/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.UIUtils;

public class CompoundUndoManager
implements UndoableEditListener {
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text");
    public static Action UNDO = new UndoAction();
    public static Action REDO = new RedoAction();
    private UndoManager undoer;
    private CompoundEdit compoundEdit = null;
    private Document document = null;
    private static Vector docs = new Vector();
    private static Vector lsts = new Vector();
    private static Vector undoers = new Vector();

    protected static void registerDocument(Document document, CompoundUndoManager compoundUndoManager, UndoManager undoManager) {
        docs.add(document);
        lsts.add(compoundUndoManager);
        undoers.add(undoManager);
    }

    public static UndoManager getUndoManagerForDocument(Document document) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != document) continue;
            return (UndoManager)undoers.elementAt(i);
        }
        return null;
    }

    public static void beginCompoundEdit(Document document) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != document) continue;
            CompoundUndoManager compoundUndoManager = (CompoundUndoManager)lsts.elementAt(i);
            compoundUndoManager.beginCompoundEdit();
            return;
        }
    }

    public static void endCompoundEdit(Document document) {
        for (int i = 0; i < docs.size(); ++i) {
            if (docs.elementAt(i) != document) continue;
            CompoundUndoManager compoundUndoManager = (CompoundUndoManager)lsts.elementAt(i);
            compoundUndoManager.endCompoundEdit();
            return;
        }
    }

    public static void updateUndo(Document document) {
        UndoManager undoManager = CompoundUndoManager.getUndoManagerForDocument(document);
        if (undoManager != null) {
            UNDO.setEnabled(undoManager.canUndo());
            REDO.setEnabled(undoManager.canRedo());
        }
    }

    public static void discardAllEdits(Document document) {
        UndoManager undoManager = CompoundUndoManager.getUndoManagerForDocument(document);
        if (undoManager != null) {
            undoManager.discardAllEdits();
            UNDO.setEnabled(undoManager.canUndo());
            REDO.setEnabled(undoManager.canRedo());
        }
    }

    public CompoundUndoManager(Document document, UndoManager undoManager) {
        this.undoer = undoManager;
        this.document = document;
        CompoundUndoManager.registerDocument(this.document, this, this.undoer);
    }

    public CompoundUndoManager(Document document) {
        this(document, new UndoManager());
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        if (this.compoundEdit != null) {
            this.compoundEdit.addEdit(undoableEdit);
        } else {
            this.undoer.addEdit(undoableEdit);
            CompoundUndoManager.updateUndo(this.document);
        }
    }

    protected void beginCompoundEdit() {
        this.compoundEdit = new CompoundEdit();
    }

    protected void endCompoundEdit() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoer.addEdit(this.compoundEdit);
            CompoundUndoManager.updateUndo(this.document);
        }
        this.compoundEdit = null;
    }

    static class RedoAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public RedoAction() {
            super(i18n.str("redo"));
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "redo.png"));
            this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "redo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("redo")));
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Document document = this.getTextComponent(actionEvent).getDocument();
            UndoManager undoManager = CompoundUndoManager.getUndoManagerForDocument(document);
            if (undoManager != null) {
                try {
                    undoManager.redo();
                }
                catch (CannotUndoException cannotUndoException) {
                    System.out.println("Unable to redo: " + cannotUndoException);
                    cannotUndoException.printStackTrace();
                }
                CompoundUndoManager.updateUndo(document);
            }
        }
    }

    static class UndoAction
    extends TextAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            super(i18n.str("undo"));
            this.putValue("SmallIcon", UIUtils.getIcon("resources/images/x16/", "undo.png"));
            this.putValue("LARGE_ICON", UIUtils.getIcon("resources/images/x24/", "undo.png"));
            this.putValue("MnemonicKey", new Integer(i18n.mnem("undo")));
            this.setEnabled(false);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Document document = this.getTextComponent(actionEvent).getDocument();
            UndoManager undoManager = CompoundUndoManager.getUndoManagerForDocument(document);
            if (undoManager != null) {
                try {
                    undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    System.out.println("Unable to undo: " + cannotUndoException);
                    cannotUndoException.printStackTrace();
                }
                CompoundUndoManager.updateUndo(document);
            }
        }
    }
}

