/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class IndentationFilter
extends DocumentFilter {
    private boolean isSoftTabs;
    private boolean isAutoIndent;

    public IndentationFilter() {
        this(false, true);
    }

    public IndentationFilter(boolean bl, boolean bl2) {
        this.isSoftTabs = bl;
        this.isAutoIndent = bl2;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        Document document = filterBypass.getDocument();
        if (string != null && n2 == 0) {
            if (this.isSoftTabs) {
                string = this.convertTabsToSpaces(string, document);
            }
            if (this.isAutoIndent && string.startsWith("\n")) {
                string = string + this.getLineIndentation(n, document);
            }
        }
        super.replace(filterBypass, n, n2, string, attributeSet);
    }

    private String convertTabsToSpaces(String string, Document document) {
        try {
            AbstractDocument abstractDocument = (AbstractDocument)document;
            int n = (Integer)abstractDocument.getProperty("tabSize");
            String string2 = "";
            for (int i = 1; i <= n; ++i) {
                string2 = string2 + ' ';
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n2 = 0;
            while ((n2 = stringBuffer.indexOf("\t", n2)) != -1) {
                stringBuffer.replace(n2, n2 + 1, string2);
                n2 += string2.length();
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    private String getLineIndentation(int n, Document document) throws BadLocationException {
        StringBuffer stringBuffer = new StringBuffer();
        if (document instanceof AbstractDocument) {
            char c;
            AbstractDocument abstractDocument = (AbstractDocument)document;
            int n2 = abstractDocument.getParagraphElement(n).getStartOffset();
            String string = abstractDocument.getText(n2, n - n2);
            for (int i = 0; i < string.length() && (c = string.charAt(i)) != '\n' && Character.isWhitespace(c); ++i) {
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isAutoIndent() {
        return this.isAutoIndent;
    }

    public void setAutoIndent(boolean bl) {
        this.isAutoIndent = bl;
    }

    public boolean isSoftTabs() {
        return this.isSoftTabs;
    }

    public void setSoftTabs(boolean bl) {
        this.isSoftTabs = bl;
    }
}

