/*
 * Decompiled with CFR 0.152.
 */
package net.atlanticbb.tantlinger.ui.text.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.atlanticbb.tantlinger.i18n.I18n;
import net.atlanticbb.tantlinger.ui.OptionDialog;
import net.atlanticbb.tantlinger.ui.UIUtils;
import net.atlanticbb.tantlinger.ui.text.dialogs.CellAttributesPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.RowAttributesPanel;
import net.atlanticbb.tantlinger.ui.text.dialogs.TableAttributesPanel;

public class TablePropertiesDialog
extends OptionDialog {
    private static final long serialVersionUID = 1L;
    private static final I18n i18n = I18n.getInstance("net.atlanticbb.tantlinger.ui.text.dialogs");
    private static Icon icon = UIUtils.getIcon("resources/images/x32/", "table.png");
    private static String title = i18n.str("table_properties");
    private static String desc = i18n.str("table_properties_desc");
    private TableAttributesPanel tableProps = new TableAttributesPanel();
    private RowAttributesPanel rowProps = new RowAttributesPanel();
    private CellAttributesPanel cellProps = new CellAttributesPanel();

    public TablePropertiesDialog(Frame frame) {
        super(frame, title, desc, icon);
        this.init();
    }

    public TablePropertiesDialog(Dialog dialog) {
        super(dialog, title, desc, icon);
        this.init();
    }

    private void init() {
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(i18n.str("table_properties"));
        this.tableProps.setBorder(BorderFactory.createCompoundBorder(emptyBorder, titledBorder));
        this.rowProps.setBorder(emptyBorder);
        this.cellProps.setBorder(emptyBorder);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)this.tableProps, i18n.str("table"));
        jTabbedPane.add((Component)this.rowProps, i18n.str("row"));
        jTabbedPane.add((Component)this.cellProps, i18n.str("cell"));
        this.setContentPane(jTabbedPane);
        this.setSize(440, 375);
        this.setResizable(false);
    }

    public void setTableAttributes(Map map) {
        this.tableProps.setAttributes(map);
    }

    public void setRowAttributes(Map map) {
        this.rowProps.setAttributes(map);
    }

    public void setCellAttributes(Map map) {
        this.cellProps.setAttributes(map);
    }

    public Map getTableAttributes() {
        return this.tableProps.getAttributes();
    }

    public Map getRowAttribures() {
        return this.rowProps.getAttributes();
    }

    public Map getCellAttributes() {
        return this.cellProps.getAttributes();
    }
}

