/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeGastronomieHotel;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.VermarktungsartGewerbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GewerbeGastronomieHotel
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(GewerbeGastronomieHotel.class);
    protected static final int FIELD_VERMARKTUNGSART = 60;
    protected static final int FIELD_OBJEKTKATEGORIE = 61;
    protected static final int FIELD_GEWERBEFLAECHE = 62;
    protected static final int FIELD_NEBENFLAECHE = 63;
    protected static final int FIELD_GESAMTFLAECHE = 64;
    protected static final int FIELD_ANZAHL_PARKFLAECHEN = 65;
    protected static final int FIELD_ETAGEN = 66;
    protected static final int FIELD_BAUJAHR = 67;
    protected static final int FIELD_OBJEKTZUSTAND = 68;
    protected static final int FIELD_PERSONENAUFZUG = 69;
    protected static final int FIELD_ANZAHL_GASTRAUMPLAETZE = 70;
    protected static final int FIELD_ANZAHL_BETTEN = 71;
    protected static final int FIELD_GASTTERRASSE = 72;
    protected static final int FIELD_FUSSWEG_NAHVERKEHR = 73;
    protected static final int FIELD_FAHRTWEG_HAUPTBAHNHOF = 74;
    protected static final int FIELD_FAHRTWEG_AUTOBAHN = 75;
    protected static final int FIELD_FAHRTWEG_FLUGHAFEN = 76;
    protected static final int FIELD_VERFUEGBAR_AB = 77;
    protected static final int FIELD_SANIERUNGSJAHR = 80;
    protected static final int FIELD_AUSSTATTUNG = 81;
    protected static final int FIELD_BEFEUERUNG = 83;
    protected static final int FIELD_ENERGIEAUSWEIS_TYP = 84;
    protected static final int FIELD_ENERGIEAUSWEIS_KENNWERT = 85;
    protected static final int FIELD_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    protected static final int FIELD_HEIZUNGSART = 87;
    protected static final int FIELD_DENKMALSCHUTZ = 88;
    protected static final int FIELD_KELLER = 89;
    protected static final int FIELD_PREIS = 90;
    protected static final int FIELD_NEBENKOSTEN = 91;
    protected static final int FIELD_PREIS_PRO_PARKFLAECHE = 92;
    protected static final int FIELD_KAUTION = 93;

    public GewerbeGastronomieHotel() {
        this.setImmobilienart(Immobilienart.GEWERBE_GASTRONOMIE_HOTEL);
    }

    public Integer getAnzahlBetten() {
        try {
            return Is24CsvFormat.parseInteger(this.get(71));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Betten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getAnzahlGastraumplaetze() {
        try {
            return Is24CsvFormat.parseInteger(this.get(70));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Gastraumplaetze'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getAnzahlParkflaechen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(65));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Parkflaechen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Ausstattung getAusstattung() {
        return Ausstattung.parse(this.get(81));
    }

    public Integer getBaujahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(67));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Baujahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Befeuerungsart[] getBefeuerungsart() {
        return Befeuerungsart.parseMultiple(this.get(83));
    }

    public Boolean getDenkmalschutz() {
        return Is24CsvFormat.parseBoolean(this.get(88));
    }

    public Boolean getEnergieausweisInklWarmwasser() {
        return Is24CsvFormat.parseBoolean(this.get(86));
    }

    public BigDecimal getEnergieausweisKennwert() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(85));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Energieausweis-Kennwert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public EnergieausweisTyp getEnergieausweisTyp() {
        return EnergieausweisTyp.parse(this.get(84));
    }

    public String getEtagen() {
        return this.get(66);
    }

    public Integer getFahrtwegAutobahn() {
        try {
            return Is24CsvFormat.parseInteger(this.get(75));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zur Autobahn'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegFlughafen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(76));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Flughafen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFahrtwegHauptbahnhof() {
        try {
            return Is24CsvFormat.parseInteger(this.get(74));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fahrtweg zum Hauptbahnhof'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getFusswegNahverkehr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(73));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Fussweg zum Nahverkehr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getGastterrasse() {
        return Is24CsvFormat.parseBoolean(this.get(72));
    }

    public BigDecimal getGesamtflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gesamtflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getGewerbeflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Gewerbeflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Heizungsart getHeizungsart() {
        return Heizungsart.parse(this.get(87));
    }

    public String getKaution() {
        return this.get(93);
    }

    public Boolean getKeller() {
        return Is24CsvFormat.parseBoolean(this.get(89));
    }

    public BigDecimal getNebenflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getNebenkosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(91));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenkosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieGewerbeGastronomieHotel getObjektkategorie() {
        return ObjektkategorieGewerbeGastronomieHotel.parse(this.get(61));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(68));
    }

    public Boolean getPersonenaufzug() {
        return Is24CsvFormat.parseBoolean(this.get(69));
    }

    public BigDecimal getPreis() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Preis'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getPreisProParkflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(92));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Preis pro Parkflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getSanierungsjahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(80));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Sanierungsjahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getVerfuegbarAb() {
        return this.get(77);
    }

    public VermarktungsartGewerbe getVermarktungsart() {
        return VermarktungsartGewerbe.parse(this.get(60));
    }

    public static GewerbeGastronomieHotel newRecord(CSVRecord cSVRecord) {
        GewerbeGastronomieHotel gewerbeGastronomieHotel = new GewerbeGastronomieHotel();
        gewerbeGastronomieHotel.parse(cSVRecord);
        return gewerbeGastronomieHotel;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.GEWERBE_GASTRONOMIE_HOTEL);
        return super.print();
    }

    public void setAnzahlBetten(Number number) {
        this.set(71, Is24CsvFormat.printNumber(number, 5));
    }

    public void setAnzahlGastraumplaetze(Number number) {
        this.set(70, Is24CsvFormat.printNumber(number, 5));
    }

    public void setAnzahlParkflaechen(Number number) {
        this.set(65, Is24CsvFormat.printNumber(number, 5));
    }

    public void setAusstattung(Ausstattung ausstattung) {
        this.set(81, ausstattung != null ? ausstattung.print() : null);
    }

    public void setBaujahr(Number number) {
        this.set(67, Is24CsvFormat.printNumber(number, 4));
    }

    public void setBefeuerungsart(Befeuerungsart befeuerungsart) {
        this.set(83, befeuerungsart != null ? befeuerungsart.print() : null);
    }

    public void setBefeuerungsart(Iterable<Befeuerungsart> iterable) {
        this.set(83, Befeuerungsart.printMultiple(iterable));
    }

    public void setDenkmalschutz(Boolean bl) {
        this.set(88, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisInklWarmwasser(Boolean bl) {
        this.set(86, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisKennwert(Number number) {
        this.set(85, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setEnergieausweisTyp(EnergieausweisTyp energieausweisTyp) {
        this.set(84, energieausweisTyp != null ? energieausweisTyp.print() : null);
    }

    public void setEtagen(String string) {
        this.set(66, Is24CsvFormat.printString(string, 50));
    }

    public void setFahrtwegAutobahn(Number number) {
        this.set(75, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegFlughafen(Number number) {
        this.set(76, Is24CsvFormat.printNumber(number, 3));
    }

    public void setFahrtwegHauptbahnhof(Number number) {
        this.set(74, Is24CsvFormat.printNumber(number, 2));
    }

    public void setFusswegNahverkehr(Number number) {
        this.set(73, Is24CsvFormat.printNumber(number, 2));
    }

    public void setGastterrasse(Boolean bl) {
        this.set(72, Is24CsvFormat.printBoolean(bl));
    }

    public void setGesamtflaeche(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setGewerbeflaeche(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setHeizungsart(Heizungsart heizungsart) {
        this.set(87, heizungsart != null ? heizungsart.print() : null);
    }

    public void setKaution(String string) {
        this.set(93, Is24CsvFormat.printString(string, 50));
    }

    public void setKeller(Boolean bl) {
        this.set(89, Is24CsvFormat.printBoolean(bl));
    }

    public void setNebenflaeche(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setNebenkosten(Number number) {
        this.set(91, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setObjektkategorie(ObjektkategorieGewerbeGastronomieHotel objektkategorieGewerbeGastronomieHotel) {
        this.set(61, objektkategorieGewerbeGastronomieHotel != null ? objektkategorieGewerbeGastronomieHotel.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(68, objektzustand != null ? objektzustand.print() : null);
    }

    public void setPersonenaufzug(Boolean bl) {
        this.set(69, Is24CsvFormat.printBoolean(bl));
    }

    public void setPreis(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setPreisProParkflaeche(Number number) {
        this.set(92, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setSanierungsjahr(Number number) {
        this.set(80, Is24CsvFormat.printNumber(number, 4));
    }

    public void setVerfuegbarAb(String string) {
        this.set(77, Is24CsvFormat.printString(string, 50));
    }

    public void setVermarktungsart(VermarktungsartGewerbe vermarktungsartGewerbe) {
        this.set(60, vermarktungsartGewerbe != null ? vermarktungsartGewerbe.print() : null);
    }
}

