/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Auswahl;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieHaus;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.Stellplatz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HausMiete
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(HausMiete.class);
    protected static final int FIELD_OBJEKTKATEGORIE = 60;
    protected static final int FIELD_WOHNFLAECHE = 61;
    protected static final int FIELD_NUTZFLAECHE = 62;
    protected static final int FIELD_ZIMMER = 63;
    protected static final int FIELD_ANZAHL_BADEZIMMER = 64;
    protected static final int FIELD_GRUNDSTUECKSFLAECHE = 65;
    protected static final int FIELD_ETAGENZAHL = 66;
    protected static final int FIELD_BAUJAHR = 67;
    protected static final int FIELD_OBJEKTZUSTAND = 68;
    protected static final int FIELD_HEIZUNGSART = 69;
    protected static final int FIELD_HAUSTIERE = 70;
    protected static final int FIELD_EINBAUKUECHE = 71;
    protected static final int FIELD_SENIORENGERECHT = 72;
    protected static final int FIELD_ANZAHL_GARAGE_STELLPLATZ = 73;
    protected static final int FIELD_STELLPLATZ = 74;
    protected static final int FIELD_VERFUEGBAR_AB = 75;
    protected static final int FIELD_ROLLSTUHLGERECHT = 76;
    protected static final int FIELD_ANZAHL_SCHLAFZIMMER = 77;
    protected static final int FIELD_BEFEUERUNG = 78;
    protected static final int FIELD_ENERGIEAUSWEIS_TYP = 79;
    protected static final int FIELD_ENERGIEAUSWEIS_KENNWERT = 80;
    protected static final int FIELD_ENERGIEAUSWEIS_INKL_WARMWASSER = 81;
    protected static final int FIELD_GAESTE_WC = 82;
    protected static final int FIELD_AUSSTATTUNG = 83;
    protected static final int FIELD_KELLER = 85;
    protected static final int FIELD_BARRIEREFREI = 86;
    protected static final int FIELD_SANIERUNGSJAHR = 88;
    protected static final int FIELD_KALTMIETE = 90;
    protected static final int FIELD_NEBENKOSTEN = 91;
    protected static final int FIELD_WARMMIETE = 92;
    protected static final int FIELD_STELLPLATZMIETE = 93;
    protected static final int FIELD_KAUTION = 94;
    protected static final int FIELD_HEIZKOSTEN = 96;
    protected static final int FIELD_NEBENKOSTEN_INKL_HEIZKOSTEN = 97;

    public HausMiete() {
        this.setImmobilienart(Immobilienart.HAUS_MIETE);
    }

    public Integer getAnzahlBadezimmer() {
        try {
            return Is24CsvFormat.parseInteger(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Badezimmer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getAnzahlGarageStellplatz() {
        try {
            return Is24CsvFormat.parseInteger(this.get(73));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Garage / Stellplatz'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getAnzahlSchlafzimmer() {
        try {
            return Is24CsvFormat.parseInteger(this.get(77));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Schlafzimmer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Ausstattung getAusstattung() {
        return Ausstattung.parse(this.get(83));
    }

    public Boolean getBarrierefrei() {
        return Is24CsvFormat.parseBoolean(this.get(86));
    }

    public Integer getBaujahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(67));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Baujahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Befeuerungsart[] getBefeuerungsart() {
        return Befeuerungsart.parseMultiple(this.get(78));
    }

    public Boolean getEinbaukueche() {
        return Is24CsvFormat.parseBoolean(this.get(71));
    }

    public Boolean getEnergieausweisInklWarmwasser() {
        return Is24CsvFormat.parseBoolean(this.get(81));
    }

    public BigDecimal getEnergieausweisKennwert() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(80));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Energieausweis-Kennwert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public EnergieausweisTyp getEnergieausweisTyp() {
        return EnergieausweisTyp.parse(this.get(79));
    }

    public Integer getEtagenzahl() {
        try {
            return Is24CsvFormat.parseInteger(this.get(66));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Etagenzahl'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getGaesteWc() {
        return Is24CsvFormat.parseBoolean(this.get(82));
    }

    public BigDecimal getGrundstuecksflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(65));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Grundstuecksflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Auswahl getHaustiere() {
        return Auswahl.parse(this.get(70));
    }

    public BigDecimal getHeizkosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(96));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Heizkosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Heizungsart getHeizungsart() {
        return Heizungsart.parse(this.get(69));
    }

    public BigDecimal getKaltmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaltmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getKaution() {
        return this.get(94);
    }

    public Boolean getKeller() {
        return Is24CsvFormat.parseBoolean(this.get(85));
    }

    public BigDecimal getNebenkosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(91));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenkosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getNebenkostenInklHeizkosten() {
        return Is24CsvFormat.parseBoolean(this.get(97));
    }

    public BigDecimal getNutzflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nutzflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieHaus getObjektkategorie() {
        return ObjektkategorieHaus.parse(this.get(60));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(68));
    }

    @Deprecated
    public Boolean getRollstuhlgerecht() {
        return Is24CsvFormat.parseBoolean(this.get(76));
    }

    public Integer getSanierungsjahr() {
        try {
            return Is24CsvFormat.parseInteger(this.get(88));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Sanierungsjahr'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getSeniorengerecht() {
        return Is24CsvFormat.parseBoolean(this.get(72));
    }

    public Stellplatz getStellplatz() {
        return Stellplatz.parse(this.get(74));
    }

    public BigDecimal getStellplatzmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(93));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Stellplatzmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getVerfuegbarAb() {
        return this.get(75);
    }

    public BigDecimal getWarmmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(92));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Warmmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getWohnflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(61));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Wohnflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getZimmer() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(63));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Zimmer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public static HausMiete newRecord(CSVRecord cSVRecord) {
        HausMiete hausMiete = new HausMiete();
        hausMiete.parse(cSVRecord);
        return hausMiete;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.HAUS_MIETE);
        return super.print();
    }

    public void setAnzahlBadezimmer(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 2));
    }

    public void setAnzahlGarageStellplatz(Number number) {
        this.set(73, Is24CsvFormat.printNumber(number, 2));
    }

    public void setAnzahlSchlafzimmer(Number number) {
        this.set(77, Is24CsvFormat.printNumber(number, 2));
    }

    public void setAusstattung(Ausstattung ausstattung) {
        this.set(83, ausstattung != null ? ausstattung.print() : null);
    }

    public void setBarrierefrei(Boolean bl) {
        this.set(86, Is24CsvFormat.printBoolean(bl));
    }

    public void setBaujahr(Number number) {
        this.set(67, Is24CsvFormat.printNumber(number, 4));
    }

    public void setBefeuerungsart(Befeuerungsart befeuerungsart) {
        this.set(78, befeuerungsart != null ? befeuerungsart.print() : null);
    }

    public void setBefeuerungsart(Iterable<Befeuerungsart> iterable) {
        this.set(78, Befeuerungsart.printMultiple(iterable));
    }

    public void setEinbaukueche(Boolean bl) {
        this.set(71, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisInklWarmwasser(Boolean bl) {
        this.set(81, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisKennwert(Number number) {
        this.set(80, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setEnergieausweisTyp(EnergieausweisTyp energieausweisTyp) {
        this.set(79, energieausweisTyp != null ? energieausweisTyp.print() : null);
    }

    public void setEtagenzahl(Number number) {
        this.set(66, Is24CsvFormat.printNumber(number, 3));
    }

    public void setGaesteWc(Boolean bl) {
        this.set(82, Is24CsvFormat.printBoolean(bl));
    }

    public void setGrundstuecksflaeche(Number number) {
        this.set(65, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setHaustiere(Auswahl auswahl) {
        this.set(70, auswahl != null ? auswahl.print() : null);
    }

    public void setHeizkosten(Number number) {
        this.set(96, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setHeizungsart(Heizungsart heizungsart) {
        this.set(69, heizungsart != null ? heizungsart.print() : null);
    }

    public void setKaution(String string) {
        this.set(94, Is24CsvFormat.printString(string, 50));
    }

    public void setKaltmiete(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setKeller(Boolean bl) {
        this.set(85, Is24CsvFormat.printBoolean(bl));
    }

    public void setNebenkosten(Number number) {
        this.set(91, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setNebenkostenInklHeizkosten(Boolean bl) {
        this.set(97, Is24CsvFormat.printBoolean(bl));
    }

    public void setNutzflaeche(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setObjektkategorie(ObjektkategorieHaus objektkategorieHaus) {
        this.set(60, objektkategorieHaus != null ? objektkategorieHaus.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(68, objektzustand != null ? objektzustand.print() : null);
    }

    @Deprecated
    public void setRollstuhlgerecht(Boolean bl) {
        this.set(76, Is24CsvFormat.printBoolean(bl));
    }

    public void setSanierungsjahr(Number number) {
        this.set(88, Is24CsvFormat.printNumber(number, 4));
    }

    public void setSeniorengerecht(Boolean bl) {
        this.set(72, Is24CsvFormat.printBoolean(bl));
    }

    public void setStellplatz(Stellplatz stellplatz) {
        this.set(74, stellplatz != null ? stellplatz.print() : null);
    }

    public void setStellplatzmiete(Number number) {
        this.set(93, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setVerfuegbarAb(String string) {
        this.set(75, Is24CsvFormat.printString(string, 50));
    }

    public void setWarmmiete(Number number) {
        this.set(92, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setWohnflaeche(Number number) {
        this.set(61, Is24CsvFormat.printNumber(number, 10, 2));
    }

    public void setZimmer(Number number) {
        this.set(63, Is24CsvFormat.printNumber(number, 6, 2));
    }
}

