/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.types;

import org.openestate.io.is24_csv.types.DateiSuffix;
import org.openestate.io.is24_csv.types.DateiTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Datei {
    private static final Logger LOGGER = LoggerFactory.getLogger(Datei.class);
    private String name;
    private String text;
    private DateiSuffix suffix;
    private DateiTyp typ;
    private int abspieldauer;

    public Datei(String string, DateiTyp dateiTyp, DateiSuffix dateiSuffix) {
        this(string, dateiTyp, dateiSuffix, null, 0);
    }

    public Datei(String string, DateiTyp dateiTyp, DateiSuffix dateiSuffix, String string2) {
        this(string, dateiTyp, dateiSuffix, string2, 0);
    }

    public Datei(String string, DateiTyp dateiTyp, DateiSuffix dateiSuffix, String string2, int n) {
        this.name = string;
        this.suffix = dateiSuffix;
        this.typ = dateiTyp;
        this.text = string2;
        this.abspieldauer = n;
    }

    public int getAbspieldauer() {
        return this.abspieldauer;
    }

    public String getName() {
        return this.name;
    }

    public DateiSuffix getSuffix() {
        return this.suffix;
    }

    public String getText() {
        return this.text;
    }

    public DateiTyp getTyp() {
        return this.typ;
    }

    public String guessMimeType() {
        DateiSuffix dateiSuffix = this.suffix;
        if (dateiSuffix == null) {
            dateiSuffix = DateiSuffix.fromFileName(this.name);
        }
        return dateiSuffix != null ? dateiSuffix.getMimeType() : "application/octet-stream";
    }

    public void setAbspieldauer(int n) {
        this.abspieldauer = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setSuffix(DateiSuffix dateiSuffix) {
        this.suffix = dateiSuffix;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setTyp(DateiTyp dateiTyp) {
        this.typ = dateiTyp;
    }
}

