/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.wis_it;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CubatureVolume;
import com.openindex.openestate.impl.attribs.measures.GrossArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.prices.Conventioned;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.wis_it.WisItDocument;
import org.openestate.io.wis_it.WisItUtils;
import org.openestate.io.wis_it.xml.AreaType;
import org.openestate.io.wis_it.xml.EnergyEfficencyClass;
import org.openestate.io.wis_it.xml.HeatingType;
import org.openestate.io.wis_it.xml.MarketingType;
import org.openestate.io.wis_it.xml.ObjectFactory;
import org.openestate.io.wis_it.xml.ObjectType;
import org.openestate.io.wis_it.xml.PropertyType;
import org.openestate.io.wis_it.xml.WIS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WisItWriter
extends AbstractXmlWriter<WisItDocument, WIS> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisItWriter.class);
    private static final ObjectFactory FACTORY = WisItUtils.getFactory();
    public static final int MAX_IMAGES_PER_OBJECT = 10;
    public static final int MAX_DOCUMENTS_PER_OBJECT = 3;
    private boolean energyCertificateAppendedToDescription = false;

    public WisItWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public WisItWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected WIS.BENUTZER convertAgent(AgentImpl agentImpl) {
        WIS.BENUTZER bENUTZER = FACTORY.createWISBENUTZER();
        bENUTZER.setKDNR(agentImpl.getId());
        return bENUTZER;
    }

    /*
     * WARNING - void declaration
     */
    protected ObjectType convertEstate(EstateImpl estateImpl, List<String> list) {
        String string;
        String string2;
        String string3;
        ComplexStringAttrib complexStringAttrib;
        OpenEstateAttrib[] openEstateAttribArray;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Comparable<Boolean> comparable;
        Object object5;
        ObjectType objectType = FACTORY.createObjectType();
        Calendar calendar = Calendar.getInstance();
        if (estateImpl.getPublishBegin() != null) {
            calendar.setTime(estateImpl.getPublishBegin());
        } else {
            calendar.add(2, 6);
        }
        objectType.setGUELTIGBIS(calendar);
        List<OpenEstateType> list2 = Arrays.asList(estateImpl.getType().getParentPath());
        try {
            object5 = null;
            if (list2.contains(OpenEstateType.FARM)) {
                object5 = PropertyType.BAUERNHOF;
            } else if (list2.contains(OpenEstateType.OFFICE_SURGERY)) {
                object5 = PropertyType.BUERO;
            } else if (list2.contains(OpenEstateType.HOSPITALITY_INDUSTRY)) {
                object5 = PropertyType.GASTGEWERBEOBJEKT;
            } else if (list2.contains(OpenEstateType.RETAIL)) {
                object5 = PropertyType.GESCHAEFT;
            } else if (list2.contains(OpenEstateType.DEPARTMENT_STORE) || list2.contains(OpenEstateType.HALL_WAREHOUSE) || list2.contains(OpenEstateType.SELF_SERVICE_MARKET) || list2.contains(OpenEstateType.SHOWROOM) || list2.contains(OpenEstateType.SALES_AREA) || list2.contains(OpenEstateType.CONSUMER_STORE)) {
                object5 = PropertyType.GEWERBEHALLE;
            } else if (list2.contains(OpenEstateType.TERRACED_HOUSE)) {
                object5 = PropertyType.REIHENHAUS;
            } else if (list2.contains(OpenEstateType.HOUSE)) {
                object5 = PropertyType.EINFAMILIENHAUS;
            } else if (list2.contains(OpenEstateType.RESIDENCE)) {
                object5 = PropertyType.WOHNUNG;
            } else if (list2.contains(OpenEstateType.AGRICULTURAL_FORESTRY_GROUND)) {
                object5 = PropertyType.KULTURGRUND;
            } else if (list2.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
                object5 = PropertyType.GESCHAEFT;
            } else if (list2.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                object5 = PropertyType.BAUGRUND;
            } else if (list2.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
                object5 = PropertyType.KULTURGRUND;
            } else if (list2.contains(OpenEstateType.GENERAL_PARKING)) {
                object5 = PropertyType.GARAGE;
            } else if (list2.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                object5 = PropertyType.WOHNUNG;
            }
            if (object5 == null) {
                list.add("Can't find a matching estate-type for: " + estateImpl.getType());
                return null;
            }
            objectType.setIMMOBILIENART((PropertyType)object5);
        }
        catch (Exception exception) {
            list.add("Can't set estate-type: " + exception.getLocalizedMessage());
            return null;
        }
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            objectType.setMIETEKAUF(MarketingType.KAUF);
            object5 = PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl);
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            objectType.setMIETEKAUF(MarketingType.MIETE);
            object5 = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            if (object5 == null || ((BigDecimal)object5).longValue() < 1L) {
                object5 = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            }
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            objectType.setMIETEKAUF(MarketingType.MIETE);
            object5 = Lease.getAsBigDecimal((EstateImpl)estateImpl);
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            objectType.setMIETEKAUF(MarketingType.MIETE);
            object5 = Lease.getAsBigDecimal((EstateImpl)estateImpl);
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            objectType.setMIETEKAUF(MarketingType.MIETE);
            object5 = RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl);
        } else {
            list.add("Can't find a matching estate-action for: " + estateImpl.getAction());
            return null;
        }
        if (estateImpl.isHiddenPrices()) {
            objectType.setPREIS(BigDecimal.ZERO);
            objectType.setAUFANFRAGE(Boolean.valueOf(true));
        } else {
            if (object5 == null || ((BigDecimal)object5).longValue() < 1L) {
                list.add("Can't find a valid price: " + object5);
                return null;
            }
            objectType.setPREIS((BigDecimal)object5);
            objectType.setAUFANFRAGE(Boolean.valueOf(false));
        }
        AreaType areaType = AreaType.NETTO;
        BigDecimal bigDecimal = GrossArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            areaType = AreaType.BRUTTO;
        } else {
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = SalesArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                bigDecimal = CarParkingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
            }
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = BigDecimal.ZERO;
        }
        objectType.setNUTZFLAECHE(bigDecimal);
        objectType.setFLAECHEART(areaType);
        Conventioned.Option option = Conventioned.get((EstateImpl)estateImpl);
        if (Conventioned.Option.YES.equals((Object)option)) {
            objectType.setKONVENTIONIERT(Boolean.valueOf(true));
        } else if (Conventioned.Option.EITHER_OR.equals((Object)option)) {
            objectType.setKONVENTIONIERT(Boolean.valueOf(false));
        } else if (Conventioned.Option.NO.equals((Object)option)) {
            objectType.setKONVENTIONIERT(Boolean.valueOf(false));
        }
        objectType.setKUBATUR(CubatureVolume.getAsBigDecimal((EstateImpl)estateImpl, (VolumeValue.Unit)VolumeValue.Unit.CUM));
        ConditionType.Option option2 = ConditionType.get((EstateImpl)estateImpl);
        if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.MODERNIZED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.NEU);
        } else if (ConditionType.Option.DILAPIDATED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.WELL_TENDED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.PARTIALLY_RENOVATED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.PARTIALLY_REFURBISHED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.PARTIAL_REFURBISHMENT_REQUIRED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        } else if (ConditionType.Option.COMPLETE_REFURBISHMENT_REQUIRED.equals((Object)option2)) {
            objectType.setZUSTAND(org.openestate.io.wis_it.xml.ConditionType.GEBRAUCHT);
        }
        objectType.setZIMMER(CountRooms.getAsBigInteger((EstateImpl)estateImpl));
        objectType.setSTOCKWERKE(CountFloors.getAsBigInteger((EstateImpl)estateImpl));
        String string4 = Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        if (!StringUtils.isBlank((CharSequence)string4)) {
            if ("eg".equalsIgnoreCase(string4)) {
                comparable = BigInteger.ZERO;
            } else {
                object4 = NumberFormat.getNumberInstance(Locale.ENGLISH);
                ((NumberFormat)object4).setParseIntegerOnly(true);
                ((NumberFormat)object4).setGroupingUsed(false);
                serializable = OpenEstateUtils.parseNumber((String)string4, (NumberFormat)object4);
                comparable = serializable instanceof BigDecimal ? ((BigDecimal)serializable).toBigInteger() : (serializable instanceof BigInteger ? (BigInteger)serializable : (serializable != null ? BigInteger.valueOf(serializable.longValue()) : null));
            }
            if (comparable != null && ((BigInteger)comparable).compareTo(BigInteger.ZERO) > -1) {
                objectType.setSTOCKWERK(((BigInteger)comparable).add(BigInteger.ONE));
            }
        }
        if (!Boolean.TRUE.equals(comparable = Lift.get((EstateImpl)estateImpl))) {
            comparable = FreightElevator.get((EstateImpl)estateImpl);
        }
        if (Boolean.TRUE.equals(comparable)) {
            objectType.setAUFZUG(Boolean.valueOf(true));
        } else if (Boolean.FALSE.equals(comparable)) {
            objectType.setAUFZUG(Boolean.valueOf(false));
        }
        object4 = CarParkingType.getAsList((EstateImpl)estateImpl);
        if (object4.contains(CarParkingType.Option.GARAGE)) {
            objectType.setGARAGE(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
            objectType.setGARAGE(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.CARPORT)) {
            objectType.setGARAGE(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.DOUBLE_GARAGE)) {
            objectType.setGARAGE(Boolean.valueOf(true));
        }
        if (object4.contains(CarParkingType.Option.OUTDOOR)) {
            objectType.setABSTELLPLATZ(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
            objectType.setABSTELLPLATZ(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
            objectType.setABSTELLPLATZ(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.GARAGE)) {
            objectType.setABSTELLPLATZ(Boolean.valueOf(true));
        } else if (object4.contains(CarParkingType.Option.COMMUNAL)) {
            objectType.setABSTELLPLATZ(Boolean.valueOf(true));
        }
        serializable = GardenUse.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(serializable)) {
            objectType.setGRUENFLAECHE(Boolean.valueOf(true));
        } else if (Boolean.FALSE.equals(serializable)) {
            objectType.setGRUENFLAECHE(Boolean.valueOf(false));
        }
        Boolean bl = Basement.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            objectType.setKELLER(Boolean.valueOf(true));
        } else if (Boolean.FALSE.equals(bl)) {
            objectType.setKELLER(Boolean.valueOf(false));
        } else {
            object3 = UndergroundLevel.get((EstateImpl)estateImpl);
            if (UndergroundLevel.Option.YES.equals(object3)) {
                objectType.setKELLER(Boolean.valueOf(true));
            } else if (UndergroundLevel.Option.PARTIALLY.equals(object3)) {
                objectType.setKELLER(Boolean.valueOf(true));
            } else if (UndergroundLevel.Option.NO.equals(object3)) {
                objectType.setKELLER(Boolean.valueOf(false));
            }
        }
        object3 = BalconyTerrace.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(object3)) {
            objectType.setBALKON(Boolean.valueOf(true));
            objectType.setTERRASSE(Boolean.valueOf(true));
        } else if (Boolean.FALSE.equals(object3)) {
            objectType.setBALKON(Boolean.valueOf(false));
            objectType.setTERRASSE(Boolean.valueOf(false));
        }
        List list3 = ResidentialRooms.getAsList((EstateImpl)estateImpl);
        if (list3.contains(ResidentialRooms.Option.ATTIC)) {
            objectType.setDACHBODEN(Boolean.valueOf(true));
        } else if (!list3.isEmpty()) {
            objectType.setDACHBODEN(Boolean.valueOf(false));
        }
        List list4 = TypeOfHeating.getAsList((EstateImpl)estateImpl);
        if (list4.contains(TypeOfHeating.Option.CENTRAL)) {
            objectType.setHEIZUNG(HeatingType.ZENTRAL);
        } else if (list4.contains(TypeOfHeating.Option.INDEPENDENT)) {
            objectType.setHEIZUNG(HeatingType.AUTONOM);
        }
        String string5 = AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        if (StringUtils.isBlank((CharSequence)string5)) {
            string5 = AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        }
        if (!StringUtils.isBlank((CharSequence)string5)) {
            objectType.setUEBERGABEZEITPUNKT(string5.trim());
        }
        objectType.setBAUJAHR(BuildYear.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        EfficiencyCategory.Option option3 = EfficiencyCategory.get((EstateImpl)estateImpl);
        if (option3 == null && (object2 = Type.Option.DEMAND.equals((Object)(openEstateAttribArray = Type.get((EstateImpl)estateImpl))) ? DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR) : (Type.Option.CONSUMPTION.equals((Object)openEstateAttribArray) ? ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR) : null)) != null) {
            option3 = OpenEstateUtils.getEnergyEfficiencyCategory((Number)object2, (String)estateImpl.getAddress().getCountry());
        }
        if (option3 != null) {
            switch (option3) {
                case A_PLUS: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.A_PLUS);
                    break;
                }
                case A: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.A);
                    break;
                }
                case B: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.B);
                    break;
                }
                case C: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.C);
                    break;
                }
                case D: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.D);
                    break;
                }
                case E: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.E);
                    break;
                }
                case F: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.F);
                    break;
                }
                case G: 
                case H: {
                    objectType.setENERGIEEFFIZIENZKLASSE(EnergyEfficencyClass.G);
                }
            }
        }
        openEstateAttribArray = new OpenEstateAttrib[]{OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_FEATURE_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_LOCATION_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION};
        object2 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
        for (OpenEstateAttrib object6 : openEstateAttribArray) {
            complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(object6);
            if (complexStringAttrib == null || (string3 = StringUtils.trimToNull((String)complexStringAttrib.getValue("de"))) == null) continue;
            objectType.setINFODE(OpenEstateUtils.serializeString((String)string3, (String)this.getXmlLineSeparator()));
            if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((CharSequence)(string2 = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)new Locale("de"), (String)this.getXmlLineSeparator())))) break;
            string = StringUtils.trimToNull((String)objectType.getINFODE());
            string = string == null ? string2 : string2 + (String)object2 + string;
            objectType.setINFODE(StringUtils.trimToEmpty((String)string));
            break;
        }
        for (OpenEstateAttrib openEstateAttrib : openEstateAttribArray) {
            complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexStringAttrib == null || (string3 = StringUtils.trimToNull((String)complexStringAttrib.getValue("it"))) == null) continue;
            objectType.setINFOIT(OpenEstateUtils.serializeString((String)string3, (String)this.getXmlLineSeparator()));
            if (!this.isEnergyCertificateAppendedToDescription() || StringUtils.isBlank((CharSequence)(string2 = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)new Locale("it"), (String)this.getXmlLineSeparator())))) break;
            string = StringUtils.trimToNull((String)objectType.getINFOIT());
            string = string == null ? string2 : string2 + (String)object2 + string;
            objectType.setINFOIT(StringUtils.trimToEmpty((String)string));
            break;
        }
        objectType.setID(estateImpl.getId());
        objectType.setLOESCHEN(Boolean.valueOf(false));
        objectType.setSTRASSE(estateImpl.getAddress().getStreet());
        if (estateImpl.getAddress().isPublished()) {
            objectType.setHAUSNUMMER(estateImpl.getAddress().getStreetNr());
        }
        objectType.setORT(estateImpl.getAddress().getCity());
        objectType.setFRAKTION(estateImpl.getAddress().getDistrict());
        if (estateImpl.getAddress().isPublished()) {
            objectType.setLAT(estateImpl.getAddress().getLatitude());
            objectType.setLNG(estateImpl.getAddress().getLongitude());
        }
        int n = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            void var26_38;
            if (!estateAttachmentImpl.isPublished() || !estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || !estateAttachmentImpl.getMimeType().startsWith("image/")) continue;
            Object var26_35 = null;
            if (estateAttachmentImpl.isName()) {
                String string6 = estateAttachmentImpl.getFileAsName();
            } else if (estateAttachmentImpl.isUrl()) {
                String string7 = estateAttachmentImpl.getFileAsUrl().getPath();
            }
            if (var26_38 == null || var26_38.trim().length() == 0) continue;
            String string8 = var26_38.trim();
            if (n == 0) {
                objectType.setBILD1(string8);
            } else if (n == 1) {
                objectType.setBILD2(string8);
            } else if (n == 2) {
                objectType.setBILD3(string8);
            } else if (n == 3) {
                objectType.setBILD4(string8);
            } else if (n == 4) {
                objectType.setBILD5(string8);
            } else if (n == 5) {
                objectType.setBILD6(string8);
            } else if (n == 6) {
                objectType.setBILD7(string8);
            } else if (n == 7) {
                objectType.setBILD8(string8);
            } else if (n == 8) {
                objectType.setBILD9(string8);
            } else {
                if (n != 9) break;
                objectType.setBILD10(string8);
            }
            ++n;
        }
        n = 0;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            void var26_44;
            if (!estateAttachmentImpl.isPublished() || !estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl() || estateAttachmentImpl.getMimeType().startsWith("image/")) continue;
            Object var26_41 = null;
            if (estateAttachmentImpl.isName()) {
                String string9 = estateAttachmentImpl.getFileAsName();
            } else if (estateAttachmentImpl.isUrl()) {
                String string10 = estateAttachmentImpl.getFileAsUrl().getPath();
            }
            if (var26_44 == null || var26_44.trim().length() == 0) continue;
            String string11 = var26_44.trim();
            if (n == 0) {
                objectType.setDOWNLOAD1(string11);
            } else if (n == 1) {
                objectType.setDOWNLOAD2(string11);
            } else {
                if (n != 2) break;
                objectType.setDOWNLOAD3(string11);
            }
            ++n;
        }
        return objectType;
    }

    protected WIS convertToXmlObject(AgencyImpl agencyImpl) {
        WIS wIS = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("No agency was provided!");
            wIS.getOBJEKTE().setANZAHL(BigInteger.ZERO);
            return wIS;
        }
        wIS.setBENUTZER(this.convertAgent(agencyImpl.getAgent()));
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                ObjectType objectType = this.convertEstate(estateImpl, arrayList);
                if (!arrayList.isEmpty()) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                objectType.setLOESCHEN(Boolean.valueOf(false));
                wIS.getOBJEKTE().getOBJEKT().add(objectType);
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        wIS.getOBJEKTE().setANZAHL(BigInteger.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        return wIS;
    }

    protected WIS convertToXmlObject(TransferImpl transferImpl) {
        ObjectType objectType;
        WIS wIS = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("No transfer was provided!");
            return wIS;
        }
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().iterator().next();
        if (transferAgencyImpl == null) {
            LOGGER.warn("No agency was provided!");
            wIS.getOBJEKTE().setANZAHL(BigInteger.ZERO);
            return wIS;
        }
        wIS.setBENUTZER(this.convertAgent(transferAgencyImpl.getAgent()));
        for (Object object : transferAgencyImpl.getEstatesToSave()) {
            try {
                objectType = new ArrayList();
                ObjectType objectType2 = this.convertEstate((EstateImpl)object, (List<String>)objectType);
                if (!objectType.isEmpty()) {
                    this.putErrors(object.getId(), (List)objectType);
                    continue;
                }
                objectType2.setLOESCHEN(Boolean.valueOf(false));
                wIS.getOBJEKTE().getOBJEKT().add(objectType2);
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        for (Object object : transferAgencyImpl.getEstateIdsToRemove()) {
            try {
                objectType = FACTORY.createObjectType();
                objectType.setID((String)object);
                objectType.setLOESCHEN(Boolean.valueOf(true));
                wIS.getOBJEKTE().getOBJEKT().add(objectType);
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        wIS.getOBJEKTE().setANZAHL(BigInteger.valueOf(wIS.getOBJEKTE().getOBJEKT().size()));
        return wIS;
    }

    protected WIS createRoot() {
        WIS wIS = FACTORY.createWIS();
        wIS.setOBJEKTE(FACTORY.createWISOBJEKTE());
        return wIS;
    }

    protected WisItDocument createXmlDocument(WIS wIS) throws ParserConfigurationException, JAXBException {
        return WisItDocument.newDocument((WIS)wIS);
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }
}

