/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.wis_it;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WisItGeoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(WisItGeoBuilder.class);

    public GeoImpl build(File file) throws IOException {
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.setBuildTime(new Date());
        geoImpl.setName("wis_it");
        geoImpl.setProvider("wohnen-in-suedtirol.it");
        try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("cp1252")));){
            String string = lineNumberReader.readLine();
            GeoCountryImpl geoCountryImpl = new GeoCountryImpl();
            geoCountryImpl.setIsoCode(Locale.ITALY.getCountry());
            geoCountryImpl.setId(DigestUtils.sha1Hex((String)geoCountryImpl.getIsoCode()));
            geoCountryImpl.setName(Locale.ITALY.getDisplayCountry(Locale.ITALY));
            while (string != null) {
                String string2 = string.trim();
                if (string2.length() <= 0) {
                    string = lineNumberReader.readLine();
                    continue;
                }
                GeoAreaImpl geoAreaImpl = new GeoAreaImpl();
                geoAreaImpl.setId(DigestUtils.sha1Hex((String)(geoCountryImpl.getId() + "-" + string2)));
                geoAreaImpl.setName(string2);
                geoAreaImpl.setLevel(GeoAreaImpl.LEVEL_REGION);
                geoCountryImpl.getAreas().add(geoAreaImpl);
                string = lineNumberReader.readLine();
            }
            if (geoCountryImpl.getIsoCode() != null) {
                geoImpl.getCountries().add(geoCountryImpl);
            }
        }
        return geoImpl;
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length <= 1) {
            System.out.println("no input- and output-file was provided!");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).isFile()) {
            System.out.println("input-file is invalid!");
            System.exit(1);
        }
        WisItGeoBuilder wisItGeoBuilder = new WisItGeoBuilder();
        GeoImpl geoImpl = null;
        try {
            geoImpl = wisItGeoBuilder.build(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (geoImpl == null) {
            System.exit(1);
        }
        File file2 = new File(stringArray[1]);
        try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file2, "UTF-8");){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)geoImpl, (Writer)fileWriterWithEncoding, (boolean)true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

