/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AuctionCancellationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AuctionModificationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRecordationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRepeated;
import com.openindex.openestate.impl.attribs.administration.AuctionSplitted;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.BuildableInShortTerm;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.BuildingPermissionAvailable;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesFemale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesMale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesTotal;
import com.openindex.openestate.impl.attribs.administration.CountRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.CountryCourtFileReference;
import com.openindex.openestate.impl.attribs.administration.CountryCourtName;
import com.openindex.openestate.impl.attribs.administration.DemolitionRequired;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LandRegisterNr;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Owner;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ConstructionPhase;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.CeilingLoad;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.Height;
import com.openindex.openestate.impl.attribs.measures.Length;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.Width;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.LeasePerArea;
import com.openindex.openestate.impl.attribs.prices.MarketValue;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomePerMonth;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.SupplyAccess;
import com.openindex.openestate.impl.is24.Is24Utils;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.AktionsTyp;
import org.openestate.io.is24_xml.xml.Anlageobjekt;
import org.openestate.io.is24_xml.xml.AnlageobjekteKategorieTyp;
import org.openestate.io.is24_xml.xml.AusstattungsqualitaetsTyp;
import org.openestate.io.is24_xml.xml.BauphaseTyp;
import org.openestate.io.is24_xml.xml.BebaubarNachTyp;
import org.openestate.io.is24_xml.xml.BefeuerungsArtTyp;
import org.openestate.io.is24_xml.xml.BodenbelagTyp;
import org.openestate.io.is24_xml.xml.BodenbelagWohnenTyp;
import org.openestate.io.is24_xml.xml.BueroPraxis;
import org.openestate.io.is24_xml.xml.BueroPraxisKategorienTyp;
import org.openestate.io.is24_xml.xml.DatenVerkabelungsTyp;
import org.openestate.io.is24_xml.xml.Einzelhandel;
import org.openestate.io.is24_xml.xml.EinzelhandelKategorienTyp;
import org.openestate.io.is24_xml.xml.EnergieausweisTyp;
import org.openestate.io.is24_xml.xml.EnergieausweistypTyp;
import org.openestate.io.is24_xml.xml.ErschliessungszustandTyp;
import org.openestate.io.is24_xml.xml.GarageKauf;
import org.openestate.io.is24_xml.xml.GarageMiete;
import org.openestate.io.is24_xml.xml.GaragenKategorieTyp;
import org.openestate.io.is24_xml.xml.GastroKategorieTyp;
import org.openestate.io.is24_xml.xml.Gastronomie;
import org.openestate.io.is24_xml.xml.GenehmigungTyp;
import org.openestate.io.is24_xml.xml.GeschlechtTyp;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbe;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbeEmpfohleneNutzung;
import org.openestate.io.is24_xml.xml.GrundstueckGewerbeKategorienTyp;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenEmpfohleneNutzung;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenKategorienTyp;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenKauf;
import org.openestate.io.is24_xml.xml.GrundstueckWohnenMiete;
import org.openestate.io.is24_xml.xml.HalleProduktion;
import org.openestate.io.is24_xml.xml.HalleProduktionKategorieTyp;
import org.openestate.io.is24_xml.xml.HausKategorienTyp;
import org.openestate.io.is24_xml.xml.HausKauf;
import org.openestate.io.is24_xml.xml.HausMiete;
import org.openestate.io.is24_xml.xml.HebeanlageTyp;
import org.openestate.io.is24_xml.xml.HeizungsartTyp;
import org.openestate.io.is24_xml.xml.IS24ImmobilienTransfer;
import org.openestate.io.is24_xml.xml.ISOLaenderCodeTyp;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.openestate.io.is24_xml.xml.JaNeinVereinbarungTyp;
import org.openestate.io.is24_xml.xml.LageartTyp;
import org.openestate.io.is24_xml.xml.MMAnhangArtenTyp;
import org.openestate.io.is24_xml.xml.MieteEinheitTyp;
import org.openestate.io.is24_xml.xml.MobilarTyp;
import org.openestate.io.is24_xml.xml.MultimediaAnhangTyp;
import org.openestate.io.is24_xml.xml.ObjectFactory;
import org.openestate.io.is24_xml.xml.ObjektZustandTyp;
import org.openestate.io.is24_xml.xml.RauchenTyp;
import org.openestate.io.is24_xml.xml.SonstigeGewerbe;
import org.openestate.io.is24_xml.xml.SonstigeGewerbeKategorieTyp;
import org.openestate.io.is24_xml.xml.StatusTyp;
import org.openestate.io.is24_xml.xml.StellplatzKategorieTyp;
import org.openestate.io.is24_xml.xml.TVAnschlussTyp;
import org.openestate.io.is24_xml.xml.VermarktungGewerbeTyp;
import org.openestate.io.is24_xml.xml.VermarktungGewerbeTyp2;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckGewerbeTyp;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckWohnenKaufTyp;
import org.openestate.io.is24_xml.xml.VermarktungGrundstueckWohnenMieteTyp;
import org.openestate.io.is24_xml.xml.WAZ;
import org.openestate.io.is24_xml.xml.WGGroesse;
import org.openestate.io.is24_xml.xml.WGZimmer;
import org.openestate.io.is24_xml.xml.WGZimmerGeschlechtTyp;
import org.openestate.io.is24_xml.xml.WGZimmerKategorienTyp;
import org.openestate.io.is24_xml.xml.WaehrungTyp;
import org.openestate.io.is24_xml.xml.WazKategorienTyp;
import org.openestate.io.is24_xml.xml.WazObjektZustandTyp;
import org.openestate.io.is24_xml.xml.WazTyp;
import org.openestate.io.is24_xml.xml.WazZeiteinheitenTyp;
import org.openestate.io.is24_xml.xml.WohnungKategorienTyp;
import org.openestate.io.is24_xml.xml.WohnungKauf;
import org.openestate.io.is24_xml.xml.WohnungMiete;
import org.openestate.io.is24_xml.xml.ZulieferungTyp;
import org.openestate.io.is24_xml.xml.Zwangsversteigerung;
import org.openestate.io.is24_xml.xml.ZwangsversteigerungKategorieTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24XmlWriter
extends AbstractXmlWriter<Is24XmlDocument, IS24ImmobilienTransfer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlWriter.class);
    private static final ObjectFactory FACTORY = Is24XmlUtils.getFactory();
    private boolean energyCertificateAppendedToDescription = false;

    public Is24XmlWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public Is24XmlWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected ImmobilienTransferTyp.Anbieter convertAgent(AgentImpl agentImpl) {
        ImmobilienTransferTyp.Anbieter anbieter = new ImmobilienTransferTyp.Anbieter();
        anbieter.setScoutKundenID((String)StringUtils.defaultIfBlank((CharSequence)agentImpl.getId(), (CharSequence)"0"));
        return anbieter;
    }

    protected JAXBElement convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        MultimediaAnhangTyp multimediaAnhangTyp;
        Iterator iterator;
        String string;
        String string2;
        OpenEstateAction openEstateAction = estateImpl.getAction();
        if (openEstateAction == null) {
            throw new IllegalArgumentException("unbekannte Vermarktungsart!");
        }
        OpenEstateType openEstateType = estateImpl.getType();
        if (openEstateType == null) {
            throw new IllegalArgumentException("unbekannte Immobilienart!");
        }
        List<OpenEstateType> list2 = Arrays.asList(openEstateType.getParentPath());
        List list3 = Usage.getAsList((EstateImpl)estateImpl);
        Anlageobjekt.Type type = null;
        if (list3.contains(Usage.Option.INVESTMENT) && OpenEstateAction.PURCHASE.equals((Object)openEstateAction) && (list2.contains(OpenEstateType.GENERAL_COMMERCIAL) || list2.contains(OpenEstateType.GENERAL_RESIDENCE))) {
            type = FACTORY.createAnlageobjektType();
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction) && list2.contains(OpenEstateType.HOUSING_COMPLEX)) {
            type = FACTORY.createAnlageobjektType();
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            if (list2.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                type = FACTORY.createWAZType();
            }
        } else if (OpenEstateAction.AUCTION.equals((Object)openEstateAction)) {
            type = FACTORY.createZwangsversteigerungTyp();
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction) && list2.contains(OpenEstateType.APARTMENT_SHARE)) {
            type = FACTORY.createWGZimmerType();
        } else if (list2.contains(OpenEstateType.RESIDENCE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createWohnungKaufType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createWohnungMieteType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createWohnungMieteType();
            }
        } else if (list2.contains(OpenEstateType.HOUSE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createHausKaufType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createHausMieteType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createHausMieteType();
            }
        } else if (list2.contains(OpenEstateType.RESIDENTIAL_GROUND)) {
            if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckWohnenKaufType();
            } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckWohnenKaufType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckWohnenMieteType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckWohnenMieteType();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckGewerbeType();
            } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckGewerbeType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckGewerbeType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGrundstueckGewerbeType();
            }
        } else if (list2.contains(OpenEstateType.OFFICE_SURGERY) || list2.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createBueroPraxisType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createBueroPraxisType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createBueroPraxisType();
            }
        } else if (list2.contains(OpenEstateType.RETAIL)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createEinzelhandelType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createEinzelhandelType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createEinzelhandelType();
            }
        } else if (list2.contains(OpenEstateType.GASTRONOMY) || list2.contains(OpenEstateType.HOSPITALITY_INDUSTRY)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGastronomieType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createGastronomieType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGastronomieType();
            }
        } else if (list2.contains(OpenEstateType.PRODUCTION) || list2.contains(OpenEstateType.HALL_WAREHOUSE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createHalleProduktionType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createHalleProduktionType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createHalleProduktionType();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_COMMERCIAL) || list2.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createSonstigeGewerbeType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createSonstigeGewerbeType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createSonstigeGewerbeType();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_PARKING)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGarageKaufType();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                type = FACTORY.createGarageMieteType();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                type = FACTORY.createGarageMieteType();
            }
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            type = FACTORY.createAnlageobjektType();
        }
        if (type == null) {
            LOGGER.warn("kein xml-schema gefunden f\u00fcr immobilie #" + estateImpl.getId() + " / " + openEstateType + " / " + openEstateAction);
            list.add("Von IS24-XML nicht unterst\u00fctzt: " + openEstateType + " / " + openEstateAction);
            return null;
        }
        type.setAnbieterObjektID(estateImpl.getId());
        if (StringUtils.isBlank((CharSequence)type.getAnbieterObjektID())) {
            list.add("IS24-Pflichtfeld 'AnbieterObjektID' nicht angegeben!");
        }
        if ((string2 = StringUtils.trimToNull((String)estateImpl.getGroupId())) != null) {
            try {
                string = Long.valueOf(string2).toString();
            }
            catch (NumberFormatException numberFormatException) {
                int n = string2.hashCode();
                if (n == Integer.MIN_VALUE) {
                    ++n;
                }
                string = String.valueOf(Math.abs(n));
            }
            if (string.length() > 10) {
                string = string.substring(0, 10);
            }
            type.setGruppierungsID(Long.valueOf(string));
        }
        type.setAdressdruck(Boolean.valueOf(estateImpl.getAddress().isPublished()));
        type.setAdresse(FACTORY.createImmobilienAdresseTyp());
        type.getAdresse().setHausnummer(estateImpl.getAddress().getStreetNr());
        type.getAdresse().setOrt(estateImpl.getAddress().getCity());
        type.getAdresse().setPostleitzahl(estateImpl.getAddress().getPostalCode());
        type.getAdresse().setStrasse(estateImpl.getAddress().getStreet());
        try {
            string = estateImpl.getAddress().getCountry();
            if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.isBlank((CharSequence)((Object)(iterator = OpenEstateUtils.convertToIso3Country((String)string))))) {
                type.getAdresse().setLaenderkennzeichen(ISOLaenderCodeTyp.fromValue((String)((String)((Object)iterator)).toUpperCase()));
            }
        }
        catch (Exception exception) {
            list.add("IS24-Pflichtfeld 'Land' nicht angegeben!");
            LOGGER.warn("Land der Immobilie konnte nicht \u00fcbernommen werden (" + estateImpl.getAddress().getCountry() + ")!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (StringUtils.isBlank((CharSequence)type.getAdresse().getPostleitzahl())) {
            list.add("IS24-Pflichtfeld 'Postleitzahl' nicht angegeben!");
        }
        if (StringUtils.isBlank((CharSequence)type.getAdresse().getOrt())) {
            list.add("IS24-Pflichtfeld 'Ort' nicht angegeben!");
        }
        if (type.getAdresse().getLaenderkennzeichen() == null) {
            list.add("IS24-Pflichtfeld 'Laenderkennzeichen' nicht angegeben!");
        }
        type.setKontaktperson(FACTORY.createKontaktAdresseTyp());
        if (agentContactImpl != null) {
            if (agentContactImpl.isFemale()) {
                type.getKontaktperson().setAnrede("Frau");
            } else if (agentContactImpl.isMale()) {
                type.getKontaktperson().setAnrede("Herr");
            }
            type.getKontaktperson().setEMail(agentContactImpl.getPersonMail());
            type.getKontaktperson().setHausnummer(agentContactImpl.getStreetNr());
            type.getKontaktperson().setMobiltelefon(agentContactImpl.getPersonMobilePhone());
            type.getKontaktperson().setNachname(agentContactImpl.getPersonLastName());
            type.getKontaktperson().setOrt(agentContactImpl.getCity());
            type.getKontaktperson().setPostleitzahl(agentContactImpl.getPostalCode());
            type.getKontaktperson().setStrasse(agentContactImpl.getStreet());
            type.getKontaktperson().setTelefax(agentContactImpl.getPersonFax());
            type.getKontaktperson().setTelefon(agentContactImpl.getPersonPhone());
            if (StringUtils.isBlank((CharSequence)type.getKontaktperson().getTelefon())) {
                type.getKontaktperson().setTelefon(agentContactImpl.getPersonMobilePhone());
            }
            type.getKontaktperson().setVorname(agentContactImpl.getPersonFirstName());
            try {
                string = agentContactImpl.getCountry();
                if (!StringUtils.isBlank((CharSequence)string) && !StringUtils.isBlank((CharSequence)((Object)(iterator = OpenEstateUtils.convertToIso3Country((String)string))))) {
                    type.getKontaktperson().setLaenderkennzeichen(ISOLaenderCodeTyp.fromValue((String)((String)((Object)iterator)).toUpperCase()));
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Land des Ansprechpartners konnte nicht \u00fcbernommen werden!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        type.getKontaktperson().setHomepage(agentContactImpl != null ? agentContactImpl.getContactWebsite() : null);
        if (type.getKontaktperson().getHomepage() == null) {
            type.getKontaktperson().setHomepage(agentImpl.getCompany().getCompanyWebsite());
        }
        if (StringUtils.isBlank((CharSequence)type.getKontaktperson().getEMail())) {
            type.getKontaktperson().setEMail(agentImpl.getCompany().getCompanyMail());
        }
        if (StringUtils.isBlank((CharSequence)type.getKontaktperson().getTelefax())) {
            type.getKontaktperson().setTelefax(agentImpl.getCompany().getCompanyFax());
        }
        if (StringUtils.isBlank((CharSequence)type.getKontaktperson().getTelefon())) {
            type.getKontaktperson().setTelefon(agentImpl.getCompany().getCompanyPhone());
        }
        type.setAusstattung(OpenEstateUtils.serializeString((String)StringUtils.trimToNull((String)FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())), (String)this.getXmlLineSeparator()));
        type.setLage(OpenEstateUtils.serializeString((String)StringUtils.trimToNull((String)LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())), (String)this.getXmlLineSeparator()));
        type.setObjektbeschreibung(OpenEstateUtils.serializeString((String)StringUtils.trimToNull((String)DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())), (String)this.getXmlLineSeparator()));
        type.setProvisionshinweis(OpenEstateUtils.serializeString((String)StringUtils.trimToNull((String)AgentFeeInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())), (String)this.getXmlLineSeparator()));
        type.setSonstigeAngaben(OpenEstateUtils.serializeString((String)StringUtils.trimToNull((String)AdditionalInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())), (String)this.getXmlLineSeparator()));
        if (this.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((CharSequence)(string = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)this.getXmlLineSeparator())))) {
            type.setSonstigeAngaben(OpenEstateUtils.appendTextToDescription((String)type.getSonstigeAngaben(), (String)string, (String)this.getXmlLineSeparator(), (int)2000, (boolean)true));
        }
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_AGENT_FEE)) {
            string = AgentFee.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
            type.setProvisionspflichtig(Boolean.valueOf(!StringUtils.isBlank((CharSequence)string) && !string.equalsIgnoreCase("keine") && !string.equalsIgnoreCase("nein") && !string.equalsIgnoreCase("frei") && !string.equalsIgnoreCase("provisionsfrei")));
            type.setProvision(StringUtils.trimToNull((String)string));
        } else {
            type.setProvisionspflichtig(Boolean.valueOf(false));
        }
        type.setImportmodus(AktionsTyp.AKTUALISIEREN);
        type.setStatusHP(StatusTyp.AKTIV);
        type.setStatusIS24(StatusTyp.AKTIV);
        type.setStatusVBM(StatusTyp.AKTIV);
        string = estateImpl.getTitle(this.getOpenEstateLanguage());
        type.setUeberschrift(!StringUtils.isBlank((CharSequence)string) ? string.trim() : estateImpl.getFallbackTitle(this.getOpenEstateLanguage()));
        if (StringUtils.isBlank((CharSequence)type.getUeberschrift())) {
            list.add("IS24-Pflichtfeld 'Ueberschrift' nicht angegeben!");
        }
        try {
            type.setWaehrung(WaehrungTyp.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("W\u00e4hrung konnte nicht \u00fcbernommen werden!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (type.getMultimediaAnhang().size() >= 15) break;
            if (!estateAttachmentImpl.isName() && !estateAttachmentImpl.isUrl()) continue;
            multimediaAnhangTyp = FACTORY.createMultimediaAnhangTyp();
            if (estateAttachmentImpl.isName()) {
                multimediaAnhangTyp.setDateiname(estateAttachmentImpl.getFileAsName());
                if (estateAttachmentImpl.getMimeType().equalsIgnoreCase("application/pdf")) {
                    if (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType())) {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.GRUNDRISS_PDF);
                    } else {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.VIDEO);
                    }
                } else if (estateAttachmentImpl.getMimeType().toLowerCase().startsWith("image/")) {
                    if (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType())) {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.GRUNDRISS_BILD);
                    } else {
                        multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.BILD);
                    }
                } else {
                    if (!estateAttachmentImpl.getMimeType().toLowerCase().startsWith("video/")) continue;
                    multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.VIDEO);
                }
            } else {
                if (!estateAttachmentImpl.isUrl()) continue;
                multimediaAnhangTyp.setDateiname(estateAttachmentImpl.getFileAsUrl().toString());
                multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.LINK);
            }
            if (StringUtils.isBlank((CharSequence)multimediaAnhangTyp.getDateiname()) || multimediaAnhangTyp.getAnhangArt() == null) {
                LOGGER.warn("incomplete attachment...");
                continue;
            }
            String[] stringArray = multimediaAnhangTyp.getDateiname().split("\\.");
            multimediaAnhangTyp.setDateityp(stringArray[stringArray.length - 1].trim().toUpperCase());
            multimediaAnhangTyp.setTitel(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
            type.getMultimediaAnhang().add(multimediaAnhangTyp);
        }
        for (EstateLinkImpl estateLinkImpl : estateImpl.getLinks()) {
            if (type.getMultimediaAnhang().size() >= 15) break;
            if (!estateLinkImpl.isWebLink()) continue;
            multimediaAnhangTyp = FACTORY.createMultimediaAnhangTyp();
            multimediaAnhangTyp.setAnhangArt(MMAnhangArtenTyp.LINK);
            multimediaAnhangTyp.setDateiname(estateLinkImpl.getWebLink().toString());
            multimediaAnhangTyp.setTitel(estateLinkImpl.getTitle(this.getOpenEstateLanguage()));
            type.getMultimediaAnhang().add(multimediaAnhangTyp);
        }
        if (type instanceof Anlageobjekt.Type) {
            return this.convertEstate(estateImpl, type, list2, list);
        }
        if (type instanceof BueroPraxis.Type) {
            return this.convertEstate(estateImpl, (BueroPraxis.Type)type, list2, list);
        }
        if (type instanceof Einzelhandel.Type) {
            return this.convertEstate(estateImpl, (Einzelhandel.Type)type, list2, list);
        }
        if (type instanceof GarageKauf.Type) {
            return this.convertEstate(estateImpl, (GarageKauf.Type)type, list2, list);
        }
        if (type instanceof GarageMiete.Type) {
            return this.convertEstate(estateImpl, (GarageMiete.Type)type, list2, list);
        }
        if (type instanceof Gastronomie.Type) {
            return this.convertEstate(estateImpl, (Gastronomie.Type)type, list2, list);
        }
        if (type instanceof GrundstueckGewerbe.Type) {
            return this.convertEstate(estateImpl, (GrundstueckGewerbe.Type)type, list2, list);
        }
        if (type instanceof GrundstueckWohnenKauf.Type) {
            return this.convertEstate(estateImpl, (GrundstueckWohnenKauf.Type)type, list2, list);
        }
        if (type instanceof GrundstueckWohnenMiete.Type) {
            return this.convertEstate(estateImpl, (GrundstueckWohnenMiete.Type)type, list2, list);
        }
        if (type instanceof HalleProduktion.Type) {
            return this.convertEstate(estateImpl, (HalleProduktion.Type)type, list2, list);
        }
        if (type instanceof HausKauf.Type) {
            return this.convertEstate(estateImpl, (HausKauf.Type)type, list2, list);
        }
        if (type instanceof HausMiete.Type) {
            return this.convertEstate(estateImpl, (HausMiete.Type)type, list2, list);
        }
        if (type instanceof SonstigeGewerbe.Type) {
            return this.convertEstate(estateImpl, (SonstigeGewerbe.Type)type, list2, list);
        }
        if (type instanceof WAZ.Type) {
            return this.convertEstate(estateImpl, (WAZ.Type)type, list2, list);
        }
        if (type instanceof WGZimmer.Type) {
            return this.convertEstate(estateImpl, (WGZimmer.Type)type, list2, list);
        }
        if (type instanceof WohnungKauf.Type) {
            return this.convertEstate(estateImpl, (WohnungKauf.Type)type, list2, list);
        }
        if (type instanceof WohnungMiete.Type) {
            return this.convertEstate(estateImpl, (WohnungMiete.Type)type, list2, list);
        }
        if (type instanceof Zwangsversteigerung.Type) {
            return this.convertEstate(estateImpl, (Zwangsversteigerung.Type)type, list2, list);
        }
        list.add("Keine Immobilienart zur Verarbeitung gefunden!");
        return null;
    }

    protected Anlageobjekt convertEstate(EstateImpl estateImpl, Anlageobjekt.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setGewerbeFlaechen(CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setGrundstuecksFlaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKaufpreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKaufpreisProQm(PurchasePricePerArea.getAsBigDecimal((EstateImpl)estateImpl));
        type.setMietEinnahmePaIst(RentalIncomeActualPerAnnum.getAsBigDecimal((EstateImpl)estateImpl));
        type.setMietEinnahmePaSoll(RentalIncomeDebitPerAnnum.getAsBigDecimal((EstateImpl)estateImpl));
        type.setObjektkategorie2(this.writeKategorieAnlage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setPreisProParkflaeche(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.setSonstigeFlaechen(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setWohnFlaechen(ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setXFacheMiete(PurchasePriceOnAnnualRentalIncome.getAsBigDecimal((EstateImpl)estateImpl));
        BigDecimal bigDecimal = RentableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setVermietbareFlaeche(bigDecimal);
        if (type.getVermietbareFlaeche() == null || type.getVermietbareFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'VermietbareFlaeche' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        if (type.getKaufpreis() == null || type.getKaufpreis().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Kaufpreis' nicht angegeben (f\u00fcr Anlageobjekt)!");
        }
        return list2.isEmpty() ? FACTORY.createAnlageobjekt(type) : null;
    }

    protected BueroPraxis convertEstate(EstateImpl estateImpl, BueroPraxis.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDatenVerkabelung(this.writeDatenverkabelung(estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKantine(CanteenCafeteria.get((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setKlimaanlage(this.writeKlimatisiert(estateImpl));
        type.setKuecheVorhanden(this.writeKueche(estateImpl));
        type.setNebenflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektkategorie2(this.writeKategorieBueroPraxis(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setTeilbarAb(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        BigDecimal bigDecimal = OfficeArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setBueroPraxisFlaeche(bigDecimal);
        if (type.getBueroPraxisFlaeche() == null || type.getBueroPraxisFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'BueroPraxisFlaeche' nicht angegeben (f\u00fcr BueroPraxis)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr BueroPraxis)!");
        } else if (type.getVermarktung().getMiete() != null) {
            BigDecimal bigDecimal2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(BigDecimal.ZERO);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            BigDecimal bigDecimal3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(BigDecimal.ZERO);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr BueroPraxis)!");
        }
        return list2.isEmpty() ? FACTORY.createBueroPraxis(type) : null;
    }

    protected Einzelhandel convertEstate(EstateImpl estateImpl, Einzelhandel.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDeckenlast(CeilingLoad.getAsBigDecimal((EstateImpl)estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setLageart(this.writeLageArt(estateImpl));
        HebeanlageTyp hebeanlageTyp = this.writeLastenaufzug(estateImpl);
        if (hebeanlageTyp != null) {
            type.setLastenaufzug(new JAXBElement(new QName("http://www.immobilienscout24.de/immobilientransfer", "Lastenaufzug"), HebeanlageTyp.class, (Object)hebeanlageTyp));
        }
        type.setNebenflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektkategorie2(this.writeKategorieEinzelhandel(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setRampe(Ramp.get((EstateImpl)estateImpl));
        type.setSchaufensterfront(FrontWindowLength.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setObjektkategorie2(this.writeKategorieEinzelhandel(list));
        type.setTeilbarAb(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        type.setZulieferung(this.writeZulieferung(estateImpl));
        BigDecimal bigDecimal = SalesArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setVerkaufsflaeche(bigDecimal);
        if (type.getVerkaufsflaeche() == null || type.getVerkaufsflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Verkaufsflaeche' nicht angegeben (f\u00fcr Einzelhandel)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr Einzelhandel)!");
        } else if (type.getVermarktung().getMiete() != null) {
            BigDecimal bigDecimal2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(BigDecimal.ZERO);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            BigDecimal bigDecimal3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(BigDecimal.ZERO);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr Einzelhandel)!");
        }
        return list2.isEmpty() ? FACTORY.createEinzelhandel(type) : null;
    }

    protected GarageKauf convertEstate(EstateImpl estateImpl, GarageKauf.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBreite(Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setFlaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHoehe(Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKaufpreise(FACTORY.createVermarktungGarageKaufTyp());
        type.getKaufpreise().setKaufpreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.setLaenge(Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setObjektKategorie2(this.writeKategorieGarage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr GarageKauf)!");
        } else {
            BigDecimal bigDecimal = type.getKaufpreise().getKaufpreis();
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr GarageKauf)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createGarageKauf(type) : null;
    }

    protected GarageMiete convertEstate(EstateImpl estateImpl, GarageMiete.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBreite(Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setFlaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHoehe(Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setMietpreise(FACTORY.createVermarktungGarageMieteTyp());
        type.getMietpreise().setMiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.setLaenge(Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setObjektKategorie2(this.writeKategorieGarage(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr GarageMiete)!");
        } else {
            BigDecimal bigDecimal = type.getMietpreise().getMiete();
            if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Miete' nicht angegeben (f\u00fcr GarageMiete)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createGarageMiete(type) : null;
    }

    protected Gastronomie convertEstate(EstateImpl estateImpl, Gastronomie.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlBetten(CountBeds.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGastraumPlaetze(CountGuestroomSeats.getAsLong((EstateImpl)estateImpl));
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setNebenflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektkategorie2(this.writeKategorieGastronomie(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setVermarktung(this.writeVermarktungGewerbe2(estateImpl));
        BigDecimal bigDecimal = SeatingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setGastraumFlaeche(bigDecimal);
        if (type.getGastraumFlaeche() == null || type.getGastraumFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'GastraumFlaeche' nicht angegeben (f\u00fcr Gastronomie)!");
        }
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr Gastronomie)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr Gastronomie)!");
        } else {
            BigDecimal bigDecimal2 = type.getVermarktung().getPreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                type.getVermarktung().setPreis(BigDecimal.ZERO);
            }
            if (type.getVermarktung().getMiete() == null && type.getVermarktung().getKauf() == null) {
                list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr Gastronomie)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createGastronomie(type) : null;
    }

    protected GrundstueckGewerbe convertEstate(EstateImpl estateImpl, GrundstueckGewerbe.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAbrissErforderlich(DemolitionRequired.get((EstateImpl)estateImpl));
        type.setBaugenehmigungVorhanden(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitGewerbe(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setGFZ(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setGRZ(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKurzfristigBebaubar(BuildableInShortTerm.get((EstateImpl)estateImpl));
        type.setObjektkategorie2(this.writeKategorieGrundstueckGewerbe(list));
        type.setTeilbarAb(DivisibleFromArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGrundstueckGewerbe(estateImpl));
        BigDecimal bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setGrundstuecksFlaeche(bigDecimal);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
        } else {
            BigDecimal bigDecimal2 = type.getVermarktung().getPreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                type.getVermarktung().setPreis(BigDecimal.ZERO);
            }
            if (type.getVermarktung().getErbpacht() != null && ((VermarktungGrundstueckGewerbeTyp.Erbpacht)type.getVermarktung().getErbpacht().getValue()).getDauerInJahren() == null) {
                list2.add("IS24-Pflichtfeld 'Vermarktung/Erbpacht/DauerInJahren' nicht angegeben (f\u00fcr GrundstueckGewerbe)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createGrundstueckGewerbe(type) : null;
    }

    protected GrundstueckWohnenKauf convertEstate(EstateImpl estateImpl, GrundstueckWohnenKauf.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAbrissErforderlich(DemolitionRequired.get((EstateImpl)estateImpl));
        type.setBaugenehmigungVorhanden(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitWohnen(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setGFZ(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setGRZ(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKurzfristigBebaubar(BuildableInShortTerm.get((EstateImpl)estateImpl));
        type.setObjektkategorie2(GrundstueckWohnenKategorienTyp.WOHNEN);
        type.setTeilbarAb(DivisibleFromArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGrundstueckWohnenKauf(estateImpl));
        BigDecimal bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setGrundstuecksFlaeche(bigDecimal);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
        } else {
            BigDecimal bigDecimal2 = type.getVermarktung().getPreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                type.getVermarktung().setPreis(BigDecimal.ZERO);
            }
            if (type.getVermarktung().getErbpacht() != null && ((VermarktungGrundstueckWohnenKaufTyp.Erbpacht)type.getVermarktung().getErbpacht().getValue()).getDauerInJahren() == null) {
                list2.add("IS24-Pflichtfeld 'Vermarktung/Erbpacht/DauerInJahren' nicht angegeben (f\u00fcr GrundstueckWohnenKauf)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createGrundstueckWohnenKauf(type) : null;
    }

    protected GrundstueckWohnenMiete convertEstate(EstateImpl estateImpl, GrundstueckWohnenMiete.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAbrissErforderlich(DemolitionRequired.get((EstateImpl)estateImpl));
        type.setBaugenehmigungVorhanden(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        type.setBebaubarMit(this.writeBebaubarMitWohnen(estateImpl));
        type.setBebaubarNach(this.writeBebaubarNach(estateImpl));
        type.setErschliessungszustand(this.writeErschliessungszustand(estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setGFZ(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setGRZ(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKurzfristigBebaubar(BuildableInShortTerm.get((EstateImpl)estateImpl));
        type.setObjektkategorie2(GrundstueckWohnenKategorienTyp.WOHNEN);
        type.setTeilbarAb(DivisibleFromArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGrundstueckWohnenMiete(estateImpl));
        BigDecimal bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setGrundstuecksFlaeche(bigDecimal);
        if (type.getGrundstuecksFlaeche() == null || type.getGrundstuecksFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'GrundstuecksFlaeche' nicht angegeben (f\u00fcr GrundstueckWohnenMiete)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr GrundstueckWohnenMiete)!");
        } else {
            BigDecimal bigDecimal2 = type.getVermarktung().getPreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                type.getVermarktung().setPreis(BigDecimal.ZERO);
            }
        }
        return list2.isEmpty() ? FACTORY.createGrundstueckWohnenMiete(type) : null;
    }

    protected HalleProduktion convertEstate(EstateImpl estateImpl, HalleProduktion.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setBodenbelastung(FloorLoading.getAsBigDecimal((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setGrundstuecksFlaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHallenhoehe(WarehouseHeight.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        type.setHebebuehne(LiftingPlatform.get((EstateImpl)estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKranbahn(this.writeKranbahn(estateImpl));
        type.setLastenaufzug(this.writeLastenaufzug(estateImpl));
        type.setNebenflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektkategorie2(this.writeKategorieHalleProduktion(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setRampe(Ramp.get((EstateImpl)estateImpl));
        type.setStromanschlusswert(ElectricalConnectionValue.getAsLong((EstateImpl)estateImpl));
        type.setTeilbarAb(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGewerbe(estateImpl));
        BigDecimal bigDecimal = StorageArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setLagerProduktionsFlaeche(bigDecimal);
        if (type.getLagerProduktionsFlaeche() == null || type.getLagerProduktionsFlaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LagerProduktionsFlaeche' nicht angegeben (f\u00fcr HalleProduktion)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr HalleProduktion)!");
        } else if (type.getVermarktung().getMiete() != null) {
            BigDecimal bigDecimal2 = ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).getKaltmiete();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Miete)type.getVermarktung().getMiete().getValue()).setKaltmiete(BigDecimal.ZERO);
            }
        } else if (type.getVermarktung().getKauf() != null) {
            BigDecimal bigDecimal3 = ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).getPreis();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
                ((VermarktungGewerbeTyp.Kauf)type.getVermarktung().getKauf().getValue()).setPreis(BigDecimal.ZERO);
            }
        } else {
            list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr HalleProduktion)!");
        }
        return list2.isEmpty() ? FACTORY.createHalleProduktion(type) : null;
    }

    protected HausKauf convertEstate(EstateImpl estateImpl, HausKauf.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAlsFerienwohnungGeeignet(HolidayProperty.get((EstateImpl)estateImpl));
        type.setAnzahlBadezimmer(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlGaragenStellplaetze(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlSchlafzimmer(CountBedrooms.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBauphase(this.writeBauphase(estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGrundstuecksFlaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHausKategorie(this.writeKategorieHaus(list));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKaufpreise(FACTORY.createVermarktungWohnKaufTyp());
        type.getKaufpreise().setKaufpreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setMieteinnahmenProMonat(RentalIncomePerMonth.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setStellplatzKaufpreis(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setWohngeld(CommonCharge.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setMitEinliegerwohnung(GrannyFlat.get((EstateImpl)estateImpl));
        type.setNutzflaeche(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            type.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        type.setVermietet(Rented.get((EstateImpl)estateImpl));
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        BigDecimal bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setWohnflaeche(bigDecimal);
        if (type.getWohnflaeche() == null || type.getWohnflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr HausKauf)!");
        }
        if (type.getZimmer() == null || type.getZimmer().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr HausKauf)!");
        }
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr HausKauf)!");
        } else if (type.getKaufpreise().getKaufpreis() == null || type.getKaufpreise().getKaufpreis().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr HausKauf)!");
        }
        return list2.isEmpty() ? FACTORY.createHausKauf(type) : null;
    }

    protected HausMiete convertEstate(EstateImpl estateImpl, HausMiete.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlBadezimmer(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlGaragenStellplaetze(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlSchlafzimmer(CountBedrooms.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        if (ResidentialServices.hasOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING)) {
            type.setBetreutesWohnen(Boolean.valueOf(true));
        }
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            type.setEinbaukueche(Boolean.valueOf(true));
        }
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGrundstuecksFlaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHausKategorie(this.writeKategorieHaus(list));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setMietpreise(FACTORY.createVermarktungWohnMieteTyp());
        type.getMietpreise().setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        type.getMietpreise().setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setStellplatzMiete(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setWarmmiete(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        BigDecimal bigDecimal = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 && bl != null) {
            type.getMietpreise().setHeizkosten(bigDecimal);
        }
        type.setNutzflaeche(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            type.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        BigDecimal bigDecimal2 = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal2 = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setWohnflaeche(bigDecimal2);
        if (type.getWohnflaeche() == null || type.getWohnflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr HausMiete)!");
        }
        if (type.getZimmer() == null || type.getZimmer().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr HausMiete)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr HausMiete)!");
        } else if (type.getMietpreise().getKaltmiete() == null || type.getMietpreise().getKaltmiete().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr HausMiete)!");
        }
        return list2.isEmpty() ? FACTORY.createHausMiete(type) : null;
    }

    protected SonstigeGewerbe convertEstate(EstateImpl estateImpl, SonstigeGewerbe.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAnzahlParkflaechen(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setBodenbelag(this.writeBodenbelag(estateImpl));
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagen(StringUtils.trimToNull((String)CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        type.setFahrzeitBAB(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        type.setFahrzeitBHf(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        type.setFahrzeitFlughafen(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl)));
        if (type.getFusswegOeNV() == null) {
            type.setFusswegOeNV(Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl)));
        }
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setGrundstuecksFlaeche(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setNebenflaeche(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektkategorie2(this.writeKategorieSonstigesGewerbe(list));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        type.setTeilbarAb(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setVermarktung(this.writeVermarktungGewerbe2(estateImpl));
        BigDecimal bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setHauptflaeche(bigDecimal);
        if (type.getObjektkategorie2() == null) {
            list2.add("IS24-Pflichtfeld 'Objektkategorie2' nicht angegeben (f\u00fcr SonstigeGewerbe)!");
        }
        if (type.getVermarktung() == null) {
            list2.add("IS24-Pflichtfeld 'Vermarktung' nicht angegeben (f\u00fcr SonstigeGewerbe)!");
        } else {
            BigDecimal bigDecimal2 = type.getVermarktung().getPreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                type.getVermarktung().setPreis(BigDecimal.ZERO);
            }
            if (type.getVermarktung().getMiete() == null && type.getVermarktung().getKauf() == null) {
                list2.add("IS24-Pflichtfeld unvollst\u00e4ndig, weder 'Vermarktung/Miete' noch 'Vermarktung/Kauf' sind angegeben (f\u00fcr SonstigeGewerbe)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createSonstigeGewerbe(type) : null;
    }

    protected WAZ convertEstate(EstateImpl estateImpl, WAZ.Type type, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        Number number;
        Number number2;
        Number number3;
        type.setAnzahlGaragenStellplaetze(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlPersonen(PeopleMaximumCount.getAsLong((EstateImpl)estateImpl));
        type.setAufzug(Lift.get((EstateImpl)estateImpl));
        type.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFreiAb(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        type.setFreiBis(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGartenBenutzung(GardenUse.get((EstateImpl)estateImpl));
        type.setGeschlecht(this.writeGeschlecht(estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getKaution())) {
            type.setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        if (Furnished.Option.YES.equals((Object)Furnished.get((EstateImpl)estateImpl))) {
            type.setMobilar(Boolean.valueOf(true));
        }
        type.setObjektzustand(this.writeObjektZustandWaz(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        type.setParkplatzmiete(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        type.setRaucherOk(this.writeRaucherOk(estateImpl));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            type.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        type.setWazKategorie(this.writeKategorieWaz(list));
        type.setWohnflaeche(ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES)) {
            type.setMonatsmiete(new WazTyp.Monatsmiete());
            type.getMonatsmiete().setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
            type.getMonatsmiete().setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_FLAT_RATE)) {
            type.setPauschalmiete(new WazTyp.Pauschalmiete());
            type.getPauschalmiete().setMietePauschal(RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl));
            number3 = RentFlatRatePer.get((EstateImpl)estateImpl);
            if (RentFlatRatePer.Option.MONTH.equals((Object)number3)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.MONAT);
            } else if (RentFlatRatePer.Option.WEEK.equals((Object)number3)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.WOCHE);
            } else if (RentFlatRatePer.Option.DAY.equals((Object)number3)) {
                type.getPauschalmiete().setMietePro(WazZeiteinheitenTyp.TAG);
            }
        }
        number3 = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number3 != null) {
            type.setEtage(Long.valueOf(number3.longValue()));
        }
        if ((number2 = OpenEstateUtils.parseNumber((String)OccupationPeriodMaximum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) instanceof BigDecimal) {
            type.setMaximalmietdauer((BigDecimal)number2);
        } else if (number2 instanceof BigInteger) {
            type.setMaximalmietdauer(new BigDecimal((BigInteger)number2));
        } else if (number2 != null) {
            type.setMaximalmietdauer(BigDecimal.valueOf(number2.doubleValue()));
        }
        if (type.getMaximalmietdauer() != null && type.getMaximalmietdauer().compareTo(BigDecimal.ZERO) < 1) {
            type.setMaximalmietdauer(null);
        }
        if ((number = OpenEstateUtils.parseNumber((String)OccupationPeriodMinimum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) instanceof BigDecimal) {
            type.setMidestmietdauer((BigDecimal)number);
        } else if (number instanceof BigInteger) {
            type.setMidestmietdauer(new BigDecimal((BigInteger)number));
        } else if (number != null) {
            type.setMidestmietdauer(BigDecimal.valueOf(number.doubleValue()));
        }
        if (type.getMidestmietdauer() != null && type.getMidestmietdauer().compareTo(BigDecimal.ZERO) < 1) {
            type.setMidestmietdauer(null);
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setWohnflaeche(bigDecimal);
        if (type.getWohnflaeche() == null || type.getWohnflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getWazKategorie() == null) {
            list2.add("IS24-Pflichtfeld 'WazKategorie' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getZimmer() == null || type.getZimmer().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getFreiAb() == null) {
            list2.add("IS24-Pflichtfeld 'FreiAb' nicht angegeben (f\u00fcr WAZ)!");
        }
        if (type.getPauschalmiete() == null) {
            list2.add("IS24-Pflichtfeld 'Pauschalmiete' nicht angegeben (f\u00fcr WAZ)!");
        } else {
            BigDecimal bigDecimal2 = type.getPauschalmiete().getMietePauschal();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Pauschalmiete/MietePauschal' nicht angegeben (f\u00fcr WAZ)!");
            }
            if (type.getPauschalmiete().getMietePro() == null) {
                list2.add("IS24-Pflichtfeld 'Pauschalmiete/MietePro' nicht angegeben (f\u00fcr WAZ)!");
            }
        }
        if (type.getMonatsmiete() != null && (type.getMonatsmiete().getKaltmiete() == null || type.getMonatsmiete().getKaltmiete().compareTo(BigDecimal.ZERO) < 1)) {
            list2.add("IS24-Pflichtfeld 'Monatsmiete/Kaltmiete' nicht angegeben (f\u00fcr WAZ)!");
        }
        return list2.isEmpty() ? FACTORY.createWAZ(type) : null;
    }

    protected WGZimmer convertEstate(EstateImpl estateImpl, WGZimmer.Type type, List<OpenEstateType> list, List<String> list2) {
        Serializable serializable;
        BigDecimal bigDecimal;
        Number number;
        type.setAlterDerzeitigeBewohnerBis(AgeOfFlatmatesMaximal.getAsLong((EstateImpl)estateImpl));
        type.setAlterDerzeitigeBewohnerVon(AgeOfFlatmatesMinimal.getAsLong((EstateImpl)estateImpl));
        type.setAlterGesuchterBewohnerBis(AgeOfRequestedFlatmatesMaximal.getAsLong((EstateImpl)estateImpl));
        type.setAlterGesuchterBewohnerVon(AgeOfRequestedFlatmatesMinimal.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlBadezimmer(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlGesuchteMitbewohner(CountRequestedFlatmates.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlMaennlicheMitbewohner(CountFlatmatesMale.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlWeiblicheMitbewohner(CountFlatmatesFemale.getAsLong((EstateImpl)estateImpl));
        type.setAufzug(Lift.get((EstateImpl)estateImpl));
        if (Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BATHTUB)) {
            type.setBadewanne(Boolean.valueOf(true));
        }
        type.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBewohnerzahl(this.writeWgGroesse(estateImpl));
        type.setBodenbelag(this.writeBodenbelagWohnen(estateImpl));
        if (Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.SHOWER)) {
            type.setDusche(Boolean.valueOf(true));
        }
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFreiAb(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        type.setFreiBis(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGartenBenutzung(GardenUse.get((EstateImpl)estateImpl));
        type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setGeschlechtGesuchterBewohner(this.writeGeschlechtWG(estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setMobilar(this.writeMobilar(estateImpl));
        type.setRauchen(this.writeRauchen(estateImpl));
        type.setTVAnschluss(this.writeTvAnschluss(estateImpl));
        type.setWGZimmerKategorie(WGZimmerKategorienTyp.KEINE_ANGABE);
        if (Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.WASHING_MACHINE_CONNECTION)) {
            type.setWaschmaschine(Boolean.valueOf(true));
        }
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        type.setMietpreise(FACTORY.createVermarktungWGZimmerTyp());
        type.getMietpreise().setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        type.getMietpreise().setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setWarmmiete(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        BigDecimal bigDecimal2 = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 && bl != null) {
            type.getMietpreise().setHeizkosten(bigDecimal2);
        }
        if ((number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) != null) {
            type.setEtage(Long.valueOf(number.longValue()));
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setZimmerflaeche(bigDecimal);
        if (StringUtils.isBlank((CharSequence)type.getSonstigeAngaben())) {
            serializable = new ArrayList<String>();
            if (!StringUtils.isBlank((CharSequence)type.getObjektbeschreibung())) {
                serializable.add(type.getObjektbeschreibung().trim());
            }
            if (!StringUtils.isBlank((CharSequence)type.getLage())) {
                serializable.add(type.getLage().trim());
            }
            if (!StringUtils.isBlank((CharSequence)type.getAusstattung())) {
                serializable.add(type.getAusstattung().trim());
            }
            if (!serializable.isEmpty()) {
                type.setSonstigeAngaben(StringUtils.join(serializable, (String)(this.getXmlLineSeparator() + this.getXmlLineSeparator())).trim());
            }
        }
        type.setAusstattung(null);
        type.setLage(null);
        type.setObjektbeschreibung(null);
        if (type.getZimmerflaeche() == null || type.getZimmerflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmerflaeche' nicht angegeben (f\u00fcr WGZimmer)!");
        }
        if (type.getFreiAb() == null) {
            list2.add("IS24-Pflichtfeld 'FreiAb' nicht angegeben (f\u00fcr WGZimmer)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr WGZimmer)!");
        } else {
            serializable = type.getMietpreise().getKaltmiete();
            if (serializable == null || ((BigDecimal)serializable).compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr WGZimmer)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createWGZimmer(type) : null;
    }

    protected WohnungKauf convertEstate(EstateImpl estateImpl, WohnungKauf.Type type, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        type.setAlsFerienwohnungGeeignet(HolidayProperty.get((EstateImpl)estateImpl));
        type.setAnzahlBadezimmer(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlGaragenStellplaetze(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlSchlafzimmer(CountBedrooms.getAsLong((EstateImpl)estateImpl));
        type.setAufzug(Lift.get((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        if (ResidentialServices.hasOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING)) {
            type.setBetreutesWohnen(Boolean.valueOf(true));
        }
        type.setDenkmalschutzobjekt(MonumentalProtection.get((EstateImpl)estateImpl));
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            type.setEinbaukueche(Boolean.valueOf(true));
        }
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGartenBenutzung(GardenUse.get((EstateImpl)estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKaufpreise(FACTORY.createVermarktungWohnKaufTyp());
        type.getKaufpreise().setKaufpreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setMieteinnahmenProMonat(RentalIncomePerMonth.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setStellplatzKaufpreis(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        type.getKaufpreise().setWohngeld(CommonCharge.getAsBigDecimal((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setNutzflaeche(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            type.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        type.setVermietet(Rented.get((EstateImpl)estateImpl));
        type.setWohnungKategorie(this.writeKategorieWohnung(list));
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        Number number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number != null) {
            type.setEtage(Long.valueOf(number.longValue()));
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setWohnflaeche(bigDecimal);
        if (type.getWohnflaeche() == null || type.getWohnflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WohnungKauf)!");
        }
        if (type.getZimmer() == null || type.getZimmer().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WohnungKauf)!");
        }
        if (type.getKaufpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Kaufpreise' nicht angegeben (f\u00fcr WohnungKauf)!");
        } else {
            BigDecimal bigDecimal2 = type.getKaufpreise().getKaufpreis();
            if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Kaufpreise/Kaufpreis' nicht angegeben (f\u00fcr WohnungKauf)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createWohnungKauf(type) : null;
    }

    protected WohnungMiete convertEstate(EstateImpl estateImpl, WohnungMiete.Type type, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        type.setAnzahlBadezimmer(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlGaragenStellplaetze(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        type.setAnzahlSchlafzimmer(CountBedrooms.getAsLong((EstateImpl)estateImpl));
        type.setAufzug(Lift.get((EstateImpl)estateImpl));
        type.setAusstattungsqualitaet(this.writeAustattungsQualitaet(estateImpl));
        type.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        type.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        type.setBaujahr(BuildYear.getAsLong((EstateImpl)estateImpl));
        type.setBefeuerungsArt(this.writeBefeuerung(estateImpl));
        if (ResidentialServices.hasOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING)) {
            type.setBetreutesWohnen(Boolean.valueOf(true));
        }
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            type.setEinbaukueche(Boolean.valueOf(true));
        }
        type.setEnergieausweis(this.writeEnergieausweis(estateImpl));
        type.setEtagenzahl(CountFloors.getAsLong((EstateImpl)estateImpl));
        type.setFoerderung(WbsRequired.get((EstateImpl)estateImpl));
        type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getFreiAb())) {
            type.setFreiAb(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            type.setGaesteWC(Boolean.valueOf(true));
        }
        type.setGartenBenutzung(GardenUse.get((EstateImpl)estateImpl));
        type.setHaustiere(this.writeHaustiere(estateImpl));
        type.setHeizungsart(this.writeHeizungsart(estateImpl));
        type.setJahrLetzteModernisierung(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        type.setKeller(Basement.get((EstateImpl)estateImpl));
        type.setMietpreise(FACTORY.createVermarktungWohnMieteTyp());
        type.getMietpreise().setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)type.getMietpreise().getKaution())) {
            type.getMietpreise().setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        type.getMietpreise().setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setStellplatzMiete(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        type.getMietpreise().setWarmmiete(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        type.getMietpreise().setHeizkostenInWarmmieteEnthalten(bl);
        BigDecimal bigDecimal2 = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 && bl != null) {
            type.getMietpreise().setHeizkosten(bigDecimal2);
        }
        type.setNutzflaeche(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        type.setObjektzustand(this.writeObjektZustand(estateImpl));
        type.setParkplatz(this.writeStellplatzKategorie(estateImpl));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            type.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        type.setWohnungKategorie(this.writeKategorieWohnung(list));
        type.setZimmer(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        Number number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number != null) {
            type.setEtage(Long.valueOf(number.longValue()));
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        type.setWohnflaeche(bigDecimal);
        if (type.getWohnflaeche() == null || type.getWohnflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Wohnflaeche' nicht angegeben (f\u00fcr WohnungMiete)!");
        }
        if (type.getZimmer() == null || type.getZimmer().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Zimmer' nicht angegeben (f\u00fcr WohnungMiete)!");
        }
        if (type.getMietpreise() == null) {
            list2.add("IS24-Pflichtfeld 'Mietpreise' nicht angegeben (f\u00fcr WohnungMiete)!");
        } else {
            BigDecimal bigDecimal3 = type.getMietpreise().getKaltmiete();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
                list2.add("IS24-Pflichtfeld 'Mietpreise/Kaltmiete' nicht angegeben (f\u00fcr WohnungMiete)!");
            }
        }
        return list2.isEmpty() ? FACTORY.createWohnungMiete(type) : null;
    }

    protected Zwangsversteigerung convertEstate(EstateImpl estateImpl, Zwangsversteigerung.Type type, List<OpenEstateType> list, List<String> list2) {
        type.setAenderungsdatum(AuctionModificationDate.getAsCalendar((EstateImpl)estateImpl));
        type.setAufhebungsdatum(AuctionCancellationDate.getAsCalendar((EstateImpl)estateImpl));
        type.setEigentuemer(Owner.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        type.setErfassungsdatum(AuctionRecordationDate.getAsCalendar((EstateImpl)estateImpl));
        type.setGrundbuchblattnummer(LandRegisterNr.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        type.setPreis(MarketValue.getAsBigDecimal((EstateImpl)estateImpl));
        type.setAmtsgericht(FACTORY.createAmtsgerichtTyp());
        type.getAmtsgericht().setAktenzeichen(CountryCourtFileReference.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        type.getAmtsgericht().setValue(CountryCourtName.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        AreaValue areaValue = estateImpl.getPrimaryAreaValue();
        if (areaValue != null) {
            type.setGesamtflaeche(AreaValue.convert((AreaValue)areaValue, (AreaValue.Unit)AreaValue.Unit.SQM));
        } else {
            type.setGesamtflaeche(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        }
        if (list.contains(OpenEstateType.HOUSE)) {
            type.setObjektart(ZwangsversteigerungKategorieTyp.EFH_MFH);
        } else if (list.contains(OpenEstateType.RESIDENCE)) {
            type.setObjektart(ZwangsversteigerungKategorieTyp.EIGENTUMSWOHNUNG);
        } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            type.setObjektart(ZwangsversteigerungKategorieTyp.GRUNDSTUECK);
        } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL) || Usage.hasOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.COMMERCIAL)) {
            type.setObjektart(ZwangsversteigerungKategorieTyp.GEWERBE_ANLAGE);
        } else {
            type.setObjektart(ZwangsversteigerungKategorieTyp.GARAGE_SONSTIGES);
        }
        type.setVersteigerungstermin(FACTORY.createVersteigerungsterminTyp());
        type.getVersteigerungstermin().setTeilungsversteigerung(AuctionSplitted.get((EstateImpl)estateImpl));
        type.getVersteigerungstermin().setValue(AuctionDate.getAsCalendar((EstateImpl)estateImpl));
        type.getVersteigerungstermin().setWiederholungstermin(AuctionRepeated.get((EstateImpl)estateImpl));
        if (type.getGesamtflaeche().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Gesamtflaeche' nicht angegeben (f\u00fcr Zwangsversteigerung)!");
        }
        if (type.getVersteigerungstermin() == null || type.getVersteigerungstermin().getValue() == null) {
            list2.add("IS24-Pflichtfeld 'Versteigerungstermin' nicht angegeben (f\u00fcr Zwangsversteigerung)!");
        }
        if (type.getPreis() == null) {
            list2.add("IS24-Pflichtfeld 'Preis' nicht angegeben (f\u00fcr Zwangsversteigerung)!");
        }
        return list2.isEmpty() ? FACTORY.createZwangsversteigerung(type) : null;
    }

    protected IS24ImmobilienTransfer convertToXmlObject(AgencyImpl agencyImpl) {
        ImmobilienTransferTyp immobilienTransferTyp = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("no agency was provided!");
        } else {
            ImmobilienTransferTyp.Anbieter anbieter = this.convertAgent(agencyImpl.getAgent());
            for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
                try {
                    String string = estateImpl.getContactId();
                    AgentContactImpl agentContactImpl = string != null && agencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)agencyImpl.getContacts().get(string) : this.createEmptyContact();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    JAXBElement jAXBElement = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setImportmodus(AktionsTyp.AKTUALISIEREN);
                    anbieter.getImmobilie().add(jAXBElement);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            immobilienTransferTyp.setAnbieter(anbieter);
        }
        return FACTORY.createIS24ImmobilienTransfer(immobilienTransferTyp);
    }

    protected IS24ImmobilienTransfer convertToXmlObject(TransferImpl transferImpl) {
        ImmobilienTransferTyp immobilienTransferTyp = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn("no transferable agent found!");
        } else {
            JAXBElement jAXBElement;
            Object object;
            String string;
            TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
            ImmobilienTransferTyp.Anbieter anbieter = this.convertAgent(transferAgencyImpl.getAgent());
            for (Object object2 : transferAgencyImpl.getEstatesToSave()) {
                try {
                    string = object2.getContactId();
                    object = transferAgencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)transferAgencyImpl.getContacts().get(string) : this.createEmptyContact();
                    jAXBElement = new ArrayList();
                    JAXBElement jAXBElement2 = this.convertEstate((EstateImpl)object2, transferAgencyImpl.getAgent(), (AgentContactImpl)object, (List<String>)jAXBElement);
                    if (!jAXBElement.isEmpty()) {
                        this.putErrors(object2.getId(), (List)jAXBElement);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement2.getValue()).setImportmodus(AktionsTyp.AKTUALISIEREN);
                    anbieter.getImmobilie().add(jAXBElement2);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            for (Object object2 : transferAgencyImpl.getEstateIdsToRemove()) {
                try {
                    string = this.createEmptyEstate();
                    string.setId((String)object2);
                    string.setCurrency(Currency.getInstance(Locale.GERMANY));
                    string.getAddress().setPostalCode("13125");
                    string.getAddress().setCity("Berlin");
                    string.getAddress().setCountry(Locale.GERMANY.getCountry());
                    string.setType(OpenEstateType.GENERAL_PARKING, OpenEstateAction.PURCHASE);
                    string.putAttribute((AbstractAttribImpl)new PurchasePrice((Number)99999.0, string.getCurrency()));
                    object = new ArrayList();
                    jAXBElement = this.convertEstate((EstateImpl)string, transferAgencyImpl.getAgent(), null, (List<String>)object);
                    if (!object.isEmpty()) {
                        this.putErrors(string.getId(), (List)object);
                        continue;
                    }
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setImportmodus(AktionsTyp.LOESCHEN);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusHP(StatusTyp.INAKTIV);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusIS24(StatusTyp.INAKTIV);
                    ((ImmobilieBaseTyp)jAXBElement.getValue()).setStatusVBM(StatusTyp.INAKTIV);
                    anbieter.getImmobilie().add(jAXBElement);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            immobilienTransferTyp.setAnbieter(anbieter);
        }
        return FACTORY.createIS24ImmobilienTransfer(immobilienTransferTyp);
    }

    protected Is24XmlDocument createXmlDocument(IS24ImmobilienTransfer iS24ImmobilienTransfer) throws ParserConfigurationException, JAXBException {
        return Is24XmlDocument.newDocument((IS24ImmobilienTransfer)iS24ImmobilienTransfer);
    }

    protected ImmobilienTransferTyp createRoot() {
        ImmobilienTransferTyp immobilienTransferTyp = FACTORY.createImmobilienTransferTyp();
        immobilienTransferTyp.setAnbieter(new ImmobilienTransferTyp.Anbieter());
        immobilienTransferTyp.setEmailBeiFehler("webmaster@immobilienscout24.de");
        immobilienTransferTyp.setErstellerSoftware("OpenEstate-DevUtils");
        immobilienTransferTyp.setErstellerSoftwareVersion("1.0");
        return immobilienTransferTyp;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    protected AusstattungsqualitaetsTyp writeAustattungsQualitaet(EstateImpl estateImpl) {
        Equipment.Option option = Equipment.get((EstateImpl)estateImpl);
        if (Equipment.Option.BASIC.equals((Object)option)) {
            return AusstattungsqualitaetsTyp.EINFACH;
        }
        if (Equipment.Option.EXCLUSIVE.equals((Object)option)) {
            return AusstattungsqualitaetsTyp.GEHOBEN;
        }
        if (Equipment.Option.LUXURY.equals((Object)option)) {
            return AusstattungsqualitaetsTyp.LUXUS;
        }
        if (Equipment.Option.STANDARD.equals((Object)option)) {
            return AusstattungsqualitaetsTyp.NORMAL;
        }
        return null;
    }

    protected BauphaseTyp writeBauphase(EstateImpl estateImpl) {
        ConstructionPhase.Option option = ConstructionPhase.get((EstateImpl)estateImpl);
        if (ConstructionPhase.Option.COMPLETED.equals((Object)option)) {
            return BauphaseTyp.HAUS_FERTIG_GESTELLT;
        }
        if (ConstructionPhase.Option.UNDER_CONSTRUCTION.equals((Object)option)) {
            return BauphaseTyp.HAUS_IM_BAU;
        }
        if (ConstructionPhase.Option.PLANNED.equals((Object)option)) {
            return BauphaseTyp.HAUS_IN_PLANUNG;
        }
        return BauphaseTyp.KEINE_ANGABE;
    }

    protected GrundstueckGewerbeEmpfohleneNutzung writeBebaubarMitGewerbe(EstateImpl estateImpl) {
        List list = BuildableWith.getAsList((EstateImpl)estateImpl);
        GrundstueckGewerbeEmpfohleneNutzung grundstueckGewerbeEmpfohleneNutzung = null;
        if (list.contains(BuildableWith.Option.FARMLAND)) {
            grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            grundstueckGewerbeEmpfohleneNutzung.setAckerland(FACTORY.createGrundstueckEmpfohleneNutzungAckerland(null));
        }
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setBauerwartungsland(FACTORY.createGrundstueckEmpfohleneNutzungBauerwartungsland(null));
        }
        if (list.contains(BuildableWith.Option.JETTY)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setBootsstaende(FACTORY.createGrundstueckEmpfohleneNutzungBootsstaende(null));
        }
        if (list.contains(BuildableWith.Option.OFFICE)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setBuero(FACTORY.createGrundstueckEmpfohleneNutzungBuero(null));
        }
        if (list.contains(BuildableWith.Option.CAMPING)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setCamping(FACTORY.createGrundstueckEmpfohleneNutzungCamping(null));
        }
        if (list.contains(BuildableWith.Option.RETAIL_LARGE)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setEinzelhandelGross(FACTORY.createGrundstueckEmpfohleneNutzungEinzelhandelGross(null));
        }
        if (list.contains(BuildableWith.Option.RETAIL_SMALL)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setEinzelhandelKlein(FACTORY.createGrundstueckEmpfohleneNutzungEinzelhandelKlein(null));
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setGaragen(FACTORY.createGrundstueckEmpfohleneNutzungGaragen(null));
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setGarten(FACTORY.createGrundstueckEmpfohleneNutzungGarten(null));
        }
        if (list.contains(BuildableWith.Option.GASTRONOMY)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setGastronomie(FACTORY.createGrundstueckEmpfohleneNutzungGastronomie(null));
        }
        if (list.contains(BuildableWith.Option.BUSINESS_BIG)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setGewerbe(FACTORY.createGrundstueckEmpfohleneNutzungGewerbe(null));
        }
        if (list.contains(BuildableWith.Option.HOTEL)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setHotel(FACTORY.createGrundstueckEmpfohleneNutzungHotel(null));
        }
        if (list.contains(BuildableWith.Option.INDUSTRY)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setIndustrie(FACTORY.createGrundstueckEmpfohleneNutzungIndustrie(null));
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setKeineBebauung(FACTORY.createGrundstueckEmpfohleneNutzungKeineBebauung(null));
        }
        if (list.contains(BuildableWith.Option.BUSINESS_SMALL)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setKleingewerbe(FACTORY.createGrundstueckEmpfohleneNutzungKleingewerbe(null));
        }
        if (list.contains(BuildableWith.Option.WAREHOUSE)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setLager(FACTORY.createGrundstueckEmpfohleneNutzungLager(null));
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setObstpflanzung(FACTORY.createGrundstueckEmpfohleneNutzungObstpflanzung(null));
        }
        if (list.contains(BuildableWith.Option.PARKING_STRUCTURE)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setParkhaus(FACTORY.createGrundstueckEmpfohleneNutzungParkhaus(null));
        }
        if (list.contains(BuildableWith.Option.PRODUCTION)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setProduktion(FACTORY.createGrundstueckEmpfohleneNutzungProduktion(null));
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            if (grundstueckGewerbeEmpfohleneNutzung == null) {
                grundstueckGewerbeEmpfohleneNutzung = FACTORY.createGrundstueckGewerbeEmpfohleneNutzung();
            }
            grundstueckGewerbeEmpfohleneNutzung.setWald(FACTORY.createGrundstueckEmpfohleneNutzungWald(null));
        }
        return grundstueckGewerbeEmpfohleneNutzung;
    }

    protected GrundstueckWohnenEmpfohleneNutzung writeBebaubarMitWohnen(EstateImpl estateImpl) {
        List list = BuildableWith.getAsList((EstateImpl)estateImpl);
        GrundstueckWohnenEmpfohleneNutzung grundstueckWohnenEmpfohleneNutzung = null;
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            grundstueckWohnenEmpfohleneNutzung.setBauerwartungsland(FACTORY.createGrundstueckEmpfohleneNutzungBauerwartungsland(null));
        }
        if (list.contains(BuildableWith.Option.DUPLEX_HOUSE)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setDoppelhaus(FACTORY.createGrundstueckEmpfohleneNutzungDoppelhaus(null));
        }
        if (list.contains(BuildableWith.Option.SINGLE_FAMILY_HOUSE)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setEinfamilienhaus(FACTORY.createGrundstueckEmpfohleneNutzungEinfamilienhaus(null));
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setGaragen(FACTORY.createGrundstueckEmpfohleneNutzungGaragen(null));
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setGarten(FACTORY.createGrundstueckEmpfohleneNutzungGarten(null));
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setKeineBebauung(FACTORY.createGrundstueckEmpfohleneNutzungKeineBebauung(null));
        }
        if (list.contains(BuildableWith.Option.MULTI_FAMILY_HOUSE)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setMehrfamilienhaus(FACTORY.createGrundstueckEmpfohleneNutzungMehrfamilienhaus(null));
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setObstpflanzung(FACTORY.createGrundstueckEmpfohleneNutzungObstpflanzung(null));
        }
        if (list.contains(BuildableWith.Option.TERRACED_HOUSE)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setReihenhaus(FACTORY.createGrundstueckEmpfohleneNutzungReihenhaus(null));
        }
        if (list.contains(BuildableWith.Option.CAR_PARKING_SPACES)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setStellplaetze(FACTORY.createGrundstueckEmpfohleneNutzungStellplaetze(null));
        }
        if (list.contains(BuildableWith.Option.VILLA)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setVilla(FACTORY.createGrundstueckEmpfohleneNutzungVilla(null));
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            if (grundstueckWohnenEmpfohleneNutzung == null) {
                grundstueckWohnenEmpfohleneNutzung = FACTORY.createGrundstueckWohnenEmpfohleneNutzung();
            }
            grundstueckWohnenEmpfohleneNutzung.setWald(FACTORY.createGrundstueckEmpfohleneNutzungWald(null));
        }
        return grundstueckWohnenEmpfohleneNutzung;
    }

    protected BebaubarNachTyp writeBebaubarNach(EstateImpl estateImpl) {
        BuildableAccordingTo.Option option = BuildableAccordingTo.get((EstateImpl)estateImpl);
        if (BuildableAccordingTo.Option.BINDING_SITE_PLAN.equals((Object)option)) {
            return BebaubarNachTyp.BAUGB_30;
        }
        if (BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT.equals((Object)option)) {
            return BebaubarNachTyp.BAUGB_34;
        }
        if (BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT.equals((Object)option)) {
            return BebaubarNachTyp.BAUGB_35;
        }
        return null;
    }

    protected BefeuerungsArtTyp writeBefeuerung(EstateImpl estateImpl) {
        List list = TypeOfBeaconing.getAsList((EstateImpl)estateImpl);
        BefeuerungsArtTyp befeuerungsArtTyp = null;
        if (list.contains(TypeOfBeaconing.Option.ELECTRICS)) {
            befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            befeuerungsArtTyp.setStrom(FACTORY.createBefeuerungsArtTypStrom(null));
        }
        if (list.contains(TypeOfBeaconing.Option.GEOTHERMICS)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setErdwaerme(FACTORY.createBefeuerungsArtTypErdwaerme(null));
        }
        if (list.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setFernwaerme(FACTORY.createBefeuerungsArtTypFernwaerme(null));
        }
        if (list.contains(TypeOfBeaconing.Option.GAS)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setGas(FACTORY.createBefeuerungsArtTypGas(null));
        }
        if (list.contains(TypeOfBeaconing.Option.COAL)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setKohle(FACTORY.createBefeuerungsArtTypKohle(null));
        }
        if (list.contains(TypeOfBeaconing.Option.OIL)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setOel(FACTORY.createBefeuerungsArtTypOel(null));
        }
        if (list.contains(TypeOfBeaconing.Option.PELLETS)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setPelletheizung(FACTORY.createBefeuerungsArtTypPelletheizung(null));
        }
        if (list.contains(TypeOfBeaconing.Option.SOLAR)) {
            if (befeuerungsArtTyp == null) {
                befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            }
            befeuerungsArtTyp.setSolarheizung(FACTORY.createBefeuerungsArtTypSolarheizung(null));
        }
        if (befeuerungsArtTyp == null) {
            befeuerungsArtTyp = FACTORY.createBefeuerungsArtTyp();
            befeuerungsArtTyp.setKeineAngabe(FACTORY.createBefeuerungsArtTypKeineAngabe(null));
        }
        return befeuerungsArtTyp;
    }

    protected BodenbelagTyp writeBodenbelag(EstateImpl estateImpl) {
        List list = FlooringMaterial.getAsList((EstateImpl)estateImpl);
        if (list.contains(FlooringMaterial.Option.CONCRETE)) {
            return BodenbelagTyp.BETON;
        }
        if (list.contains(FlooringMaterial.Option.FLOOR_BOARDS) || list.contains(FlooringMaterial.Option.FLOOR_BOARDS_POLISHED)) {
            return BodenbelagTyp.DIELEN;
        }
        if (list.contains(FlooringMaterial.Option.EPOXY_RESIN)) {
            return BodenbelagTyp.EPOXIDHARZ;
        }
        if (list.contains(FlooringMaterial.Option.TILES) || list.contains(FlooringMaterial.Option.CERAMIC) || list.contains(FlooringMaterial.Option.TERRACOTTA)) {
            return BodenbelagTyp.FLIESEN;
        }
        if (list.contains(FlooringMaterial.Option.LAMINATE)) {
            return BodenbelagTyp.LAMINAT;
        }
        if (list.contains(FlooringMaterial.Option.PARQUET)) {
            return BodenbelagTyp.PARKETT;
        }
        if (list.contains(FlooringMaterial.Option.PVC)) {
            return BodenbelagTyp.PVC;
        }
        if (list.contains(FlooringMaterial.Option.STONE) || list.contains(FlooringMaterial.Option.GRANITE) || list.contains(FlooringMaterial.Option.MARBLE) || list.contains(FlooringMaterial.Option.SLATE)) {
            return BodenbelagTyp.STEIN;
        }
        if (list.contains(FlooringMaterial.Option.CARPET)) {
            return BodenbelagTyp.TEPPICHBODEN;
        }
        if (list.contains(FlooringMaterial.Option.CARPET_ANTISTATIC)) {
            return BodenbelagTyp.TEPPICHBODEN_ANTISTATISCH;
        }
        return BodenbelagTyp.KEINE_ANGABE;
    }

    protected BodenbelagWohnenTyp writeBodenbelagWohnen(EstateImpl estateImpl) {
        List list = FlooringMaterial.getAsList((EstateImpl)estateImpl);
        if (list.contains(FlooringMaterial.Option.FLOOR_BOARDS) || list.contains(FlooringMaterial.Option.FLOOR_BOARDS_POLISHED)) {
            return BodenbelagWohnenTyp.DIELEN;
        }
        if (list.contains(FlooringMaterial.Option.TILES) || list.contains(FlooringMaterial.Option.CERAMIC) || list.contains(FlooringMaterial.Option.TERRACOTTA)) {
            return BodenbelagWohnenTyp.FLIESEN;
        }
        if (list.contains(FlooringMaterial.Option.LAMINATE)) {
            return BodenbelagWohnenTyp.LAMINAT;
        }
        if (list.contains(FlooringMaterial.Option.PARQUET)) {
            return BodenbelagWohnenTyp.PARKETT;
        }
        if (list.contains(FlooringMaterial.Option.PVC)) {
            return BodenbelagWohnenTyp.PVC;
        }
        if (list.contains(FlooringMaterial.Option.CARPET)) {
            return BodenbelagWohnenTyp.TEPPICHBODEN;
        }
        return BodenbelagWohnenTyp.KEINE_ANGABE;
    }

    protected DatenVerkabelungsTyp writeDatenverkabelung(EstateImpl estateImpl) {
        Boolean bl = Technics.hasOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        if (Boolean.TRUE.equals(bl)) {
            return DatenVerkabelungsTyp.JA;
        }
        return DatenVerkabelungsTyp.KEINE_ANGABE;
    }

    protected EnergieausweisTyp writeEnergieausweis(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        EnergieausweisTyp energieausweisTyp = FACTORY.createEnergieausweisTyp();
        energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.KEINE_ANGABE);
        Type.Option option = Type.get((EstateImpl)estateImpl);
        if (Type.Option.DEMAND.equals((Object)option)) {
            energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENDENERGIEBEDARF);
            energieausweisTyp.setEnergieverbrauchskennwert(DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (Type.Option.CONSUMPTION.equals((Object)option)) {
            energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
            energieausweisTyp.setEnergieverbrauchskennwert(ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            energieausweisTyp.setWarmwasserEnthalten(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        } else {
            BigDecimal bigDecimal = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            Boolean bl = Available.get((EstateImpl)estateImpl);
            if (Boolean.TRUE.equals(bl) && bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                energieausweisTyp.setEnergieausweistyp(EnergieausweistypTyp.ENERGIEVERBRAUCHSKENNWERT);
                energieausweisTyp.setEnergieverbrauchskennwert(bigDecimal);
                energieausweisTyp.setWarmwasserEnthalten(null);
            }
        }
        return energieausweisTyp;
    }

    protected ErschliessungszustandTyp writeErschliessungszustand(EstateImpl estateImpl) {
        Development.Option option = Development.get((EstateImpl)estateImpl);
        if (Development.Option.PARTIALLY.equals((Object)option)) {
            return ErschliessungszustandTyp.TEILERSCHLOSSEN;
        }
        if (Development.Option.UNDEVELOPED.equals((Object)option)) {
            return ErschliessungszustandTyp.UNERSCHLOSSEN;
        }
        if (Development.Option.COMPLETELY.equals((Object)option)) {
            return ErschliessungszustandTyp.ERSCHLOSSEN;
        }
        return ErschliessungszustandTyp.UNBEKANNT;
    }

    protected GeschlechtTyp writeGeschlecht(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        GenderOfRequestedFlatmates.Option option = GenderOfRequestedFlatmates.get((EstateImpl)estateImpl);
        if (GenderOfRequestedFlatmates.Option.FEMALE.equals((Object)option)) {
            return GeschlechtTyp.NUR_FRAUEN;
        }
        if (GenderOfRequestedFlatmates.Option.MALE.equals((Object)option)) {
            return GeschlechtTyp.NUR_MAENNER;
        }
        return null;
    }

    protected WGZimmerGeschlechtTyp writeGeschlechtWG(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return null;
        }
        GenderOfRequestedFlatmates.Option option = GenderOfRequestedFlatmates.get((EstateImpl)estateImpl);
        if (GenderOfRequestedFlatmates.Option.FEMALE.equals((Object)option)) {
            return WGZimmerGeschlechtTyp.WEIBLICH;
        }
        if (GenderOfRequestedFlatmates.Option.MALE.equals((Object)option)) {
            return WGZimmerGeschlechtTyp.MAENNLICH;
        }
        return null;
    }

    protected GenehmigungTyp writeHaustiere(EstateImpl estateImpl) {
        Pets.Option option = Pets.get((EstateImpl)estateImpl);
        if (Pets.Option.YES.equals((Object)option)) {
            return GenehmigungTyp.ERLAUBT;
        }
        if (Pets.Option.NO.equals((Object)option)) {
            return GenehmigungTyp.VERBOTEN;
        }
        if (Pets.Option.AS_APPOINTED.equals((Object)option)) {
            return GenehmigungTyp.NACH_VEREINBARUNG;
        }
        return GenehmigungTyp.KEINE_ANGABE;
    }

    protected HeizungsartTyp writeHeizungsart(EstateImpl estateImpl) {
        List list = TypeOfHeating.getAsList((EstateImpl)estateImpl);
        if (list.contains(TypeOfHeating.Option.SELF_CONTAINED_CENTRAL)) {
            return HeizungsartTyp.ETAGENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.OVEN)) {
            return HeizungsartTyp.OFENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.CENTRAL)) {
            return HeizungsartTyp.ZENTRALHEIZUNG;
        }
        return HeizungsartTyp.KEINE_ANGABE;
    }

    protected AnlageobjekteKategorieTyp writeKategorieAnlage(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.OFFICE_BUILDING.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.BUEROGEBAEUDE;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.EIGENTUMSWOHNUNG;
            }
            if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.EINFAMILIENHAUS;
            }
            if (OpenEstateType.SHOPPING_CENTER.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.EINKAUFSZENTRUM;
            }
            if (OpenEstateType.LEISURE_SPORTS_FACILITY.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.FREIZEITANLAGE;
            }
            if (OpenEstateType.GASTRONOMY.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.GASTSTAETTE;
            }
            if (OpenEstateType.COMMERCIAL_BUILDING.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.GESCHAEFTSHAUS;
            }
            if (OpenEstateType.COMMERCIAL_CENTER.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.GEWERBEANWESEN;
            }
            if (OpenEstateType.HALL_WAREHOUSE.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.HALLE_LAGER;
            }
            if (OpenEstateType.HOSTEL.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.HOTEL;
            }
            if (OpenEstateType.HOTEL.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.HOTEL;
            }
            if (OpenEstateType.PRODUCTION.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.INDUSTRIEANWESEN;
            }
            if (OpenEstateType.RETAIL.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.LADEN_VERKAUFSFLAECHE;
            }
            if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.MEHRFAMILIENHAUS;
            }
            if (OpenEstateType.SERVICE_CENTER.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.SERVICECENTER;
            }
            if (OpenEstateType.GENERAL_COMMERCIAL.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.SONSTIGE;
            }
            if (OpenEstateType.CONSUMER_STORE.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.SUPERMARKT;
            }
            if (OpenEstateType.HOUSING_COMPLEX.equals((Object)openEstateType)) {
                return AnlageobjekteKategorieTyp.WOHNANLAGE;
            }
            if (!OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING.equals((Object)openEstateType)) continue;
            return AnlageobjekteKategorieTyp.WOHN_GESCHAEFTSHAUS;
        }
        return AnlageobjekteKategorieTyp.SONSTIGE;
    }

    protected BueroPraxisKategorienTyp writeKategorieBueroPraxis(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.ATELIER.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.ATELIER;
            }
            if (OpenEstateType.OFFICE.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.BUERO;
            }
            if (OpenEstateType.OFFICE_BUILDING.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.BUEROHAUS;
            }
            if (OpenEstateType.OFFICE_CENTER.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.BUEROZENTRUM;
            }
            if (OpenEstateType.OFFICE_FLOOR.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.BUERO_ETAGE;
            }
            if (OpenEstateType.OFFICE_COMMERCIAL_BUILDING.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.BUERO_UND_GESCHAEFTSGEBAEUDE;
            }
            if (OpenEstateType.COMMERCIAL_CENTER.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.GEWERBE_ZENTRUM;
            }
            if (OpenEstateType.LOFT.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.LOFT;
            }
            if (OpenEstateType.SURGERY.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.PRAXIS;
            }
            if (OpenEstateType.SURGERY_FLOOR.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.PRAXIS_ETAGE;
            }
            if (OpenEstateType.DOCTORS_OFFICE_HOUSE.equals((Object)openEstateType)) {
                return BueroPraxisKategorienTyp.PRAXIS_HAUS;
            }
            if (!OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING.equals((Object)openEstateType)) continue;
            return BueroPraxisKategorienTyp.WOHN_UND_GESCHAEFTSGEBAEUDE;
        }
        return BueroPraxisKategorienTyp.KEINE_ANGABE;
    }

    protected EinzelhandelKategorienTyp writeKategorieEinzelhandel(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.AUSSTELLUNGSFLAECHE;
            }
            if (OpenEstateType.SHOPPING_CENTER.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.EINKAUFSZENTRUM;
            }
            if (OpenEstateType.DEPARTMENT_STORE.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.KAUFHAUS;
            }
            if (OpenEstateType.KIOSK.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.KIOSK;
            }
            if (OpenEstateType.SHOP.equals((Object)openEstateType) || OpenEstateType.STORE.equals((Object)openEstateType) || OpenEstateType.PREMISE.equals((Object)openEstateType) || OpenEstateType.OFFICE_COMMERCIAL_PREMISE.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.LADEN;
            }
            if (OpenEstateType.SELF_SERVICE_MARKET.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.SB_MARKT;
            }
            if (OpenEstateType.SALES_AREA.equals((Object)openEstateType)) {
                return EinzelhandelKategorienTyp.VERKAUFSFLAECHE;
            }
            if (!OpenEstateType.SHOWROOM.equals((Object)openEstateType)) continue;
            return EinzelhandelKategorienTyp.VERKAUFSHALLE;
        }
        return EinzelhandelKategorienTyp.KEINE_ANGABE;
    }

    protected GaragenKategorieTyp writeKategorieGarage(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.OUTDOOR_CAR_PARKING_SPACE.equals((Object)openEstateType)) {
                return GaragenKategorieTyp.AUSSENSTELLPLATZ;
            }
            if (OpenEstateType.CARPORT.equals((Object)openEstateType)) {
                return GaragenKategorieTyp.CARPORT;
            }
            if (OpenEstateType.DUPLEX_GARAGE.equals((Object)openEstateType)) {
                return GaragenKategorieTyp.DUPLEX;
            }
            if (OpenEstateType.GARAGE.equals((Object)openEstateType)) {
                return GaragenKategorieTyp.GARAGE;
            }
            if (OpenEstateType.CAR_PARK.equals((Object)openEstateType)) {
                return GaragenKategorieTyp.PARKHAUS;
            }
            if (!OpenEstateType.UNDERGROUND_CAR_PARK.equals((Object)openEstateType)) continue;
            return GaragenKategorieTyp.TIEFGARAGE;
        }
        return GaragenKategorieTyp.KEINE_ANGABE;
    }

    protected GastroKategorieTyp writeKategorieGastronomie(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.RESTAURANT_BAR.equals((Object)openEstateType)) {
                return GastroKategorieTyp.BARBETRIEB;
            }
            if (OpenEstateType.BISTRO_CAFE.equals((Object)openEstateType)) {
                return GastroKategorieTyp.CAFFEE;
            }
            if (OpenEstateType.DISCOTHEQUE.equals((Object)openEstateType)) {
                return GastroKategorieTyp.DISKOTHEK;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return GastroKategorieTyp.FERIENBUNGALOW;
            }
            if (OpenEstateType.HOSPITALITY_INDUSTRY.equals((Object)openEstateType)) {
                return GastroKategorieTyp.GAESTEHAUS;
            }
            if (OpenEstateType.HOSTEL.equals((Object)openEstateType)) {
                return GastroKategorieTyp.HOTEL;
            }
            if (OpenEstateType.HOTEL.equals((Object)openEstateType)) {
                return GastroKategorieTyp.HOTEL;
            }
            if (OpenEstateType.GUESTHOUSE.equals((Object)openEstateType)) {
                return GastroKategorieTyp.PENSION;
            }
            if (!OpenEstateType.RESTAURANT.equals((Object)openEstateType)) continue;
            return GastroKategorieTyp.RESTAURANT;
        }
        return GastroKategorieTyp.GASTSTAETTE;
    }

    protected GrundstueckGewerbeKategorienTyp writeKategorieGrundstueckGewerbe(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.LEISURE_GROUND.equals((Object)openEstateType)) {
                return GrundstueckGewerbeKategorienTyp.FREIZEIT;
            }
            if (OpenEstateType.COMMERCIAL_GROUND.equals((Object)openEstateType)) {
                return GrundstueckGewerbeKategorienTyp.GEWERBE;
            }
            if (!OpenEstateType.AGRICULTURAL_FORESTRY_GROUND.equals((Object)openEstateType)) continue;
            return GrundstueckGewerbeKategorienTyp.LAND_FORSTWIRTSCHAFT;
        }
        return GrundstueckGewerbeKategorienTyp.GEWERBE;
    }

    protected HalleProduktionKategorieTyp writeKategorieHalleProduktion(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.AUSSTELLUNGSFLAECHE;
            }
            if (OpenEstateType.HALL_WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.HALLE;
            }
            if (OpenEstateType.HIGH_RACK_WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.HOCHREGALLAGER;
            }
            if (OpenEstateType.INDUSTRIAL_WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.INDUSTRIEHALLE;
            }
            if (OpenEstateType.INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.INDUSTRIEHALLE_MIT_FREIFLAECHE;
            }
            if (OpenEstateType.COOLING_HOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.KUEHLHAUS;
            }
            if (OpenEstateType.COLD_STORAGE_WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.KUEHLREGALLAGER;
            }
            if (OpenEstateType.STORAGE_AREA.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.LAGERFLAECHE;
            }
            if (OpenEstateType.WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.LAGERHALLE;
            }
            if (OpenEstateType.SERVICE_AREA.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.SERVICEFLAECHE;
            }
            if (OpenEstateType.FORWARDING_WAREHOUSE.equals((Object)openEstateType)) {
                return HalleProduktionKategorieTyp.SPEDITIONSLAGER;
            }
            if (!OpenEstateType.WORKSHOP.equals((Object)openEstateType)) continue;
            return HalleProduktionKategorieTyp.WERKSTATT;
        }
        return HalleProduktionKategorieTyp.KEINE_ANGABE;
    }

    protected HausKategorienTyp writeKategorieHaus(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.FARMHOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.BAUERNHAUS;
            }
            if (OpenEstateType.SPECIAL_HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.BESONDERE_IMMOBILIE;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return HausKategorienTyp.BUNGALOW;
            }
            if (OpenEstateType.CASTLE.equals((Object)openEstateType) || OpenEstateType.PALACE.equals((Object)openEstateType)) {
                return HausKategorienTyp.BURG_SCHLOSS;
            }
            if (OpenEstateType.SEMIDETACHED_HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.DOPPELHAUSHAELFTE;
            }
            if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.EINFAMILIENHAUS;
            }
            if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.MEHRFAMILIENHAUS;
            }
            if (OpenEstateType.TERRACED_HOUSE_CORNERSIDE.equals((Object)openEstateType)) {
                return HausKategorienTyp.REIHENECKHAUS;
            }
            if (OpenEstateType.TERRACED_HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.REIHENHAUS;
            }
            if (OpenEstateType.TERRACED_HOUSE_MIDDLE.equals((Object)openEstateType)) {
                return HausKategorienTyp.REIHENMITTELHAUS;
            }
            if (OpenEstateType.HOUSE.equals((Object)openEstateType)) {
                return HausKategorienTyp.SONSTIGES;
            }
            if (OpenEstateType.VILLA.equals((Object)openEstateType)) {
                return HausKategorienTyp.VILLA;
            }
            if (!OpenEstateType.TWO_FAMILY_HOUSE.equals((Object)openEstateType) && !OpenEstateType.DUPLEX_HOUSE.equals((Object)openEstateType)) continue;
            return HausKategorienTyp.ZWEIFAMILIENHAUS;
        }
        return HausKategorienTyp.KEINE_ANGABE;
    }

    protected SonstigeGewerbeKategorieTyp writeKategorieSonstigesGewerbe(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.FARM.equals((Object)openEstateType)) {
                return SonstigeGewerbeKategorieTyp.BAUERNHOF;
            }
            if (OpenEstateType.LEISURE_SPORTS_FACILITY.equals((Object)openEstateType)) {
                return SonstigeGewerbeKategorieTyp.FREIZEITANLAGE;
            }
            if (OpenEstateType.GENERAL_COMMERCIAL.equals((Object)openEstateType)) {
                return SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE;
            }
            if (OpenEstateType.RIDING_ESTATE.equals((Object)openEstateType)) {
                return SonstigeGewerbeKategorieTyp.REITERHOF;
            }
            if (OpenEstateType.VINICULTURE.equals((Object)openEstateType)) {
                return SonstigeGewerbeKategorieTyp.WEINGUT;
            }
            if (!OpenEstateType.WORKSHOP.equals((Object)openEstateType)) continue;
            return SonstigeGewerbeKategorieTyp.WERKSTATT;
        }
        return SonstigeGewerbeKategorieTyp.GEWERBEFLAECHE;
    }

    protected WazKategorienTyp writeKategorieWaz(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.APARTMENT.equals((Object)openEstateType)) {
                return WazKategorienTyp.APPARTMENT;
            }
            if (OpenEstateType.HOUSE.equals((Object)openEstateType)) {
                return WazKategorienTyp.HAUS;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return WazKategorienTyp.WOHNUNG;
            }
            if (!OpenEstateType.ROOM.equals((Object)openEstateType)) continue;
            return WazKategorienTyp.ZIMMER;
        }
        return WazKategorienTyp.WOHNUNG;
    }

    protected WohnungKategorienTyp writeKategorieWohnung(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.ATTIC_APARTMENT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.DACHGESCHOSS;
            }
            if (OpenEstateType.GROUND_FLOOR_APARTMENT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.ERDGESCHOSS;
            }
            if (OpenEstateType.HIGHER_FLOOR_APARTMENT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.ETAGENWOHNUNG;
            }
            if (OpenEstateType.MEZZANINE.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.HOCHPARTERRE;
            }
            if (OpenEstateType.LOFT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.LOFT;
            }
            if (OpenEstateType.MAISONETTE.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.MAISONETTE;
            }
            if (OpenEstateType.PENTHOUSE_APARTMENT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.PENTHOUSE;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.SONSTIGE;
            }
            if (OpenEstateType.SOUTERRAIN_APARTMENT.equals((Object)openEstateType)) {
                return WohnungKategorienTyp.SOUTERRAIN;
            }
            if (!OpenEstateType.TERRACE_APARTMENT.equals((Object)openEstateType)) continue;
            return WohnungKategorienTyp.TERRASSENWOHNUNG;
        }
        return WohnungKategorienTyp.KEINE_ANGABE;
    }

    protected JaNeinVereinbarungTyp writeKlimatisiert(EstateImpl estateImpl) {
        Boolean bl = AirConditioned.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            return JaNeinVereinbarungTyp.JA;
        }
        if (Boolean.FALSE.equals(bl)) {
            return JaNeinVereinbarungTyp.NEIN;
        }
        return JaNeinVereinbarungTyp.KEINE_ANGABE;
    }

    protected HebeanlageTyp writeKranbahn(EstateImpl estateImpl) {
        HebeanlageTyp hebeanlageTyp = null;
        if (Boolean.TRUE.equals(Crane.get((EstateImpl)estateImpl))) {
            hebeanlageTyp = FACTORY.createHebeanlageTyp();
            hebeanlageTyp.setTragkraft(CraneLiftingCapacity.getAsBigDecimal((EstateImpl)estateImpl));
        }
        return hebeanlageTyp;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    protected Boolean writeKueche(EstateImpl estateImpl) {
        List list = Kitchen.getAsList((EstateImpl)estateImpl);
        return !list.isEmpty() ? Boolean.valueOf(true) : null;
    }

    protected LageartTyp writeLageArt(EstateImpl estateImpl) {
        CommercialZone.Option option = CommercialZone.get((EstateImpl)estateImpl);
        if (CommercialZone.Option.LOCATION_A.equals((Object)option) || CommercialZone.Option.LOCATION_1A.equals((Object)option) || CommercialZone.Option.LOCATION_2A.equals((Object)option)) {
            return LageartTyp.A_LAGE;
        }
        if (CommercialZone.Option.LOCATION_B.equals((Object)option) || CommercialZone.Option.LOCATION_1B.equals((Object)option) || CommercialZone.Option.LOCATION_2B.equals((Object)option)) {
            return LageartTyp.B_LAGE;
        }
        if (CommercialZone.Option.SHOPPING_CENTER.equals((Object)option)) {
            return LageartTyp.EINKAUFSZENTRUM;
        }
        return LageartTyp.KEINE_ANGABE;
    }

    protected HebeanlageTyp writeLastenaufzug(EstateImpl estateImpl) {
        HebeanlageTyp hebeanlageTyp = null;
        if (Boolean.TRUE.equals(FreightElevator.get((EstateImpl)estateImpl))) {
            hebeanlageTyp = FACTORY.createHebeanlageTyp();
            hebeanlageTyp.setTragkraft(FreightElevatorCapacity.getAsBigDecimal((EstateImpl)estateImpl));
        }
        return hebeanlageTyp;
    }

    protected MobilarTyp writeMobilar(EstateImpl estateImpl) {
        Furnished.Option option = Furnished.get((EstateImpl)estateImpl);
        if (Furnished.Option.YES.equals((Object)option)) {
            return MobilarTyp.JA;
        }
        if (Furnished.Option.NO.equals((Object)option)) {
            return MobilarTyp.NEIN;
        }
        return MobilarTyp.KEINE_ANGABE;
    }

    protected ObjektZustandTyp writeObjektZustand(EstateImpl estateImpl) {
        ConditionType.Option option = ConditionType.get((EstateImpl)estateImpl);
        if (ConditionType.Option.CONDEMNED.equals((Object)option)) {
            return ObjektZustandTyp.ABBRUCHREIF;
        }
        if (ConditionType.Option.EXCELLENT.equals((Object)option)) {
            return ObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option)) {
            return ObjektZustandTyp.ERSTBEZUG;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option)) {
            return ObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG;
        }
        if (ConditionType.Option.WELL_TENDED.equals((Object)option)) {
            return ObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.GOOD.equals((Object)option)) {
            return ObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.MODERNIZED.equals((Object)option)) {
            return ObjektZustandTyp.MODERNISIERT;
        }
        if (ConditionType.Option.AS_APPOINTED.equals((Object)option)) {
            return ObjektZustandTyp.NACH_VEREINBARUNG;
        }
        if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option)) {
            return ObjektZustandTyp.NEUWERTIG;
        }
        if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option)) {
            return ObjektZustandTyp.VOLLSTAENDIG_REONVIERT;
        }
        if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option)) {
            return ObjektZustandTyp.RENOVIERUNGSBEDUERFTIG;
        }
        if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option)) {
            return ObjektZustandTyp.UNRENOVIERT;
        }
        if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option)) {
            return ObjektZustandTyp.SANIERT;
        }
        return ObjektZustandTyp.KEINE_ANGABE;
    }

    protected WazObjektZustandTyp writeObjektZustandWaz(EstateImpl estateImpl) {
        ConditionType.Option option = ConditionType.get((EstateImpl)estateImpl);
        if (ConditionType.Option.CONDEMNED.equals((Object)option)) {
            return WazObjektZustandTyp.ABBRUCHREIF;
        }
        if (ConditionType.Option.EXCELLENT.equals((Object)option)) {
            return WazObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option)) {
            return WazObjektZustandTyp.ERSTBEZUG;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option)) {
            return WazObjektZustandTyp.ERSTBEZUG_NACH_SANIERUNG;
        }
        if (ConditionType.Option.WELL_TENDED.equals((Object)option)) {
            return WazObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.GOOD.equals((Object)option)) {
            return WazObjektZustandTyp.GEPFLEGT;
        }
        if (ConditionType.Option.MODERNIZED.equals((Object)option)) {
            return WazObjektZustandTyp.MODERNISIERT;
        }
        if (ConditionType.Option.AS_APPOINTED.equals((Object)option)) {
            return WazObjektZustandTyp.NACH_VEREINBARUNG;
        }
        if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option)) {
            return WazObjektZustandTyp.NEUWERTIG;
        }
        if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option)) {
            return WazObjektZustandTyp.VOLLSTAENDIG_RENOVIERT;
        }
        if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option)) {
            return WazObjektZustandTyp.RENOVIERUNGSBEDUERFTIG;
        }
        if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option)) {
            return WazObjektZustandTyp.UNRENOVIERT;
        }
        if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option)) {
            return WazObjektZustandTyp.SANIERT;
        }
        return WazObjektZustandTyp.UNBEKANNT;
    }

    protected StellplatzKategorieTyp writeStellplatzKategorie(EstateImpl estateImpl) {
        List list = CarParkingType.getAsList((EstateImpl)estateImpl);
        if (list.contains(CarParkingType.Option.OUTDOOR)) {
            return StellplatzKategorieTyp.AUSSEN_STELLPLATZ;
        }
        if (list.contains(CarParkingType.Option.CARPORT)) {
            return StellplatzKategorieTyp.CARPORT;
        }
        if (list.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
            return StellplatzKategorieTyp.DUPLEX;
        }
        if (list.contains(CarParkingType.Option.GARAGE)) {
            return StellplatzKategorieTyp.GARAGE;
        }
        if (list.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
            return StellplatzKategorieTyp.PARKHAUS;
        }
        if (list.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
            return StellplatzKategorieTyp.TIEFGARAGE;
        }
        if (!list.isEmpty()) {
            return StellplatzKategorieTyp.TRUE;
        }
        return StellplatzKategorieTyp.KEINE_ANGABE;
    }

    protected RauchenTyp writeRauchen(EstateImpl estateImpl) {
        NonSmoker.Option option = NonSmoker.get((EstateImpl)estateImpl);
        if (NonSmoker.Option.YES.equals((Object)option)) {
            return RauchenTyp.UNERWUENSCHT;
        }
        if (NonSmoker.Option.NO.equals((Object)option)) {
            return RauchenTyp.ERLAUBT;
        }
        return RauchenTyp.KEINE_ANGABE;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    protected Boolean writeRaucherOk(EstateImpl estateImpl) {
        NonSmoker.Option option = NonSmoker.get((EstateImpl)estateImpl);
        if (NonSmoker.Option.YES.equals((Object)option)) {
            return false;
        }
        if (NonSmoker.Option.INDIFFERENT.equals((Object)option)) {
            return true;
        }
        if (NonSmoker.Option.NO.equals((Object)option)) {
            return true;
        }
        return null;
    }

    protected TVAnschlussTyp writeTvAnschluss(EstateImpl estateImpl) {
        List list = Technics.getAsList((EstateImpl)estateImpl);
        if (list.contains(Technics.Option.CABLE_SAT_TV)) {
            return TVAnschlussTyp.KABEL_UND_SATELLIT;
        }
        if (list.contains(Technics.Option.CABLE_TV)) {
            return TVAnschlussTyp.KABEL;
        }
        if (list.contains(Technics.Option.SAT_TV)) {
            return TVAnschlussTyp.SATELLIT;
        }
        return TVAnschlussTyp.KEINE_ANGABE;
    }

    protected VermarktungGewerbeTyp writeVermarktungGewerbe(EstateImpl estateImpl) {
        VermarktungGewerbeTyp vermarktungGewerbeTyp = FACTORY.createVermarktungGewerbeTyp();
        vermarktungGewerbeTyp.setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            VermarktungGewerbeTyp.Kauf kauf = FACTORY.createVermarktungGewerbeTypKauf();
            if (estateImpl.isHiddenPrices()) {
                kauf.setPreis(BigDecimal.ZERO);
            } else {
                kauf.setPreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
            }
            vermarktungGewerbeTyp.setKauf(FACTORY.createVermarktungGewerbeTypKauf(kauf));
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            VermarktungGewerbeTyp.Miete miete = FACTORY.createVermarktungGewerbeTypMiete();
            miete.setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
            if (StringUtils.isBlank((CharSequence)miete.getKaution())) {
                miete.setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            }
            if (estateImpl.isHiddenPrices()) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(BigDecimal.ZERO);
            } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES)) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
            } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA)) {
                miete.setPro(MieteEinheitTyp.QUADRATMETER);
                miete.setKaltmiete(RentExcludingServiceChargesPerArea.getAsBigDecimal((EstateImpl)estateImpl));
            }
            vermarktungGewerbeTyp.setMiete(FACTORY.createVermarktungGewerbeTypMiete(miete));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            VermarktungGewerbeTyp.Miete miete = FACTORY.createVermarktungGewerbeTypMiete();
            miete.setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
            if (StringUtils.isBlank((CharSequence)miete.getKaution())) {
                miete.setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            }
            if (estateImpl.isHiddenPrices()) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(BigDecimal.ZERO);
            } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_LEASE)) {
                miete.setPro(MieteEinheitTyp.MONAT);
                miete.setKaltmiete(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_LEASE_PER_AREA)) {
                miete.setPro(MieteEinheitTyp.QUADRATMETER);
                miete.setKaltmiete(LeasePerArea.getAsBigDecimal((EstateImpl)estateImpl));
            }
            vermarktungGewerbeTyp.setMiete(FACTORY.createVermarktungGewerbeTypMiete(miete));
        }
        return vermarktungGewerbeTyp;
    }

    protected VermarktungGewerbeTyp2 writeVermarktungGewerbe2(EstateImpl estateImpl) {
        VermarktungGewerbeTyp2 vermarktungGewerbeTyp2 = FACTORY.createVermarktungGewerbeTyp2();
        vermarktungGewerbeTyp2.setNebenkosten(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGewerbeTyp2.setPreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
            }
            vermarktungGewerbeTyp2.setKauf(FACTORY.createVermarktungGewerbeTyp2Kauf(null));
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGewerbeTyp2.setPreis(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGewerbeTyp2.Miete miete = FACTORY.createVermarktungGewerbeTyp2Miete();
            miete.setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
            if (StringUtils.isBlank((CharSequence)miete.getKaution())) {
                miete.setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            }
            vermarktungGewerbeTyp2.setMiete(miete);
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGewerbeTyp2.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGewerbeTyp2.setPreis(Lease.getAsBigDecimal((EstateImpl)estateImpl));
                vermarktungGewerbeTyp2.setPreisProParkflaeche(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGewerbeTyp2.Miete miete = FACTORY.createVermarktungGewerbeTyp2Miete();
            miete.setKaution(StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
            if (StringUtils.isBlank((CharSequence)miete.getKaution())) {
                miete.setKaution(DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            }
            vermarktungGewerbeTyp2.setMiete(miete);
        }
        return vermarktungGewerbeTyp2;
    }

    protected VermarktungGrundstueckGewerbeTyp writeVermarktungGrundstueckGewerbe(EstateImpl estateImpl) {
        VermarktungGrundstueckGewerbeTyp vermarktungGrundstueckGewerbeTyp = FACTORY.createVermarktungGrundstueckGewerbeTyp();
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Erbpacht erbpacht = FACTORY.createVermarktungGrundstueckGewerbeTypErbpacht();
            erbpacht.setDauerInJahren(EmphyteusisDuration.getAsLong((EstateImpl)estateImpl));
            vermarktungGrundstueckGewerbeTyp.setErbpacht(FACTORY.createVermarktungGrundstueckGewerbeTypErbpacht(erbpacht));
        } else if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Kauf kauf = FACTORY.createVermarktungGrundstueckGewerbeTypKauf();
            vermarktungGrundstueckGewerbeTyp.setKauf(FACTORY.createVermarktungGrundstueckGewerbeTypKauf(kauf));
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Miete miete = FACTORY.createVermarktungGrundstueckGewerbeTypMiete();
            vermarktungGrundstueckGewerbeTyp.setMiete(FACTORY.createVermarktungGrundstueckGewerbeTypMiete(miete));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckGewerbeTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckGewerbeTyp.setPreis(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckGewerbeTyp.Pacht pacht = FACTORY.createVermarktungGrundstueckGewerbeTypPacht();
            vermarktungGrundstueckGewerbeTyp.setPacht(FACTORY.createVermarktungGrundstueckGewerbeTypPacht(pacht));
        }
        return vermarktungGrundstueckGewerbeTyp;
    }

    protected VermarktungGrundstueckWohnenKaufTyp writeVermarktungGrundstueckWohnenKauf(EstateImpl estateImpl) {
        VermarktungGrundstueckWohnenKaufTyp vermarktungGrundstueckWohnenKaufTyp = FACTORY.createVermarktungGrundstueckWohnenKaufTyp();
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckWohnenKaufTyp.Erbpacht erbpacht = FACTORY.createVermarktungGrundstueckWohnenKaufTypErbpacht();
            erbpacht.setDauerInJahren(EmphyteusisDuration.getAsLong((EstateImpl)estateImpl));
            vermarktungGrundstueckWohnenKaufTyp.setErbpacht(FACTORY.createVermarktungGrundstueckWohnenKaufTypErbpacht(erbpacht));
        } else if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckWohnenKaufTyp.setPreis(PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckWohnenKaufTyp.Kauf kauf = FACTORY.createVermarktungGrundstueckWohnenKaufTypKauf();
            vermarktungGrundstueckWohnenKaufTyp.setKauf(FACTORY.createVermarktungGrundstueckWohnenKaufTypKauf(kauf));
        }
        return vermarktungGrundstueckWohnenKaufTyp;
    }

    protected VermarktungGrundstueckWohnenMieteTyp writeVermarktungGrundstueckWohnenMiete(EstateImpl estateImpl) {
        VermarktungGrundstueckWohnenMieteTyp vermarktungGrundstueckWohnenMieteTyp = FACTORY.createVermarktungGrundstueckWohnenMieteTyp();
        if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckWohnenMieteTyp.Miete miete = FACTORY.createVermarktungGrundstueckWohnenMieteTypMiete();
            vermarktungGrundstueckWohnenMieteTyp.setMiete(FACTORY.createVermarktungGrundstueckWohnenMieteTypMiete(miete));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            if (estateImpl.isHiddenPrices()) {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(BigDecimal.ZERO);
            } else {
                vermarktungGrundstueckWohnenMieteTyp.setPreis(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            }
            VermarktungGrundstueckWohnenMieteTyp.Pacht pacht = FACTORY.createVermarktungGrundstueckWohnenMieteTypPacht();
            vermarktungGrundstueckWohnenMieteTyp.setPacht(FACTORY.createVermarktungGrundstueckWohnenMieteTypPacht(pacht));
        }
        return vermarktungGrundstueckWohnenMieteTyp;
    }

    protected WGGroesse writeWgGroesse(EstateImpl estateImpl) {
        int n;
        Integer n2 = CountFlatmatesTotal.getAsInteger((EstateImpl)estateImpl);
        int n3 = n = n2 != null ? n2 : 0;
        if (n == 2) {
            return WGGroesse.PERSONS_02;
        }
        if (n == 3) {
            return WGGroesse.PERSONS_03;
        }
        if (n == 4) {
            return WGGroesse.PERSONS_04;
        }
        if (n == 5) {
            return WGGroesse.PERSONS_05;
        }
        if (n == 6) {
            return WGGroesse.PERSONS_06;
        }
        if (n == 7) {
            return WGGroesse.PERSONS_07;
        }
        if (n == 8) {
            return WGGroesse.PERSONS_08;
        }
        if (n == 9) {
            return WGGroesse.PERSONS_09;
        }
        if (n == 10) {
            return WGGroesse.PERSONS_10;
        }
        if (n > 10) {
            return WGGroesse.PERSONS_11_PLUS;
        }
        return null;
    }

    protected ZulieferungTyp writeZulieferung(EstateImpl estateImpl) {
        List list = SupplyAccess.getAsList((EstateImpl)estateImpl);
        if (list.contains(SupplyAccess.Option.DIRECT_ACCESS)) {
            return ZulieferungTyp.DIREKTER_ZUGANG;
        }
        if (list.contains(SupplyAccess.Option.ALL_DAY)) {
            return ZulieferungTyp.GANZTAEGIG;
        }
        if (list.contains(SupplyAccess.Option.NO_DIRECT_ACCESS)) {
            return ZulieferungTyp.KEINE_DIREKTE_ANFAHRT;
        }
        if (list.contains(SupplyAccess.Option.CAR_ACCESS)) {
            return ZulieferungTyp.PKW_ZUFAHRT;
        }
        if (list.contains(SupplyAccess.Option.FROM_BACK_SIDE)) {
            return ZulieferungTyp.VON_HINTEN;
        }
        if (list.contains(SupplyAccess.Option.FROM_FRONT_SIDE)) {
            return ZulieferungTyp.VON_VORN;
        }
        if (list.contains(SupplyAccess.Option.MORNING)) {
            return ZulieferungTyp.VORMITTAGS;
        }
        return ZulieferungTyp.KEINE_ANGABE;
    }
}

