/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.BuildableInShortTerm;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.BuildingPermissionAvailable;
import com.openindex.openestate.impl.attribs.administration.DemolitionRequired;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ConstructionPhase;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.CeilingLoad;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountGuestrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowArea;
import com.openindex.openestate.impl.attribs.measures.GuestTerrace;
import com.openindex.openestate.impl.attribs.measures.Height;
import com.openindex.openestate.impl.attribs.measures.Length;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.RetailArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.Width;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeRequired;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomePerMonth;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.SupplyAccess;
import com.openindex.openestate.impl.is24.Is24Utils;
import com.openindex.openestate.impl.utils.AbstractCsvWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvRecord;
import org.openestate.io.is24_csv.Is24CsvPrinter;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.records.Anlageobjekt;
import org.openestate.io.is24_csv.records.GewerbeBueroPraxis;
import org.openestate.io.is24_csv.records.GewerbeEinzelhandel;
import org.openestate.io.is24_csv.records.GewerbeGastronomieHotel;
import org.openestate.io.is24_csv.records.GewerbeHalleProduktion;
import org.openestate.io.is24_csv.records.GewerbeSonstiges;
import org.openestate.io.is24_csv.records.GrundstueckGewerbe;
import org.openestate.io.is24_csv.records.GrundstueckWohnen;
import org.openestate.io.is24_csv.records.HausKauf;
import org.openestate.io.is24_csv.records.HausMiete;
import org.openestate.io.is24_csv.records.StellplatzKauf;
import org.openestate.io.is24_csv.records.StellplatzMiete;
import org.openestate.io.is24_csv.records.WohnenAufZeit;
import org.openestate.io.is24_csv.records.WohnungKauf;
import org.openestate.io.is24_csv.records.WohnungMiete;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Auswahl;
import org.openestate.io.is24_csv.types.Bauphase;
import org.openestate.io.is24_csv.types.BebaubarNach;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.Bodenbelag;
import org.openestate.io.is24_csv.types.Datei;
import org.openestate.io.is24_csv.types.DateiSuffix;
import org.openestate.io.is24_csv.types.DateiTyp;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Erschliessung;
import org.openestate.io.is24_csv.types.Geschlecht;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.HeizungsartWohnenAufZeit;
import org.openestate.io.is24_csv.types.Importmodus;
import org.openestate.io.is24_csv.types.KaltmietePro;
import org.openestate.io.is24_csv.types.Lage;
import org.openestate.io.is24_csv.types.NutzungGrundstueckGewerbe;
import org.openestate.io.is24_csv.types.NutzungGrundstueckWohnen;
import org.openestate.io.is24_csv.types.ObjektkategorieAnlageobjekt;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeBueroPraxen;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeEinzelhandel;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeGastronomieHotel;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeHalleProduktion;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeSonstiges;
import org.openestate.io.is24_csv.types.ObjektkategorieGrundstueck;
import org.openestate.io.is24_csv.types.ObjektkategorieHaus;
import org.openestate.io.is24_csv.types.ObjektkategorieStellplatz;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnenAufZeit;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnung;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.PauschalmietePro;
import org.openestate.io.is24_csv.types.Rauchen;
import org.openestate.io.is24_csv.types.Stellplatz;
import org.openestate.io.is24_csv.types.Vermarktungsart;
import org.openestate.io.is24_csv.types.VermarktungsartGewerbe;
import org.openestate.io.is24_csv.types.Zulieferung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvWriter
extends AbstractCsvWriter<Is24CsvPrinter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvWriter.class);
    private boolean energyCertificateAppendedToDescription = false;

    public Is24CsvWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public Is24CsvWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected Is24CsvRecord createEmptyRecord(OpenEstateType openEstateType, OpenEstateAction openEstateAction, boolean bl) {
        if (openEstateType == null || openEstateAction == null) {
            return null;
        }
        List<OpenEstateType> list = Arrays.asList(openEstateType.getParentPath());
        boolean bl2 = OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction);
        boolean bl3 = OpenEstateAction.LEASE.equals((Object)openEstateAction);
        boolean bl4 = OpenEstateAction.PURCHASE.equals((Object)openEstateAction);
        boolean bl5 = OpenEstateAction.RENT.equals((Object)openEstateAction);
        boolean bl6 = OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction);
        boolean bl7 = bl4 || bl5 || bl3;
        boolean bl8 = bl4 || bl5 || bl3 || bl2;
        boolean bl9 = bl4;
        boolean bl10 = bl5 || bl3;
        boolean bl11 = bl6;
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction) && bl && (list.contains(OpenEstateType.GENERAL_COMMERCIAL) || list.contains(OpenEstateType.GENERAL_RESIDENCE))) {
            return new Anlageobjekt();
        }
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction) && list.contains(OpenEstateType.HOUSING_COMPLEX)) {
            return new Anlageobjekt();
        }
        if (bl7 && (list.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING) || list.contains(OpenEstateType.OFFICE_SURGERY))) {
            return new GewerbeBueroPraxis();
        }
        if (bl7 && list.contains(OpenEstateType.RETAIL)) {
            return new GewerbeEinzelhandel();
        }
        if (bl7 && (list.contains(OpenEstateType.GASTRONOMY) || list.contains(OpenEstateType.HOSPITALITY_INDUSTRY))) {
            return new GewerbeGastronomieHotel();
        }
        if (bl7 && (list.contains(OpenEstateType.HALL_WAREHOUSE) || list.contains(OpenEstateType.PRODUCTION))) {
            return new GewerbeHalleProduktion();
        }
        if (bl7 && (list.contains(OpenEstateType.GENERAL_COMMERCIAL) || list.contains(OpenEstateType.GENERAL_AGRICULTURE))) {
            return new GewerbeSonstiges();
        }
        if (bl8 && list.contains(OpenEstateType.RESIDENTIAL_GROUND)) {
            return new GrundstueckWohnen();
        }
        if (bl8 && list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            return new GrundstueckGewerbe();
        }
        if (bl9 && list.contains(OpenEstateType.HOUSE)) {
            return new HausKauf();
        }
        if (bl10 && list.contains(OpenEstateType.HOUSE)) {
            return new HausMiete();
        }
        if (bl9 && list.contains(OpenEstateType.RESIDENCE)) {
            return new WohnungKauf();
        }
        if (bl10 && list.contains(OpenEstateType.RESIDENCE)) {
            return new WohnungMiete();
        }
        if (bl11 && list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            return new WohnenAufZeit();
        }
        if (bl9 && list.contains(OpenEstateType.GENERAL_PARKING)) {
            return new StellplatzKauf();
        }
        if (bl10 && list.contains(OpenEstateType.GENERAL_PARKING)) {
            return new StellplatzMiete();
        }
        return null;
    }

    protected Is24CsvPrinter createPrinter(OutputStream outputStream) throws IOException {
        return Is24CsvPrinter.create((OutputStream)outputStream);
    }

    protected Is24CsvPrinter createPrinter(Writer writer) throws IOException {
        return Is24CsvPrinter.create((Writer)writer);
    }

    protected Is24CsvRecord createRecord(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) throws OpenEstateException {
        DateiTyp dateiTyp;
        Object object;
        Object object2;
        String string;
        Object object3;
        Is24CsvRecord is24CsvRecord = this.createEmptyRecord(estateImpl.getType(), estateImpl.getAction(), Usage.hasOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.INVESTMENT));
        if (is24CsvRecord == null) {
            LOGGER.warn("Can't find matching CSV record for " + estateImpl.getType() + " / " + estateImpl.getAction() + "!");
            list.add("Immobilienart " + estateImpl.getType() + " mit Vermarktungsart " + estateImpl.getAction() + " wird nicht unterst\u00fctzt!");
            return null;
        }
        is24CsvRecord.setImportmodus(Importmodus.AKTUALISIEREN);
        Date date = new Date();
        Date date2 = estateImpl.getPublishBegin();
        Date date3 = estateImpl.getPublishEnd();
        if (date2 != null && date.before(date2)) {
            is24CsvRecord.setAktiv(false);
        } else if (date3 != null && date.after(date3)) {
            is24CsvRecord.setAktiv(false);
        } else {
            is24CsvRecord.setAktiv(true);
        }
        is24CsvRecord.setAnbieterObjektId(estateImpl.getId());
        is24CsvRecord.setScoutKundenId(agentImpl.getId());
        String string2 = StringUtils.trimToNull((String)estateImpl.getGroupId());
        if (string2 != null) {
            try {
                is24CsvRecord.setGruppierungId((Number)Long.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                int n = string2.hashCode();
                if (n == Integer.MIN_VALUE) {
                    ++n;
                }
                is24CsvRecord.setGruppierungId((Number)Math.abs(n));
            }
        }
        if (agentContactImpl != null) {
            if (agentContactImpl.isFemale()) {
                is24CsvRecord.setKontaktAnrede("Frau");
            } else if (agentContactImpl.isMale()) {
                is24CsvRecord.setKontaktAnrede("Herr");
            }
            is24CsvRecord.setKontaktOrt(agentContactImpl.getCity());
            is24CsvRecord.setKontaktLand(agentContactImpl.getCountry());
            is24CsvRecord.setKontaktEmail(agentContactImpl.getPersonMail());
            is24CsvRecord.setKontaktTelefax(agentContactImpl.getPersonFax());
            is24CsvRecord.setKontaktVorname(agentContactImpl.getPersonFirstName());
            is24CsvRecord.setKontaktNachname(agentContactImpl.getPersonLastName());
            is24CsvRecord.setKontaktMobiltelefon(agentContactImpl.getPersonMobilePhone());
            is24CsvRecord.setKontaktTelefon(agentContactImpl.getPersonPhone());
            is24CsvRecord.setKontaktPlz(agentContactImpl.getPostalCode());
            is24CsvRecord.setKontaktStrasse(agentContactImpl.getStreet());
            is24CsvRecord.setKontaktHausNr(agentContactImpl.getStreetNr());
        } else {
            is24CsvRecord.setKontaktLand(agentImpl.getCompany().getCountry());
            is24CsvRecord.setKontaktEmail(agentImpl.getCompany().getCompanyMail());
            is24CsvRecord.setKontaktTelefax(agentImpl.getCompany().getCompanyFax());
            is24CsvRecord.setKontaktMobiltelefon(agentImpl.getCompany().getCompanyMobilePhone());
            is24CsvRecord.setKontaktTelefon(agentImpl.getCompany().getCompanyPhone());
        }
        if (is24CsvRecord.getKontaktWebseite() == null) {
            Object object4 = object3 = agentContactImpl != null ? agentContactImpl.getContactWebsite() : null;
            if (object3 == null) {
                object3 = agentImpl.getCompany().getCompanyWebsite();
            }
            if (object3 != null) {
                is24CsvRecord.setKontaktWebseite(((URI)object3).toString());
            }
        }
        if ((object3 = StringUtils.trimToNull((String)estateImpl.getTitle(this.getOpenEstateLanguage()))) == null) {
            object3 = estateImpl.getFallbackTitle(this.getOpenEstateLanguage());
        }
        is24CsvRecord.setUeberschrift((String)object3);
        is24CsvRecord.setWaehrung(estateImpl.getCurrency());
        is24CsvRecord.setAdressdruck(estateImpl.getAddress().isPublished());
        is24CsvRecord.setObjektOrt(estateImpl.getAddress().getCity());
        is24CsvRecord.setObjektLand(estateImpl.getAddress().getCountry());
        is24CsvRecord.setObjektPlz(estateImpl.getAddress().getPostalCode());
        is24CsvRecord.setObjektStrasse(estateImpl.getAddress().getStreet());
        is24CsvRecord.setObjektHausNr(estateImpl.getAddress().getStreetNr());
        is24CsvRecord.setProvision(AgentFee.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        is24CsvRecord.setProvisionshinweis(AgentFeeInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        is24CsvRecord.setProvisionpflichtig(AgentFeeRequired.get((EstateImpl)estateImpl));
        is24CsvRecord.setBeschreibungAusstattung(FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        is24CsvRecord.setBeschreibungObjekt(DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        is24CsvRecord.setBeschreibungLage(LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        is24CsvRecord.setBeschreibungSonstiges(AdditionalInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (this.isEnergyCertificateAppendedToDescription() && (string = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)"\r\n")) != null) {
            Object object5 = StringUtils.trimToEmpty((String)is24CsvRecord.getBeschreibungSonstiges());
            object5 = OpenEstateUtils.appendTextToDescription(object5, (String)string, (String)"\r\n", (int)2000, (boolean)false);
            is24CsvRecord.setBeschreibungSonstiges((String)object5);
        }
        ArrayList<Datei> arrayList = new ArrayList<Datei>();
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            if (estateAttachmentImpl.isUrl()) {
                object2 = estateAttachmentImpl.getFileAsUrl();
                if (object2 == null) continue;
                object = DateiTyp.LINK;
                dateiTyp = null;
                arrayList.add(new Datei(((URI)object2).toString(), (DateiTyp)object, dateiTyp, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage())));
                continue;
            }
            if (!estateAttachmentImpl.isName() || (object2 = StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName())) == null) continue;
            object = StringUtils.trimToEmpty((String)estateAttachmentImpl.getMimeType()).toLowerCase();
            dateiTyp = null;
            if (((String)object).equals("application/pdf")) {
                dateiTyp = EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType()) ? DateiTyp.GRUNDRISS_PDF : DateiTyp.VIDEO;
            } else if (((String)object).startsWith("image/")) {
                dateiTyp = EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType()) ? DateiTyp.GRUNDRISS_BILD : DateiTyp.BILD;
            } else if (((String)object).startsWith("video/")) {
                dateiTyp = DateiTyp.VIDEO;
            } else if (((String)object).startsWith("audio/")) {
                dateiTyp = DateiTyp.SOUNDFILE;
            }
            DateiSuffix dateiSuffix = DateiSuffix.fromFileName((String)object2);
            if (dateiSuffix == null) {
                dateiSuffix = DateiSuffix.fromMimeType((String)object);
            }
            arrayList.add(new Datei((String)object2, dateiTyp, dateiSuffix, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage())));
        }
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getLinks()) {
            object2 = estateAttachmentImpl.getUrl();
            if (object2 == null) continue;
            object = DateiTyp.LINK;
            dateiTyp = null;
            arrayList.add(new Datei(((URI)object2).toString(), (DateiTyp)object, dateiTyp, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage())));
        }
        is24CsvRecord.setDateien(arrayList);
        if (is24CsvRecord instanceof Anlageobjekt) {
            this.setupRecord((Anlageobjekt)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GewerbeBueroPraxis) {
            this.setupRecord((GewerbeBueroPraxis)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GewerbeEinzelhandel) {
            this.setupRecord((GewerbeEinzelhandel)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GewerbeGastronomieHotel) {
            this.setupRecord((GewerbeGastronomieHotel)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GewerbeHalleProduktion) {
            this.setupRecord((GewerbeHalleProduktion)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GewerbeSonstiges) {
            this.setupRecord((GewerbeSonstiges)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GrundstueckGewerbe) {
            this.setupRecord((GrundstueckGewerbe)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof GrundstueckWohnen) {
            this.setupRecord((GrundstueckWohnen)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof HausKauf) {
            this.setupRecord((HausKauf)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof HausMiete) {
            this.setupRecord((HausMiete)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof StellplatzKauf) {
            this.setupRecord((StellplatzKauf)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof StellplatzMiete) {
            this.setupRecord((StellplatzMiete)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof WohnenAufZeit) {
            this.setupRecord((WohnenAufZeit)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof WohnungKauf) {
            this.setupRecord((WohnungKauf)is24CsvRecord, estateImpl);
        } else if (is24CsvRecord instanceof WohnungMiete) {
            this.setupRecord((WohnungMiete)is24CsvRecord, estateImpl);
        } else {
            throw new OpenEstateException("Unsupported CSV record: " + is24CsvRecord.getClass().getName());
        }
        return is24CsvRecord;
    }

    protected Is24CsvRecord createRecordForRemoval(String string, AgentImpl agentImpl, List<String> list) {
        StellplatzKauf stellplatzKauf = new StellplatzKauf();
        stellplatzKauf.setAktiv(true);
        stellplatzKauf.setAnbieterObjektId(string);
        stellplatzKauf.setImportmodus(Importmodus.LOESCHEN);
        stellplatzKauf.setKaufpreis((Number)9999);
        stellplatzKauf.setObjektkategorie(ObjektkategorieStellplatz.KEINE_ANGABE);
        stellplatzKauf.setObjektLand(Locale.GERMANY.getISO3Country());
        stellplatzKauf.setObjektOrt("Berlin");
        stellplatzKauf.setObjektPlz("13125");
        stellplatzKauf.setScoutKundenId(agentImpl.getId());
        stellplatzKauf.setUeberschrift("object to remove");
        return stellplatzKauf;
    }

    protected Ausstattung getAusstattung(Equipment.Option option) {
        if (Equipment.Option.BASIC.equals((Object)option)) {
            return Ausstattung.EINFACH;
        }
        if (Equipment.Option.EXCLUSIVE.equals((Object)option)) {
            return Ausstattung.GEHOBEN;
        }
        if (Equipment.Option.LUXURY.equals((Object)option)) {
            return Ausstattung.LUXUS;
        }
        if (Equipment.Option.STANDARD.equals((Object)option)) {
            return Ausstattung.NORMAL;
        }
        return Ausstattung.KEINE_ANGABE;
    }

    protected Auswahl getAuswahl(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return Auswahl.JA;
        }
        if (Boolean.FALSE.equals(bl)) {
            return Auswahl.NEIN;
        }
        return null;
    }

    protected Bauphase getBauphase(ConstructionPhase.Option option) {
        if (ConstructionPhase.Option.PLANNED.equals((Object)option)) {
            return Bauphase.IN_PLANUNG;
        }
        if (ConstructionPhase.Option.UNDER_CONSTRUCTION.equals((Object)option)) {
            return Bauphase.IM_BAU;
        }
        if (ConstructionPhase.Option.COMPLETED.equals((Object)option)) {
            return Bauphase.FERTIG_GESTELLT;
        }
        return Bauphase.KEINE_ANGABE;
    }

    protected BebaubarNach getBebaubarNach(BuildableAccordingTo.Option option) {
        if (BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT.equals((Object)option)) {
            return BebaubarNach.AUSSENGEBIET;
        }
        if (BuildableAccordingTo.Option.BINDING_SITE_PLAN.equals((Object)option)) {
            return BebaubarNach.BEBAUUNGSPLAN;
        }
        if (BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT.equals((Object)option)) {
            return BebaubarNach.NACHBARBEBAUUNG;
        }
        return BebaubarNach.UNBEKANNT;
    }

    protected Iterable<Befeuerungsart> getBefeuerungsart(List<TypeOfBeaconing.Option> list) {
        ArrayList<Befeuerungsart> arrayList = new ArrayList<Befeuerungsart>();
        if (list.contains(TypeOfBeaconing.Option.GEOTHERMICS)) {
            arrayList.add(Befeuerungsart.ERDWAERME);
        }
        if (list.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            arrayList.add(Befeuerungsart.FERNWAERME);
        }
        if (list.contains(TypeOfBeaconing.Option.GAS)) {
            arrayList.add(Befeuerungsart.GAS);
        }
        if (list.contains(TypeOfBeaconing.Option.COAL)) {
            arrayList.add(Befeuerungsart.KOHLE);
        }
        if (list.contains(TypeOfBeaconing.Option.OIL)) {
            arrayList.add(Befeuerungsart.OEL);
        }
        if (list.contains(TypeOfBeaconing.Option.PELLETS)) {
            arrayList.add(Befeuerungsart.PELLETHEIZUNG);
        }
        if (list.contains(TypeOfBeaconing.Option.SOLAR)) {
            arrayList.add(Befeuerungsart.SOLARHEIZUNG);
        }
        if (list.contains(TypeOfBeaconing.Option.ELECTRICS)) {
            arrayList.add(Befeuerungsart.STROM);
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    protected Bodenbelag getBodenbelag(List<FlooringMaterial.Option> list) {
        if (list.contains(FlooringMaterial.Option.CONCRETE)) {
            return Bodenbelag.BETON;
        }
        if (list.contains(FlooringMaterial.Option.EPOXY_RESIN)) {
            return Bodenbelag.EPOXIDHARZBODEN;
        }
        if (list.contains(FlooringMaterial.Option.TILES) || list.contains(FlooringMaterial.Option.CERAMIC) || list.contains(FlooringMaterial.Option.TERRACOTTA)) {
            return Bodenbelag.FLIESEN;
        }
        if (list.contains(FlooringMaterial.Option.LAMINATE)) {
            return Bodenbelag.LAMINAT;
        }
        if (list.contains(FlooringMaterial.Option.AS_REQUESTED)) {
            return Bodenbelag.NACH_MIETERWUNSCH;
        }
        if (list.contains(FlooringMaterial.Option.PARQUET)) {
            return Bodenbelag.PARKETT;
        }
        if (list.contains(FlooringMaterial.Option.PVC)) {
            return Bodenbelag.PVC;
        }
        if (list.contains(FlooringMaterial.Option.STONE) || list.contains(FlooringMaterial.Option.GRANITE) || list.contains(FlooringMaterial.Option.MARBLE) || list.contains(FlooringMaterial.Option.SLATE)) {
            return Bodenbelag.STEIN;
        }
        if (list.contains(FlooringMaterial.Option.CARPET)) {
            return Bodenbelag.TEPPICHBODEN;
        }
        if (list.contains(FlooringMaterial.Option.CARPET_ANTISTATIC)) {
            return Bodenbelag.ANTISTATISCHER_TEPPICHBODEN;
        }
        return Bodenbelag.KEINE_ANGABE;
    }

    protected EnergieausweisTyp getEnergieausweisTyp(Type.Option option) {
        if (Type.Option.CONSUMPTION.equals((Object)option)) {
            return EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT;
        }
        if (Type.Option.DEMAND.equals((Object)option)) {
            return EnergieausweisTyp.ENDENERGIEBEDARF;
        }
        return EnergieausweisTyp.KEINE_ANGABE;
    }

    protected Erschliessung getErschliessung(Development.Option option) {
        if (Development.Option.COMPLETELY.equals((Object)option)) {
            return Erschliessung.ERSCHLOSSEN;
        }
        if (Development.Option.PARTIALLY.equals((Object)option)) {
            return Erschliessung.TEILERSCHLOSSEN;
        }
        if (Development.Option.UNDEVELOPED.equals((Object)option)) {
            return Erschliessung.UNERSCHLOSSEN;
        }
        return null;
    }

    protected Geschlecht getGeschlecht(GenderOfRequestedFlatmates.Option option) {
        if (GenderOfRequestedFlatmates.Option.FEMALE.equals((Object)option)) {
            return Geschlecht.NUR_FRAUEN;
        }
        if (GenderOfRequestedFlatmates.Option.MALE.equals((Object)option)) {
            return Geschlecht.NUR_MAENNER;
        }
        return null;
    }

    protected Auswahl getHaustiere(Pets.Option option) {
        if (Pets.Option.YES.equals((Object)option)) {
            return Auswahl.JA;
        }
        if (Pets.Option.NO.equals((Object)option)) {
            return Auswahl.NEIN;
        }
        if (Pets.Option.AS_APPOINTED.equals((Object)option)) {
            return Auswahl.NACH_VEREINBARUNG;
        }
        return null;
    }

    protected Heizungsart getHeizungsart(List<TypeOfHeating.Option> list) {
        if (list.contains(TypeOfHeating.Option.SELF_CONTAINED_CENTRAL)) {
            return Heizungsart.ETAGENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.OVEN)) {
            return Heizungsart.OFENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.CENTRAL)) {
            return Heizungsart.ZENTRALHEIZUNG;
        }
        return Heizungsart.KEINE_ANGABE;
    }

    protected HeizungsartWohnenAufZeit getHeizungsartWohnenAufZeit(List<TypeOfHeating.Option> list) {
        if (list.contains(TypeOfHeating.Option.SELF_CONTAINED_CENTRAL)) {
            return HeizungsartWohnenAufZeit.ETAGENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.OVEN)) {
            return HeizungsartWohnenAufZeit.OFENHEIZUNG;
        }
        if (list.contains(TypeOfHeating.Option.CENTRAL)) {
            return HeizungsartWohnenAufZeit.ZENTRALHEIZUNG;
        }
        return null;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="A null return value is explicitly required.")
    protected Boolean getKeller(UndergroundLevel.Option option) {
        if (UndergroundLevel.Option.YES.equals((Object)option)) {
            return true;
        }
        if (UndergroundLevel.Option.PARTIALLY.equals((Object)option)) {
            return true;
        }
        if (UndergroundLevel.Option.NO.equals((Object)option)) {
            return false;
        }
        return null;
    }

    protected Lage getLage(CommercialZone.Option option) {
        if (option == null) {
            return Lage.KEINE_ANGABE;
        }
        switch (option) {
            case LOCATION_A: 
            case LOCATION_1A: 
            case LOCATION_2A: {
                return Lage.A_LAGE;
            }
            case LOCATION_B: 
            case LOCATION_1B: 
            case LOCATION_2B: {
                return Lage.B_LAGE;
            }
            case SHOPPING_CENTER: {
                return Lage.EINKAUFSZENTRUM;
            }
        }
        return Lage.KEINE_ANGABE;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="A null return value is explicitly required.")
    protected Boolean getMobiliar(Furnished.Option option) {
        if (Furnished.Option.YES.equals((Object)option)) {
            return true;
        }
        if (Furnished.Option.PARTIAL.equals((Object)option)) {
            return true;
        }
        if (Furnished.Option.NO.equals((Object)option)) {
            return false;
        }
        return null;
    }

    protected List<NutzungGrundstueckGewerbe> getNutzungGrundstueckGewerbe(List<BuildableWith.Option> list) {
        ArrayList<NutzungGrundstueckGewerbe> arrayList = new ArrayList<NutzungGrundstueckGewerbe>();
        if (list.contains(BuildableWith.Option.FARMLAND)) {
            arrayList.add(NutzungGrundstueckGewerbe.ACKERLAND);
        }
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            arrayList.add(NutzungGrundstueckGewerbe.BAUERWARTUNGSLAND);
        }
        if (list.contains(BuildableWith.Option.JETTY)) {
            arrayList.add(NutzungGrundstueckGewerbe.BOOTSSTAENDE);
        }
        if (list.contains(BuildableWith.Option.OFFICE)) {
            arrayList.add(NutzungGrundstueckGewerbe.BUERO);
        }
        if (list.contains(BuildableWith.Option.CAMPING)) {
            arrayList.add(NutzungGrundstueckGewerbe.CAMPING);
        }
        if (list.contains(BuildableWith.Option.RETAIL_LARGE)) {
            arrayList.add(NutzungGrundstueckGewerbe.EINZELHANDEL_GROSS);
        }
        if (list.contains(BuildableWith.Option.RETAIL_SMALL)) {
            arrayList.add(NutzungGrundstueckGewerbe.EINZELHANDEL_KLEIN);
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            arrayList.add(NutzungGrundstueckGewerbe.GARAGEN);
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            arrayList.add(NutzungGrundstueckGewerbe.GARTEN);
        }
        if (list.contains(BuildableWith.Option.GASTRONOMY)) {
            arrayList.add(NutzungGrundstueckGewerbe.GASTRONOMIE);
        }
        if (list.contains(BuildableWith.Option.BUSINESS_BIG)) {
            arrayList.add(NutzungGrundstueckGewerbe.GEWERBE);
        }
        if (list.contains(BuildableWith.Option.HOTEL)) {
            arrayList.add(NutzungGrundstueckGewerbe.HOTEL);
        }
        if (list.contains(BuildableWith.Option.INDUSTRY)) {
            arrayList.add(NutzungGrundstueckGewerbe.INDUSTRIE);
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            arrayList.add(NutzungGrundstueckGewerbe.KEINE_BEBAUUNG);
        }
        if (list.contains(BuildableWith.Option.BUSINESS_SMALL)) {
            arrayList.add(NutzungGrundstueckGewerbe.KLEINGEWERBE);
        }
        if (list.contains(BuildableWith.Option.WAREHOUSE)) {
            arrayList.add(NutzungGrundstueckGewerbe.LAGER);
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            arrayList.add(NutzungGrundstueckGewerbe.OBSTPFLANZUNG);
        }
        if (list.contains(BuildableWith.Option.PARKING_STRUCTURE)) {
            arrayList.add(NutzungGrundstueckGewerbe.PARKHAUS);
        }
        if (list.contains(BuildableWith.Option.PRODUCTION)) {
            arrayList.add(NutzungGrundstueckGewerbe.PRODUKTION);
        }
        if (list.contains(BuildableWith.Option.CAR_PARKING_SPACES)) {
            arrayList.add(NutzungGrundstueckGewerbe.STELLPLAETZE);
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            arrayList.add(NutzungGrundstueckGewerbe.WALD);
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    protected List<NutzungGrundstueckWohnen> getNutzungGrundstueckWohnen(List<BuildableWith.Option> list) {
        ArrayList<NutzungGrundstueckWohnen> arrayList = new ArrayList<NutzungGrundstueckWohnen>();
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            arrayList.add(NutzungGrundstueckWohnen.BAUERWARTUNGSLAND);
        }
        if (list.contains(BuildableWith.Option.DUPLEX_HOUSE)) {
            arrayList.add(NutzungGrundstueckWohnen.DOPPELHAUSHAELFTE);
        }
        if (list.contains(BuildableWith.Option.SINGLE_FAMILY_HOUSE)) {
            arrayList.add(NutzungGrundstueckWohnen.EINFAMILIENHAUS);
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            arrayList.add(NutzungGrundstueckWohnen.GARAGEN);
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            arrayList.add(NutzungGrundstueckWohnen.GARTEN);
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            arrayList.add(NutzungGrundstueckWohnen.KEINE_BEBAUUNG);
        }
        if (list.contains(BuildableWith.Option.MULTI_FAMILY_HOUSE)) {
            arrayList.add(NutzungGrundstueckWohnen.MEHRFAMILIENHAUS);
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            arrayList.add(NutzungGrundstueckWohnen.OBSTPFLANZUNG);
        }
        if (list.contains(BuildableWith.Option.TERRACED_HOUSE)) {
            arrayList.add(NutzungGrundstueckWohnen.REIHENHAUS);
        }
        if (list.contains(BuildableWith.Option.CAR_PARKING_SPACES)) {
            arrayList.add(NutzungGrundstueckWohnen.STELLPLAETZE);
        }
        if (list.contains(BuildableWith.Option.VILLA)) {
            arrayList.add(NutzungGrundstueckWohnen.VILLA);
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            arrayList.add(NutzungGrundstueckWohnen.WALD);
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    protected ObjektkategorieAnlageobjekt getObjektkategorieAnlageobjekt(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case OFFICE_BUILDING: {
                return ObjektkategorieAnlageobjekt.BUEROGEBAEUDE;
            }
            case RESIDENCE: {
                return ObjektkategorieAnlageobjekt.EIGENTUMSWOHNUNG;
            }
            case SINGLE_FAMILY_HOUSE: {
                return ObjektkategorieAnlageobjekt.EINFAMILIENHAUS;
            }
            case SHOPPING_CENTER: {
                return ObjektkategorieAnlageobjekt.EINKAUFSZENTRUM;
            }
            case LEISURE_SPORTS_FACILITY: {
                return ObjektkategorieAnlageobjekt.FREIZEITANLAGE;
            }
            case COMMERCIAL_BUILDING: {
                return ObjektkategorieAnlageobjekt.GAESCHAEFTSHAUS;
            }
            case GASTRONOMY: {
                return ObjektkategorieAnlageobjekt.GASTSTAETTE;
            }
            case GENERAL_COMMERCIAL: {
                return ObjektkategorieAnlageobjekt.GEWERBEANWESEN;
            }
            case HALL_WAREHOUSE: {
                return ObjektkategorieAnlageobjekt.HALLE_LAGER;
            }
            case HOTEL: 
            case HOSTEL: {
                return ObjektkategorieAnlageobjekt.HOTEL;
            }
            case INDUSTRIAL_FACILITY: {
                return ObjektkategorieAnlageobjekt.INDUSTRIEANWESEN;
            }
            case SALES_AREA: 
            case SHOP: 
            case STORE: 
            case PREMISE: 
            case OFFICE_COMMERCIAL_PREMISE: {
                return ObjektkategorieAnlageobjekt.LADEN_VERKAUFSFLAECHE;
            }
            case MULTI_FAMILY_HOUSE: 
            case MULTI_FAMILY_HOUSE_WITH_COMMERCIAL: {
                return ObjektkategorieAnlageobjekt.MEHRFAMILIENHAUS;
            }
            case SERVICE_CENTER: {
                return ObjektkategorieAnlageobjekt.SERVICECENTER;
            }
            case CONSUMER_STORE: 
            case DEPARTMENT_STORE: {
                return ObjektkategorieAnlageobjekt.SUPERMARKT;
            }
            case HOUSING_COMPLEX: 
            case SENIOR_HOUSING_COMPLEX: {
                return ObjektkategorieAnlageobjekt.WOHNANLAGE;
            }
            case RESIDENTIAL_COMMERCIAL_BUILDING: {
                return ObjektkategorieAnlageobjekt.WOHN_GESCHAEFTSHAUS;
            }
        }
        return null;
    }

    protected ObjektkategorieGewerbeBueroPraxen getObjektkategorieGewerbeBueroPraxen(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case ATELIER: {
                return ObjektkategorieGewerbeBueroPraxen.ATELIER;
            }
            case OFFICE: {
                return ObjektkategorieGewerbeBueroPraxen.BUERO;
            }
            case OFFICE_FLOOR: {
                return ObjektkategorieGewerbeBueroPraxen.BUEROETAGE;
            }
            case OFFICE_BUILDING: {
                return ObjektkategorieGewerbeBueroPraxen.BUEROHAUS;
            }
            case OFFICE_CENTER: {
                return ObjektkategorieGewerbeBueroPraxen.BUEROZENTRUM;
            }
            case OFFICE_COMMERCIAL_BUILDING: {
                return ObjektkategorieGewerbeBueroPraxen.BUERO_GESCHAEFTSGEBAEUDE;
            }
            case COMMERCIAL_CENTER: {
                return ObjektkategorieGewerbeBueroPraxen.GEWERBEZENTRUM;
            }
            case LOFT: {
                return ObjektkategorieGewerbeBueroPraxen.LOFT;
            }
            case SURGERY: {
                return ObjektkategorieGewerbeBueroPraxen.PRAXIS;
            }
            case SURGERY_FLOOR: {
                return ObjektkategorieGewerbeBueroPraxen.PRAXISETAGE;
            }
            case DOCTORS_OFFICE_HOUSE: {
                return ObjektkategorieGewerbeBueroPraxen.PRAXISHAUS;
            }
            case RESIDENTIAL_COMMERCIAL_BUILDING: {
                return ObjektkategorieGewerbeBueroPraxen.WOHN_GESCHAEFTSGEBAEUDE;
            }
        }
        return null;
    }

    protected ObjektkategorieGewerbeEinzelhandel getObjektkategorieGewerbeEinzelhandel(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case EXHIBITION_AREA: {
                return ObjektkategorieGewerbeEinzelhandel.AUSSTELLUNGSFLAECHE;
            }
            case SHOPPING_CENTER: {
                return ObjektkategorieGewerbeEinzelhandel.EINKAUFSZENTRUM;
            }
            case DEPARTMENT_STORE: {
                return ObjektkategorieGewerbeEinzelhandel.KAUFHAUS;
            }
            case KIOSK: {
                return ObjektkategorieGewerbeEinzelhandel.KIOSK;
            }
            case SHOP: 
            case STORE: 
            case PREMISE: 
            case OFFICE_COMMERCIAL_PREMISE: {
                return ObjektkategorieGewerbeEinzelhandel.LADEN;
            }
            case SELF_SERVICE_MARKET: {
                return ObjektkategorieGewerbeEinzelhandel.SB_MARKT;
            }
            case SALES_AREA: {
                return ObjektkategorieGewerbeEinzelhandel.VERKAUFSFLAECHE;
            }
            case SHOWROOM: {
                return ObjektkategorieGewerbeEinzelhandel.VERKAUFSHALLE;
            }
        }
        return null;
    }

    protected ObjektkategorieGewerbeGastronomieHotel getObjektkategorieGewerbeGastronomieHotel(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case RESTAURANT_BAR: {
                return ObjektkategorieGewerbeGastronomieHotel.BAR_LOUNGE;
            }
            case BISTRO_CAFE: {
                return ObjektkategorieGewerbeGastronomieHotel.CAFE;
            }
            case DISCOTHEQUE: {
                return ObjektkategorieGewerbeGastronomieHotel.CLUB_DISCO;
            }
            case COTTAGE: 
            case BUNGALOW: {
                return ObjektkategorieGewerbeGastronomieHotel.FERIENBUNGALOW;
            }
            case HOSPITALITY_INDUSTRY: {
                return ObjektkategorieGewerbeGastronomieHotel.GAESTEHAUS;
            }
            case GASTRONOMY: 
            case GASTRONOMY_WITH_HOUSING: {
                return ObjektkategorieGewerbeGastronomieHotel.GASTSTAETTE;
            }
            case HOTEL: 
            case HOSTEL: {
                return ObjektkategorieGewerbeGastronomieHotel.HOTEL;
            }
            case GUESTHOUSE: {
                return ObjektkategorieGewerbeGastronomieHotel.PENSION;
            }
            case RESTAURANT: {
                return ObjektkategorieGewerbeGastronomieHotel.RESTAURANT;
            }
        }
        return null;
    }

    protected ObjektkategorieGewerbeHalleProduktion getObjektkategorieGewerbeHalleProduktion(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case EXHIBITION_AREA: {
                return ObjektkategorieGewerbeHalleProduktion.AUSSTELLUNGSFLAECHE;
            }
            case HALL_WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.HALLE;
            }
            case HIGH_RACK_WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.HOCHREGALLAGER;
            }
            case INDUSTRIAL_WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.INDUSTRIEHALLE;
            }
            case INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE: {
                return ObjektkategorieGewerbeHalleProduktion.INDUSTRIEHALLE_MIT_FREIFLAECHE;
            }
            case COOLING_HOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.KUEHLHAUS;
            }
            case COLD_STORAGE_WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.KUEHLREGALLAGER;
            }
            case STORAGE_AREA: {
                return ObjektkategorieGewerbeHalleProduktion.LAGERFLAECHE;
            }
            case WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.LAGERHALLE;
            }
            case WAREHOUSE_WITH_OPEN_SPACE: {
                return ObjektkategorieGewerbeHalleProduktion.LAGER_MIT_FREIFLAECHE;
            }
            case SERVICE_AREA: {
                return ObjektkategorieGewerbeHalleProduktion.SERVICEFLAECHE;
            }
            case FORWARDING_WAREHOUSE: {
                return ObjektkategorieGewerbeHalleProduktion.SPEDITIONSLAGER;
            }
            case WORKSHOP: {
                return ObjektkategorieGewerbeHalleProduktion.WERKSTATT;
            }
        }
        return null;
    }

    protected ObjektkategorieGewerbeSonstiges getObjektkategorieGewerbeSonstiges(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case FARM: 
            case OUTLYING_FARM: {
                return ObjektkategorieGewerbeSonstiges.BAUERNHOF;
            }
            case LEISURE_SPORTS_FACILITY: {
                return ObjektkategorieGewerbeSonstiges.FREIZEITANLAGE;
            }
            case COMMERCIAL_CENTER: {
                return ObjektkategorieGewerbeSonstiges.GEWERBEPARK;
            }
            case RIDING_ESTATE: {
                return ObjektkategorieGewerbeSonstiges.REITERHOF;
            }
            case VINICULTURE: {
                return ObjektkategorieGewerbeSonstiges.WEINGUT;
            }
            case WORKSHOP: {
                return ObjektkategorieGewerbeSonstiges.WERKSTATT;
            }
        }
        return null;
    }

    protected ObjektkategorieGrundstueck getObjektkategorieGrundstueck(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case COMMERCIAL_GROUND: {
                return ObjektkategorieGrundstueck.GEWERBE;
            }
            case LEISURE_GROUND: {
                return ObjektkategorieGrundstueck.GEWERBE_FREIZEIT;
            }
            case AGRICULTURAL_FORESTRY_GROUND: {
                return ObjektkategorieGrundstueck.GEWERBE_LAND_FORSTWIRTSCHAFT;
            }
            case RESIDENTIAL_GROUND: {
                return ObjektkategorieGrundstueck.WOHNEN;
            }
        }
        return null;
    }

    protected ObjektkategorieHaus getObjektkategorieHaus(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case FARMHOUSE: {
                return ObjektkategorieHaus.BAUERNHAUS;
            }
            case SPECIAL_HOUSE: {
                return ObjektkategorieHaus.BESONDERE_IMMOBILIE;
            }
            case BUNGALOW: {
                return ObjektkategorieHaus.BUNGALOW;
            }
            case CASTLE: 
            case PALACE: {
                return ObjektkategorieHaus.BURG_SCHLOSS;
            }
            case SEMIDETACHED_HOUSE: {
                return ObjektkategorieHaus.DOPPELHAUSHAELFTE;
            }
            case SINGLE_FAMILY_HOUSE: {
                return ObjektkategorieHaus.EINFAMILIENHAUS;
            }
            case MULTI_FAMILY_HOUSE: {
                return ObjektkategorieHaus.MEHRFAMILIENHAUS;
            }
            case TERRACED_HOUSE_CORNERSIDE: {
                return ObjektkategorieHaus.REIHENECKHAUS;
            }
            case TERRACED_HOUSE_MIDDLE: {
                return ObjektkategorieHaus.REIHENMITTELHAUS;
            }
            case TERRACED_HOUSE: {
                return ObjektkategorieHaus.REIHENMITTELHAUS;
            }
            case GENERAL_RESIDENCE: {
                return ObjektkategorieHaus.SONSTIGE_WOHNIMMOBILIE;
            }
            case VILLA: {
                return ObjektkategorieHaus.VILLA;
            }
        }
        return null;
    }

    protected ObjektkategorieStellplatz getObjektkategorieStellplatz(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case OUTDOOR_CAR_PARKING_SPACE: {
                return ObjektkategorieStellplatz.AUSSENSTELLPLATZ;
            }
            case CARPORT: {
                return ObjektkategorieStellplatz.CARPORT;
            }
            case DUPLEX_GARAGE: {
                return ObjektkategorieStellplatz.DUPLEX;
            }
            case GARAGE: {
                return ObjektkategorieStellplatz.GARAGE;
            }
            case CAR_PARK_UNIT: {
                return ObjektkategorieStellplatz.PARKHAUS;
            }
            case UNDERGROUND_CAR_PARK_UNIT: {
                return ObjektkategorieStellplatz.TIEFGARAGE;
            }
        }
        return null;
    }

    protected ObjektkategorieWohnenAufZeit getObjektkategorieWohnenAufZeit(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case APARTMENT: {
                return ObjektkategorieWohnenAufZeit.APPARTMENT;
            }
            case HOUSE: {
                return ObjektkategorieWohnenAufZeit.HAUS;
            }
            case RESIDENCE: {
                return ObjektkategorieWohnenAufZeit.WOHNUNG;
            }
            case ROOM: {
                return ObjektkategorieWohnenAufZeit.ZIMMER;
            }
        }
        return null;
    }

    protected ObjektkategorieWohnung getObjektkategorieWohnung(OpenEstateType openEstateType) {
        if (openEstateType == null) {
            return null;
        }
        switch (openEstateType) {
            case ATTIC_APARTMENT: {
                return ObjektkategorieWohnung.DACHGESCHOSS;
            }
            case GROUND_FLOOR_APARTMENT: {
                return ObjektkategorieWohnung.ERDGESCHOSS;
            }
            case HIGHER_FLOOR_APARTMENT: {
                return ObjektkategorieWohnung.ETAGE;
            }
            case MEZZANINE: {
                return ObjektkategorieWohnung.HOCHPARTERRE;
            }
            case LOFT: {
                return ObjektkategorieWohnung.LOFT;
            }
            case MAISONETTE: {
                return ObjektkategorieWohnung.MAISONETTE;
            }
            case PENTHOUSE_APARTMENT: {
                return ObjektkategorieWohnung.PENTHOUSE;
            }
            case SOUTERRAIN_APARTMENT: {
                return ObjektkategorieWohnung.SOUTERRAIN;
            }
            case TERRACE_APARTMENT: {
                return ObjektkategorieWohnung.TERRASSE;
            }
        }
        return null;
    }

    protected Objektzustand getObjektzustand(ConditionType.Option option) {
        if (ConditionType.Option.CONDEMNED.equals((Object)option)) {
            return Objektzustand.ABBRUCHREIF;
        }
        if (ConditionType.Option.EXCELLENT.equals((Object)option)) {
            return Objektzustand.GEPFLEGT;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option)) {
            return Objektzustand.ERSTBEZUG;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option)) {
            return Objektzustand.ERSTBEZUG_NACH_SANIERUNG;
        }
        if (ConditionType.Option.WELL_TENDED.equals((Object)option)) {
            return Objektzustand.GEPFLEGT;
        }
        if (ConditionType.Option.GOOD.equals((Object)option)) {
            return Objektzustand.GEPFLEGT;
        }
        if (ConditionType.Option.MODERNIZED.equals((Object)option)) {
            return Objektzustand.MODERNISIERT;
        }
        if (ConditionType.Option.AS_APPOINTED.equals((Object)option)) {
            return Objektzustand.NACH_VEREINBARUNG;
        }
        if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option)) {
            return Objektzustand.NEUWERTIG;
        }
        if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option)) {
            return Objektzustand.VOLLSTAENDIG_RENOVIERT;
        }
        if (ConditionType.Option.PARTIALLY_RENOVATED.equals((Object)option)) {
            return Objektzustand.RENOVIERUNGSBEDARF;
        }
        if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option)) {
            return Objektzustand.RENOVIERUNGSBEDARF;
        }
        if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option)) {
            return Objektzustand.RENOVIERUNGSBEDARF;
        }
        if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option)) {
            return Objektzustand.SANIERT;
        }
        return Objektzustand.KEINE_ANGABE;
    }

    protected PauschalmietePro getPauschalmietePro(RentFlatRatePer.Option option) {
        if (RentFlatRatePer.Option.DAY.equals((Object)option)) {
            return PauschalmietePro.TAG;
        }
        if (RentFlatRatePer.Option.WEEK.equals((Object)option)) {
            return PauschalmietePro.WOCHE;
        }
        if (RentFlatRatePer.Option.MONTH.equals((Object)option)) {
            return PauschalmietePro.MONAT;
        }
        return null;
    }

    protected Rauchen getRauchen(NonSmoker.Option option) {
        if (NonSmoker.Option.YES.equals((Object)option)) {
            return Rauchen.NUR_NICHTRAUCHER;
        }
        if (NonSmoker.Option.INDIFFERENT.equals((Object)option)) {
            return Rauchen.KEINE_EINSCHRAENKUNG;
        }
        return null;
    }

    protected Stellplatz getStellplatz(List<CarParkingType.Option> list) {
        if (list.contains(CarParkingType.Option.OUTDOOR)) {
            return Stellplatz.AUSSEN_STELLPLATZ;
        }
        if (list.contains(CarParkingType.Option.CARPORT)) {
            return Stellplatz.CARPORT;
        }
        if (list.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
            return Stellplatz.DUPLEX;
        }
        if (list.contains(CarParkingType.Option.GARAGE)) {
            return Stellplatz.GARAGE;
        }
        if (list.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
            return Stellplatz.PARKHAUS;
        }
        if (list.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
            return Stellplatz.TIEFGARAGE;
        }
        if (!list.isEmpty()) {
            return Stellplatz.JA;
        }
        return Stellplatz.KEINE_ANGABE;
    }

    protected Vermarktungsart getVermarktungsart(OpenEstateAction openEstateAction) {
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            return Vermarktungsart.KAUF;
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            return Vermarktungsart.MIETE;
        }
        if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            return Vermarktungsart.PACHT;
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            return Vermarktungsart.ERBPACHT;
        }
        return null;
    }

    protected VermarktungsartGewerbe getVermarktungsartGewerbe(OpenEstateAction openEstateAction) {
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            return VermarktungsartGewerbe.KAUF;
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            return VermarktungsartGewerbe.MIETE;
        }
        if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            return VermarktungsartGewerbe.MIETE;
        }
        return null;
    }

    protected Zulieferung getZulieferung(List<SupplyAccess.Option> list) {
        if (list.contains(SupplyAccess.Option.DIRECT_ACCESS)) {
            return Zulieferung.DIREKT;
        }
        if (list.contains(SupplyAccess.Option.ALL_DAY)) {
            return Zulieferung.GANZTAEGIG;
        }
        if (list.contains(SupplyAccess.Option.NO_DIRECT_ACCESS)) {
            return Zulieferung.INDIREKT;
        }
        if (list.contains(SupplyAccess.Option.CAR_ACCESS)) {
            return Zulieferung.PKW;
        }
        if (list.contains(SupplyAccess.Option.FROM_BACK_SIDE)) {
            return Zulieferung.VON_HINTEN;
        }
        if (list.contains(SupplyAccess.Option.FROM_FRONT_SIDE)) {
            return Zulieferung.VON_VORN;
        }
        if (list.contains(SupplyAccess.Option.MORNING)) {
            return Zulieferung.VORMITTAGS;
        }
        return Zulieferung.KEINE_ANGABE;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public void write(AgencyImpl agencyImpl, Is24CsvPrinter is24CsvPrinter) {
        this.getErrorMap().clear();
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                String string = StringUtils.trimToNull((String)estateImpl.getContactId());
                if (string != null && agencyImpl.getContacts().containsKey(string)) {
                    agentContactImpl = (AgentContactImpl)agencyImpl.getContacts().get(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Is24CsvRecord is24CsvRecord = this.createRecord(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (!arrayList.isEmpty()) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                if (is24CsvRecord == null) continue;
                is24CsvPrinter.printRecord((CsvRecord)is24CsvRecord);
            }
            catch (Exception exception) {
                this.putError(estateImpl.getId(), "Can't print record! " + exception.getLocalizedMessage());
                LOGGER.warn("Can't print record for real estate '" + estateImpl.getId() + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void write(TransferImpl transferImpl, Is24CsvPrinter is24CsvPrinter) {
        this.getErrorMap().clear();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            String string;
            AgentContactImpl agentContactImpl;
            for (Object object : transferAgencyImpl.getEstatesToSave()) {
                try {
                    agentContactImpl = null;
                    string = StringUtils.trimToNull((String)object.getContactId());
                    if (string != null && transferAgencyImpl.getContacts().containsKey(string)) {
                        agentContactImpl = (AgentContactImpl)transferAgencyImpl.getContacts().get(string);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Is24CsvRecord is24CsvRecord = this.createRecord((EstateImpl)object, transferAgencyImpl.getAgent(), agentContactImpl, (List<String>)arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(object.getId(), arrayList);
                        continue;
                    }
                    if (is24CsvRecord == null) continue;
                    is24CsvPrinter.printRecord((CsvRecord)is24CsvRecord);
                }
                catch (Exception exception) {
                    this.putError(object.getId(), "Can't print record! " + exception.getLocalizedMessage());
                    LOGGER.warn("Can't print record for real estate '" + object.getId() + "'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            for (Object object : transferAgencyImpl.getEstateIdsToRemove()) {
                try {
                    agentContactImpl = new ArrayList();
                    string = this.createRecordForRemoval((String)object, transferAgencyImpl.getAgent(), (List<String>)agentContactImpl);
                    if (!agentContactImpl.isEmpty()) {
                        this.putErrors((String)object, (List)agentContactImpl);
                        continue;
                    }
                    if (string == null) continue;
                    is24CsvPrinter.printRecord((CsvRecord)string);
                }
                catch (Exception exception) {
                    this.putError((String)object, "Can't print record for removal! " + exception.getLocalizedMessage());
                    LOGGER.warn("Can't print record for removal of real estate '" + (String)object + "'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
    }

    protected void setupRecord(Anlageobjekt anlageobjekt, EstateImpl estateImpl) throws OpenEstateException {
        ObjektkategorieAnlageobjekt objektkategorieAnlageobjekt = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieAnlageobjekt = this.getObjektkategorieAnlageobjekt(list.get(i))) == null; --i) {
        }
        if (objektkategorieAnlageobjekt == null) {
            throw new OpenEstateException("Keine passende Kategorie gefunden!");
        }
        anlageobjekt.setObjektkategorie(objektkategorieAnlageobjekt);
        anlageobjekt.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        anlageobjekt.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        anlageobjekt.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        anlageobjekt.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        anlageobjekt.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        anlageobjekt.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        anlageobjekt.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        anlageobjekt.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        anlageobjekt.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        anlageobjekt.setGesamtflaeche((Number)TotalArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setGewerbeflaeche((Number)CommercialArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setGrundstuecksflaeche((Number)PlotArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
        anlageobjekt.setKaufpreisProQm((Number)PurchasePricePerArea.get((EstateImpl)estateImpl));
        anlageobjekt.setMieteinnahmenIst((Number)RentalIncomeActualPerAnnum.get((EstateImpl)estateImpl));
        anlageobjekt.setMieteinnahmenSoll((Number)RentalIncomeDebitPerAnnum.get((EstateImpl)estateImpl));
        anlageobjekt.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        anlageobjekt.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        anlageobjekt.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
        anlageobjekt.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        anlageobjekt.setSonstigeFlaeche((Number)RemainingAreas.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setVermietbareFlaeche((Number)RentableArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setWohnflaeche((Number)ResidentialArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        anlageobjekt.setXFache(PurchasePriceOnAnnualRentalIncome.get((EstateImpl)estateImpl));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        anlageobjekt.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            anlageobjekt.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            anlageobjekt.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            anlageobjekt.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (anlageobjekt.getVermietbareFlaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            anlageobjekt.setVermietbareFlaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GewerbeBueroPraxis gewerbeBueroPraxis, EstateImpl estateImpl) throws OpenEstateException {
        VermarktungsartGewerbe vermarktungsartGewerbe;
        ObjektkategorieGewerbeBueroPraxen objektkategorieGewerbeBueroPraxen = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGewerbeBueroPraxen = this.getObjektkategorieGewerbeBueroPraxen(list.get(i))) == null; --i) {
        }
        if (objektkategorieGewerbeBueroPraxen == null) {
            objektkategorieGewerbeBueroPraxen = ObjektkategorieGewerbeBueroPraxen.KEINE_ANGABE;
        }
        gewerbeBueroPraxis.setObjektkategorie(objektkategorieGewerbeBueroPraxen);
        VermarktungsartGewerbe vermarktungsartGewerbe2 = this.getVermarktungsartGewerbe(estateImpl.getAction());
        if (vermarktungsartGewerbe2 == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        gewerbeBueroPraxis.setVermarktungsart(vermarktungsartGewerbe2);
        gewerbeBueroPraxis.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setBodenbelag(this.getBodenbelag(FlooringMaterial.getAsList((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gewerbeBueroPraxis.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        gewerbeBueroPraxis.setGesamtflaeche((Number)TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeBueroPraxis.setGewerbeflaeche((Number)CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeBueroPraxis.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setKantineCafeteria(CanteenCafeteria.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeBueroPraxis.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setKlimaanlage(this.getAuswahl(AirConditioned.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setNebenflaeche((Number)RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeBueroPraxis.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        gewerbeBueroPraxis.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeBueroPraxis.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (Technics.hasOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING)) {
            gewerbeBueroPraxis.setDvVerkabelung(Auswahl.JA);
        }
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        gewerbeBueroPraxis.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            gewerbeBueroPraxis.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            gewerbeBueroPraxis.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            gewerbeBueroPraxis.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            gewerbeBueroPraxis.setKaltmiete((Number)Lease.get((EstateImpl)estateImpl));
            gewerbeBueroPraxis.setKaltmietePro(KaltmietePro.MONAT);
            gewerbeBueroPraxis.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        } else {
            vermarktungsartGewerbe = gewerbeBueroPraxis.getVermarktungsart();
            switch (vermarktungsartGewerbe) {
                case KAUF: {
                    gewerbeBueroPraxis.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                    gewerbeBueroPraxis.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
                    break;
                }
                case MIETE: {
                    if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES)) {
                        gewerbeBueroPraxis.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                        gewerbeBueroPraxis.setKaltmietePro(KaltmietePro.MONAT);
                    } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA)) {
                        gewerbeBueroPraxis.setKaltmiete((Number)RentExcludingServiceChargesPerArea.get((EstateImpl)estateImpl));
                        gewerbeBueroPraxis.setKaltmietePro(KaltmietePro.QUADRATMETER);
                    }
                    gewerbeBueroPraxis.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
                    break;
                }
            }
        }
        if (Technics.hasOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.HIGH_VOLTAGE_CURRENT)) {
            gewerbeBueroPraxis.setStarkstrom(Boolean.valueOf(true));
        }
        if (gewerbeBueroPraxis.getGewerbeflaeche() == null) {
            vermarktungsartGewerbe = estateImpl.getPrimaryAreaValue();
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = OfficeArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = UsableArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = TotalArea.get((EstateImpl)estateImpl);
            }
            gewerbeBueroPraxis.setGewerbeflaeche(vermarktungsartGewerbe != null ? AreaValue.convert((BigDecimal)vermarktungsartGewerbe.getValue(), (AreaValue.Unit)vermarktungsartGewerbe.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GewerbeEinzelhandel gewerbeEinzelhandel, EstateImpl estateImpl) throws OpenEstateException {
        VermarktungsartGewerbe vermarktungsartGewerbe;
        ObjektkategorieGewerbeEinzelhandel objektkategorieGewerbeEinzelhandel = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGewerbeEinzelhandel = this.getObjektkategorieGewerbeEinzelhandel(list.get(i))) == null; --i) {
        }
        if (objektkategorieGewerbeEinzelhandel == null) {
            objektkategorieGewerbeEinzelhandel = ObjektkategorieGewerbeEinzelhandel.KEINE_ANGABE;
        }
        gewerbeEinzelhandel.setObjektkategorie(objektkategorieGewerbeEinzelhandel);
        VermarktungsartGewerbe vermarktungsartGewerbe2 = this.getVermarktungsartGewerbe(estateImpl.getAction());
        if (vermarktungsartGewerbe2 == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        gewerbeEinzelhandel.setVermarktungsart(vermarktungsartGewerbe2);
        gewerbeEinzelhandel.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setBodenbelag(this.getBodenbelag(FlooringMaterial.getAsList((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setDeckenlast(CeilingLoad.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gewerbeEinzelhandel.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        gewerbeEinzelhandel.setGesamtflaeche((Number)TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeEinzelhandel.setGewerbeflaeche((Number)CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeEinzelhandel.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeEinzelhandel.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setLage(this.getLage(CommercialZone.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setLastenaufzug(FreightElevator.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setLastenaufzugTragkraft(FreightElevatorCapacity.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setNebenflaeche((Number)RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeEinzelhandel.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        gewerbeEinzelhandel.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setRampe(Ramp.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setSchaufensterfront((Number)FrontWindowArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeEinzelhandel.setTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeEinzelhandel.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeEinzelhandel.setZulieferung(this.getZulieferung(SupplyAccess.getAsList((EstateImpl)estateImpl)));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        gewerbeEinzelhandel.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            gewerbeEinzelhandel.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            gewerbeEinzelhandel.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            gewerbeEinzelhandel.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            gewerbeEinzelhandel.setKaltmiete((Number)Lease.get((EstateImpl)estateImpl));
            gewerbeEinzelhandel.setKaltmietePro(KaltmietePro.MONAT);
            gewerbeEinzelhandel.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        } else {
            vermarktungsartGewerbe = gewerbeEinzelhandel.getVermarktungsart();
            switch (vermarktungsartGewerbe) {
                case KAUF: {
                    gewerbeEinzelhandel.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                    gewerbeEinzelhandel.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
                    break;
                }
                case MIETE: {
                    if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES)) {
                        gewerbeEinzelhandel.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                        gewerbeEinzelhandel.setKaltmietePro(KaltmietePro.MONAT);
                    } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA)) {
                        gewerbeEinzelhandel.setKaltmiete((Number)RentExcludingServiceChargesPerArea.get((EstateImpl)estateImpl));
                        gewerbeEinzelhandel.setKaltmietePro(KaltmietePro.QUADRATMETER);
                    }
                    gewerbeEinzelhandel.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
                    break;
                }
            }
        }
        if (gewerbeEinzelhandel.getGewerbeflaeche() == null) {
            vermarktungsartGewerbe = estateImpl.getPrimaryAreaValue();
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = RetailArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = SalesArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = UsableArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = TotalArea.get((EstateImpl)estateImpl);
            }
            gewerbeEinzelhandel.setGewerbeflaeche(vermarktungsartGewerbe != null ? AreaValue.convert((BigDecimal)vermarktungsartGewerbe.getValue(), (AreaValue.Unit)vermarktungsartGewerbe.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GewerbeGastronomieHotel gewerbeGastronomieHotel, EstateImpl estateImpl) throws OpenEstateException {
        VermarktungsartGewerbe vermarktungsartGewerbe;
        ObjektkategorieGewerbeGastronomieHotel objektkategorieGewerbeGastronomieHotel = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGewerbeGastronomieHotel = this.getObjektkategorieGewerbeGastronomieHotel(list.get(i))) == null; --i) {
        }
        if (objektkategorieGewerbeGastronomieHotel == null) {
            objektkategorieGewerbeGastronomieHotel = ObjektkategorieGewerbeGastronomieHotel.GAESTEHAUS;
        }
        gewerbeGastronomieHotel.setObjektkategorie(objektkategorieGewerbeGastronomieHotel);
        VermarktungsartGewerbe vermarktungsartGewerbe2 = this.getVermarktungsartGewerbe(estateImpl.getAction());
        if (vermarktungsartGewerbe2 == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        gewerbeGastronomieHotel.setVermarktungsart(vermarktungsartGewerbe2);
        gewerbeGastronomieHotel.setAnzahlBetten(CountBeds.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setAnzahlGastraumplaetze(CountGuestrooms.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gewerbeGastronomieHotel.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        gewerbeGastronomieHotel.setGastterrasse(GuestTerrace.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setGesamtflaeche((Number)TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeGastronomieHotel.setGewerbeflaeche((Number)CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeGastronomieHotel.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeGastronomieHotel.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setNebenflaeche((Number)RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeGastronomieHotel.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        gewerbeGastronomieHotel.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        gewerbeGastronomieHotel.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            gewerbeGastronomieHotel.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            gewerbeGastronomieHotel.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            gewerbeGastronomieHotel.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            gewerbeGastronomieHotel.setPreis((Number)Lease.get((EstateImpl)estateImpl));
            gewerbeGastronomieHotel.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        } else {
            vermarktungsartGewerbe = gewerbeGastronomieHotel.getVermarktungsart();
            switch (vermarktungsartGewerbe) {
                case KAUF: {
                    gewerbeGastronomieHotel.setPreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                    gewerbeGastronomieHotel.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
                    break;
                }
                case MIETE: {
                    gewerbeGastronomieHotel.setPreis((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                    gewerbeGastronomieHotel.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
                    break;
                }
            }
        }
        if (gewerbeGastronomieHotel.getGewerbeflaeche() == null) {
            vermarktungsartGewerbe = estateImpl.getPrimaryAreaValue();
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = SeatingArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = CommercialArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = UsableArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = TotalArea.get((EstateImpl)estateImpl);
            }
            gewerbeGastronomieHotel.setGewerbeflaeche(vermarktungsartGewerbe != null ? AreaValue.convert((BigDecimal)vermarktungsartGewerbe.getValue(), (AreaValue.Unit)vermarktungsartGewerbe.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GewerbeHalleProduktion gewerbeHalleProduktion, EstateImpl estateImpl) throws OpenEstateException {
        VermarktungsartGewerbe vermarktungsartGewerbe;
        ObjektkategorieGewerbeHalleProduktion objektkategorieGewerbeHalleProduktion = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGewerbeHalleProduktion = this.getObjektkategorieGewerbeHalleProduktion(list.get(i))) == null; --i) {
        }
        if (objektkategorieGewerbeHalleProduktion == null) {
            objektkategorieGewerbeHalleProduktion = ObjektkategorieGewerbeHalleProduktion.KEINE_ANGABE;
        }
        gewerbeHalleProduktion.setObjektkategorie(objektkategorieGewerbeHalleProduktion);
        VermarktungsartGewerbe vermarktungsartGewerbe2 = this.getVermarktungsartGewerbe(estateImpl.getAction());
        if (vermarktungsartGewerbe2 == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        gewerbeHalleProduktion.setVermarktungsart(vermarktungsartGewerbe2);
        gewerbeHalleProduktion.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setBodenbelag(this.getBodenbelag(FlooringMaterial.getAsList((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setBodenbelastung(FloorLoading.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gewerbeHalleProduktion.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        gewerbeHalleProduktion.setGesamtflaeche((Number)TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeHalleProduktion.setGewerbeflaeche((Number)CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeHalleProduktion.setGrundstuecksflaeche((Number)PlotArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeHalleProduktion.setHallenhoehe((Number)WarehouseHeight.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        gewerbeHalleProduktion.setHebebuehne(LiftingPlatform.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeHalleProduktion.setKranbahn(Crane.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setKranbahnTragkraft(CraneLiftingCapacity.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setLastenaufzug(FreightElevator.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setLastenaufzugTragkraft(FreightElevatorCapacity.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setNebenflaeche((Number)RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeHalleProduktion.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        gewerbeHalleProduktion.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setRampe(Ramp.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setStromanschlusswert(ElectricalConnectionValue.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeHalleProduktion.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        gewerbeHalleProduktion.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            gewerbeHalleProduktion.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            gewerbeHalleProduktion.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            gewerbeHalleProduktion.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            gewerbeHalleProduktion.setKaltmiete((Number)Lease.get((EstateImpl)estateImpl));
            gewerbeHalleProduktion.setKaltmietePro(KaltmietePro.MONAT);
            gewerbeHalleProduktion.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        } else {
            vermarktungsartGewerbe = gewerbeHalleProduktion.getVermarktungsart();
            switch (vermarktungsartGewerbe) {
                case KAUF: {
                    gewerbeHalleProduktion.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                    gewerbeHalleProduktion.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
                    break;
                }
                case MIETE: {
                    if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES)) {
                        gewerbeHalleProduktion.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                        gewerbeHalleProduktion.setKaltmietePro(KaltmietePro.MONAT);
                    } else if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_RENT_EXCLUDING_SERVICE_CHARGES_PER_AREA)) {
                        gewerbeHalleProduktion.setKaltmiete((Number)RentExcludingServiceChargesPerArea.get((EstateImpl)estateImpl));
                        gewerbeHalleProduktion.setKaltmietePro(KaltmietePro.QUADRATMETER);
                    }
                    gewerbeHalleProduktion.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
                    break;
                }
            }
        }
        if (gewerbeHalleProduktion.getGewerbeflaeche() == null) {
            vermarktungsartGewerbe = estateImpl.getPrimaryAreaValue();
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = StorageArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = CommercialArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = UsableArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = TotalArea.get((EstateImpl)estateImpl);
            }
            gewerbeHalleProduktion.setGewerbeflaeche(vermarktungsartGewerbe != null ? AreaValue.convert((BigDecimal)vermarktungsartGewerbe.getValue(), (AreaValue.Unit)vermarktungsartGewerbe.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GewerbeSonstiges gewerbeSonstiges, EstateImpl estateImpl) throws OpenEstateException {
        VermarktungsartGewerbe vermarktungsartGewerbe;
        ObjektkategorieGewerbeSonstiges objektkategorieGewerbeSonstiges = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGewerbeSonstiges = this.getObjektkategorieGewerbeSonstiges(list.get(i))) == null; --i) {
        }
        if (objektkategorieGewerbeSonstiges == null) {
            objektkategorieGewerbeSonstiges = ObjektkategorieGewerbeSonstiges.GEWERBEFLAECHE;
        }
        gewerbeSonstiges.setObjektkategorie(objektkategorieGewerbeSonstiges);
        VermarktungsartGewerbe vermarktungsartGewerbe2 = this.getVermarktungsartGewerbe(estateImpl.getAction());
        if (vermarktungsartGewerbe2 == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        gewerbeSonstiges.setVermarktungsart(vermarktungsartGewerbe2);
        gewerbeSonstiges.setAnzahlParkflaechen(CountParkingSpaces.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        gewerbeSonstiges.setBodenbelag(this.getBodenbelag(FlooringMaterial.getAsList((EstateImpl)estateImpl)));
        gewerbeSonstiges.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setEtagen(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gewerbeSonstiges.setFahrtwegAutobahn((Number)Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setFahrtwegFlughafen((Number)Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setFahrtwegHauptbahnhof((Number)Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setFusswegNahverkehr((Number)Is24Utils.getFusswegZeit((LengthValue)ObjectUtils.defaultIfNull((Object)DistanceToBusStation.get((EstateImpl)estateImpl), (Object)DistanceToNextTrainStation.get((EstateImpl)estateImpl))));
        gewerbeSonstiges.setGesamtflaeche((Number)TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeSonstiges.setGewerbeflaeche((Number)CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeSonstiges.setGrundstuecksflaeche((Number)PlotArea.getAsDouble((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeSonstiges.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        gewerbeSonstiges.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        gewerbeSonstiges.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setNebenflaeche((Number)RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeSonstiges.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        gewerbeSonstiges.setPersonenaufzug(Lift.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gewerbeSonstiges.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        gewerbeSonstiges.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            gewerbeSonstiges.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            gewerbeSonstiges.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            gewerbeSonstiges.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            gewerbeSonstiges.setPreis((Number)Lease.get((EstateImpl)estateImpl));
            gewerbeSonstiges.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        } else {
            vermarktungsartGewerbe = gewerbeSonstiges.getVermarktungsart();
            switch (vermarktungsartGewerbe) {
                case KAUF: {
                    gewerbeSonstiges.setPreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                    gewerbeSonstiges.setPreisProParkflaeche((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
                    break;
                }
                case MIETE: {
                    gewerbeSonstiges.setPreis((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                    gewerbeSonstiges.setPreisProParkflaeche((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
                    break;
                }
            }
        }
        if (gewerbeSonstiges.getGewerbeflaeche() == null) {
            vermarktungsartGewerbe = estateImpl.getPrimaryAreaValue();
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = CommercialArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = UsableArea.get((EstateImpl)estateImpl);
            }
            if (vermarktungsartGewerbe == null) {
                vermarktungsartGewerbe = TotalArea.get((EstateImpl)estateImpl);
            }
            gewerbeSonstiges.setGewerbeflaeche(vermarktungsartGewerbe != null ? AreaValue.convert((BigDecimal)vermarktungsartGewerbe.getValue(), (AreaValue.Unit)vermarktungsartGewerbe.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GrundstueckGewerbe grundstueckGewerbe, EstateImpl estateImpl) throws OpenEstateException {
        ObjektkategorieGrundstueck objektkategorieGrundstueck = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieGrundstueck = this.getObjektkategorieGrundstueck(list.get(i))) == null; --i) {
        }
        if (objektkategorieGrundstueck == null || ObjektkategorieGrundstueck.WOHNEN.equals((Object)objektkategorieGrundstueck)) {
            objektkategorieGrundstueck = ObjektkategorieGrundstueck.GEWERBE;
        }
        grundstueckGewerbe.setObjektkategorie(objektkategorieGrundstueck);
        Vermarktungsart vermarktungsart = this.getVermarktungsart(estateImpl.getAction());
        if (vermarktungsart == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        grundstueckGewerbe.setVermarktungsart(vermarktungsart);
        grundstueckGewerbe.setAbrissErforderlich(DemolitionRequired.get((EstateImpl)estateImpl));
        grundstueckGewerbe.setBaugenehmigungVorhanden(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        grundstueckGewerbe.setBebaubarNach(this.getBebaubarNach(BuildableAccordingTo.get((EstateImpl)estateImpl)));
        grundstueckGewerbe.setEmpfohleneNutzung(this.getNutzungGrundstueckGewerbe(BuildableWith.getAsList((EstateImpl)estateImpl)));
        grundstueckGewerbe.setErschliessung(this.getErschliessung(Development.get((EstateImpl)estateImpl)));
        grundstueckGewerbe.setFlaecheTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        grundstueckGewerbe.setGeschossflaechenzahl(FloorAreaIndex.get((EstateImpl)estateImpl));
        grundstueckGewerbe.setGrundflaechenzahl(BaseAreaIndex.get((EstateImpl)estateImpl));
        grundstueckGewerbe.setGrundstuecksflaeche((Number)PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        grundstueckGewerbe.setKurzfristigBebaubar(BuildableInShortTerm.get((EstateImpl)estateImpl));
        grundstueckGewerbe.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        switch (grundstueckGewerbe.getVermarktungsart()) {
            case ERBPACHT: {
                grundstueckGewerbe.setPreis((Number)Lease.get((EstateImpl)estateImpl));
                grundstueckGewerbe.setErbpachtdauer(EmphyteusisDuration.get((EstateImpl)estateImpl));
                if (grundstueckGewerbe.getErbpachtdauer() != null) break;
                grundstueckGewerbe.setErbpachtdauer((Number)0);
                break;
            }
            case KAUF: {
                grundstueckGewerbe.setPreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                break;
            }
            case MIETE: {
                grundstueckGewerbe.setPreis((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                break;
            }
            case PACHT: {
                grundstueckGewerbe.setPreis((Number)Lease.get((EstateImpl)estateImpl));
                break;
            }
        }
        if (grundstueckGewerbe.getGrundstuecksflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            grundstueckGewerbe.setGrundstuecksflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(GrundstueckWohnen grundstueckWohnen, EstateImpl estateImpl) throws OpenEstateException {
        grundstueckWohnen.setObjektkategorie(ObjektkategorieGrundstueck.WOHNEN);
        Vermarktungsart vermarktungsart = this.getVermarktungsart(estateImpl.getAction());
        if (vermarktungsart == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        grundstueckWohnen.setVermarktungsart(vermarktungsart);
        grundstueckWohnen.setAbrissErforderlich(DemolitionRequired.get((EstateImpl)estateImpl));
        grundstueckWohnen.setBaugenehmigungVorhanden(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        grundstueckWohnen.setBebaubarNach(this.getBebaubarNach(BuildableAccordingTo.get((EstateImpl)estateImpl)));
        grundstueckWohnen.setEmpfohleneNutzung(this.getNutzungGrundstueckWohnen(BuildableWith.getAsList((EstateImpl)estateImpl)));
        grundstueckWohnen.setErschliessung(this.getErschliessung(Development.get((EstateImpl)estateImpl)));
        grundstueckWohnen.setGrundstuecksflaeche((Number)PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        grundstueckWohnen.setFlaecheTeilbarAb((Number)DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        grundstueckWohnen.setGeschossflaechenzahl(FloorAreaIndex.get((EstateImpl)estateImpl));
        grundstueckWohnen.setGrundflaechenzahl(BaseAreaIndex.get((EstateImpl)estateImpl));
        grundstueckWohnen.setKurzfristigBebaubar(BuildableInShortTerm.get((EstateImpl)estateImpl));
        grundstueckWohnen.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        switch (grundstueckWohnen.getVermarktungsart()) {
            case ERBPACHT: {
                grundstueckWohnen.setPreis((Number)Lease.get((EstateImpl)estateImpl));
                grundstueckWohnen.setErbpachtdauer(EmphyteusisDuration.get((EstateImpl)estateImpl));
                if (grundstueckWohnen.getErbpachtdauer() != null) break;
                grundstueckWohnen.setErbpachtdauer((Number)0);
                break;
            }
            case KAUF: {
                grundstueckWohnen.setPreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
                break;
            }
            case MIETE: {
                grundstueckWohnen.setPreis((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
                break;
            }
            case PACHT: {
                grundstueckWohnen.setPreis((Number)Lease.get((EstateImpl)estateImpl));
                break;
            }
        }
        if (grundstueckWohnen.getGrundstuecksflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            grundstueckWohnen.setGrundstuecksflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(HausKauf hausKauf, EstateImpl estateImpl) {
        ObjektkategorieHaus objektkategorieHaus = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieHaus = this.getObjektkategorieHaus(list.get(i))) == null; --i) {
        }
        if (objektkategorieHaus == null) {
            objektkategorieHaus = ObjektkategorieHaus.KEINE_ANGABE;
        }
        hausKauf.setObjektkategorie(objektkategorieHaus);
        hausKauf.setAnzahlBadezimmer(CountBathrooms.get((EstateImpl)estateImpl));
        hausKauf.setAnzahlGarageStellplatz(CountParkingSpaces.get((EstateImpl)estateImpl));
        hausKauf.setAnzahlSchlafzimmer(CountBedrooms.get((EstateImpl)estateImpl));
        hausKauf.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        hausKauf.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        hausKauf.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        hausKauf.setBauphase(this.getBauphase(ConstructionPhase.get((EstateImpl)estateImpl)));
        hausKauf.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        hausKauf.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        hausKauf.setEinliegerwohnung(GrannyFlat.get((EstateImpl)estateImpl));
        hausKauf.setEtagenzahl(CountFloors.get((EstateImpl)estateImpl));
        hausKauf.setFerienhaus(HolidayProperty.get((EstateImpl)estateImpl));
        hausKauf.setGrundstuecksflaeche((Number)ObjectUtils.defaultIfNull((Object)PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), (Object)0));
        hausKauf.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        hausKauf.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
        hausKauf.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        hausKauf.setMieteinnahmenProMonat((Number)RentalIncomePerMonth.get((EstateImpl)estateImpl));
        hausKauf.setNutzflaeche((Number)UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        hausKauf.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        hausKauf.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        hausKauf.setStellplatz(this.getStellplatz(CarParkingType.getAsList((EstateImpl)estateImpl)));
        hausKauf.setStellplatzpreis((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
        hausKauf.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        hausKauf.setVermietet(Rented.get((EstateImpl)estateImpl));
        hausKauf.setWohnflaeche((Number)ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        hausKauf.setZimmer((Number)ObjectUtils.defaultIfNull((Object)CountRooms.get((EstateImpl)estateImpl), (Object)0));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        hausKauf.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            hausKauf.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            hausKauf.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            hausKauf.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            hausKauf.setGaesteWc(Boolean.valueOf(true));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            hausKauf.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        if (hausKauf.getWohnflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            hausKauf.setWohnflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(HausMiete hausMiete, EstateImpl estateImpl) {
        ObjektkategorieHaus objektkategorieHaus = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieHaus = this.getObjektkategorieHaus(list.get(i))) == null; --i) {
        }
        if (objektkategorieHaus == null) {
            objektkategorieHaus = ObjektkategorieHaus.KEINE_ANGABE;
        }
        hausMiete.setObjektkategorie(objektkategorieHaus);
        hausMiete.setAnzahlBadezimmer(CountBathrooms.get((EstateImpl)estateImpl));
        hausMiete.setAnzahlGarageStellplatz(CountParkingSpaces.get((EstateImpl)estateImpl));
        hausMiete.setAnzahlSchlafzimmer(CountBedrooms.get((EstateImpl)estateImpl));
        hausMiete.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        hausMiete.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        hausMiete.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        hausMiete.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        hausMiete.setEtagenzahl(CountFloors.get((EstateImpl)estateImpl));
        hausMiete.setGrundstuecksflaeche((Number)ObjectUtils.defaultIfNull((Object)PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM), (Object)0));
        hausMiete.setHaustiere(this.getHaustiere(Pets.get((EstateImpl)estateImpl)));
        hausMiete.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        hausMiete.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        hausMiete.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        hausMiete.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        hausMiete.setNutzflaeche((Number)UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        hausMiete.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        hausMiete.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        hausMiete.setStellplatz(this.getStellplatz(CarParkingType.getAsList((EstateImpl)estateImpl)));
        hausMiete.setStellplatzmiete((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        hausMiete.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        hausMiete.setWarmmiete((Number)RentIncludingServiceCharges.get((EstateImpl)estateImpl));
        hausMiete.setWohnflaeche((Number)ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        hausMiete.setZimmer((Number)ObjectUtils.defaultIfNull((Object)CountRooms.get((EstateImpl)estateImpl), (Object)0));
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            hausMiete.setEinbaukueche(Boolean.valueOf(true));
        }
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        hausMiete.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            hausMiete.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            hausMiete.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            hausMiete.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            hausMiete.setGaesteWc(Boolean.valueOf(true));
        }
        Double d = HeatingCosts.getAsDouble((EstateImpl)estateImpl);
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        if (d != null && d > 0.0 && bl != null) {
            hausMiete.setHeizkosten((Number)d);
            hausMiete.setNebenkostenInklHeizkosten(bl);
        }
        if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            hausMiete.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            hausMiete.setKaltmiete((Number)Lease.get((EstateImpl)estateImpl));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            hausMiete.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS)) {
            hausMiete.setSeniorengerecht(Boolean.valueOf(true));
        }
        if (hausMiete.getWohnflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            hausMiete.setWohnflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(StellplatzKauf stellplatzKauf, EstateImpl estateImpl) {
        ObjektkategorieStellplatz objektkategorieStellplatz = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieStellplatz = this.getObjektkategorieStellplatz(list.get(i))) == null; --i) {
        }
        if (objektkategorieStellplatz == null) {
            objektkategorieStellplatz = ObjektkategorieStellplatz.KEINE_ANGABE;
        }
        stellplatzKauf.setObjektkategorie(objektkategorieStellplatz);
        stellplatzKauf.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        stellplatzKauf.setBreite((Number)Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzKauf.setFlaeche((Number)CarParkingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        stellplatzKauf.setHoehe((Number)Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzKauf.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
        stellplatzKauf.setLaenge((Number)Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzKauf.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        stellplatzKauf.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
    }

    protected void setupRecord(StellplatzMiete stellplatzMiete, EstateImpl estateImpl) {
        ObjektkategorieStellplatz objektkategorieStellplatz = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieStellplatz = this.getObjektkategorieStellplatz(list.get(i))) == null; --i) {
        }
        if (objektkategorieStellplatz == null) {
            objektkategorieStellplatz = ObjektkategorieStellplatz.KEINE_ANGABE;
        }
        stellplatzMiete.setObjektkategorie(objektkategorieStellplatz);
        stellplatzMiete.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        stellplatzMiete.setBreite((Number)Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzMiete.setFlaeche((Number)CarParkingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        stellplatzMiete.setFreiAb(AvailabilityBeginDate.get((EstateImpl)estateImpl));
        stellplatzMiete.setFreiBis(AvailabilityEndDate.get((EstateImpl)estateImpl));
        stellplatzMiete.setHoehe((Number)Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzMiete.setLaenge((Number)Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        stellplatzMiete.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        stellplatzMiete.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            stellplatzMiete.setMiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            stellplatzMiete.setMiete((Number)Lease.get((EstateImpl)estateImpl));
        }
    }

    protected void setupRecord(WohnenAufZeit wohnenAufZeit, EstateImpl estateImpl) {
        ObjektkategorieWohnenAufZeit objektkategorieWohnenAufZeit = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieWohnenAufZeit = this.getObjektkategorieWohnenAufZeit(list.get(i))) == null; --i) {
        }
        if (objektkategorieWohnenAufZeit == null) {
            objektkategorieWohnenAufZeit = ObjektkategorieWohnenAufZeit.WOHNUNG;
        }
        wohnenAufZeit.setObjektkategorie(objektkategorieWohnenAufZeit);
        wohnenAufZeit.setAnzahlGarageStellplatz(CountParkingSpaces.get((EstateImpl)estateImpl));
        wohnenAufZeit.setAnzahlPersonen(PeopleMaximumCount.get((EstateImpl)estateImpl));
        wohnenAufZeit.setAufzug(Lift.get((EstateImpl)estateImpl));
        wohnenAufZeit.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        wohnenAufZeit.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        wohnenAufZeit.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        wohnenAufZeit.setEtagenzahl(CountFloors.get((EstateImpl)estateImpl));
        wohnenAufZeit.setFreiAb(AvailabilityBeginDate.get((EstateImpl)estateImpl));
        wohnenAufZeit.setFreiBis(AvailabilityEndDate.get((EstateImpl)estateImpl));
        wohnenAufZeit.setGartennutzung(GardenUse.get((EstateImpl)estateImpl));
        wohnenAufZeit.setGeschlecht(this.getGeschlecht(GenderOfRequestedFlatmates.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setHaustiere(this.getHaustiere(Pets.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setHeizungsart(this.getHeizungsartWohnenAufZeit(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        wohnenAufZeit.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
        wohnenAufZeit.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        wohnenAufZeit.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setMobiliar(this.getMobiliar(Furnished.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        wohnenAufZeit.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setPauschalmiete((Number)RentFlatRate.get((EstateImpl)estateImpl));
        wohnenAufZeit.setPauschalmietePro(this.getPauschalmietePro(RentFlatRatePer.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setRauchen(this.getRauchen(NonSmoker.get((EstateImpl)estateImpl)));
        wohnenAufZeit.setStellplatz(this.getStellplatz(CarParkingType.getAsList((EstateImpl)estateImpl)));
        wohnenAufZeit.setStellplatzmiete((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        wohnenAufZeit.setWohnflaeche((Number)ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        wohnenAufZeit.setZimmer((Number)ObjectUtils.defaultIfNull((Object)CountRooms.get((EstateImpl)estateImpl), (Object)0));
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        wohnenAufZeit.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            wohnenAufZeit.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            wohnenAufZeit.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            wohnenAufZeit.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        wohnenAufZeit.setEtage((Number)Is24Utils.toDouble(Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            wohnenAufZeit.setGaesteWc(Boolean.valueOf(true));
        }
        wohnenAufZeit.setMietdauerMaximum((Number)Is24Utils.toDouble(OccupationPeriodMaximum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        wohnenAufZeit.setMietdauerMinimum((Number)Is24Utils.toDouble(OccupationPeriodMinimum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            wohnenAufZeit.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        if (wohnenAufZeit.getWohnflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            wohnenAufZeit.setWohnflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(WohnungKauf wohnungKauf, EstateImpl estateImpl) {
        ObjektkategorieWohnung objektkategorieWohnung = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieWohnung = this.getObjektkategorieWohnung(list.get(i))) == null; --i) {
        }
        if (objektkategorieWohnung == null) {
            objektkategorieWohnung = ObjektkategorieWohnung.KEINE_ANGABE;
        }
        wohnungKauf.setObjektkategorie(objektkategorieWohnung);
        wohnungKauf.setAnzahlBadezimmer(CountBathrooms.get((EstateImpl)estateImpl));
        wohnungKauf.setAnzahlGarageStellplatz(CountParkingSpaces.get((EstateImpl)estateImpl));
        wohnungKauf.setAnzahlSchlafzimmer(CountBedrooms.get((EstateImpl)estateImpl));
        wohnungKauf.setAufzug(Lift.get((EstateImpl)estateImpl));
        wohnungKauf.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        wohnungKauf.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        wohnungKauf.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        wohnungKauf.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        wohnungKauf.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        wohnungKauf.setDenkmalschutz(MonumentalProtection.get((EstateImpl)estateImpl));
        wohnungKauf.setEtagenzahl(CountFloors.get((EstateImpl)estateImpl));
        wohnungKauf.setFerienwohnung(HolidayProperty.get((EstateImpl)estateImpl));
        wohnungKauf.setGartennutzung(GardenUse.get((EstateImpl)estateImpl));
        wohnungKauf.setHausgeld((Number)CommonCharge.get((EstateImpl)estateImpl));
        wohnungKauf.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        wohnungKauf.setKaufpreis((Number)PurchasePrice.get((EstateImpl)estateImpl));
        wohnungKauf.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        wohnungKauf.setMieteinnahmenProMonat((Number)RentalIncomePerMonth.get((EstateImpl)estateImpl));
        wohnungKauf.setNutzflaeche((Number)UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        wohnungKauf.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        wohnungKauf.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        wohnungKauf.setStellplatz(this.getStellplatz(CarParkingType.getAsList((EstateImpl)estateImpl)));
        wohnungKauf.setStellplatzpreis((Number)CarParkingSpacePrice.get((EstateImpl)estateImpl));
        wohnungKauf.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        wohnungKauf.setVermietet(Rented.get((EstateImpl)estateImpl));
        wohnungKauf.setWohnflaeche((Number)ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        wohnungKauf.setZimmer((Number)ObjectUtils.defaultIfNull((Object)CountRooms.get((EstateImpl)estateImpl), (Object)0));
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            wohnungKauf.setEinbaukueche(Boolean.valueOf(true));
        }
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        wohnungKauf.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            wohnungKauf.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            wohnungKauf.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            wohnungKauf.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        wohnungKauf.setEtage((Number)Is24Utils.toDouble(Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            wohnungKauf.setGaesteWc(Boolean.valueOf(true));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            wohnungKauf.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS)) {
            wohnungKauf.setSeniorengerecht(Boolean.valueOf(true));
        }
        if (wohnungKauf.getWohnflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            wohnungKauf.setWohnflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }

    protected void setupRecord(WohnungMiete wohnungMiete, EstateImpl estateImpl) {
        ObjektkategorieWohnung objektkategorieWohnung = null;
        List<OpenEstateType> list = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list.size() - 1; i >= 0 && (objektkategorieWohnung = this.getObjektkategorieWohnung(list.get(i))) == null; --i) {
        }
        if (objektkategorieWohnung == null) {
            objektkategorieWohnung = ObjektkategorieWohnung.KEINE_ANGABE;
        }
        wohnungMiete.setObjektkategorie(objektkategorieWohnung);
        wohnungMiete.setAnzahlBadezimmer(CountBathrooms.get((EstateImpl)estateImpl));
        wohnungMiete.setAnzahlGarageStellplatz(CountParkingSpaces.get((EstateImpl)estateImpl));
        wohnungMiete.setAnzahlSchlafzimmer(CountBedrooms.get((EstateImpl)estateImpl));
        wohnungMiete.setAufzug(Lift.get((EstateImpl)estateImpl));
        wohnungMiete.setBalkonTerrasse(BalconyTerrace.get((EstateImpl)estateImpl));
        wohnungMiete.setBarrierefrei(BarrierFree.get((EstateImpl)estateImpl));
        wohnungMiete.setBaujahr(BuildYear.get((EstateImpl)estateImpl));
        wohnungMiete.setEtagenzahl(CountFloors.get((EstateImpl)estateImpl));
        wohnungMiete.setFoerderung(WbsRequired.get((EstateImpl)estateImpl));
        wohnungMiete.setGartennutzung(GardenUse.get((EstateImpl)estateImpl));
        wohnungMiete.setKaution((String)StringUtils.defaultIfBlank((CharSequence)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        wohnungMiete.setNebenkosten((Number)ServiceCharges.get((EstateImpl)estateImpl));
        wohnungMiete.setNutzflaeche((Number)UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        wohnungMiete.setSanierungsjahr(RefurbishmentYear.get((EstateImpl)estateImpl));
        wohnungMiete.setStellplatzmiete((Number)CarParkingSpaceRent.get((EstateImpl)estateImpl));
        wohnungMiete.setVerfuegbarAb((String)StringUtils.defaultIfBlank((CharSequence)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (CharSequence)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        wohnungMiete.setWarmmiete((Number)RentIncludingServiceCharges.get((EstateImpl)estateImpl));
        wohnungMiete.setWohnflaeche((Number)ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        wohnungMiete.setZimmer((Number)ObjectUtils.defaultIfNull((Object)CountRooms.get((EstateImpl)estateImpl), (Object)0));
        wohnungMiete.setAusstattung(this.getAusstattung(Equipment.get((EstateImpl)estateImpl)));
        wohnungMiete.setBefeuerungsart(this.getBefeuerungsart(TypeOfBeaconing.getAsList((EstateImpl)estateImpl)));
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            wohnungMiete.setEinbaukueche(Boolean.valueOf(true));
        }
        EnergieausweisTyp energieausweisTyp = this.getEnergieausweisTyp(Type.get((EstateImpl)estateImpl));
        wohnungMiete.setEnergieausweisTyp(energieausweisTyp);
        if (EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            wohnungMiete.setEnergieausweisKennwert((Number)DemandTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
        } else if (EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            wohnungMiete.setEnergieausweisKennwert((Number)ConsumptionTotal.get((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR));
            wohnungMiete.setEnergieausweisInklWarmwasser(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl));
        }
        wohnungMiete.setEtage((Number)Is24Utils.toDouble(Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            wohnungMiete.setGaesteWc(Boolean.valueOf(true));
        }
        wohnungMiete.setHaustiere(this.getHaustiere(Pets.get((EstateImpl)estateImpl)));
        Double d = HeatingCosts.getAsDouble((EstateImpl)estateImpl);
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        if (d != null && d > 0.0 && bl != null) {
            wohnungMiete.setHeizkosten((Number)d);
            wohnungMiete.setNebenkostenInklHeizkosten(bl);
        }
        wohnungMiete.setHeizungsart(this.getHeizungsart(TypeOfHeating.getAsList((EstateImpl)estateImpl)));
        wohnungMiete.setKeller(this.getKeller(UndergroundLevel.get((EstateImpl)estateImpl)));
        if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            wohnungMiete.setKaltmiete((Number)RentExcludingServiceCharges.get((EstateImpl)estateImpl));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            wohnungMiete.setKaltmiete((Number)Lease.get((EstateImpl)estateImpl));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR)) {
            wohnungMiete.setRollstuhlgerecht(Boolean.valueOf(true));
        }
        if (Applicability.hasOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS)) {
            wohnungMiete.setSeniorengerecht(Boolean.valueOf(true));
        }
        wohnungMiete.setStellplatz(this.getStellplatz(CarParkingType.getAsList((EstateImpl)estateImpl)));
        wohnungMiete.setObjektzustand(this.getObjektzustand(ConditionType.get((EstateImpl)estateImpl)));
        if (wohnungMiete.getWohnflaeche() == null) {
            AreaValue areaValue = estateImpl.getPrimaryAreaValue();
            if (areaValue == null) {
                areaValue = UsableArea.get((EstateImpl)estateImpl);
            }
            if (areaValue == null) {
                areaValue = TotalArea.get((EstateImpl)estateImpl);
            }
            wohnungMiete.setWohnflaeche(areaValue != null ? AreaValue.convert((BigDecimal)areaValue.getValue(), (AreaValue.Unit)areaValue.getUnit(), (AreaValue.Unit)AreaValue.Unit.SQM) : Integer.valueOf(0));
        }
    }
}

