/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateField;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.contacts.ContactsEntryAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryExtendedAddressPanel;
import com.openindex.openestate.tool.contacts.ContactsEntryField;
import com.openindex.openestate.tool.contacts.ContactsEntryViewDetailsPanel;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.gui.GroupRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultAutoCompleteField;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.StatusNotification;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.java.balloontip.BalloonTip;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyBrokeringViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyBrokeringViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyBrokeringViewPanel.class);
    private DbAgencyBrokering currentBrokering = null;
    private long nextBrokeringId = 0L;
    private long prevBrokeringId = 0L;
    private boolean mayEditBrokering = false;
    private boolean mayRemoveBrokering = false;
    private BrokeringTab brokeringTab;
    private DetailsTab detailsTab;
    private NotesTab notesTab;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;
    private DbContactsGroup unreadableGroup = null;
    private DbContactsEntry unreadableAddress = null;

    private AgencyBrokeringViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        this.brokeringTab = (BrokeringTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new BrokeringTab(), (JTabbedPane)jTabbedPane);
        this.detailsTab = (DetailsTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new DetailsTab(this.brokeringTab.addressPanel), (JTabbedPane)jTabbedPane);
        this.notesTab = (NotesTab)ImmoToolUtils.addTab((com.openindex.openestate.tool.gui.AbstractTab)new NotesTab(), (JTabbedPane)jTabbedPane);
    }

    public static AgencyBrokeringViewPanel createTab() {
        return AgencyBrokeringViewPanel.createTab(new DbAgencyBrokering());
    }

    public static AgencyBrokeringViewPanel createTab(DbAgencyBrokering dbAgencyBrokering) {
        AgencyBrokeringViewPanel agencyBrokeringViewPanel = new AgencyBrokeringViewPanel();
        agencyBrokeringViewPanel.setBrokering(dbAgencyBrokering);
        return agencyBrokeringViewPanel;
    }

    protected void doCopy() {
        if (!this.mayEditBrokering) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doHelp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        DbAgencyObject dbAgencyObject;
        Object object;
        Object object2;
        DbContactsEntry dbContactsEntry;
        block16: {
            Object object3;
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            this.nextBrokeringId = 0L;
            this.prevBrokeringId = 0L;
            if (this.currentBrokering != null && this.currentBrokering.id > 0L) {
                try {
                    object3 = dbAgencyBrokeringsHandler.getBrokeringIds(connection);
                    int n = ArrayUtils.indexOf((long[])object3, (long)this.currentBrokering.id);
                    if (n > 0) {
                        this.prevBrokeringId = object3[n - 1];
                    }
                    if (n + 1 < ((long[])object3).length) {
                        this.nextBrokeringId = object3[n + 1];
                    }
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't load previous & next dataset!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            this.mayEditBrokering = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT);
            this.mayRemoveBrokering = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_REMOVE);
            object3 = null;
            dbContactsEntry = null;
            try {
                if (this.currentBrokering != null && this.currentBrokering.contactsEntryId > 0L) {
                    dbContactsEntry = dbContactsHandler.getEntry(connection, this.currentBrokering.contactsEntryId);
                    if (dbContactsEntry != null) {
                        dbContactsHandler.loadEntrySettings(connection, dbContactsEntry);
                    } else {
                        this.unreadableGroup = new DbContactsGroup();
                        this.unreadableGroup.id = 0L;
                        this.unreadableGroup.name = I18N.tr("unknown");
                        this.unreadableAddress = new DbContactsEntry();
                        this.unreadableAddress.id = this.currentBrokering.contactsEntryId;
                        this.unreadableAddress.address = new CompanyAddressImpl();
                        this.unreadableAddress.address.setPersonLastName(I18N.tr("unknown"));
                        dbContactsEntry = this.unreadableAddress;
                    }
                }
                if (this.currentBrokering != null && this.currentBrokering.agencyObjectId > 0L) {
                    object3 = (DbAgencyObject)dbAgencyObjectsHandler.getObject(connection, this.currentBrokering.agencyObjectId);
                    if (object3 == null) {
                        LOGGER.warn("Can't find property #" + this.currentBrokering.agencyObjectId + "!");
                    } else {
                        dbAgencyObjectsHandler.loadObjectTranslations(connection, (DbObject)object3, dbLanguagesHandler);
                    }
                    if (object3 != null && object3.permission != null) {
                        object2 = ImmoToolProject.getAppInstance().getUser();
                        this.mayEditBrokering = this.mayEditBrokering && object3.permission.canRead((DbUser)object2, object3.ownerUserId, object3.ownerGroupId);
                        boolean bl = this.mayRemoveBrokering = this.mayRemoveBrokering && object3.permission.canWrite((DbUser)object2, object3.ownerUserId, object3.ownerGroupId);
                    }
                }
                if (object3 == null) break block16;
                object = object3;
            }
            catch (Throwable throwable) {
                Object object4;
                if (object3 != null) {
                    object4 = object3;
                } else {
                    DbAgencyObject dbAgencyObject2;
                    object4 = dbAgencyObject2;
                    dbAgencyObject2 = new DbAgencyObject();
                }
                Object object5 = object4;
                DbContactsEntry dbContactsEntry2 = dbContactsEntry != null ? dbContactsEntry : new DbContactsEntry();
                SwingUtilities.invokeLater(new Runnable(dbContactsEntry2, (DbAgencyObject)object5){
                    final /* synthetic */ DbContactsEntry val$currentContactsEntry;
                    final /* synthetic */ DbAgencyObject val$currentAgencyObject;
                    {
                        this.val$currentContactsEntry = dbContactsEntry;
                        this.val$currentAgencyObject = dbAgencyObject;
                    }

                    @Override
                    public void run() {
                        for (AbstractMainViewTab abstractMainViewTab : AgencyBrokeringViewPanel.this.getTabs()) {
                            int n = AgencyBrokeringViewPanel.this.indexOf(abstractMainViewTab);
                            if (n < 0) continue;
                            AgencyBrokeringViewPanel.this.getTabbedPane().setEnabledAt(n, false);
                            try {
                                AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                                abstractTab.load(AgencyBrokeringViewPanel.this.currentBrokering, this.val$currentContactsEntry, this.val$currentAgencyObject);
                                AgencyBrokeringViewPanel.this.getTabbedPane().setEnabledAt(n, abstractTab.isTabEnabled() && abstractTab.isTabUsable());
                            }
                            catch (Exception exception) {
                                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                            }
                        }
                    }
                });
                throw throwable;
            }
        }
        object = dbAgencyObject;
        dbAgencyObject = new DbAgencyObject();
        object2 = object;
        DbContactsEntry dbContactsEntry3 = dbContactsEntry != null ? dbContactsEntry : new DbContactsEntry();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        if (this.currentBrokering != null && this.currentBrokering.id > 0L) {
            this.setBrokering(this.currentBrokering);
            this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentBrokering == null || this.currentBrokering.id < 1L) {
            return;
        }
        if (!this.mayRemoveBrokering) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove brokering mandate {0}?", (Object)("#" + this.currentBrokering.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask(this.currentBrokering.id));
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.currentBrokering == null || this.currentBrokering.id < 1L) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.mayRemoveBrokering));
        jPopupMenu.addSeparator();
        if (this.currentBrokering.contactsEntryId > 0L) {
            jPopupMenu.add((Action)new ContactsPlugin.EntryFormAction(this.currentBrokering.contactsEntryId));
        }
        if (this.currentBrokering.agencyObjectId > 0L) {
            jPopupMenu.add((Action)new AgencyPlugin.EstateFormAction(this.currentBrokering.agencyObjectId));
        }
        jPopupMenu.add((Action)this.notesTab.addressNotesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditBrokering) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        DbAgencyObject dbAgencyObject = this.brokeringTab.agencyObjectField.getAgencyObject();
        if (dbAgencyObject == null) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("No property is selected!"), (Component)((Object)this));
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextBrokeringId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyBrokeringViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.nextBrokeringId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevBrokeringId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyBrokeringViewTask(ImmoToolProject.getAppInstance().getDbDriver(), this.prevBrokeringId, this));
        }
    }

    public long getCurrentAgencyObjectId() {
        return this.currentBrokering != null ? this.currentBrokering.agencyObjectId : 0L;
    }

    public long getCurrentBrokeringId() {
        return this.currentBrokering != null ? this.currentBrokering.id : 0L;
    }

    public long getCurrentContactsEntryId() {
        return this.currentBrokering != null ? this.currentBrokering.contactsEntryId : 0L;
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)32);
    }

    protected String getHeaderTitle() {
        long l = this.getCurrentBrokeringId();
        if (l > 0L) {
            return StringUtils.capitalize((String)I18N.tr("brokering mandate")) + " #" + l;
        }
        return StringUtils.capitalize((String)I18N.tr("create brokering mandate"));
    }

    public String getTabTitle() {
        long l = this.getCurrentBrokeringId();
        if (l > 0L) {
            return StringUtils.capitalize((String)I18N.tr("brokering")) + " #" + l;
        }
        return StringUtils.capitalize((String)I18N.tr("new brokering"));
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    public void setBrokering(DbAgencyBrokering dbAgencyBrokering) {
        this.currentBrokering = dbAgencyBrokering != null ? dbAgencyBrokering : new DbAgencyBrokering();
        this.nextBrokeringId = 0L;
        this.prevBrokeringId = 0L;
        this.unreadableGroup = null;
        this.unreadableAddress = null;
        this.mayEditBrokering = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT);
        this.mayRemoveBrokering = AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_REMOVE);
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
        }
        this.updateLocalization();
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditBrokering);
        this.closeAction.setEnabled(bl);
        this.helpAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextBrokeringId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevBrokeringId > 0L);
    }

    protected void tabComponentAdded(ContainerEvent containerEvent) {
        super.tabComponentAdded(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(this);
        }
    }

    protected void tabComponentRemoved(ContainerEvent containerEvent) {
        super.tabComponentRemoved(containerEvent);
        Component component = containerEvent.getChild();
        if (component instanceof AbstractTab) {
            ((AbstractTab)((Object)component)).setViewPanel(null);
        }
    }

    private class SubmitTask
    extends ImmoToolTask<DbAgencyBrokering, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;
        private final List<String> warnings = new ArrayList<String>();

        public SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyBrokering doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            boolean bl = AgencyBrokeringViewPanel.this.brokeringTab.addContactsEntryField.isSelected();
            this.warnings.clear();
            Connection connection = null;
            try {
                DbAgencyObject dbAgencyObject;
                DbContactsEntry dbContactsEntry;
                connection = immoToolProject.getDbConnection();
                DbAgencyBrokering dbAgencyBrokering = AgencyBrokeringViewPanel.this.currentBrokering == null || ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).currentBrokering.id < 1L || this.saveAsCopy ? new DbAgencyBrokering() : dbAgencyBrokeringsHandler.getBrokering(connection, ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).currentBrokering.id);
                DbContactsEntry dbContactsEntry2 = dbContactsEntry = !bl ? AgencyBrokeringViewPanel.this.brokeringTab.contactsEntryField.getContactsEntry() : new DbContactsEntry();
                if (dbContactsEntry.address == null) {
                    dbContactsEntry.address = new CompanyAddressImpl();
                }
                if (dbContactsEntry.values == null) {
                    dbContactsEntry.values = new HashMap();
                }
                if ((dbAgencyObject = AgencyBrokeringViewPanel.this.brokeringTab.agencyObjectField.getAgencyObject()) == null) {
                    throw new Exception("Unknown property!");
                }
                DbAgencyBrokering dbAgencyBrokering2 = dbAgencyBrokeringsHandler.getBrokeringForObject(connection, dbAgencyObject.id);
                if (dbAgencyBrokering2 != null && dbAgencyBrokering2.id != dbAgencyBrokering.id) {
                    this.warnings.add(I18N.tr("A different brokering mandate is already assigned to property {0}!", (Object)("#" + dbAgencyObject.id)));
                    DbAgencyBrokering dbAgencyBrokering3 = null;
                    return dbAgencyBrokering3;
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    ((AbstractTab)abstractMainViewTab).saveWarnings.clear();
                    ((AbstractTab)abstractMainViewTab).save(dbAgencyBrokering, dbContactsEntry, dbAgencyObject);
                }
                if (AgencyBrokeringViewPanel.this.unreadableAddress == null || ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).unreadableAddress.id != dbContactsEntry.id) {
                    dbContactsHandler.saveEntry(connection, dbContactsEntry);
                }
                dbAgencyBrokering.contactsEntryId = dbContactsEntry.id;
                dbAgencyObjectsHandler.saveObject(connection, (DbObject)dbAgencyObject);
                dbAgencyBrokering.agencyObjectId = dbAgencyObject.id;
                dbAgencyBrokeringsHandler.saveBrokering(connection, dbAgencyBrokering);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    if (!(abstractMainViewTab instanceof AbstractTab)) continue;
                    AbstractTab abstractTab = (AbstractTab)abstractMainViewTab;
                    abstractTab.saveFinished(connection, dbAgencyBrokering, dbContactsEntry, dbAgencyObject);
                    if (abstractTab.saveWarnings.isEmpty()) continue;
                    this.warnings.addAll(abstractTab.saveWarnings);
                }
                DbAgencyBrokering dbAgencyBrokering3 = dbAgencyBrokering;
                return dbAgencyBrokering3;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save brokering mandate!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyBrokeringViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(DbAgencyBrokering dbAgencyBrokering) {
            super.succeeded((Object)dbAgencyBrokering);
            if (!this.warnings.isEmpty()) {
                for (String string : this.warnings) {
                    ImmoToolEnvironment.showStatusNotification((StatusNotification)new StatusNotification.Warning(string));
                }
            }
            if (dbAgencyBrokering != null) {
                AgencyBrokeringViewPanel.this.setBrokering(dbAgencyBrokering);
                AgencyBrokeringViewPanel.this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
            }
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long brokeringId;

        public RemoveTask(long l) {
            this.brokeringId = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencyBrokeringsHandler.removeBrokering(connection, this.brokeringId);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete brokering mandate!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyBrokeringViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)AgencyBrokeringViewPanel.this), (boolean)true);
        }
    }

    private final class NotesTab
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JSplitPane splitPane;
        private JXTitledSeparator brokeringNotesTitle;
        private DefaultTextArea brokeringNotesField;
        private JXTitledSeparator addressNotesTitle;
        private DefaultTextArea addressNotesField;

        private NotesTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.brokeringNotesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.brokeringNotesField = new DefaultTextArea();
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)this.brokeringNotesTitle, "North");
            jPanel.add((Component)this.brokeringNotesField.createScrollPane(), "Center");
            this.addressNotesTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.addressNotesField = new DefaultTextArea();
            JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
            jPanel2.setBorder((Border)Paddings.DIALOG);
            jPanel2.add((Component)this.addressNotesTitle, "North");
            jPanel2.add((Component)this.addressNotesField.createScrollPane(), "Center");
            this.splitPane = new JSplitPane(0);
            this.splitPane.setBorder(Paddings.EMPTY);
            this.splitPane.setTopComponent(jPanel);
            this.splitPane.setBottomComponent(jPanel2);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(this.splitPane, "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        public void load(DbContactsEntry dbContactsEntry) {
            this.addressNotesField.setText(dbContactsEntry != null ? StringUtils.trimToEmpty((String)dbContactsEntry.notes) : "");
            this.addressNotesField.setCaretPosition(0);
            this.modificationHandler.putValue((JComponent)this.addressNotesField);
        }

        @Override
        public void load(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) throws Exception {
            this.modificationHandler.clear();
            this.load(dbContactsEntry);
            this.brokeringNotesField.setText(dbAgencyBrokering != null ? StringUtils.trimToEmpty((String)dbAgencyBrokering.notes) : "");
            this.brokeringNotesField.setCaretPosition(0);
            this.modificationHandler.putValue((JComponent)this.brokeringNotesField);
            this.splitPane.setDividerLocation(0.5);
        }

        @Override
        public void save(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) throws Exception {
            dbAgencyBrokering.notes = StringUtils.trimToNull((String)this.brokeringNotesField.getText());
            if (this.addressNotesField.isEnabled() && dbContactsEntry != null && (AgencyBrokeringViewPanel.this.unreadableAddress == null || ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).unreadableAddress.id != dbContactsEntry.id)) {
                dbContactsEntry.notes = StringUtils.trimToNull((String)this.addressNotesField.getText());
            }
        }

        public void setAddressEnabled(boolean bl) {
            this.addressNotesField.setEnabled(bl);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.brokeringNotesTitle.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the brokering mandate")));
            this.addressNotesTitle.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the assigned address")));
        }
    }

    private final class DetailsTab
    extends AbstractTab {
        private ContactsEntryViewDetailsPanel form;

        private DetailsTab(ContactsEntryExtendedAddressPanel contactsEntryExtendedAddressPanel) {
            this.build(contactsEntryExtendedAddressPanel);
        }

        private void build(ContactsEntryExtendedAddressPanel contactsEntryExtendedAddressPanel) {
            this.form = new ContactsEntryViewDetailsPanel((ContactsEntryAddressPanel)contactsEntryExtendedAddressPanel);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.add((Component)this.form, "Center");
        }

        public String getTabTitle() {
            return this.form.getTabTitle();
        }

        public void load(DbContactsEntry dbContactsEntry) throws Exception {
            this.form.load(dbContactsEntry);
        }

        @Override
        public void load(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) throws Exception {
            this.load(dbContactsEntry);
        }

        @Override
        public void save(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) throws Exception {
            if (this.form.isEnabled() && dbContactsEntry != null && (AgencyBrokeringViewPanel.this.unreadableAddress == null || ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).unreadableAddress.id != dbContactsEntry.id)) {
                this.form.save(dbContactsEntry);
            }
        }

        public void setAddressEnabled(boolean bl) {
            this.form.setEnabled(bl);
        }
    }

    private final class BrokeringTab
    extends AbstractTab
    implements DisposableComponent {
        private ValidationHandler validationHandler;
        private JXTitledSeparator titleLabel;
        private JLabel beginLabel;
        private DefaultDatePicker beginField;
        private JLabel endLabel;
        private DefaultDatePicker endField;
        private JLabel agencyObjectStatusLabel;
        private JComboBox<DbAgencyObject.Status> agencyObjectStatusField;
        private JLabel contactsLabel;
        private JComboBox<DbContactsGroup> contactsGroupField;
        private ContactsEntryField contactsEntryField;
        private JLabel agencyObjectLabel;
        private AgencyEstateField agencyObjectField;
        private JCheckBox addContactsEntryField;
        private ContactsEntryExtendedAddressPanel addressPanel;
        private DbContactsEntry newContactsEntry = null;
        private long loadedContactsEntryId = 0L;
        private long loadedContactsGroupId = 0L;
        private BalloonTip unreadableAddressBalloonTip;
        private JLabel unreadableAddressBalloonLabel;

        private BrokeringTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.validationHandler = ImmoToolUtils.createValidationHandler();
            this.titleLabel = ImmoToolUtils.createHead2Separator((String)"");
            this.beginLabel = new JLabel();
            this.beginField = new DefaultDatePicker();
            this.endLabel = new JLabel();
            this.endField = new DefaultDatePicker();
            this.agencyObjectStatusLabel = new JLabel();
            this.agencyObjectStatusField = new JComboBox();
            this.agencyObjectStatusField.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES_EDIT_STATUS));
            this.agencyObjectStatusField.setRenderer((ListCellRenderer<DbAgencyObject.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            this.agencyObjectStatusField.addItem(null);
            for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
                this.agencyObjectStatusField.addItem(status);
            }
            this.agencyObjectLabel = new JLabel();
            this.agencyObjectField = new AgencyEstateField();
            this.agencyObjectField.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
            this.agencyObjectField.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

                public void valueChanged() {
                    if (!BrokeringTab.this.agencyObjectField.isEnabled()) {
                        return;
                    }
                    BrokeringTab.this.updateAgencyObjectStatus(BrokeringTab.this.agencyObjectField.getAgencyObject());
                }
            });
            this.contactsLabel = new JLabel();
            this.contactsGroupField = new JComboBox();
            this.contactsGroupField.setRenderer((ListCellRenderer<DbContactsGroup>)new DefaultListCellRenderer((Renderer)new GroupRenderer(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select address group") + " ]";
                }
            }));
            this.contactsGroupField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!BrokeringTab.this.contactsGroupField.isEnabled()) {
                        return;
                    }
                    BrokeringTab.this.updateAddressForm();
                }
            });
            this.contactsEntryField = new ContactsEntryField();
            this.contactsEntryField.addSelectionListener(new DefaultAutoCompleteField.SelectionListener(){

                public void valueChanged() {
                    if (!BrokeringTab.this.contactsEntryField.isEnabled()) {
                        return;
                    }
                    BrokeringTab.this.updateAddressForm();
                }
            });
            this.addContactsEntryField = new JCheckBox();
            this.addContactsEntryField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.addContactsEntryField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!BrokeringTab.this.addContactsEntryField.isEnabled()) {
                        return;
                    }
                    BrokeringTab.this.contactsEntryField.setEnabled(!BrokeringTab.this.addContactsEntryField.isSelected());
                    if (!BrokeringTab.this.addContactsEntryField.isSelected() && BrokeringTab.this.newContactsEntry != null) {
                        BrokeringTab.this.addressPanel.save(BrokeringTab.this.newContactsEntry);
                    }
                    BrokeringTab.this.updateAddressForm();
                }
            });
            this.unreadableAddressBalloonLabel = new JLabel();
            this.unreadableAddressBalloonLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
            this.unreadableAddressBalloonTip = new BalloonTip((JComponent)this.contactsEntryField, (JComponent)this.unreadableAddressBalloonLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.LEFT_BELOW, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
            this.unreadableAddressBalloonTip.setVisible(false);
            this.validationHandler.putRule((JComponent)this.beginField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.agencyObjectStatusField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule((JComponent)this.agencyObjectField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule(this.contactsGroupField, ValidationHandler.NOT_NULL);
            this.validationHandler.putRule((JComponent)this.contactsEntryField, ValidationHandler.NOT_NULL);
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[60dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:[60dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.add((Component)this.titleLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
            defaultFormBuilder.add((Component)this.agencyObjectLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.agencyObjectField).xyw(3, defaultFormBuilder.row(), 5);
            defaultFormBuilder.add((Component)this.contactsLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.contactsGroupField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.agencyObjectStatusLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add(this.agencyObjectStatusField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.contactsEntryField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.beginLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.beginField).xy(7, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.addContactsEntryField).xy(3, defaultFormBuilder.nextRow());
            defaultFormBuilder.add((Component)this.endLabel).xy(5, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.endField).xy(7, defaultFormBuilder.row());
            this.addressPanel = new ContactsEntryExtendedAddressPanel(60){

                public void load(DbContactsEntry dbContactsEntry) {
                    super.load(dbContactsEntry);
                    try {
                        AgencyBrokeringViewPanel.this.detailsTab.load(dbContactsEntry);
                        AgencyBrokeringViewPanel.this.notesTab.load(dbContactsEntry);
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load address details!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }

                public void setEnabled(boolean bl) {
                    super.setEnabled(bl);
                    AgencyBrokeringViewPanel.this.detailsTab.setAddressEnabled(bl);
                    AgencyBrokeringViewPanel.this.notesTab.setAddressEnabled(bl);
                }
            };
            JPanel jPanel = new JPanel(new BorderLayout(10, 10));
            jPanel.setBorder((Border)Paddings.DIALOG);
            jPanel.add((Component)defaultFormBuilder.getPanel(), "North");
            jPanel.add((Component)this.addressPanel, "Center");
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void dispose() {
            if (this.unreadableAddressBalloonTip != null) {
                this.unreadableAddressBalloonTip.closeBalloon();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) throws Exception {
            this.contactsGroupField.setEnabled(false);
            this.contactsGroupField.setModel(new DefaultComboBoxModel());
            DefaultComboBoxModel<DbContactsGroup> defaultComboBoxModel = new DefaultComboBoxModel<DbContactsGroup>();
            defaultComboBoxModel.addElement(null);
            try {
                DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
                for (DbContactsGroup dbContactsGroup : dbContactsHandler.getGroups(connection)) {
                    defaultComboBoxModel.addElement(dbContactsGroup);
                }
                if (AgencyBrokeringViewPanel.this.unreadableGroup != null) {
                    defaultComboBoxModel.addElement(AgencyBrokeringViewPanel.this.unreadableGroup);
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(defaultComboBoxModel){
                    final /* synthetic */ DefaultComboBoxModel val$contactsGroupModel;
                    {
                        this.val$contactsGroupModel = defaultComboBoxModel;
                    }

                    @Override
                    public void run() {
                        block4: {
                            try {
                                BrokeringTab.this.contactsGroupField.setModel(this.val$contactsGroupModel);
                                BrokeringTab.this.contactsGroupField.setSelectedItem(null);
                                if (BrokeringTab.this.loadedContactsGroupId <= 0L) break block4;
                                for (int i = 0; i < this.val$contactsGroupModel.getSize(); ++i) {
                                    DbContactsGroup dbContactsGroup = (DbContactsGroup)this.val$contactsGroupModel.getElementAt(i);
                                    if (dbContactsGroup == null || dbContactsGroup.id != BrokeringTab.this.loadedContactsGroupId) continue;
                                    BrokeringTab.this.contactsGroupField.setSelectedItem(dbContactsGroup);
                                    break;
                                }
                            }
                            finally {
                                BrokeringTab.this.agencyObjectField.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES));
                                BrokeringTab.this.contactsGroupField.setEnabled(true);
                                BrokeringTab.this.validationHandler.init();
                                BrokeringTab.this.updateAddressForm();
                            }
                        }
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("mandate"));
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabValid() {
            this.validationHandler.validate();
            this.addressPanel.validateInputs();
            return this.validationHandler.isValid() && this.addressPanel.isValidInput();
        }

        @Override
        public void load(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) {
            if (this.unreadableAddressBalloonTip.isVisible()) {
                this.unreadableAddressBalloonTip.setVisible(false);
            }
            this.loadedContactsEntryId = dbContactsEntry != null ? dbContactsEntry.id : 0L;
            this.loadedContactsGroupId = dbContactsEntry != null ? dbContactsEntry.groupId : 0L;
            this.newContactsEntry = null;
            this.beginField.setDate(dbAgencyBrokering.id > 0L ? dbAgencyBrokering.begin : new Date());
            this.endField.setDate(dbAgencyBrokering.end);
            this.agencyObjectField.setEnabled(false);
            this.agencyObjectField.setAgencyObject(dbAgencyObject);
            this.agencyObjectField.setEnabled(true);
            this.updateAgencyObjectStatus(dbAgencyObject);
            this.contactsGroupField.setEnabled(false);
            this.contactsGroupField.setModel(new DefaultComboBoxModel());
            this.addContactsEntryField.setSelected(dbAgencyBrokering.id == 0L && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT));
            this.contactsEntryField.setEnabled(false);
            this.contactsEntryField.setContactsEntry(dbContactsEntry != null && dbContactsEntry.id > 0L ? dbContactsEntry : null);
            this.contactsEntryField.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && !this.addContactsEntryField.isSelected());
            this.addressPanel.setEnabled(false);
        }

        @Override
        public void save(DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) {
            DbContactsGroup dbContactsGroup;
            dbAgencyBrokering.begin = this.beginField.getDate();
            dbAgencyBrokering.end = this.endField.getDate();
            if (this.agencyObjectField.isEnabled()) {
                dbAgencyBrokering.agencyObjectId = this.agencyObjectField.getAgencyObject().id;
            }
            if (this.agencyObjectStatusField.isEnabled()) {
                dbAgencyObject.status = (DbAgencyObject.Status)this.agencyObjectStatusField.getSelectedItem();
            }
            if (this.contactsGroupField.isEnabled() && (dbContactsGroup = (DbContactsGroup)this.contactsGroupField.getSelectedItem()) != null && dbContactsGroup != AgencyBrokeringViewPanel.this.unreadableGroup) {
                dbContactsEntry.groupId = dbContactsGroup.id;
            }
            if (this.addressPanel.isEnabled() && dbContactsEntry != null && (AgencyBrokeringViewPanel.this.unreadableAddress == null || ((AgencyBrokeringViewPanel)AgencyBrokeringViewPanel.this).unreadableAddress.id != dbContactsEntry.id)) {
                this.addressPanel.save(dbContactsEntry);
            }
        }

        private void updateAddressForm() {
            boolean bl;
            boolean bl2 = this.addContactsEntryField.isEnabled() && this.addContactsEntryField.isSelected();
            DbContactsGroup dbContactsGroup = (DbContactsGroup)this.contactsGroupField.getSelectedItem();
            DbContactsEntry dbContactsEntry = this.contactsEntryField.getContactsEntry();
            if (bl2) {
                if (this.newContactsEntry == null) {
                    this.newContactsEntry = new DbContactsEntry();
                }
                dbContactsEntry = this.newContactsEntry;
            }
            boolean bl3 = bl = dbContactsGroup != null && ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT);
            if (!bl2) {
                boolean bl4 = bl = bl && dbContactsEntry != null && dbContactsEntry.id > 0L;
            }
            if (dbContactsGroup != null && dbContactsGroup.permission != null) {
                DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
                bl = bl && dbContactsGroup.permission.canWrite(dbUser, dbContactsGroup.ownerUserId, dbContactsGroup.ownerGroupId);
            }
            this.addressPanel.load(dbContactsEntry != null ? dbContactsEntry : new DbContactsEntry());
            this.addressPanel.setEnabled(bl);
            this.addressPanel.initInputs();
            this.validationHandler.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAgencyObjectStatus(DbAgencyObject dbAgencyObject) {
            try {
                boolean bl;
                this.agencyObjectStatusField.setEnabled(false);
                this.agencyObjectStatusField.removeAllItems();
                this.agencyObjectStatusField.addItem(null);
                if (dbAgencyObject == null) {
                    this.agencyObjectStatusField.setSelectedItem(null);
                    return;
                }
                DbUser dbUser = ImmoToolProject.getAppInstance().getUser();
                for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
                    this.agencyObjectStatusField.addItem(status);
                }
                if (!DbAgencyObject.Status.PUBLISHED.equals((Object)dbAgencyObject.status) && !AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING)) {
                    this.agencyObjectStatusField.removeItem(DbAgencyObject.Status.PUBLISHED);
                }
                this.agencyObjectStatusField.setSelectedItem(dbAgencyObject.status);
                boolean bl2 = bl = dbAgencyObject.permission.canWrite(dbUser, dbAgencyObject.ownerUserId, dbAgencyObject.ownerGroupId) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES_EDIT_STATUS);
                if (DbAgencyObject.Status.PUBLISHED.equals((Object)dbAgencyObject.status)) {
                    bl = bl && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.PROPERTIES_EDIT_STATUS_UNPUBLISHING);
                }
                this.agencyObjectStatusField.setEnabled(bl);
            }
            finally {
                this.validationHandler.validate(this.agencyObjectStatusField);
            }
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.titleLabel.setTitle(StringUtils.capitalize((String)I18N.tr("details about the brokering mandate")));
            this.beginLabel.setText(StringUtils.capitalize((String)I18N.tr("begin")) + ":");
            this.endLabel.setText(StringUtils.capitalize((String)I18N.tr("end")) + ":");
            this.agencyObjectLabel.setText(StringUtils.capitalize((String)I18N.tr("property")) + ":");
            this.agencyObjectStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
            this.contactsLabel.setText(StringUtils.capitalize((String)I18N.tr("principal")) + ":");
            this.addContactsEntryField.setText(I18N.tr("Create a new address."));
            this.unreadableAddressBalloonLabel.setText(I18N.tr("The assigned address is not readable by your user account."));
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        private WeakReference<AgencyBrokeringViewPanel> viewPanel = null;
        private final List<String> saveWarnings = new ArrayList<String>();

        protected final void addSaveWarning(String string) {
            this.saveWarnings.add(string);
        }

        public AgencyBrokeringViewPanel getViewPanel() {
            return this.viewPanel != null ? (AgencyBrokeringViewPanel)((Object)this.viewPanel.get()) : null;
        }

        public abstract void load(DbAgencyBrokering var1, DbContactsEntry var2, DbAgencyObject var3) throws Exception;

        public abstract void save(DbAgencyBrokering var1, DbContactsEntry var2, DbAgencyObject var3) throws Exception;

        public void saveFinished(Connection connection, DbAgencyBrokering dbAgencyBrokering, DbContactsEntry dbContactsEntry, DbAgencyObject dbAgencyObject) {
        }

        public void setViewPanel(AgencyBrokeringViewPanel agencyBrokeringViewPanel) {
            this.viewPanel = agencyBrokeringViewPanel != null ? new WeakReference<AgencyBrokeringViewPanel>(agencyBrokeringViewPanel) : null;
        }
    }
}

