/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestOfferPanel;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.gui.InterestOfferStatusRenderer;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.contacts.ContactsEntryViewPanel;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ContactsEntryEstateOffersPanel
extends ContactsEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsEntryEstateOffersPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsEntryEstateOffersPanel.class);
    private DbContactsEntry currentContactsEntry = null;
    private JXTitledSeparator interestsTitle;
    private JXTreeTable interestsTable;
    private TableModel interestsTableModel;
    private OfferForm offerForm;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction refreshAction;

    public ContactsEntryEstateOffersPanel() {
        this.build();
        this.offerForm.unselectRelation();
    }

    private void build() {
        this.interestsTableModel = new TableModel();
        this.interestsTable = new JXTreeTable();
        this.interestsTable.setTreeCellRenderer((TreeCellRenderer)new TableTreeCellRenderer());
        this.interestsTable.setTreeTableModel((TreeTableModel)this.interestsTableModel);
        this.interestsTable.getColumn(9).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer((Renderer)new InterestOfferStatusRenderer()));
        ImmoToolUtils.configureTable((JXTable)this.interestsTable);
        this.interestsTable.getSelectionModel().setSelectionMode(0);
        this.interestsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContactsEntryEstateOffersPanel.this.showActionsAction.setEnabled(ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRowCount() > 0);
                if (ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRowCount() < 1) {
                    ContactsEntryEstateOffersPanel.this.offerForm.unselectRelation();
                } else {
                    int n = ContactsEntryEstateOffersPanel.this.interestsTable.convertRowIndexToModel(ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRow());
                    TreePath treePath = ContactsEntryEstateOffersPanel.this.interestsTable.getPathForRow(n);
                    TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
                    if (!tableNode.isOffer()) {
                        ContactsEntryEstateOffersPanel.this.offerForm.unselectRelation();
                    } else {
                        ContactsEntryEstateOffersPanel.this.offerForm.selectRelation(tableNode.offer);
                    }
                }
            }
        });
        this.interestsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    ContactsEntryEstateOffersPanel.this.doView();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    int n = ContactsEntryEstateOffersPanel.this.interestsTable.rowAtPoint(mouseEvent.getPoint());
                    if (n > -1 && !ArrayUtils.contains((int[])ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRows(), (int)n)) {
                        ContactsEntryEstateOffersPanel.this.interestsTable.getSelectionModel().setSelectionInterval(n, n);
                    }
                    ContactsEntryEstateOffersPanel.this.doShowActions((Component)ContactsEntryEstateOffersPanel.this.interestsTable, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this.interestsTable);
        this.interestsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.interestsTitle, (Action[])new Action[]{this.refreshAction, this.showActionsAction});
        this.offerForm = new OfferForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(jScrollPane, "Center");
        this.add((Component)((Object)this.offerForm), "South");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void doLoadInBackground(Connection connection) throws Exception {
        this.interestsTable.setEnabled(false);
        this.interestsTable.setAutoCreateColumnsFromModel(false);
        this.interestsTable.setTreeTableModel((TreeTableModel)new TableModel());
        this.interestsTableModel = new TableModel();
        ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
        HashMap<Long, DbObject> hashMap = new HashMap<Long, DbObject>();
        HashMap<Long, DbAgencySearch> hashMap2 = new HashMap<Long, DbAgencySearch>();
        try {
            DbObject[] dbObjectArray;
            void var11_14;
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbAgencyInterest[] dbAgencyInterestArray = dbAgencyInterestsHandler.getInterestsForContact(connection, this.currentContactsEntry.id);
            dbAgencyInterestsHandler.loadInterestOffers(connection, dbAgencyInterestArray);
            arrayList.addAll(Arrays.asList(dbAgencyInterestArray));
            DbAgencyInterest[] objectArray = dbAgencyInterestArray;
            int dbObjectArray2 = objectArray.length;
            boolean bl = false;
            while (var11_14 < dbObjectArray2) {
                DbAgencyInterest dbAgencyInterest = objectArray[var11_14];
                for (Long l : dbAgencyInterest.offers.keySet()) {
                    hashMap.put(l, null);
                }
                ++var11_14;
            }
            long[] lArray = ArrayUtils.toPrimitive((Long[])hashMap.keySet().toArray(new Long[0]));
            for (DbObject dbObject : dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, lArray)) {
                hashMap.put(dbObject.id, dbObject);
            }
            for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestArray) {
                DbAgencySearch dbAgencySearch;
                DbAgencySearch dbAgencySearch2 = dbAgencySearch = dbAgencyInterest.agencySearchId > 0L ? (DbAgencySearch)dbAgencySearchesHandler.getSearch(connection, dbAgencyInterest.agencySearchId) : null;
                if (dbAgencySearch == null) continue;
                hashMap2.put(dbAgencyInterest.agencySearchId, dbAgencySearch);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap2, hashMap){
                final /* synthetic */ List val$interestsList;
                final /* synthetic */ Map val$searchMap;
                final /* synthetic */ Map val$objectsMap;
                {
                    this.val$interestsList = list;
                    this.val$searchMap = map;
                    this.val$objectsMap = map2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (DbAgencyInterest dbAgencyInterest : this.val$interestsList) {
                            DbAgencySearch dbAgencySearch = dbAgencyInterest.agencySearchId > 0L ? (DbAgencySearch)this.val$searchMap.get(dbAgencyInterest.agencySearchId) : null;
                            TableNode tableNode = new TableNode(dbAgencyInterest, dbAgencySearch);
                            for (DbAgencyInterestOffer dbAgencyInterestOffer : dbAgencyInterest.offers.values()) {
                                DbAgencyObject dbAgencyObject = this.val$objectsMap.containsKey(dbAgencyInterestOffer.agencyObjectId) ? (DbAgencyObject)this.val$objectsMap.get(dbAgencyInterestOffer.agencyObjectId) : null;
                                TableNode tableNode2 = new TableNode(dbAgencyInterestOffer, dbAgencyObject);
                                tableNode.add((MutableTreeTableNode)tableNode2);
                            }
                            ContactsEntryEstateOffersPanel.this.interestsTableModel.getRootNode().add((MutableTreeTableNode)tableNode);
                        }
                    }
                    finally {
                        ContactsEntryEstateOffersPanel.this.interestsTable.setTreeTableModel((TreeTableModel)ContactsEntryEstateOffersPanel.this.interestsTableModel);
                        ContactsEntryEstateOffersPanel.this.interestsTable.setEnabled(true);
                        ContactsEntryEstateOffersPanel.this.interestsTable.expandAll();
                        ContactsEntryEstateOffersPanel.this.interestsTable.packAll();
                        ContactsEntryEstateOffersPanel.this.updateLocalization();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doRefresh() {
        try {
            this.load(this.currentContactsEntry);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't load address into panel!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.interestsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n3 = this.interestsTable.convertRowIndexToModel(this.interestsTable.getSelectedRow());
        TreePath treePath = this.interestsTable.getPathForRow(n3);
        TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
        if (tableNode == null) {
            return;
        }
        ObjectViewAction objectViewAction = new ObjectViewAction();
        objectViewAction.setEnabled(tableNode.isOffer());
        InterestViewAction interestViewAction = new InterestViewAction();
        interestViewAction.setEnabled(tableNode.isOffer() || tableNode.isSearch());
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)objectViewAction));
        jPopupMenu.add((Action)((Object)interestViewAction));
        jPopupMenu.show(component, n, n2);
    }

    private void doView() {
        if (this.interestsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.interestsTable.convertRowIndexToModel(this.interestsTable.getSelectedRow());
        TreePath treePath = this.interestsTable.getPathForRow(n);
        if (treePath == null) {
            return;
        }
        TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
        if (tableNode.isOffer()) {
            this.doViewAgencyObject();
        } else if (tableNode.isSearch()) {
            this.doViewAgencyInterest();
        }
    }

    private void doViewAgencyInterest() {
        if (this.interestsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.interestsTable.convertRowIndexToModel(this.interestsTable.getSelectedRow());
        TreePath treePath = this.interestsTable.getPathForRow(n);
        if (treePath == null) {
            return;
        }
        TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
        if (tableNode.isOffer()) {
            tableNode = (TableNode)tableNode.getParent();
        }
        if (!tableNode.isSearch()) {
            return;
        }
        new AgencyContactsUtils.InterestFormAction(((TableNode)tableNode).interest.id).actionPerformed(null);
    }

    private void doViewAgencyObject() {
        if (this.interestsTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.interestsTable.convertRowIndexToModel(this.interestsTable.getSelectedRow());
        TreePath treePath = this.interestsTable.getPathForRow(n);
        if (treePath == null) {
            return;
        }
        TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
        if (!tableNode.isOffer()) {
            return;
        }
        new AgencyPlugin.EstateFormAction(((TableNode)tableNode).offerObject.id).actionPerformed(null);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("search mandates"));
    }

    public boolean isLoadedInBackground() {
        return this.currentContactsEntry != null && this.currentContactsEntry.id > 0L;
    }

    public void load(DbContactsEntry dbContactsEntry) {
        this.currentContactsEntry = dbContactsEntry;
        this.offerForm.unselectRelation();
        this.interestsTable.setEnabled(false);
        this.interestsTable.setAutoCreateColumnsFromModel(false);
        this.interestsTable.setTreeTableModel((TreeTableModel)new TableModel());
        this.interestsTableModel = new TableModel();
        this.showActionsAction.setEnabled(false);
    }

    public void save(DbContactsEntry dbContactsEntry) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbContactsEntry dbContactsEntry) throws SQLException {
        DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
        TableNode tableNode = this.interestsTableModel.getRootNode();
        for (int i = 0; i < tableNode.getChildCount(); ++i) {
            TableNode tableNode2 = (TableNode)tableNode.getChildAt(i);
            for (int j = 0; j < tableNode2.getChildCount(); ++j) {
                TableNode tableNode3 = (TableNode)tableNode2.getChildAt(j);
                DbAgencyInterestOffer dbAgencyInterestOffer = tableNode3.offer;
                dbAgencyInterestsHandler.saveInterestOffer(connection, dbAgencyInterestOffer);
            }
        }
    }

    protected void updateButtons(boolean bl) {
        this.refreshAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.interestsTable.getSelectedRowCount() > 0);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        String string = StringUtils.capitalize((String)I18N.tr("search mandates for the address"));
        if (this.interestsTable.getRowCount() > 0) {
            TableNode tableNode = this.interestsTableModel.getRootNode();
            int n = tableNode.getChildCount();
            int n2 = 0;
            for (int i = 0; i < tableNode.getChildCount(); ++i) {
                n2 += tableNode.getChildAt(i).getChildCount();
            }
            if (n > 0 || n2 > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} search mandate", "{0} search mandates", (long)n, (Object)n);
                string = string + " / ";
                string = string + I18N.trn("{0} offer", "{0} offers", (long)n2, (Object)n2);
            }
        }
        this.interestsTitle.setTitle(string);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            ContactsEntryEstateOffersPanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                ContactsEntryEstateOffersPanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateOffersPanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ObjectViewAction
    extends AbstractI18nAction {
        private ObjectViewAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateOffersPanel.this.doViewAgencyObject();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class InterestViewAction
    extends AbstractI18nAction {
        private InterestViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ContactsEntryEstateOffersPanel.this.doViewAgencyInterest();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show search mandate")));
            this.setShortDescription(I18N.tr("Show details about the search mandate."));
        }
    }

    private class OfferForm
    extends AgencyInterestOfferPanel {
        private OfferForm() {
        }

        @Override
        public void close() {
            if (ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRowCount() > 0) {
                ContactsEntryEstateOffersPanel.this.interestsTable.clearSelection();
            }
        }

        @Override
        protected boolean submit(DbAgencyInterestOffer dbAgencyInterestOffer) {
            if (dbAgencyInterestOffer == null) {
                return false;
            }
            if (ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRowCount() < 1) {
                return false;
            }
            int n = ContactsEntryEstateOffersPanel.this.interestsTable.convertRowIndexToModel(ContactsEntryEstateOffersPanel.this.interestsTable.getSelectedRow());
            TreePath treePath = ContactsEntryEstateOffersPanel.this.interestsTable.getPathForRow(n);
            TableNode tableNode = (TableNode)((Object)treePath.getLastPathComponent());
            if (!tableNode.isOffer()) {
                return false;
            }
            tableNode.offer = dbAgencyInterestOffer;
            ContactsEntryEstateOffersPanel.this.interestsTableModel.valueForPathChanged(treePath, (Object)tableNode);
            return true;
        }
    }

    private static class TableTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private final Icon searchIcon = ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16);
        private final Icon offerIcon = AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16);

        private TableTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            TableNode tableNode = (TableNode)((Object)object);
            this.setText((String)tableNode.getValueAt(0));
            if (tableNode.isSearch()) {
                this.setIcon(this.searchIcon);
            } else if (tableNode.isOffer()) {
                this.setIcon(this.offerIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private static class TableNode
    extends AbstractMutableTreeTableNode {
        private DbAgencyInterest interest = null;
        private DbAgencySearch interestSearch = null;
        private DbAgencyInterestOffer offer = null;
        private DbAgencyObject offerObject = null;

        private TableNode() {
        }

        private TableNode(DbAgencyInterest dbAgencyInterest, DbAgencySearch dbAgencySearch) {
            this.interest = dbAgencyInterest;
            this.interestSearch = dbAgencySearch;
            this.offer = null;
            this.offerObject = null;
        }

        private TableNode(DbAgencyInterestOffer dbAgencyInterestOffer, DbAgencyObject dbAgencyObject) {
            this.offer = dbAgencyInterestOffer;
            this.offerObject = dbAgencyObject;
            this.interest = null;
            this.interestSearch = null;
        }

        public int getColumnCount() {
            if (this.interest != null && this.interestSearch != null) {
                return 1;
            }
            if (this.offer != null && this.offerObject != null) {
                return 10;
            }
            return 0;
        }

        public Object getValueAt(int n) {
            if (this.interest != null && this.interestSearch != null) {
                switch (n) {
                    case 0: {
                        return this.interestSearch.item.getName();
                    }
                }
                return null;
            }
            if (this.offer != null && this.offerObject != null) {
                switch (n) {
                    case 4: {
                        return this.offerObject.item.getAction().getTranslation();
                    }
                    case 7: {
                        return this.offerObject.item.getAddress().getCity();
                    }
                    case 2: {
                        return this.offerObject.item.getPublicId();
                    }
                    case 6: {
                        return this.offerObject.item.getAddress().getPostalCode();
                    }
                    case 8: {
                        return this.offerObject.status.getTranslation();
                    }
                    case 5: {
                        return this.offerObject.item.getAddress().writeStreet(true);
                    }
                    case 3: {
                        return this.offerObject.item.getType().getTranslation();
                    }
                    case 9: {
                        return this.offer.status;
                    }
                    case 1: {
                        return this.offer.time;
                    }
                    case 0: {
                        return StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.offerObject.id;
                    }
                }
                return null;
            }
            return null;
        }

        public boolean isOffer() {
            return this.offer != null && this.offerObject != null;
        }

        public boolean isSearch() {
            return this.interest != null && this.interestSearch != null;
        }
    }

    private static class TableModel
    extends AbstractTreeTableModel {
        private static final int COLUMN_OFFER = 0;
        private static final int COLUMN_OFFER_TIME = 1;
        private static final int COLUMN_OBJECT_NR = 2;
        private static final int COLUMN_OBJECT_TYPE = 3;
        private static final int COLUMN_OBJECT_ACTION = 4;
        private static final int COLUMN_OBJECT_STREET = 5;
        private static final int COLUMN_OBJECT_POSTAL = 6;
        private static final int COLUMN_OBJECT_CITY = 7;
        private static final int COLUMN_OBJECT_STATUS = 8;
        private static final int COLUMN_OFFER_STATUS = 9;
        private static final int TOTAL_COLUMNS = 10;
        private TableNode rootNode = (TableNode)((Object)this.getRoot());

        public TableModel() {
            super((Object)new TableNode());
        }

        public Object getChild(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildAt(n);
        }

        public int getChildCount(Object object) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getChildCount();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return String.class;
                }
                case 1: {
                    return Date.class;
                }
                case 9: {
                    return DbAgencyInterestOffer.Status.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return StringUtils.capitalize((String)I18N.tr("search mandate")) + " / " + StringUtils.capitalize((String)I18N.tr("offer"));
                }
                case 1: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case 2: {
                    return StringUtils.capitalize((String)I18N.tr("property-nr"));
                }
                case 3: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case 4: {
                    return StringUtils.capitalize((String)I18N.tr("marketing"));
                }
                case 5: {
                    return StringUtils.capitalize((String)I18N.tr("street"));
                }
                case 6: {
                    return StringUtils.capitalize((String)I18N.tr("postcode"));
                }
                case 7: {
                    return StringUtils.capitalize((String)I18N.tr("place"));
                }
                case 8: {
                    return StringUtils.capitalize((String)I18N.tr("property")) + "-" + I18N.tr("status");
                }
                case 9: {
                    return StringUtils.capitalize((String)I18N.tr("offer")) + "-" + I18N.tr("status");
                }
            }
            return null;
        }

        public int getIndexOfChild(Object object, Object object2) {
            TableNode tableNode = (TableNode)((Object)object);
            for (int i = 0; i < tableNode.getChildCount(); ++i) {
                if (tableNode.getChildAt(i) != object2) continue;
                return i;
            }
            return -1;
        }

        public TableNode getRootNode() {
            return this.rootNode;
        }

        public Object getValueAt(Object object, int n) {
            TableNode tableNode = (TableNode)((Object)object);
            return tableNode.getValueAt(n);
        }
    }
}

