/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts.gui;

import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.gui.AbstractRenderer;
import java.awt.Color;
import javax.swing.JLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class InterestOfferStatusRenderer
extends AbstractRenderer<DbAgencyInterestOffer.Status> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterestOfferStatusRenderer.class);
    private static final I18n I18N = I18nFactory.getI18n(InterestOfferStatusRenderer.class);

    public InterestOfferStatusRenderer() {
        this(null);
    }

    public InterestOfferStatusRenderer(String string) {
        super(string);
    }

    public void render(DbAgencyInterestOffer.Status status, JLabel jLabel) {
        if (status != null) {
            jLabel.setText(status.getTranslation());
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            switch (status) {
                case REQUESTED: {
                    jLabel.setForeground(Color.YELLOW.darker().darker());
                    break;
                }
                case OPEN: {
                    jLabel.setForeground(Color.YELLOW.darker().darker());
                    break;
                }
                case INTERESTED: {
                    jLabel.setForeground(Color.BLUE.darker());
                    break;
                }
                case ACCEPTED: {
                    jLabel.setForeground(Color.GREEN.darker().darker());
                    break;
                }
                case DENIED: {
                    jLabel.setForeground(Color.RED);
                    break;
                }
                case RESIGNED: {
                    jLabel.setForeground(Color.RED);
                    break;
                }
                case SHELVED: {
                    jLabel.setForeground(Color.DARK_GRAY);
                    break;
                }
                case NOT_OFFERED: {
                    jLabel.setForeground(Color.DARK_GRAY);
                    break;
                }
                default: {
                    jLabel.setForeground(Color.BLACK);
                    break;
                }
            }
        } else {
            jLabel.setText(this.getEmptyText());
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setForeground(Color.BLACK);
        }
    }
}

