/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.agency.addons.contacts.gui.InterestOfferStatusRenderer;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerDateModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AgencyInterestOfferPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyInterestOfferPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyInterestOfferPanel.class);
    private DbAgencyInterestOffer currentOffer = null;
    private JXTitledSeparator formTitle;
    private JLabel statusLabel;
    private JComboBox<DbAgencyInterestOffer.Status> statusField;
    private JLabel timeLabel;
    private JSpinner timeField;
    private JLabel notesLabel;
    private DefaultTextArea notesField;

    public AgencyInterestOfferPanel() {
        this.build();
    }

    private void build() {
        this.statusLabel = new JLabel();
        this.statusField = new JComboBox();
        this.statusField.setRenderer((ListCellRenderer<DbAgencyInterestOffer.Status>)new DefaultListCellRenderer((Renderer)new InterestOfferStatusRenderer("-")));
        this.statusField.addItem(null);
        for (DbAgencyInterestOffer.Status status : DbAgencyInterestOffer.Status.values()) {
            this.statusField.addItem(status);
        }
        this.timeLabel = new JLabel();
        this.timeField = new JSpinner(new SpinnerDateModel());
        this.timeField.setEditor(new JSpinner.DateEditor(this.timeField));
        this.timeField.setValue(new Date());
        this.notesLabel = new JLabel();
        this.notesField = new DefaultTextArea();
        JScrollPane jScrollPane = this.notesField.createScrollPane();
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{new RelationSubmitAction(), new RelationCloseAction()});
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, pref, 3dlu, right:[40dlu,pref], 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)jPanel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.timeLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.timeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.notesLabel).xy(5, defaultFormBuilder.row());
        int n = defaultFormBuilder.row();
        defaultFormBuilder.add((Component)this.statusLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.statusField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.addRaw((Component)jScrollPane).xywh(7, n, 1, 4);
        this.updateLocalization();
    }

    protected abstract void close();

    private void doRelationClose() {
        this.unselectRelation();
        this.close();
    }

    private void doRelationSubmit() {
        try {
            this.timeField.commitEdit();
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read offer-time!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        DbAgencyInterestOffer dbAgencyInterestOffer = new DbAgencyInterestOffer();
        dbAgencyInterestOffer.agencyObjectId = this.currentOffer.agencyObjectId;
        dbAgencyInterestOffer.interestId = this.currentOffer.interestId;
        dbAgencyInterestOffer.status = (DbAgencyInterestOffer.Status)((Object)this.statusField.getSelectedItem());
        dbAgencyInterestOffer.time = (Date)this.timeField.getValue();
        dbAgencyInterestOffer.notes = this.notesField.getText().trim();
        if (dbAgencyInterestOffer.time == null) {
            return;
        }
        if (this.submit(dbAgencyInterestOffer)) {
            this.unselectRelation();
        }
    }

    public void selectEmptyRelation() {
        this.selectRelation(new DbAgencyInterestOffer());
    }

    public void selectRelation(DbAgencyInterestOffer dbAgencyInterestOffer) {
        this.currentOffer = dbAgencyInterestOffer;
        if (dbAgencyInterestOffer == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.statusField.setSelectedItem((Object)dbAgencyInterestOffer.status);
        this.timeField.setValue(dbAgencyInterestOffer.time != null ? dbAgencyInterestOffer.time : new Date());
        this.notesField.setText(dbAgencyInterestOffer.notes);
        this.notesField.setCaretPosition(0);
    }

    protected abstract boolean submit(DbAgencyInterestOffer var1);

    public void unselectRelation() {
        this.selectRelation(null);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(this.currentOffer != null && this.currentOffer.agencyObjectId > 0L ? StringUtils.capitalize((String)I18N.tr("edit assignment")) : StringUtils.capitalize((String)I18N.tr("add assignment")));
        this.statusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
        this.timeLabel.setText(StringUtils.capitalize((String)I18N.tr("time")) + ":");
        this.notesLabel.setText(StringUtils.capitalize((String)I18N.tr("notes")) + ":");
    }

    private class RelationSubmitAction
    extends AbstractI18nAction {
        private RelationSubmitAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestOfferPanel.this.doRelationSubmit();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("submit")));
            this.setShortDescription(I18N.tr("Submit assignment."));
        }
    }

    private class RelationCloseAction
    extends AbstractI18nAction {
        private RelationCloseAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestOfferPanel.this.doRelationClose();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("cancel")));
            this.setShortDescription(I18N.tr("Close assignment."));
        }
    }
}

