/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.contacts.ContactsEntryTable;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyInterestTable<R extends Row>
extends ContactsEntryTable<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyInterestTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyInterestTable.class);

    public AgencyInterestTable(String string) {
        super(string);
    }

    public AgencyInterestTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public DbAgencyInterest getInterestAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getInterest() : null;
    }

    public Long getInterestIdAt(int n) {
        DbAgencyInterest dbAgencyInterest = this.getInterestAt(n);
        return dbAgencyInterest != null ? dbAgencyInterest.id : 0L;
    }

    public int getRowForInterestId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getInterestIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    public DbAgencySearch getSearchAt(int n) {
        Row row = (Row)this.getRow(n);
        return row != null ? row.getSearch() : null;
    }

    public Long getSearchIdAt(int n) {
        DbAgencySearch dbAgencySearch = this.getSearchAt(n);
        return dbAgencySearch != null ? dbAgencySearch.id : 0L;
    }

    protected List<AbstractTable.Column> listColumns() {
        List list = super.listColumns();
        list.addAll(Arrays.asList(Column.values()));
        return list;
    }

    public static class Row
    extends ContactsEntryTable.Row {
        private final DbAgencyInterest interest;
        private final DbAgencySearch search;

        public Row(DbContactsEntry dbContactsEntry, String string, DbAgencyInterest dbAgencyInterest, DbAgencySearch dbAgencySearch) {
            super(dbContactsEntry, string);
            this.interest = dbAgencyInterest;
            this.search = dbAgencySearch;
        }

        public DbAgencyInterest getInterest() {
            return this.interest;
        }

        public DbAgencySearch getSearch() {
            return this.search;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForInterest((Column)column);
            }
            return super.getValue(column);
        }

        public Object getValueForInterest(Column column) {
            if (this.interest == null || this.search == null) {
                return null;
            }
            SearchImpl searchImpl = (SearchImpl)ObjectUtils.defaultIfNull((Object)this.search.item, (Object)new SearchImpl());
            switch (column) {
                case INTEREST_STATUS: {
                    return this.interest.status;
                }
                case SEARCH_NAME: {
                    return searchImpl.getName();
                }
                case SEARCH_OBJECT_ACTION: {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (SearchEqualsImpl searchEqualsImpl : searchImpl.getSimpleConditions(SearchImpl.SimpleConditionType.ESTATE_ACTION)) {
                        String string = searchEqualsImpl.getValue();
                        OpenEstateAction openEstateAction = !StringUtils.isBlank((CharSequence)string) ? OpenEstateUtils.lookupAction((String)string) : null;
                        String string2 = openEstateAction != null ? openEstateAction.getTranslation() : null;
                        if (StringUtils.isBlank((CharSequence)string2) || arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                    }
                    return StringUtils.join(arrayList, (String)", ");
                }
                case SEARCH_OBJECT_TYPE: {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (SearchEqualsImpl searchEqualsImpl : searchImpl.getSimpleConditions(SearchImpl.SimpleConditionType.ESTATE_TYPE)) {
                        String string = searchEqualsImpl.getValue();
                        OpenEstateType openEstateType = !StringUtils.isBlank((CharSequence)string) ? OpenEstateUtils.lookupEstate((String)string) : null;
                        String string3 = openEstateType != null ? openEstateType.getTranslation() : null;
                        if (StringUtils.isBlank((CharSequence)string3) || arrayList.contains(string3)) continue;
                        arrayList.add(string3);
                    }
                    return StringUtils.join(arrayList, (String)", ");
                }
            }
            return null;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        SEARCH_NAME,
        SEARCH_OBJECT_TYPE,
        SEARCH_OBJECT_ACTION,
        INTEREST_STATUS;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case INTEREST_STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new TranslatableRenderer("-"));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case SEARCH_NAME: {
                    return String.class;
                }
                case SEARCH_OBJECT_ACTION: {
                    return String.class;
                }
                case SEARCH_OBJECT_TYPE: {
                    return String.class;
                }
                case INTEREST_STATUS: {
                    return DbAgencyInterest.Status.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case SEARCH_NAME: {
                    return StringUtils.capitalize((String)I18N.trc("search (noun)", "search")) + "-" + StringUtils.capitalize((String)I18N.tr("title"));
                }
                case SEARCH_OBJECT_ACTION: {
                    return StringUtils.capitalize((String)I18N.trc("search (noun)", "search")) + "-" + StringUtils.capitalize((String)I18N.tr("marketing"));
                }
                case SEARCH_OBJECT_TYPE: {
                    return StringUtils.capitalize((String)I18N.trc("search (noun)", "search")) + "-" + StringUtils.capitalize((String)I18N.tr("type"));
                }
                case INTEREST_STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("mandate")) + "-" + StringUtils.capitalize((String)I18N.tr("status"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }
}

