/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandlerImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyInterestsHandler
extends DbAgencyInterestsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyInterestsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyInterestsHandler.class);
    public static final String VIEW_INTERESTS = "view_immotool_agency_interests";
    public static final String VIEW_INTERESTS_OFFERS = "view_immotool_agency_interests_offers";
    public static final String PROC_REMOVE_INTERESTS = "remove_immotool_agency_interests";
    public static final String PROC_REMOVE_INTERESTS_OFFERS = "remove_immotool_agency_interests_offers";
    public static final String PROC_SAVE_INTERESTS = "save_immotool_agency_interests";
    public static final String PROC_SAVE_INTERESTS_OFFERS = "save_immotool_agency_interests_offers";
    private static final String FIELD_INTEREST_ID = "interest_id";
    private static final String FIELD_INTEREST_STATUS = "interest_status";
    private static final String FIELD_INTEREST_BEGIN = "interest_begin";
    private static final String FIELD_INTEREST_END = "interest_end";
    private static final String FIELD_INTEREST_NOTES = "interest_notes";
    private static final String FIELD_OFFER_STATUS = "offer_status";
    private static final String FIELD_OFFER_TIME = "offer_time";
    private static final String FIELD_OFFER_NOTES = "offer_notes";
    private static final String FIELD_AGENCY_OBJECT_ID = "agency_object_id";
    private static final String FIELD_AGENCY_SEARCH_ID = "agency_search_id";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    private DbAgencyInterest createInterest(ResultSet resultSet) throws SQLException {
        DbAgencyInterest dbAgencyInterest = this.buildInterest();
        dbAgencyInterest.id = resultSet.getLong(FIELD_INTEREST_ID);
        dbAgencyInterest.agencySearchId = resultSet.getLong(FIELD_AGENCY_SEARCH_ID);
        dbAgencyInterest.contactsEntryId = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
        dbAgencyInterest.begin = resultSet.getTimestamp(FIELD_INTEREST_BEGIN);
        dbAgencyInterest.end = resultSet.getTimestamp(FIELD_INTEREST_END);
        dbAgencyInterest.notes = resultSet.getString(FIELD_INTEREST_NOTES);
        dbAgencyInterest.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyInterest.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        try {
            dbAgencyInterest.status = DbAgencyInterest.Status.valueOf(resultSet.getString(FIELD_INTEREST_STATUS));
        }
        catch (Exception exception) {
            dbAgencyInterest.status = null;
            LOGGER.warn("Can't read status of CRM interest #" + dbAgencyInterest.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbAgencyInterest;
    }

    private DbAgencyInterestOffer createInterestOffer(ResultSet resultSet) throws SQLException {
        DbAgencyInterestOffer dbAgencyInterestOffer = this.buildInterestOffer();
        dbAgencyInterestOffer.interestId = resultSet.getLong(FIELD_INTEREST_ID);
        dbAgencyInterestOffer.agencyObjectId = resultSet.getLong(FIELD_AGENCY_OBJECT_ID);
        dbAgencyInterestOffer.notes = resultSet.getString(FIELD_OFFER_NOTES);
        dbAgencyInterestOffer.time = resultSet.getTimestamp(FIELD_OFFER_TIME);
        try {
            dbAgencyInterestOffer.status = DbAgencyInterestOffer.Status.valueOf(resultSet.getString(FIELD_OFFER_STATUS));
        }
        catch (Exception exception) {
            dbAgencyInterestOffer.status = null;
            LOGGER.warn("Can't read status for offer of CRM interest #" + dbAgencyInterestOffer.interestId + " / object #" + dbAgencyInterestOffer.agencyObjectId + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbAgencyInterestOffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyInterest[] getInterests(Connection connection, long[] lArray) throws SQLException {
        DbAgencyInterest[] dbAgencyInterestArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyInterest[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests WHERE interest_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_INTEREST_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
            while (resultSet.next()) {
                arrayList.add(this.createInterest(resultSet));
            }
            dbAgencyInterestArray = arrayList.toArray(new DbAgencyInterest[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyInterestArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyInterest[] getInterests(Connection connection, DbAgencyInterest.Status status) throws SQLException {
        DbAgencyInterest[] dbAgencyInterestArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (status == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests WHERE interest_status = ? ORDER BY interest_id ASC;");
                preparedStatement.setString(1, status.name());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
            while (resultSet.next()) {
                arrayList.add(this.createInterest(resultSet));
            }
            dbAgencyInterestArray = arrayList.toArray(new DbAgencyInterest[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyInterestArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyInterest[] getInterestsForContact(Connection connection, long[] lArray) throws SQLException {
        DbAgencyInterest[] dbAgencyInterestArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyInterest[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_INTEREST_ID + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
            while (resultSet.next()) {
                arrayList.add(this.createInterest(resultSet));
            }
            dbAgencyInterestArray = arrayList.toArray(new DbAgencyInterest[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyInterestArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyInterest[] getInterestsForEstate(Connection connection, long[] lArray) throws SQLException {
        DbAgencyInterest[] dbAgencyInterestArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyInterest[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests WHERE interest_id IN (SELECT interest_id FROM view_immotool_agency_interests_offers WHERE agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ) ORDER BY " + FIELD_INTEREST_ID + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
            while (resultSet.next()) {
                arrayList.add(this.createInterest(resultSet));
            }
            dbAgencyInterestArray = arrayList.toArray(new DbAgencyInterest[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyInterestArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getInterestIds(Connection connection, DbAgencyInterest.Status status) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (status == null) {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests WHERE interest_status = ? ORDER BY interest_id ASC;");
                preparedStatement.setString(1, status.name());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_INTEREST_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getInterestIdsForContact(Connection connection, long[] lArray) throws SQLException {
        long[] lArray2;
        if (lArray != null && lArray.length < 1) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_INTEREST_ID + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_INTEREST_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getInterestIdsForEstate(Connection connection, long[] lArray) throws SQLException {
        long[] lArray2;
        if (lArray != null && lArray.length < 1) {
            return new long[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests ORDER BY interest_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT interest_id FROM view_immotool_agency_interests WHERE interest_id IN (SELECT interest_id FROM view_immotool_agency_interests_offers WHERE agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ) ORDER BY " + FIELD_INTEREST_ID + " ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_INTEREST_ID));
            }
            lArray2 = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadInterestOffers(Connection connection, DbAgencyInterest[] dbAgencyInterestArray) throws SQLException {
        HashMap<Long, DbAgencyInterest> hashMap = new HashMap<Long, DbAgencyInterest>();
        for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestArray) {
            if (dbAgencyInterest.id <= 0L || hashMap.containsKey(dbAgencyInterest.id)) continue;
            hashMap.put(dbAgencyInterest.id, dbAgencyInterest);
            if (dbAgencyInterest.offers != null) {
                dbAgencyInterest.offers.clear();
                continue;
            }
            dbAgencyInterest.offers = new HashMap<Long, DbAgencyInterestOffer>();
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_interests_offers WHERE interest_id IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_INTEREST_ID + " ASC, " + FIELD_AGENCY_OBJECT_ID + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                DbAgencyInterestOffer dbAgencyInterestOffer = this.createInterestOffer(resultSet);
                ((DbAgencyInterest)hashMap.get((Object)Long.valueOf((long)dbAgencyInterestOffer.interestId))).offers.put(dbAgencyInterestOffer.agencyObjectId, dbAgencyInterestOffer);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    @Override
    public void removeInterests(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_interests(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void removeInterestOffers(Connection connection, long l, long[] lArray) throws SQLException {
        if (l < 1L || lArray == null) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL remove_immotool_agency_interests_offers(:interest_id, :agency_object_id);");
            for (long l2 : lArray) {
                if (l2 <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_INTEREST_ID, l);
                namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, l2);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveInterest(Connection connection, DbAgencyInterest dbAgencyInterest) throws SQLException {
        ArrayList<CallableStatement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block11: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<CallableStatement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_interests(:interest_id, :contacts_entry_id, :agency_search_id, :interest_status, :interest_begin, :interest_end, :interest_notes);");
                namedCallableStatement.setLong(FIELD_INTEREST_ID, dbAgencyInterest.id);
                namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbAgencyInterest.contactsEntryId);
                namedCallableStatement.setLong(FIELD_AGENCY_SEARCH_ID, dbAgencyInterest.agencySearchId);
                namedCallableStatement.setString(FIELD_INTEREST_NOTES, dbAgencyInterest.notes);
                namedCallableStatement.setString(FIELD_INTEREST_STATUS, dbAgencyInterest.status != null ? dbAgencyInterest.status.name() : null);
                namedCallableStatement.setTimestamp(FIELD_INTEREST_BEGIN, dbAgencyInterest.begin != null ? new Timestamp(dbAgencyInterest.begin.getTime()) : null);
                namedCallableStatement.setTimestamp(FIELD_INTEREST_END, dbAgencyInterest.end != null ? new Timestamp(dbAgencyInterest.end.getTime()) : null);
                namedCallableStatement.execute();
                long l2 = l = dbAgencyInterest.id < 1L ? namedCallableStatement.getLong(FIELD_INTEREST_ID) : dbAgencyInterest.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                if (dbAgencyInterest.offers != null) {
                    NamedCallableStatement namedCallableStatement2;
                    if (dbAgencyInterest.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL remove_immotool_agency_interests_offers(:interest_id, :agency_object_id);");
                        namedCallableStatement2.setLong(FIELD_INTEREST_ID, dbAgencyInterest.id);
                        namedCallableStatement2.setNull(FIELD_AGENCY_OBJECT_ID, -5);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    if (!dbAgencyInterest.offers.isEmpty()) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL save_immotool_agency_interests_offers(:interest_id, :agency_object_id, :offer_time, :offer_status, :offer_notes);");
                        for (DbAgencyInterestOffer dbAgencyInterestOffer : dbAgencyInterest.offers.values()) {
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_INTEREST_ID, l);
                            namedCallableStatement2.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyInterestOffer.agencyObjectId);
                            namedCallableStatement2.setString(FIELD_OFFER_NOTES, dbAgencyInterestOffer.notes);
                            namedCallableStatement2.setString(FIELD_OFFER_STATUS, dbAgencyInterestOffer.status != null ? dbAgencyInterestOffer.status.name() : null);
                            namedCallableStatement2.setTimestamp(FIELD_OFFER_TIME, dbAgencyInterestOffer.time != null ? new Timestamp(dbAgencyInterestOffer.time.getTime()) : null);
                            namedCallableStatement2.execute();
                        }
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbAgencyInterest.id >= 1L) break block11;
                dbAgencyInterest.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveInterestOffers(Connection connection, DbAgencyInterestOffer[] dbAgencyInterestOfferArray) throws SQLException {
        if (dbAgencyInterestOfferArray == null || dbAgencyInterestOfferArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_interests_offers(:interest_id, :agency_object_id, :offer_time, :offer_status, :offer_notes);");
            for (DbAgencyInterestOffer dbAgencyInterestOffer : dbAgencyInterestOfferArray) {
                if (dbAgencyInterestOffer.interestId <= 0L || dbAgencyInterestOffer.agencyObjectId <= 0L) continue;
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_INTEREST_ID, dbAgencyInterestOffer.interestId);
                namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyInterestOffer.agencyObjectId);
                namedCallableStatement.setString(FIELD_OFFER_NOTES, dbAgencyInterestOffer.notes);
                namedCallableStatement.setString(FIELD_OFFER_STATUS, dbAgencyInterestOffer.status != null ? dbAgencyInterestOffer.status.name() : null);
                namedCallableStatement.setTimestamp(FIELD_OFFER_TIME, dbAgencyInterestOffer.time != null ? new Timestamp(dbAgencyInterestOffer.time.getTime()) : null);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

