/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immobiliare_it;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConvertableDocument;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItVersion;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImmobiliareItDocument
extends XmlConvertableDocument<Feed, ImmobiliareItVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItDocument.class);

    public ImmobiliareItDocument(Document document) {
        super(document);
        if (!ImmobiliareItDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    public ImmobiliareItVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            string = StringUtils.trimToNull((String)XmlUtils.newXPath((String)"/io:feed/io:version/text()", (Document)object).stringValueOf(object));
            if (string == null) {
                LOGGER.warn("Can't find version information in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = ImmobiliareItVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public ImmobiliareItVersion getLatestVersion() {
        return ImmobiliareItUtils.VERSION;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "feed".equals(element.getLocalName());
    }

    public static ImmobiliareItDocument newDocument() throws ParserConfigurationException, JAXBException {
        return ImmobiliareItDocument.newDocument(ImmobiliareItUtils.getFactory().createFeed());
    }

    public static ImmobiliareItDocument newDocument(Feed feed) throws ParserConfigurationException, JAXBException {
        if (feed.getVersion() == null) {
            feed.setVersion(Version.V2_5);
        }
        Document document = XmlUtils.newDocument();
        ImmobiliareItUtils.createMarshaller("UTF-8", true).marshal((Object)feed, (Node)document);
        return new ImmobiliareItDocument(document);
    }

    public void setDocumentVersion(ImmobiliareItVersion immobiliareItVersion) {
        try {
            Document document = this.getDocument();
            Element element = (Element)XmlUtils.newXPath((String)"/io:feed/io:version", (Document)document).selectSingleNode((Object)document);
            if (element == null) {
                Element element2 = (Element)XmlUtils.newXPath((String)"/io:feed", (Document)document).selectSingleNode((Object)document);
                if (element2 == null) {
                    LOGGER.warn("Can't find a <feed> element in the document!");
                    return;
                }
                element = document.createElement("version");
                element2.insertBefore(element, element2.getFirstChild());
            }
            element.setTextContent(immobiliareItVersion.toReadableVersion());
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public Feed toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (Feed)ImmobiliareItUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

