/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CsvPrinter<Record extends CsvRecord>
implements Closeable,
Flushable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvPrinter.class);
    private static final Pattern LINES = Pattern.compile("^(.*)$", 8);
    private final CSVPrinter printer;

    protected CsvPrinter(CSVPrinter cSVPrinter) {
        this.printer = cSVPrinter;
    }

    @Override
    public void close() throws IOException {
        this.printer.close();
    }

    @Override
    public void flush() throws IOException {
        this.printer.flush();
    }

    protected void print(String string) throws IOException {
        this.printer.print((Object)string);
    }

    protected void println() throws IOException {
        this.printer.println();
    }

    protected void printComment(String string) throws IOException {
        this.printer.printComment(string);
    }

    public void printRecord(Record Record) throws IOException {
        for (String string : ((CsvRecord)Record).print()) {
            this.print(string);
        }
        this.println();
    }

    public void printRecords(Iterable<Record> iterable) throws IOException {
        for (CsvRecord csvRecord : iterable) {
            this.printRecord(csvRecord);
        }
        this.flush();
    }

    protected static String replaceLineBreaks(String string) {
        return CsvPrinter.replaceLineBreaks(string, null);
    }

    protected static String replaceLineBreaks(String string, String string2) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "<br/>";
        }
        Matcher matcher = LINES.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            stringBuilder.append(StringUtils.trimToEmpty((String)matcher.group()));
            if (matcher.hitEnd()) continue;
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

