/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.BuildableInShortTerm;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.BuildingPermissionAvailable;
import com.openindex.openestate.impl.attribs.administration.DemolitionRequired;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ConstructionPhase;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.CeilingLoad;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountGuestrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowArea;
import com.openindex.openestate.impl.attribs.measures.GuestTerrace;
import com.openindex.openestate.impl.attribs.measures.Height;
import com.openindex.openestate.impl.attribs.measures.Length;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.Width;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeRequired;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomePerMonth;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.SupplyAccess;
import com.openindex.openestate.impl.is24.Is24Utils;
import com.openindex.openestate.impl.utils.AbstractCsvReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvParser;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.records.Anlageobjekt;
import org.openestate.io.is24_csv.records.GewerbeBueroPraxis;
import org.openestate.io.is24_csv.records.GewerbeEinzelhandel;
import org.openestate.io.is24_csv.records.GewerbeGastronomieHotel;
import org.openestate.io.is24_csv.records.GewerbeHalleProduktion;
import org.openestate.io.is24_csv.records.GewerbeSonstiges;
import org.openestate.io.is24_csv.records.GrundstueckGewerbe;
import org.openestate.io.is24_csv.records.GrundstueckWohnen;
import org.openestate.io.is24_csv.records.HausKauf;
import org.openestate.io.is24_csv.records.HausMiete;
import org.openestate.io.is24_csv.records.StellplatzKauf;
import org.openestate.io.is24_csv.records.StellplatzMiete;
import org.openestate.io.is24_csv.records.WohnenAufZeit;
import org.openestate.io.is24_csv.records.WohnungKauf;
import org.openestate.io.is24_csv.records.WohnungMiete;
import org.openestate.io.is24_csv.types.Ausstattung;
import org.openestate.io.is24_csv.types.Auswahl;
import org.openestate.io.is24_csv.types.Bauphase;
import org.openestate.io.is24_csv.types.BebaubarNach;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.Bodenbelag;
import org.openestate.io.is24_csv.types.Datei;
import org.openestate.io.is24_csv.types.DateiTyp;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Erschliessung;
import org.openestate.io.is24_csv.types.Geschlecht;
import org.openestate.io.is24_csv.types.Heizungsart;
import org.openestate.io.is24_csv.types.HeizungsartWohnenAufZeit;
import org.openestate.io.is24_csv.types.Importmodus;
import org.openestate.io.is24_csv.types.KaltmietePro;
import org.openestate.io.is24_csv.types.Lage;
import org.openestate.io.is24_csv.types.NutzungGrundstueckGewerbe;
import org.openestate.io.is24_csv.types.NutzungGrundstueckWohnen;
import org.openestate.io.is24_csv.types.ObjektkategorieAnlageobjekt;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeBueroPraxen;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeEinzelhandel;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeGastronomieHotel;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeHalleProduktion;
import org.openestate.io.is24_csv.types.ObjektkategorieGewerbeSonstiges;
import org.openestate.io.is24_csv.types.ObjektkategorieGrundstueck;
import org.openestate.io.is24_csv.types.ObjektkategorieHaus;
import org.openestate.io.is24_csv.types.ObjektkategorieStellplatz;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnenAufZeit;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnung;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.PauschalmietePro;
import org.openestate.io.is24_csv.types.Rauchen;
import org.openestate.io.is24_csv.types.Stellplatz;
import org.openestate.io.is24_csv.types.Vermarktungsart;
import org.openestate.io.is24_csv.types.VermarktungsartGewerbe;
import org.openestate.io.is24_csv.types.Zulieferung;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvReader
extends AbstractCsvReader<Is24CsvParser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvReader.class);

    public Is24CsvReader() {
    }

    public Is24CsvReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl createAgent(Is24CsvRecord is24CsvRecord) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.setId(is24CsvRecord.getScoutKundenId());
        return agentImpl;
    }

    protected EstateAttachmentImpl createAttachment(Datei datei, String string) {
        EstateAttachmentImpl estateAttachmentImpl;
        if (datei == null) {
            return null;
        }
        String string2 = StringUtils.trimToNull((String)datei.getName());
        if (string2 == null) {
            return null;
        }
        DateiTyp dateiTyp = datei.getTyp();
        if (DateiTyp.LINK.equals((Object)dateiTyp)) {
            try {
                if (!string2.toLowerCase().startsWith("http:") && !string2.toLowerCase().startsWith("https:")) {
                    string2 = "http://" + string2;
                }
                estateAttachmentImpl = this.createEmptyAttachment();
                estateAttachmentImpl.setFile(new URI(string2.trim()));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read attachment URL '" + string2 + "'!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage());
                this.putError(string, "Can't read attachment URL '" + string2 + "'! " + uRISyntaxException.getLocalizedMessage());
                return null;
            }
        } else {
            estateAttachmentImpl = this.createEmptyAttachment();
            estateAttachmentImpl.setFile(string2);
            if (DateiTyp.GRUNDRISS_BILD.equals((Object)dateiTyp)) {
                estateAttachmentImpl.setType(EstateAttachmentType.IMAGE_GROUNDPLAN);
            } else if (DateiTyp.BILD.equals((Object)dateiTyp)) {
                estateAttachmentImpl.setType(EstateAttachmentType.IMAGE);
            }
        }
        estateAttachmentImpl.setTitle(datei.getText(), this.getOpenEstateLanguage());
        estateAttachmentImpl.setMimeType(datei.guessMimeType());
        return estateAttachmentImpl;
    }

    protected AgentContactImpl createContact(Is24CsvRecord is24CsvRecord) {
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        agentContactImpl.setPersonFirstName(is24CsvRecord.getKontaktVorname());
        agentContactImpl.setPersonLastName(is24CsvRecord.getKontaktNachname());
        agentContactImpl.setStreet(is24CsvRecord.getKontaktStrasse());
        agentContactImpl.setStreetNr(is24CsvRecord.getKontaktHausNr());
        agentContactImpl.setPostalCode(is24CsvRecord.getKontaktPlz());
        agentContactImpl.setCity(is24CsvRecord.getKontaktOrt());
        agentContactImpl.setCountry(this.getCountry(is24CsvRecord.getKontaktLand()));
        agentContactImpl.setPersonPhone(is24CsvRecord.getKontaktTelefon());
        agentContactImpl.setPersonMobilePhone(is24CsvRecord.getKontaktMobiltelefon());
        agentContactImpl.setPersonFax(is24CsvRecord.getKontaktTelefax());
        agentContactImpl.setPersonMail(is24CsvRecord.getKontaktEmail());
        String string = StringUtils.trimToNull((String)is24CsvRecord.getKontaktAnrede());
        if (string == null) {
            agentContactImpl.setPersonGender((Gender)null);
        } else if (string.toLowerCase().contains("frau") || string.equalsIgnoreCase(Gender.FEMALE.name())) {
            agentContactImpl.setPersonGender(Gender.FEMALE);
        } else if (string.toLowerCase().contains("herr") || string.equalsIgnoreCase(Gender.MALE.name())) {
            agentContactImpl.setPersonGender(Gender.MALE);
        }
        String string2 = StringUtils.trimToNull((String)is24CsvRecord.getKontaktWebseite());
        if (string2 != null) {
            try {
                if (!string2.toLowerCase().startsWith("http://") && !string2.toLowerCase().startsWith("https://")) {
                    string2 = "http://" + string2;
                }
                agentContactImpl.setContactWebsite(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read attachment URL '" + string2 + "'!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                agentContactImpl.setContactWebsite(null);
                this.putError(is24CsvRecord.getAnbieterObjektId(), "Can't read attachment URL '" + string2 + "'! " + uRISyntaxException.getLocalizedMessage());
            }
        }
        return agentContactImpl;
    }

    protected EstateImpl createEstate(Is24CsvRecord is24CsvRecord) throws OpenEstateException {
        EstateImpl estateImpl = this.createEmptyEstate();
        estateImpl.setId(is24CsvRecord.getAnbieterObjektId());
        estateImpl.setPublicId(is24CsvRecord.getAnbieterObjektId());
        estateImpl.setCurrency(is24CsvRecord.getWaehrung());
        estateImpl.getCustomValues().putCustomValue("nr", (Object)is24CsvRecord.getAnbieterObjektId(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.api.search1", (Object)is24CsvRecord.getApiSuchfeld1(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.api.search2", (Object)is24CsvRecord.getApiSuchfeld2(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.api.search3", (Object)is24CsvRecord.getApiSuchfeld3(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.agent.id", (Object)is24CsvRecord.getScoutKundenId(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.object.id", (Object)is24CsvRecord.getScoutObjektId(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.terms.region", (Object)is24CsvRecord.getTermsRegion(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.terms.stadt", (Object)is24CsvRecord.getTermsStadt(), 5);
        estateImpl.getCustomValues().putCustomValue("is24.terms.stadtteil", (Object)is24CsvRecord.getTermsStadtteil(), 5);
        Integer n = is24CsvRecord.getGruppierungId();
        if (n != null) {
            estateImpl.setGroupId(n.toString());
        }
        String string = StringUtils.trimToNull((String)is24CsvRecord.getUeberschrift());
        estateImpl.setTitle((String)StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)"Immobilienangebot"), this.getOpenEstateLanguage());
        if (is24CsvRecord.isProvisionspflichtig()) {
            AgentFeeRequired.put((EstateImpl)estateImpl, (Boolean)true);
            AgentFee.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getProvision());
        } else {
            AgentFeeRequired.put((EstateImpl)estateImpl, (Boolean)false);
        }
        AgentFeeInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getProvisionshinweis());
        estateImpl.getAddress().setPublished(is24CsvRecord.isAdressdruck());
        estateImpl.getAddress().setStreet(is24CsvRecord.getObjektStrasse());
        estateImpl.getAddress().setStreetNr(is24CsvRecord.getObjektHausNr());
        estateImpl.getAddress().setPostalCode(is24CsvRecord.getObjektPlz());
        estateImpl.getAddress().setCity(is24CsvRecord.getObjektOrt());
        estateImpl.getAddress().setRegion(is24CsvRecord.getInternationaleRegion());
        estateImpl.getAddress().setCountry(this.getCountry(is24CsvRecord.getObjektLand()));
        FeatureDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getBeschreibungAusstattung());
        DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getBeschreibungObjekt());
        LocationDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getBeschreibungLage());
        AdditionalInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)is24CsvRecord.getBeschreibungSonstiges());
        Object[] objectArray = is24CsvRecord.getDateien();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                EstateAttachmentImpl estateAttachmentImpl = this.createAttachment((Datei)object, is24CsvRecord.getAnbieterObjektId());
                if (estateAttachmentImpl == null) continue;
                estateImpl.getAttachments().add(estateAttachmentImpl);
            }
        }
        if (is24CsvRecord instanceof Anlageobjekt) {
            this.setupEstate(estateImpl, (Anlageobjekt)is24CsvRecord);
        } else if (is24CsvRecord instanceof GewerbeBueroPraxis) {
            this.setupEstate(estateImpl, (GewerbeBueroPraxis)is24CsvRecord);
        } else if (is24CsvRecord instanceof GewerbeEinzelhandel) {
            this.setupEstate(estateImpl, (GewerbeEinzelhandel)is24CsvRecord);
        } else if (is24CsvRecord instanceof GewerbeGastronomieHotel) {
            this.setupEstate(estateImpl, (GewerbeGastronomieHotel)is24CsvRecord);
        } else if (is24CsvRecord instanceof GewerbeHalleProduktion) {
            this.setupEstate(estateImpl, (GewerbeHalleProduktion)is24CsvRecord);
        } else if (is24CsvRecord instanceof GewerbeSonstiges) {
            this.setupEstate(estateImpl, (GewerbeSonstiges)is24CsvRecord);
        } else if (is24CsvRecord instanceof GrundstueckGewerbe) {
            this.setupEstate(estateImpl, (GrundstueckGewerbe)is24CsvRecord);
        } else if (is24CsvRecord instanceof GrundstueckWohnen) {
            this.setupEstate(estateImpl, (GrundstueckWohnen)is24CsvRecord);
        } else if (is24CsvRecord instanceof HausKauf) {
            this.setupEstate(estateImpl, (HausKauf)is24CsvRecord);
        } else if (is24CsvRecord instanceof HausMiete) {
            this.setupEstate(estateImpl, (HausMiete)is24CsvRecord);
        } else if (is24CsvRecord instanceof StellplatzKauf) {
            this.setupEstate(estateImpl, (StellplatzKauf)is24CsvRecord);
        } else if (is24CsvRecord instanceof StellplatzMiete) {
            this.setupEstate(estateImpl, (StellplatzMiete)is24CsvRecord);
        } else if (is24CsvRecord instanceof WohnenAufZeit) {
            this.setupEstate(estateImpl, (WohnenAufZeit)is24CsvRecord);
        } else if (is24CsvRecord instanceof WohnungKauf) {
            this.setupEstate(estateImpl, (WohnungKauf)is24CsvRecord);
        } else if (is24CsvRecord instanceof WohnungMiete) {
            this.setupEstate(estateImpl, (WohnungMiete)is24CsvRecord);
        } else {
            throw new OpenEstateException("Unsupported CSV record: " + is24CsvRecord.getClass().getName());
        }
        return estateImpl;
    }

    protected Is24CsvParser createParser(InputStream inputStream) throws IOException {
        return Is24CsvParser.create((InputStream)inputStream);
    }

    protected Is24CsvParser createParser(Reader reader) throws IOException {
        return Is24CsvParser.create((Reader)reader);
    }

    protected OpenEstateAction getAction(Vermarktungsart vermarktungsart) {
        if (Vermarktungsart.KAUF.equals((Object)vermarktungsart)) {
            return OpenEstateAction.PURCHASE;
        }
        if (Vermarktungsart.MIETE.equals((Object)vermarktungsart)) {
            return OpenEstateAction.RENT;
        }
        if (Vermarktungsart.ERBPACHT.equals((Object)vermarktungsart)) {
            return OpenEstateAction.EMPHYTEUSIS;
        }
        if (Vermarktungsart.PACHT.equals((Object)vermarktungsart)) {
            return OpenEstateAction.LEASE;
        }
        return null;
    }

    protected OpenEstateAction getAction(VermarktungsartGewerbe vermarktungsartGewerbe) {
        if (VermarktungsartGewerbe.KAUF.equals((Object)vermarktungsartGewerbe)) {
            return OpenEstateAction.PURCHASE;
        }
        if (VermarktungsartGewerbe.MIETE.equals((Object)vermarktungsartGewerbe)) {
            return OpenEstateAction.RENT;
        }
        return null;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="A null return value is explicitly required.")
    protected Boolean getBoolean(Auswahl auswahl) {
        if (Auswahl.JA.equals((Object)auswahl)) {
            return true;
        }
        if (Auswahl.NEIN.equals((Object)auswahl)) {
            return false;
        }
        return null;
    }

    protected BuildableAccordingTo.Option getBuildableAccordingTo(BebaubarNach bebaubarNach) {
        if (BebaubarNach.AUSSENGEBIET.equals((Object)bebaubarNach)) {
            return BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT;
        }
        if (BebaubarNach.BEBAUUNGSPLAN.equals((Object)bebaubarNach)) {
            return BuildableAccordingTo.Option.BINDING_SITE_PLAN;
        }
        if (BebaubarNach.NACHBARBEBAUUNG.equals((Object)bebaubarNach)) {
            return BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT;
        }
        return null;
    }

    protected BuildableWith.Option[] getBuildableWith(NutzungGrundstueckGewerbe[] nutzungGrundstueckGewerbeArray) {
        if (ArrayUtils.isEmpty((Object[])nutzungGrundstueckGewerbeArray)) {
            return null;
        }
        ArrayList<BuildableWith.Option> arrayList = new ArrayList<BuildableWith.Option>();
        block23: for (NutzungGrundstueckGewerbe nutzungGrundstueckGewerbe : nutzungGrundstueckGewerbeArray) {
            switch (nutzungGrundstueckGewerbe) {
                case ACKERLAND: {
                    arrayList.add(BuildableWith.Option.FARMLAND);
                    continue block23;
                }
                case BAUERWARTUNGSLAND: {
                    arrayList.add(BuildableWith.Option.DEVELOPMENT_AREA);
                    continue block23;
                }
                case BOOTSSTAENDE: {
                    arrayList.add(BuildableWith.Option.JETTY);
                    continue block23;
                }
                case BUERO: {
                    arrayList.add(BuildableWith.Option.OFFICE);
                    continue block23;
                }
                case CAMPING: {
                    arrayList.add(BuildableWith.Option.CAMPING);
                    continue block23;
                }
                case EINZELHANDEL_GROSS: {
                    arrayList.add(BuildableWith.Option.RETAIL_LARGE);
                    continue block23;
                }
                case EINZELHANDEL_KLEIN: {
                    arrayList.add(BuildableWith.Option.RETAIL_SMALL);
                    continue block23;
                }
                case GARAGEN: {
                    arrayList.add(BuildableWith.Option.GARAGE);
                    continue block23;
                }
                case GARTEN: {
                    arrayList.add(BuildableWith.Option.GARDEN);
                    continue block23;
                }
                case GASTRONOMIE: {
                    arrayList.add(BuildableWith.Option.GASTRONOMY);
                    continue block23;
                }
                case GEWERBE: {
                    arrayList.add(BuildableWith.Option.BUSINESS_BIG);
                    continue block23;
                }
                case HOTEL: {
                    arrayList.add(BuildableWith.Option.HOTEL);
                    continue block23;
                }
                case INDUSTRIE: {
                    arrayList.add(BuildableWith.Option.INDUSTRY);
                    continue block23;
                }
                case KEINE_BEBAUUNG: {
                    arrayList.add(BuildableWith.Option.NO_DEVELOPMENT);
                    continue block23;
                }
                case KLEINGEWERBE: {
                    arrayList.add(BuildableWith.Option.BUSINESS_SMALL);
                    continue block23;
                }
                case LAGER: {
                    arrayList.add(BuildableWith.Option.WAREHOUSE);
                    continue block23;
                }
                case OBSTPFLANZUNG: {
                    arrayList.add(BuildableWith.Option.FRUIT_PLANTING);
                    continue block23;
                }
                case PARKHAUS: {
                    arrayList.add(BuildableWith.Option.PARKING_STRUCTURE);
                    continue block23;
                }
                case PRODUKTION: {
                    arrayList.add(BuildableWith.Option.PRODUCTION);
                    continue block23;
                }
                case STELLPLAETZE: {
                    arrayList.add(BuildableWith.Option.CAR_PARKING_SPACES);
                    continue block23;
                }
                case WALD: {
                    arrayList.add(BuildableWith.Option.FOREST);
                }
            }
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new BuildableWith.Option[0]) : null;
    }

    protected BuildableWith.Option[] getBuildableWith(NutzungGrundstueckWohnen[] nutzungGrundstueckWohnenArray) {
        if (ArrayUtils.isEmpty((Object[])nutzungGrundstueckWohnenArray)) {
            return null;
        }
        ArrayList<BuildableWith.Option> arrayList = new ArrayList<BuildableWith.Option>();
        block14: for (NutzungGrundstueckWohnen nutzungGrundstueckWohnen : nutzungGrundstueckWohnenArray) {
            switch (nutzungGrundstueckWohnen) {
                case BAUERWARTUNGSLAND: {
                    arrayList.add(BuildableWith.Option.DEVELOPMENT_AREA);
                    continue block14;
                }
                case DOPPELHAUSHAELFTE: {
                    arrayList.add(BuildableWith.Option.DUPLEX_HOUSE);
                    continue block14;
                }
                case EINFAMILIENHAUS: {
                    arrayList.add(BuildableWith.Option.SINGLE_FAMILY_HOUSE);
                    continue block14;
                }
                case GARAGEN: {
                    arrayList.add(BuildableWith.Option.GARAGE);
                    continue block14;
                }
                case GARTEN: {
                    arrayList.add(BuildableWith.Option.GARDEN);
                    continue block14;
                }
                case KEINE_BEBAUUNG: {
                    arrayList.add(BuildableWith.Option.NO_DEVELOPMENT);
                    continue block14;
                }
                case MEHRFAMILIENHAUS: {
                    arrayList.add(BuildableWith.Option.MULTI_FAMILY_HOUSE);
                    continue block14;
                }
                case OBSTPFLANZUNG: {
                    arrayList.add(BuildableWith.Option.FRUIT_PLANTING);
                    continue block14;
                }
                case REIHENHAUS: {
                    arrayList.add(BuildableWith.Option.TERRACED_HOUSE);
                    continue block14;
                }
                case STELLPLAETZE: {
                    arrayList.add(BuildableWith.Option.CAR_PARKING_SPACES);
                    continue block14;
                }
                case VILLA: {
                    arrayList.add(BuildableWith.Option.VILLA);
                    continue block14;
                }
                case WALD: {
                    arrayList.add(BuildableWith.Option.FOREST);
                }
            }
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new BuildableWith.Option[0]) : null;
    }

    protected CarParkingType.Option getCarParkingType(Stellplatz stellplatz) {
        if (Stellplatz.JA.equals((Object)stellplatz)) {
            return CarParkingType.Option.GENERAL;
        }
        if (Stellplatz.AUSSEN_STELLPLATZ.equals((Object)stellplatz)) {
            return CarParkingType.Option.OUTDOOR;
        }
        if (Stellplatz.CARPORT.equals((Object)stellplatz)) {
            return CarParkingType.Option.CARPORT;
        }
        if (Stellplatz.GARAGE.equals((Object)stellplatz)) {
            return CarParkingType.Option.GARAGE;
        }
        if (Stellplatz.PARKHAUS.equals((Object)stellplatz)) {
            return CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK;
        }
        if (Stellplatz.TIEFGARAGE.equals((Object)stellplatz)) {
            return CarParkingType.Option.AT_UNDERGROUND_CAR_PARK;
        }
        return null;
    }

    protected CommercialZone.Option getCommercialZone(Lage lage) {
        if (Lage.A_LAGE.equals((Object)lage)) {
            return CommercialZone.Option.LOCATION_A;
        }
        if (Lage.B_LAGE.equals((Object)lage)) {
            return CommercialZone.Option.LOCATION_B;
        }
        if (Lage.EINKAUFSZENTRUM.equals((Object)lage)) {
            return CommercialZone.Option.SHOPPING_CENTER;
        }
        return null;
    }

    protected ConditionType.Option getConditionType(Objektzustand objektzustand) {
        if (Objektzustand.ABBRUCHREIF.equals((Object)objektzustand)) {
            return ConditionType.Option.CONDEMNED;
        }
        if (Objektzustand.ERSTBEZUG.equals((Object)objektzustand)) {
            return ConditionType.Option.FIRST_OCCUPANCY;
        }
        if (Objektzustand.ERSTBEZUG_NACH_SANIERUNG.equals((Object)objektzustand)) {
            return ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT;
        }
        if (Objektzustand.GEPFLEGT.equals((Object)objektzustand)) {
            return ConditionType.Option.WELL_TENDED;
        }
        if (Objektzustand.MODERNISIERT.equals((Object)objektzustand)) {
            return ConditionType.Option.MODERNIZED;
        }
        if (Objektzustand.NACH_VEREINBARUNG.equals((Object)objektzustand)) {
            return ConditionType.Option.AS_APPOINTED;
        }
        if (Objektzustand.NEUWERTIG.equals((Object)objektzustand)) {
            return ConditionType.Option.AS_GOOD_AS_NEW;
        }
        if (Objektzustand.RENOVIERUNGSBEDARF.equals((Object)objektzustand)) {
            return ConditionType.Option.PARTIAL_RENOVATION_REQUIRED;
        }
        if (Objektzustand.SANIERT.equals((Object)objektzustand)) {
            return ConditionType.Option.FULLY_REFURBISHED;
        }
        if (Objektzustand.UNRENOVIERT.equals((Object)objektzustand)) {
            return ConditionType.Option.COMPLETE_RENOVATION_REQUIRED;
        }
        if (Objektzustand.VOLLSTAENDIG_RENOVIERT.equals((Object)objektzustand)) {
            return ConditionType.Option.FULLY_RENOVATED;
        }
        return null;
    }

    protected ConstructionPhase.Option getConstructionPhase(Bauphase bauphase) {
        if (Bauphase.IN_PLANUNG.equals((Object)bauphase)) {
            return ConstructionPhase.Option.PLANNED;
        }
        if (Bauphase.IM_BAU.equals((Object)bauphase)) {
            return ConstructionPhase.Option.UNDER_CONSTRUCTION;
        }
        if (Bauphase.FERTIG_GESTELLT.equals((Object)bauphase)) {
            return ConstructionPhase.Option.COMPLETED;
        }
        return null;
    }

    protected String getCountry(String string) {
        String string2 = Is24CsvFormat.getCountryCode((String)string);
        return string2 != null ? OpenEstateUtils.convertToIso2Country((String)string2) : null;
    }

    protected Development.Option getDevelopment(Erschliessung erschliessung) {
        if (Erschliessung.ERSCHLOSSEN.equals((Object)erschliessung)) {
            return Development.Option.COMPLETELY;
        }
        if (Erschliessung.TEILERSCHLOSSEN.equals((Object)erschliessung)) {
            return Development.Option.PARTIALLY;
        }
        if (Erschliessung.UNERSCHLOSSEN.equals((Object)erschliessung)) {
            return Development.Option.UNDEVELOPED;
        }
        return null;
    }

    protected Equipment.Option getEquipment(Ausstattung ausstattung) {
        if (Ausstattung.EINFACH.equals((Object)ausstattung)) {
            return Equipment.Option.BASIC;
        }
        if (Ausstattung.GEHOBEN.equals((Object)ausstattung)) {
            return Equipment.Option.EXCLUSIVE;
        }
        if (Ausstattung.LUXUS.equals((Object)ausstattung)) {
            return Equipment.Option.LUXURY;
        }
        if (Ausstattung.NORMAL.equals((Object)ausstattung)) {
            return Equipment.Option.STANDARD;
        }
        return null;
    }

    protected FlooringMaterial.Option getFlooringMaterial(Bodenbelag bodenbelag) {
        if (Bodenbelag.BETON.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.CONCRETE;
        }
        if (Bodenbelag.EPOXIDHARZBODEN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.EPOXY_RESIN;
        }
        if (Bodenbelag.FLIESEN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.TILES;
        }
        if (Bodenbelag.LAMINAT.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.LAMINATE;
        }
        if (Bodenbelag.NACH_MIETERWUNSCH.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.AS_REQUESTED;
        }
        if (Bodenbelag.PARKETT.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.PARQUET;
        }
        if (Bodenbelag.PVC.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.PVC;
        }
        if (Bodenbelag.STEIN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.STONE;
        }
        if (Bodenbelag.TEPPICHBODEN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.CARPET;
        }
        if (Bodenbelag.ANTISTATISCHER_TEPPICHBODEN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.CARPET_ANTISTATIC;
        }
        if (Bodenbelag.STUHLROLLENFESTE_TEPPICHFLIESEN.equals((Object)bodenbelag)) {
            return FlooringMaterial.Option.CARPET;
        }
        return null;
    }

    protected Furnished.Option getFurnished(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return Furnished.Option.YES;
        }
        if (Boolean.FALSE.equals(bl)) {
            return Furnished.Option.NO;
        }
        return null;
    }

    protected GenderOfRequestedFlatmates.Option getGenderOfRequestedFlatmates(Geschlecht geschlecht) {
        if (Geschlecht.NUR_FRAUEN.equals((Object)geschlecht)) {
            return GenderOfRequestedFlatmates.Option.FEMALE;
        }
        if (Geschlecht.NUR_MAENNER.equals((Object)geschlecht)) {
            return GenderOfRequestedFlatmates.Option.MALE;
        }
        return null;
    }

    protected NonSmoker.Option getNonSmoker(Rauchen rauchen) {
        if (Rauchen.KEINE_EINSCHRAENKUNG.equals((Object)rauchen)) {
            return NonSmoker.Option.INDIFFERENT;
        }
        if (Rauchen.NUR_NICHTRAUCHER.equals((Object)rauchen)) {
            return NonSmoker.Option.YES;
        }
        return null;
    }

    protected Pets.Option getPets(Auswahl auswahl) {
        if (Auswahl.JA.equals((Object)auswahl)) {
            return Pets.Option.YES;
        }
        if (Auswahl.NEIN.equals((Object)auswahl)) {
            return Pets.Option.NO;
        }
        if (Auswahl.NACH_VEREINBARUNG.equals((Object)auswahl)) {
            return Pets.Option.AS_APPOINTED;
        }
        return null;
    }

    protected RentFlatRatePer.Option getRentFlatRatePer(PauschalmietePro pauschalmietePro) {
        if (PauschalmietePro.TAG.equals((Object)pauschalmietePro)) {
            return RentFlatRatePer.Option.DAY;
        }
        if (PauschalmietePro.WOCHE.equals((Object)pauschalmietePro)) {
            return RentFlatRatePer.Option.WEEK;
        }
        if (PauschalmietePro.MONAT.equals((Object)pauschalmietePro)) {
            return RentFlatRatePer.Option.MONTH;
        }
        return null;
    }

    protected SupplyAccess.Option getSupplyAccess(Zulieferung zulieferung) {
        if (Zulieferung.DIREKT.equals((Object)zulieferung)) {
            return SupplyAccess.Option.DIRECT_ACCESS;
        }
        if (Zulieferung.GANZTAEGIG.equals((Object)zulieferung)) {
            return SupplyAccess.Option.ALL_DAY;
        }
        if (Zulieferung.INDIREKT.equals((Object)zulieferung)) {
            return SupplyAccess.Option.NO_DIRECT_ACCESS;
        }
        if (Zulieferung.PKW.equals((Object)zulieferung)) {
            return SupplyAccess.Option.CAR_ACCESS;
        }
        if (Zulieferung.VON_HINTEN.equals((Object)zulieferung)) {
            return SupplyAccess.Option.FROM_BACK_SIDE;
        }
        if (Zulieferung.VON_VORN.equals((Object)zulieferung)) {
            return SupplyAccess.Option.FROM_FRONT_SIDE;
        }
        if (Zulieferung.VORMITTAGS.equals((Object)zulieferung)) {
            return SupplyAccess.Option.MORNING;
        }
        return null;
    }

    protected OpenEstateType getType(ObjektkategorieAnlageobjekt objektkategorieAnlageobjekt) {
        if (objektkategorieAnlageobjekt == null) {
            objektkategorieAnlageobjekt = ObjektkategorieAnlageobjekt.SONSTIGES;
        }
        switch (objektkategorieAnlageobjekt) {
            case BUEROGEBAEUDE: {
                return OpenEstateType.OFFICE_BUILDING;
            }
            case EINFAMILIENHAUS: {
                return OpenEstateType.SINGLE_FAMILY_HOUSE;
            }
            case EIGENTUMSWOHNUNG: {
                return OpenEstateType.RESIDENCE;
            }
            case EINKAUFSZENTRUM: {
                return OpenEstateType.SHOPPING_CENTER;
            }
            case FREIZEITANLAGE: {
                return OpenEstateType.LEISURE_SPORTS_FACILITY;
            }
            case GAESCHAEFTSHAUS: {
                return OpenEstateType.COMMERCIAL_BUILDING;
            }
            case GASTSTAETTE: {
                return OpenEstateType.GASTRONOMY;
            }
            case GEWERBEANWESEN: {
                return OpenEstateType.COMMERCIAL_CENTER;
            }
            case GEWERBEEINHEIT: {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            case HALLE_LAGER: {
                return OpenEstateType.HALL_WAREHOUSE;
            }
            case HOTEL: {
                return OpenEstateType.HOTEL;
            }
            case INDUSTRIEANWESEN: {
                return OpenEstateType.INDUSTRIAL_FACILITY;
            }
            case LADEN_VERKAUFSFLAECHE: {
                return OpenEstateType.SALES_AREA;
            }
            case MEHRFAMILIENHAUS: {
                return OpenEstateType.MULTI_FAMILY_HOUSE;
            }
            case SERVICECENTER: {
                return OpenEstateType.SERVICE_CENTER;
            }
            case SONSTIGES: {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            case SUPERMARKT: {
                return OpenEstateType.CONSUMER_STORE;
            }
            case WOHNANLAGE: {
                return OpenEstateType.HOUSING_COMPLEX;
            }
            case WOHN_GESCHAEFTSHAUS: {
                return OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING;
            }
        }
        return OpenEstateType.GENERAL_COMMERCIAL;
    }

    protected OpenEstateType getType(ObjektkategorieGewerbeBueroPraxen objektkategorieGewerbeBueroPraxen) {
        if (objektkategorieGewerbeBueroPraxen == null) {
            objektkategorieGewerbeBueroPraxen = ObjektkategorieGewerbeBueroPraxen.KEINE_ANGABE;
        }
        switch (objektkategorieGewerbeBueroPraxen) {
            case ATELIER: {
                return OpenEstateType.ATELIER;
            }
            case BUERO: {
                return OpenEstateType.OFFICE;
            }
            case BUEROETAGE: {
                return OpenEstateType.OFFICE_FLOOR;
            }
            case BUEROHAUS: {
                return OpenEstateType.OFFICE_BUILDING;
            }
            case BUEROZENTRUM: {
                return OpenEstateType.OFFICE_CENTER;
            }
            case BUERO_GESCHAEFTSGEBAEUDE: {
                return OpenEstateType.OFFICE_COMMERCIAL_BUILDING;
            }
            case BUERO_UND_LAGERGEBAEUDE: {
                return OpenEstateType.OFFICE_COMMERCIAL_BUILDING;
            }
            case GEWERBEZENTRUM: {
                return OpenEstateType.COMMERCIAL_CENTER;
            }
            case LOFT: {
                return OpenEstateType.LOFT;
            }
            case PRAXIS: {
                return OpenEstateType.SURGERY;
            }
            case PRAXISETAGE: {
                return OpenEstateType.SURGERY_FLOOR;
            }
            case PRAXISHAUS: {
                return OpenEstateType.DOCTORS_OFFICE_HOUSE;
            }
            case WOHN_GESCHAEFTSGEBAEUDE: {
                return OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING;
            }
        }
        return OpenEstateType.OFFICE_SURGERY;
    }

    protected OpenEstateType getType(ObjektkategorieGewerbeEinzelhandel objektkategorieGewerbeEinzelhandel) {
        if (objektkategorieGewerbeEinzelhandel == null) {
            objektkategorieGewerbeEinzelhandel = ObjektkategorieGewerbeEinzelhandel.KEINE_ANGABE;
        }
        switch (objektkategorieGewerbeEinzelhandel) {
            case AUSSTELLUNGSFLAECHE: {
                return OpenEstateType.EXHIBITION_AREA;
            }
            case EINKAUFSZENTRUM: {
                return OpenEstateType.SHOPPING_CENTER;
            }
            case FACTORY_OUTLET: {
                return OpenEstateType.RETAIL;
            }
            case KAUFHAUS: {
                return OpenEstateType.DEPARTMENT_STORE;
            }
            case KIOSK: {
                return OpenEstateType.KIOSK;
            }
            case LADEN: {
                return OpenEstateType.SHOP;
            }
            case SB_MARKT: {
                return OpenEstateType.SELF_SERVICE_MARKET;
            }
            case VERKAUFSFLAECHE: {
                return OpenEstateType.SALES_AREA;
            }
            case VERKAUFSHALLE: {
                return OpenEstateType.SHOWROOM;
            }
        }
        return OpenEstateType.RETAIL;
    }

    protected OpenEstateType getType(ObjektkategorieGewerbeGastronomieHotel objektkategorieGewerbeGastronomieHotel) {
        if (objektkategorieGewerbeGastronomieHotel == null) {
            return OpenEstateType.HOSPITALITY_INDUSTRY;
        }
        switch (objektkategorieGewerbeGastronomieHotel) {
            case BAR_LOUNGE: {
                return OpenEstateType.RESTAURANT_BAR;
            }
            case CAFE: {
                return OpenEstateType.BISTRO_CAFE;
            }
            case CLUB_DISCO: {
                return OpenEstateType.DISCOTHEQUE;
            }
            case FERIENBUNGALOW: {
                return OpenEstateType.COTTAGE;
            }
            case GAESTEHAUS: {
                return OpenEstateType.HOSPITALITY_INDUSTRY;
            }
            case GASTSTAETTE: {
                return OpenEstateType.GASTRONOMY;
            }
            case HOTEL: {
                return OpenEstateType.HOTEL;
            }
            case HOTELANWESEN: {
                return OpenEstateType.HOTEL;
            }
            case HOTEL_GARNI: {
                return OpenEstateType.HOTEL;
            }
            case PENSION: {
                return OpenEstateType.GUESTHOUSE;
            }
            case RESTAURANT: {
                return OpenEstateType.RESTAURANT;
            }
        }
        return OpenEstateType.HOSPITALITY_INDUSTRY;
    }

    protected OpenEstateType getType(ObjektkategorieGewerbeHalleProduktion objektkategorieGewerbeHalleProduktion) {
        if (objektkategorieGewerbeHalleProduktion == null) {
            objektkategorieGewerbeHalleProduktion = ObjektkategorieGewerbeHalleProduktion.KEINE_ANGABE;
        }
        switch (objektkategorieGewerbeHalleProduktion) {
            case AUSSTELLUNGSFLAECHE: {
                return OpenEstateType.EXHIBITION_AREA;
            }
            case HALLE: {
                return OpenEstateType.HALL_WAREHOUSE;
            }
            case HOCHREGALLAGER: {
                return OpenEstateType.HIGH_RACK_WAREHOUSE;
            }
            case INDUSTRIEHALLE: {
                return OpenEstateType.INDUSTRIAL_WAREHOUSE;
            }
            case INDUSTRIEHALLE_MIT_FREIFLAECHE: {
                return OpenEstateType.INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE;
            }
            case KUEHLHAUS: {
                return OpenEstateType.COOLING_HOUSE;
            }
            case KUEHLREGALLAGER: {
                return OpenEstateType.COLD_STORAGE_WAREHOUSE;
            }
            case LAGERFLAECHE: {
                return OpenEstateType.STORAGE_AREA;
            }
            case LAGERHALLE: {
                return OpenEstateType.WAREHOUSE;
            }
            case LAGER_MIT_FREIFLAECHE: {
                return OpenEstateType.WAREHOUSE;
            }
            case SERVICEFLAECHE: {
                return OpenEstateType.SERVICE_AREA;
            }
            case SPEDITIONSLAGER: {
                return OpenEstateType.FORWARDING_WAREHOUSE;
            }
            case WERKSTATT: {
                return OpenEstateType.WORKSHOP;
            }
        }
        return OpenEstateType.HALL_WAREHOUSE;
    }

    protected OpenEstateType getType(ObjektkategorieGewerbeSonstiges objektkategorieGewerbeSonstiges) {
        if (objektkategorieGewerbeSonstiges == null) {
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        switch (objektkategorieGewerbeSonstiges) {
            case ANWESEN: {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            case BAUERNHOF: {
                return OpenEstateType.FARM;
            }
            case FREIZEITANLAGE: {
                return OpenEstateType.LEISURE_SPORTS_FACILITY;
            }
            case GEWERBEFLAECHE: {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            case GEWERBEPARK: {
                return OpenEstateType.COMMERCIAL_CENTER;
            }
            case REITERHOF: {
                return OpenEstateType.RIDING_ESTATE;
            }
            case SPEZIALOBJEKT: {
                return OpenEstateType.GENERAL_COMMERCIAL;
            }
            case WEINGUT: {
                return OpenEstateType.VINICULTURE;
            }
            case WERKSTATT: {
                return OpenEstateType.WORKSHOP;
            }
        }
        return OpenEstateType.GENERAL_COMMERCIAL;
    }

    protected OpenEstateType getType(ObjektkategorieGrundstueck objektkategorieGrundstueck) {
        if (objektkategorieGrundstueck == null) {
            return OpenEstateType.GENERAL_PIECE_OF_LAND;
        }
        switch (objektkategorieGrundstueck) {
            case GEWERBE: {
                return OpenEstateType.COMMERCIAL_GROUND;
            }
            case GEWERBE_FREIZEIT: {
                return OpenEstateType.LEISURE_GROUND;
            }
            case GEWERBE_LAND_FORSTWIRTSCHAFT: {
                return OpenEstateType.AGRICULTURAL_FORESTRY_GROUND;
            }
            case WOHNEN: {
                return OpenEstateType.RESIDENTIAL_GROUND;
            }
        }
        return OpenEstateType.GENERAL_PIECE_OF_LAND;
    }

    protected OpenEstateType getType(ObjektkategorieHaus objektkategorieHaus) {
        if (objektkategorieHaus == null) {
            objektkategorieHaus = ObjektkategorieHaus.SONSTIGE_WOHNIMMOBILIE;
        }
        switch (objektkategorieHaus) {
            case BAUERNHAUS: {
                return OpenEstateType.FARMHOUSE;
            }
            case BESONDERE_IMMOBILIE: {
                return OpenEstateType.SPECIAL_HOUSE;
            }
            case BUNGALOW: {
                return OpenEstateType.BUNGALOW;
            }
            case BURG_SCHLOSS: {
                return OpenEstateType.CASTLE;
            }
            case DOPPELHAUSHAELFTE: {
                return OpenEstateType.SEMIDETACHED_HOUSE;
            }
            case EINFAMILIENHAUS: {
                return OpenEstateType.SINGLE_FAMILY_HOUSE;
            }
            case MEHRFAMILIENHAUS: {
                return OpenEstateType.MULTI_FAMILY_HOUSE;
            }
            case REIHENECKHAUS: {
                return OpenEstateType.TERRACED_HOUSE_CORNERSIDE;
            }
            case REIHENHAUS: {
                return OpenEstateType.TERRACED_HOUSE;
            }
            case REIHENMITTELHAUS: {
                return OpenEstateType.TERRACED_HOUSE_MIDDLE;
            }
            case SONSTIGE_WOHNIMMOBILIE: {
                return OpenEstateType.HOUSE;
            }
            case SONSTIGES: {
                return OpenEstateType.HOUSE;
            }
            case VILLA: {
                return OpenEstateType.VILLA;
            }
            case ZWEIFAMILIENHAUS: {
                return OpenEstateType.TWO_FAMILY_HOUSE;
            }
        }
        return OpenEstateType.HOUSE;
    }

    protected OpenEstateType getType(ObjektkategorieStellplatz objektkategorieStellplatz) {
        if (objektkategorieStellplatz == null) {
            objektkategorieStellplatz = ObjektkategorieStellplatz.KEINE_ANGABE;
        }
        switch (objektkategorieStellplatz) {
            case AUSSENSTELLPLATZ: {
                return OpenEstateType.OUTDOOR_CAR_PARKING_SPACE;
            }
            case CARPORT: {
                return OpenEstateType.CARPORT;
            }
            case DUPLEX: {
                return OpenEstateType.DUPLEX_GARAGE;
            }
            case GARAGE: {
                return OpenEstateType.GARAGE;
            }
            case PARKHAUS: {
                return OpenEstateType.CAR_PARK_UNIT;
            }
            case TIEFGARAGE: {
                return OpenEstateType.UNDERGROUND_CAR_PARK_UNIT;
            }
        }
        return OpenEstateType.GENERAL_PARKING;
    }

    protected OpenEstateType getType(ObjektkategorieWohnenAufZeit objektkategorieWohnenAufZeit) {
        if (objektkategorieWohnenAufZeit == null) {
            objektkategorieWohnenAufZeit = ObjektkategorieWohnenAufZeit.WOHNUNG;
        }
        switch (objektkategorieWohnenAufZeit) {
            case APPARTMENT: {
                return OpenEstateType.APARTMENT;
            }
            case HAUS: {
                return OpenEstateType.HOUSE;
            }
            case WOHNUNG: {
                return OpenEstateType.RESIDENCE;
            }
            case ZIMMER: {
                return OpenEstateType.ROOM;
            }
        }
        return OpenEstateType.RESIDENCE;
    }

    protected OpenEstateType getType(ObjektkategorieWohnung objektkategorieWohnung) {
        if (objektkategorieWohnung == null) {
            objektkategorieWohnung = ObjektkategorieWohnung.KEINE_ANGABE;
        }
        switch (objektkategorieWohnung) {
            case DACHGESCHOSS: {
                return OpenEstateType.ATTIC_APARTMENT;
            }
            case ERDGESCHOSS: {
                return OpenEstateType.GROUND_FLOOR_APARTMENT;
            }
            case ETAGE: {
                return OpenEstateType.HIGHER_FLOOR_APARTMENT;
            }
            case HOCHPARTERRE: {
                return OpenEstateType.MEZZANINE;
            }
            case LOFT: {
                return OpenEstateType.LOFT;
            }
            case MAISONETTE: {
                return OpenEstateType.MAISONETTE;
            }
            case PENTHOUSE: {
                return OpenEstateType.PENTHOUSE_APARTMENT;
            }
            case SONSTIGE: {
                return OpenEstateType.RESIDENCE;
            }
            case SOUTERRAIN: {
                return OpenEstateType.SOUTERRAIN_APARTMENT;
            }
            case TERRASSE: {
                return OpenEstateType.TERRACE_APARTMENT;
            }
        }
        return OpenEstateType.RESIDENCE;
    }

    protected TypeOfBeaconing.Option[] getTypeOfBeaconing(Befeuerungsart[] befeuerungsartArray) {
        if (ArrayUtils.isEmpty((Object[])befeuerungsartArray)) {
            return null;
        }
        ArrayList<TypeOfBeaconing.Option> arrayList = new ArrayList<TypeOfBeaconing.Option>();
        for (Befeuerungsart befeuerungsart : befeuerungsartArray) {
            if (Befeuerungsart.ERDWAERME.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.GEOTHERMICS);
                continue;
            }
            if (Befeuerungsart.FERNWAERME.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.DISTRICT_HEATING);
                continue;
            }
            if (Befeuerungsart.GAS.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.GAS);
                continue;
            }
            if (Befeuerungsart.KOHLE.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.COAL);
                continue;
            }
            if (Befeuerungsart.OEL.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.OIL);
                continue;
            }
            if (Befeuerungsart.PELLETHEIZUNG.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.PELLETS);
                continue;
            }
            if (Befeuerungsart.SOLARHEIZUNG.equals((Object)befeuerungsart)) {
                arrayList.add(TypeOfBeaconing.Option.SOLAR);
                continue;
            }
            if (!Befeuerungsart.STROM.equals((Object)befeuerungsart)) continue;
            arrayList.add(TypeOfBeaconing.Option.ELECTRICS);
        }
        return !arrayList.isEmpty() ? arrayList.toArray(new TypeOfBeaconing.Option[0]) : null;
    }

    protected TypeOfHeating.Option getTypeOfHeating(Heizungsart heizungsart) {
        if (Heizungsart.ETAGENHEIZUNG.equals((Object)heizungsart)) {
            return TypeOfHeating.Option.SELF_CONTAINED_CENTRAL;
        }
        if (Heizungsart.OFENHEIZUNG.equals((Object)heizungsart)) {
            return TypeOfHeating.Option.OVEN;
        }
        if (Heizungsart.ZENTRALHEIZUNG.equals((Object)heizungsart)) {
            return TypeOfHeating.Option.CENTRAL;
        }
        return null;
    }

    protected TypeOfHeating.Option getTypeOfHeating(HeizungsartWohnenAufZeit heizungsartWohnenAufZeit) {
        if (HeizungsartWohnenAufZeit.ETAGENHEIZUNG.equals((Object)heizungsartWohnenAufZeit)) {
            return TypeOfHeating.Option.SELF_CONTAINED_CENTRAL;
        }
        if (HeizungsartWohnenAufZeit.OFENHEIZUNG.equals((Object)heizungsartWohnenAufZeit)) {
            return TypeOfHeating.Option.OVEN;
        }
        if (HeizungsartWohnenAufZeit.ZENTRALHEIZUNG.equals((Object)heizungsartWohnenAufZeit)) {
            return TypeOfHeating.Option.CENTRAL;
        }
        return null;
    }

    protected UndergroundLevel.Option getUndergroundLevel(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return UndergroundLevel.Option.YES;
        }
        if (Boolean.FALSE.equals(bl)) {
            return UndergroundLevel.Option.NO;
        }
        return null;
    }

    protected void initRecord(Is24CsvRecord is24CsvRecord) {
    }

    protected AgencyImpl readAgency(Is24CsvParser is24CsvParser) {
        this.getErrorMap().clear();
        AgencyImpl agencyImpl = this.createEmptyAgency();
        boolean bl = true;
        while (is24CsvParser.hasNext()) {
            Is24CsvRecord is24CsvRecord = (Is24CsvRecord)is24CsvParser.next();
            this.initRecord(is24CsvRecord);
            try {
                if (bl) {
                    bl = false;
                    agencyImpl.setAgent(this.createAgent(is24CsvRecord));
                }
                AgentContactImpl agentContactImpl = this.createContact(is24CsvRecord);
                agentContactImpl.setId("NewContact." + (agencyImpl.getContacts().size() + 1));
                EstateImpl estateImpl = this.createEstate(is24CsvRecord);
                estateImpl.setId("NewEstate." + (agencyImpl.getEstates().size() + 1));
                estateImpl.setContactId(agentContactImpl.getId());
                agencyImpl.getContacts().put(agentContactImpl.getId(), agentContactImpl);
                agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
            }
            catch (Exception exception) {
                LOGGER.error("Can't read line " + is24CsvParser.getCurrentLineNumber() + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return agencyImpl;
    }

    protected TransferImpl readTransfer(Is24CsvParser is24CsvParser) {
        this.getErrorMap().clear();
        TransferImpl transferImpl = this.createEmptyTransfer();
        TransferAgencyImpl transferAgencyImpl = null;
        while (is24CsvParser.hasNext()) {
            Is24CsvRecord is24CsvRecord = (Is24CsvRecord)is24CsvParser.next();
            this.initRecord(is24CsvRecord);
            try {
                String string;
                Importmodus importmodus = is24CsvRecord.getImportmodus();
                if (Importmodus.IGNORIEREN.equals((Object)importmodus)) continue;
                if (transferAgencyImpl == null || !StringUtils.trimToEmpty((String)transferAgencyImpl.getAgent().getId()).equalsIgnoreCase(StringUtils.trimToEmpty((String)is24CsvRecord.getScoutKundenId()))) {
                    transferAgencyImpl = this.createEmptyTransferAgency();
                    transferAgencyImpl.setAgent(this.createAgent(is24CsvRecord));
                    transferImpl.getAgencies().add(transferAgencyImpl);
                }
                if (Importmodus.LOESCHEN.equals((Object)importmodus)) {
                    string = is24CsvRecord.getAnbieterObjektId();
                    if (string == null) continue;
                    transferAgencyImpl.getEstateIdsToRemove().add(string);
                    continue;
                }
                string = this.createContact(is24CsvRecord);
                string.setId("NewContact." + (transferAgencyImpl.getContacts().size() + 1));
                EstateImpl estateImpl = this.createEstate(is24CsvRecord);
                if (estateImpl == null) continue;
                estateImpl.setId("NewEstate." + (transferAgencyImpl.getEstatesToSave().size() + 1));
                estateImpl.setContactId(string.getId());
                transferAgencyImpl.getContacts().put(string.getId(), string);
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            catch (Exception exception) {
                LOGGER.error("Can't read line " + is24CsvParser.getCurrentLineNumber() + "!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return transferImpl;
    }

    protected void setupEnergiepass(EstateImpl estateImpl, EnergieausweisTyp energieausweisTyp, BigDecimal bigDecimal, Boolean bl) {
        boolean bl2 = false;
        if (bigDecimal != null && EnergieausweisTyp.ENDENERGIEBEDARF.equals((Object)energieausweisTyp)) {
            bl2 = true;
            Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.DEMAND);
            DemandTotal.put((EstateImpl)estateImpl, (Number)bigDecimal, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
        } else if (bigDecimal != null && EnergieausweisTyp.ENERGIEVERBRAUCHSKENNWERT.equals((Object)energieausweisTyp)) {
            bl2 = true;
            Type.put((EstateImpl)estateImpl, (Type.Option)Type.Option.CONSUMPTION);
            ConsumptionTotal.put((EstateImpl)estateImpl, (Number)bigDecimal, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
            ConsumptionIncludingHotWater.put((EstateImpl)estateImpl, (Boolean)bl);
        }
        Available.put((EstateImpl)estateImpl, (Boolean)bl2);
        if (bl2 && estateImpl.getAddress() != null) {
            EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)OpenEstateUtils.getEnergyEfficiencyCategory((Number)bigDecimal, (String)estateImpl.getAddress().getCountry()));
        }
    }

    protected void setupEstate(EstateImpl estateImpl, Anlageobjekt anlageobjekt) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(anlageobjekt.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)anlageobjekt.getAnzahlParkflaechen());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(anlageobjekt.getAusstattung()));
        BuildYear.put((EstateImpl)estateImpl, (Number)anlageobjekt.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(anlageobjekt.getBefeuerungsart()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)anlageobjekt.getDenkmalschutz());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(anlageobjekt.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(anlageobjekt.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(anlageobjekt.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(anlageobjekt.getFusswegNahverkehr()));
        TotalArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(anlageobjekt.getHeizungsart()));
        PurchasePrice.put((EstateImpl)estateImpl, (Number)anlageobjekt.getKaufpreis());
        PurchasePricePerArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getKaufpreisProQm());
        RentalIncomeActualPerAnnum.put((EstateImpl)estateImpl, (Number)anlageobjekt.getMieteinnahmenIst());
        RentalIncomeDebitPerAnnum.put((EstateImpl)estateImpl, (Number)anlageobjekt.getMieteinnahmenSoll());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(anlageobjekt.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)anlageobjekt.getPersonenaufzug());
        CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)anlageobjekt.getPreisProParkflaeche());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)anlageobjekt.getSanierungsjahr());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)anlageobjekt.getSonstigeFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RentableArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getVermietbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)anlageobjekt.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PurchasePriceOnAnnualRentalIncome.put((EstateImpl)estateImpl, (Number)anlageobjekt.getXFache());
        this.setupEnergiepass(estateImpl, anlageobjekt.getEnergieausweisTyp(), anlageobjekt.getEnergieausweisKennwert(), anlageobjekt.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)anlageobjekt.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + anlageobjekt.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(anlageobjekt.getAnbieterObjektId(), "Can't read number of floors '" + anlageobjekt.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GewerbeBueroPraxis gewerbeBueroPraxis) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(gewerbeBueroPraxis.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(gewerbeBueroPraxis.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getAnzahlParkflaechen());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(gewerbeBueroPraxis.getAusstattung()));
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)gewerbeBueroPraxis.getBarrierefrei());
        BuildYear.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(gewerbeBueroPraxis.getBefeuerungsart()));
        FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)this.getFlooringMaterial(gewerbeBueroPraxis.getBodenbelag()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)gewerbeBueroPraxis.getDenkmalschutz());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeBueroPraxis.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeBueroPraxis.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeBueroPraxis.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(gewerbeBueroPraxis.getFusswegNahverkehr()));
        TotalArea.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(gewerbeBueroPraxis.getHeizungsart()));
        CanteenCafeteria.put((EstateImpl)estateImpl, (Boolean)gewerbeBueroPraxis.getKantineCafeteria());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeBueroPraxis.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(gewerbeBueroPraxis.getKeller()));
        AirConditioned.put((EstateImpl)estateImpl, (Boolean)this.getBoolean(gewerbeBueroPraxis.getKlimaanlage()));
        RemainingAreas.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(gewerbeBueroPraxis.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)gewerbeBueroPraxis.getPersonenaufzug());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getSanierungsjahr());
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeBueroPraxis.getVerfuegbarAb());
        if (Boolean.TRUE.equals(this.getBoolean(gewerbeBueroPraxis.getDvVerkabelung()))) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        }
        this.setupEnergiepass(estateImpl, gewerbeBueroPraxis.getEnergieausweisTyp(), gewerbeBueroPraxis.getEnergieausweisKennwert(), gewerbeBueroPraxis.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)gewerbeBueroPraxis.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + gewerbeBueroPraxis.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(gewerbeBueroPraxis.getAnbieterObjektId(), "Can't read number of floors '" + gewerbeBueroPraxis.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
        if (Boolean.TRUE.equals(gewerbeBueroPraxis.getKueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            KaltmietePro kaltmietePro = gewerbeBueroPraxis.getKaltmietePro();
            if (KaltmietePro.QUADRATMETER.equals((Object)kaltmietePro)) {
                RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getKaltmiete());
            } else {
                RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getKaltmiete());
            }
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getPreisProParkflaeche());
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getKaufpreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)gewerbeBueroPraxis.getPreisProParkflaeche());
        }
        if (Boolean.TRUE.equals(gewerbeBueroPraxis.getStarkstrom())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.HIGH_VOLTAGE_CURRENT);
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GewerbeEinzelhandel gewerbeEinzelhandel) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(gewerbeEinzelhandel.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(gewerbeEinzelhandel.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getAnzahlParkflaechen());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(gewerbeEinzelhandel.getAusstattung()));
        BuildYear.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(gewerbeEinzelhandel.getBefeuerungsart()));
        FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)this.getFlooringMaterial(gewerbeEinzelhandel.getBodenbelag()));
        CeilingLoad.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getDeckenlast());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)gewerbeEinzelhandel.getDenkmalschutz());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeEinzelhandel.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeEinzelhandel.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeEinzelhandel.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(gewerbeEinzelhandel.getFusswegNahverkehr()));
        TotalArea.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(gewerbeEinzelhandel.getHeizungsart()));
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeEinzelhandel.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(gewerbeEinzelhandel.getKeller()));
        CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)this.getCommercialZone(gewerbeEinzelhandel.getLage()));
        FreightElevator.put((EstateImpl)estateImpl, (Boolean)gewerbeEinzelhandel.getLastenaufzug());
        FreightElevatorCapacity.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getLastenaufzugTragkraft());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(gewerbeEinzelhandel.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)gewerbeEinzelhandel.getPersonenaufzug());
        Ramp.put((EstateImpl)estateImpl, (Boolean)gewerbeEinzelhandel.getRampe());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getSanierungsjahr());
        FrontWindowArea.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getSchaufensterfront(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeEinzelhandel.getVerfuegbarAb());
        SupplyAccess.putOption((EstateImpl)estateImpl, (SupplyAccess.Option)this.getSupplyAccess(gewerbeEinzelhandel.getZulieferung()));
        this.setupEnergiepass(estateImpl, gewerbeEinzelhandel.getEnergieausweisTyp(), gewerbeEinzelhandel.getEnergieausweisKennwert(), gewerbeEinzelhandel.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)gewerbeEinzelhandel.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + gewerbeEinzelhandel.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(gewerbeEinzelhandel.getAnbieterObjektId(), "Can't read number of floors '" + gewerbeEinzelhandel.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            KaltmietePro kaltmietePro = gewerbeEinzelhandel.getKaltmietePro();
            if (KaltmietePro.QUADRATMETER.equals((Object)kaltmietePro)) {
                RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getKaltmiete());
            } else {
                RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getKaltmiete());
            }
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getPreisProParkflaeche());
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getKaufpreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)gewerbeEinzelhandel.getPreisProParkflaeche());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GewerbeGastronomieHotel gewerbeGastronomieHotel) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(gewerbeGastronomieHotel.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(gewerbeGastronomieHotel.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountBeds.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getAnzahlBetten());
        CountGuestrooms.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getAnzahlGastraumplaetze());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getAnzahlParkflaechen());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(gewerbeGastronomieHotel.getAusstattung()));
        BuildYear.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(gewerbeGastronomieHotel.getBefeuerungsart()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)gewerbeGastronomieHotel.getDenkmalschutz());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeGastronomieHotel.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeGastronomieHotel.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeGastronomieHotel.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(gewerbeGastronomieHotel.getFusswegNahverkehr()));
        GuestTerrace.put((EstateImpl)estateImpl, (Boolean)gewerbeGastronomieHotel.getGastterrasse());
        TotalArea.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(gewerbeGastronomieHotel.getHeizungsart()));
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeGastronomieHotel.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(gewerbeGastronomieHotel.getKeller()));
        RemainingAreas.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(gewerbeGastronomieHotel.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)gewerbeGastronomieHotel.getPersonenaufzug());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getSanierungsjahr());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeGastronomieHotel.getVerfuegbarAb());
        this.setupEnergiepass(estateImpl, gewerbeGastronomieHotel.getEnergieausweisTyp(), gewerbeGastronomieHotel.getEnergieausweisKennwert(), gewerbeGastronomieHotel.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)gewerbeGastronomieHotel.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + gewerbeGastronomieHotel.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(gewerbeGastronomieHotel.getAnbieterObjektId(), "Can't read number of floors '" + gewerbeGastronomieHotel.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getPreis());
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getPreisProParkflaeche());
        } else {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getPreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)gewerbeGastronomieHotel.getPreisProParkflaeche());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GewerbeHalleProduktion gewerbeHalleProduktion) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(gewerbeHalleProduktion.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(gewerbeHalleProduktion.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getAnzahlParkflaechen());
        BuildYear.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(gewerbeHalleProduktion.getBefeuerungsart()));
        FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)this.getFlooringMaterial(gewerbeHalleProduktion.getBodenbelag()));
        FloorLoading.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getBodenbelastung());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeHalleProduktion.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeHalleProduktion.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeHalleProduktion.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(gewerbeHalleProduktion.getFusswegNahverkehr()));
        TotalArea.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        WarehouseHeight.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getHallenhoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        LiftingPlatform.put((EstateImpl)estateImpl, (Boolean)gewerbeHalleProduktion.getHebebuehne());
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(gewerbeHalleProduktion.getHeizungsart()));
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeHalleProduktion.getKaution());
        Crane.put((EstateImpl)estateImpl, (Boolean)gewerbeHalleProduktion.getKranbahn());
        CraneLiftingCapacity.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getKranbahnTragkraft());
        FreightElevator.put((EstateImpl)estateImpl, (Boolean)gewerbeHalleProduktion.getLastenaufzug());
        FreightElevatorCapacity.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getLastenaufzugTragkraft());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(gewerbeHalleProduktion.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)gewerbeHalleProduktion.getPersonenaufzug());
        Ramp.put((EstateImpl)estateImpl, (Boolean)gewerbeHalleProduktion.getRampe());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getSanierungsjahr());
        ElectricalConnectionValue.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getStromanschlusswert());
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeHalleProduktion.getVerfuegbarAb());
        this.setupEnergiepass(estateImpl, gewerbeHalleProduktion.getEnergieausweisTyp(), gewerbeHalleProduktion.getEnergieausweisKennwert(), gewerbeHalleProduktion.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)gewerbeHalleProduktion.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + gewerbeHalleProduktion.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(gewerbeHalleProduktion.getAnbieterObjektId(), "Can't read number of floors '" + gewerbeHalleProduktion.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            KaltmietePro kaltmietePro = gewerbeHalleProduktion.getKaltmietePro();
            if (KaltmietePro.QUADRATMETER.equals((Object)kaltmietePro)) {
                RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getKaltmiete());
            } else {
                RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getKaltmiete());
            }
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getPreisProParkflaeche());
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getKaufpreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)gewerbeHalleProduktion.getPreisProParkflaeche());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GewerbeSonstiges gewerbeSonstiges) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(gewerbeSonstiges.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(gewerbeSonstiges.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getAnzahlParkflaechen());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(gewerbeSonstiges.getAusstattung()));
        BuildYear.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(gewerbeSonstiges.getBefeuerungsart()));
        FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)this.getFlooringMaterial(gewerbeSonstiges.getBodenbelag()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)gewerbeSonstiges.getDenkmalschutz());
        DistanceToMotorway.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeSonstiges.getFahrtwegAutobahn()));
        DistanceToMainLineStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeSonstiges.getFahrtwegHauptbahnhof()));
        DistanceToAirport.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFahrtwegDistanz(gewerbeSonstiges.getFahrtwegFlughafen()));
        DistanceToBusStation.put((EstateImpl)estateImpl, (LengthValue)Is24Utils.getFusswegDistanz(gewerbeSonstiges.getFusswegNahverkehr()));
        TotalArea.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CommercialArea.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getGewerbeflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotArea.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(gewerbeSonstiges.getHeizungsart()));
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeSonstiges.getKaution());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getNebenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(gewerbeSonstiges.getObjektzustand()));
        Lift.put((EstateImpl)estateImpl, (Boolean)gewerbeSonstiges.getPersonenaufzug());
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getSanierungsjahr());
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)gewerbeSonstiges.getVerfuegbarAb());
        this.setupEnergiepass(estateImpl, gewerbeSonstiges.getEnergieausweisTyp(), gewerbeSonstiges.getEnergieausweisKennwert(), gewerbeSonstiges.getEnergieausweisInklWarmwasser());
        try {
            CountFloors.put((EstateImpl)estateImpl, (Number)NumberUtils.createDouble((String)gewerbeSonstiges.getEtagen()));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors '" + gewerbeSonstiges.getEtagen() + "' as numeric value!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            this.putError(gewerbeSonstiges.getAnbieterObjektId(), "Can't read number of floors '" + gewerbeSonstiges.getEtagen() + "' as numeric value! " + numberFormatException.getLocalizedMessage());
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getPreis());
            CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getPreisProParkflaeche());
        } else {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getPreis());
            CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)gewerbeSonstiges.getPreisProParkflaeche());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GrundstueckGewerbe grundstueckGewerbe) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(grundstueckGewerbe.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(grundstueckGewerbe.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        DemolitionRequired.put((EstateImpl)estateImpl, (Boolean)grundstueckGewerbe.getAbrissErforderlich());
        BuildingPermissionAvailable.put((EstateImpl)estateImpl, (Boolean)grundstueckGewerbe.getBaugenehmigungVorhanden());
        BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)this.getBuildableAccordingTo(grundstueckGewerbe.getBebaubarNach()));
        BuildableWith.put((EstateImpl)estateImpl, (BuildableWith.Option[])this.getBuildableWith(grundstueckGewerbe.getEmpfohleneNutzung()));
        Development.put((EstateImpl)estateImpl, (Development.Option)this.getDevelopment(grundstueckGewerbe.getErschliessung()));
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getFlaecheTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        FloorAreaIndex.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getGeschossflaechenzahl());
        BaseAreaIndex.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getGrundflaechenzahl());
        PlotArea.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        BuildableInShortTerm.put((EstateImpl)estateImpl, (Boolean)grundstueckGewerbe.getKurzfristigBebaubar());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)grundstueckGewerbe.getVerfuegbarAb());
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getErbpachtdauer());
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction) || OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            Lease.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getPreis());
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getPreis());
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)grundstueckGewerbe.getPreis());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, GrundstueckWohnen grundstueckWohnen) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(grundstueckWohnen.getObjektkategorie());
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        OpenEstateAction openEstateAction = this.getAction(grundstueckWohnen.getVermarktungsart());
        if (openEstateAction == null) {
            throw new OpenEstateException("Keine passende Vermarktungsart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        DemolitionRequired.put((EstateImpl)estateImpl, (Boolean)grundstueckWohnen.getAbrissErforderlich());
        BuildingPermissionAvailable.put((EstateImpl)estateImpl, (Boolean)grundstueckWohnen.getBaugenehmigungVorhanden());
        BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)this.getBuildableAccordingTo(grundstueckWohnen.getBebaubarNach()));
        BuildableWith.put((EstateImpl)estateImpl, (BuildableWith.Option[])this.getBuildableWith(grundstueckWohnen.getEmpfohleneNutzung()));
        Development.put((EstateImpl)estateImpl, (Development.Option)this.getDevelopment(grundstueckWohnen.getErschliessung()));
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getFlaecheTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        FloorAreaIndex.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getGeschossflaechenzahl());
        BaseAreaIndex.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getGrundflaechenzahl());
        PlotArea.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        BuildableInShortTerm.put((EstateImpl)estateImpl, (Boolean)grundstueckWohnen.getKurzfristigBebaubar());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)grundstueckWohnen.getVerfuegbarAb());
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getErbpachtdauer());
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction) || OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            Lease.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getPreis());
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getPreis());
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)grundstueckWohnen.getPreis());
        }
    }

    protected void setupEstate(EstateImpl estateImpl, HausKauf hausKauf) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(hausKauf.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)hausKauf.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)hausKauf.getAnzahlGarageStellplatz());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)hausKauf.getAnzahlSchlafzimmer());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(hausKauf.getAusstattung()));
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)hausKauf.getBarrierefrei());
        BuildYear.put((EstateImpl)estateImpl, (Number)hausKauf.getBaujahr());
        ConstructionPhase.put((EstateImpl)estateImpl, (ConstructionPhase.Option)this.getConstructionPhase(hausKauf.getBauphase()));
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(hausKauf.getBefeuerungsart()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)hausKauf.getDenkmalschutz());
        GrannyFlat.put((EstateImpl)estateImpl, (Boolean)hausKauf.getEinliegerwohnung());
        CountFloors.put((EstateImpl)estateImpl, (Number)hausKauf.getEtagenzahl());
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)hausKauf.getFerienhaus());
        PlotArea.put((EstateImpl)estateImpl, (Number)hausKauf.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(hausKauf.getHeizungsart()));
        PurchasePrice.put((EstateImpl)estateImpl, (Number)hausKauf.getKaufpreis());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(hausKauf.getKeller()));
        RentalIncomePerMonth.put((EstateImpl)estateImpl, (Number)hausKauf.getMieteinnahmenProMonat());
        UsableArea.put((EstateImpl)estateImpl, (Number)hausKauf.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(hausKauf.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)hausKauf.getSanierungsjahr());
        CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)this.getCarParkingType(hausKauf.getStellplatz()));
        CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)hausKauf.getStellplatzpreis());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)hausKauf.getVerfuegbarAb());
        Rented.put((EstateImpl)estateImpl, (Boolean)hausKauf.getVermietet());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)hausKauf.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)hausKauf.getZimmer());
        this.setupEnergiepass(estateImpl, hausKauf.getEnergieausweisTyp(), hausKauf.getEnergieausweisKennwert(), hausKauf.getEnergieausweisInklWarmwasser());
        if (Boolean.TRUE.equals(hausKauf.getGaesteWc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (Boolean.TRUE.equals(hausKauf.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
    }

    protected void setupEstate(EstateImpl estateImpl, HausMiete hausMiete) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(hausMiete.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)hausMiete.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)hausMiete.getAnzahlGarageStellplatz());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)hausMiete.getAnzahlSchlafzimmer());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(hausMiete.getAusstattung()));
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)hausMiete.getBarrierefrei());
        BuildYear.put((EstateImpl)estateImpl, (Number)hausMiete.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(hausMiete.getBefeuerungsart()));
        CountFloors.put((EstateImpl)estateImpl, (Number)hausMiete.getEtagenzahl());
        PlotArea.put((EstateImpl)estateImpl, (Number)hausMiete.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        Pets.put((EstateImpl)estateImpl, (Pets.Option)this.getPets(hausMiete.getHaustiere()));
        HeatingCosts.put((EstateImpl)estateImpl, (Number)hausMiete.getHeizkosten());
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(hausMiete.getHeizungsart()));
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)hausMiete.getKaltmiete());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)hausMiete.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(hausMiete.getKeller()));
        ServiceCharges.put((EstateImpl)estateImpl, (Number)hausMiete.getNebenkosten());
        ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)hausMiete.getNebenkostenInklHeizkosten());
        UsableArea.put((EstateImpl)estateImpl, (Number)hausMiete.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(hausMiete.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)hausMiete.getSanierungsjahr());
        CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)this.getCarParkingType(hausMiete.getStellplatz()));
        CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)hausMiete.getStellplatzmiete());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)hausMiete.getVerfuegbarAb());
        RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)hausMiete.getWarmmiete());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)hausMiete.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)hausMiete.getZimmer());
        this.setupEnergiepass(estateImpl, hausMiete.getEnergieausweisTyp(), hausMiete.getEnergieausweisKennwert(), hausMiete.getEnergieausweisInklWarmwasser());
        if (Boolean.TRUE.equals(hausMiete.getGaesteWc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (Boolean.TRUE.equals(hausMiete.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (Boolean.TRUE.equals(hausMiete.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (Boolean.TRUE.equals(hausMiete.getSeniorengerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS);
        }
    }

    protected void setupEstate(EstateImpl estateImpl, StellplatzKauf stellplatzKauf) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(stellplatzKauf.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        BuildYear.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getBaujahr());
        Width.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getBreite(), (LengthValue.Unit)LengthValue.Unit.M);
        CarParkingArea.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        Height.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getHoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        PurchasePrice.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getKaufpreis());
        Length.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getLaenge(), (LengthValue.Unit)LengthValue.Unit.M);
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(stellplatzKauf.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)stellplatzKauf.getSanierungsjahr());
    }

    protected void setupEstate(EstateImpl estateImpl, StellplatzMiete stellplatzMiete) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(stellplatzMiete.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        BuildYear.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getBaujahr());
        Width.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getBreite(), (LengthValue.Unit)LengthValue.Unit.M);
        CarParkingArea.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)stellplatzMiete.getFreiAb());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)stellplatzMiete.getFreiBis());
        Height.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getHoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        Length.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getLaenge(), (LengthValue.Unit)LengthValue.Unit.M);
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getMiete());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(stellplatzMiete.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)stellplatzMiete.getSanierungsjahr());
    }

    protected void setupEstate(EstateImpl estateImpl, WohnenAufZeit wohnenAufZeit) throws OpenEstateException {
        Object object;
        Object object2;
        Serializable serializable;
        BigDecimal bigDecimal;
        OpenEstateType openEstateType = this.getType(wohnenAufZeit.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.SHORT_TERM_RENT;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getAnzahlGarageStellplatz());
        PeopleMaximumCount.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getAnzahlPersonen());
        Lift.put((EstateImpl)estateImpl, (Boolean)wohnenAufZeit.getAufzug());
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)wohnenAufZeit.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)wohnenAufZeit.getBarrierefrei());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(wohnenAufZeit.getBefeuerungsart()));
        CountFloors.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getEtagenzahl());
        AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)wohnenAufZeit.getFreiAb());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)wohnenAufZeit.getFreiBis());
        GardenUse.put((EstateImpl)estateImpl, (Boolean)wohnenAufZeit.getGartennutzung());
        GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)this.getGenderOfRequestedFlatmates(wohnenAufZeit.getGeschlecht()));
        Pets.put((EstateImpl)estateImpl, (Pets.Option)this.getPets(wohnenAufZeit.getHaustiere()));
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(wohnenAufZeit.getHeizungsart()));
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getKaltmiete());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)wohnenAufZeit.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(wohnenAufZeit.getKeller()));
        Furnished.put((EstateImpl)estateImpl, (Furnished.Option)this.getFurnished(wohnenAufZeit.getMobiliar()));
        ServiceCharges.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getNebenkosten());
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(wohnenAufZeit.getObjektzustand()));
        RentFlatRate.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getPauschalmiete());
        NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)this.getNonSmoker(wohnenAufZeit.getRauchen()));
        RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)this.getRentFlatRatePer(wohnenAufZeit.getPauschalmietePro()));
        CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)this.getCarParkingType(wohnenAufZeit.getStellplatz()));
        CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getStellplatzmiete());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)wohnenAufZeit.getZimmer());
        this.setupEnergiepass(estateImpl, wohnenAufZeit.getEnergieausweisTyp(), wohnenAufZeit.getEnergieausweisKennwert(), wohnenAufZeit.getEnergieausweisInklWarmwasser());
        Integer n = wohnenAufZeit.getEtage();
        if (n != null) {
            Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)n.toString());
        }
        if (Boolean.TRUE.equals(wohnenAufZeit.getGaesteWc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if ((bigDecimal = wohnenAufZeit.getMietdauerMaximum()) != null) {
            serializable = NumberFormat.getInstance(this.getOpenEstateLanguage());
            ((NumberFormat)serializable).setMaximumFractionDigits(2);
            ((NumberFormat)serializable).setMaximumIntegerDigits(5);
            ((NumberFormat)serializable).setMinimumFractionDigits(0);
            object2 = this.getOpenEstateLanguage();
            object = object2 != null && "de".equalsIgnoreCase(((Locale)object2).getLanguage()) ? ((Format)serializable).format(bigDecimal) + " Monate" : ((Format)serializable).format(bigDecimal) + " months";
            OccupationPeriodMaximum.putValue((EstateImpl)estateImpl, (Locale)object2, (String)object);
        }
        if ((serializable = wohnenAufZeit.getMietdauerMinimum()) != null) {
            object = NumberFormat.getInstance(this.getOpenEstateLanguage());
            ((NumberFormat)object).setMaximumFractionDigits(2);
            ((NumberFormat)object).setMaximumIntegerDigits(5);
            ((NumberFormat)object).setMinimumFractionDigits(0);
            Locale locale = this.getOpenEstateLanguage();
            object2 = locale != null && "de".equalsIgnoreCase(locale.getLanguage()) ? ((Format)object).format(serializable) + " Monate" : ((Format)object).format(serializable) + " months";
            OccupationPeriodMinimum.putValue((EstateImpl)estateImpl, (Locale)locale, (String)object2);
        }
        if (Boolean.TRUE.equals(wohnenAufZeit.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
    }

    protected void setupEstate(EstateImpl estateImpl, WohnungKauf wohnungKauf) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(wohnungKauf.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.PURCHASE;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)wohnungKauf.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)wohnungKauf.getAnzahlGarageStellplatz());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)wohnungKauf.getAnzahlSchlafzimmer());
        Lift.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getAufzug());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(wohnungKauf.getAusstattung()));
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getBarrierefrei());
        BuildYear.put((EstateImpl)estateImpl, (Number)wohnungKauf.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(wohnungKauf.getBefeuerungsart()));
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getDenkmalschutz());
        CountFloors.put((EstateImpl)estateImpl, (Number)wohnungKauf.getEtagenzahl());
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getFerienwohnung());
        GardenUse.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getGartennutzung());
        CommonCharge.put((EstateImpl)estateImpl, (Number)wohnungKauf.getHausgeld());
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(wohnungKauf.getHeizungsart()));
        PurchasePrice.put((EstateImpl)estateImpl, (Number)wohnungKauf.getKaufpreis());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(wohnungKauf.getKeller()));
        RentalIncomePerMonth.put((EstateImpl)estateImpl, (Number)wohnungKauf.getMieteinnahmenProMonat());
        UsableArea.put((EstateImpl)estateImpl, (Number)wohnungKauf.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(wohnungKauf.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)wohnungKauf.getSanierungsjahr());
        CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)this.getCarParkingType(wohnungKauf.getStellplatz()));
        CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)wohnungKauf.getStellplatzpreis());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)wohnungKauf.getVerfuegbarAb());
        Rented.put((EstateImpl)estateImpl, (Boolean)wohnungKauf.getVermietet());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)wohnungKauf.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)wohnungKauf.getZimmer());
        this.setupEnergiepass(estateImpl, wohnungKauf.getEnergieausweisTyp(), wohnungKauf.getEnergieausweisKennwert(), wohnungKauf.getEnergieausweisInklWarmwasser());
        Integer n = wohnungKauf.getEtage();
        if (n != null) {
            Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)n.toString());
        }
        if (Boolean.TRUE.equals(wohnungKauf.getGaesteWc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (Boolean.TRUE.equals(wohnungKauf.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (Boolean.TRUE.equals(wohnungKauf.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (Boolean.TRUE.equals(wohnungKauf.getSeniorengerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS);
        }
    }

    protected void setupEstate(EstateImpl estateImpl, WohnungMiete wohnungMiete) throws OpenEstateException {
        OpenEstateType openEstateType = this.getType(wohnungMiete.getObjektkategorie());
        OpenEstateAction openEstateAction = OpenEstateAction.RENT;
        if (openEstateType == null) {
            throw new OpenEstateException("Keine passende Immobilienart gefunden!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        CountBathrooms.put((EstateImpl)estateImpl, (Number)wohnungMiete.getAnzahlBadezimmer());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)wohnungMiete.getAnzahlGarageStellplatz());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)wohnungMiete.getAnzahlSchlafzimmer());
        Lift.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getAufzug());
        Equipment.put((EstateImpl)estateImpl, (Equipment.Option)this.getEquipment(wohnungMiete.getAusstattung()));
        BalconyTerrace.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getBalkonTerrasse());
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getBarrierefrei());
        BuildYear.put((EstateImpl)estateImpl, (Number)wohnungMiete.getBaujahr());
        TypeOfBeaconing.put((EstateImpl)estateImpl, (TypeOfBeaconing.Option[])this.getTypeOfBeaconing(wohnungMiete.getBefeuerungsart()));
        CountFloors.put((EstateImpl)estateImpl, (Number)wohnungMiete.getEtagenzahl());
        WbsRequired.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getFoerderung());
        GardenUse.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getGartennutzung());
        Pets.put((EstateImpl)estateImpl, (Pets.Option)this.getPets(wohnungMiete.getHaustiere()));
        HeatingCosts.put((EstateImpl)estateImpl, (Number)wohnungMiete.getHeizkosten());
        TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)this.getTypeOfHeating(wohnungMiete.getHeizungsart()));
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)wohnungMiete.getKaltmiete());
        Deposit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)wohnungMiete.getKaution());
        UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)this.getUndergroundLevel(wohnungMiete.getKeller()));
        ServiceCharges.put((EstateImpl)estateImpl, (Number)wohnungMiete.getNebenkosten());
        ServiceChargesIncludingHeatingCosts.put((EstateImpl)estateImpl, (Boolean)wohnungMiete.getNebenkostenInklHeizkosten());
        UsableArea.put((EstateImpl)estateImpl, (Number)wohnungMiete.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)this.getConditionType(wohnungMiete.getObjektzustand()));
        RefurbishmentYear.put((EstateImpl)estateImpl, (Number)wohnungMiete.getSanierungsjahr());
        CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)this.getCarParkingType(wohnungMiete.getStellplatz()));
        CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)wohnungMiete.getStellplatzmiete());
        AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)wohnungMiete.getVerfuegbarAb());
        RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)wohnungMiete.getWarmmiete());
        ResidentialArea.put((EstateImpl)estateImpl, (Number)wohnungMiete.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountRooms.put((EstateImpl)estateImpl, (Number)wohnungMiete.getZimmer());
        this.setupEnergiepass(estateImpl, wohnungMiete.getEnergieausweisTyp(), wohnungMiete.getEnergieausweisKennwert(), wohnungMiete.getEnergieausweisInklWarmwasser());
        Integer n = wohnungMiete.getEtage();
        if (n != null) {
            Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)n.toString());
        }
        if (Boolean.TRUE.equals(wohnungMiete.getGaesteWc())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET);
        }
        if (Boolean.TRUE.equals(wohnungMiete.getEinbaukueche())) {
            Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
        }
        if (Boolean.TRUE.equals(wohnungMiete.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (Boolean.TRUE.equals(wohnungMiete.getSeniorengerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.SENIORS);
        }
    }
}

