/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenImmo_1_2_2
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_2.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_2;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_1);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.downgradeUebertragungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <uebertragung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeVersteigerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <versteigerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeProvisionspflichtigElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove <provisionspflichtig> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeAusstattungChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <ausstattung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeObjektartElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <objektart> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBodenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <boden> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBefeuerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <befeuerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeWohnungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <wohnung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHausElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <haus> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeGrundstueckElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <grundstueck> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBueroPraxenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <buero_praxen> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEinzelhandelElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <einzelhandel> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeGastgewerbeElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <gastgewerbe> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHallenLagerProdElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <hallen_lager_prod> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeLandUndForstwirtschaftElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <land_und_forstwirtschaft> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeFreizeitimmobilieGewerblichElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <freizeitimmobilie_gewerblich> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_2);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeBefeuerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:befeuerung[@LUFTWP]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("LUFTWP");
        }
    }

    protected void downgradeBodenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:boden[@FERTIGPARKETT or @LAMINAT or @LINOLEUM]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("FERTIGPARKETT");
            element.removeAttribute("LAMINAT");
            element.removeAttribute("LINOLEUM");
        }
    }

    protected void downgradeBueroPraxenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:buero_praxen[@buero_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("buero_typ"));
            if ("BUEROZENTRUM".equalsIgnoreCase(string)) {
                element.setAttribute("buero_typ", "BUEROFLAECHE");
                continue;
            }
            if ("LOFT_ATELIER".equalsIgnoreCase(string)) {
                element.setAttribute("buero_typ", "BUEROFLAECHE");
                continue;
            }
            if ("PRAXISFLAECHE".equalsIgnoreCase(string)) {
                element.setAttribute("buero_typ", "BUEROFLAECHE");
                continue;
            }
            if (!"PRAXISHAUS".equalsIgnoreCase(string)) continue;
            element.setAttribute("buero_typ", "BUEROFLAECHE");
        }
    }

    protected void downgradeEinzelhandelElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:einzelhandel[@handel_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("handel_typ"));
            if ("KAUFHAUS".equalsIgnoreCase(string)) {
                element.removeAttribute("handel_typ");
                continue;
            }
            if ("FACTORY_OUTLET".equalsIgnoreCase(string)) {
                element.removeAttribute("handel_typ");
                continue;
            }
            if ("KIOSK".equalsIgnoreCase(string)) {
                element.removeAttribute("handel_typ");
                continue;
            }
            if ("VERKAUFSFLAECHE".equalsIgnoreCase(string)) {
                element.removeAttribute("handel_typ");
                continue;
            }
            if (!"AUSSTELLUNGSFLAECHE".equalsIgnoreCase(string)) continue;
            element.removeAttribute("handel_typ");
        }
    }

    protected void downgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass/io:epart", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            Element element3 = document.createElementNS("", "art");
            element3.setTextContent(element.getTextContent());
            element2.replaceChild(element3, element);
        }
    }

    protected void downgradeFreizeitimmobilieGewerblichElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:freizeitimmobilie_gewerblich[@freizeit_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("freizeit_typ"));
            if (!"FREIZEITANLAGE".equalsIgnoreCase(string)) continue;
            element.removeAttribute("freizeit_typ");
        }
    }

    protected void downgradeGastgewerbeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:gastgewerbe[@gastgew_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("gastgew_typ"));
            if ("BAR".equalsIgnoreCase(string)) {
                element.removeAttribute("gastgew_typ");
                continue;
            }
            if ("CAFE".equalsIgnoreCase(string)) {
                element.removeAttribute("gastgew_typ");
                continue;
            }
            if ("DISCOTHEK".equalsIgnoreCase(string)) {
                element.removeAttribute("gastgew_typ");
                continue;
            }
            if ("RESTAURANT".equalsIgnoreCase(string)) {
                element.removeAttribute("gastgew_typ");
                continue;
            }
            if ("RAUCHERLOKAL".equalsIgnoreCase(string)) {
                element.removeAttribute("gastgew_typ");
                continue;
            }
            if (!"EINRAUMLOKAL".equalsIgnoreCase(string)) continue;
            element.removeAttribute("gastgew_typ");
        }
    }

    protected void downgradeGrundstueckElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:grundstueck[@grundst_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("grundst_typ"));
            if (!"GEWERBEPARK".equalsIgnoreCase(string)) continue;
            element.removeAttribute("grundst_typ");
        }
    }

    protected void downgradeHallenLagerProdElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:hallen_lager_prod[@hallen_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("hallen_typ"));
            if ("INDUSTRIEHALLE".equalsIgnoreCase(string)) {
                element.setAttribute("hallen_typ", "HALLE");
                continue;
            }
            if ("LAGERFLAECHEN".equalsIgnoreCase(string)) {
                element.setAttribute("hallen_typ", "LAGER");
                continue;
            }
            if ("LAGER_MIT_FREIFLAECHE".equalsIgnoreCase(string)) {
                element.setAttribute("hallen_typ", "LAGER");
                continue;
            }
            if ("SPEDITIONSLAGER".equalsIgnoreCase(string)) {
                element.setAttribute("hallen_typ", "LAGER");
                continue;
            }
            if (!"KUEHLHAUS".equalsIgnoreCase(string)) continue;
            element.removeAttribute("hallen_typ");
        }
    }

    protected void downgradeHausElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if (!"KEINE_ANGABE".equalsIgnoreCase(string)) continue;
            element.removeAttribute("haustyp");
        }
    }

    protected void downgradeLandUndForstwirtschaftElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:land_und_forstwirtschaft[@land_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("land_typ"));
            if (!"ANWESEN".equalsIgnoreCase(string)) continue;
            element.setAttribute("land_typ", "SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN");
        }
    }

    protected void downgradeObjektartElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = null;
            List list2 = XmlUtils.newXPath((String)"*", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                Element element2 = (Element)e2;
                if (string == null) {
                    string = element2.getLocalName();
                    continue;
                }
                if (string.equalsIgnoreCase(element2.getLocalName())) continue;
                element.removeChild(element2);
            }
        }
    }

    protected void downgradeUebertragungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung[@timestamp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("timestamp");
        }
    }

    protected void downgradeWohnungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:wohnung[@wohnungtyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("wohnungtyp"));
            if (!"KEINE_ANGABE".equalsIgnoreCase(string)) continue;
            element.removeAttribute("wohnungtyp");
        }
    }

    protected void removeAusstattungChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:ausstatt_kategorie | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:dachform | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:bauweise | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:ausbaustufe", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeProvisionspflichtigElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:provisionspflichtig", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeVersteigerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:versteigerung", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass/io:art", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            Element element3 = document.createElementNS("", "epart");
            element3.setTextContent(element.getTextContent());
            element2.replaceChild(element3, element);
        }
    }
}

