/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.idx;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.ChimneyPort;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.Fireplace;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CountBalconies;
import com.openindex.openestate.impl.attribs.measures.CountResidentialUnits;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CubatureVolume;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCityCentre;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCollege;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToComprehensiveSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToDayNursery;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToElementarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToJuniorHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextShopping;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSecondarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToUniversity;
import com.openindex.openestate.impl.attribs.surroundings.View;
import com.openindex.openestate.impl.utils.AbstractCsvWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvRecord;
import org.openestate.io.idx.IdxPrinter;
import org.openestate.io.idx.IdxRecord;
import org.openestate.io.idx.types.Media;
import org.openestate.io.idx.types.ObjectType;
import org.openestate.io.idx.types.OfferType;
import org.openestate.io.idx.types.PriceUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxWriter
extends AbstractCsvWriter<IdxPrinter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxWriter.class);
    public static final int MAX_IMAGES_PER_OBJECT = 13;
    public static final int MAX_MOVIES_PER_OBJECT = 1;
    public static final int MAX_DOCUMENTS_PER_OBJECT = 1;
    private boolean energyCertificateAppendedToDescription = false;

    public IdxWriter() {
        this(null);
    }

    public IdxWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected IdxRecord createEmptyRecord() {
        IdxRecord idxRecord = new IdxRecord();
        idxRecord.setSenderId("OpenEstate-Impl");
        return idxRecord;
    }

    protected IdxPrinter createPrinter(OutputStream outputStream) throws IOException {
        return IdxPrinter.create((OutputStream)outputStream);
    }

    protected IdxPrinter createPrinter(Writer writer) throws IOException {
        return IdxPrinter.create((Writer)writer);
    }

    protected IdxRecord createRecord(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        Long l;
        Object object;
        IdxRecord idxRecord = this.createEmptyRecord();
        idxRecord.setAgencyId(agentImpl.getId());
        idxRecord.setRefObject(estateImpl.getId());
        List<OpenEstateType> list2 = Arrays.asList(estateImpl.getType().getParentPath());
        ObjectType objectType = this.getObjectType(estateImpl, list2);
        if (objectType == null) {
            list.add("Keine passende Objektart gefunden!");
            return null;
        }
        idxRecord.setObjectType(objectType);
        OfferType offerType = this.getOfferType(estateImpl);
        if (offerType == null) {
            list.add("Keine passende Vermarktungsart gefunden!");
            return null;
        }
        idxRecord.setOfferType(offerType);
        idxRecord.setRaisedGroundFloor(list2.contains(OpenEstateType.MEZZANINE));
        idxRecord.setFlatSharingCommunity(list2.contains(OpenEstateType.APARTMENT_SHARE));
        idxRecord.setCornerHouse(list2.contains(OpenEstateType.TERRACED_HOUSE_CORNERSIDE));
        idxRecord.setMiddleHouse(list2.contains(OpenEstateType.TERRACED_HOUSE_MIDDLE));
        idxRecord.setGardenhouse(list2.contains(OpenEstateType.SUMMER_HOUSE));
        idxRecord.setObjectCity(estateImpl.getAddress().getCity());
        idxRecord.setObjectCountry(estateImpl.getAddress().getCountry());
        idxRecord.setObjectSituation(estateImpl.getAddress().getRegion());
        idxRecord.setObjectStreet(estateImpl.getAddress().writeStreet());
        idxRecord.setObjectZip(estateImpl.getAddress().getPostalCode());
        idxRecord.setAvailableFrom(AvailabilityBeginDate.get((EstateImpl)estateImpl));
        idxRecord.setObjectTitle((String)StringUtils.defaultIfBlank((CharSequence)estateImpl.getTitle(this.getOpenEstateLanguage()), (CharSequence)estateImpl.getFallbackTitle(this.getOpenEstateLanguage())));
        String string = DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        if (StringUtils.isBlank((CharSequence)string)) {
            string = FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            string = LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            string = ShortDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            string = idxRecord.getObjectTitle();
        }
        if (this.isEnergyCertificateAppendedToDescription() && (object = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)"\r\n")) != null) {
            string = OpenEstateUtils.appendTextToDescription((String)string, (String)object, (String)"\r\n", (int)4000, (boolean)false);
        }
        idxRecord.setObjectDescription(string);
        idxRecord.setCurrency(estateImpl.getCurrency());
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            object = PurchasePrice.getAsLong((EstateImpl)estateImpl);
            l = PurchasePricePerArea.getAsLong((EstateImpl)estateImpl);
            if (object != null) {
                idxRecord.setSellingPrice((Number)object);
                idxRecord.setPriceUnit(PriceUnit.SELL);
            } else if (l != null) {
                idxRecord.setSellingPrice((Number)l);
                idxRecord.setPriceUnit(PriceUnit.SELLM2);
            }
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction()) || OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
            idxRecord.setSellingPrice((Number)Lease.getAsLong((EstateImpl)estateImpl));
            idxRecord.setPriceUnit(PriceUnit.MONTHLY);
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            idxRecord.setSellingPrice((Number)OpenEstateUtils.getTotalRent((EstateImpl)estateImpl));
            idxRecord.setRentNet((Number)RentExcludingServiceCharges.getAsLong((EstateImpl)estateImpl));
            idxRecord.setPriceUnit(PriceUnit.MONTHLY);
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            idxRecord.setSellingPrice((Number)RentFlatRate.getAsLong((EstateImpl)estateImpl));
            object = RentFlatRatePer.get((EstateImpl)estateImpl);
            if (RentFlatRatePer.Option.YEAR.equals(object)) {
                idxRecord.setPriceUnit(PriceUnit.YEARLY);
            } else if (RentFlatRatePer.Option.MONTH.equals(object)) {
                idxRecord.setPriceUnit(PriceUnit.MONTHLY);
            } else if (RentFlatRatePer.Option.WEEK.equals(object)) {
                idxRecord.setPriceUnit(PriceUnit.WEEKLY);
            } else if (RentFlatRatePer.Option.DAY.equals(object)) {
                idxRecord.setPriceUnit(PriceUnit.DAILY);
            }
        }
        idxRecord.setRentExtra((Number)ServiceCharges.getAsLong((EstateImpl)estateImpl));
        object = Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
        if (!StringUtils.isBlank((CharSequence)object)) {
            try {
                idxRecord.setFloor(OpenEstateUtils.parseNumber((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        idxRecord.setNumberOfFloors((Number)CountFloors.getAsLong((EstateImpl)estateImpl));
        idxRecord.setNumberOfRooms((Number)CountRooms.getAsFloat((EstateImpl)estateImpl));
        idxRecord.setNumberOfApartments((Number)CountResidentialUnits.getAsFloat((EstateImpl)estateImpl));
        idxRecord.setSurfaceLiving((Number)ResidentialArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        idxRecord.setSurfaceProperty((Number)PlotArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        l = UsableArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (l == null || l < 1L) {
            l = TotalArea.getAsLong((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        idxRecord.setSurfaceUsable((Number)l);
        idxRecord.setVolume((Number)CubatureVolume.getAsLong((EstateImpl)estateImpl, (VolumeValue.Unit)VolumeValue.Unit.CUM));
        idxRecord.setYearBuilt((Number)BuildYear.getAsInteger((EstateImpl)estateImpl));
        idxRecord.setYearRenovated((Number)RefurbishmentYear.getAsInteger((EstateImpl)estateImpl));
        idxRecord.setView(!ArrayUtils.isEmpty((Object[])View.get((EstateImpl)estateImpl)));
        idxRecord.setFireplace(Boolean.TRUE.equals(ChimneyPort.get((EstateImpl)estateImpl)) || !ArrayUtils.isEmpty((Object[])Fireplace.get((EstateImpl)estateImpl)));
        List list3 = Technics.getAsList((EstateImpl)estateImpl);
        idxRecord.setCableTv(list3.contains(Technics.Option.CABLE_SAT_TV) || list3.contains(Technics.Option.CABLE_TV));
        idxRecord.setElevator(Boolean.TRUE.equals(Lift.get((EstateImpl)estateImpl)) || Boolean.TRUE.equals(FreightElevator.get((EstateImpl)estateImpl)));
        idxRecord.setParking(!ArrayUtils.isEmpty((Object[])CarParkingType.get((EstateImpl)estateImpl)));
        int n = (Integer)ObjectUtils.defaultIfNull((Object)CountBalconies.getAsInteger((EstateImpl)estateImpl), (Object)0);
        idxRecord.setBalcony(Boolean.TRUE.equals(BalconyTerrace.get((EstateImpl)estateImpl)) || n > 0);
        List list4 = Applicability.getAsList((EstateImpl)estateImpl);
        idxRecord.setWheelchairAccessible(Boolean.TRUE.equals(BarrierFree.get((EstateImpl)estateImpl)) || list4.contains(Applicability.Option.WHEELCHAIR));
        idxRecord.setAnimalAllowed(Pets.Option.YES.equals((Object)Pets.get((EstateImpl)estateImpl)));
        idxRecord.setHallHeight((Number)WarehouseHeight.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        idxRecord.setMaximalFloorLoading((Number)FloorLoading.getAsFloat((EstateImpl)estateImpl));
        idxRecord.setCarryingCapacityCrane((Number)CraneLiftingCapacity.getAsFloat((EstateImpl)estateImpl));
        idxRecord.setCarryingCapacityElevator((Number)FreightElevatorCapacity.getAsFloat((EstateImpl)estateImpl));
        idxRecord.setRamp(Boolean.TRUE.equals(Ramp.get((EstateImpl)estateImpl)));
        idxRecord.setLiftingPlatform(Boolean.TRUE.equals(LiftingPlatform.get((EstateImpl)estateImpl)));
        idxRecord.setRestrooms(ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET));
        Development.Option option = Development.get((EstateImpl)estateImpl);
        idxRecord.setBuildingLandConnected(Development.Option.PARTIALLY.equals((Object)option) || Development.Option.COMPLETELY.equals((Object)option));
        Age.Option option2 = Age.get((EstateImpl)estateImpl);
        idxRecord.setNewBuilding(Age.Option.NEW_BUILDING.equals((Object)option2));
        idxRecord.setOldBuilding(Age.Option.OLD_BUILDING.equals((Object)option2));
        idxRecord.setSwimmingpool(Boolean.TRUE.equals(SwimmingPool.get((EstateImpl)estateImpl)));
        idxRecord.setDistanceKindergarten((Number)DistanceToDayNursery.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        idxRecord.setDistanceMotorway((Number)DistanceToMotorway.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        Long l2 = DistanceToNextTrainStation.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToBusStation.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToMainLineStation.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        idxRecord.setDistancePublicTransport((Number)l2);
        l2 = DistanceToNextShopping.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToCityCentre.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        idxRecord.setDistanceShop((Number)l2);
        idxRecord.setDistanceSchool1((Number)DistanceToElementarySchool.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        l2 = DistanceToComprehensiveSchool.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToHighSchool.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToJuniorHighSchool.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToCollege.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToSecondarySchool.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        if (l2 == null || l2 < 1L) {
            l2 = DistanceToUniversity.getAsLong((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M);
        }
        idxRecord.setDistanceSchool2((Number)l2);
        idxRecord.setAgencyCity(agentContactImpl != null ? agentContactImpl.getCity() : agentImpl.getCompany().getCity());
        idxRecord.setAgencyCountry(agentContactImpl != null ? agentContactImpl.getCountry() : agentImpl.getCompany().getCountry());
        idxRecord.setAgencyEmail(agentContactImpl != null ? agentContactImpl.getPersonMail() : agentImpl.getCompany().getCompanyMail());
        idxRecord.setAgencyFax(agentContactImpl != null ? agentContactImpl.getPersonFax() : agentImpl.getCompany().getCompanyFax());
        idxRecord.setAgencyName(agentImpl.getCompany().getCompanyName());
        idxRecord.setAgencyName2(agentImpl.getCompany().getCompanyNameAddition());
        idxRecord.setAgencyPhone(agentContactImpl != null ? agentContactImpl.getPersonPhone() : agentImpl.getCompany().getCompanyPhone());
        idxRecord.setAgencyReference(agentContactImpl != null ? agentContactImpl.writePersonFullName() : agentImpl.getCompany().writePersonFullName());
        idxRecord.setAgencyStreet(agentContactImpl != null ? agentContactImpl.writeStreet() : agentImpl.getCompany().writeStreet());
        idxRecord.setAgencyZip(agentContactImpl != null ? agentContactImpl.getPostalCode() : agentImpl.getCompany().getPostalCode());
        Media media = null;
        Media media2 = null;
        ArrayList<Media> arrayList = new ArrayList<Media>();
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            String string2 = StringUtils.trimToNull((String)estateAttachmentImpl.getFileAsName());
            URI uRI = estateAttachmentImpl.getFileAsUrl();
            if (string2 != null) {
                string2 = FilenameUtils.getName((String)string2);
            } else {
                if (uRI == null) continue;
                string2 = FilenameUtils.getName((String)StringUtils.trimToNull((String)uRI.getPath()));
            }
            if (Media.isDocument((String)string2)) {
                if (media != null) continue;
                media = new Media(string2, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()), null, uRI != null ? uRI.toString() : null);
                continue;
            }
            if (Media.isMovie((String)string2)) {
                if (media2 != null) continue;
                media2 = new Media(string2, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()), null, uRI != null ? uRI.toString() : null);
                continue;
            }
            if (!Media.isImage((String)string2) || arrayList.size() > 12) continue;
            arrayList.add(new Media(string2, estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()), null, uRI != null ? uRI.toString() : null));
        }
        idxRecord.setDocument(media);
        idxRecord.setMovie(media2);
        idxRecord.setPictures(arrayList);
        return idxRecord;
    }

    protected ObjectType getObjectType(EstateImpl estateImpl, List<OpenEstateType> list) {
        if (list.contains(OpenEstateType.ATELIER)) {
            return ObjectType.INDUS_ATELIER;
        }
        if (list.contains(OpenEstateType.GARDENING)) {
            return ObjectType.INDUS_GARDENING;
        }
        if (list.contains(OpenEstateType.SUMMER_HOUSE) || list.contains(OpenEstateType.GARDEN_GROUND)) {
            return ObjectType.GARDEN_GENERAL;
        }
        if (list.contains(OpenEstateType.CAR_PARK_UNIT)) {
            return ObjectType.INDUS_PARKING_GARAGE;
        }
        if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            if (list.contains(OpenEstateType.BERTH)) {
                return ObjectType.PARK_BOAT_LANDING_STAGE;
            }
            if (list.contains(OpenEstateType.CARPORT)) {
                return ObjectType.PARK_COVERED_SLOT;
            }
            if (list.contains(OpenEstateType.DOUBLE_GARAGE)) {
                return ObjectType.PARK_DOUBLE_GARAGE;
            }
            if (list.contains(OpenEstateType.OUTDOOR_CAR_PARKING_SPACE)) {
                return ObjectType.PARK_OPEN_SLOT;
            }
            if (list.contains(OpenEstateType.GARAGE)) {
                return ObjectType.PARK_SINGLE_GARAGE;
            }
            if (list.contains(OpenEstateType.UNDERGROUND_CAR_PARK_UNIT)) {
                return ObjectType.PARK_UNDERGROUND_SLOT;
            }
            return ObjectType.INDUS_PARKING_SURFACE;
        }
        if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            if (list.contains(OpenEstateType.FARM) || list.contains(OpenEstateType.OUTLYING_FARM)) {
                return ObjectType.AGRI_FARM;
            }
            return ObjectType.AGRI_GENERAL;
        }
        if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            if (list.contains(OpenEstateType.AGRICULTURAL_FORESTRY_GROUND)) {
                return ObjectType.PROP_AGRICULTURAL;
            }
            if (list.contains(OpenEstateType.COMMERCIAL_GROUND)) {
                return ObjectType.PROP_COMMERCIAL;
            }
            if (list.contains(OpenEstateType.INDUSTRIAL_GROUND)) {
                return ObjectType.PROP_INDUSTRIAL;
            }
            return ObjectType.PROP_BUILDING;
        }
        if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            if (list.contains(OpenEstateType.HOUSE)) {
                if (list.contains(OpenEstateType.CASTLE) || list.contains(OpenEstateType.PALACE)) {
                    return ObjectType.HOUSE_CASTLE;
                }
                if (list.contains(OpenEstateType.CHALET)) {
                    return ObjectType.HOUSE_CHALET;
                }
                if (list.contains(OpenEstateType.DUPLEX_HOUSE)) {
                    return ObjectType.HOUSE_DUPLEX;
                }
                if (list.contains(OpenEstateType.FARMHOUSE)) {
                    return ObjectType.HOUSE_FARM;
                }
                if (list.contains(OpenEstateType.MULTI_FAMILY_HOUSE)) {
                    return ObjectType.HOUSE_MULTI_FAMILY;
                }
                if (list.contains(OpenEstateType.TERRACED_HOUSE)) {
                    return ObjectType.HOUSE_ROW;
                }
                if (list.contains(OpenEstateType.COUNTRY_HOUSE) || list.contains(OpenEstateType.RUSTICO)) {
                    return ObjectType.HOUSE_RUSTICO;
                }
                if (list.contains(OpenEstateType.SINGLE_FAMILY_HOUSE)) {
                    return ObjectType.HOUSE_SINGLE_FAMILY;
                }
                if (list.contains(OpenEstateType.VILLA)) {
                    return ObjectType.HOUSE_VILLA;
                }
                return ObjectType.HOUSE_SINGLE_FAMILY;
            }
            Furnished.Option option = Furnished.get((EstateImpl)estateImpl);
            if (list.contains(OpenEstateType.ATTIC_APARTMENT)) {
                return ObjectType.APPT_ROOF_FLAT;
            }
            if (list.contains(OpenEstateType.MAISONETTE)) {
                return ObjectType.APPT_DUPLEX;
            }
            if (list.contains(OpenEstateType.LOFT)) {
                return ObjectType.APPT_LOFT;
            }
            if (list.contains(OpenEstateType.ROOM)) {
                return ObjectType.APPT_SINGLE_ROOM;
            }
            if (list.contains(OpenEstateType.STUDIO)) {
                return ObjectType.APPT_STUDIO;
            }
            if (list.contains(OpenEstateType.TERRACE_APARTMENT)) {
                return ObjectType.APPT_TERRACE_FLAT;
            }
            if (Furnished.Option.YES.equals((Object)option) || Furnished.Option.PARTIAL.equals((Object)option)) {
                return ObjectType.APPT_FURNISHED_FLAT;
            }
            return ObjectType.APPT_GENERAL;
        }
        if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            if (list.contains(OpenEstateType.GASTRONOMY) || list.contains(OpenEstateType.LEISURE_SPORTS_FACILITY)) {
                if (list.contains(OpenEstateType.RESTAURANT_BAR)) {
                    return ObjectType.GASTRO_BAR;
                }
                if (list.contains(OpenEstateType.BISTRO_CAFE)) {
                    return ObjectType.GASTRO_CAFE;
                }
                if (list.contains(OpenEstateType.DISCOTHEQUE)) {
                    return ObjectType.GASTRO_CLUB_DISCO;
                }
                if (list.contains(OpenEstateType.HOTEL)) {
                    return ObjectType.GASTRO_HOTEL;
                }
                if (list.contains(OpenEstateType.HOSTEL)) {
                    return ObjectType.GASTRO_MOTEL;
                }
                if (list.contains(OpenEstateType.RESTAURANT)) {
                    return ObjectType.GASTRO_RESTAURANT;
                }
                if (list.contains(OpenEstateType.LEISURE_SPORTS_FACILITY)) {
                    return ObjectType.GASTRO_SPORTS_HALL;
                }
                return ObjectType.GASTRO_RESTAURANT;
            }
            if (list.contains(OpenEstateType.EXHIBITION_AREA)) {
                return ObjectType.INDUS_ADVERTISING;
            }
            if (list.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING)) {
                return ObjectType.INDUS_DEPARTMENT_STORE;
            }
            if (list.contains(OpenEstateType.INDUSTRIAL_FACILITY) || list.contains(OpenEstateType.INDUSTRIAL_WAREHOUSE)) {
                return ObjectType.INDUS_INDUSTRY;
            }
            if (list.contains(OpenEstateType.PRODUCTION)) {
                return ObjectType.INDUS_FACTORY;
            }
            if (list.contains(OpenEstateType.PETROL_STATION)) {
                return ObjectType.INDUS_FUEL_STATION;
            }
            if (list.contains(OpenEstateType.SENIOR_HOUSING_COMPLEX)) {
                return ObjectType.INDUS_OLD_AGE_HOME;
            }
            if (list.contains(OpenEstateType.HOUSING_COMPLEX)) {
                return ObjectType.INDUS_HOME;
            }
            if (list.contains(OpenEstateType.SANATORIUM)) {
                return ObjectType.INDUS_SANATORIUM;
            }
            if (list.contains(OpenEstateType.HOSPITAL_CLINIC)) {
                return ObjectType.INDUS_HOSPITAL;
            }
            if (list.contains(OpenEstateType.KIOSK)) {
                return ObjectType.INDUS_KIOSK;
            }
            if (list.contains(OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING)) {
                return ObjectType.INDUS_LIVING_COMMERCIAL;
            }
            if (list.contains(OpenEstateType.SURGERY) || list.contains(OpenEstateType.SURGERY_FLOOR) || list.contains(OpenEstateType.SURGERY_AREA)) {
                return ObjectType.INDUS_SURGERY;
            }
            if (list.contains(OpenEstateType.OFFICE_SURGERY)) {
                return ObjectType.INDUS_OFFICE;
            }
            if (list.contains(OpenEstateType.RIDING_ESTATE)) {
                return ObjectType.INDUS_RIDING_HALL;
            }
            if (list.contains(OpenEstateType.STORE) || list.contains(OpenEstateType.SALES_AREA) || list.contains(OpenEstateType.OFFICE_COMMERCIAL_PREMISE)) {
                return ObjectType.INDUS_SHOP;
            }
            if (list.contains(OpenEstateType.SHOPPING_CENTER) || list.contains(OpenEstateType.CONSUMER_STORE) || list.contains(OpenEstateType.SHOWROOM) || list.contains(OpenEstateType.SELF_SERVICE_MARKET)) {
                return ObjectType.INDUS_SHOPPING_CENTRE;
            }
            if (list.contains(OpenEstateType.TANNING_SALON)) {
                return ObjectType.INDUS_SOLARIUM;
            }
            if (list.contains(OpenEstateType.HALL_WAREHOUSE)) {
                return ObjectType.INDUS_STORAGE;
            }
            if (list.contains(OpenEstateType.WORKSHOP)) {
                return ObjectType.INDUS_WORKSHOP;
            }
            return ObjectType.INDUS_COMMERCIAL;
        }
        return null;
    }

    protected OfferType getOfferType(EstateImpl estateImpl) {
        OpenEstateAction openEstateAction = estateImpl.getAction();
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            return OfferType.SALE;
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            return OfferType.RENT;
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            return OfferType.RENT;
        }
        if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            return OfferType.RENT;
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            return OfferType.RENT;
        }
        return null;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public void write(AgencyImpl agencyImpl, IdxPrinter idxPrinter) {
        this.getErrorMap().clear();
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                String string = StringUtils.trimToNull((String)estateImpl.getContactId());
                if (string != null && agencyImpl.getContacts().containsKey(string)) {
                    agentContactImpl = (AgentContactImpl)agencyImpl.getContacts().get(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                IdxRecord idxRecord = this.createRecord(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (!arrayList.isEmpty()) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                if (idxRecord == null) continue;
                idxPrinter.printRecord((CsvRecord)idxRecord);
            }
            catch (Exception exception) {
                this.putError(estateImpl.getId(), "Can't print record! " + exception.getLocalizedMessage());
                LOGGER.warn("Can't print record for real estate '" + estateImpl.getId() + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void write(TransferImpl transferImpl, IdxPrinter idxPrinter) {
        this.getErrorMap().clear();
        for (TransferAgencyImpl transferAgencyImpl : transferImpl.getAgencies()) {
            for (Object object : transferAgencyImpl.getEstatesToSave()) {
                try {
                    AgentContactImpl agentContactImpl = null;
                    String string = StringUtils.trimToNull((String)object.getContactId());
                    if (string != null && transferAgencyImpl.getContacts().containsKey(string)) {
                        agentContactImpl = (AgentContactImpl)transferAgencyImpl.getContacts().get(string);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    IdxRecord idxRecord = this.createRecord((EstateImpl)object, transferAgencyImpl.getAgent(), agentContactImpl, (List<String>)arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(object.getId(), arrayList);
                        continue;
                    }
                    if (idxRecord == null) continue;
                    idxPrinter.printRecord((CsvRecord)idxRecord);
                }
                catch (Exception exception) {
                    this.putError(object.getId(), "Can't print record! " + exception.getLocalizedMessage());
                    LOGGER.warn("Can't print record for real estate '" + object.getId() + "'!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            for (Object object : transferAgencyImpl.getEstateIdsToRemove()) {
                this.putError((String)object, "Removals are not supported in IDX format.");
                LOGGER.warn("Can't print record for removal of real estate '" + (String)object + "'! Removals are not supported in IDX format.");
            }
        }
    }
}

