/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.immobiliare_it;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.GrossArea;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.LeasePerArea;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immobiliare_it.ImmobiliareItDocument;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.xml.Box;
import org.openestate.io.immobiliare_it.xml.ClassEnergy;
import org.openestate.io.immobiliare_it.xml.Feed;
import org.openestate.io.immobiliare_it.xml.Floor;
import org.openestate.io.immobiliare_it.xml.Furniture;
import org.openestate.io.immobiliare_it.xml.Garden;
import org.openestate.io.immobiliare_it.xml.Heat;
import org.openestate.io.immobiliare_it.xml.Langtxt;
import org.openestate.io.immobiliare_it.xml.LocationStructure;
import org.openestate.io.immobiliare_it.xml.NationCode;
import org.openestate.io.immobiliare_it.xml.ObjectFactory;
import org.openestate.io.immobiliare_it.xml.Operation;
import org.openestate.io.immobiliare_it.xml.PropertyType;
import org.openestate.io.immobiliare_it.xml.PropertyTypeBusiness;
import org.openestate.io.immobiliare_it.xml.Publisher;
import org.openestate.io.immobiliare_it.xml.Rental;
import org.openestate.io.immobiliare_it.xml.Status;
import org.openestate.io.immobiliare_it.xml.TerrainType;
import org.openestate.io.immobiliare_it.xml.Terrains;
import org.openestate.io.immobiliare_it.xml.TransactionType;
import org.openestate.io.immobiliare_it.xml.Version;
import org.openestate.io.immobiliare_it.xml.VideoProject;
import org.openestate.io.immobiliare_it.xml.VideoType;
import org.openestate.io.immobiliare_it.xml.YesNoReady;
import org.openestate.io.immobiliare_it.xml.types.Category;
import org.openestate.io.immobiliare_it.xml.types.EnergyUnit;
import org.openestate.io.immobiliare_it.xml.types.LandSizeUnit;
import org.openestate.io.immobiliare_it.xml.types.SizeUnit;
import org.openestate.io.immobiliare_it.xml.types.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmobiliareItWriter
extends AbstractXmlWriter<ImmobiliareItDocument, Feed> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItWriter.class);
    private static final ObjectFactory FACTORY = ImmobiliareItUtils.getFactory();
    private static final Map<OpenEstateAction, Transaction> ACTIONS = new EnumMap<OpenEstateAction, Transaction>(OpenEstateAction.class);
    private static final Map<OpenEstateType, Category> CATEGORIES;
    private static final Map<Category, Map<OpenEstateType, PropertyType>> TYPES;
    private static final Map<PropertyType, Map<OpenEstateType, PropertyTypeBusiness>> COMMERCIAL_TYPES;
    private static final Map<OpenEstateType, TerrainType> TERRAINS;
    private Date now = new Date();
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;

    public ImmobiliareItWriter() {
    }

    public ImmobiliareItWriter(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected Publisher convertAgent(AgentImpl agentImpl) {
        Publisher publisher = FACTORY.createPublisher();
        publisher.setName(agentImpl.getCompany().getCompanyName());
        String string = StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyPhone());
        publisher.setPhone(string != null ? string : "+3906XXXXX");
        String string2 = StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMail());
        publisher.setEmail(ImmobiliareItUtils.isValidEmailType((String)string2) ? string2 : "unknown@immobiliare.it");
        URI uRI = agentImpl.getCompany().getCompanyWebsite();
        if (uRI != null && !StringUtils.isBlank((CharSequence)uRI.getHost())) {
            publisher.setSite(uRI.toString());
        }
        return publisher;
    }

    /*
     * WARNING - void declaration
     */
    protected Feed.Properties.Property convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        EstateLinkProvider estateLinkProvider;
        URI uRI;
        Object object;
        Double d;
        Integer n;
        List list2;
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object3;
        Object object2;
        Object object4;
        Object object5;
        String string4;
        Object object7;
        Object object822;
        String string2;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        OpenEstateType openEstateType;
        int n2;
        Feed.Properties.Property property = FACTORY.createFeedPropertiesProperty();
        property.setBuilding(FACTORY.createBuilding());
        property.setUniqueId(estateImpl.getId());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.now);
        if (ImmobiliareItUtils.isValidDateUpdatedType((Calendar)calendar)) {
            property.setDateUpdated(calendar);
        }
        if (estateImpl.getPublishEnd() != null) {
            property.setDateExpiration(Calendar.getInstance());
            property.getDateExpiration().setTime(estateImpl.getPublishEnd());
        }
        if (!ACTIONS.containsKey(estateImpl.getAction())) {
            list.add("Vermarktungsart '" + estateImpl.getAction() + "' wird nicht unterst\u00fctzt!");
            return null;
        }
        Object object14 = FACTORY.createTransactionType();
        object14.setValue(ACTIONS.get(estateImpl.getAction()).getXmlValue());
        object14.setAuction(Boolean.FALSE);
        property.setTransactionType((TransactionType)object14);
        object14 = Arrays.asList(estateImpl.getType().getParentPath());
        Category category = null;
        for (n2 = object14.size(); n2 > 0; --n2) {
            openEstateType = (OpenEstateType)object14.get(n2 - 1);
            if (!TYPES.get(Category.VACANZE).containsKey(openEstateType)) continue;
            category = Category.VACANZE;
            break;
        }
        if (category == null) {
            for (n2 = object14.size(); n2 > 0; --n2) {
                openEstateType = (OpenEstateType)object14.get(n2 - 1);
                if (!CATEGORIES.containsKey(openEstateType)) continue;
                category = CATEGORIES.get(openEstateType);
                break;
            }
        }
        if (category == null) {
            list.add("Immobilienart " + estateImpl.getType() + " wird nicht unterst\u00fctzt!");
            return null;
        }
        property.getBuilding().setCategory(category);
        if (Category.RESIDENZIALE.equals(category) || Category.VACANZE.equals(category)) {
            object13 = null;
            for (int i = object14.size(); i > 0; --i) {
                object12 = (OpenEstateType)object14.get(i - 1);
                if (!TYPES.get(category).containsKey(object12)) continue;
                object13 = TYPES.get(category).get(object12);
                break;
            }
            if (object13 == null) {
                object13 = PropertyType.OTHER;
            }
            property.getBuilding().setType((PropertyType)object13);
        } else if (Category.COMMERCIALE.equals((Object)category)) {
            int n3;
            object13 = null;
            openEstateType = null;
            for (n3 = object14.size(); n3 > 0; --n3) {
                object11 = (OpenEstateType)object14.get(n3 - 1);
                if (!COMMERCIAL_TYPES.get(PropertyType.ATTIVIT\u00c0).containsKey(object11)) continue;
                object13 = PropertyType.ATTIVIT\u00c0;
                break;
            }
            if (object13 == null) {
                for (n3 = object14.size(); n3 > 0; --n3) {
                    object11 = (OpenEstateType)object14.get(n3 - 1);
                    if (!TYPES.get(category).containsKey(object11)) continue;
                    object13 = TYPES.get(category).get(object11);
                    break;
                }
            }
            if (object13 == null) {
                object13 = PropertyType.IMMOBILE;
            }
            property.getBuilding().setType((PropertyType)object13);
            for (n3 = object14.size(); n3 > 0; --n3) {
                object11 = (OpenEstateType)object14.get(n3 - 1);
                if (!COMMERCIAL_TYPES.get(object13).containsKey(object11)) continue;
                openEstateType = COMMERCIAL_TYPES.get(object13).get(object11);
                break;
            }
            property.getBuilding().setDetail((PropertyTypeBusiness)openEstateType);
            if (object13 == PropertyType.TERRENO && openEstateType == PropertyTypeBusiness.AGRICOLO) {
                Terrains terrains = FACTORY.createTerrains();
                object11 = object14.iterator();
                while (object11.hasNext()) {
                    object10 = (OpenEstateType)object11.next();
                    if (!TERRAINS.containsKey(object10)) continue;
                    object9 = TERRAINS.get(object10);
                    if (terrains.getTerrain().contains(object9)) continue;
                    terrains.getTerrain().add(object9);
                }
                object11 = BuildableWith.getAsList((EstateImpl)estateImpl);
                if (object11.contains(BuildableWith.Option.FARMLAND) && !terrains.getTerrain().contains(TerrainType.SEMINATIVO)) {
                    terrains.getTerrain().add(TerrainType.SEMINATIVO);
                }
                if (object11.contains(BuildableWith.Option.FRUIT_PLANTING) && !terrains.getTerrain().contains(TerrainType.FRUTTETO)) {
                    terrains.getTerrain().add(TerrainType.FRUTTETO);
                }
                if (object11.contains(BuildableWith.Option.FOREST) && !terrains.getTerrain().contains(TerrainType.PASCOLO_ARBORATO)) {
                    terrains.getTerrain().add(TerrainType.PASCOLO_ARBORATO);
                }
                if (!terrains.getTerrain().isEmpty()) {
                    property.getBuilding().setTerrains(terrains);
                }
            }
        } else {
            list.add("Immobilien-Kategorie ist ung\u00fcltig!");
            return null;
        }
        object13 = ConditionType.getAsList((EstateImpl)estateImpl);
        if (object13.contains(ConditionType.Option.FIRST_OCCUPANCY) || object13.contains(ConditionType.Option.AS_GOOD_AS_NEW)) {
            property.getBuilding().setStatus(Status.NUOVO);
        } else if (object13.contains(ConditionType.Option.EXCELLENT)) {
            property.getBuilding().setStatus(Status.OTTIMO);
        } else if (object13.contains(ConditionType.Option.WELL_TENDED) || object13.contains(ConditionType.Option.GOOD)) {
            property.getBuilding().setStatus(Status.BUONO);
        } else if (object13.contains(ConditionType.Option.FAIR)) {
            property.getBuilding().setStatus(Status.DISCRETO);
        } else if (object13.contains(ConditionType.Option.HABITABLE)) {
            property.getBuilding().setStatus(Status.ABITABILE);
        } else if (object13.contains(ConditionType.Option.PARTIALLY_RENOVATED) || object13.contains(ConditionType.Option.FULLY_RENOVATED) || object13.contains(ConditionType.Option.PARTIALLY_REFURBISHED) || object13.contains(ConditionType.Option.FULLY_REFURBISHED) || object13.contains(ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT) || object13.contains(ConditionType.Option.MODERNIZED)) {
            property.getBuilding().setStatus(Status.RISTRUTTURATO);
        } else if (object13.contains(ConditionType.Option.PARTIAL_REFURBISHMENT_REQUIRED) || object13.contains(ConditionType.Option.COMPLETE_REFURBISHMENT_REQUIRED) || object13.contains(ConditionType.Option.PARTIAL_RENOVATION_REQUIRED) || object13.contains(ConditionType.Option.COMPLETE_RENOVATION_REQUIRED)) {
            property.getBuilding().setStatus(Status.DA_RISTRUTTURARE);
        } else if (object13.contains(ConditionType.Option.DILAPIDATED) || object13.contains(ConditionType.Option.GUTTED) || object13.contains(ConditionType.Option.SHELL_CONSTRUCTION)) {
            property.getBuilding().setStatus(Status.IN_COSTRUZIONE);
        } else {
            property.getBuilding().setStatus(Status.ND);
        }
        property.setAgent(FACTORY.createFeedPropertiesPropertyAgent());
        property.getAgent().setOfficeName(agentImpl != null && agentImpl.getCompany() != null ? StringUtils.trimToEmpty((String)agentImpl.getCompany().getCompanyName()) : "");
        String string3 = string2 = agentContactImpl != null ? StringUtils.trimToNull((String)agentContactImpl.getPersonMail()) : null;
        if (!ImmobiliareItUtils.isValidEmailType((String)string2)) {
            string2 = agentImpl != null && agentImpl.getCompany() != null ? StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMail()) : null;
        }
        property.getAgent().setEmail(ImmobiliareItUtils.isValidEmailType((String)string2) ? string2 : "unknown@immobiliare.it");
        property.setLocation(FACTORY.createLocationStructure());
        property.getLocation().setCountryCode(estateImpl.getAddress().getCountry());
        property.getLocation().setAdministrativeArea(StringUtils.trimToEmpty((String)estateImpl.getAddress().getRegion()));
        property.getLocation().setSubAdministrativeArea(FACTORY.createLocationStructureSubAdministrativeArea());
        property.getLocation().getSubAdministrativeArea().setValue(StringUtils.trimToEmpty((String)estateImpl.getAddress().getRegion()));
        property.getLocation().setCity(FACTORY.createLocationStructureCity());
        property.getLocation().getCity().setValue(StringUtils.trimToEmpty((String)estateImpl.getAddress().getCity()));
        property.getLocation().setLocality(FACTORY.createLocationStructureLocality());
        property.getLocation().getLocality().setPostalCode(estateImpl.getAddress().getPostalCode());
        property.getLocation().getLocality().setNeighbourhood(FACTORY.createLocationStructureLocalityNeighbourhood());
        property.getLocation().getLocality().getNeighbourhood().setValue(StringUtils.trimToEmpty((String)estateImpl.getAddress().getDistrict()));
        property.getLocation().getLocality().getNeighbourhood().setType(LocationStructure.Locality.Neighbourhood.LocationNeighbourhoodType.AREA);
        object12 = estateImpl.getAddress().getLatitude();
        object11 = estateImpl.getAddress().getLongitude();
        if (ImmobiliareItUtils.isValidLatitude((BigDecimal)object12) && ImmobiliareItUtils.isValidLongitude((BigDecimal)object11)) {
            property.getLocation().getLocality().setLatitude((BigDecimal)object12);
            property.getLocation().getLocality().setLongitude((BigDecimal)object11);
        }
        property.getLocation().getLocality().setThoroughfare(FACTORY.createLocationStructureLocalityThoroughfare());
        property.getLocation().getLocality().getThoroughfare().setDisplay(Boolean.valueOf(Boolean.TRUE.equals(estateImpl.getAddress().isPublished())));
        property.getLocation().getLocality().getThoroughfare().setValue(estateImpl.getAddress().writeStreet());
        property.setFeatures(FACTORY.createFeedPropertiesPropertyFeatures());
        object10 = CountRooms.getAsInteger((EstateImpl)estateImpl);
        property.getFeatures().setRooms(Integer.valueOf(ImmobiliareItUtils.isValidRooms((Integer)object10) ? (Integer)object10 : 1));
        property.getFeatures().setPrice(FACTORY.createPriceType());
        property.getFeatures().getPrice().setCurrency(estateImpl.getCurrency());
        property.getFeatures().getPrice().setReserved(Boolean.valueOf(estateImpl.isHiddenPrices()));
        object9 = null;
        if (estateImpl.isHiddenPrices()) {
            object9 = BigInteger.ZERO;
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            object9 = RentExcludingServiceCharges.getAsBigInteger((EstateImpl)estateImpl);
            if (object9 == null) {
                object9 = RentIncludingServiceCharges.getAsBigInteger((EstateImpl)estateImpl);
            }
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            object9 = Lease.getAsBigInteger((EstateImpl)estateImpl);
            if (object9 == null) {
                object9 = LeasePerArea.getAsBigInteger((EstateImpl)estateImpl);
            }
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            object9 = RentFlatRate.getAsBigInteger((EstateImpl)estateImpl);
        } else if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            object9 = PurchasePrice.getAsBigInteger((EstateImpl)estateImpl);
        }
        property.getFeatures().getPrice().setValue((BigInteger)(object9 != null ? object9 : BigInteger.ZERO));
        BigInteger bigInteger3 = GrossArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = TotalArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = PlotArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = ResidentialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = CommercialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = SalesArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigInteger3 == null || bigInteger3.compareTo(BigInteger.ZERO) < 1) {
            bigInteger3 = CarParkingArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        property.getFeatures().setSize(FACTORY.createSizeType());
        property.getFeatures().getSize().setUnit(SizeUnit.M2);
        property.getFeatures().getSize().setValue(bigInteger3 != null ? bigInteger3 : BigInteger.ZERO);
        for (Object object822 : OpenEstateAttribGroup.DESCRIPTIONS.getAttributes()) {
            if (OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION.equals(object822) || (object7 = (ComplexStringAttrib)estateImpl.getAttribute((OpenEstateAttrib)object822)) == null) continue;
            for (String string4 : object7.getValueLanguages()) {
                object5 = StringUtils.trimToNull((String)object7.getValue(string4));
                if (StringUtils.isBlank((CharSequence)object5)) continue;
                try {
                    object4 = NationCode.fromValue((String)string4.toLowerCase());
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't create nation-code from: " + string4);
                    LOGGER.warn("> " + exception.getLocalizedMessage());
                    continue;
                }
                object2 = FACTORY.createLangtxt();
                object2.setLanguage((NationCode)object4);
                object2.setValue(OpenEstateUtils.serializeString((String)object5, (String)this.getXmlLineSeparator()));
                property.getFeatures().getDescription().add(object2);
                if (property.getFeatures().getDescription().size() >= 25) break;
            }
            if (!property.getFeatures().getDescription().isEmpty()) break;
        }
        if (property.getFeatures().getDescription().isEmpty()) {
            object3 = FACTORY.createLangtxt();
            object3.setLanguage(NationCode.IT);
            object3.setValue("");
            property.getFeatures().getDescription().add(object3);
        }
        if (this.isEnergyCertificateAppendedToDescription()) {
            object3 = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
            for (Langtxt langtxt : property.getFeatures().getDescription()) {
                void var21_39;
                object822 = langtxt.getLanguage().value().toLowerCase();
                object7 = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)new Locale(((String)object822).toLowerCase()), (String)this.getXmlLineSeparator());
                if (StringUtils.isBlank((CharSequence)object7)) continue;
                String string5 = StringUtils.trimToNull((String)langtxt.getValue());
                if (string5 == null) {
                    Object object6 = object7;
                } else {
                    String string6 = (String)object7 + (String)object3 + string5;
                }
                langtxt.setValue(StringUtils.trimToEmpty((String)var21_39));
            }
        }
        property.setExtraFeatures(FACTORY.createFeedPropertiesPropertyExtraFeatures());
        property.getExtraFeatures().setAirConditioning(AirConditioned.get((EstateImpl)estateImpl));
        property.getExtraFeatures().setBalcony(BalconyTerrace.get((EstateImpl)estateImpl));
        property.getExtraFeatures().setBathrooms(CountBathrooms.getAsBigInteger((EstateImpl)estateImpl));
        property.getExtraFeatures().setBedrooms(CountBedrooms.getAsBigInteger((EstateImpl)estateImpl));
        property.getExtraFeatures().setNumFloors(CountFloors.getAsBigInteger((EstateImpl)estateImpl));
        property.getExtraFeatures().setTerrace(BalconyTerrace.get((EstateImpl)estateImpl));
        object3 = BigInteger.ZERO;
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction()) && (bigInteger2 = CommonCharge.getAsBigInteger((EstateImpl)estateImpl)) != null) {
            object3 = ((BigInteger)object3).add(bigInteger2);
        }
        if (((BigInteger)object3).compareTo(BigInteger.ZERO) < 1) {
            BigInteger bigInteger4 = ServiceCharges.getAsBigInteger((EstateImpl)estateImpl);
            BigInteger bigInteger5 = HeatingCosts.getAsBigInteger((EstateImpl)estateImpl);
            object822 = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
            if (bigInteger4 != null) {
                object3 = ((BigInteger)object3).add(bigInteger4);
            }
            if (bigInteger5 != null && !Boolean.TRUE.equals(object822)) {
                object3 = ((BigInteger)object3).add(bigInteger5);
            }
        }
        if (((BigInteger)object3).compareTo(BigInteger.ZERO) >= 1) {
            property.getExtraFeatures().setAdditionalCosts(FACTORY.createAdditionalCostsType());
            property.getExtraFeatures().getAdditionalCosts().setValue((BigInteger)object3);
            property.getExtraFeatures().getAdditionalCosts().setCurrency(estateImpl.getCurrency());
        }
        if ((bigInteger = CountParkingSpaces.getAsBigInteger((EstateImpl)estateImpl)) != null && ((BigInteger)object3).compareTo(BigInteger.ZERO) >= 0) {
            property.getExtraFeatures().setGarage(FACTORY.createBox());
            if (((BigInteger)object3).compareTo(BigInteger.ZERO) == 0) {
                property.getExtraFeatures().getGarage().setValue(BigInteger.ZERO);
                property.getExtraFeatures().getGarage().setType(Box.BoxType.NO);
            } else {
                property.getExtraFeatures().getGarage().setValue(bigInteger);
                List list3 = CarParkingType.getAsList((EstateImpl)estateImpl);
                if (list3.contains(CarParkingType.Option.GARAGE) || list3.contains(CarParkingType.Option.DOUBLE_GARAGE)) {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.BOX);
                } else if (list3.contains(CarParkingType.Option.CARPORT) || list3.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.RIMESSA);
                } else {
                    property.getExtraFeatures().getGarage().setType(Box.BoxType.POSTO_AUTO);
                }
            }
        }
        if ((list2 = Kitchen.getAsList((EstateImpl)estateImpl)).contains(Kitchen.Option.OPEN_PLAN_KITCHEN)) {
            property.getExtraFeatures().setKitchen(org.openestate.io.immobiliare_it.xml.Kitchen.ABITABILE);
        } else if (list2.contains(Kitchen.Option.KITCHEN_NOOK)) {
            property.getExtraFeatures().setKitchen(org.openestate.io.immobiliare_it.xml.Kitchen.ANGOLO_COTTURA);
        } else if (list2.contains(Kitchen.Option.SMALL_KITCHEN)) {
            property.getExtraFeatures().setKitchen(org.openestate.io.immobiliare_it.xml.Kitchen.SEMI_ABITABILE);
        }
        object822 = TypeOfHeating.getAsList((EstateImpl)estateImpl);
        object7 = TypeOfBeaconing.getAsList((EstateImpl)estateImpl);
        if (object822.contains(TypeOfHeating.Option.INDEPENDENT)) {
            property.getExtraFeatures().setHeating(Heat.AUTONOMO);
        } else if (object7.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            property.getExtraFeatures().setHeating(Heat.TELERISCALDAMENTO);
        } else if (object822.contains(TypeOfHeating.Option.CENTRAL)) {
            property.getExtraFeatures().setHeating(Heat.CENTRALIZZATO);
        }
        Boolean bl = GardenUse.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            property.getExtraFeatures().setGarden(Garden.PRIVATO);
        } else if (Boolean.FALSE.equals(bl)) {
            property.getExtraFeatures().setGarden(Garden.NESSUNO);
        }
        Boolean bl2 = Lift.get((EstateImpl)estateImpl);
        if (!Boolean.TRUE.equals(bl2)) {
            bl2 = FreightElevator.get((EstateImpl)estateImpl);
        }
        property.getExtraFeatures().setElevator(bl2);
        Furnished.Option option = Furnished.get((EstateImpl)estateImpl);
        if (Furnished.Option.YES.equals((Object)option)) {
            property.getExtraFeatures().setFurniture(Furniture.ARREDATO);
        } else if (Furnished.Option.NO.equals((Object)option)) {
            property.getExtraFeatures().setFurniture(Furniture.NON_ARREDATO);
        } else if (Furnished.Option.PARTIAL.equals((Object)option)) {
            property.getExtraFeatures().setFurniture(Furniture.PARZIALMENTE_ARREDATO);
        }
        string4 = null;
        try {
            object5 = StringUtils.trimToNull((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
            string4 = object5 != null ? new BigDecimal((String)object5).toBigInteger() : null;
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Etagenzahl konnte nicht umgewandelt werden!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
        }
        if (string4 != null) {
            property.getExtraFeatures().setFloor(FACTORY.createFloor());
            property.getExtraFeatures().getFloor().setValue((BigInteger)((Object)string4));
            if (object14.contains(OpenEstateType.ATTIC_APARTMENT) || object14.contains(OpenEstateType.PENTHOUSE_APARTMENT)) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.ATTICO);
            } else if (object14.contains(OpenEstateType.GROUND_FLOOR_APARTMENT)) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.PIANO_TERRA);
            } else if (object14.contains(OpenEstateType.MEZZANINE)) {
                property.getExtraFeatures().getFloor().setType(Floor.FloorType.RIALZATO);
            }
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            property.getExtraFeatures().setRentContract(Rental.TRANSITORIO);
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            if (object14.contains(OpenEstateType.APARTMENT_SHARE_STUDENTS)) {
                property.getExtraFeatures().setRentContract(Rental.STUDENTI);
            } else {
                property.getExtraFeatures().setRentContract(Rental.CONCORDATO);
            }
        }
        property.getExtraFeatures().setSecurityAlarm(Boolean.valueOf(SecurityTechnology.hasOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.ALARM_SYSTEM)));
        property.getExtraFeatures().setNet(Boolean.valueOf(Technics.hasOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING)));
        property.getExtraFeatures().setFreeConditions(OpenEstateUtils.serializeString((String)PriceDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()), (String)this.getXmlLineSeparator()));
        object5 = Crane.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(object5)) {
            property.getExtraFeatures().setOverheadCrane(YesNoReady.YES);
        } else if (Boolean.FALSE.equals(object5)) {
            property.getExtraFeatures().setOverheadCrane(YesNoReady.NO);
        }
        property.getExtraFeatures().setBeamHeight(WarehouseHeight.getAsBigInteger((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        object4 = OfficeArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (object4 != null && ((BigInteger)object4).compareTo(BigInteger.ZERO) >= 1) {
            property.getExtraFeatures().setOfficeSize(FACTORY.createSizeType());
            property.getExtraFeatures().getOfficeSize().setUnit(SizeUnit.M2);
            property.getExtraFeatures().getOfficeSize().setValue((BigInteger)object4);
        }
        if ((object2 = PlotArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) != null && ((BigInteger)object2).compareTo(BigInteger.ZERO) >= 1) {
            property.getExtraFeatures().setExternalArea(FACTORY.createLandSizeType());
            property.getExtraFeatures().getExternalArea().setUnit(LandSizeUnit.M2);
            property.getExtraFeatures().getExternalArea().setValue((BigInteger)object2);
        }
        if (ImmobiliareItUtils.isValidYear((Integer)(n = BuildYear.getAsInteger((EstateImpl)estateImpl)))) {
            property.getExtraFeatures().setBuildYear(n);
        }
        if ((d = ConsumptionTotal.getAsDouble((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR)) != null && d > 0.0) {
            object = Available.get((EstateImpl)estateImpl);
            if (object == null) {
                Type.Option option2 = Type.get((EstateImpl)estateImpl);
                object = Type.Option.CONSUMPTION.equals((Object)option2);
            }
            property.getFeatures().setEnergyPerformance(FACTORY.createClassEnergyPerformance());
            property.getFeatures().getEnergyPerformance().setCertified((Boolean)object);
            property.getFeatures().getEnergyPerformance().setUnit(EnergyUnit.KWH_M2ANNO);
            property.getFeatures().getEnergyPerformance().setValue(NumberFormat.getNumberInstance(Locale.ENGLISH).format(d));
        }
        property.getFeatures().setEnergyClass(ClassEnergy.ESENTE);
        object = EfficiencyCategory.get((EstateImpl)estateImpl);
        if (EfficiencyCategory.Option.A_PLUS.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.A_PLUS);
        } else if (EfficiencyCategory.Option.A.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.A);
        } else if (EfficiencyCategory.Option.B.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.B);
        } else if (EfficiencyCategory.Option.C.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.C);
        } else if (EfficiencyCategory.Option.D.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.D);
        } else if (EfficiencyCategory.Option.E.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.E);
        } else if (EfficiencyCategory.Option.F.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.F);
        } else if (EfficiencyCategory.Option.G.equals(object)) {
            property.getFeatures().setEnergyClass(ClassEnergy.G);
        } else {
            object = OpenEstateUtils.getEnergyEfficiencyCategory((Number)d, (String)estateImpl.getAddress().getCountry());
            if (EfficiencyCategory.Option.A_PLUS.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.A_PLUS);
            } else if (EfficiencyCategory.Option.A.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.A);
            } else if (EfficiencyCategory.Option.B.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.B);
            } else if (EfficiencyCategory.Option.C.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.C);
            } else if (EfficiencyCategory.Option.D.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.D);
            } else if (EfficiencyCategory.Option.E.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.E);
            } else if (EfficiencyCategory.Option.F.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.F);
            } else if (EfficiencyCategory.Option.G.equals(object)) {
                property.getFeatures().setEnergyClass(ClassEnergy.G);
            } else {
                property.getFeatures().setEnergyClass(ClassEnergy.ESENTE);
                property.getFeatures().setEnergyPerformance(FACTORY.createClassEnergyPerformance());
                property.getFeatures().getEnergyPerformance().setCertified(Boolean.valueOf(false));
                property.getFeatures().getEnergyPerformance().setUnit(EnergyUnit.KWH_M2ANNO);
                property.getFeatures().getEnergyPerformance().setValue("0");
            }
        }
        Feed.Properties.Property.Pictures pictures = FACTORY.createFeedPropertiesPropertyPictures();
        Feed.Properties.Property.Blueprints blueprints = FACTORY.createFeedPropertiesPropertyBlueprints();
        Feed.Properties.Property.Videos videos = FACTORY.createFeedPropertiesPropertyVideos();
        String string7 = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string7 != null) {
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                if (estateAttachmentImpl == null || !estateAttachmentImpl.isImageType() && !estateAttachmentImpl.isVideoType() || (uRI = estateAttachmentImpl.getAbsoluteUrl(string7)) == null) continue;
                if (estateAttachmentImpl.isVideoType()) {
                    if (videos.getVideo().size() < 4) {
                        estateLinkProvider = FACTORY.createVideoProject();
                        estateLinkProvider.setType(VideoType.LOCAL);
                        estateLinkProvider.setValue(uRI.toString());
                        videos.getVideo().add(estateLinkProvider);
                    }
                } else if (estateAttachmentImpl.isImageType()) {
                    estateLinkProvider = FACTORY.createPictureExtended();
                    estateLinkProvider.setUrl(uRI.toString());
                    if (EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType()) && blueprints.getBlueprint().size() < 10) {
                        estateLinkProvider.setPosition(BigInteger.valueOf(blueprints.getBlueprint().size() + 1));
                        blueprints.getBlueprint().add(estateLinkProvider);
                    } else if (pictures.getPictureUrlAndPicture().size() < 15) {
                        estateLinkProvider.setPosition(BigInteger.valueOf(pictures.getPictureUrlAndPicture().size() + 1));
                        pictures.getPictureUrlAndPicture().add(estateLinkProvider);
                    }
                }
                if (pictures.getPictureUrlAndPicture().size() < 15 || blueprints.getBlueprint().size() < 10 || videos.getVideo().size() < 4) continue;
                break;
            }
        }
        if (!estateImpl.getLinks().isEmpty() && videos.getVideo().size() < 4) {
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getLinks()) {
                URI uRI2;
                if (!estateAttachmentImpl.isProviderLink() || !EstateLinkProvider.VIDEO_YOUTUBE_COM.equals((Object)(estateLinkProvider = (uRI = estateAttachmentImpl.getProviderLink()).getProvider())) || StringUtils.isBlank((CharSequence)uRI.getLinkId()) || (uRI2 = estateLinkProvider.getUrlFromLinkId(uRI.getLinkId())) == null) continue;
                VideoProject videoProject = FACTORY.createVideoProject();
                videoProject.setType(VideoType.REMOTE);
                videoProject.setValue(uRI2.toString());
                videos.getVideo().add(videoProject);
                if (videos.getVideo().size() < 4) continue;
                break;
            }
        }
        if (!pictures.getPictureUrlAndPicture().isEmpty()) {
            property.setPictures(pictures);
        }
        if (!blueprints.getBlueprint().isEmpty()) {
            property.setBlueprints(blueprints);
        }
        if (!videos.getVideo().isEmpty()) {
            property.setVideos(videos);
        }
        return property;
    }

    protected Feed convertToXmlObject(AgencyImpl agencyImpl) {
        Feed feed = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("no agency was provided!");
            return feed;
        }
        feed.getMetadata().setPublisher(this.convertAgent(agencyImpl.getAgent()));
        feed.setProperties(FACTORY.createFeedProperties());
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                AgentContactImpl agentContactImpl = null;
                String string = estateImpl.getContactId();
                if (string != null && agencyImpl.getContacts().containsKey(string)) {
                    agentContactImpl = (AgentContactImpl)agencyImpl.getContacts().get(string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                Feed.Properties.Property property = this.convertEstate(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                if (!arrayList.isEmpty() || property == null) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                property.setOperation(Operation.WRITE);
                feed.getProperties().getProperty().add(property);
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return feed;
    }

    protected Feed convertToXmlObject(TransferImpl transferImpl) {
        Feed feed = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn("no transferable agent found!");
        } else {
            Feed.Properties.Property property;
            TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
            feed.getMetadata().setPublisher(this.convertAgent(transferAgencyImpl.getAgent()));
            feed.setProperties(FACTORY.createFeedProperties());
            for (Object object : transferAgencyImpl.getEstatesToSave()) {
                try {
                    property = null;
                    String string = object.getContactId();
                    if (string != null && transferAgencyImpl.getContacts().containsKey(string)) {
                        property = (AgentContactImpl)transferAgencyImpl.getContacts().get(string);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    Feed.Properties.Property property2 = this.convertEstate((EstateImpl)object, transferAgencyImpl.getAgent(), (AgentContactImpl)property, (List<String>)arrayList);
                    if (!arrayList.isEmpty() || property2 == null) {
                        this.putErrors(object.getId(), arrayList);
                        continue;
                    }
                    property2.setOperation(Operation.WRITE);
                    feed.getProperties().getProperty().add(property2);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
            for (Object object : transferAgencyImpl.getEstateIdsToRemove()) {
                try {
                    property = FACTORY.createFeedPropertiesProperty();
                    property.setOperation(Operation.DELETE);
                    property.setUniqueId((String)object);
                    property.setDateUpdated(Calendar.getInstance());
                    property.getDateUpdated().setTime(this.now);
                    feed.getProperties().getProperty().add(property);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return feed;
    }

    protected Feed createRoot() {
        Feed feed = FACTORY.createFeed();
        feed.setVersion(Version.fromValue((String)ImmobiliareItUtils.VERSION.toReadableVersion()));
        feed.setMetadata(FACTORY.createFeedMetadata());
        feed.getMetadata().setBuildDate(Calendar.getInstance());
        feed.getMetadata().getBuildDate().setTime(this.now);
        feed.getMetadata().setMultipage(FACTORY.createFeedMetadataMultipage());
        feed.getMetadata().getMultipage().setCurrent(BigInteger.ONE);
        feed.getMetadata().getMultipage().setLast(BigInteger.ONE);
        return feed;
    }

    protected ImmobiliareItDocument createXmlDocument(Feed feed) throws ParserConfigurationException, JAXBException {
        return ImmobiliareItDocument.newDocument((Feed)feed);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    static {
        ACTIONS.put(OpenEstateAction.RENT, Transaction.RENT);
        ACTIONS.put(OpenEstateAction.LEASE, Transaction.RENT);
        ACTIONS.put(OpenEstateAction.EMPHYTEUSIS, Transaction.RENT);
        ACTIONS.put(OpenEstateAction.SHORT_TERM_RENT, Transaction.RENT);
        ACTIONS.put(OpenEstateAction.PURCHASE, Transaction.SALE);
        CATEGORIES = new EnumMap<OpenEstateType, Category>(OpenEstateType.class);
        CATEGORIES.put(OpenEstateType.GENERAL_COMMERCIAL, Category.COMMERCIALE);
        CATEGORIES.put(OpenEstateType.GENERAL_PIECE_OF_LAND, Category.COMMERCIALE);
        CATEGORIES.put(OpenEstateType.GENERAL_AGRICULTURE, Category.COMMERCIALE);
        CATEGORIES.put(OpenEstateType.GENERAL_PARKING, Category.RESIDENZIALE);
        CATEGORIES.put(OpenEstateType.GENERAL_RESIDENCE, Category.RESIDENZIALE);
        TYPES = new EnumMap<Category, Map<OpenEstateType, PropertyType>>(Category.class);
        EnumMap<OpenEstateType, PropertyType> enumMap = new EnumMap<OpenEstateType, PropertyType>(OpenEstateType.class);
        enumMap.put(OpenEstateType.GENERAL_PIECE_OF_LAND, PropertyType.TERRENO);
        enumMap.put(OpenEstateType.GENERAL_COMMERCIAL, PropertyType.IMMOBILE);
        TYPES.put(Category.COMMERCIALE, enumMap);
        enumMap = new EnumMap(OpenEstateType.class);
        enumMap.put(OpenEstateType.RESIDENCE, PropertyType.APPARTAMENTO);
        enumMap.put(OpenEstateType.ATTIC_APARTMENT, PropertyType.ATTICO);
        enumMap.put(OpenEstateType.TERRACE_APARTMENT, PropertyType.ATTICO);
        enumMap.put(OpenEstateType.PENTHOUSE_APARTMENT, PropertyType.MANSARDA);
        enumMap.put(OpenEstateType.GENERAL_PARKING, PropertyType.GARAGE);
        enumMap.put(OpenEstateType.SPECIAL_HOUSE, PropertyType.PALAZZO);
        enumMap.put(OpenEstateType.HOUSE, PropertyType.STABILE);
        enumMap.put(OpenEstateType.COUNTRY_HOUSE, PropertyType.RUSTICO);
        enumMap.put(OpenEstateType.FARMHOUSE, PropertyType.CASALE);
        enumMap.put(OpenEstateType.VILLA, PropertyType.VILLA);
        enumMap.put(OpenEstateType.LOFT, PropertyType.LOFT);
        enumMap.put(OpenEstateType.GENERAL_RESIDENCE, PropertyType.OTHER);
        enumMap.put(OpenEstateType.TERRACED_HOUSE, PropertyType.VILLETTA_A_SCHIERA);
        TYPES.put(Category.RESIDENZIALE, enumMap);
        enumMap = new EnumMap(OpenEstateType.class);
        enumMap.put(OpenEstateType.FARM, PropertyType.AGRITURISMO);
        enumMap.put(OpenEstateType.BUNGALOW, PropertyType.BUNGALOW);
        enumMap.put(OpenEstateType.CHALET, PropertyType.CHALET);
        enumMap.put(OpenEstateType.ALPINE_HUT, PropertyType.BAITA);
        enumMap.put(OpenEstateType.HOTEL, PropertyType.HOTEL);
        enumMap.put(OpenEstateType.HOSTEL, PropertyType.HOTEL);
        enumMap.put(OpenEstateType.LEISURE_SPORTS_FACILITY, PropertyType.PARCO_VACANZE);
        enumMap.put(OpenEstateType.ROOM, PropertyType.STANZA);
        enumMap.put(OpenEstateType.COTTAGE, PropertyType.CASA_PER_FERIE_GRUPPI);
        TYPES.put(Category.VACANZE, enumMap);
        COMMERCIAL_TYPES = new EnumMap<PropertyType, Map<OpenEstateType, PropertyTypeBusiness>>(PropertyType.class);
        EnumMap<OpenEstateType, PropertyTypeBusiness> enumMap2 = new EnumMap<OpenEstateType, PropertyTypeBusiness>(OpenEstateType.class);
        enumMap2.put(OpenEstateType.SHOPPING_CENTER, PropertyTypeBusiness.CENTRO_COMMERCIALE);
        enumMap2.put(OpenEstateType.GENERAL_AGRICULTURE, PropertyTypeBusiness.AZIENDA_AGRICOLA);
        enumMap2.put(OpenEstateType.RESTAURANT, PropertyTypeBusiness.RISTORANTE);
        enumMap2.put(OpenEstateType.RESTAURANT_BAR, PropertyTypeBusiness.BAR);
        enumMap2.put(OpenEstateType.PIZZERIA, PropertyTypeBusiness.PIZZERIA);
        enumMap2.put(OpenEstateType.DISCOTHEQUE, PropertyTypeBusiness.DISCOTECA);
        enumMap2.put(OpenEstateType.GUEST_ROOM, PropertyTypeBusiness.BED_AND_BREAKFAST);
        enumMap2.put(OpenEstateType.GUESTHOUSE, PropertyTypeBusiness.PENSIONE);
        enumMap2.put(OpenEstateType.PREMISE, PropertyTypeBusiness.NEGOZIO);
        enumMap2.put(OpenEstateType.FITNESS_STUDIO, PropertyTypeBusiness.PALESTRA);
        enumMap2.put(OpenEstateType.TANNING_SALON, PropertyTypeBusiness.ESTETICA_SOLARIUM);
        enumMap2.put(OpenEstateType.WORKSHOP, PropertyTypeBusiness.AUTO_OFFICINA);
        COMMERCIAL_TYPES.put(PropertyType.ATTIVIT\u00c0, enumMap2);
        enumMap2 = new EnumMap(OpenEstateType.class);
        enumMap2.put(OpenEstateType.RESIDENTIAL_GROUND, PropertyTypeBusiness.RESIDENZIALE);
        enumMap2.put(OpenEstateType.GENERAL_PIECE_OF_LAND, PropertyTypeBusiness.RESIDENZIALE);
        enumMap2.put(OpenEstateType.COMMERCIAL_GROUND, PropertyTypeBusiness.COMMERCIALE);
        enumMap2.put(OpenEstateType.INDUSTRIAL_GROUND, PropertyTypeBusiness.INDUSTRIALE);
        enumMap2.put(OpenEstateType.AGRICULTURAL_FORESTRY_GROUND, PropertyTypeBusiness.AGRICOLO);
        COMMERCIAL_TYPES.put(PropertyType.TERRENO, enumMap2);
        enumMap2 = new EnumMap(OpenEstateType.class);
        enumMap2.put(OpenEstateType.HALL_WAREHOUSE, PropertyTypeBusiness.CAPANNONE);
        enumMap2.put(OpenEstateType.GENERAL_AGRICULTURE, PropertyTypeBusiness.AZIENDA_AGRICOLA);
        enumMap2.put(OpenEstateType.GENERAL_PARKING, PropertyTypeBusiness.GARAGE);
        enumMap2.put(OpenEstateType.PREMISE, PropertyTypeBusiness.NEGOZIO);
        enumMap2.put(OpenEstateType.OFFICE_SURGERY, PropertyTypeBusiness.UFFICIO);
        enumMap2.put(OpenEstateType.HOUSE, PropertyTypeBusiness.STABILE);
        enumMap2.put(OpenEstateType.INDUSTRIAL_WAREHOUSE, PropertyTypeBusiness.CAPANNONE_INDUSTRIALE);
        enumMap2.put(OpenEstateType.EXHIBITION_AREA, PropertyTypeBusiness.SHOWROOM);
        enumMap2.put(OpenEstateType.HOSPITALITY_INDUSTRY, PropertyTypeBusiness.ALBERGO);
        enumMap2.put(OpenEstateType.GENERAL_COMMERCIAL, PropertyTypeBusiness.ALTRO);
        enumMap2.put(OpenEstateType.RIDING_ESTATE, PropertyTypeBusiness.SCUDERIA);
        COMMERCIAL_TYPES.put(PropertyType.IMMOBILE, enumMap2);
        TERRAINS = new EnumMap<OpenEstateType, TerrainType>(OpenEstateType.class);
        TERRAINS.put(OpenEstateType.CULTIVATION, TerrainType.SEMINATIVO);
        TERRAINS.put(OpenEstateType.VINICULTURE, TerrainType.VIGNETO);
    }
}

