/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.DbContactsHandler;
import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolAppUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolPermissionPanel;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactAddressPanel;
import com.openindex.openestate.tool.agency.AgencyContactDialog;
import com.openindex.openestate.tool.agency.AgencyContactViewTask;
import com.openindex.openestate.tool.agency.AgencyEstateStatusTask;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyEstateViewTask;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectLogsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.extensions.ContactViewExtension;
import com.openindex.openestate.tool.agency.extensions.EstateTableExtension;
import com.openindex.openestate.tool.db.DbGroup;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.extensions.DbExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import com.openindex.openestate.tool.gui.AbstractMainViewTab;
import com.openindex.openestate.tool.gui.DefaultAddressPanel;
import com.openindex.openestate.tool.gui.DefaultTextArea;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyContactViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyContactViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyContactViewPanel.class);
    private static final String ESTATE_TABLE_ID = "AgencyContactViewPanel.EstateTable";
    private DbAgencyContact currentContact = null;
    private long nextContactId = 0L;
    private long prevContactId = 0L;
    private boolean mayEditContact = false;
    private boolean mayRemoveContact = false;
    private List<ContactViewExtension> addons;
    private AddressPanel addressPanel;
    private EstatePanel estatePanel;
    private NotesPanel notesPanel;
    private PermissionsTab permissionsPanel;
    private AbstractI18nAction submitAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;
    private AbstractI18nAction viewNextAction;
    private AbstractI18nAction viewPrevAction;

    private AgencyContactViewPanel() {
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.submitAction = this.createDefaultSubmitAction(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT));
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.viewNextAction = this.createDefaultViewNextAction();
        this.viewPrevAction = this.createDefaultViewPreviousAction();
        this.showActionsAction = this.createDefaultShowActionsAction(AgencyPlugin.getResourceIcon("agent_family.png", 16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewPrevAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.viewNextAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.submitAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected void buildMainComponentTabs(JTabbedPane jTabbedPane) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        this.addressPanel = (AddressPanel)AgencyContactViewPanel.addTab((AbstractMainViewTab)new AddressPanel(), (JTabbedPane)jTabbedPane);
        this.estatePanel = AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES) ? (EstatePanel)AgencyContactViewPanel.addTab((AbstractMainViewTab)new EstatePanel(), (JTabbedPane)jTabbedPane) : null;
        for (ContactViewExtension contactViewExtension : this.addons) {
            try {
                AbstractTab[] abstractTabArray = contactViewExtension.createTabs();
                if (ArrayUtils.isEmpty((Object[])abstractTabArray)) continue;
                for (AbstractTab abstractTab : abstractTabArray) {
                    AgencyContactViewPanel.addTab((AbstractMainViewTab)abstractTab, (JTabbedPane)jTabbedPane);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load addon tab!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.notesPanel = (NotesPanel)AgencyContactViewPanel.addTab((AbstractMainViewTab)new NotesPanel(), (JTabbedPane)jTabbedPane);
        this.permissionsPanel = null;
        if (immoToolProject != null && immoToolProject.isRemoteProject()) {
            this.permissionsPanel = (PermissionsTab)AgencyContactViewPanel.addTab((AbstractMainViewTab)new PermissionsTab(), (JTabbedPane)jTabbedPane);
        }
    }

    public static AgencyContactViewPanel createTab() {
        return AgencyContactViewPanel.createTab(null);
    }

    public static AgencyContactViewPanel createTab(DbAgencyContact dbAgencyContact) {
        AgencyContactViewPanel agencyContactViewPanel = new AgencyContactViewPanel();
        agencyContactViewPanel.setContact(dbAgencyContact);
        return agencyContactViewPanel;
    }

    protected void doCopy() {
        if (this.currentContact == null || this.currentContact.id < 1L) {
            return;
        }
        if (!this.mayEditContact) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), true));
    }

    protected void doLoadInBackground(Connection connection) {
        this.nextContactId = 0L;
        this.prevContactId = 0L;
        if (this.currentContact == null || this.currentContact.id < 1L) {
            return;
        }
        try {
            long[] lArray = AgencyPlugin.getDbAgencyExtension().getContactsHandler().getContactIds(connection);
            int n = ArrayUtils.indexOf((long[])lArray, (long)this.currentContact.id);
            if (n > 0) {
                this.prevContactId = lArray[n - 1];
            }
            if (n + 1 < lArray.length) {
                this.nextContactId = lArray[n + 1];
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load previous & next dataset!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    private void doEstateRefresh() {
        if (this.estatePanel == null) {
            return;
        }
        try {
            this.estatePanel.load(this.currentContact);
            if (this.estatePanel.isLoadedInBackground()) {
                this.setButtonsEnabled(false);
                ImmoToolUtils.executeTask((ImmoToolTask)new EstateRefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload properties for contact person!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload properties for contact person!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doEstateSetStatus(DbAgencyObject.Status status) {
        if (this.estatePanel == null) {
            return;
        }
        if (this.estatePanel.getTable().getSelectedRowCount() < 1) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : this.estatePanel.getTable().getSelectedRows()) {
            int n2 = this.estatePanel.getTable().convertRowIndexToModel(n);
            arrayList.add(this.estatePanel.getTable().getEstateIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to change the status of the selected properties to {0}?", (Object)('\"' + status.getTranslation() + '\"')), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler = AgencyPlugin.getDbAgencyExtension().getObjectLogsHandler();
        ImmoToolTaskDialog.showDialog((ImmoToolTask)new EstateSetStatusTask(lArray, status, immoToolProject, dbAgencyObjectsHandler, dbAgencyObjectLogsHandler), (Window)ImmoToolEnvironment.getFrame());
    }

    private void doEstateShowActions(Component component, int n, int n2) {
        if (this.estatePanel == null) {
            return;
        }
        if (this.estatePanel.getTable().getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new EstateShowTabAction()));
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("change status")));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
        jMenu.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS));
        for (DbAgencyObject.Status status : DbAgencyObject.Status.values()) {
            jMenu.add((Action)((Object)new EstateSetStatusAction(status)));
        }
        jPopupMenu.add(jMenu);
        ArrayList arrayList = new ArrayList();
        for (int n3 : this.estatePanel.getTable().getSelectedRows()) {
            int n4 = this.estatePanel.getTable().convertRowIndexToModel(n3);
            arrayList.add(this.estatePanel.getTable().getEstateIdAt(n4));
        }
        Long[] longArray = arrayList.toArray(new Long[0]);
        int n5 = 0;
        for (EstateTableExtension estateTableExtension : this.estatePanel.getTable().getAddons()) {
            Object[] objectArray = estateTableExtension.getActions(longArray);
            if (!ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (n5 == 0) {
                    jPopupMenu.addSeparator();
                    n5 = 1;
                }
                jPopupMenu.add(new JMenuItem((Action)object));
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    private void doEstateShowTab() {
        if (this.estatePanel == null) {
            return;
        }
        int n = this.estatePanel.getTable().getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = this.estatePanel.getTable().convertRowIndexToModel(n);
        long l = this.estatePanel.getTable().getEstateIdAt(n2);
        ImmoToolUtils.executeTask((ImmoToolTask)new AgencyEstateViewTask(ImmoToolProject.getAppDbDriver(), l));
    }

    protected void doHelp() {
        ImmoToolAppUtils.showManual((String)"agency.contacts.form", null);
    }

    public void doRefresh() {
        if (this.currentContact != null && this.currentContact.id > 0L) {
            this.setContact(this.currentContact);
            this.loadInBackground(ImmoToolProject.getAppDbDriver());
        }
    }

    protected void doRemove() {
        if (this.currentContact == null || this.currentContact.id < 1L) {
            return;
        }
        if (!this.mayRemoveContact) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove contact person {0}?", (Object)("#" + this.currentContact.id)), (Component)((Object)this));
        if (!bl) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new RemoveTask());
    }

    protected void doShowActions(Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)this.createDefaultCopyAction(this.currentContact != null && this.currentContact.id > 0L && AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT)));
        jPopupMenu.add((Action)this.createDefaultRemoveAction(this.currentContact != null && this.currentContact.id > 0L && this.mayRemoveContact));
        boolean bl = false;
        for (ContactViewExtension contactViewExtension : this.addons) {
            Object[] objectArray = contactViewExtension.createActionMenuItems(this.currentContact);
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!bl) {
                    bl = true;
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)this.notesPanel.notesField.getPrintAction());
        jPopupMenu.show(component, n, n2);
    }

    protected void doSubmit() {
        if (!this.mayEditContact) {
            ImmoToolUtils.showMessageWarningDialog((String)I18N.tr("Access denied!"), (Component)((Object)this));
            return;
        }
        if (!this.validateTabs()) {
            return;
        }
        this.setButtonsEnabled(false);
        ImmoToolUtils.executeTask((ImmoToolTask)new SubmitTask(this.getTabs(), false));
    }

    protected void doViewNext() {
        if (this.nextContactId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyContactViewTask(ImmoToolProject.getAppDbDriver(), this.nextContactId, this));
        }
    }

    protected void doViewPrevious() {
        if (this.prevContactId > 0L) {
            this.setButtonsEnabled(false);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyContactViewTask(ImmoToolProject.getAppDbDriver(), this.prevContactId, this));
        }
    }

    public long getCurrentContactId() {
        return this.currentContact != null ? this.currentContact.id : 0L;
    }

    protected Icon getHeaderIcon() {
        return AgencyPlugin.getResourceIcon("agent_family.png", 32);
    }

    protected String getHeaderTitle() {
        long l = this.getCurrentContactId();
        return l > 0L ? StringUtils.capitalize((String)I18N.tr("contact person")) + " #" + l : StringUtils.capitalize((String)I18N.tr("new contact person"));
    }

    public String getTabTitle() {
        long l = this.getCurrentContactId();
        return l > 0L ? StringUtils.capitalize((String)I18N.tr("contact person")) + " #" + l : StringUtils.capitalize((String)I18N.tr("new contact person"));
    }

    protected void init() {
        super.init();
        this.addons = new ArrayList<ContactViewExtension>();
        try {
            this.addons.addAll(AgencyPluginUtils.getContactViewExtensions());
        }
        catch (Exception exception) {
            LOGGER.warn("Can't load addons!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.submitAction.setEnabled(bl && this.mayEditContact);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl);
        this.viewNextAction.setEnabled(bl && this.nextContactId > 0L);
        this.viewPrevAction.setEnabled(bl && this.prevContactId > 0L);
        if (this.estatePanel != null) {
            this.estatePanel.estateActionsAction.setEnabled(bl && this.estatePanel.getTable().getSelectedRowCount() > 0);
            this.estatePanel.estateRefreshAction.setEnabled(bl);
        }
    }

    public void setContact(DbAgencyContact dbAgencyContact) {
        this.currentContact = dbAgencyContact != null ? dbAgencyContact : new DbAgencyContact();
        this.nextContactId = 0L;
        this.prevContactId = 0L;
        this.mayEditContact = AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT);
        this.mayRemoveContact = AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_REMOVE);
        if (this.currentContact.permission != null) {
            AbstractMainViewTab[] abstractMainViewTabArray = ImmoToolProject.getAppUser();
            this.mayEditContact = this.mayEditContact && this.currentContact.permission.canWrite((DbUser)abstractMainViewTabArray, this.currentContact.ownerUserId, this.currentContact.ownerGroupId);
            this.mayRemoveContact = this.mayRemoveContact && this.currentContact.permission.canDelete((DbUser)abstractMainViewTabArray, this.currentContact.ownerUserId, this.currentContact.ownerGroupId);
        }
        for (AbstractMainViewTab abstractMainViewTab : this.getTabs()) {
            int n = this.indexOf(abstractMainViewTab);
            if (n < 0) continue;
            this.getTabbedPane().setEnabledAt(n, false);
            try {
                ((AbstractTab)abstractMainViewTab).load(this.currentContact);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load tab '" + abstractMainViewTab.getTabTitle() + "'!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        this.updateLocalization();
    }

    private class SubmitTask
    extends ImmoToolTask<Boolean, Void> {
        private final AbstractMainViewTab[] tabs;
        private final boolean saveAsCopy;

        private SubmitTask(AbstractMainViewTab[] abstractMainViewTabArray, boolean bl) {
            this.tabs = abstractMainViewTabArray;
            this.saveAsCopy = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            Boolean bl;
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            Connection connection = null;
            try {
                if (this.saveAsCopy) {
                    ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id = 0L;
                }
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    ((AbstractTab)abstractMainViewTab).save(AgencyContactViewPanel.this.currentContact);
                }
                connection = ImmoToolProject.getAppDbConnection();
                dbAgencyContactsHandler.saveContact(connection, AgencyContactViewPanel.this.currentContact);
                for (AbstractMainViewTab abstractMainViewTab : this.tabs) {
                    ((AbstractTab)abstractMainViewTab).saveFinished(connection, immoToolProject, AgencyContactViewPanel.this.currentContact);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
            JdbcUtils.closeQuietly((Connection)connection);
            return bl;
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't save contact person!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyContactViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyContactViewPanel.this.doRefresh();
        }
    }

    private class RemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            final long l = ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id;
            Connection connection = null;
            try {
                Object object;
                connection = ImmoToolProject.getAppDbConnection();
                long[] lArray = dbAgencyObjectsHandler.getObjectIds(connection, l);
                if (lArray.length > 0) {
                    object = I18N.trn("{1} property is assigned to contact person {0}!", "{1} properties are assigned to contact person {0}!", (long)lArray.length, (Object)('\"' + ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.item.writePersonFullName() + '\"'), (Object)lArray.length);
                    AgencyContactDialog.Filter filter = new AgencyContactDialog.Filter(){

                        @Override
                        public boolean canLoadIntoSelection(DbAgencyContact dbAgencyContact) {
                            return dbAgencyContact.id != l;
                        }
                    };
                    Long l2 = AgencyContactDialog.showDialog(connection, (DbContactsHandler)dbAgencyContactsHandler, filter, (String)(object = (String)object + " " + I18N.tr("Please select another contact person, who will maintain the unassigned properties.")), (Window)ImmoToolEnvironment.getFrame());
                    if (l2 == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    dbAgencyObjectsHandler.setObjectContactId(connection, lArray, l2);
                }
                dbAgencyContactsHandler.removeContact(connection, l);
                object = true;
                return object;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't delete contact person!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyContactViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            ImmoToolAppUtils.removeTab((Component)((Object)AgencyContactViewPanel.this), (boolean)true);
        }
    }

    private class EstateRefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private EstateRefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                AgencyContactViewPanel.this.estatePanel.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void finished() {
            super.finished();
            AgencyContactViewPanel.this.setButtonsEnabled(true);
        }
    }

    private class EstateRefreshAction
    extends AbstractI18nAction {
        private EstateRefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactViewPanel.this.doEstateRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class PermissionsTab
    extends AbstractTab {
        private ImmoToolPermissionPanel form;
        private boolean loaded = false;

        private PermissionsTab() {
            this.build();
        }

        private void build() {
            this.form = new ImmoToolPermissionPanel();
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)this.form);
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public void doLoadInBackground(Connection connection) throws Exception {
            this.loaded = false;
            try {
                DbExtension dbExtension = ImmoToolProject.getAppDbExtension();
                DbUser dbUser = ImmoToolProject.getAppUser();
                if (AgencyContactViewPanel.this.currentContact != null && ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id > 0L) {
                    this.form.setPermission(((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.ownerUserId, ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.ownerGroupId, ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.permission);
                } else {
                    this.form.setPermission(dbUser != null ? dbUser.id : 0L, 0L, null);
                }
                if (dbExtension != null) {
                    this.form.load(connection, dbExtension.getUserHandler(), dbUser, dbExtension.getBaseGroupName());
                }
                this.loaded = true;
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load permissions!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
        }

        public String getTabTitle() {
            return this.form.getTitle();
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbAgencyContact dbAgencyContact) {
            this.loaded = false;
            this.form.setPermission(0L, 0L, null);
        }

        @Override
        public void save(DbAgencyContact dbAgencyContact) {
            DbGroup dbGroup;
            dbAgencyContact.permission = this.form.getSelectedPermission();
            DbUser dbUser = this.form.getSelectedOwner();
            if (dbUser != null) {
                dbAgencyContact.ownerUserId = dbUser.id;
            }
            if ((dbGroup = this.form.getSelectedGroup()) != null) {
                dbAgencyContact.ownerGroupId = dbGroup.id;
            }
        }
    }

    private final class NotesPanel
    extends AbstractTab {
        private ModificationHandler modificationHandler;
        private JXTitledSeparator title;
        private DefaultTextArea notesField;

        private NotesPanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.modificationHandler = ImmoToolUtils.createModificationHandler();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.notesField = new DefaultTextArea();
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.notesField.createScrollPane(), "Center");
        }

        public DefaultTextArea getField() {
            return this.notesField;
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("notes"));
        }

        public boolean isTabModified() {
            return this.modificationHandler.isModified();
        }

        @Override
        public void load(DbAgencyContact dbAgencyContact) {
            this.notesField.setText(dbAgencyContact != null ? StringUtils.trimToEmpty((String)dbAgencyContact.notes) : "");
            this.notesField.setCaretPosition(0);
            this.modificationHandler.clear();
            this.modificationHandler.putValue((JComponent)this.notesField);
        }

        @Override
        public void save(DbAgencyContact dbAgencyContact) {
            dbAgencyContact.notes = this.notesField.getText().trim();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("notes about the contact person")));
        }
    }

    private class EstateShowTabAction
    extends AbstractI18nAction {
        private EstateShowTabAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon("agent_estates.png", 16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactViewPanel.this.doEstateShowTab();
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class EstateShowActionsAction
    extends AbstractI18nAction {
        private EstateShowActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)actionEvent.getSource();
                AgencyContactViewPanel.this.doEstateShowActions(component, 0, component.getSize().height);
            } else {
                AgencyContactViewPanel.this.doEstateShowActions(null, 0, 0);
            }
        }

        protected final void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show menu with further actions."));
        }
    }

    private class EstateSetStatusTask
    extends AgencyEstateStatusTask {
        private EstateSetStatusTask(long[] lArray, DbAgencyObject.Status status, ImmoToolProject immoToolProject, DbAgencyObjectsHandler dbAgencyObjectsHandler, DbAgencyObjectLogsHandler dbAgencyObjectLogsHandler) {
            super(lArray, status, immoToolProject.getDbDriver(), immoToolProject.getUser(), dbAgencyObjectsHandler, dbAgencyObjectLogsHandler);
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't change status of selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }

        protected void finished() {
            super.finished();
            AgencyContactViewPanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            AgencyContactViewPanel.this.doEstateRefresh();
        }
    }

    private class EstateSetStatusAction
    extends AbstractI18nAction {
        private final DbAgencyObject.Status status;

        private EstateSetStatusAction(DbAgencyObject.Status status) {
            this.status = status;
            if (DbAgencyObject.Status.PUBLISHED.equals((Object)status)) {
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS_PUBLISHING));
            } else {
                this.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.PROPERTIES_EDIT_STATUS));
            }
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyContactViewPanel.this.doEstateSetStatus(this.status);
        }

        protected final void updateLocalization() {
            this.setName(this.status.getTranslation());
        }
    }

    private class EstateTable
    extends AgencyEstateTable<AgencyEstateTable.Row> {
        private EstateTable() {
            super(AgencyContactViewPanel.ESTATE_TABLE_ID);
        }

        protected void doShowActions(int n, int n2) {
            AgencyContactViewPanel.this.doEstateShowActions((Component)((Object)this), n, n2);
        }

        protected void doSelect() {
            if (AgencyContactViewPanel.this.estatePanel != null) {
                AgencyContactViewPanel.this.estatePanel.estateActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            }
        }

        protected void doView() {
            AgencyContactViewPanel.this.doEstateShowTab();
        }
    }

    private final class EstatePanel
    extends AbstractTab {
        private JXTitledSeparator title;
        private EstateTable table;
        private EstateRefreshAction estateRefreshAction;
        private EstateShowActionsAction estateActionsAction;
        private boolean loaded = false;

        private EstatePanel() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.estateRefreshAction = new EstateRefreshAction();
            this.estateActionsAction = new EstateShowActionsAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.title, (Action[])new Action[]{this.estateRefreshAction, this.estateActionsAction});
            this.table = new EstateTable();
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doLoadInBackground(Connection connection) {
            this.loaded = false;
            try {
                if (AgencyContactViewPanel.this.currentContact == null || ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id < 1L) {
                    this.loaded = true;
                    this.table.setEnabled(true);
                    return;
                }
                DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
                DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
                Map map = dbLanguagesHandler.getLanguageMap(connection);
                long[] lArray = dbAgencyObjectsHandler.getObjectIds(connection, ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id);
                DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, lArray);
                dbAgencyObjectsHandler.loadObjectAttribs(connection, dbObjectArray, map);
                dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, map);
                for (DbObject dbObject : dbObjectArray) {
                    DbAgencyObject dbAgencyObject = (DbAgencyObject)dbObject;
                    this.table.addRow(new AgencyEstateTable.Row(dbAgencyObject));
                }
                this.loaded = true;
                this.table.setEnabled(true);
            }
            catch (Exception exception) {
                if (AgencyContactViewPanel.this.currentContact != null) {
                    LOGGER.warn("Can't load properties for contact person #" + ((AgencyContactViewPanel)AgencyContactViewPanel.this).currentContact.id + "!");
                } else {
                    LOGGER.warn("Can't load properties for empty contact person!");
                }
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.loaded = false;
            }
            finally {
                this.updateLocalization();
            }
        }

        public EstateTable getTable() {
            return this.table;
        }

        public boolean isLoadedInBackground() {
            return true;
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("properties"));
        }

        public boolean isTabEnabled() {
            return this.loaded;
        }

        @Override
        public void load(DbAgencyContact dbAgencyContact) {
            this.table.setEnabled(false);
            this.table.setAutoCreateColumnsFromModel(false);
            this.table.clearRows();
            this.estateActionsAction.setEnabled(false);
        }

        @Override
        public void save(DbAgencyContact dbAgencyContact) {
        }

        protected void updateLocalization() {
            super.updateLocalization();
            String string = StringUtils.capitalize((String)I18N.tr("assigned properties"));
            int n = this.table.getRowCount();
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.title.setTitle(string);
        }
    }

    private final class AddressPanel
    extends AbstractTab {
        private final AgencyContactAddressPanel form = new AgencyContactAddressPanel(40);

        private AddressPanel() {
            this.form.setBorder((Border)Paddings.DIALOG);
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.form));
            jScrollPane.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout());
            this.setBorder(Paddings.EMPTY);
            this.add(jScrollPane, "Center");
        }

        public DefaultAddressPanel getForm() {
            return this.form;
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("person"));
        }

        @Override
        public void load(DbAgencyContact dbAgencyContact) {
            this.form.load(dbAgencyContact);
            if (dbAgencyContact != null && dbAgencyContact.id > 0L) {
                this.form.validateInputs();
            } else {
                this.form.initInputs();
            }
        }

        @Override
        public void save(DbAgencyContact dbAgencyContact) {
            this.form.save(dbAgencyContact);
        }
    }

    public static abstract class AbstractTab
    extends AbstractMainViewTab {
        public abstract void load(DbAgencyContact var1);

        public abstract void save(DbAgencyContact var1);

        public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyContact dbAgencyContact) throws Exception {
        }
    }
}

