/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyExportLogsPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.gui.AbstractTab;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.FlowPanel;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewExportsPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewExportsPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewExportsPanel.class);
    private static final String TABLE_ID = "AgencyEstateViewExportsPanel.HistoryTab.Table";
    private WeakReference<DbAgencyObject> currentObject = null;
    private ModificationHandler modifications;
    private JXTitledSeparator formTitle;
    private JTabbedPane tabbedPane;
    private InterfaceTab interfaceTab;
    private HistoryTab historyTab;

    public AgencyEstateViewExportsPanel() {
        this.build();
    }

    private void build() {
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.tabbedPane = new JTabbedPane();
        this.interfaceTab = (InterfaceTab)ImmoToolUtils.addTab((AbstractTab)new InterfaceTab(), (JTabbedPane)this.tabbedPane);
        this.historyTab = (HistoryTab)ImmoToolUtils.addTab((AbstractTab)new HistoryTab(), (JTabbedPane)this.tabbedPane);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.formTitle, "North");
        this.add(this.tabbedPane, "Center");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        DbAgencyObject dbAgencyObject = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
        ArrayList arrayList = new ArrayList();
        ArrayList<DbAgencyExportLog> arrayList2 = new ArrayList<DbAgencyExportLog>();
        try {
            if (dbAgencyObject != null) {
                DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
                DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
                DbAgencyExport[] dbAgencyExportArray = dbAgencyExportsHandler.getExports(connection, (Boolean)null);
                TreeMap<String, DbAgencyExport> treeMap = new TreeMap<String, DbAgencyExport>();
                for (DbAgencyExport dbAgencyExport : dbAgencyExportArray) {
                    String string = StringUtils.trimToEmpty((String)dbAgencyExport.name).toLowerCase();
                    int n = 1;
                    while (treeMap.containsKey(string)) {
                        string = dbAgencyExport.name.toLowerCase() + "_" + n++;
                    }
                    treeMap.put(string, dbAgencyExport);
                }
                if (dbAgencyObject.id > 0L) {
                    dbAgencyObjectsHandler.loadObjectExportIds(connection, dbAgencyObject);
                } else {
                    dbAgencyObject.exportIds = new ArrayList<Long>();
                }
                if (dbAgencyObject.id > 0L) {
                    arrayList2.addAll(Arrays.asList(dbAgencyExportsHandler.getExportLogsForObject(connection, dbAgencyObject.id)));
                }
                arrayList.addAll(treeMap.values());
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, dbAgencyObject, arrayList2){
                final /* synthetic */ List val$exportList;
                final /* synthetic */ DbAgencyObject val$object;
                final /* synthetic */ List val$exportLogs;
                {
                    this.val$exportList = list;
                    this.val$object = dbAgencyObject;
                    this.val$exportLogs = list2;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AgencyEstateViewExportsPanel.this.interfaceTab.setExports(this.val$exportList, this.val$object != null ? this.val$object.exportIds : new ArrayList());
                        HashMap<Long, String> hashMap = new HashMap<Long, String>();
                        for (DbAgencyExportLog dbAgencyExportLog : this.val$exportLogs) {
                            String string = null;
                            if (hashMap.containsKey(dbAgencyExportLog.exportId)) {
                                string = (String)hashMap.get(dbAgencyExportLog.exportId);
                            } else {
                                for (DbAgencyExport dbAgencyExport : this.val$exportList) {
                                    if (dbAgencyExport.id != dbAgencyExportLog.exportId) continue;
                                    string = StringUtils.trimToNull((String)dbAgencyExport.name);
                                    break;
                                }
                                hashMap.put(dbAgencyExportLog.exportId, string);
                            }
                            AgencyEstateViewExportsPanel.this.historyTab.logsPanel.addExportLog(dbAgencyExportLog, string);
                        }
                    }
                    finally {
                        AgencyEstateViewExportsPanel.this.historyTab.logsPanel.updateLocalization();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("exports"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isTabModified() {
        return this.modifications.isModified();
    }

    public boolean isTabUsable() {
        return AgencyPlugin.isUserAllowedTo(AgencyPermission.EXPORTS);
    }

    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        this.currentObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        this.tabbedPane.setEnabledAt(1, dbAgencyObject.id > 0L);
        if (dbAgencyObject.id == 0L) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.historyTab.logsPanel.clearExportLogs();
        this.interfaceTab.setExportMode(dbAgencyObject.exportMode != null ? dbAgencyObject.exportMode : DbAgencyObject.ExportMode.ALL);
        this.interfaceTab.setExports();
        this.modifications.clear();
        this.modifications.putValue((JComponent)this.interfaceTab.modeField);
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) {
        DbAgencyObject.ExportMode exportMode = this.interfaceTab.getExportMode();
        DbAgencyObject.ExportMode exportMode2 = dbAgencyObject.exportMode = exportMode != null ? exportMode : DbAgencyObject.ExportMode.ALL;
        if (dbAgencyObject.exportIds == null) {
            dbAgencyObject.exportIds = new ArrayList<Long>();
        } else {
            dbAgencyObject.exportIds.clear();
        }
        if (DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode) || DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode)) {
            dbAgencyObject.exportIds.addAll(this.interfaceTab.getExportIds());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("exports for the property")));
    }

    private static class HistoryTab
    extends AbstractTab {
        private AgencyExportLogsPanel logsPanel;

        private HistoryTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.logsPanel = new AgencyExportLogsPanel(AgencyEstateViewExportsPanel.TABLE_ID, true);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)((Object)this.logsPanel), "Center");
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("export history"));
        }
    }

    private class InterfaceTab
    extends AbstractTab {
        private JXTitledSeparator title;
        private JLabel modeLabel;
        private JComboBox<DbAgencyObject.ExportMode> modeField;
        private JPanel interfacePanel;
        private Map<Long, JCheckBox> interfaceFields;

        private InterfaceTab() {
            this.build();
            this.updateLocalization();
        }

        private void build() {
            this.interfaceFields = new HashMap<Long, JCheckBox>();
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.modeLabel = new JLabel();
            this.modeField = new JComboBox();
            this.modeField.setRenderer((ListCellRenderer<DbAgencyObject.ExportMode>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
            for (DbAgencyObject.ExportMode exportMode : DbAgencyObject.ExportMode.values()) {
                this.modeField.addItem(exportMode);
            }
            this.modeField.setSelectedIndex(0);
            this.modeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!InterfaceTab.this.modeField.isEnabled()) {
                        return;
                    }
                    InterfaceTab.this.updateMode();
                }
            });
            this.interfacePanel = new JPanel(new GridLayout());
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow");
            defaultFormBuilder.border((Border)Paddings.DIALOG);
            defaultFormBuilder.add((Component)this.title).xyw(1, defaultFormBuilder.nextRow(), 3);
            defaultFormBuilder.add((Component)this.modeLabel).xy(1, defaultFormBuilder.nextRow());
            defaultFormBuilder.add(this.modeField).xy(3, defaultFormBuilder.row());
            defaultFormBuilder.add((Component)this.interfacePanel).xy(3, defaultFormBuilder.nextRow());
            JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
            jScrollPane.setBorder(Paddings.EMPTY);
            jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
            jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setBorder(Paddings.EMPTY);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jScrollPane, "Center");
        }

        public Collection<Long> getExportIds() {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (Map.Entry<Long, JCheckBox> entry : this.interfaceFields.entrySet()) {
                if (!entry.getValue().isSelected()) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList;
        }

        public DbAgencyObject.ExportMode getExportMode() {
            return (DbAgencyObject.ExportMode)((Object)this.modeField.getSelectedItem());
        }

        public String getTabTitle() {
            return StringUtils.capitalize((String)I18N.tr("interfaces"));
        }

        private void setExports() {
            this.setExports(new ArrayList<DbAgencyExport>(), new ArrayList<Long>());
        }

        private void setExports(Collection<DbAgencyExport> collection, Collection<Long> collection2) {
            DbAgencyObject.ExportMode exportMode = this.getExportMode();
            this.interfacePanel.removeAll();
            DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"30dlu:grow", (JPanel)this.interfacePanel);
            TreeMap<String, DbAgencyExport> treeMap = new TreeMap<String, DbAgencyExport>();
            for (DbAgencyExport dbAgencyExport : collection) {
                String string = dbAgencyExport.name.toLowerCase();
                int n = 1;
                while (treeMap.containsKey(string)) {
                    string = dbAgencyExport.name.toLowerCase() + "_" + n++;
                }
                treeMap.put(string, dbAgencyExport);
            }
            this.interfaceFields.clear();
            for (DbAgencyExport dbAgencyExport : treeMap.values()) {
                boolean bl = collection2 != null && collection2.contains(dbAgencyExport.id);
                String string = StringUtils.abbreviate((String)((String)StringUtils.defaultIfBlank((CharSequence)dbAgencyExport.name, (CharSequence)("#" + dbAgencyExport.id))), (int)75);
                JCheckBox jCheckBox = new JCheckBox(string);
                jCheckBox.setEnabled(DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode) || DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode));
                jCheckBox.setSelected(jCheckBox.isEnabled() && bl);
                defaultFormBuilder.add((Component)FlowPanel.create((JComponent[])new JComponent[]{jCheckBox})).xy(1, defaultFormBuilder.nextRow());
                this.interfaceFields.put(dbAgencyExport.id, jCheckBox);
                if (!DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode) && !DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode)) continue;
                AgencyEstateViewExportsPanel.this.modifications.putValue((JComponent)jCheckBox);
            }
            this.interfacePanel.revalidate();
            this.interfacePanel.repaint();
        }

        public void setExportMode(DbAgencyObject.ExportMode exportMode) {
            this.modeField.setSelectedItem((Object)exportMode);
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.title.setTitle(StringUtils.capitalize((String)I18N.tr("usable export interfaces")));
            this.modeLabel.setText(StringUtils.capitalize((String)I18N.tr("export")) + ":");
            this.modeField.setToolTipText(I18N.tr("Please select, through which export interfaces the property may be exported."));
        }

        private void updateMode() {
            DbAgencyObject.ExportMode exportMode = this.getExportMode();
            for (JCheckBox jCheckBox : this.interfaceFields.values()) {
                jCheckBox.setEnabled(DbAgencyObject.ExportMode.SELECTED_EXPORTS.equals((Object)exportMode) || DbAgencyObject.ExportMode.UNSELECTED_EXPORTS.equals((Object)exportMode));
            }
        }
    }
}

