/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyExportLogPanel;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainView;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportLogViewPanel
extends AbstractMainView {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportLogViewPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportLogViewPanel.class);
    private AgencyExportLogPanel logPanel;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction printAction;
    private AbstractI18nAction pdfAction;

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.closeAction = this.createDefaultCloseAction();
        this.pdfAction = this.logPanel.createPdfAction();
        this.printAction = this.logPanel.createPrintAction();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.pdfAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.printAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildMainComponent() {
        return this.logPanel;
    }

    public void doRefresh() {
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"history.png", (int)32);
    }

    protected String getHeaderTitle() {
        return I18N.tr("export protocol");
    }

    public String getTabTitle() {
        return I18N.tr("export protocol");
    }

    protected void init() {
        super.init();
        this.logPanel = new AgencyExportLogPanel(false);
    }

    public void setLog(DbAgencyExportLog dbAgencyExportLog, String string) {
        this.pdfAction.setEnabled(dbAgencyExportLog != null && dbAgencyExportLog.id > 0L);
        this.printAction.setEnabled(dbAgencyExportLog != null && dbAgencyExportLog.id > 0L);
        this.logPanel.setLog(dbAgencyExportLog, string);
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }
}

