/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExposeTask
extends ImmoToolTask<File[], Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExposeTask.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExposeTask.class);
    private final long[] estateIds;
    private final DbAgencyObject[] estates;
    protected final ImmoToolProject project;
    protected final DbAgencyExpose expose;
    protected final File outputFile;
    private ExportMode exportMode = null;

    public AgencyExposeTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, long[] lArray, File file) {
        this.estates = null;
        this.estateIds = ArrayUtils.clone((long[])lArray);
        this.expose = dbAgencyExpose;
        this.project = immoToolProject;
        this.outputFile = file;
    }

    public AgencyExposeTask(ImmoToolProject immoToolProject, DbAgencyExpose dbAgencyExpose, DbAgencyObject[] dbAgencyObjectArray, File file) {
        this.estateIds = null;
        this.estates = (DbAgencyObject[])ArrayUtils.clone((Object[])dbAgencyObjectArray);
        this.expose = dbAgencyExpose;
        this.project = immoToolProject;
        this.outputFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File[] doInBackground() throws Exception {
        DbLanguagesHandler dbLanguagesHandler;
        if (this.expose == null) {
            LOGGER.warn("No expos\u00e9 was selected!");
            return null;
        }
        this.exportMode = null;
        Connection connection = null;
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyObject[] dbAgencyObjectArray = this.loadEstates(dbAgencyObjectsHandler, dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler());
        if (dbAgencyObjectArray.length < 1) {
            LOGGER.warn("Nothing to export!");
            return null;
        }
        AbstractExpose abstractExpose = this.expose.createExposeBuilder();
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            connection = this.project.getDbConnection();
            for (DbAgencyObject dbAgencyObject : dbAgencyObjectArray) {
                Object object;
                Object object2;
                File file;
                if (dbAgencyObjectArray.length == 1) {
                    file = this.outputFile;
                } else {
                    object2 = dbAgencyObject.item.getPublicId();
                    if (object2 == null || ((String)object2).trim().length() == 0) {
                        object2 = "ID_" + dbAgencyObject.id;
                    }
                    object = this.expose.name + "_" + (String)object2;
                    object = ((String)object).replaceAll("[^\\w\\-\\.]", "_");
                    while (((String)object).contains("__")) {
                        object = ((String)object).replace("__", "_");
                    }
                    file = new File(this.outputFile.getAbsolutePath() + File.separator + (String)object + ".pdf");
                }
                object2 = new FileOutputStream(file);
                object = null;
                try {
                    abstractExpose.generate(dbAgencyObject, this.project, connection, (OutputStream)object2);
                    ((OutputStream)object2).flush();
                    arrayList.add(file);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)object2).close();
                        }
                    }
                }
            }
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
        return arrayList.toArray(new File[0]);
    }

    public final boolean isOpened() {
        return ExportMode.OPENED.equals((Object)this.exportMode);
    }

    public final boolean isSaved() {
        return ExportMode.SAVED.equals((Object)this.exportMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DbAgencyObject[] loadEstates(DbAgencyObjectsHandler dbAgencyObjectsHandler, DbLanguagesHandler dbLanguagesHandler) throws SQLException {
        if (this.estates != null) {
            return this.estates;
        }
        if (ArrayUtils.isEmpty((long[])this.estateIds)) {
            return new DbAgencyObject[0];
        }
        Connection connection = null;
        try {
            connection = this.project.getDbConnection();
            DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, this.estateIds);
            ArrayList<DbAgencyObject> arrayList = new ArrayList<DbAgencyObject>();
            for (DbObject dbObject : dbObjectArray) {
                arrayList.add((DbAgencyObject)dbObject);
            }
            DbObject[] dbObjectArray2 = arrayList.toArray(new DbAgencyObject[0]);
            return dbObjectArray2;
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    public static enum ExportMode {
        SAVED,
        OPENED;

    }
}

