/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.impl.OpenEstateConstant;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolSettings;
import com.openindex.openestate.tool.ImmoToolSetupDialog;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.db.DbAdminHandler;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.RegexFormatter;
import com.openindex.openestate.tool.utils.forms.FormatterRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencySetupGeneralPanel
extends ImmoToolSetupDialog.AbstractForm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencySetupGeneralPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencySetupGeneralPanel.class);
    private ValidationHandler validationHandler;
    private JXTitledSeparator imgMaxTitle;
    private JLabel imgMaxInfoLabel;
    private JLabel imgMaxHeightLabel;
    private JFormattedTextField imgMaxHeightField;
    private JLabel imgMaxWidthLabel;
    private JFormattedTextField imgMaxWidthField;
    private JXTitledSeparator furtherOptionsTitle;
    private JCheckBox approximatedAttributesBox;

    public AgencySetupGeneralPanel() {
        this.build();
        this.updateLocalization();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.imgMaxTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.furtherOptionsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.imgMaxInfoLabel = new JLabel();
        this.imgMaxHeightLabel = new JLabel();
        this.imgMaxHeightField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegexFormatter("\\d{1,4}"));
        this.imgMaxWidthLabel = new JLabel();
        this.imgMaxWidthField = new JFormattedTextField((JFormattedTextField.AbstractFormatter)new RegexFormatter("\\d{1,4}"));
        this.approximatedAttributesBox = new JCheckBox();
        this.validationHandler.putRule((JComponent)this.imgMaxHeightField, (ValidationRule)new FormatterRule(this.imgMaxHeightField));
        this.validationHandler.putRule((JComponent)this.imgMaxWidthField, (ValidationRule)new FormatterRule(this.imgMaxHeightField));
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[40dlu,pref], 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.imgMaxTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.imgMaxInfoLabel).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.imgMaxWidthLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.imgMaxWidthField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.imgMaxHeightLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.imgMaxHeightField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.furtherOptionsTitle).xyw(1, defaultFormBuilder.nextRow(), 7);
        defaultFormBuilder.add((Component)this.approximatedAttributesBox).xyw(1, defaultFormBuilder.nextRow(), 7);
    }

    public String getTitle() {
        return StringUtils.capitalize((String)I18N.tr("general"));
    }

    public boolean isFormValid() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    public boolean isProjectRequired() {
        return true;
    }

    public void load(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbAdminHandler dbAdminHandler = immoToolProject.getDbExtension().getAdminHandler();
        boolean bl = dbAdminHandler.isAdmin(connection);
        AgencyPlugin.loadSettings(immoToolProject, connection);
        this.imgMaxWidthField.setEnabled(bl);
        this.imgMaxWidthField.setValue(AgencyPlugin.getImageMaxWidth());
        this.imgMaxHeightField.setEnabled(bl);
        this.imgMaxHeightField.setValue(AgencyPlugin.getImageMaxHeight());
        this.approximatedAttributesBox.setEnabled(bl);
        this.approximatedAttributesBox.setSelected(AgencyPlugin.isApproximatedAttributes());
        this.validationHandler.validate();
    }

    public void save(ImmoToolSettings immoToolSettings, ImmoToolProject immoToolProject, Connection connection) throws SQLException, IOException {
        DbAdminHandler dbAdminHandler = immoToolProject.getDbExtension().getAdminHandler();
        boolean bl = dbAdminHandler.isAdmin(connection);
        if (bl) {
            AgencyPlugin.setImageMaxHeight(Integer.parseInt(this.imgMaxHeightField.getText()));
            AgencyPlugin.setImageMaxWidth(Integer.parseInt(this.imgMaxWidthField.getText()));
            AgencyPlugin.setApproximatedAttributes(this.approximatedAttributesBox.isSelected());
            AgencyPlugin.saveSettings(connection, immoToolProject.getUser(), immoToolProject.getDbExtension());
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.imgMaxTitle.setTitle(StringUtils.capitalize((String)I18N.tr("maximum image size")));
        this.imgMaxInfoLabel.setText("<html>" + I18N.tr("Imported property images should not exceed the maximum image size. In case that an image is too large, it will be automatically resized.") + "</html>");
        this.imgMaxHeightLabel.setText(StringUtils.capitalize((String)I18N.tr("max. height")) + ":");
        this.imgMaxHeightField.setToolTipText(I18N.tr("Stored images may not exceed the maximum height (in pixels)."));
        this.imgMaxWidthLabel.setText(StringUtils.capitalize((String)I18N.tr("max. width")) + ":");
        this.imgMaxWidthField.setToolTipText(I18N.tr("Stored images may not exceed the maximum width (in pixels)."));
        this.furtherOptionsTitle.setTitle(StringUtils.capitalize((String)I18N.tr("further options")));
        this.approximatedAttributesBox.setText(I18N.tr("Prepend {0} to numeric attributes with unit.", (Object)("\"" + OpenEstateConstant.APPROX.getTranslation() + "\"")));
        this.approximatedAttributesBox.setToolTipText(I18N.tr("Enable this option to prepend the text {0} to numeric attributes with unit (e.g. length, area).", (Object)("\"" + OpenEstateConstant.APPROX.getTranslation() + "\"")));
    }
}

