/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExposeFile;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import eu.medsea.mimeutil.MimeType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyExpose
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyExpose.class);
    public long id = 0L;
    public String name = null;
    public String type = null;
    public Date createdAt = null;
    public Date modifiedAt = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public Map<String, String> settings = null;
    public transient File temporaryTemplateFile = null;
    public transient boolean templateFileDisabled = false;

    public AbstractExpose createExposeBuilder() {
        if (this.type == null) {
            return null;
        }
        AbstractExpose abstractExpose = AbstractExpose.getExpose(this.type);
        if (abstractExpose == null) {
            LOGGER.warn("Unknown expose type: " + this.type);
            return null;
        }
        abstractExpose.initDefaults();
        abstractExpose.putAll(this.settings);
        abstractExpose.setTemporaryTemplate(this.temporaryTemplateFile);
        return abstractExpose;
    }

    public void saveToDatabase(Connection connection, DbAgencyExposesHandler dbAgencyExposesHandler) throws SQLException, IOException {
        dbAgencyExposesHandler.saveExpose(connection, this);
        AbstractExpose abstractExpose = this.createExposeBuilder();
        int n = abstractExpose.hashCode();
        File file = this.temporaryTemplateFile;
        if (file != null && file.isFile()) {
            DbAgencyExposeFile dbAgencyExposeFile;
            if (abstractExpose.getTemplateId() > 0L) {
                dbAgencyExposeFile = dbAgencyExposesHandler.getExposeFile(connection, abstractExpose.getTemplateId());
                if (dbAgencyExposeFile == null) {
                    LOGGER.warn("Can't find template #" + abstractExpose.getTemplateId() + " for expos\u00e9 #" + this.id);
                }
            } else {
                dbAgencyExposeFile = new DbAgencyExposeFile();
            }
            if (dbAgencyExposeFile != null) {
                dbAgencyExposeFile.exposeId = this.id;
                dbAgencyExposeFile.tempContent = file;
                dbAgencyExposeFile.name = file.getName();
                MimeType mimeType = ImmoToolUtils.getMimeType((File)file);
                dbAgencyExposeFile.mimeType = mimeType != null ? mimeType.toString() : "application/octet-stream";
                dbAgencyExposesHandler.saveExposeFile(connection, dbAgencyExposeFile);
                abstractExpose.setTemplateId(dbAgencyExposeFile.id);
            }
        } else if (this.templateFileDisabled && abstractExpose.getTemplateId() > 0L) {
            dbAgencyExposesHandler.removeExposeFile(connection, abstractExpose.getTemplateId());
            abstractExpose.setTemplateId(0L);
        }
        abstractExpose.saveToDatabase(this, connection, dbAgencyExposesHandler);
        if (abstractExpose.hashCode() != n) {
            this.setExposeBuilder(abstractExpose);
            dbAgencyExposesHandler.saveExpose(connection, this);
        }
    }

    public void setExposeBuilder(AbstractExpose abstractExpose) {
        if (abstractExpose == null) {
            this.type = null;
            this.settings = new HashMap<String, String>();
        } else {
            this.type = abstractExpose.getName();
            this.settings = new HashMap<String, String>();
            this.settings.putAll(abstractExpose);
        }
    }
}

