/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db;

import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.utils.Permission;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Public fields are kept for compatibility with the database model.")
public class DbAgencyObject
extends DbObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbAgencyObject.class);
    private static final I18n I18N = I18nFactory.getI18n(DbAgencyObject.class);
    public String importId = null;
    public String importHash = null;
    public String notes = null;
    public Status status = null;
    public ExportMode exportMode = null;
    public long ownerUserId = 0L;
    public long ownerGroupId = 0L;
    public Permission permission = null;
    public List<Long> exportIds = null;

    public static ObjectToStringConverter createObjectToStringConverter() {
        return new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object object) {
                if (object instanceof DbAgencyObject) {
                    return ((DbAgencyObject)((Object)object)).print();
                }
                return "-";
            }

            public String[] getPossibleStringsForItem(Object object) {
                if (object instanceof DbAgencyObject) {
                    String string;
                    DbAgencyObject dbAgencyObject = (DbAgencyObject)((Object)object);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(this.getPreferredStringForItem(object));
                    String string2 = dbAgencyObject.item.getPublicId();
                    if (string2 != null && string2.trim().length() > 0) {
                        arrayList.add(string2);
                    }
                    if ((string = dbAgencyObject.item.getTitle(Locale.getDefault())) != null && string.trim().length() > 0) {
                        arrayList.add(string);
                    }
                    return arrayList.toArray(new String[0]);
                }
                return super.getPossibleStringsForItem(object);
            }
        };
    }

    public String print() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string = this.item != null ? StringUtils.trimToNull((String)this.item.getPublicId()) : null;
        if (string == null) {
            string = "#" + this.id;
        }
        arrayList.add(string);
        if (this.item != null) {
            String string3;
            String string4;
            String string5 = StringUtils.trimToNull((String)this.item.getAddress().writePostal());
            if (string5 != null) {
                arrayList.add(string5);
            }
            if ((string4 = StringUtils.trimToNull((String)this.item.getAddress().writeStreet(true))) != null) {
                arrayList.add(string4);
            }
            if ((string3 = StringUtils.trimToNull((String)this.item.getTitle(Locale.getDefault()))) == null) {
                string3 = StringUtils.trimToNull((String)this.item.getFallbackTitle(Locale.getDefault()));
            }
            if (string3 != null) {
                arrayList.add(StringUtils.abbreviate((String)string3, (int)50));
            }
        }
        return StringUtils.join(arrayList, (String)" | ");
    }

    public String writeToolTip() {
        String string;
        Locale locale = Locale.getDefault();
        String string2 = "<h2 style=\"margin:0;\">" + StringUtils.capitalize((String)I18N.tr("property")) + " #" + this.id + "</h2>";
        String string3 = StringUtils.trimToNull((String)this.item.getPublicId());
        if (string3 != null) {
            string2 = string2 + "<b>" + string3 + "</b>";
        }
        if ((string = StringUtils.trimToNull((String)this.item.getTitle(locale))) == null) {
            string = StringUtils.trimToNull((String)this.item.getFallbackTitle(locale));
        }
        String string4 = "";
        if (string != null) {
            string4 = string4 + "<i>" + StringEscapeUtils.escapeXml11((String)string) + "</i>";
        }
        if (this.item.getType() != null || this.item.getAction() != null) {
            string4 = string4 + "<br>";
            if (this.item.getType() != null) {
                string4 = string4 + "<i>" + StringEscapeUtils.escapeXml11((String)this.item.getType().getTranslation(locale)) + "</i>";
            }
            if (this.item.getAction() != null) {
                if (this.item.getType() != null) {
                    string4 = string4 + " / ";
                }
                string4 = string4 + "<i>" + StringEscapeUtils.escapeXml11((String)this.item.getAction().getTranslation(locale)) + "</i>";
            }
        }
        if (string4.length() > 0) {
            string2 = string2 + "<hr>" + string4;
        }
        if ((string4 = this.item.getAddress().writeFullAddress("<br>", locale)).length() > 0) {
            string2 = string2 + "<hr>" + string4;
        }
        return "<html><div style=\"margin:5px;\">" + string2 + "</div></html>";
    }

    public String writeValueForPublic(OpenEstateAttrib openEstateAttrib, Locale locale) {
        return AgencyPluginUtils.writeValueForPublic(this.item, openEstateAttrib, locale);
    }

    public String writeValueForPublic(AbstractAttribImpl abstractAttribImpl, Locale locale) {
        return AgencyPluginUtils.writeValueForPublic(this.item, abstractAttribImpl, locale);
    }

    public static enum Status implements Translatable
    {
        DRAFT(I18n.marktr((String)"in draft")),
        REVIEW(I18n.marktr((String)"in review")),
        PUBLISHED(I18n.marktr((String)"is published")),
        BROKERED(I18n.marktr((String)"successfully marketed")),
        NOT_BROKERED(I18n.marktr((String)"unsuccessfully marketed")),
        TRAY(I18n.marktr((String)"in clipboard"));

        private final String i18nKey;

        private Status(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbAgencyObject.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }

    public static enum ExportMode implements Translatable
    {
        ALL(I18n.marktr((String)"ALWAYS export property.")),
        SELECTED_EXPORTS(I18n.marktr((String)"Export property with the SELECTED interfaces.")),
        UNSELECTED_EXPORTS(I18n.marktr((String)"Export property with the UNSELECTED interfaces.")),
        NEVER(I18n.marktr((String)"NEVER export property."));

        private final String i18nKey;

        private ExportMode(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString((I18n)I18N, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(DbAgencyObject.class, (String)this.i18nKey, (Locale)locale);
        }

        @Deprecated
        public String write() {
            return this.getTranslation();
        }
    }
}

