/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.db.hsql;

import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.db.hsql.HSqlDbSearchesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.utils.Permission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencySearchesHandler
extends HSqlDbSearchesHandler
implements DbAgencySearchesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencySearchesHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencySearchesHandler.class);
    public static final String PROC_SAVE_SEARCHES_ADDON = "save_immotool_agency_searches";
    public static final String TABLE_AGENCY_SEARCHES = "immotool_agency_searches";
    public static final String FIELD_SEARCH_TYPE = "search_type";
    public static final String FIELD_SEARCH_OBJECT_STATUS = "search_object_status";
    private static final String FIELD_ACCESS_OWNER_ID = "access_owner_id";
    private static final String FIELD_ACCESS_GROUP_ID = "access_group_id";
    private static final String FIELD_ACCESS_PERMISSIONS = "access_permissions";

    protected DbSearch buildSearch(ResultSet resultSet) throws SQLException {
        DbAgencySearch dbAgencySearch = (DbAgencySearch)super.buildSearch(resultSet);
        if (dbAgencySearch == null) {
            return null;
        }
        dbAgencySearch.ownerUserId = resultSet.getLong(FIELD_ACCESS_OWNER_ID);
        dbAgencySearch.ownerGroupId = resultSet.getLong(FIELD_ACCESS_GROUP_ID);
        dbAgencySearch.permission = new Permission(resultSet.getInt(FIELD_ACCESS_PERMISSIONS));
        String string = resultSet.getString(FIELD_SEARCH_TYPE);
        if (!StringUtils.isBlank((CharSequence)string)) {
            try {
                dbAgencySearch.type = DbAgencySearch.Type.valueOf(string);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read type of search #" + dbAgencySearch.id);
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (dbAgencySearch.type == null) {
            dbAgencySearch.type = DbAgencySearch.Type.TEMP;
        }
        if (dbAgencySearch.status == null) {
            dbAgencySearch.status = new ArrayList<DbAgencyObject.Status>();
        } else {
            dbAgencySearch.status.clear();
        }
        String string2 = resultSet.getString(FIELD_SEARCH_OBJECT_STATUS);
        if (!StringUtils.isBlank((CharSequence)string2)) {
            for (String string3 : string2.split(",")) {
                if (string3.trim().length() < 1) continue;
                try {
                    dbAgencySearch.status.add(DbAgencyObject.Status.valueOf(string3));
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read status for search #" + dbAgencySearch.id + "!");
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return dbAgencySearch;
    }

    protected DbSearch createSearch() {
        return new DbAgencySearch();
    }

    @Override
    public long[] getSearchIds(Connection connection, Boolean bl, DbAgencySearch.Type type) throws SQLException {
        DbAgencySearch.Type[] typeArray;
        if (type != null) {
            DbAgencySearch.Type[] typeArray2 = new DbAgencySearch.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = type;
        } else {
            typeArray = null;
        }
        return this.getSearchIds(connection, bl, typeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getSearchIds(Connection connection, Boolean bl, DbAgencySearch.Type[] typeArray) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl != null) {
                arrayList.add("search_enabled = ?");
            }
            if (typeArray != null && typeArray.length > 0) {
                arrayList.add("search_type IN (" + JdbcUtils.writeQuestionMarkList((int)typeArray.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT search_id FROM view_openestate_searches " + string + " ORDER BY " + "search_name" + " ASC;");
            int n = 0;
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (typeArray != null && typeArray.length > 0) {
                for (DbAgencySearch.Type type : typeArray) {
                    preparedStatement.setString(++n, type.name());
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList2 = new ArrayList();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getLong("search_id"));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    @Override
    public DbSearch[] getSearches(Connection connection, Boolean bl, DbAgencySearch.Type type) throws SQLException {
        DbAgencySearch.Type[] typeArray;
        if (type != null) {
            DbAgencySearch.Type[] typeArray2 = new DbAgencySearch.Type[1];
            typeArray = typeArray2;
            typeArray2[0] = type;
        } else {
            typeArray = null;
        }
        return this.getSearches(connection, bl, typeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbSearch[] getSearches(Connection connection, Boolean bl, DbAgencySearch.Type[] typeArray) throws SQLException {
        DbSearch[] dbSearchArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl != null) {
                arrayList.add("search_enabled = ?");
            }
            if (typeArray != null && typeArray.length > 0) {
                arrayList.add("search_type IN (" + JdbcUtils.writeQuestionMarkList((int)typeArray.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM view_openestate_searches " + string + " ORDER BY " + "search_name" + " ASC;");
            int n = 0;
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (typeArray != null && typeArray.length > 0) {
                for (DbAgencySearch.Type type : typeArray) {
                    preparedStatement.setString(++n, type.name());
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList arrayList2 = new ArrayList();
            while (resultSet.next()) {
                arrayList2.add(this.buildSearch(resultSet));
            }
            dbSearchArray = arrayList2.toArray(new DbSearch[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbSearchArray;
    }

    protected void saveSearchAdditionally(Connection connection, DbSearch dbSearch, long l, List<Statement> list) throws SQLException {
        if (!(dbSearch instanceof DbAgencySearch)) {
            LOGGER.warn("DbSearch is not an instance of DbAgencySearch!");
            LOGGER.warn("> " + dbSearch.getClass().getName());
            return;
        }
        DbAgencySearch dbAgencySearch = (DbAgencySearch)dbSearch;
        NamedCallableStatement namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_searches(:search_id, :search_type, :search_object_status, :access_owner_id, :access_group_id, :access_permissions);");
        namedCallableStatement.setLong("search_id", l);
        namedCallableStatement.setString(FIELD_SEARCH_TYPE, dbAgencySearch.type != null ? dbAgencySearch.type.name() : DbAgencySearch.Type.TEMP.name());
        namedCallableStatement.setString(FIELD_SEARCH_OBJECT_STATUS, dbAgencySearch.status != null ? StringUtils.join(dbAgencySearch.status, (String)",") : null);
        namedCallableStatement.setLong(FIELD_ACCESS_OWNER_ID, dbAgencySearch.ownerUserId);
        namedCallableStatement.setLong(FIELD_ACCESS_GROUP_ID, dbAgencySearch.ownerGroupId);
        namedCallableStatement.setInt(FIELD_ACCESS_PERMISSIONS, dbAgencySearch.permission != null ? dbAgencySearch.permission.getValue() : -1);
        namedCallableStatement.execute();
        list.add(namedCallableStatement.getStatement());
    }
}

