/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.lowagie.text.DocumentException;
import com.openindex.openestate.impl.AddressImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.EstateAddressImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.PersonAddressImpl;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnergyConsumptionAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.CurrencyValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractPhpFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.expose.AbstractExpose;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractPhpBuilder<F extends AbstractPhpFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPhpBuilder.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractPhpBuilder.class);
    public static final String INDEX_HTML = "index.html";
    public static final String HTACCESS = ".htaccess";
    private final F format;
    private final String packagePath;
    private final String encoding;

    protected AbstractPhpBuilder(F f, String string, String string2) {
        this.format = f;
        this.encoding = string;
        this.packagePath = string2;
    }

    protected String buildLanguagePhp() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.initLanguagePhpValues(hashMap);
        return this.readResource("data_language.php.txt", hashMap);
    }

    protected void buildObjectPdf(AbstractExpose abstractExpose, ExportEntry exportEntry, String string, File file, Connection connection) throws IOException, DocumentException, SQLException {
        for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
            this.buildObjectPdf(abstractExpose, exportEntry, string, file, locale, connection);
        }
    }

    protected void buildObjectPdf(AbstractExpose abstractExpose, ExportEntry exportEntry, String string, File file, Locale locale, Connection connection) throws IOException, DocumentException, SQLException {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        abstractExpose.setLocale(locale);
        File file2 = new File(file, string + "_" + locale.getLanguage() + ".pdf");
        try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            abstractExpose.generate(exportEntry.objectId, immoToolProject, connection, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
    }

    protected String buildObjectPhp(EstateImpl estateImpl, String string, DbAgencyObject.Status status, AgentImpl agentImpl, AgentContactImpl agentContactImpl, Date date, Date date2) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.initObjectPhpValues(hashMap, estateImpl, string, status, agentImpl, agentContactImpl, date, date2);
        return this.readResource("data_object.php.txt", hashMap);
    }

    protected String buildObjectTextsPhp(EstateImpl estateImpl, String string) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.initObjectTextsPhpValues(hashMap, estateImpl, string);
        return this.readResource("data_texts.php.txt", hashMap);
    }

    protected String buildTermsPhp(AgentImpl agentImpl) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.initTermsPhpValues(hashMap, agentImpl);
        return this.readResource("data_terms.php.txt", hashMap);
    }

    protected String buildTranslationPhp(Locale locale) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.initTranslationPhpValues(hashMap, locale);
        return this.readResource("data_i18n.php.txt", hashMap);
    }

    protected void extractScripts(File file) throws IOException {
        File file2 = new File(file, "scripts.zip");
        try {
            this.saveResource("scripts.zip", file2);
            ImmoToolUtils.unzip((File)file2, (File)file);
        }
        finally {
            FileUtils.deleteQuietly((File)file2);
        }
    }

    public final F getFormat() {
        return this.format;
    }

    protected void initLanguagePhpValues(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
            String string = "'" + locale.getLanguage() + "' => '" + locale.getDisplayLanguage(locale) + "',";
            stringBuilder.append("  ").append(string).append(System.lineSeparator());
        }
        map.put("LANGUAGES", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
    }

    protected void initObjectPhpValues(Map<String, String> map, EstateImpl estateImpl, String string, DbAgencyObject.Status status, AgentImpl agentImpl, AgentContactImpl agentContactImpl, Date date, Date date2) {
        Object object;
        Object object322;
        Locale[] localeArray = ((AbstractFormat)this.format).getLanguages();
        AbstractTypeImpl abstractTypeImpl = estateImpl.getTypeSpec();
        CompanyAddressImpl companyAddressImpl = agentImpl != null ? agentImpl.getCompany() : null;
        String string2 = StringUtils.trimToNull((String)((AbstractFormat)this.format).getPropertyPrefix());
        String string3 = string2 != null ? string2 + "-" : "";
        ArrayList<EstateAttachmentImpl> arrayList = new ArrayList<EstateAttachmentImpl>();
        ArrayList<EstateAttachmentImpl> arrayList2 = new ArrayList<EstateAttachmentImpl>();
        for (Object object322 : estateImpl.getAttachments()) {
            if (!object322.isName()) continue;
            if (object322.getMimeType().toLowerCase().startsWith("image/")) {
                arrayList.add((EstateAttachmentImpl)object322);
                continue;
            }
            arrayList2.add((EstateAttachmentImpl)object322);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("status", status != null ? status.name().toLowerCase() : DbAgencyObject.Status.PUBLISHED.name().toLowerCase(), 2));
        stringBuilder.append(this.writeArrayLine("action", estateImpl.getAction() != null ? estateImpl.getAction().name().toLowerCase() : "", 2));
        stringBuilder.append(this.writeArrayLine("type", estateImpl.getType() != null ? estateImpl.getType().name().toLowerCase() : "", 2));
        stringBuilder.append(this.writeArrayLine("type_path", (Enum[])estateImpl.getType().getParentPath(), 2));
        stringBuilder.append(this.writeArrayLine("currency", estateImpl.getCurrency() != null ? estateImpl.getCurrency().getCurrencyCode() : null, 2));
        stringBuilder.append(this.writeArrayLine("nr", !StringUtils.isBlank((CharSequence)estateImpl.getPublicId()) ? string3 + estateImpl.getPublicId() : null, 2));
        stringBuilder.append(this.writeArrayLine("hidden_price", estateImpl.isHiddenPrices(), 2));
        stringBuilder.append(this.writeArrayLine("group_nr", estateImpl.getGroupId(), 2));
        stringBuilder.append(this.writeArrayLine("created_at", date, 2));
        stringBuilder.append(this.writeArrayLine("modified_at", date2, 2));
        object322 = StringUtils.trimToNull((String)(agentContactImpl != null ? agentContactImpl.getPersonMail() : null));
        if (object322 == null) {
            object322 = StringUtils.trimToNull((String)(companyAddressImpl != null ? companyAddressImpl.getCompanyMail() : null));
        }
        if (object322 == null) {
            object322 = StringUtils.trimToNull((String)(companyAddressImpl != null ? companyAddressImpl.getPersonMail() : null));
        }
        stringBuilder.append(this.writeArrayLine("mail", (String)object322, 2));
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Locale object22 : ((AbstractFormat)this.format).getLanguages()) {
            String string4 = estateImpl.getTitle(object22);
            if (StringUtils.isBlank((CharSequence)string4)) {
                string4 = estateImpl.getFallbackTitle(object22);
            }
            stringBuilder2.append(this.writeArrayLine(object22.getLanguage(), string4, 4));
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        if (estateImpl.getAddress() != null) {
            stringBuilder3.append(this.writeAddress((AddressImpl)estateImpl.getAddress(), localeArray, 4));
        }
        StringBuilder stringBuilder4 = new StringBuilder();
        if (agentContactImpl != null) {
            stringBuilder4.append(this.writeAddress((AddressImpl)agentContactImpl, localeArray, 4));
        } else if (companyAddressImpl != null) {
            stringBuilder4.append(this.writeAddress((AddressImpl)companyAddressImpl, localeArray, 4));
        }
        StringBuilder stringBuilder5 = new StringBuilder();
        for (OpenEstateAttribGroup openEstateAttribGroup : OpenEstateAttribGroup.values()) {
            if (OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttribGroup)) continue;
            StringBuilder stringBuilder6 = new StringBuilder();
            for (OpenEstateAttrib openEstateAttrib : abstractTypeImpl.getAttribsByGroup(openEstateAttribGroup)) {
                String string5;
                AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
                if (abstractAttribImpl == null || abstractAttribImpl.hasEmptyValue()) continue;
                StringBuilder stringBuilder7 = new StringBuilder();
                if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                    Boolean bl = ((SimpleBooleanAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", bl, 8));
                } else if (abstractAttribImpl instanceof SimpleNumericAttrib) {
                    Number number = ((SimpleNumericAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", number, 8));
                } else if (abstractAttribImpl instanceof SimpleTimeAttrib) {
                    Date date3 = ((SimpleTimeAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", date3, 8));
                } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                    Enum enum_ = ((SimpleEnumAttrib)abstractAttribImpl).getValue();
                    String string6 = enum_ != null ? enum_.name() : null;
                    stringBuilder7.append(this.writeArrayLine("value", string6, 8));
                } else if (abstractAttribImpl instanceof ComplexAreaAttrib) {
                    AreaValue areaValue = ((ComplexAreaAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", (Number)areaValue, 8));
                    stringBuilder7.append(this.writeArrayLine("unit", areaValue.getUnit() != null ? areaValue.getUnit().name() : null, 8));
                } else if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
                    CurrencyValue currencyValue = ((ComplexCurrencyAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", (Number)currencyValue, 8));
                } else if (abstractAttribImpl instanceof ComplexEnergyConsumptionAttrib) {
                    EnergyConsumptionValue energyConsumptionValue = ((ComplexEnergyConsumptionAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", (Number)energyConsumptionValue, 8));
                    stringBuilder7.append(this.writeArrayLine("unit", energyConsumptionValue.getUnit() != null ? energyConsumptionValue.getUnit().name() : null, 8));
                } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                    Enum[] enumArray = ((ComplexEnumAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", enumArray, 8));
                } else if (abstractAttribImpl instanceof ComplexLengthAttrib) {
                    LengthValue lengthValue = ((ComplexLengthAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", (Number)lengthValue, 8));
                    stringBuilder7.append(this.writeArrayLine("unit", lengthValue.getUnit() != null ? lengthValue.getUnit().name() : null, 8));
                } else if (abstractAttribImpl instanceof ComplexStringAttrib) {
                    for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                        string5 = AgencyPluginUtils.writeValueForPublic(estateImpl, abstractAttribImpl, locale);
                        stringBuilder7.append(this.writeArrayLine(locale.getLanguage(), string5, 8));
                    }
                } else if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
                    VolumeValue volumeValue = ((ComplexVolumeAttrib)abstractAttribImpl).getValue();
                    stringBuilder7.append(this.writeArrayLine("value", (Number)volumeValue, 8));
                    stringBuilder7.append(this.writeArrayLine("unit", volumeValue.getUnit() != null ? volumeValue.getUnit().name() : null, 8));
                }
                for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                    string5 = OpenEstateUtils.serializeString((String)AgencyPluginUtils.writeValueForPublic(estateImpl, abstractAttribImpl, locale), (String)", ");
                    stringBuilder7.append(this.writeArrayLine(locale.getLanguage(), string5, 8));
                }
                stringBuilder6.append(this.writeArrayNode(openEstateAttrib.getAttribName().toLowerCase(), ImmoToolUtils.trimRight((String)stringBuilder7.toString()), 6));
            }
            stringBuilder5.append(this.writeArrayNode(openEstateAttribGroup.name().toLowerCase(), ImmoToolUtils.trimRight((String)stringBuilder6.toString()), 4));
        }
        StringBuilder stringBuilder8 = new StringBuilder();
        if (!arrayList.isEmpty()) {
            for (EstateAttachmentImpl stringBuilder12 : arrayList) {
                String string7 = FilenameUtils.getName((String)stringBuilder12.getFileAsName());
                int n = string7.lastIndexOf(".");
                object = string7.substring(0, n) + ".thumb.jpg";
                StringBuilder stringBuilder9 = new StringBuilder();
                stringBuilder9.append(this.writeArrayLine("name", string7, 6));
                stringBuilder9.append(this.writeArrayLine("thumb", (String)object, 6));
                stringBuilder9.append(this.writeArrayLine("mimetype", stringBuilder12.getMimeType(), 6));
                stringBuilder9.append(this.writeArrayLine("type", stringBuilder12.getType() != null ? stringBuilder12.getType().name().toLowerCase() : null, 6));
                StringBuilder stringBuilder10 = new StringBuilder();
                for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                    stringBuilder10.append(this.writeArrayLine(locale.getLanguage(), stringBuilder12.getTitle(locale), 8));
                }
                stringBuilder9.append(this.writeArrayNode("title", ImmoToolUtils.trimRight((String)stringBuilder10.toString()), 6));
                stringBuilder8.append(this.writeArrayNode(ImmoToolUtils.trimRight((String)stringBuilder9.toString()), 4));
            }
        }
        StringBuilder stringBuilder11 = new StringBuilder();
        if (!arrayList2.isEmpty()) {
            for (EstateAttachmentImpl estateAttachmentImpl : arrayList2) {
                String string8 = FilenameUtils.getName((String)estateAttachmentImpl.getFileAsName());
                object = new StringBuilder();
                ((StringBuilder)object).append(this.writeArrayLine("name", string8, 6));
                ((StringBuilder)object).append(this.writeArrayLine("mimetype", estateAttachmentImpl.getMimeType(), 6));
                ((StringBuilder)object).append(this.writeArrayLine("type", estateAttachmentImpl.getType() != null ? estateAttachmentImpl.getType().name().toLowerCase() : null, 6));
                StringBuilder stringBuilder12 = new StringBuilder();
                for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                    stringBuilder12.append(this.writeArrayLine(locale.getLanguage(), estateAttachmentImpl.getTitle(locale), 8));
                }
                ((StringBuilder)object).append(this.writeArrayNode("title", ImmoToolUtils.trimRight((String)stringBuilder12.toString()), 6));
                stringBuilder11.append(this.writeArrayNode(ImmoToolUtils.trimRight((String)((StringBuilder)object).toString()), 4));
            }
        }
        StringBuilder stringBuilder13 = new StringBuilder();
        for (EstateLinkImpl estateLinkImpl : estateImpl.getLinks()) {
            object = new StringBuilder();
            URI uRI = estateLinkImpl.getWebLink();
            EstateLinkImpl.ProviderLink providerLink = estateLinkImpl.getProviderLink();
            if (uRI != null) {
                ((StringBuilder)object).append(this.writeArrayLine("url", uRI.toString(), 6));
            } else if (providerLink != null) {
                ((StringBuilder)object).append(this.writeArrayLine("id", providerLink.getLinkId(), 6));
                ((StringBuilder)object).append(this.writeArrayLine("provider", providerLink.getProvider().getXmlName(), 6));
                URI uRI2 = providerLink.getProvider().getUrlFromLinkId(providerLink.getLinkId());
                ((StringBuilder)object).append(this.writeArrayLine("url", uRI2 != null ? uRI2.toString() : null, 6));
            } else {
                LOGGER.warn("Can't export incomplete link!");
                continue;
            }
            StringBuilder stringBuilder14 = new StringBuilder();
            for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                stringBuilder14.append(this.writeArrayLine(locale.getLanguage(), estateLinkImpl.getTitle(locale), 8));
            }
            ((StringBuilder)object).append(this.writeArrayNode("title", ImmoToolUtils.trimRight((String)stringBuilder14.toString()), 6));
            stringBuilder13.append(this.writeArrayNode(ImmoToolUtils.trimRight((String)((StringBuilder)object).toString()), 4));
        }
        map.put("OBJECT_ID", string);
        map.put("OBJECT_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
        map.put("OBJECT_TITLES", ImmoToolUtils.trimRight((String)stringBuilder2.toString()));
        map.put("ADDRESS_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder3.toString()));
        map.put("CONTACT_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder4.toString()));
        map.put("ATTRIBUTES_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder5.toString()));
        map.put("IMAGES_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder8.toString()));
        map.put("MEDIA_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder11.toString()));
        map.put("LINKS_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder13.toString()));
    }

    protected void initObjectTextsPhpValues(Map<String, String> map, EstateImpl estateImpl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.DESCRIPTIONS.getAttributes()) {
            AbstractAttribImpl abstractAttribImpl;
            if (estateImpl.isHiddenPrices() && OpenEstateAttrib.DESCRIPTIONS_PRICE_DESCRIPTION.equals((Object)openEstateAttrib) || (abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib)) == null || abstractAttribImpl.hasEmptyValue()) continue;
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
                String string2 = OpenEstateUtils.serializeString((String)AgencyPluginUtils.writeValueForPublic(estateImpl, abstractAttribImpl, locale), (String)"<br/>");
                stringBuilder2.append(this.writeArrayLine(locale.getLanguage(), string2, 4));
            }
            stringBuilder.append(this.writeArrayNode(openEstateAttrib.getAttribName().toLowerCase(), ImmoToolUtils.trimRight((String)stringBuilder2.toString()), 2));
        }
        map.put("OBJECT_ID", string);
        map.put("TEXT_DETAILS", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
    }

    protected void initTermsPhpValues(Map<String, String> map, AgentImpl agentImpl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Locale locale : ((AbstractFormat)this.format).getLanguages()) {
            String string = agentImpl.getTerms(locale);
            String string2 = !StringUtils.isBlank((CharSequence)string) ? OpenEstateUtils.serializeString((String)string.trim(), (String)"<br/>") : null;
            stringBuilder.append(this.writeArrayLine(locale.getLanguage(), string2, 2));
        }
        map.put("TERMS", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
    }

    protected void initTranslationPhpValues(Map<String, String> map, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        for (OpenEstateAction openEstateAction : OpenEstateAction.values()) {
            stringBuilder.append(this.writeArrayLine(openEstateAction.name().toLowerCase(), openEstateAction.getTranslation(locale), 6));
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        for (OpenEstateType openEstateType : OpenEstateType.values()) {
            stringBuilder2.append(this.writeArrayLine(openEstateType.name().toLowerCase(), openEstateType.getTranslation(locale), 6));
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        for (EstateAttachmentType estateAttachmentType : EstateAttachmentType.values()) {
            String string = estateAttachmentType.getTranslation(locale);
            stringBuilder3.append(this.writeArrayLine(estateAttachmentType.name().toLowerCase(), string, 6));
        }
        StringBuilder stringBuilder4 = new StringBuilder();
        StringBuilder stringBuilder5 = new StringBuilder();
        for (OpenEstateAttribGroup openEstateAttribGroup : OpenEstateAttribGroup.values()) {
            String string = openEstateAttribGroup.name().toLowerCase();
            stringBuilder5.append(this.writeArrayLine(string, openEstateAttribGroup.getTranslation(locale), 6));
            StringBuilder stringBuilder6 = new StringBuilder();
            for (OpenEstateAttrib openEstateAttrib : openEstateAttribGroup.getAttributes()) {
                String string2 = openEstateAttrib.getAttribName().toLowerCase();
                stringBuilder6.append(this.writeArrayLine(string2, openEstateAttrib.getTranslation(locale), 8));
            }
            stringBuilder4.append(this.writeArrayNode(string, stringBuilder6.toString(), 6));
        }
        map.put("LANGUAGE_NAME", locale.getDisplayLanguage(locale) + " / " + locale.getDisplayLanguage(Locale.GERMAN));
        map.put("LANGUAGE_CODE", locale.getLanguage());
        map.put("I18N_OPENESTATE_ACTIONS", ImmoToolUtils.trimRight((String)stringBuilder.toString()));
        map.put("I18N_OPENESTATE_ATTACHMENTS", ImmoToolUtils.trimRight((String)stringBuilder3.toString()));
        map.put("I18N_OPENESTATE_ATTRIBUTES", ImmoToolUtils.trimRight((String)stringBuilder4.toString()));
        map.put("I18N_OPENESTATE_GROUPS", ImmoToolUtils.trimRight((String)stringBuilder5.toString()));
        map.put("I18N_OPENESTATE_TYPES", ImmoToolUtils.trimRight((String)stringBuilder2.toString()));
    }

    protected AgentContactImpl lookupContact(String string, TransferAgencyImpl transferAgencyImpl) {
        return (AgentContactImpl)transferAgencyImpl.getContacts().get(string);
    }

    protected EstateImpl lookupEstate(String string, TransferAgencyImpl transferAgencyImpl) {
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            if (!estateImpl.getId().equals(string)) continue;
            return estateImpl;
        }
        return null;
    }

    protected String readResource(String string) throws IOException {
        return this.readResource(string, null);
    }

    protected String readResource(String string, Map<String, String> map) throws IOException {
        URL uRL = AbstractPhpBuilder.class.getResource(this.packagePath + string);
        if (uRL == null) {
            throw new IOException("Can't find resource: " + this.packagePath + string);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());){
            String string2 = IOUtils.toString((InputStream)bufferedInputStream, (String)this.encoding);
            String string3 = map != null ? StringSubstitutor.replace((Object)string2, map) : string2;
            return string3;
        }
    }

    protected String replaceVariable(String string, String string2, Object object) {
        int n = StringUtils.indexOf((CharSequence)string, (CharSequence)string2);
        if (n < 0) {
            return string;
        }
        int n2 = StringUtils.indexOf((CharSequence)string, (CharSequence)"=", (int)n);
        if (n2 < 0) {
            return string;
        }
        int n3 = StringUtils.indexOf((CharSequence)string, (CharSequence)";", (int)n2);
        if (n3 < 0) {
            return string;
        }
        String string3 = object instanceof String ? "'" + StringUtils.replace((String)((String)object), (String)"'", (String)"\\'") + "'" : (object instanceof Boolean ? object.toString() : (object instanceof Number ? object.toString() : "null"));
        String string4 = StringUtils.substring((String)string, (int)n, (int)n3);
        String string5 = string2 + " = " + string3;
        return StringUtils.replaceOnce((String)string, (String)string4, (String)string5);
    }

    protected void saveResource(String string, File file) throws IOException {
        URL uRL = AbstractPhpBuilder.class.getResource(this.packagePath + string);
        if (uRL == null) {
            throw new IOException("Can't find resource: " + this.packagePath + string);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());){
            ImmoToolUtils.writeStreamToFile((InputStream)bufferedInputStream, (File)file);
        }
    }

    protected void saveText(String string, File file) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)string, (String)this.encoding);
    }

    public abstract void write(TransferImpl var1, ExportContext var2, DbAgencyExpose var3) throws IOException, SQLException;

    protected String writeAddress(AddressImpl addressImpl, Locale[] estateAddressImpl, int n) {
        EstateAddressImpl estateAddressImpl2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.writeArrayLine("country", addressImpl.getCountry(), n));
        StringBuilder stringBuilder2 = new StringBuilder();
        if (estateAddressImpl != null && ((Locale[])estateAddressImpl).length > 0) {
            for (Locale locale : estateAddressImpl) {
                stringBuilder2.append(this.writeArrayLine(locale.getLanguage(), addressImpl.writeCountry(locale), n + 2));
            }
        }
        stringBuilder.append(this.writeArrayNode("country_name", ImmoToolUtils.trimRight((String)stringBuilder2.toString()), n));
        stringBuilder.append(this.writeArrayLine("postal", addressImpl.getPostalCode(), n));
        stringBuilder.append(this.writeArrayLine("city", addressImpl.getCity(), n));
        stringBuilder.append(this.writeArrayLine("city_part", addressImpl.getDistrict(), n));
        if (addressImpl instanceof EstateAddressImpl) {
            estateAddressImpl2 = (EstateAddressImpl)addressImpl;
            stringBuilder.append(this.writeArrayLine("street", estateAddressImpl2.isPublished() ? addressImpl.getStreet() : null, n));
            stringBuilder.append(this.writeArrayLine("street_nr", estateAddressImpl2.isPublished() ? addressImpl.getStreetNr() : null, n));
        } else {
            stringBuilder.append(this.writeArrayLine("street", addressImpl.getStreet(), n));
            stringBuilder.append(this.writeArrayLine("street_nr", addressImpl.getStreetNr(), n));
        }
        stringBuilder.append(this.writeArrayLine("region", addressImpl.getRegion(), n));
        stringBuilder.append(this.writeArrayLine("latitude", addressImpl.getLatitude(), n));
        stringBuilder.append(this.writeArrayLine("longitude", addressImpl.getLongitude(), n));
        if (addressImpl instanceof PersonAddressImpl) {
            estateAddressImpl2 = (PersonAddressImpl)addressImpl;
            stringBuilder.append(this.writeArrayLine("person_title", estateAddressImpl2.getPersonTitle(), n));
            stringBuilder.append(this.writeArrayLine("person_firstname", estateAddressImpl2.getPersonFirstName(), n));
            stringBuilder.append(this.writeArrayLine("person_middlename", estateAddressImpl2.getPersonMiddleName(), n));
            stringBuilder.append(this.writeArrayLine("person_lastname", estateAddressImpl2.getPersonLastName(), n));
            stringBuilder.append(this.writeArrayLine("person_fullname", estateAddressImpl2.writePersonFullName(), n));
            stringBuilder.append(this.writeArrayLine("person_mail", estateAddressImpl2.getPersonMail(), n));
            stringBuilder.append(this.writeArrayLine("person_phone", estateAddressImpl2.getPersonPhone(), n));
            stringBuilder.append(this.writeArrayLine("person_mobile", estateAddressImpl2.getPersonMobilePhone(), n));
            stringBuilder.append(this.writeArrayLine("person_fax", estateAddressImpl2.getPersonFax(), n));
            Gender gender = estateAddressImpl2.getPersonGender();
            stringBuilder.append(this.writeArrayLine("person_gender", gender != null ? gender.name() : null, n));
        }
        if (addressImpl instanceof CompanyAddressImpl) {
            estateAddressImpl2 = (CompanyAddressImpl)addressImpl;
            stringBuilder.append(this.writeArrayLine("company_name", estateAddressImpl2.getCompanyName(), n));
            stringBuilder.append(this.writeArrayLine("company_name_addition", estateAddressImpl2.getCompanyNameAddition(), n));
            stringBuilder.append(this.writeArrayLine("company_type", estateAddressImpl2.getCompanyLegalForm(), n));
            stringBuilder.append(this.writeArrayLine("company_business", estateAddressImpl2.getCompanyBusiness(), n));
            stringBuilder.append(this.writeArrayLine("company_department", estateAddressImpl2.getCompanyDepartment(), n));
            stringBuilder.append(this.writeArrayLine("company_position", estateAddressImpl2.getCompanyPosition(), n));
            stringBuilder.append(this.writeArrayLine("company_mail", estateAddressImpl2.getCompanyMail(), n));
            stringBuilder.append(this.writeArrayLine("company_phone", estateAddressImpl2.getCompanyPhone(), n));
            stringBuilder.append(this.writeArrayLine("company_mobile", estateAddressImpl2.getCompanyMobilePhone(), n));
            stringBuilder.append(this.writeArrayLine("company_fax", estateAddressImpl2.getCompanyFax(), n));
            stringBuilder.append(this.writeArrayLine("company_website", estateAddressImpl2.getCompanyWebsite() != null ? estateAddressImpl2.getCompanyWebsite().toString() : "", n));
        }
        return ImmoToolUtils.trimRight((String)stringBuilder.toString());
    }

    protected String writeArrayLine(String string, String string2, int n) {
        String string3 = StringUtils.repeat((String)" ", (int)n);
        String string4 = !StringUtils.isBlank((CharSequence)string2) ? "'" + string2.replaceAll(Pattern.quote("'"), "\\\\'") + "'" : "null";
        return string3 + "'" + string + "' => " + string4 + "," + System.lineSeparator();
    }

    protected String writeArrayLine(String string, Enum[] enumArray, int n) {
        String[] stringArray = null;
        if (!ArrayUtils.isEmpty((Object[])enumArray)) {
            stringArray = new String[enumArray.length];
            for (int i = 0; i < enumArray.length; ++i) {
                stringArray[i] = enumArray[i].name();
            }
        }
        return this.writeArrayLine(string, stringArray, n);
    }

    protected String writeArrayLine(String string, String[] stringArray, int n) {
        String string2;
        String string3 = StringUtils.repeat((String)" ", (int)n);
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : stringArray) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append(string4.toLowerCase().replaceAll(Pattern.quote("'"), "\\\\'")).append("'");
            }
            string2 = "array(" + stringBuilder.toString() + ")";
        } else {
            string2 = "null";
        }
        return string3 + "'" + string + "' => " + string2 + "," + System.lineSeparator();
    }

    protected String writeArrayLine(String string, Date date, int n) {
        return this.writeArrayLine(string, date != null ? Long.valueOf(date.getTime() / 1000L) : null, n);
    }

    protected String writeArrayLine(String string, Number number, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = number != null ? number.toString() : "null";
        return string2 + "'" + string + "' => " + string3 + "," + System.lineSeparator();
    }

    protected String writeArrayLine(String string, Boolean bl, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = bl != null ? bl.toString().toLowerCase() : "null";
        return string2 + "'" + string + "' => " + string3 + "," + System.lineSeparator();
    }

    protected String writeArrayNode(String string, int n) {
        String string2 = StringUtils.repeat((String)" ", (int)n);
        String string3 = StringUtils.repeat((String)" ", (int)(n + 2));
        String string4 = !StringUtils.isBlank((CharSequence)string) ? string3 + string.trim() + System.lineSeparator() : "";
        return string2 + "array(" + System.lineSeparator() + string4 + string2 + ")," + System.lineSeparator();
    }

    protected String writeArrayNode(String string, String string2, int n) {
        String string3 = StringUtils.repeat((String)" ", (int)n);
        String string4 = StringUtils.repeat((String)" ", (int)(n + 2));
        String string5 = !StringUtils.isBlank((CharSequence)string2) ? string4 + string2.trim() + System.lineSeparator() : "";
        return string3 + "'" + string + "' => array(" + System.lineSeparator() + string5 + string3 + ")," + System.lineSeparator();
    }

    protected void writeHtaccess(File file) throws IOException {
        File file2 = new File(file, HTACCESS);
        if (!file2.exists()) {
            this.saveResource("htaccess.txt", file2);
        }
    }

    protected void writeIndexHtml(File file) throws IOException {
        File file2 = new File(file, INDEX_HTML);
        if (!file2.exists()) {
            FileUtils.touch((File)file2);
        }
    }
}

