/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.is24.Is24XmlWriter;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractXmlFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.Is24XmlFormatPanel;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.db.AbstractDbDriver;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.is24_xml.Is24XmlDocument;
import org.openestate.io.is24_xml.Is24XmlUtils;
import org.openestate.io.is24_xml.xml.IS24ImmobilienTransfer;
import org.openestate.io.is24_xml.xml.ImmobilieBaseTyp;
import org.openestate.io.is24_xml.xml.ImmobilienTransferTyp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class Is24XmlFormat
extends AbstractXmlFormat<IS24ImmobilienTransfer> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24XmlFormat.class);
    private static final I18n I18N = I18nFactory.getI18n(Is24XmlFormat.class);
    private static final String NAME = "is24_xml";
    public static final String GEODB = "is24";

    protected Is24XmlWriter buildWriter() {
        return this.buildWriter(null, null);
    }

    private Writer buildWriter(ExportContext exportContext) {
        return exportContext != null ? this.buildWriter(exportContext.dbDriver, exportContext.dbExtension) : this.buildWriter(null, null);
    }

    private Writer buildWriter(AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
        Writer writer = new Writer(this.getLanguage(), abstractDbDriver, dbAgencyExtension);
        writer.setEnergyCertificateAppendedToDescription(this.isPropertyDescriptionWithEnergyCertificate());
        AbstractXmlFormat.LineBreakMode lineBreakMode = this.getXmlLineBreak();
        if (lineBreakMode != null) {
            writer.setXmlLineSeparator(lineBreakMode.getSeparator());
        }
        return writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String calculateHashForObject(long l, EstateImpl estateImpl) throws AbstractFormat.NotExportableException, AbstractFormat.HashCalculationException {
        String string;
        IS24ImmobilienTransfer iS24ImmobilienTransfer;
        Object object;
        if (!this.prepareObjectForExport(l, estateImpl)) {
            throw new AbstractFormat.NotExportableException("Preparation failed!");
        }
        AgencyImpl agencyImpl = new AgencyImpl();
        agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
        try {
            object = this.buildWriter();
            object.setXmlLineSeparator("<br/>");
            iS24ImmobilienTransfer = (IS24ImmobilienTransfer)object.writeToObject(agencyImpl);
            string = object.getErrorMessages(estateImpl.getId());
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert property #" + l + "!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            throw new AbstractFormat.NotExportableException("Can't convert property #" + l + "! (" + exception.getLocalizedMessage() + ")", exception);
        }
        if (iS24ImmobilienTransfer == null) throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        if (string != null) {
            throw new AbstractFormat.NotExportableException(StringUtils.trimToNull((String)string));
        }
        ((ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue()).setEmailBeiFehler(null);
        ((ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue()).setErstellerSoftware(null);
        ((ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue()).setErstellerSoftwareVersion(null);
        if (((ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue()).getAnbieter() != null) {
            ((ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue()).getAnbieter().setScoutKundenID(null);
        }
        try {
            object = new StringWriter();
            Throwable throwable = null;
            try {
                Is24XmlUtils.createMarshaller((String)"UTF-8", (boolean)false).marshal((Object)iS24ImmobilienTransfer, (java.io.Writer)object);
                String string2 = ((StringWriter)object).toString().replaceAll("(\r\n|\n\r|\r|\n)", "");
                String string3 = DigestUtils.sha1Hex((String)string2);
                return string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((StringWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((StringWriter)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new AbstractFormat.HashCalculationException(exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new Is24XmlFormatPanel();
    }

    @Override
    protected IS24ImmobilienTransfer convertXml(TransferImpl transferImpl, ExportContext exportContext) {
        Writer writer = this.buildWriter(exportContext);
        IS24ImmobilienTransfer iS24ImmobilienTransfer = writer.writeToObject(transferImpl);
        if (iS24ImmobilienTransfer == null) {
            return null;
        }
        ImmobilienTransferTyp immobilienTransferTyp = (ImmobilienTransferTyp)iS24ImmobilienTransfer.getValue();
        String string = StringUtils.trimToNull((String)this.getAgentMail());
        if (string == null) {
            try {
                string = exportContext.agent.getCompany().getCompanyMail();
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load 'EmailBeiFehler'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        immobilienTransferTyp.setEmailBeiFehler(StringUtils.trimToEmpty((String)string));
        String string2 = this.getAgentId();
        if (string2 != null && string2.trim().length() > 0) {
            immobilienTransferTyp.getAnbieter().setScoutKundenID(string2);
        }
        exportContext.addErrorMessages(writer.getErrorMap(), AbstractFormat.DefaultMessageCode.FORMAT_CONVERSION_FAILED.name());
        return iS24ImmobilienTransfer;
    }

    @Override
    protected String getCompressedFileName(AbstractFormat.Compression compression, ExportContext exportContext) {
        String string = super.getCompressedFileName(compression, exportContext);
        char c = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode) ? (char)'t' : 'v';
        int n = string.lastIndexOf(".");
        return string.substring(0, n) + "_st_Z7P_im" + c + string.substring(n);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return new String[]{"application/pdf", "image/bmp", "image/gif", "image/jpeg", "image/png", "image/svg+xml", "image/tiff", "video/avi", "video/flv", "video/mp4", "video/mpeg", "video/msvideo", "video/ogg", "video/quicktime", "video/vnd.rn-realvideo", "video/x-flv", "video/x-ms-asf", "video/x-ms-wmv", "video/x-msvideo", "video/x-sgi-movie"};
    }

    @Override
    public AbstractFormat.TransferMode[] getSupportedTransferModes() {
        return new AbstractFormat.TransferMode[]{AbstractFormat.TransferMode.FULL, AbstractFormat.TransferMode.INCREMENTAL};
    }

    @Override
    public String getTitle() {
        return "IS24-XML";
    }

    @Override
    public String getVersion() {
        return "rev189438";
    }

    @Override
    protected String getXmlFileName(ExportContext exportContext) {
        String string = super.getXmlFileName(exportContext);
        char c = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode) ? (char)'t' : 'v';
        return string.substring(0, string.lastIndexOf(".")) + "_st_Z7P_im" + c + ".xml";
    }

    @Override
    public void initDefaults() {
        super.initDefaults();
        this.setCompression(AbstractFormat.Compression.ZIP);
        this.setLanguages(new Locale[]{Locale.GERMAN});
    }

    @Override
    public boolean prepareObjectForExport(long l, EstateImpl estateImpl) {
        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(GEODB);
        if (!super.prepareObjectForExport(l, estateImpl)) {
            return false;
        }
        estateImpl.removeCustomGeoAreas();
        if (geoAreaImpl != null) {
            estateImpl.putCustomGeoArea(GEODB, geoAreaImpl);
        }
        return true;
    }

    @Override
    protected void writeXmlObject(IS24ImmobilienTransfer iS24ImmobilienTransfer, java.io.Writer writer) throws IOException, JAXBException {
        try {
            Is24XmlDocument is24XmlDocument = Is24XmlDocument.newDocument((IS24ImmobilienTransfer)iS24ImmobilienTransfer);
            is24XmlDocument.toXml(writer, true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Can't create parser!", parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Can't write document!", transformerException);
        }
    }

    public static class Writer
    extends Is24XmlWriter {
        private final Map<Long, DbGeoArea> areas;
        private final AbstractDbDriver dbDriver;
        private final DbAgencyExtension dbExtension;
        private Connection dbConnection = null;

        public Writer(Locale locale) {
            this(locale, null, null);
        }

        public Writer(Locale locale, AbstractDbDriver abstractDbDriver, DbAgencyExtension dbAgencyExtension) {
            super(locale);
            this.dbDriver = abstractDbDriver;
            this.dbExtension = dbAgencyExtension;
            this.areas = new HashMap<Long, DbGeoArea>();
            AgencyPluginUtils.initJAXB(Is24XmlUtils.class);
        }

        protected JAXBElement convertEstate(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
            JAXBElement jAXBElement = super.convertEstate(estateImpl, agentImpl, agentContactImpl, list);
            if (jAXBElement == null || !list.isEmpty()) {
                return null;
            }
            Object object = jAXBElement.getValue();
            if (object instanceof ImmobilieBaseTyp) {
                ImmobilieBaseTyp immobilieBaseTyp = (ImmobilieBaseTyp)object;
                if (this.dbDriver != null) {
                    DbGeoArea dbGeoArea = null;
                    try {
                        GeoAreaImpl geoAreaImpl = estateImpl.getCustomGeoArea(Is24XmlFormat.GEODB);
                        dbGeoArea = geoAreaImpl != null ? this.lookupArea(geoAreaImpl) : null;
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't load areas from geodb 'is24'!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                    if (dbGeoArea != null) {
                        immobilieBaseTyp.getAdresse().setInternationaleRegion(dbGeoArea.name);
                    }
                }
            }
            return jAXBElement;
        }

        protected ImmobilienTransferTyp createRoot() {
            ImmobilienTransferTyp immobilienTransferTyp = super.createRoot();
            immobilienTransferTyp.setErstellerSoftware(ImmoToolEnvironment.getApplicationTitle());
            immobilienTransferTyp.setErstellerSoftwareVersion(ImmoToolEnvironment.getApplicationVersion());
            return immobilienTransferTyp;
        }

        private Connection initConnection() throws SQLException {
            if (this.dbConnection == null) {
                this.dbConnection = this.dbDriver.getConnection();
            }
            return this.dbConnection;
        }

        private DbGeoArea lookupArea(Long l) throws SQLException {
            if (this.areas.containsKey(l)) {
                return this.areas.get(l);
            }
            Connection connection = this.initConnection();
            DbGeoArea dbGeoArea = this.dbExtension.getGeoHandler().getGeoArea(connection, l.longValue());
            this.areas.put(dbGeoArea.id, dbGeoArea);
            return dbGeoArea;
        }

        private DbGeoArea lookupArea(GeoAreaImpl geoAreaImpl) throws SQLException {
            Long l = Long.valueOf(geoAreaImpl.getId());
            return this.lookupArea(l);
        }

        public IS24ImmobilienTransfer writeToObject(AgencyImpl agencyImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                IS24ImmobilienTransfer iS24ImmobilienTransfer = (IS24ImmobilienTransfer)super.writeToObject(agencyImpl);
                return iS24ImmobilienTransfer;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }

        public IS24ImmobilienTransfer writeToObject(TransferImpl transferImpl) {
            this.areas.clear();
            this.dbConnection = null;
            try {
                IS24ImmobilienTransfer iS24ImmobilienTransfer = (IS24ImmobilienTransfer)super.writeToObject(transferImpl);
                return iS24ImmobilienTransfer;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)this.dbConnection);
                this.dbConnection = null;
                this.areas.clear();
            }
        }
    }
}

