/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.jcraft.jsch.ChannelSftp;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExportAction;
import com.openindex.openestate.tool.agency.db.DbAgencyExportPublishing;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.AbstractPhpFormat;
import com.openindex.openestate.tool.agency.export.ExportContext;
import com.openindex.openestate.tool.agency.export.ExportEntry;
import com.openindex.openestate.tool.agency.export.FtpTransport;
import com.openindex.openestate.tool.agency.export.SftpTransport;
import com.openindex.openestate.tool.agency.export.WebsitePhp2Builder;
import com.openindex.openestate.tool.agency.export.WebsitePhp2FormatPanel;
import com.openindex.openestate.tool.utils.FtpUtils;
import com.openindex.openestate.tool.utils.SftpClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsitePhp2Format
extends AbstractPhpFormat {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitePhp2Format.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsitePhp2Format.class);
    private static final String NAME = "website_php2";
    private static final String STAMP = "immotool.php.stamp";
    private static final String LOCK = "immotool.php.lock";
    private static final String PHP_COMPANY = "website_php2.company";
    private static final String PHP_FEED_ATOM = "website_php2.feed.atom";
    private static final String PHP_FEED_RSS = "website_php2.feed.rss";
    private static final String PHP_FEED_TROVIT = "website_php2.feed.trovit";
    private static final String PHP_SAVE_SCRIPTS = "website_php2.saveScripts";

    @Override
    protected FtpTransport.Request createExportRequestForFtp(FtpTransport ftpTransport, File file) {
        return new FtpTransfer(ftpTransport, file);
    }

    @Override
    protected SftpTransport.Request createExportRequestForSftp(SftpTransport sftpTransport, File file) {
        return new SftpTransfer(sftpTransport, file);
    }

    @Override
    public AbstractFormatPanel createSetupPanel() {
        return new WebsitePhp2FormatPanel();
    }

    @Override
    protected File getAttachmentDirectory(long l, EstateAttachmentImpl estateAttachmentImpl, File file) {
        String string = StringUtils.trimToNull((String)this.getPropertyPrefix());
        string = string != null ? string + "-" : "";
        return new File(new File(file, "data"), string + l);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getPhpCompany() {
        return StringUtils.trimToNull((String)((String)this.get(PHP_COMPANY)));
    }

    public static Locale[] getSupportedLocales() {
        return new Locale[]{Locale.ENGLISH, Locale.GERMAN};
    }

    @Override
    protected int getThumbnailHeight() {
        return 325;
    }

    @Override
    protected int getThumbnailWidth() {
        return 500;
    }

    @Override
    public String getTitle() {
        return "Website: PHP-Export 2.x";
    }

    @Override
    public String getVersion() {
        return AgencyPlugin.getInstance().getPhpExport2Version();
    }

    public boolean isPhpFeedAtom() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_ATOM)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpFeedRss() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_RSS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isPhpFeedTrovit() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_FEED_TROVIT)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    @Override
    public boolean isPhpSaveScripts() {
        String string = StringUtils.trimToNull((String)((String)this.get(PHP_SAVE_SCRIPTS)));
        return string != null && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public void setPhpCompany(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            this.remove(PHP_COMPANY);
        } else {
            this.put(PHP_COMPANY, string);
        }
    }

    public void setPhpFeedAtom(boolean bl) {
        this.put(PHP_FEED_ATOM, String.valueOf(bl));
    }

    public void setPhpFeedRss(boolean bl) {
        this.put(PHP_FEED_RSS, String.valueOf(bl));
    }

    public void setPhpFeedTrovit(boolean bl) {
        this.put(PHP_FEED_TROVIT, String.valueOf(bl));
    }

    @Override
    public void setPhpSaveScripts(boolean bl) {
        this.put(PHP_SAVE_SCRIPTS, String.valueOf(bl));
    }

    @Override
    public File writeToDisk(File file, TransferImpl transferImpl, ExportContext exportContext) throws IOException, SQLException {
        DbAgencyExpose dbAgencyExpose = this.createExpose(exportContext);
        new WebsitePhp2Builder(this).write(transferImpl, exportContext, dbAgencyExpose);
        return exportContext.getWorkDir();
    }

    private static class SftpTransfer
    extends SftpTransport.Request {
        private transient String remoteBasePath = null;

        private SftpTransfer(SftpTransport sftpTransport, File file) {
            super(sftpTransport, file);
        }

        @Override
        protected void doTransportFinish(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            super.doTransportFinish(sftpClient, file, exportContext, callback);
            String string = StringUtils.trimToEmpty((String)this.remoteBasePath);
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                callback.checkCancelled();
                String string2 = string + "cache";
                sftpClient.chmod("777", string2);
                callback.checkCancelled();
                for (ChannelSftp.LsEntry lsEntry : sftpClient.ls(string2)) {
                    String string3 = lsEntry.getFilename();
                    if (lsEntry.getAttrs().isDir() || "index.html".equalsIgnoreCase(string3) || ".htaccess".equalsIgnoreCase(string3)) continue;
                    sftpClient.rm(string2 + "/" + string3);
                }
                callback.checkCancelled();
                String string4 = string + WebsitePhp2Format.LOCK;
                sftpClient.rm(string4);
            }
            catch (IOException iOException) {
                throw new IOException("Can't finish the export process!", iOException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doTransportInit(SftpClient sftpClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            Object object;
            ArrayList arrayList;
            block80: {
                ArrayList<String> arrayList2;
                String string;
                boolean bl;
                WebsitePhp2Format websitePhp2Format;
                block79: {
                    void exception;
                    boolean bl2;
                    if (!file.isDirectory()) {
                        return;
                    }
                    websitePhp2Format = (WebsitePhp2Format)exportContext.getFormat();
                    bl = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
                    String string2 = StringUtils.trimToNull((String)exportContext.export.getFormat().getPropertyPrefix());
                    string = string2 != null ? string2 + "-" : "";
                    try {
                        callback.checkCancelled();
                        this.remoteBasePath = StringUtils.trimToEmpty((String)sftpClient.pwd());
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't get current working directory from SFTP server!", iOException);
                    }
                    try {
                        callback.checkCancelled();
                        sftpClient.put((InputStream)new ByteArrayInputStream(new byte[0]), WebsitePhp2Format.LOCK);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't save lock file!", iOException);
                    }
                    arrayList2 = new ArrayList<String>();
                    try {
                        callback.checkCancelled();
                        for (File[] fileArray : sftpClient.ls()) {
                            arrayList2.add(fileArray.getFilename());
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't read file names from SFTP server!", iOException);
                    }
                    arrayList = new ArrayList();
                    callback.checkCancelled();
                    for (File object22 : (File[])ObjectUtils.defaultIfNull((Object)new File(file, "data").listFiles(), (Object)new File[0])) {
                        if (!object22.isDirectory()) continue;
                        arrayList.add(object22.getName());
                    }
                    boolean bl3 = bl2 = !arrayList2.contains(WebsitePhp2Format.STAMP);
                    if (!bl2) break block79;
                    callback.checkCancelled();
                    object = (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0]);
                    int n = ((File[])object).length;
                    boolean bl4 = false;
                    while (exception < n) {
                        File file2 = object[exception];
                        if (arrayList2.contains(file2.getName())) {
                            throw new IOException("The file '" + file2.getName() + "' already exists on the SFTP server!");
                        }
                        ++exception;
                    }
                    break block80;
                }
                object = new ArrayList();
                File file3 = null;
                try {
                    callback.checkCancelled();
                    file3 = File.createTempFile("immotool.", ".stamp");
                    try (FileOutputStream exception = new FileOutputStream(file3);){
                        sftpClient.get(WebsitePhp2Format.STAMP, (OutputStream)exception);
                        exception.flush();
                    }
                    for (String string2 : ImmoToolUtils.readFile((File)file3).split("\\n")) {
                        String string3 = StringUtils.trimToNull((String)string2);
                        if (string3 == null || object.contains(string3)) continue;
                        object.add(string3);
                    }
                }
                catch (Exception exception) {
                    try {
                        throw new IOException("Can't read 'immotool.php.stamp' from SFTP server!", exception);
                    }
                    catch (Throwable throwable) {
                        FileUtils.deleteQuietly(file3);
                        throw throwable;
                    }
                }
                FileUtils.deleteQuietly((File)file3);
                if (!bl) {
                    callback.checkCancelled();
                    try {
                        sftpClient.rmdir("data", true);
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't remove old data files from SFTP server!", exception);
                    }
                }
                callback.checkCancelled();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if ((string4 = StringUtils.trimToNull((String)string4)) == null || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
                try {
                    for (ExportEntry exportEntry : exportContext.entries) {
                        if (!DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) continue;
                        String string5 = null;
                        if (exportContext.export.publishings.containsKey(exportEntry.objectId)) {
                            DbAgencyExportPublishing dbAgencyExportPublishing = exportContext.export.publishings.get(exportEntry.objectId);
                            string5 = StringUtils.trimToNull((String)dbAgencyExportPublishing.objectKey);
                        }
                        if (string5 == null) {
                            string5 = string + exportEntry.objectId;
                        }
                        sftpClient.rmdir("data/" + string5, true);
                        callback.checkCancelled();
                        if (!DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) continue;
                        arrayList.remove(string5);
                    }
                }
                catch (Exception exception) {
                    throw new IOException("Can't remove old data files from SFTP server!", exception);
                }
                if (websitePhp2Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    for (File file4 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                        String string6 = file4.getName();
                        if (file4.isFile()) {
                            if ("config.php".equals(string6) || "custom.css".equals(string6)) continue;
                            sftpClient.rm(string6);
                            continue;
                        }
                        if (!file4.isDirectory() || "data".equals(file4.getName())) continue;
                        for (File file5 : (File[])ObjectUtils.defaultIfNull((Object)file4.listFiles(), (Object)new File[0])) {
                            string6 = file4.getName() + "/" + file5.getName();
                            if (file5.isFile()) {
                                sftpClient.rm(string6);
                                continue;
                            }
                            if (!file5.isDirectory()) continue;
                            sftpClient.rmdir(string6, true);
                        }
                    }
                }
                if (arrayList2.contains("config.php")) {
                    File file6 = new File(file, "config.php");
                    if (file6.isFile()) {
                        FileUtils.deleteQuietly((File)file6);
                    }
                    callback.checkCancelled();
                }
                if (arrayList2.contains("custom.css")) {
                    File file7 = new File(file, "custom.css");
                    if (file7.isFile()) {
                        FileUtils.deleteQuietly((File)file7);
                    }
                    callback.checkCancelled();
                }
            }
            object = File.createTempFile(WebsitePhp2Format.STAMP, "");
            try {
                Throwable throwable = null;
                try (Object object4 = new FileWriterWithEncoding((File)object, "UTF-8");){
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        ((Writer)object4).write(string);
                        ((Writer)object4).write("\n");
                    }
                    ((Writer)object4).flush();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                object4 = new FileInputStream((File)object);
                Throwable throwable4 = null;
                try {
                    sftpClient.put((InputStream)object4, WebsitePhp2Format.STAMP);
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (object4 != null) {
                        if (throwable4 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (Throwable throwable7) {
                                throwable4.addSuppressed(throwable7);
                            }
                        } else {
                            ((InputStream)object4).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't write 'immotool.php.stamp' to SFTP server!", iOException);
            }
            finally {
                FileUtils.deleteQuietly((File)object);
            }
        }
    }

    private static class FtpTransfer
    extends FtpTransport.Request {
        private transient String remoteBasePath = null;

        private FtpTransfer(FtpTransport ftpTransport, File file) {
            super(ftpTransport, file);
        }

        @Override
        protected void doTransportFinish(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            super.doTransportFinish(fTPClient, file, exportContext, callback);
            String string = StringUtils.trimToEmpty((String)this.remoteBasePath);
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                callback.checkCancelled();
                String string2 = string + "cache";
                if (fTPClient.site("CHMOD 777 " + string2) != 200) {
                    LOGGER.warn("Can't CHMOD the cache-directory!");
                }
                callback.checkCancelled();
                for (FTPFile fTPFile : fTPClient.listFiles(string2)) {
                    if (fTPFile.getType() != 0 || "index.html".equalsIgnoreCase(fTPFile.getName()) || ".htaccess".equalsIgnoreCase(fTPFile.getName()) || fTPClient.deleteFile(string2 + "/" + fTPFile.getName())) continue;
                    LOGGER.warn("Can't remove file: " + string2 + "/" + fTPFile.getName());
                }
                callback.checkCancelled();
                String string3 = string + WebsitePhp2Format.LOCK;
                if (!fTPClient.deleteFile(string3)) {
                    LOGGER.warn("Can't remove lock-file from: " + string3);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't finish the export process!", iOException);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void doTransportInit(FTPClient fTPClient, File file, ExportContext exportContext, ImmoToolTask.Callback callback) throws IOException, CancellationException {
            Object object;
            ArrayList<String> arrayList;
            block70: {
                List<Object> list;
                String string;
                boolean bl;
                WebsitePhp2Format websitePhp2Format;
                block69: {
                    void exception;
                    boolean bl2;
                    if (!file.isDirectory()) {
                        return;
                    }
                    websitePhp2Format = (WebsitePhp2Format)exportContext.getFormat();
                    bl = AbstractFormat.TransferMode.INCREMENTAL.equals((Object)exportContext.transferMode);
                    String string2 = StringUtils.trimToNull((String)exportContext.export.getFormat().getPropertyPrefix());
                    string = string2 != null ? string2 + "-" : "";
                    try {
                        callback.checkCancelled();
                        this.remoteBasePath = FtpUtils.getWorkingDirectory((FTPClient)fTPClient);
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't get current working directory from FTP server!", iOException);
                    }
                    try {
                        callback.checkCancelled();
                        if (!FtpUtils.storeEmptyFile((FTPClient)fTPClient, (String)WebsitePhp2Format.LOCK)) {
                            LOGGER.warn("Can't save lock-file!");
                        }
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't save lock file!", iOException);
                    }
                    try {
                        callback.checkCancelled();
                        list = Arrays.asList((Object[])ObjectUtils.defaultIfNull((Object)fTPClient.listNames(), (Object)new String[0]));
                    }
                    catch (IOException iOException) {
                        throw new IOException("Can't read file names from FTP server!", iOException);
                    }
                    arrayList = new ArrayList<String>();
                    callback.checkCancelled();
                    for (File object22 : (File[])ObjectUtils.defaultIfNull((Object)new File(file, "data").listFiles(), (Object)new File[0])) {
                        if (!object22.isDirectory()) continue;
                        arrayList.add(object22.getName());
                    }
                    boolean bl3 = bl2 = !list.contains(WebsitePhp2Format.STAMP);
                    if (!bl2) break block69;
                    callback.checkCancelled();
                    object = (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0]);
                    int n = ((File[])object).length;
                    boolean bl4 = false;
                    while (exception < n) {
                        File file2 = object[exception];
                        if (list.contains(file2.getName())) {
                            throw new IOException("The file '" + file2.getName() + "' already exists on the FTP server!");
                        }
                        ++exception;
                    }
                    break block70;
                }
                object = new ArrayList();
                File file3 = null;
                try {
                    callback.checkCancelled();
                    file3 = File.createTempFile("immotool.", ".stamp");
                    FtpUtils.downloadToFile((FTPClient)fTPClient, (String)WebsitePhp2Format.STAMP, (File)file3);
                    String[] exception = ImmoToolUtils.readFile((File)file3).split("\\n");
                    int n = exception.length;
                    for (int i = 0; i < n; ++i) {
                        String string3 = exception[i];
                        string3 = StringUtils.trimToNull((String)string3);
                        if (string3 == null || object.contains(string3)) continue;
                        object.add(string3);
                    }
                }
                catch (Exception exception) {
                    try {
                        throw new IOException("Can't read 'immotool.php.stamp' from FTP server!", exception);
                    }
                    catch (Throwable throwable) {
                        FileUtils.deleteQuietly(file3);
                        throw throwable;
                    }
                }
                FileUtils.deleteQuietly((File)file3);
                if (!bl) {
                    callback.checkCancelled();
                    try {
                        FtpUtils.deleteRecursively((FTPClient)fTPClient, (String)"data");
                    }
                    catch (Exception exception) {
                        throw new IOException("Can't remove old data files from FTP server!", exception);
                    }
                }
                callback.checkCancelled();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if ((string4 = StringUtils.trimToNull((String)string4)) == null || arrayList.contains(string4)) continue;
                    arrayList.add(string4);
                }
                try {
                    for (ExportEntry exportEntry : exportContext.entries) {
                        if (!DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) continue;
                        String string5 = null;
                        if (exportContext.export.publishings.containsKey(exportEntry.objectId)) {
                            DbAgencyExportPublishing dbAgencyExportPublishing = exportContext.export.publishings.get(exportEntry.objectId);
                            string5 = StringUtils.trimToNull((String)dbAgencyExportPublishing.objectKey);
                        }
                        if (string5 == null) {
                            string5 = string + exportEntry.objectId;
                        }
                        FtpUtils.deleteRecursively((FTPClient)fTPClient, (String)("data/" + string5));
                        callback.checkCancelled();
                        if (!DbAgencyExportAction.DELETE.equals((Object)exportEntry.action)) continue;
                        arrayList.remove(string5);
                    }
                }
                catch (Exception exception) {
                    throw new IOException("Can't remove old data files from FTP server!", exception);
                }
                if (websitePhp2Format.isPhpSaveScripts()) {
                    callback.checkCancelled();
                    for (File file4 : (File[])ObjectUtils.defaultIfNull((Object)file.listFiles(), (Object)new File[0])) {
                        String string6 = file4.getName();
                        if (file4.isFile()) {
                            if ("config.php".equals(string6) || "custom.css".equals(string6) || fTPClient.deleteFile(string6)) continue;
                            LOGGER.warn("Can't remove file: " + string6);
                            continue;
                        }
                        if (!file4.isDirectory() || "data".equals(file4.getName())) continue;
                        for (File file5 : (File[])ObjectUtils.defaultIfNull((Object)file4.listFiles(), (Object)new File[0])) {
                            string6 = file4.getName() + "/" + file5.getName();
                            if (file5.isFile()) {
                                if (fTPClient.deleteFile(string6)) continue;
                                LOGGER.warn("Can't remove file: " + string6);
                                continue;
                            }
                            if (!file5.isDirectory()) continue;
                            FtpUtils.deleteRecursively((FTPClient)fTPClient, (String)string6);
                        }
                    }
                }
                if (list.contains("config.php")) {
                    File file6 = new File(file, "config.php");
                    if (file6.isFile()) {
                        FileUtils.deleteQuietly((File)file6);
                    }
                    callback.checkCancelled();
                }
                if (list.contains("custom.css")) {
                    File file7 = new File(file, "custom.css");
                    if (file7.isFile()) {
                        FileUtils.deleteQuietly((File)file7);
                    }
                    callback.checkCancelled();
                }
            }
            object = File.createTempFile(WebsitePhp2Format.STAMP, "");
            try {
                if (!fTPClient.setFileType(2)) {
                    LOGGER.warn("Can't change file-type!");
                }
                Throwable throwable = null;
                try (Object object4 = new FileWriterWithEncoding((File)object, "UTF-8");){
                    for (String string : arrayList) {
                        ((Writer)object4).write(string);
                        ((Writer)object4).write("\n");
                    }
                    ((Writer)object4).flush();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                object4 = new FileInputStream((File)object);
                Throwable throwable4 = null;
                try {
                    if (!fTPClient.setFileType(2)) {
                        LOGGER.warn("Can't change file-type!");
                    }
                    if (!fTPClient.storeFile(WebsitePhp2Format.STAMP, (InputStream)object4)) {
                        LOGGER.warn("Can't store file: " + ((File)object).getName());
                    }
                }
                catch (Throwable throwable5) {
                    Throwable throwable6 = throwable5;
                    throw throwable5;
                }
                finally {
                    if (object4 != null) {
                        if (throwable4 != null) {
                            try {
                                ((InputStream)object4).close();
                            }
                            catch (Throwable throwable7) {
                                throwable4.addSuppressed(throwable7);
                            }
                        } else {
                            ((InputStream)object4).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new IOException("Can't write 'immotool.php.stamp' to FTP server!", iOException);
            }
            finally {
                FileUtils.deleteQuietly((File)object);
            }
        }
    }
}

