/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.WebsitePhp2Format;
import com.openindex.openestate.tool.agency.gui.AgencyExposeRenderer;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultSelectButton;
import com.openindex.openestate.tool.gui.LocaleComboBox;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.utils.forms.NonEmptyComboBoxRule;
import com.openindex.openestate.tool.utils.forms.PatternRule;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WebsitePhp2FormatPanel
extends AbstractFormatPanel<WebsitePhp2Format> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsitePhp2FormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(WebsitePhp2FormatPanel.class);
    private static final String FEED_TROVIT = "trovit";
    private static final String FEED_RSS = "rss";
    private static final String FEED_ATOM = "atom";
    private ValidationHandler validationHandler;
    private JLabel feedExportLabel;
    private DefaultSelectButton feedExportButton;
    private JLabel pdfExportLabel;
    private JComboBox<DbAgencyExpose> pdfExportBox;
    private JLabel companyLabel;
    private JTextField companyField;
    private JLabel estateIdPrefixLabel;
    private JTextField estateIdPrefixField;
    private LocaleComboBox defaultLocaleBox;
    private Map<Locale, JCheckBox> localeBoxes;
    private JLabel optionsLabel;
    private JCheckBox scriptExportBox;

    public WebsitePhp2FormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.scriptExportBox = new JCheckBox();
        this.companyLabel = new JLabel();
        this.companyField = new JTextField();
        this.estateIdPrefixLabel = new JLabel();
        this.estateIdPrefixField = new JTextField();
        this.pdfExportLabel = new JLabel();
        this.pdfExportBox = new JComboBox();
        this.pdfExportBox.setRenderer((ListCellRenderer<DbAgencyExpose>)new DefaultListCellRenderer((Renderer)new AgencyExposeRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("Don't export expos\u00e9s.") + " ]";
            }
        }));
        this.defaultLocaleBox = new LocaleComboBox(WebsitePhp2Format.getSupportedLocales(), true);
        this.defaultLocaleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebsitePhp2FormatPanel.this.selectLocale(WebsitePhp2FormatPanel.this.defaultLocaleBox.getSelectedLocale());
            }
        });
        this.localeBoxes = new HashMap<Locale, JCheckBox>();
        for (Locale locale : WebsitePhp2Format.getSupportedLocales()) {
            JCheckBox jCheckBox = new JCheckBox();
            this.localeBoxes.put(locale, jCheckBox);
        }
        Locale[] localeArray = this.localeBoxes.keySet().toArray(new Locale[0]);
        this.feedExportLabel = new JLabel();
        this.feedExportButton = new DefaultSelectButton(1);
        this.feedExportButton.setEmptyText("");
        this.feedExportButton.setEmptyText(this.feedExportButton.getText());
        this.feedExportButton.addOption(FEED_ATOM, "Atom feed");
        this.feedExportButton.addOption(FEED_RSS, "RSS feed");
        this.feedExportButton.addOption(FEED_TROVIT, "Trovit feed");
        this.validationHandler.putRule((JComponent)this.companyField, ValidationHandler.NOT_BLANK);
        this.validationHandler.putRule((JComponent)this.defaultLocaleBox, (ValidationRule)new NonEmptyComboBoxRule((JComboBox)this.defaultLocaleBox));
        this.validationHandler.putRule((JComponent)this.estateIdPrefixField, (ValidationRule)new PatternRule("\\w{0,5}"));
        int n = 0;
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, pref:grow, 3dlu, pref:grow, 6dlu, right:pref, 3dlu, 50dlu", (JPanel)((Object)this));
        defaultFormBuilder.add((Component)this.companyLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.companyField).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.estateIdPrefixLabel).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.estateIdPrefixField).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.feedExportLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.feedExportButton).xyw(3, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.defaultLocaleBox).xyw(7, defaultFormBuilder.row(), 3);
        defaultFormBuilder.add((Component)this.pdfExportLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.pdfExportBox).xyw(3, defaultFormBuilder.row(), 3);
        if (localeArray.length > n) {
            defaultFormBuilder.add((Component)this.localeBoxes.get(localeArray[n++])).xyw(7, defaultFormBuilder.row(), 3);
        }
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.scriptExportBox).xyw(3, defaultFormBuilder.row(), 3);
        if (localeArray.length > n) {
            defaultFormBuilder.add((Component)this.localeBoxes.get(localeArray[n++])).xyw(7, defaultFormBuilder.row(), 3);
        }
        if (localeArray.length > n) {
            for (int i = n; i < localeArray.length; ++i) {
                defaultFormBuilder.add((Component)this.localeBoxes.get(localeArray[i])).xyw(7, defaultFormBuilder.nextRow(), 3);
            }
        }
        this.updateLocalization();
        this.load((DbAgencyExport)null, (WebsitePhp2Format)null);
    }

    @Override
    public List<String> getWarnings() {
        return super.getWarnings();
    }

    @Override
    public boolean isValidInput() {
        return this.validationHandler.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DbAgencyExport dbAgencyExport, WebsitePhp2Format websitePhp2Format) {
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        if (immoToolProject == null) {
            throw new RuntimeException("No project loaded!");
        }
        if (websitePhp2Format == null) {
            this.estateIdPrefixField.setText("");
            this.feedExportButton.clearSelection();
            this.companyField.setText("");
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            this.pdfExportBox.setSelectedIndex(0);
            this.scriptExportBox.setSelected(false);
            this.defaultLocaleBox.setSelectedIndex(-1);
            for (JCheckBox jCheckBox : this.localeBoxes.values()) {
                jCheckBox.setSelected(false);
            }
            this.selectLocale(null);
        } else {
            Cloneable exception;
            this.estateIdPrefixField.setText(websitePhp2Format.getPropertyPrefix());
            this.scriptExportBox.setSelected(websitePhp2Format.isPhpSaveScripts());
            this.feedExportButton.clearSelection();
            this.feedExportButton.setSelected(FEED_ATOM, websitePhp2Format.isPhpFeedAtom());
            this.feedExportButton.setSelected(FEED_RSS, websitePhp2Format.isPhpFeedRss());
            this.feedExportButton.setSelected(FEED_TROVIT, websitePhp2Format.isPhpFeedTrovit());
            this.feedExportButton.updateText();
            this.defaultLocaleBox.setSelectedLocale(websitePhp2Format.getLanguage());
            for (Map.Entry<Locale, JCheckBox> object2 : this.localeBoxes.entrySet()) {
                exception = object2.getKey();
                DbAgencyExpose[] l = object2.getValue();
                l.setSelected(websitePhp2Format.hasLanguage((Locale)exception));
            }
            this.selectLocale(websitePhp2Format.getLanguage());
            this.companyField.setText(websitePhp2Format.getPhpCompany());
            if (StringUtils.isBlank((CharSequence)this.companyField.getText())) {
                try {
                    this.companyField.setText(immoToolProject.getAgent().getCompany().getCompanyName());
                }
                catch (Exception exception2) {
                    LOGGER.error("could not load company-name!");
                    LOGGER.error("> " + exception2.getLocalizedMessage(), (Throwable)exception2);
                }
            }
            this.pdfExportBox.removeAllItems();
            this.pdfExportBox.addItem(null);
            Object object3 = null;
            DbAgencyExposesHandler dbAgencyExposesHandler = AgencyPlugin.getDbAgencyExtension().getExposeHandler();
            try {
                object3 = immoToolProject.getDbConnection();
                exception = new TreeMap();
                for (DbAgencyExpose dbAgencyExpose : dbAgencyExposesHandler.getExposes((Connection)object3)) {
                    int n = 0;
                    String string = dbAgencyExpose.name.toLowerCase();
                    while (exception.containsKey(string)) {
                        string = dbAgencyExpose.name.toLowerCase() + "_" + ++n;
                    }
                    exception.put(string, dbAgencyExpose);
                }
                long l = dbAgencyExport.exposeId;
                for (DbAgencyExpose dbAgencyExpose : exception.values()) {
                    this.pdfExportBox.addItem(dbAgencyExpose);
                    if (l <= 0L || dbAgencyExpose.id != l) continue;
                    this.pdfExportBox.setSelectedIndex(this.pdfExportBox.getItemCount() - 1);
                }
            }
            catch (Exception exception3) {
                LOGGER.error("Can't load exposes!");
                LOGGER.error("> " + exception3.getLocalizedMessage(), (Throwable)exception3);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)object3);
            }
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, WebsitePhp2Format websitePhp2Format) {
        if (websitePhp2Format == null) {
            throw new NullPointerException("empty export-class!");
        }
        websitePhp2Format.setPhpCompany(this.companyField.getText().trim());
        websitePhp2Format.setPropertyPrefix(this.estateIdPrefixField.getText());
        websitePhp2Format.setPhpSaveScripts(this.scriptExportBox.isSelected());
        DbAgencyExpose dbAgencyExpose = (DbAgencyExpose)this.pdfExportBox.getSelectedItem();
        dbAgencyExport.exposeId = dbAgencyExpose != null ? dbAgencyExpose.id : 0L;
        websitePhp2Format.setPhpFeedAtom(this.feedExportButton.hasSelection(FEED_ATOM));
        websitePhp2Format.setPhpFeedRss(this.feedExportButton.hasSelection(FEED_RSS));
        websitePhp2Format.setPhpFeedTrovit(this.feedExportButton.hasSelection(FEED_TROVIT));
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Locale locale = this.defaultLocaleBox.getSelectedLocale();
        arrayList.add(locale);
        for (Map.Entry<Locale, JCheckBox> entry : this.localeBoxes.entrySet()) {
            Locale locale2 = entry.getKey();
            JCheckBox jCheckBox = entry.getValue();
            if (locale2.toString().equalsIgnoreCase(locale.toString()) || !jCheckBox.isSelected()) continue;
            arrayList.add(locale2);
        }
        websitePhp2Format.setLanguages(arrayList.toArray(new Locale[0]));
    }

    private void selectLocale(Locale locale) {
        for (Map.Entry<Locale, JCheckBox> entry : this.localeBoxes.entrySet()) {
            Locale locale2 = entry.getKey();
            JCheckBox jCheckBox = entry.getValue();
            if (locale != null && locale2.getLanguage().equals(locale.getLanguage())) {
                jCheckBox.setEnabled(false);
                jCheckBox.setSelected(true);
                continue;
            }
            jCheckBox.setEnabled(true);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.companyLabel.setText(StringUtils.capitalize((String)I18N.tr("company")) + ":");
        this.companyField.setToolTipText(I18N.tr("The provided text is used as company name in the generated website."));
        this.estateIdPrefixLabel.setText(StringUtils.capitalize((String)I18N.tr("ID-prefix")) + ":");
        this.estateIdPrefixField.setToolTipText(I18N.tr("The selected prefix is prepended to the property-ID & property-nr during the export."));
        this.pdfExportLabel.setText(StringUtils.capitalize((String)I18N.tr("expos\u00e9")) + ":");
        this.pdfExportBox.setToolTipText(I18N.tr("Use this field to specify an expos\u00e9, that is additionally transferred to the webspace."));
        this.feedExportLabel.setText(StringUtils.capitalize((String)I18N.tr("exports")) + ":");
        this.feedExportButton.setToolTipText(I18N.tr("The properties may be stored in additional file formats to the webspace."));
        this.feedExportButton.setEmptyText("[ " + I18N.tr("No format selected.") + " ]");
        this.feedExportButton.updateText();
        this.defaultLocaleBox.setToolTipText(I18N.tr("The selected language is used by default in the generated documents."));
        for (Map.Entry<Locale, JCheckBox> entry : this.localeBoxes.entrySet()) {
            Locale locale = entry.getKey();
            JCheckBox jCheckBox = entry.getValue();
            jCheckBox.setText(locale.getDisplayLanguage() + " / " + locale.getDisplayLanguage(locale));
            jCheckBox.setToolTipText(I18N.tr("These additionally selected language are also exported to the webspace."));
        }
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.scriptExportBox.setText(I18N.tr("Export scripts."));
        this.scriptExportBox.setToolTipText(I18N.tr("Enable this option to overwrite PHP-scripts and templates on every export."));
    }
}

