/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.export;

import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormatPanel;
import com.openindex.openestate.tool.agency.export.WohnenInSuedtirolItFormat;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationRule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class WohnenInSuedtirolItFormatPanel
extends AbstractFormatPanel<WohnenInSuedtirolItFormat> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WohnenInSuedtirolItFormatPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(WohnenInSuedtirolItFormatPanel.class);
    private ValidationHandler validationHandler;
    private JLabel agentIdLabel;
    private JTextField agentIdField;
    private JLabel optionsLabel;
    private JCheckBox publicIdBox;
    private JCheckBox energyCertificateBox;

    public WohnenInSuedtirolItFormatPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.optionsLabel = new JLabel();
        this.agentIdLabel = new JLabel();
        this.agentIdField = new JTextField();
        this.publicIdBox = new JCheckBox();
        this.energyCertificateBox = new JCheckBox();
        this.validationHandler.putRule((JComponent)this.agentIdField, new ValidationRule(){

            public boolean isValid(Object object) {
                return object != null && (object.toString().trim().length() == 0 || object.toString().trim().length() < 150);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 50dlu:grow, 3dlu, right:pref, 3dlu, 50dlu");
        defaultFormBuilder.add((Component)this.agentIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.agentIdField).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.optionsLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.publicIdBox).xyw(3, defaultFormBuilder.row(), 5);
        defaultFormBuilder.add((Component)this.energyCertificateBox).xyw(3, defaultFormBuilder.nextRow(), 5);
        this.setLayout(new BorderLayout(5, 5));
        this.add(defaultFormBuilder.getPanel(), "Center");
        this.updateLocalization();
        this.load((DbAgencyExport)null, (WohnenInSuedtirolItFormat)null);
    }

    @Override
    public List<String> getWarnings() {
        List<String> list = super.getWarnings();
        list.add(AgencyPluginUtils.Message.FULL_EXPORT_WARNING.getTranslation());
        if (this.publicIdBox.isSelected()) {
            list.add(AgencyPluginUtils.Message.PROPERTY_NR_IDENTIFICATION_WARNING.getTranslation());
        }
        return list;
    }

    @Override
    public boolean isValidInput() {
        this.validationHandler.validate();
        return this.validationHandler.isValid();
    }

    @Override
    public void load(DbAgencyExport dbAgencyExport, WohnenInSuedtirolItFormat wohnenInSuedtirolItFormat) {
        if (wohnenInSuedtirolItFormat == null) {
            this.agentIdField.setText("");
            this.publicIdBox.setSelected(false);
            this.energyCertificateBox.setSelected(false);
        } else {
            this.agentIdField.setText(wohnenInSuedtirolItFormat.getAgentId());
            this.publicIdBox.setSelected(wohnenInSuedtirolItFormat.isPropertyPublicId());
            this.energyCertificateBox.setSelected(wohnenInSuedtirolItFormat.isPropertyDescriptionWithEnergyCertificate());
        }
        this.validationHandler.init();
    }

    @Override
    public void save(DbAgencyExport dbAgencyExport, WohnenInSuedtirolItFormat wohnenInSuedtirolItFormat) {
        if (wohnenInSuedtirolItFormat == null) {
            throw new NullPointerException("empty export-class!");
        }
        wohnenInSuedtirolItFormat.setAgentId(this.agentIdField.getText().trim());
        wohnenInSuedtirolItFormat.setPropertyPublicId(this.publicIdBox.isSelected());
        wohnenInSuedtirolItFormat.setPropertyDescriptionWithEnergyCertificate(this.energyCertificateBox.isSelected());
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.agentIdLabel.setText(StringUtils.capitalize((String)I18N.tr("agency-nr")) + ":");
        this.agentIdField.setToolTipText(I18N.tr("Enter your agency-nr, that you've received from recipient to identify your account. Not all recipients require this value."));
        this.optionsLabel.setText(StringUtils.capitalize((String)I18N.tr("miscellaneous")) + ":");
        this.publicIdBox.setText(I18N.tr("Use property number for identification."));
        this.publicIdBox.setToolTipText(I18N.tr("Enable this option to export the property number instead of the property ID."));
        this.energyCertificateBox.setText(I18N.tr("Append energy certificate to the description."));
        this.energyCertificateBox.setToolTipText(I18N.tr("Enable this option to append information about the energy certificate to the description of exported objects."));
    }
}

