/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.expose;

import com.lowagie.text.DocumentException;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolAgent;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.AgencyPluginUtils;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyExpose;
import com.openindex.openestate.tool.agency.db.DbAgencyExposesHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.expose.AbstractExposePanel;
import com.openindex.openestate.tool.agency.extensions.DbAgencyExtension;
import com.openindex.openestate.tool.agency.extensions.ExportExtension;
import com.openindex.openestate.tool.agency.extensions.ExposeExtension;
import com.openindex.openestate.tool.agency.utils.PublishingMode;
import com.openindex.openestate.tool.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractExpose
extends HashMap<String, String> {
    private static final long serialVersionUID = 5671361234568L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExpose.class);
    private static final I18n I18N = I18nFactory.getI18n(AbstractExpose.class);
    private static final String LOCALE = "locale";
    private static final String ORIENTATION = "orientation";
    private static final String PUBLISH_ADDRESS = "publish.address";
    private static final String PUBLISH_FILES = "publish.files";
    private static final String PUBLISH_LINKS = "publish.links";
    private static final String PUBLISH_PRICES = "publish.prices";
    private static final String RESOLUTION = "resolution";
    private static final String SHOW_CONTACT = "showContact";
    private static final String TEMPLATE = "template";
    private static final String TEMPLATE_ID = "template.id";
    private ImmoToolAgent agent = null;
    private File agentLogo = null;
    private BufferedImage agentLogoImage = null;
    private boolean agentLogoImageLoaded = false;
    private DbAgencyObject estate = null;
    private DbAgencyContact estateContact = null;
    private boolean estateContactLoaded = false;
    private DbFile[] estateFiles = null;
    private boolean estateFilesLoaded = false;
    private Map<Long, File> estateFilesDownload = null;
    private DbLink[] estateLinks = null;
    private boolean estateLinksLoaded = false;
    private File temporaryTemplateFile = null;
    private final Map<Long, File> exposeFiles = new HashMap<Long, File>();
    protected Connection dbConnection = null;
    protected DbAgencyExtension dbExtension = null;
    protected Map<Long, String> dbLanguageMap = null;
    protected Date now = null;
    protected Locale locale = null;
    protected Orientation orientation = null;

    protected abstract void build(OutputStream var1) throws IOException, DocumentException;

    public abstract AbstractExposePanel createForm();

    protected void finish() {
        if (this.estateFilesDownload != null) {
            for (File file : this.estateFilesDownload.values()) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        for (File file : this.exposeFiles.values()) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void generate(long l, ImmoToolProject immoToolProject, OutputStream outputStream) throws IOException, DocumentException, SQLException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.generate(l, immoToolProject, connection, outputStream);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void generate(DbAgencyObject dbAgencyObject, ImmoToolProject immoToolProject, OutputStream outputStream) throws IOException, DocumentException, SQLException {
        Connection connection = null;
        try {
            connection = immoToolProject.getDbConnection();
            this.generate(dbAgencyObject, immoToolProject, connection, outputStream);
        }
        finally {
            JdbcUtils.closeQuietly((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void generate(long l, ImmoToolProject immoToolProject, Connection connection, OutputStream outputStream) throws IOException, DocumentException, SQLException {
        try {
            this.init(immoToolProject, connection);
            this.estate = (DbAgencyObject)this.dbExtension.getObjectsHandler().getObject(connection, l);
            if (this.estate == null) {
                throw new IOException("Can't find estate objekt #" + l + "!");
            }
            this.dbExtension.getObjectsHandler().loadObjectAttribs(connection, this.estate, this.dbLanguageMap);
            this.dbExtension.getObjectsHandler().loadObjectTranslations(connection, this.estate, this.dbLanguageMap);
            this.build(outputStream);
        }
        finally {
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void generate(DbAgencyObject dbAgencyObject, ImmoToolProject immoToolProject, Connection connection, OutputStream outputStream) throws IOException, DocumentException, SQLException {
        try {
            this.init(immoToolProject, connection);
            this.estate = dbAgencyObject;
            this.dbExtension.getObjectsHandler().loadObjectAttribs(connection, dbAgencyObject, this.dbLanguageMap);
            this.dbExtension.getObjectsHandler().loadObjectTranslations(connection, dbAgencyObject, this.dbLanguageMap);
            this.build(outputStream);
        }
        finally {
            this.finish();
        }
    }

    protected ImmoToolAgent getAgent() {
        return this.agent;
    }

    protected File getAgentLogo() {
        return this.agentLogo;
    }

    protected synchronized BufferedImage getAgentLogoImage() {
        if (this.agentLogoImage == null && this.agentLogo != null && this.agentLogo.isFile() && !this.agentLogoImageLoaded) {
            try {
                this.agentLogoImage = ImageUtils.read((File)this.agentLogo);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load agency logo as image!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                this.agentLogoImageLoaded = true;
            }
        }
        return this.agentLogoImage;
    }

    protected DbAgencyContact getEstateContact() {
        if (this.estateContact == null && this.estate.contactId > 0L && !this.estateContactLoaded) {
            try {
                this.estateContact = (DbAgencyContact)this.dbExtension.getContactsHandler().getContact(this.dbConnection, this.estate.contactId);
                if (this.estateContact == null) {
                    LOGGER.warn("Unknown contact #" + this.estate.contactId + "!");
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load contact #" + this.estate.contactId + " for estate #" + this.estate.id + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                this.estateContactLoaded = true;
            }
        }
        return this.estateContact;
    }

    protected DbFile[] getEstateFiles() {
        PublishingMode publishingMode = this.getPublishFiles();
        if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            if (this.estateFiles == null) {
                this.estateFiles = new DbFile[0];
            }
        } else if (this.estateFiles == null && !this.estateFilesLoaded) {
            try {
                Boolean bl = !PublishingMode.ALWAYS.equals((Object)publishingMode) ? Boolean.valueOf(true) : null;
                this.estateFiles = this.dbExtension.getFilesHandler().getFiles(this.dbConnection, this.estate.id, bl, null);
                this.dbExtension.getFilesHandler().loadFileTranslations(this.dbConnection, this.estateFiles, this.dbExtension.getLanguagesHandler());
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load files for estate #" + this.estate.id + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                this.estateFilesLoaded = true;
            }
        }
        return this.estateFiles;
    }

    protected File getEstateFileDownload(DbFile dbFile) throws IOException, SQLException {
        if (this.estateFilesDownload == null || dbFile == null || dbFile.id < 1L) {
            return null;
        }
        if (!this.estateFilesDownload.containsKey(dbFile.id)) {
            File file = null;
            try {
                file = File.createTempFile("attachment.", ".bin");
                file.deleteOnExit();
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    this.dbExtension.getFilesHandler().downloadContent(this.dbConnection, dbFile.id, (OutputStream)fileOutputStream);
                    fileOutputStream.flush();
                }
                this.estateFilesDownload.put(dbFile.id, file);
            }
            catch (IOException | SQLException exception) {
                FileUtils.deleteQuietly((File)file);
                throw exception;
            }
        }
        return this.estateFilesDownload.get(dbFile.id);
    }

    protected DbLink[] getEstateLinks() {
        PublishingMode publishingMode = this.getPublishLinks();
        if (PublishingMode.NEVER.equals((Object)publishingMode)) {
            if (this.estateLinks == null) {
                this.estateLinks = new DbLink[0];
            }
        } else if (this.estateLinks == null && !this.estateLinksLoaded) {
            try {
                Boolean bl = !PublishingMode.ALWAYS.equals((Object)publishingMode) ? Boolean.valueOf(true) : null;
                this.estateLinks = this.dbExtension.getLinksHandler().getLinks(this.dbConnection, this.estate.id, bl, null);
                this.dbExtension.getLinksHandler().loadLinkTranslations(this.dbConnection, this.estateLinks, this.dbExtension.getLanguagesHandler());
            }
            catch (Exception exception) {
                LOGGER.warn("Can't load links for estate #" + this.estate.id + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            finally {
                this.estateLinksLoaded = true;
            }
        }
        return this.estateLinks;
    }

    protected DbAgencyObject getEstateObject() {
        return this.estate;
    }

    public static AbstractExpose getExpose(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        for (ExposeExtension exposeExtension : AgencyPluginUtils.getExposeExtensions()) {
            Object[] objectArray = exposeExtension.createExposes();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                if (!((AbstractExpose)object).getName().equalsIgnoreCase(string)) continue;
                return object;
            }
        }
        return null;
    }

    public static Map<String, AbstractExpose> getExposes() {
        Object[] objectArray;
        HashMap<String, AbstractExpose> hashMap = new HashMap<String, AbstractExpose>();
        for (ExposeExtension object : AgencyPluginUtils.getExposeExtensions()) {
            objectArray = object.createExposes();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object2 : objectArray) {
                hashMap.put(((AbstractExpose)object2).getName(), (AbstractExpose)object2);
            }
        }
        for (ExportExtension exportExtension : AgencyPluginUtils.getExportExtensions()) {
            objectArray = exportExtension.createExposes();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object2 : objectArray) {
                hashMap.put(((AbstractExpose)object2).getName(), (AbstractExpose)object2);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File getExposeFile(long l) {
        if (l < 1L) {
            return null;
        }
        if (this.exposeFiles.containsKey(l)) {
            File file = this.exposeFiles.get(l);
            return file != null && file.isFile() ? file : null;
        }
        File file = null;
        try {
            file = File.createTempFile("attachment.", ".bin");
            file.deleteOnExit();
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                this.dbExtension.getExposeHandler().downloadExposeFile(this.dbConnection, l, fileOutputStream);
            }
        }
        catch (Exception exception) {
            try {
                LOGGER.warn("Can't read expos\u00e9 file #" + l + "!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                FileUtils.deleteQuietly((File)file);
            }
            catch (Throwable throwable) {
                this.exposeFiles.put(l, file != null && file.isFile() ? file : null);
                throw throwable;
            }
            this.exposeFiles.put(l, file != null && file.isFile() ? file : null);
        }
        this.exposeFiles.put(l, file != null && file.isFile() ? file : null);
        return this.exposeFiles.get(l);
    }

    public Locale getLocale() {
        String string = (String)this.get(LOCALE);
        return !StringUtils.isBlank((CharSequence)string) ? OpenEstateUtils.buildLocale((String)string) : null;
    }

    public abstract String getName();

    public Orientation getOrientation() {
        String string = (String)this.get(ORIENTATION);
        return !StringUtils.isBlank((CharSequence)string) ? Orientation.valueOf(string) : null;
    }

    public PublishingMode getPublishAddress() {
        String string = (String)this.get(PUBLISH_ADDRESS);
        return !StringUtils.isBlank((CharSequence)string) ? PublishingMode.valueOf(string) : null;
    }

    public PublishingMode getPublishFiles() {
        String string = (String)this.get(PUBLISH_FILES);
        return !StringUtils.isBlank((CharSequence)string) ? PublishingMode.valueOf(string) : null;
    }

    public PublishingMode getPublishLinks() {
        String string = (String)this.get(PUBLISH_LINKS);
        return !StringUtils.isBlank((CharSequence)string) ? PublishingMode.valueOf(string) : null;
    }

    public PublishingMode getPublishPrices() {
        String string = (String)this.get(PUBLISH_PRICES);
        return !StringUtils.isBlank((CharSequence)string) ? PublishingMode.valueOf(string) : null;
    }

    public int getResolution() {
        String string = (String)this.get(RESOLUTION);
        return !StringUtils.isBlank((CharSequence)string) ? Integer.parseInt(string) : 0;
    }

    public static Locale[] getSupportedLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.addAll(Arrays.asList(AgencyPlugin.getLocalesWithLanguagePack()));
        for (String string : new String[]{"bg", "es", "it", "ru"}) {
            boolean bl = false;
            for (Locale locale : arrayList) {
                if (!string.equalsIgnoreCase(locale.getLanguage())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new Locale(string));
        }
        return arrayList.toArray(new Locale[0]);
    }

    protected File getTemplateFile() {
        if (this.temporaryTemplateFile != null) {
            return this.temporaryTemplateFile.isFile() ? this.temporaryTemplateFile : null;
        }
        long l = this.getTemplateId();
        return l > 0L ? this.getExposeFile(l) : null;
    }

    public long getTemplateId() {
        String string = (String)this.get(TEMPLATE_ID);
        return !StringUtils.isBlank((CharSequence)string) ? Long.parseLong(string) : 0L;
    }

    public File getTemporaryTemplateFile() {
        return this.temporaryTemplateFile;
    }

    public abstract String getTitle();

    protected void init(ImmoToolProject immoToolProject, Connection connection) throws SQLException {
        this.dbConnection = connection;
        this.dbExtension = AgencyPlugin.getDbAgencyExtension();
        this.dbLanguageMap = this.dbExtension.getLanguagesHandler().getLanguageMap(connection, Boolean.valueOf(true));
        this.exposeFiles.clear();
        this.now = new Date();
        this.locale = this.getLocale();
        this.orientation = this.getOrientation();
        this.agent = immoToolProject.getAgent();
        this.agentLogo = immoToolProject.getAgentLogo();
        this.agentLogoImage = null;
        this.agentLogoImageLoaded = false;
        this.estate = null;
        this.estateContact = null;
        this.estateContactLoaded = false;
        this.estateFiles = null;
        this.estateFilesLoaded = false;
        this.estateFilesDownload = new HashMap<Long, File>();
        this.estateLinks = null;
        this.estateLinksLoaded = false;
    }

    public void initDefaults() {
        this.setPublishAddress(PublishingMode.DEFAULT);
        this.setPublishFiles(PublishingMode.DEFAULT);
        this.setPublishPrices(PublishingMode.DEFAULT);
        this.setShowContact(true);
        this.setTemplate(false);
    }

    public boolean isShowContact() {
        String string = (String)this.get(SHOW_CONTACT);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public boolean isTemplate() {
        String string = (String)this.get(TEMPLATE);
        return !StringUtils.isBlank((CharSequence)string) && Boolean.TRUE.equals(Boolean.valueOf(string));
    }

    public void saveToDatabase(DbAgencyExpose dbAgencyExpose, Connection connection, DbAgencyExposesHandler dbAgencyExposesHandler) {
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.remove(LOCALE);
        } else {
            this.put(LOCALE, locale.toString());
        }
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            this.remove(ORIENTATION);
        } else {
            this.put(ORIENTATION, orientation.name());
        }
    }

    public void setPublishAddress(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PUBLISH_ADDRESS);
        } else {
            this.put(PUBLISH_ADDRESS, publishingMode.name());
        }
    }

    public void setPublishFiles(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PUBLISH_FILES);
        } else {
            this.put(PUBLISH_FILES, publishingMode.name());
        }
    }

    public void setPublishLinks(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PUBLISH_LINKS);
        } else {
            this.put(PUBLISH_LINKS, publishingMode.name());
        }
    }

    public void setPublishPrices(PublishingMode publishingMode) {
        if (publishingMode == null) {
            this.remove(PUBLISH_PRICES);
        } else {
            this.put(PUBLISH_PRICES, publishingMode.name());
        }
    }

    public void setResolution(int n) {
        if (n < 72) {
            this.remove(RESOLUTION);
        } else {
            this.put(RESOLUTION, String.valueOf(n));
        }
    }

    public void setShowContact(boolean bl) {
        this.put(SHOW_CONTACT, String.valueOf(bl));
    }

    public void setTemplate(boolean bl) {
        this.put(TEMPLATE, String.valueOf(bl));
    }

    public void setTemplateId(long l) {
        if (l < 1L) {
            this.remove(TEMPLATE_ID);
        } else {
            this.put(TEMPLATE_ID, String.valueOf(l));
        }
    }

    public void setTemporaryTemplate(File file) {
        this.temporaryTemplateFile = file;
    }

    public static enum Orientation implements Translatable
    {
        PORTRAIT(I18n.marktr((String)"portrait")),
        LANDSCAPE(I18n.marktr((String)"landscape"));

        private final String i18nKey;

        private Orientation(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AbstractExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractExpose.class, (String)this.i18nKey, (Locale)locale);
        }
    }

    public static enum HorizontalAlign implements Translatable
    {
        LEFT(I18n.marktr((String)"left-aligned")),
        CENTER(I18n.marktr((String)"centered")),
        RIGHT(I18n.marktr((String)"right-aligned")),
        JUSTIFY(I18n.marktr((String)"justification"));

        private final String i18nKey;

        private HorizontalAlign(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AbstractExpose.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AbstractExpose.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

