/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import oauth.signpost.exception.OAuthException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.AbstractClient;
import org.openestate.is24.restapi.utils.RequestMethod;
import org.openestate.is24.restapi.utils.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient
extends AbstractClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);

    public DefaultClient(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    /*
     * Loose catch block
     */
    protected Response createResponse(HttpURLConnection httpURLConnection) throws IOException {
        String string = DefaultClient.getEncoding();
        try {
            try (FilterInputStream filterInputStream = "gzip".equalsIgnoreCase(httpURLConnection.getContentEncoding()) ? new GZIPInputStream(new BufferedInputStream(httpURLConnection.getInputStream())) : new BufferedInputStream(httpURLConnection.getInputStream());){
                Response response = new Response(httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage(), httpURLConnection.getHeaderField("L-IS24-RequestRefnum"), IOUtils.toString((InputStream)filterInputStream, (String)string));
                return response;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.close((URLConnection)httpURLConnection);
        }
    }

    private static String getRandomBoundary() {
        return StringUtils.substring((String)DigestUtils.sha1Hex((String)(System.currentTimeMillis() + "/" + RandomUtils.nextLong())), (int)0, (int)25);
    }

    @Override
    protected Response sendJsonRequest(URL uRL, RequestMethod requestMethod, String string) throws IOException, OAuthException {
        return this._sendRequest(uRL, requestMethod, string, "application/json");
    }

    @Override
    protected Response sendXmlRequest(URL uRL, RequestMethod requestMethod, String string) throws IOException, OAuthException {
        return this._sendRequest(uRL, requestMethod, string, "application/xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response sendXmlAttachmentRequest(URL uRL, RequestMethod requestMethod, String string, InputStream inputStream, String string2, String string3) throws IOException, OAuthException {
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        String string4 = "*****" + DefaultClient.getRandomBoundary() + "*****";
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod(requestMethod.name());
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
            httpURLConnection.setRequestProperty("Content-Language", "en-US");
            httpURLConnection.setRequestProperty("Accept", "application/xml");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            this.getAuthConsumer().sign((Object)httpURLConnection);
            if (string == null && inputStream == null) {
                httpURLConnection.connect();
            } else {
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                Throwable throwable = null;
                try {
                    if (string != null) {
                        ((DataOutputStream)object).writeBytes("--" + string4 + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Type: application/xml; name=body.xml\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Transfer-Encoding: binary\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Disposition: form-data; name=\"metadata\"; filename=\"body.xml\"\r\n");
                        ((DataOutputStream)object).writeBytes("\r\n");
                        ((DataOutputStream)object).writeBytes(string);
                        ((DataOutputStream)object).writeBytes("\r\n");
                        ((DataOutputStream)object).flush();
                    }
                    if (inputStream != null) {
                        if ((string3 = StringUtils.trimToNull((String)string3)) != null) {
                            string3 = "application/octet-stream";
                        }
                        if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                            string2 = "upload.bin";
                        }
                        ((DataOutputStream)object).writeBytes("--" + string4 + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Type: " + string3 + "; name=\"" + string2 + "\"" + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Transfer-Encoding: binary\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Disposition: form-data; name=\"attachment\"; filename=\"" + string2 + "\"" + "\r\n");
                        ((DataOutputStream)object).writeBytes("\r\n");
                        byte[] byArray = new byte[4096];
                        int n = inputStream.read(byArray, 0, byArray.length);
                        while (n > 0) {
                            ((DataOutputStream)object).write(byArray, 0, n);
                            n = inputStream.read(byArray, 0, byArray.length);
                        }
                        ((DataOutputStream)object).writeBytes("\r\n");
                    }
                    ((DataOutputStream)object).writeBytes("--" + string4 + "\r\n");
                    ((DataOutputStream)object).flush();
                    httpURLConnection.connect();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FilterOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FilterOutputStream)object).close();
                        }
                    }
                }
            }
            object = this.createResponse(httpURLConnection);
            return object;
        }
        finally {
            IOUtils.close((URLConnection)httpURLConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response sendVideoUploadRequest(URI uRI, RequestMethod requestMethod, String string, InputStream inputStream, String string2, long l) throws IOException {
        Object object;
        if (requestMethod == null) {
            requestMethod = RequestMethod.POST;
        }
        if (!RequestMethod.POST.equals((Object)requestMethod) && !RequestMethod.PUT.equals((Object)requestMethod)) {
            throw new IllegalArgumentException("Invalid request method!");
        }
        string = StringUtils.trimToNull((String)string);
        String string3 = "*****" + DefaultClient.getRandomBoundary() + "*****";
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
            httpURLConnection.setRequestMethod(requestMethod.name());
            httpURLConnection.setRequestProperty("MIME-Version", "1.0");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
            httpURLConnection.setRequestProperty("Content-Language", "en-US");
            httpURLConnection.setRequestProperty("Accept-Encoding", "gzip,deflate");
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            if (string == null && inputStream == null) {
                httpURLConnection.connect();
            } else {
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                Throwable throwable = null;
                try {
                    if (string != null) {
                        ((DataOutputStream)object).writeBytes("--" + string3 + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Type: text/plain; charset=" + DefaultClient.getEncoding() + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Transfer-Encoding: binary\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Disposition: form-data; name=\"auth\"\r\n");
                        ((DataOutputStream)object).writeBytes("\r\n");
                        ((DataOutputStream)object).writeBytes(string);
                        ((DataOutputStream)object).writeBytes("\r\n");
                        ((DataOutputStream)object).flush();
                    }
                    if (inputStream != null) {
                        if ((string2 = StringUtils.trimToNull((String)string2)) == null) {
                            string2 = "upload.bin";
                        }
                        ((DataOutputStream)object).writeBytes("--" + string3 + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Type: application/octet-stream; name=\"" + string2 + "\"" + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Transfer-Encoding: binary\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Length: " + String.valueOf(l) + "\r\n");
                        ((DataOutputStream)object).writeBytes("Content-Disposition: form-data; name=\"videofile\"; filename=\"" + string2 + "\"" + "\r\n");
                        ((DataOutputStream)object).writeBytes("\r\n");
                        byte[] byArray = new byte[4096];
                        int n = inputStream.read(byArray, 0, byArray.length);
                        while (n > 0) {
                            ((DataOutputStream)object).write(byArray, 0, n);
                            n = inputStream.read(byArray, 0, byArray.length);
                        }
                        ((DataOutputStream)object).writeBytes("\r\n");
                    }
                    ((DataOutputStream)object).writeBytes("--" + string3 + "\r\n");
                    ((DataOutputStream)object).flush();
                    httpURLConnection.connect();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FilterOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FilterOutputStream)object).close();
                        }
                    }
                }
            }
            object = this.createResponse(httpURLConnection);
        }
        catch (Throwable throwable) {
            IOUtils.close(httpURLConnection);
            throw throwable;
        }
        IOUtils.close((URLConnection)httpURLConnection);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response _sendRequest(URL uRL, RequestMethod requestMethod, String string, String string2) throws IOException, OAuthException {
        if (requestMethod == null) {
            requestMethod = RequestMethod.GET;
        }
        string = RequestMethod.POST.equals((Object)requestMethod) || RequestMethod.PUT.equals((Object)requestMethod) ? StringUtils.trimToNull((String)string) : null;
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod(requestMethod.name());
            if (string != null) {
                httpURLConnection.setRequestProperty("Content-Type", string2 + "; charset=" + DefaultClient.getEncoding().toLowerCase());
                httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string.getBytes(DefaultClient.getEncoding()).length));
                httpURLConnection.setRequestProperty("Content-Language", "en-US");
            }
            httpURLConnection.setRequestProperty("Accept", string2);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            this.getAuthConsumer().sign((Object)httpURLConnection);
            if (string == null) {
                httpURLConnection.connect();
            } else {
                object = new DataOutputStream(httpURLConnection.getOutputStream());
                Throwable throwable = null;
                try {
                    ((DataOutputStream)object).writeBytes(string);
                    ((DataOutputStream)object).flush();
                    httpURLConnection.connect();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FilterOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FilterOutputStream)object).close();
                        }
                    }
                }
            }
            object = this.createResponse(httpURLConnection);
            return object;
        }
        finally {
            IOUtils.close((URLConnection)httpURLConnection);
        }
    }
}

