/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.trovit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.core.XmlValidationHandler;
import org.openestate.io.trovit.TrovitDocument;
import org.openestate.io.trovit.xml.ObjectFactory;
import org.openestate.io.trovit.xml.types.AreaUnitValue;
import org.openestate.io.trovit.xml.types.ForeclosureTypeValue;
import org.openestate.io.trovit.xml.types.OrientationValue;
import org.openestate.io.trovit.xml.types.PricePeriodValue;
import org.openestate.io.trovit.xml.types.TypeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TrovitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrovitUtils.class);
    private static final Pattern ROOMS_INTERVAL = Pattern.compile("^(\\d+)\\-(\\d+)$");
    private static JAXBContext JAXB = null;
    public static final String NAMESPACE = "";
    public static final String PACKAGE = "org.openestate.io.trovit.xml";
    public static final ObjectFactory FACTORY = new ObjectFactory();

    private TrovitUtils() {
    }

    public static TrovitDocument createDocument(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        return TrovitUtils.createDocument(XmlUtils.newDocument((InputStream)inputStream, (boolean)true));
    }

    public static TrovitDocument createDocument(File file) throws SAXException, IOException, ParserConfigurationException {
        return TrovitUtils.createDocument(XmlUtils.newDocument((File)file, (boolean)true));
    }

    public static TrovitDocument createDocument(String string) throws SAXException, IOException, ParserConfigurationException {
        return TrovitUtils.createDocument(XmlUtils.newDocument((String)string, (boolean)true));
    }

    public static TrovitDocument createDocument(Document document) {
        if (TrovitDocument.isReadable(document)) {
            return new TrovitDocument(document);
        }
        return null;
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return TrovitUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = TrovitUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        marshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = TrovitUtils.getContext().createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new XmlValidationHandler());
        return unmarshaller;
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            TrovitUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static synchronized ObjectFactory getFactory() {
        return FACTORY;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)PACKAGE, (ClassLoader)classLoader);
    }

    public static AreaUnitValue parseAreaUnitValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        AreaUnitValue areaUnitValue = AreaUnitValue.fromXmlValue(string);
        if (areaUnitValue != null) {
            return areaUnitValue;
        }
        throw new IllegalArgumentException("Can't parse foreclosure type value '" + string + "'!");
    }

    public static Boolean parseBooleanValue(String string) {
        switch (string = StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)string), (Locale)Locale.ENGLISH)) {
            case "true": 
            case "yes": 
            case "si": 
            case "1": {
                return Boolean.TRUE;
            }
            case "false": 
            case "no": 
            case "0": {
                return Boolean.FALSE;
            }
        }
        throw new IllegalArgumentException("Can't parse boolean value '" + string + "'!");
    }

    public static String parseContentValue(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseCountryValue(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static Calendar parseDateValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        String[] stringArray = new String[]{"dd/MM/yyyy", "dd/MM/yyyy hh:mm:ss", "dd-MM-yyyy", "dd-MM-yyyy hh:mm:ss", "yyyy/MM/dd", "yyyy/MM/dd hh:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd hh:mm:ss"};
        try {
            Date date = DateUtils.parseDateStrictly((String)string, (Locale)Locale.ENGLISH, (String[])stringArray);
            Calendar calendar = Calendar.getInstance(Locale.getDefault());
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Can't parse date value '" + string + "'!", parseException);
        }
    }

    public static BigInteger parseFloorAreaValue(String string) {
        try {
            string = StringUtils.trimToNull((String)string);
            return string != null ? DatatypeConverter.parseInteger((String)string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse floor area value '" + string + "'!", numberFormatException);
        }
    }

    public static ForeclosureTypeValue parseForeclosureTypeValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        ForeclosureTypeValue foreclosureTypeValue = ForeclosureTypeValue.fromXmlValue(string);
        if (foreclosureTypeValue != null) {
            return foreclosureTypeValue;
        }
        throw new IllegalArgumentException("Can't parse foreclosure type value '" + string + "'!");
    }

    public static BigDecimal parseLatitudeValue(String string) {
        try {
            string = StringUtils.trimToNull((String)string);
            return string != null ? DatatypeConverter.parseDecimal((String)string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse latitude value '" + string + "'!", numberFormatException);
        }
    }

    public static BigDecimal parseLongitudeValue(String string) {
        try {
            string = StringUtils.trimToNull((String)string);
            return string != null ? DatatypeConverter.parseDecimal((String)string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse longitude value '" + string + "'!", numberFormatException);
        }
    }

    public static OrientationValue parseOrientationValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        OrientationValue orientationValue = OrientationValue.fromXmlValue(string);
        if (orientationValue != null) {
            return orientationValue;
        }
        throw new IllegalArgumentException("Can't parse orientation value '" + string + "'!");
    }

    public static BigInteger parsePlotAreaValue(String string) {
        try {
            string = StringUtils.trimToNull((String)string);
            return string != null ? DatatypeConverter.parseInteger((String)string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse plot area value '" + string + "'!", numberFormatException);
        }
    }

    public static Currency parsePriceCurrencyValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return Currency.getInstance(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Can't parse price currency value '" + string + "'!", illegalArgumentException);
        }
    }

    public static PricePeriodValue parsePricePeriodValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        PricePeriodValue pricePeriodValue = PricePeriodValue.fromXmlValue(string);
        if (pricePeriodValue != null) {
            return pricePeriodValue;
        }
        throw new IllegalArgumentException("Can't parse price period value '" + string + "'!");
    }

    public static BigDecimal parsePriceValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDecimal((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse price value '" + string + "'!", numberFormatException);
        }
    }

    public static BigDecimal parseRoomsValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        Matcher matcher = ROOMS_INTERVAL.matcher(string);
        if (matcher.find()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            if (n2 - n != -1) {
                throw new IllegalArgumentException("Can't parse rooms value '" + string + "' because of an invalid interval!");
            }
            return DatatypeConverter.parseDecimal((String)(n2 + ".5"));
        }
        try {
            return DatatypeConverter.parseDecimal((String)string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse rooms value '" + string + "'!", numberFormatException);
        }
    }

    public static URI parseUriValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) != null && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"http://") && !StringUtils.startsWithIgnoreCase((CharSequence)string, (CharSequence)"https://")) {
            string = "http://" + string;
        }
        try {
            return string != null ? new URI(string) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse URI '" + string + "'!", uRISyntaxException);
        }
    }

    public static TypeValue parseTypeValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        TypeValue typeValue = TypeValue.fromXmlValue(string);
        if (typeValue != null) {
            return typeValue;
        }
        throw new IllegalArgumentException("Can't parse type value '" + string + "'!");
    }

    public static BigInteger parseYearValue(String string) {
        try {
            string = StringUtils.trimToNull((String)string);
            return string != null ? DatatypeConverter.parseInteger((String)string) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can't parse year value '" + string + "'!", numberFormatException);
        }
    }

    public static String printAreaUnitValue(AreaUnitValue areaUnitValue) {
        if (areaUnitValue == null) {
            throw new IllegalArgumentException("Can't print empty area unit value!");
        }
        return areaUnitValue.write();
    }

    public static String printBooleanValue(Boolean bl) {
        if (bl == null) {
            throw new IllegalArgumentException("Can't print empty boolean value!");
        }
        return DatatypeConverter.printBoolean((boolean)bl);
    }

    public static String printContentValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            throw new IllegalArgumentException("Can't print empty content value!");
        }
        if (string.length() < 30) {
            throw new IllegalArgumentException("Can't print content value '" + string + "' because it is shorter than 30 characters!");
        }
        return string;
    }

    public static String printCountryValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            throw new IllegalArgumentException("Can't print empty country value!");
        }
        if (string.length() != 2 && string.length() != 3) {
            throw new IllegalArgumentException("Can't print country value '" + string + "' because it is neither an ISO-2-Code nor an ISO-3-Code!");
        }
        return StringUtils.upperCase((String)string, (Locale)Locale.ENGLISH);
    }

    public static String printDateValue(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Can't print empty date value!");
        }
        return new SimpleDateFormat("dd-MM-yyyy hh:mm:ss", Locale.ENGLISH).format(calendar.getTime());
    }

    public static String printFloorAreaValue(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print empty floor area value!");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(20L)) < 0) {
            throw new IllegalArgumentException("Can't print floor area value '" + bigInteger + "' because it is below 20!");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(50000L)) > 0) {
            throw new IllegalArgumentException("Can't print floor area value '" + bigInteger + "' because it is above 50000!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printForeclosureTypeValue(ForeclosureTypeValue foreclosureTypeValue) {
        if (foreclosureTypeValue == null) {
            throw new IllegalArgumentException("Can't print empty foreclosure type value!");
        }
        return foreclosureTypeValue.write();
    }

    public static String printLatitudeValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print empty latitude value!");
        }
        if (bigDecimal.compareTo(new BigDecimal("-90")) < 0) {
            throw new IllegalArgumentException("Can't print latitude value '" + bigDecimal + "' because it is below -90!");
        }
        if (bigDecimal.compareTo(new BigDecimal("90")) > 0) {
            throw new IllegalArgumentException("Can't print latitude value '" + bigDecimal + "' because it is above 90!");
        }
        bigDecimal = bigDecimal.setScale(10, 4);
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printLongitudeValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print empty longitude value!");
        }
        if (bigDecimal.compareTo(new BigDecimal("-180")) < 0) {
            throw new IllegalArgumentException("Can't print longitude value '" + bigDecimal + "' because it is below -180!");
        }
        if (bigDecimal.compareTo(new BigDecimal("180")) > 0) {
            throw new IllegalArgumentException("Can't print longitude value '" + bigDecimal + "' because it is above 180!");
        }
        bigDecimal = bigDecimal.setScale(10, 4);
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printOrientationValue(OrientationValue orientationValue) {
        if (orientationValue == null) {
            throw new IllegalArgumentException("Can't print empty orientation value!");
        }
        return orientationValue.write();
    }

    public static String printPlotAreaValue(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print empty plot area value!");
        }
        if (bigInteger.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException("Can't print floor plot value '" + bigInteger + "' because it is below 1!");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(1000000000L)) > 0) {
            throw new IllegalArgumentException("Can't print floor plot value '" + bigInteger + "' because it is above 1000000000!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printPriceCurrencyValue(Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("Can't print empty price currency value!");
        }
        return currency.getCurrencyCode();
    }

    public static String printPricePeriodValue(PricePeriodValue pricePeriodValue) {
        if (pricePeriodValue == null) {
            throw new IllegalArgumentException("Can't print empty price period value!");
        }
        return pricePeriodValue.write();
    }

    public static String printPriceValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print empty price value!");
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Can't print price value '" + bigDecimal + "' because it is below 0!");
        }
        if (bigDecimal.compareTo(new BigDecimal("1000000000")) > 0) {
            throw new IllegalArgumentException("Can't print price value '" + bigDecimal + "' because it is above 1000000000!");
        }
        bigDecimal = bigDecimal.setScale(2, 4);
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printRoomsValue(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        if (bigDecimal == null) {
            throw new IllegalArgumentException("Can't print empty rooms value!");
        }
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("Can't print rooms value '" + bigDecimal + "' because it is below 0!");
        }
        if (bigDecimal.compareTo(new BigDecimal("20")) > 0) {
            throw new IllegalArgumentException("Can't print rooms value '" + bigDecimal + "' because it is above 20!");
        }
        BigInteger bigInteger2 = (bigDecimal = bigDecimal.setScale(1, 4)).subtract(new BigDecimal(bigInteger = bigDecimal.toBigInteger(), 1)).multiply(BigDecimal.TEN).toBigInteger();
        if (bigInteger2.compareTo(BigInteger.ZERO) != 0) {
            return bigInteger.toString() + ".5";
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }

    public static String printTypeValue(TypeValue typeValue) {
        if (typeValue == null) {
            throw new IllegalArgumentException("Can't print empty type value!");
        }
        return typeValue.write();
    }

    public static String printUriValue(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("Can't print empty URI value!");
        }
        if ("http".equalsIgnoreCase(uRI.getScheme())) {
            return uRI.toString();
        }
        if ("https".equalsIgnoreCase(uRI.getScheme())) {
            return uRI.toString();
        }
        throw new IllegalArgumentException("Can't print URI '" + uRI + "' because of an unsupported scheme!");
    }

    public static String printYearValue(BigInteger bigInteger) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("Can't print empty year value!");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(1700L)) < 0) {
            throw new IllegalArgumentException("Can't print year value '" + bigInteger + "' because it is below 1700!");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(9999L)) > 0) {
            throw new IllegalArgumentException("Can't print year value '" + bigInteger + "' because it is above 9999!");
        }
        return DatatypeConverter.printInteger((BigInteger)bigInteger);
    }
}

