/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.idx;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvRecord;
import org.openestate.io.idx.IdxFormat;
import org.openestate.io.idx.types.GrossPremium;
import org.openestate.io.idx.types.Language;
import org.openestate.io.idx.types.Media;
import org.openestate.io.idx.types.ObjectCategory;
import org.openestate.io.idx.types.ObjectType;
import org.openestate.io.idx.types.OfferType;
import org.openestate.io.idx.types.PriceUnit;
import org.openestate.io.idx.types.Salutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxRecord
extends CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxRecord.class);
    private static final Pattern LINEBREAK = Pattern.compile("<br\\s*/?>", 2);
    protected static final String VERSION = "IDX3.01";
    public static final int LENGTH = 183;
    public static final int PICTURE_LIMIT = 13;
    protected static final int FIELD_VERSION = 0;
    protected static final int FIELD_SENDER_ID = 1;
    protected static final int FIELD_LAST_MODIFIED = 177;
    protected static final int FIELD_ADVERTISEMENT_ID = 178;
    protected static final int FIELD_SPAREFIELD_1 = 179;
    protected static final int FIELD_SPAREFIELD_2 = 180;
    protected static final int FIELD_SPAREFIELD_3 = 181;
    protected static final int FIELD_SPAREFIELD_4 = 182;
    protected static final int FIELD_OBJECT_CATEGORY = 2;
    protected static final int FIELD_OBJECT_TYPE = 3;
    protected static final int FIELD_OFFER_TYPE = 4;
    protected static final int FIELD_REF_PROPERTY = 5;
    protected static final int FIELD_REF_HOUSE = 6;
    protected static final int FIELD_REF_OBJECT = 7;
    protected static final int FIELD_OBJECT_STREET = 8;
    protected static final int FIELD_OBJECT_ZIP = 9;
    protected static final int FIELD_OBJECT_CITY = 10;
    protected static final int FIELD_OBJECT_STATE = 11;
    protected static final int FIELD_OBJECT_COUNTRY = 12;
    protected static final int FIELD_REGION = 13;
    protected static final int FIELD_OBJECT_SITUATION = 14;
    protected static final int FIELD_AVAILABLE_FROM = 15;
    protected static final int FIELD_OBJECT_TITLE = 16;
    protected static final int FIELD_OBJECT_DESCRIPTION = 17;
    protected static final int FIELD_SELLING_PRICE = 18;
    protected static final int FIELD_RENT_NET = 19;
    protected static final int FIELD_RENT_EXTRA = 20;
    protected static final int FIELD_PRICE_UNIT = 21;
    protected static final int FIELD_CURRENCY = 22;
    protected static final int FIELD_GROSS_PREMIUM = 23;
    protected static final int FIELD_FLOOR = 24;
    protected static final int FIELD_NUMBER_OF_ROOMS = 25;
    protected static final int FIELD_NUMBER_OF_APARTMENTS = 26;
    protected static final int FIELD_SURFACE_LIVING = 27;
    protected static final int FIELD_SURFACE_PROPERTY = 28;
    protected static final int FIELD_SURFACE_USABLE = 29;
    protected static final int FIELD_VOLUME = 30;
    protected static final int FIELD_YEAR_BUILT = 31;
    protected static final int FIELD_VIEW = 32;
    protected static final int FIELD_FIREPLACE = 33;
    protected static final int FIELD_CABLETV = 34;
    protected static final int FIELD_ELEVATOR = 35;
    protected static final int FIELD_CHILD_FRIENDLY = 36;
    protected static final int FIELD_PARKING = 37;
    protected static final int FIELD_GARAGE = 38;
    protected static final int FIELD_BALCONY = 39;
    protected static final int FIELD_ROOF_FLOOR = 40;
    protected static final int FIELD_DISTANCE_PUBLIC_TRANSPORT = 41;
    protected static final int FIELD_DISTANCE_SHOP = 42;
    protected static final int FIELD_DISTANCE_KINDERGARTEN = 43;
    protected static final int FIELD_DISTANCE_SCHOOL1 = 44;
    protected static final int FIELD_DISTANCE_SCHOOL2 = 45;
    protected static final int FIELD_URL = 67;
    protected static final int FIELD_PUBLISH_UNTIL = 85;
    protected static final int FIELD_DESTINATION = 86;
    protected static final int FIELD_DISTANCE_MOTORWAY = 108;
    protected static final int FIELD_CEILING_HEIGHT = 109;
    protected static final int FIELD_HALL_HEIGHT = 110;
    protected static final int FIELD_MAXIMAL_FLOOR_LOADING = 111;
    protected static final int FIELD_CARRYING_CAPACITY_CRANE = 112;
    protected static final int FIELD_CARRYING_CAPACITY_ELEVATOR = 113;
    protected static final int FIELD_ISDN = 114;
    protected static final int FIELD_WHEELCHAIR_ACCESSIBLE = 115;
    protected static final int FIELD_ANIMAL_ALLOWED = 116;
    protected static final int FIELD_RAMP = 117;
    protected static final int FIELD_LIFTING_PLATFORM = 118;
    protected static final int FIELD_RAILWAY_TERMINAL = 119;
    protected static final int FIELD_RESTROOMS = 120;
    protected static final int FIELD_WATER_SUPPLY = 121;
    protected static final int FIELD_SEWAGE_SUPPLY = 122;
    protected static final int FIELD_POWER_SUPPLY = 123;
    protected static final int FIELD_GAS_SUPPLY = 124;
    protected static final int FIELD_MUNICIPAL_INFO = 125;
    protected static final int FIELD_OWN_OBJECT_URL = 126;
    protected static final int FIELD_PUBLISHING_ID = 140;
    protected static final int FIELD_DELIVERY_ID = 141;
    protected static final int FIELD_COMMISSION_SHARING = 158;
    protected static final int FIELD_COMMISSION_OWN = 159;
    protected static final int FIELD_COMMISSION_PARTNER = 160;
    protected static final int FIELD_NUMBER_OF_FLOORS = 162;
    protected static final int FIELD_YEAR_RENOVATED = 163;
    protected static final int FIELD_FLAT_SHARING_COMMUNITY = 164;
    protected static final int FIELD_CORNER_HOUSE = 165;
    protected static final int FIELD_MIDDLE_HOUSE = 166;
    protected static final int FIELD_BUILDING_LAND_CONNECTED = 167;
    protected static final int FIELD_GARDENHOUSE = 168;
    protected static final int FIELD_RAISED_GROUND_FLOOR = 169;
    protected static final int FIELD_NEW_BUILDING = 170;
    protected static final int FIELD_OLD_BUILDING = 171;
    protected static final int FIELD_UNDER_BUILDING_LAWS = 172;
    protected static final int FIELD_UNDER_ROOF = 173;
    protected static final int FIELD_SWIMMINGPOOL = 174;
    protected static final int FIELD_MINENERGY_GENERAL = 175;
    protected static final int FIELD_MINENERGY_CERTIFIED = 176;
    protected static final int FIELD_AGENCY_ID = 68;
    protected static final int FIELD_AGENCY_NAME = 69;
    protected static final int FIELD_AGENCY_NAME2 = 70;
    protected static final int FIELD_AGENCY_REFERENCE = 71;
    protected static final int FIELD_AGENCY_STREET = 72;
    protected static final int FIELD_AGENCY_ZIP = 73;
    protected static final int FIELD_AGENCY_CITY = 74;
    protected static final int FIELD_AGENCY_COUNTRY = 75;
    protected static final int FIELD_AGENCY_PHONE = 76;
    protected static final int FIELD_AGENCY_MOBILE = 77;
    protected static final int FIELD_AGENCY_FAX = 78;
    protected static final int FIELD_AGENCY_EMAIL = 79;
    protected static final int FIELD_AGENCY_LOGO = 80;
    protected static final int FIELD_AGENCY_LOGO2 = 161;
    protected static final int FIELD_VISIT_NAME = 81;
    protected static final int FIELD_VISIT_PHONE = 82;
    protected static final int FIELD_VISIT_EMAIL = 83;
    protected static final int FIELD_VISIT_REMARK = 84;
    protected static final int FIELD_PICTURE_1_FILE = 46;
    protected static final int FIELD_PICTURE_1_TITLE = 51;
    protected static final int FIELD_PICTURE_1_TEXT = 56;
    protected static final int FIELD_PICTURE_1_URL = 99;
    protected static final int FIELD_PICTURE_2_FILE = 47;
    protected static final int FIELD_PICTURE_2_TITLE = 52;
    protected static final int FIELD_PICTURE_2_TEXT = 57;
    protected static final int FIELD_PICTURE_2_URL = 100;
    protected static final int FIELD_PICTURE_3_FILE = 48;
    protected static final int FIELD_PICTURE_3_TITLE = 53;
    protected static final int FIELD_PICTURE_3_TEXT = 58;
    protected static final int FIELD_PICTURE_3_URL = 101;
    protected static final int FIELD_PICTURE_4_FILE = 49;
    protected static final int FIELD_PICTURE_4_TITLE = 54;
    protected static final int FIELD_PICTURE_4_TEXT = 59;
    protected static final int FIELD_PICTURE_4_URL = 102;
    protected static final int FIELD_PICTURE_5_FILE = 50;
    protected static final int FIELD_PICTURE_5_TITLE = 55;
    protected static final int FIELD_PICTURE_5_TEXT = 60;
    protected static final int FIELD_PICTURE_5_URL = 103;
    protected static final int FIELD_PICTURE_6_FILE = 87;
    protected static final int FIELD_PICTURE_6_TITLE = 91;
    protected static final int FIELD_PICTURE_6_TEXT = 95;
    protected static final int FIELD_PICTURE_6_URL = 104;
    protected static final int FIELD_PICTURE_7_FILE = 88;
    protected static final int FIELD_PICTURE_7_TITLE = 92;
    protected static final int FIELD_PICTURE_7_TEXT = 96;
    protected static final int FIELD_PICTURE_7_URL = 105;
    protected static final int FIELD_PICTURE_8_FILE = 89;
    protected static final int FIELD_PICTURE_8_TITLE = 93;
    protected static final int FIELD_PICTURE_8_TEXT = 97;
    protected static final int FIELD_PICTURE_8_URL = 106;
    protected static final int FIELD_PICTURE_9_FILE = 90;
    protected static final int FIELD_PICTURE_9_TITLE = 94;
    protected static final int FIELD_PICTURE_9_TEXT = 98;
    protected static final int FIELD_PICTURE_9_URL = 107;
    protected static final int FIELD_PICTURE_10_FILE = 142;
    protected static final int FIELD_PICTURE_10_TITLE = 146;
    protected static final int FIELD_PICTURE_10_TEXT = 150;
    protected static final int FIELD_PICTURE_10_URL = 154;
    protected static final int FIELD_PICTURE_11_FILE = 143;
    protected static final int FIELD_PICTURE_11_TITLE = 147;
    protected static final int FIELD_PICTURE_11_TEXT = 151;
    protected static final int FIELD_PICTURE_11_URL = 155;
    protected static final int FIELD_PICTURE_12_FILE = 144;
    protected static final int FIELD_PICTURE_12_TITLE = 148;
    protected static final int FIELD_PICTURE_12_TEXT = 152;
    protected static final int FIELD_PICTURE_12_URL = 156;
    protected static final int FIELD_PICTURE_13_FILE = 145;
    protected static final int FIELD_PICTURE_13_TITLE = 149;
    protected static final int FIELD_PICTURE_13_TEXT = 153;
    protected static final int FIELD_PICTURE_13_URL = 157;
    protected static final int FIELD_MOVIE_FILE = 61;
    protected static final int FIELD_MOVIE_TITLE = 62;
    protected static final int FIELD_MOVIE_TEXT = 63;
    protected static final int FIELD_DOCUMENT_FILE = 64;
    protected static final int FIELD_DOCUMENT_TITLE = 65;
    protected static final int FIELD_DOCUMENT_TEXT = 66;
    protected static final int FIELD_BILLING_SALUTATION = 127;
    protected static final int FIELD_BILLING_FIRST_NAME = 128;
    protected static final int FIELD_BILLING_NAME = 129;
    protected static final int FIELD_BILLING_COMPANY = 130;
    protected static final int FIELD_BILLING_STREET = 131;
    protected static final int FIELD_BILLING_POST_BOX = 132;
    protected static final int FIELD_BILLING_ZIP = 133;
    protected static final int FIELD_BILLING_PLACE_NAME = 134;
    protected static final int FIELD_BILLING_COUNTRY = 135;
    protected static final int FIELD_BILLING_PHONE = 136;
    protected static final int FIELD_BILLING_PHONE2 = 137;
    protected static final int FIELD_BILLING_MOBILE = 138;
    protected static final int FIELD_BILLING_LANGUAGE = 139;

    public IdxRecord() {
        this.set(0, VERSION);
    }

    public String getAdvertisementId() {
        return this.get(178);
    }

    public String getAgencyCity() {
        return this.get(74);
    }

    public String getAgencyCountry() {
        return this.get(75);
    }

    public String getAgencyEmail() {
        return this.get(79);
    }

    public String getAgencyFax() {
        return this.get(78);
    }

    public String getAgencyId() {
        return this.get(68);
    }

    @Deprecated
    public String getAgencyLogo() {
        return this.get(80);
    }

    @Deprecated
    public String getAgencyLogo2() {
        return this.get(161);
    }

    @Deprecated
    public String getAgencyMobile() {
        return this.get(77);
    }

    public String getAgencyName() {
        return this.get(69);
    }

    public String getAgencyName2() {
        return this.get(70);
    }

    public String getAgencyPhone() {
        return this.get(76);
    }

    public String getAgencyReference() {
        return this.get(71);
    }

    public String getAgencyStreet() {
        return this.get(72);
    }

    public String getAgencyZip() {
        return this.get(73);
    }

    public Calendar getAvailableFrom() {
        try {
            return IdxFormat.parseDateAsCalendar(this.get(15));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read availability date!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public String getBillingCompany() {
        return this.get(130);
    }

    public String getBillingCountry() {
        return this.get(135);
    }

    public String getBillingFirstName() {
        return this.get(128);
    }

    public Language getBillingLanguage() {
        return Language.parse(this.get(139));
    }

    public String getBillingMobile() {
        return this.get(138);
    }

    public String getBillingName() {
        return this.get(129);
    }

    public String getBillingPlaceName() {
        return this.get(134);
    }

    public String getBillingPhone() {
        return this.get(136);
    }

    public String getBillingPhone2() {
        return this.get(137);
    }

    public String getBillingPostBox() {
        return this.get(132);
    }

    public Salutation getBillingSalutation() {
        return Salutation.parse(this.get(127));
    }

    public String getBillingStreet() {
        return this.get(131);
    }

    public String getBillingZip() {
        return this.get(133);
    }

    public BigDecimal getCarryingCapacityCrane() {
        try {
            return IdxFormat.parseDecimal(this.get(112));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read carrying capacity for the crane!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getCarryingCapacityElevator() {
        try {
            return IdxFormat.parseDecimal(this.get(113));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read carrying capacity for the elevator!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getCeilingHeight() {
        try {
            return IdxFormat.parseDecimal(this.get(109));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read ceiling height!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    @Deprecated
    public String getCommissionOwn() {
        return this.get(159);
    }

    @Deprecated
    public String getCommissionPartner() {
        return this.get(160);
    }

    public Currency getCurrency() {
        String string = this.get(22);
        try {
            return string != null ? Currency.getInstance(string) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("Can't read currency from '" + string + "'!");
            LOGGER.warn("> " + illegalArgumentException.getLocalizedMessage(), (Throwable)illegalArgumentException);
            return null;
        }
    }

    public Long getDeliveryId() {
        try {
            return IdxFormat.parseLong(this.get(141));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read delivery id!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    @Deprecated
    public String getDestination() {
        return this.get(86);
    }

    public Integer getDistanceKindergarten() {
        try {
            return IdxFormat.parseInteger(this.get(43));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to kindergarten!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getDistanceMotorway() {
        try {
            return IdxFormat.parseInteger(this.get(108));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to motorway!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getDistancePublicTransport() {
        try {
            return IdxFormat.parseInteger(this.get(41));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to public transport!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getDistanceSchool1() {
        try {
            return IdxFormat.parseInteger(this.get(44));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to primary school!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getDistanceSchool2() {
        try {
            return IdxFormat.parseInteger(this.get(45));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to secondary school!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getDistanceShop() {
        try {
            return IdxFormat.parseInteger(this.get(42));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read distance to shopping!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Media getDocument() {
        String string = this.get(64);
        return string != null ? new Media(string, this.get(65), this.get(66)) : null;
    }

    public Integer getFloor() {
        try {
            return IdxFormat.parseInteger(this.get(24));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read floor!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public GrossPremium getGrossPremium() {
        return GrossPremium.parse(this.get(23));
    }

    public BigDecimal getHallHeight() {
        try {
            return IdxFormat.parseDecimal(this.get(110));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read hall height!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Calendar getLastModified() {
        try {
            return IdxFormat.parseDateTimeAsCalendar(this.get(177));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read last modification date!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public BigDecimal getMaximalFloorLoading() {
        try {
            return IdxFormat.parseDecimal(this.get(111));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read maximal floor loading!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Media getMovie() {
        String string = this.get(61);
        return string != null ? new Media(string, this.get(62), this.get(63)) : null;
    }

    public BigDecimal getNumberOfApartments() {
        try {
            return IdxFormat.parseDecimal(this.get(26));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of apartments!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getNumberOfFloors() {
        try {
            return IdxFormat.parseInteger(this.get(162));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of floors!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getNumberOfRooms() {
        try {
            return IdxFormat.parseDecimal(this.get(25));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read number of rooms!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjectCategory getObjectCategory() {
        return ObjectCategory.parse(this.get(2));
    }

    public String getObjectCity() {
        return this.get(10);
    }

    public String getObjectCountry() {
        return this.get(12);
    }

    public String getObjectDescription() {
        return this.get(17);
    }

    public String getObjectSituation() {
        return this.get(14);
    }

    public String getObjectState() {
        return this.get(11);
    }

    public String getObjectStreet() {
        return this.get(8);
    }

    public String getObjectTitle() {
        return this.get(16);
    }

    public ObjectType getObjectType() {
        ObjectCategory objectCategory = this.getObjectCategory();
        return objectCategory != null ? ObjectType.parse(objectCategory, this.get(3)) : null;
    }

    public String getObjectZip() {
        return this.get(9);
    }

    public OfferType getOfferType() {
        return OfferType.parse(this.get(4));
    }

    public String getOwnObjectUrl() {
        return this.get(126);
    }

    public Media getPicture(int n) {
        switch (n) {
            case 1: {
                return this.getPicture1();
            }
            case 2: {
                return this.getPicture2();
            }
            case 3: {
                return this.getPicture3();
            }
            case 4: {
                return this.getPicture4();
            }
            case 5: {
                return this.getPicture5();
            }
            case 6: {
                return this.getPicture6();
            }
            case 7: {
                return this.getPicture7();
            }
            case 8: {
                return this.getPicture8();
            }
            case 9: {
                return this.getPicture9();
            }
            case 10: {
                return this.getPicture10();
            }
            case 11: {
                return this.getPicture11();
            }
            case 12: {
                return this.getPicture12();
            }
            case 13: {
                return this.getPicture13();
            }
        }
        throw new IllegalArgumentException("Unsupported picture position " + n + "!");
    }

    public Media getPicture1() {
        String string = this.get(46);
        return string != null ? new Media(string, this.get(51), this.get(56), this.get(99)) : null;
    }

    public Media getPicture2() {
        String string = this.get(47);
        return string != null ? new Media(string, this.get(52), this.get(57), this.get(100)) : null;
    }

    public Media getPicture3() {
        String string = this.get(48);
        return string != null ? new Media(string, this.get(53), this.get(58), this.get(101)) : null;
    }

    public Media getPicture4() {
        String string = this.get(49);
        return string != null ? new Media(string, this.get(54), this.get(59), this.get(102)) : null;
    }

    public Media getPicture5() {
        String string = this.get(50);
        return string != null ? new Media(string, this.get(55), this.get(60), this.get(103)) : null;
    }

    public Media getPicture6() {
        String string = this.get(87);
        return string != null ? new Media(string, this.get(91), this.get(95), this.get(104)) : null;
    }

    public Media getPicture7() {
        String string = this.get(88);
        return string != null ? new Media(string, this.get(92), this.get(96), this.get(105)) : null;
    }

    public Media getPicture8() {
        String string = this.get(89);
        return string != null ? new Media(string, this.get(93), this.get(97), this.get(106)) : null;
    }

    public Media getPicture9() {
        String string = this.get(90);
        return string != null ? new Media(string, this.get(94), this.get(98), this.get(107)) : null;
    }

    public Media getPicture10() {
        String string = this.get(142);
        return string != null ? new Media(string, this.get(146), this.get(150), this.get(154)) : null;
    }

    public Media getPicture11() {
        String string = this.get(143);
        return string != null ? new Media(string, this.get(147), this.get(151), this.get(155)) : null;
    }

    public Media getPicture12() {
        String string = this.get(144);
        return string != null ? new Media(string, this.get(148), this.get(152), this.get(156)) : null;
    }

    public Media getPicture13() {
        String string = this.get(145);
        return string != null ? new Media(string, this.get(149), this.get(153), this.get(157)) : null;
    }

    public Media[] getPictures() {
        ArrayList<Media> arrayList = new ArrayList<Media>();
        for (int i = 1; i <= 13; ++i) {
            Media media = this.getPicture(i);
            if (media == null) continue;
            arrayList.add(media);
        }
        return arrayList.toArray(new Media[0]);
    }

    public PriceUnit getPriceUnit() {
        return PriceUnit.parse(this.get(21));
    }

    public Long getPublishingId() {
        try {
            return IdxFormat.parseLong(this.get(140));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read publishing id!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    @Deprecated
    public Calendar getPublishUntil() {
        try {
            return IdxFormat.parseDateAsCalendar(this.get(85));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read publish until date!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    protected int getRecordLength() {
        return 183;
    }

    @Deprecated
    public String getRegion() {
        return this.get(13);
    }

    public String getRefHouse() {
        return this.get(6);
    }

    public String getRefObject() {
        return this.get(7);
    }

    public String getRefProperty() {
        return this.get(5);
    }

    public Long getRentExtra() {
        try {
            return IdxFormat.parseLong(this.get(20));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read extra rent!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Long getRentNet() {
        try {
            return IdxFormat.parseLong(this.get(19));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read net rent!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Long getSellingPrice() {
        try {
            return IdxFormat.parseLong(this.get(18));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read selling price!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getSenderId() {
        return this.get(1);
    }

    public String getSparefield1() {
        return this.get(179);
    }

    public String getSparefield2() {
        return this.get(180);
    }

    public String getSparefield3() {
        return this.get(181);
    }

    public String getSparefield4() {
        return this.get(182);
    }

    public Long getSurfaceLiving() {
        try {
            return IdxFormat.parseLong(this.get(27));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read living surface!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Long getSurfaceProperty() {
        try {
            return IdxFormat.parseLong(this.get(28));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read property surface!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Long getSurfaceUsable() {
        try {
            return IdxFormat.parseLong(this.get(29));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read usable surface!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getUrl() {
        return this.get(67);
    }

    public String getVersion() {
        return this.get(0);
    }

    @Deprecated
    public String getVisitEmail() {
        return this.get(83);
    }

    public String getVisitName() {
        return this.get(81);
    }

    public String getVisitPhone() {
        return this.get(82);
    }

    public String getVisitRemark() {
        return this.get(84);
    }

    public Long getVolume() {
        try {
            return IdxFormat.parseLong(this.get(30));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read volume!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getYearBuilt() {
        try {
            return IdxFormat.parseInteger(this.get(31));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read build year!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getYearRenovated() {
        try {
            return IdxFormat.parseInteger(this.get(163));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read renovation year!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public boolean isAnimalAllowed() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(116)));
    }

    public boolean isBalcony() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(39)));
    }

    public boolean isBuildingLandConnected() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(167)));
    }

    public boolean isCableTv() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(34)));
    }

    public boolean isChildFriendly() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(36)));
    }

    @Deprecated
    public boolean isCommissionSharing() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(158)));
    }

    public boolean isCornerHouse() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(165)));
    }

    public boolean isElevator() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(35)));
    }

    public boolean isFlatSharingCommunity() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(164)));
    }

    public boolean isFireplace() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(33)));
    }

    public boolean isGarage() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(38)));
    }

    public boolean isGardenhouse() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(168)));
    }

    public boolean isGasSupply() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(124)));
    }

    public boolean isIsdn() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(114)));
    }

    public boolean isLiftingPlatform() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(118)));
    }

    public boolean isMiddleHouse() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(166)));
    }

    public boolean isMinEnergyCertified() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(176)));
    }

    public boolean isMinEnergyGeneral() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(175)));
    }

    @Deprecated
    public boolean isMunicipalInfo() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(125)));
    }

    public boolean isNewBuilding() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(170)));
    }

    public boolean isOldBuilding() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(171)));
    }

    public boolean isParking() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(37)));
    }

    public boolean isPowerSupply() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(123)));
    }

    public boolean isRailwayTerminal() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(119)));
    }

    public boolean isRaisedGroundFloor() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(169)));
    }

    public boolean isRamp() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(117)));
    }

    public boolean isRestrooms() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(120)));
    }

    @Deprecated
    public boolean isRoofFloor() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(40)));
    }

    public boolean isSwimmingpool() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(174)));
    }

    public boolean isUnderBuildingLaws() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(172)));
    }

    public boolean isUnderRoof() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(173)));
    }

    public boolean isSewageSupply() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(122)));
    }

    public boolean isView() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(32)));
    }

    public boolean isWaterSupply() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(121)));
    }

    public boolean isWheelchairAccessible() {
        return Boolean.TRUE.equals(IdxFormat.parseBoolean(this.get(115)));
    }

    public static IdxRecord newRecord(CSVRecord cSVRecord) {
        IdxRecord idxRecord = new IdxRecord();
        idxRecord.parse(cSVRecord);
        return idxRecord;
    }

    protected void parse(CSVRecord cSVRecord) {
        String string = StringUtils.trimToNull((String)cSVRecord.get(0));
        if (string != null && !VERSION.equalsIgnoreCase(string) && !"3.01".equalsIgnoreCase(string)) {
            LOGGER.warn("IDX version '" + string + "' is not supported. Trying to parse the record anyway.");
        }
        super.parse(cSVRecord);
    }

    protected String parse(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        Matcher matcher = LINEBREAK.matcher(string);
        return matcher.find() ? matcher.replaceAll(System.lineSeparator()) : string;
    }

    protected Iterable<String> print() {
        String string = this.getVersion();
        if (string == null) {
            this.setVersion(VERSION);
        }
        return super.print();
    }

    public void setAdvertisementId(String string) {
        this.set(178, IdxFormat.printString(string, 200));
    }

    public void setAgencyCity(String string) {
        this.set(74, IdxFormat.printString(string, 200));
    }

    public void setAgencyCountry(String string) {
        string = StringUtils.trimToEmpty((String)string);
        this.set(75, IdxFormat.getCountryCode(string));
    }

    public void setAgencyEmail(String string) {
        this.set(79, IdxFormat.printString(string, 200));
    }

    public void setAgencyFax(String string) {
        this.set(78, IdxFormat.printString(string, 200));
    }

    public void setAgencyId(String string) {
        this.set(68, IdxFormat.printString(string, 10));
    }

    @Deprecated
    public void setAgencyLogo(String string) {
        this.set(80, IdxFormat.printString(string, 200));
    }

    @Deprecated
    public void setAgencyLogo2(String string) {
        this.set(161, IdxFormat.printString(string, 200));
    }

    @Deprecated
    public void setAgencyMobile(String string) {
        this.set(77, IdxFormat.printString(string, 200));
    }

    public void setAgencyName(String string) {
        this.set(69, IdxFormat.printString(string, 200));
    }

    public void setAgencyName2(String string) {
        this.set(70, IdxFormat.printString(string, 255));
    }

    public void setAgencyPhone(String string) {
        this.set(76, IdxFormat.printString(string, 200));
    }

    public void setAgencyReference(String string) {
        this.set(71, IdxFormat.printString(string, 200));
    }

    public void setAgencyStreet(String string) {
        this.set(72, IdxFormat.printString(string, 200));
    }

    public void setAgencyZip(String string) {
        this.set(73, IdxFormat.printString(string, 200));
    }

    public void setAnimalAllowed(boolean bl) {
        this.setAnimalAllowed((Boolean)bl);
    }

    public void setAnimalAllowed(Boolean bl) {
        this.set(116, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setAvailableFrom(Calendar calendar) {
        this.set(15, IdxFormat.printDate(calendar));
    }

    public void setAvailableFrom(Date date) {
        this.set(15, IdxFormat.printDate(date));
    }

    public void setBalcony(boolean bl) {
        this.setBalcony((Boolean)bl);
    }

    public void setBalcony(Boolean bl) {
        this.set(39, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setBillingCompany(String string) {
        this.set(130, IdxFormat.printString(string, 200));
    }

    public void setBillingCountry(String string) {
        this.set(135, IdxFormat.printString(string, 200));
    }

    public void setBillingFirstName(String string) {
        this.set(128, IdxFormat.printString(string, 200));
    }

    public void setBillingLanguage(Language language) {
        this.set(139, language != null ? language.print() : null);
    }

    public void setBillingMobile(String string) {
        this.set(138, IdxFormat.printString(string, 200));
    }

    public void setBillingName(String string) {
        this.set(129, IdxFormat.printString(string, 200));
    }

    public void setBillingPlaceName(String string) {
        this.set(134, IdxFormat.printString(string, 200));
    }

    public void setBillingPhone(String string) {
        this.set(136, IdxFormat.printString(string, 200));
    }

    public void setBillingPhone2(String string) {
        this.set(137, IdxFormat.printString(string, 200));
    }

    public void setBillingPostBox(String string) {
        this.set(132, IdxFormat.printString(string, 200));
    }

    public void setBillingSalutation(Salutation salutation) {
        this.set(127, salutation != null ? salutation.print() : null);
    }

    public void setBillingStreet(String string) {
        this.set(131, IdxFormat.printString(string, 200));
    }

    public void setBillingZip(String string) {
        this.set(133, IdxFormat.printString(string, 10));
    }

    public void setBuildingLandConnected(boolean bl) {
        this.setBuildingLandConnected((Boolean)bl);
    }

    public void setBuildingLandConnected(Boolean bl) {
        this.set(167, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setCableTv(boolean bl) {
        this.setCableTv((Boolean)bl);
    }

    public void setCableTv(Boolean bl) {
        this.set(34, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setCarryingCapacityCrane(Number number) {
        this.set(112, IdxFormat.printNumber(number, 10, 1));
    }

    public void setCarryingCapacityElevator(Number number) {
        this.set(113, IdxFormat.printNumber(number, 10, 1));
    }

    public void setCeilingHeight(Number number) {
        this.set(109, IdxFormat.printNumber(number, 10, 2));
    }

    public void setChildFriendly(boolean bl) {
        this.setChildFriendly((Boolean)bl);
    }

    public void setChildFriendly(Boolean bl) {
        this.set(36, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    @Deprecated
    public void setCommissionOwn(String string) {
        this.set(159, IdxFormat.printString(string, 10));
    }

    @Deprecated
    public void setCommissionPartner(String string) {
        this.set(160, IdxFormat.printString(string, 10));
    }

    @Deprecated
    public void setCommissionSharing(boolean bl) {
        this.setCommissionSharing((Boolean)bl);
    }

    @Deprecated
    public void setCommissionSharing(Boolean bl) {
        this.set(158, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setCornerHouse(boolean bl) {
        this.setCornerHouse((Boolean)bl);
    }

    public void setCornerHouse(Boolean bl) {
        this.set(165, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setCurrency(Currency currency) {
        this.set(22, currency != null ? currency.getCurrencyCode() : null);
    }

    @Deprecated
    public void setDestination(String string) {
        this.set(86, IdxFormat.printString(string, 200));
    }

    public void setDistanceKindergarten(Number number) {
        this.set(43, IdxFormat.printNumber(number, 5));
    }

    public void setDistanceMotorway(Number number) {
        this.set(108, IdxFormat.printNumber(number, 5));
    }

    public void setDistancePublicTransport(Number number) {
        this.set(41, IdxFormat.printNumber(number, 5));
    }

    public void setDistanceSchool1(Number number) {
        this.set(44, IdxFormat.printNumber(number, 5));
    }

    public void setDistanceSchool2(Number number) {
        this.set(45, IdxFormat.printNumber(number, 5));
    }

    public void setDistanceShop(Number number) {
        this.set(42, IdxFormat.printNumber(number, 5));
    }

    public void setDocument(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(64, string);
        this.set(65, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(66, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
    }

    public void setElevator(boolean bl) {
        this.setElevator((Boolean)bl);
    }

    public void setElevator(Boolean bl) {
        this.set(35, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setFireplace(boolean bl) {
        this.setFireplace((Boolean)bl);
    }

    public void setFireplace(Boolean bl) {
        this.set(33, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setFlatSharingCommunity(boolean bl) {
        this.setFlatSharingCommunity((Boolean)bl);
    }

    public void setFlatSharingCommunity(Boolean bl) {
        this.set(164, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setFloor(Number number) {
        this.set(24, IdxFormat.printNumber(number, 6));
    }

    public void setGarage(boolean bl) {
        this.setGarage((Boolean)bl);
    }

    public void setGarage(Boolean bl) {
        this.set(38, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setGardenhouse(boolean bl) {
        this.setGardenhouse((Boolean)bl);
    }

    public void setGardenhouse(Boolean bl) {
        this.set(168, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setGasSupply(boolean bl) {
        this.setGasSupply((Boolean)bl);
    }

    public void setGasSupply(Boolean bl) {
        this.set(124, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setGrossPremium(GrossPremium grossPremium) {
        this.set(23, grossPremium != null ? grossPremium.print() : null);
    }

    public void setHallHeight(Number number) {
        this.set(110, IdxFormat.printNumber(number, 10, 2));
    }

    public void setIsdn(boolean bl) {
        this.setIsdn((Boolean)bl);
    }

    public void setIsdn(Boolean bl) {
        this.set(114, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setLastModified(Calendar calendar) {
        this.set(177, IdxFormat.printDateTime(calendar));
    }

    public void setLastModified(Date date) {
        this.set(177, IdxFormat.printDateTime(date));
    }

    public void setLiftingPlatform(boolean bl) {
        this.setLiftingPlatform((Boolean)bl);
    }

    public void setLiftingPlatform(Boolean bl) {
        this.set(118, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setMaximalFloorLoading(Number number) {
        this.set(111, IdxFormat.printNumber(number, 10, 1));
    }

    public void setMiddleHouse(boolean bl) {
        this.setMiddleHouse((Boolean)bl);
    }

    public void setMiddleHouse(Boolean bl) {
        this.set(166, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setMinEnergyCertified(boolean bl) {
        this.setMinEnergyCertified((Boolean)bl);
    }

    public void setMinEnergyCertified(Boolean bl) {
        this.set(176, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setMinEnergyGeneral(boolean bl) {
        this.setMinEnergyGeneral((Boolean)bl);
    }

    public void setMinEnergyGeneral(Boolean bl) {
        this.set(175, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setMovie(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(61, string);
        this.set(62, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(63, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
    }

    @Deprecated
    public void setMunicipalInfo(boolean bl) {
        this.setMunicipalInfo((Boolean)bl);
    }

    @Deprecated
    public void setMunicipalInfo(Boolean bl) {
        this.set(125, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setNewBuilding(boolean bl) {
        this.setNewBuilding((Boolean)bl);
    }

    public void setNewBuilding(Boolean bl) {
        this.set(170, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setNumberOfApartments(Number number) {
        this.set(26, IdxFormat.printNumber(number, 5, 1));
    }

    public void setNumberOfFloors(Number number) {
        this.set(162, IdxFormat.printNumber(number, 2));
    }

    public void setNumberOfRooms(Number number) {
        this.set(25, IdxFormat.printNumber(number, 5, 1));
    }

    protected void setObjectCategory(ObjectCategory objectCategory) {
        this.set(2, objectCategory != null ? objectCategory.print() : null);
    }

    public void setObjectCity(String string) {
        this.set(10, IdxFormat.printString(string, 200));
    }

    public void setObjectCountry(String string) {
        string = StringUtils.trimToEmpty((String)string);
        this.set(12, IdxFormat.getCountryCode(string));
    }

    public void setObjectDescription(String string) {
        this.set(17, IdxFormat.printString(string, 4000));
    }

    public void setObjectSituation(String string) {
        this.set(14, IdxFormat.printString(string, 50));
    }

    public void setObjectState(String string) {
        this.set(11, (string = StringUtils.trimToEmpty((String)string)).length() == 2 ? string.toUpperCase() : null);
    }

    public void setObjectStreet(String string) {
        this.set(8, IdxFormat.printString(string, 200));
    }

    public void setObjectTitle(String string) {
        this.set(16, IdxFormat.printString(string, 70));
    }

    public void setObjectType(ObjectType objectType) {
        this.setObjectCategory(objectType != null ? objectType.getCategory() : null);
        this.set(3, objectType != null ? objectType.print() : null);
    }

    public void setObjectZip(String string) {
        this.set(9, IdxFormat.printString(string, 10));
    }

    public void setOldBuilding(boolean bl) {
        this.setOldBuilding((Boolean)bl);
    }

    public void setOldBuilding(Boolean bl) {
        this.set(171, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setOfferType(OfferType offerType) {
        this.set(4, offerType != null ? offerType.print() : null);
    }

    public void setOwnObjectUrl(String string) {
        this.set(126, IdxFormat.printString(string, 100));
    }

    public void setParking(boolean bl) {
        this.setParking((Boolean)bl);
    }

    public void setParking(Boolean bl) {
        this.set(37, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setPicture(Media media, int n) {
        switch (n) {
            case 1: {
                this.setPicture1(media);
                break;
            }
            case 2: {
                this.setPicture2(media);
                break;
            }
            case 3: {
                this.setPicture3(media);
                break;
            }
            case 4: {
                this.setPicture4(media);
                break;
            }
            case 5: {
                this.setPicture5(media);
                break;
            }
            case 6: {
                this.setPicture6(media);
                break;
            }
            case 7: {
                this.setPicture7(media);
                break;
            }
            case 8: {
                this.setPicture8(media);
                break;
            }
            case 9: {
                this.setPicture9(media);
                break;
            }
            case 10: {
                this.setPicture10(media);
                break;
            }
            case 11: {
                this.setPicture11(media);
                break;
            }
            case 12: {
                this.setPicture12(media);
                break;
            }
            case 13: {
                this.setPicture13(media);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture position " + n + "!");
            }
        }
    }

    public void setPicture1(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(46, string);
        this.set(51, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(56, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(99, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture2(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(47, string);
        this.set(52, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(57, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(100, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture3(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(48, string);
        this.set(53, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(58, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(101, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture4(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(49, string);
        this.set(54, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(59, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(102, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture5(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(50, string);
        this.set(55, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(60, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(103, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture6(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(87, string);
        this.set(91, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(95, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(104, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture7(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(88, string);
        this.set(92, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(96, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(105, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture8(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(89, string);
        this.set(93, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(97, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(106, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture9(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(90, string);
        this.set(94, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(98, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(107, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture10(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(142, string);
        this.set(146, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(150, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(154, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture11(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(143, string);
        this.set(147, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(151, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(155, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture12(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(144, string);
        this.set(148, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(152, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(156, media != null && string != null ? media.getUrl() : null);
    }

    public void setPicture13(Media media) {
        String string = media != null ? StringUtils.trimToNull((String)media.getFileName()) : null;
        this.set(145, string);
        this.set(149, media != null && string != null ? IdxFormat.printString(media.getTitle(), 200) : null);
        this.set(153, media != null && string != null ? IdxFormat.printString(media.getDescription(), 1800) : null);
        this.set(157, media != null && string != null ? media.getUrl() : null);
    }

    public void setPictures(Iterable<Media> iterable) {
        int n = 1;
        if (iterable != null) {
            for (Media media : iterable) {
                this.setPicture(media, n);
                if (++n <= 13) continue;
                break;
            }
        }
        for (int i = n; i <= 13; ++i) {
            this.setPicture(null, i);
        }
    }

    public void setPowerSupply(boolean bl) {
        this.setPowerSupply((Boolean)bl);
    }

    public void setPowerSupply(Boolean bl) {
        this.set(123, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setPriceUnit(PriceUnit priceUnit) {
        this.set(21, priceUnit != null ? priceUnit.print() : null);
    }

    @Deprecated
    public void setPublishUntil(Calendar calendar) {
        this.set(85, IdxFormat.printDate(calendar));
    }

    @Deprecated
    public void setPublishUntil(Date date) {
        this.set(85, IdxFormat.printDate(date));
    }

    public void setRailwayTerminal(boolean bl) {
        this.setRailwayTerminal((Boolean)bl);
    }

    public void setRailwayTerminal(Boolean bl) {
        this.set(119, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setRaisedGroundFloor(boolean bl) {
        this.setRaisedGroundFloor((Boolean)bl);
    }

    public void setRaisedGroundFloor(Boolean bl) {
        this.set(169, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setRamp(boolean bl) {
        this.setRamp((Boolean)bl);
    }

    public void setRamp(Boolean bl) {
        this.set(117, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setRefHouse(String string) {
        this.set(6, IdxFormat.printString(string, 80));
    }

    public void setRefObject(String string) {
        this.set(7, IdxFormat.printString(string, 80));
    }

    public void setRefProperty(String string) {
        this.set(5, IdxFormat.printString(string, 80));
    }

    @Deprecated
    public void setRegion(String string) {
        this.set(13, IdxFormat.printString(string, 200));
    }

    public void setRentExtra(Number number) {
        this.set(20, IdxFormat.printNumber(number, 10));
    }

    public void setRentNet(Number number) {
        this.set(19, IdxFormat.printNumber(number, 10));
    }

    public void setRestrooms(boolean bl) {
        this.setRestrooms((Boolean)bl);
    }

    public void setRestrooms(Boolean bl) {
        this.set(120, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    @Deprecated
    public void setRoofFloor(boolean bl) {
        this.setRoofFloor((Boolean)bl);
    }

    @Deprecated
    public void setRoofFloor(Boolean bl) {
        this.set(40, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setSellingPrice(Number number) {
        this.set(18, IdxFormat.printNumber(number, 10));
    }

    public void setSenderId(String string) {
        this.set(1, IdxFormat.printString(string, 50));
    }

    public void setSewageSupply(boolean bl) {
        this.setSewageSupply((Boolean)bl);
    }

    public void setSewageSupply(Boolean bl) {
        this.set(122, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setSparefield1(String string) {
        this.set(179, IdxFormat.printString(string, 255));
    }

    public void setSparefield2(String string) {
        this.set(180, IdxFormat.printString(string, 255));
    }

    public void setSparefield3(String string) {
        this.set(181, IdxFormat.printString(string, 255));
    }

    public void setSparefield4(String string) {
        this.set(182, IdxFormat.printString(string, 255));
    }

    public void setSurfaceLiving(Number number) {
        this.set(27, IdxFormat.printNumber(number, 10));
    }

    public void setSurfaceProperty(Number number) {
        this.set(28, IdxFormat.printNumber(number, 10));
    }

    public void setSurfaceUsable(Number number) {
        this.set(29, IdxFormat.printNumber(number, 10));
    }

    public void setSwimmingpool(boolean bl) {
        this.setSwimmingpool((Boolean)bl);
    }

    public void setSwimmingpool(Boolean bl) {
        this.set(174, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setUnderBuildingLaws(boolean bl) {
        this.setUnderBuildingLaws((Boolean)bl);
    }

    public void setUnderBuildingLaws(Boolean bl) {
        this.set(172, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setUnderRoof(boolean bl) {
        this.setUnderRoof((Boolean)bl);
    }

    public void setUnderRoof(Boolean bl) {
        this.set(173, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setUrl(String string) {
        this.set(67, IdxFormat.printString(string, 200));
    }

    public void setVersion(String string) {
        this.set(0, IdxFormat.printString(string, 50));
    }

    public void setView(boolean bl) {
        this.setView((Boolean)bl);
    }

    public void setView(Boolean bl) {
        this.set(32, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    @Deprecated
    public void setVisitEmail(String string) {
        this.set(83, IdxFormat.printString(string, 200));
    }

    public void setVisitName(String string) {
        this.set(81, IdxFormat.printString(string, 200));
    }

    public void setVisitPhone(String string) {
        this.set(82, IdxFormat.printString(string, 200));
    }

    public void setVisitRemark(String string) {
        this.set(84, IdxFormat.printString(string, 200));
    }

    public void setVolume(Number number) {
        this.set(30, IdxFormat.printNumber(number, 10));
    }

    public void setWaterSupply(boolean bl) {
        this.setWaterSupply((Boolean)bl);
    }

    public void setWaterSupply(Boolean bl) {
        this.set(121, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    @Deprecated
    public void setWheelcharAccessible(Boolean bl) {
        this.setWheelchairAccessible(bl);
    }

    @Deprecated
    public void setWheelcharAccessible(boolean bl) {
        this.setWheelchairAccessible(bl);
    }

    public void setWheelchairAccessible(boolean bl) {
        this.setWheelchairAccessible((Boolean)bl);
    }

    public void setWheelchairAccessible(Boolean bl) {
        this.set(115, IdxFormat.printBoolean(bl != null ? bl : false));
    }

    public void setYearBuilt(Number number) {
        this.set(31, IdxFormat.printNumber(number, 4));
    }

    public void setYearRenovated(Number number) {
        this.set(163, IdxFormat.printNumber(number, 4));
    }
}

