/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SearchAttribImpl;
import com.openindex.openestate.impl.SearchDateTimeImpl;
import com.openindex.openestate.impl.SearchEqualsImpl;
import com.openindex.openestate.impl.SearchImpl;
import com.openindex.openestate.impl.SearchMatchesImpl;
import com.openindex.openestate.impl.SearchNumericImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.DbSearchesHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.LengthValue;
import com.openindex.openestate.impl.values.VolumeValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbSearchesHandler
extends DbSearchesHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbSearchesHandler.class);
    public static final String PROC_REMOVE_SEARCHES = "remove_openestate_searches";
    public static final String PROC_REMOVE_SEARCHES_ATTRIBS = "remove_openestate_searches_attribs";
    public static final String PROC_REMOVE_SEARCHES_PARAMS = "remove_openestate_searches_params";
    public static final String PROC_REMOVE_SEARCHES_VALUES = "remove_openestate_searches_values";
    public static final String PROC_SAVE_SEARCHES = "save_openestate_searches";
    public static final String PROC_SAVE_SEARCHES_ATTRIBS = "save_openestate_searches_attribs";
    public static final String PROC_SAVE_SEARCHES_PARAMS = "save_openestate_searches_params";
    public static final String PROC_SAVE_SEARCHES_VALUES = "save_openestate_searches_values";
    public static final String PROC_SET_SEARCHES_ENABLED = "set_openestate_searches_enabled";
    public static final String VIEW_SEARCHES = "view_openestate_searches";
    public static final String VIEW_SEARCHES_ATTRIBS = "view_openestate_searches_attribs";
    public static final String VIEW_SEARCHES_PARAMS = "view_openestate_searches_params";
    public static final String VIEW_SEARCHES_VALUES = "view_openestate_searches_values";
    public static final String FIELD_SEARCH_ID = "search_id";
    public static final String FIELD_SEARCH_NAME = "search_name";
    public static final String FIELD_SEARCH_NOTES = "search_notes";
    public static final String FIELD_SEARCH_ENABLED = "search_enabled";
    public static final String FIELD_ATTRIB_NAME = "attrib_name";
    public static final String FIELD_ATTRIB_EQUALS = "attrib_equals";
    public static final String FIELD_ATTRIB_EQUALS_LIKE = "attrib_equals_like";
    public static final String FIELD_ATTRIB_EQUALS_CASE = "attrib_equals_case";
    public static final String FIELD_ATTRIB_MATCHES = "attrib_matches";
    public static final String FIELD_ATTRIB_NUMERIC_MIN = "attrib_numeric_min";
    public static final String FIELD_ATTRIB_NUMERIC_MAX = "attrib_numeric_max";
    public static final String FIELD_ATTRIB_NUMERIC_UNIT = "attrib_numeric_unit";
    public static final String FIELD_ATTRIB_TIME_BEGIN = "attrib_time_begin";
    public static final String FIELD_ATTRIB_TIME_END = "attrib_time_end";
    public static final String FIELD_ATTRIB_ORDER = "attrib_order";
    public static final String FIELD_PARAM_KEY = "param_key";
    public static final String FIELD_PARAM_VALUE = "param_value";
    public static final String FIELD_VALUE_TYPE = "value_type";
    public static final String FIELD_VALUE_EQUALS = "value_equals";
    public static final String FIELD_VALUE_EQUALS_LIKE = "value_equals_like";
    public static final String FIELD_VALUE_EQUALS_CASE = "value_equals_case";
    public static final String FIELD_VALUE_ORDER = "value_order";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    public HSqlDbSearchesHandler() {
    }

    public HSqlDbSearchesHandler(String string) {
        super(string);
    }

    protected SearchAttribImpl buildAttribCondition(ResultSet resultSet) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        SearchAttribImpl searchAttribImpl;
        OpenEstateAttrib openEstateAttrib;
        String string;
        long l;
        block28: {
            l = resultSet.getLong(FIELD_SEARCH_ID);
            string = resultSet.getString(FIELD_ATTRIB_NAME);
            openEstateAttrib = null;
            try {
                openEstateAttrib = OpenEstateAttrib.valueOf((String)string);
            }
            catch (Exception exception) {
                searchAttribImpl = StringUtils.split((String)string, (String)"_", (int)2);
                if (ArrayUtils.getLength((Object)searchAttribImpl) == 2) {
                    openEstateAttrib = OpenEstateUtils.lookupAttrib((String)searchAttribImpl[0], (String)searchAttribImpl[1]);
                }
                if (openEstateAttrib != null) break block28;
                LOGGER.warn("Unsupported attribute \"" + string + "\" in search #" + l + "!");
                return null;
            }
        }
        AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
        if (abstractAttribImpl == null) {
            LOGGER.warn("Unsupported attribute \"" + string + "\" in search #" + l + "!");
            return null;
        }
        searchAttribImpl = this.createAttribCondition();
        searchAttribImpl.setAttribute(openEstateAttrib);
        searchAttribImpl.setOrder(resultSet.getLong(FIELD_ATTRIB_ORDER));
        String string2 = resultSet.getString(FIELD_ATTRIB_EQUALS);
        if (string2 != null) {
            object4 = new SearchEqualsImpl();
            object4.setCaseSensitive(resultSet.getBoolean(FIELD_ATTRIB_EQUALS_CASE));
            object4.setLike(resultSet.getBoolean(FIELD_ATTRIB_EQUALS_LIKE));
            object4.setValue(string2);
            searchAttribImpl.setEqualsCondition(object4);
        }
        if ((object4 = resultSet.getString(FIELD_ATTRIB_MATCHES)) != null) {
            object3 = new SearchMatchesImpl();
            object3.setRegularExpression((String)object4);
            searchAttribImpl.setMatchesCondition(object3);
        }
        object3 = resultSet.getBigDecimal(FIELD_ATTRIB_NUMERIC_MAX);
        BigDecimal bigDecimal = resultSet.getBigDecimal(FIELD_ATTRIB_NUMERIC_MIN);
        if (object3 != null || bigDecimal != null) {
            block29: {
                object2 = new SearchNumericImpl();
                object2.setMax((BigDecimal)object3);
                object2.setMin(bigDecimal);
                object = resultSet.getString(FIELD_ATTRIB_NUMERIC_UNIT);
                if (abstractAttribImpl instanceof ComplexAreaAttrib) {
                    try {
                        if (object != null) {
                            object2.setAreaUnit(AreaValue.Unit.valueOf((String)object));
                            break block29;
                        }
                        object2.setAreaUnit(AreaValue.Unit.getBaseUnit());
                    }
                    catch (Exception exception) {
                        object2.setAreaUnit(AreaValue.Unit.getBaseUnit());
                        LOGGER.warn("Can't read area unit: " + (String)object + "!");
                        LOGGER.warn("> fallback to: " + AreaValue.Unit.getBaseUnit().name());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                } else if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
                    try {
                        if (object != null) {
                            object2.setCurrencyUnit(Currency.getInstance((String)object));
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't read currency unit: " + (String)object + "!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                } else if (abstractAttribImpl instanceof ComplexLengthAttrib) {
                    try {
                        if (object != null) {
                            object2.setLengthUnit(LengthValue.Unit.valueOf((String)object));
                            break block29;
                        }
                        object2.setLengthUnit(LengthValue.Unit.getBaseUnit());
                    }
                    catch (Exception exception) {
                        object2.setLengthUnit(LengthValue.Unit.getBaseUnit());
                        LOGGER.warn("Can't read length unit: " + (String)object + "!");
                        LOGGER.warn("> fallback to: " + LengthValue.Unit.getBaseUnit().name());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                } else if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
                    try {
                        if (object != null) {
                            object2.setVolumeUnit(VolumeValue.Unit.valueOf((String)object));
                        } else {
                            object2.setVolumeUnit(VolumeValue.Unit.getBaseUnit());
                        }
                    }
                    catch (Exception exception) {
                        object2.setVolumeUnit(VolumeValue.Unit.getBaseUnit());
                        LOGGER.warn("Can't read volume unit: " + (String)object + "!");
                        LOGGER.warn("> fallback to: " + VolumeValue.Unit.getBaseUnit().name());
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    }
                }
            }
            searchAttribImpl.setNumericCondition(object2);
        }
        object2 = resultSet.getDate(FIELD_ATTRIB_TIME_BEGIN);
        object = resultSet.getDate(FIELD_ATTRIB_TIME_END);
        if (object2 != null || object != null) {
            SearchDateTimeImpl searchDateTimeImpl = new SearchDateTimeImpl();
            searchDateTimeImpl.setBegin((Date)object2);
            searchDateTimeImpl.setEnd((Date)object);
            searchAttribImpl.setDateTimeCondition(searchDateTimeImpl);
        }
        return searchAttribImpl;
    }

    protected DbSearch buildSearch(ResultSet resultSet) throws SQLException {
        DbSearch dbSearch = this.createSearch();
        dbSearch.id = resultSet.getLong(FIELD_SEARCH_ID);
        dbSearch.item = new SearchImpl();
        dbSearch.item.setEnabled(resultSet.getBoolean(FIELD_SEARCH_ENABLED));
        dbSearch.item.setName(resultSet.getString(FIELD_SEARCH_NAME));
        dbSearch.item.setNotes(resultSet.getString(FIELD_SEARCH_NOTES));
        dbSearch.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbSearch.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbSearch;
    }

    protected SearchEqualsImpl buildValueCondition(ResultSet resultSet) throws SQLException {
        SearchEqualsImpl searchEqualsImpl = this.createValueCondition();
        searchEqualsImpl.setValue(resultSet.getString(FIELD_VALUE_EQUALS));
        searchEqualsImpl.setCaseSensitive(resultSet.getBoolean(FIELD_VALUE_EQUALS_CASE));
        searchEqualsImpl.setLike(resultSet.getBoolean(FIELD_VALUE_EQUALS_LIKE));
        searchEqualsImpl.setOrder(resultSet.getLong(FIELD_VALUE_ORDER));
        return searchEqualsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbSearch[] getSearches(Connection connection, Boolean bl) throws SQLException {
        DbSearch[] dbSearchArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES) + " ORDER BY " + FIELD_SEARCH_NAME + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES) + " WHERE " + FIELD_SEARCH_ENABLED + " = ? ORDER BY " + FIELD_SEARCH_NAME + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbSearch> arrayList = new ArrayList<DbSearch>();
            while (resultSet.next()) {
                arrayList.add(this.buildSearch(resultSet));
            }
            dbSearchArray = arrayList.toArray(new DbSearch[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbSearchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbSearch[] getSearches(Connection connection, long[] lArray) throws SQLException {
        DbSearch[] dbSearchArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbSearch[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES) + " ORDER BY " + FIELD_SEARCH_NAME + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES) + " WHERE " + FIELD_SEARCH_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_SEARCH_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbSearch> arrayList = new ArrayList<DbSearch>();
            while (resultSet.next()) {
                arrayList.add(this.buildSearch(resultSet));
            }
            dbSearchArray = arrayList.toArray(new DbSearch[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbSearchArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getSearchIds(Connection connection, Boolean bl) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (bl == null) {
                preparedStatement = connection.prepareStatement("SELECT search_id FROM " + this.getSchemaPath(VIEW_SEARCHES) + " ORDER BY " + FIELD_SEARCH_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT search_id FROM " + this.getSchemaPath(VIEW_SEARCHES) + " WHERE " + FIELD_SEARCH_ENABLED + " = ? ORDER BY " + FIELD_SEARCH_ID + " ASC;");
                preparedStatement.setBoolean(1, bl);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong(FIELD_SEARCH_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadAttribConditions(Connection connection, DbSearch[] dbSearchArray) throws SQLException {
        HashMap<Long, DbSearch> hashMap = new HashMap<Long, DbSearch>();
        for (DbSearch dbSearch : dbSearchArray) {
            if (dbSearch.item == null || dbSearch.id <= 0L || hashMap.containsKey(dbSearch.id)) continue;
            dbSearch.item.getAttribConditions().clear();
            hashMap.put(dbSearch.id, dbSearch);
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES_ATTRIBS) + " WHERE " + FIELD_SEARCH_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_SEARCH_ID + " ASC, " + FIELD_ATTRIB_ORDER + " ASC, " + FIELD_ATTRIB_NAME + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong(FIELD_SEARCH_ID);
                if (!hashMap.containsKey(l2) || (l = this.buildAttribCondition(resultSet)) == null) continue;
                ((DbSearch)hashMap.get((Object)l2)).item.getAttribConditions().add(l);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadParameters(Connection connection, DbSearch[] dbSearchArray) throws SQLException {
        HashMap<Long, DbSearch> hashMap = new HashMap<Long, DbSearch>();
        for (DbSearch dbSearch : dbSearchArray) {
            if (dbSearch.item == null || dbSearch.id <= 0L || hashMap.containsKey(dbSearch.id)) continue;
            dbSearch.item.getParams().clear();
            hashMap.put(dbSearch.id, dbSearch);
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES_PARAMS) + " WHERE " + FIELD_SEARCH_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_SEARCH_ID + " ASC, " + FIELD_PARAM_KEY + " ASC;");
            int n2 = 0;
            for (Object object : hashMap.keySet()) {
                preparedStatement.setLong(++n2, (Long)object);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Object object;
                Long l = resultSet.getLong(FIELD_SEARCH_ID);
                if (!hashMap.containsKey(l)) continue;
                object = resultSet.getString(FIELD_PARAM_KEY);
                String string = resultSet.getString(FIELD_PARAM_VALUE);
                if (object == null || string == null) continue;
                ((DbSearch)hashMap.get((Object)l)).item.getParams().put(object, string);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public void loadValueConditions(Connection connection, DbSearch[] dbSearchArray) throws SQLException {
        HashMap<Long, DbSearch> hashMap = new HashMap<Long, DbSearch>();
        for (DbSearch dbSearch : dbSearchArray) {
            if (dbSearch.item == null || dbSearch.id <= 0L || hashMap.containsKey(dbSearch.id)) continue;
            for (SearchImpl.SimpleConditionType simpleConditionType2 : SearchImpl.SimpleConditionType.values()) {
                dbSearch.item.getSimpleConditions(simpleConditionType2).clear();
            }
            hashMap.put(dbSearch.id, dbSearch);
        }
        int n = hashMap.size();
        if (n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_SEARCHES_VALUES) + " WHERE " + FIELD_SEARCH_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_SEARCH_ID + " ASC, " + FIELD_VALUE_ORDER + "  ASC, " + FIELD_VALUE_TYPE + " ASC;");
            int n2 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n2, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SearchImpl.SimpleConditionType simpleConditionType;
                SearchImpl.SimpleConditionType simpleConditionType2;
                Long l = resultSet.getLong(FIELD_SEARCH_ID);
                if (!hashMap.containsKey(l)) continue;
                String string = resultSet.getString(FIELD_VALUE_TYPE);
                try {
                    simpleConditionType = SearchImpl.SimpleConditionType.valueOf((String)string);
                }
                catch (Exception exception) {
                    LOGGER.warn("Can't read type of condition: " + string);
                    LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                simpleConditionType2 = this.buildValueCondition(resultSet);
                ((DbSearch)hashMap.get((Object)l)).item.getSimpleConditions(simpleConditionType).add(simpleConditionType2);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    public void removeSearches(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_SEARCHES) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveSearch(Connection connection, DbSearch dbSearch, boolean bl, boolean bl2) throws SQLException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl3;
        block25: {
            bl3 = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                NamedCallableStatement namedCallableStatement2;
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_SEARCHES) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_SEARCH_NAME + ", :" + FIELD_SEARCH_NOTES + ", :" + FIELD_SEARCH_ENABLED + ");");
                namedCallableStatement.setLong(FIELD_SEARCH_ID, dbSearch.id);
                namedCallableStatement.setBoolean(FIELD_SEARCH_ENABLED, dbSearch.item.isEnabled());
                namedCallableStatement.setString(FIELD_SEARCH_NOTES, dbSearch.item.getNotes());
                namedCallableStatement.setString(FIELD_SEARCH_NAME, StringUtils.abbreviate((String)dbSearch.item.getName(), (int)255));
                namedCallableStatement.execute();
                long l2 = l = dbSearch.id < 1L ? namedCallableStatement.getLong(FIELD_SEARCH_ID) : dbSearch.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveSearchAdditionally(connection, dbSearch, l, arrayList);
                if (bl) {
                    if (dbSearch.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_SEARCHES_PARAMS) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_PARAM_KEY + ");");
                        namedCallableStatement2.setLong(FIELD_SEARCH_ID, dbSearch.id);
                        namedCallableStatement2.setString(FIELD_PARAM_KEY, null);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_SEARCHES_PARAMS) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_PARAM_KEY + ", :" + FIELD_PARAM_VALUE + ");");
                    for (Object object : dbSearch.item.getParams().keySet()) {
                        String string = (String)dbSearch.item.getParams().get(object);
                        if (string == null) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_SEARCH_ID, l);
                        namedCallableStatement2.setString(FIELD_PARAM_KEY, StringUtils.abbreviate((String)object, (int)255));
                        namedCallableStatement2.setString(FIELD_PARAM_VALUE, StringUtils.abbreviate((String)string, (int)255));
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                if (bl2) {
                    NamedCallableStatement namedCallableStatement3;
                    if (dbSearch.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_SEARCHES_VALUES) + "(:" + FIELD_SEARCH_ID + ");");
                        namedCallableStatement2.setLong(FIELD_SEARCH_ID, dbSearch.id);
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                        namedCallableStatement3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_SEARCHES_ATTRIBS) + "(:" + FIELD_SEARCH_ID + ");");
                        namedCallableStatement3.setLong(FIELD_SEARCH_ID, dbSearch.id);
                        namedCallableStatement3.execute();
                        arrayList.add(namedCallableStatement3.getStatement());
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_SEARCHES_VALUES) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_VALUE_TYPE + ", :" + FIELD_VALUE_EQUALS + ", :" + FIELD_VALUE_EQUALS_LIKE + ", :" + FIELD_VALUE_EQUALS_CASE + ", :" + FIELD_VALUE_ORDER + ");");
                    for (SearchImpl.SimpleConditionType simpleConditionType : SearchImpl.SimpleConditionType.values()) {
                        for (SearchEqualsImpl searchEqualsImpl : dbSearch.item.getSimpleConditions(simpleConditionType)) {
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_SEARCH_ID, l);
                            namedCallableStatement2.setLong(FIELD_VALUE_ORDER, searchEqualsImpl.getOrder());
                            namedCallableStatement2.setBoolean(FIELD_VALUE_EQUALS_LIKE, searchEqualsImpl.isLike());
                            namedCallableStatement2.setBoolean(FIELD_VALUE_EQUALS_CASE, searchEqualsImpl.isCaseSensitive());
                            namedCallableStatement2.setString(FIELD_VALUE_TYPE, StringUtils.abbreviate((String)simpleConditionType.name(), (int)100));
                            namedCallableStatement2.setString(FIELD_VALUE_EQUALS, StringUtils.abbreviate((String)searchEqualsImpl.getValue(), (int)255));
                            namedCallableStatement2.execute();
                            arrayList.add(namedCallableStatement2.getStatement());
                        }
                    }
                    namedCallableStatement3 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_SEARCHES_ATTRIBS) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_ATTRIB_NAME + ", :" + FIELD_ATTRIB_EQUALS + ", :" + FIELD_ATTRIB_EQUALS_LIKE + ", :" + FIELD_ATTRIB_EQUALS_CASE + ", :" + FIELD_ATTRIB_MATCHES + ", :" + FIELD_ATTRIB_NUMERIC_MIN + ", :" + FIELD_ATTRIB_NUMERIC_MAX + ", :" + FIELD_ATTRIB_NUMERIC_UNIT + ", :" + FIELD_ATTRIB_TIME_BEGIN + ", :" + FIELD_ATTRIB_TIME_END + ", :" + FIELD_ATTRIB_ORDER + ");");
                    for (SearchAttribImpl searchAttribImpl : dbSearch.item.getAttribConditions()) {
                        Object object;
                        SearchEqualsImpl searchEqualsImpl;
                        SearchImpl.SimpleConditionType simpleConditionType;
                        simpleConditionType = searchAttribImpl.getEqualsCondition();
                        SearchMatchesImpl searchMatchesImpl = searchAttribImpl.getMatchesCondition();
                        searchEqualsImpl = searchAttribImpl.getNumericCondition();
                        SearchDateTimeImpl searchDateTimeImpl = searchAttribImpl.getDateTimeCondition();
                        namedCallableStatement3.clearParameters();
                        namedCallableStatement3.setLong(FIELD_SEARCH_ID, l);
                        namedCallableStatement3.setLong(FIELD_ATTRIB_ORDER, searchAttribImpl.getOrder());
                        namedCallableStatement3.setBoolean(FIELD_ATTRIB_EQUALS_LIKE, simpleConditionType != null && simpleConditionType.isLike());
                        namedCallableStatement3.setBoolean(FIELD_ATTRIB_EQUALS_CASE, simpleConditionType != null && simpleConditionType.isCaseSensitive());
                        namedCallableStatement3.setString(FIELD_ATTRIB_NAME, StringUtils.abbreviate((String)searchAttribImpl.getAttribute().name(), (int)255));
                        namedCallableStatement3.setString(FIELD_ATTRIB_EQUALS, simpleConditionType != null ? StringUtils.abbreviate((String)simpleConditionType.getValue(), (int)255) : null);
                        namedCallableStatement3.setString(FIELD_ATTRIB_MATCHES, searchMatchesImpl != null ? StringUtils.abbreviate((String)searchMatchesImpl.getRegularExpression(), (int)255) : null);
                        namedCallableStatement3.setBigDecimal(FIELD_ATTRIB_NUMERIC_MIN, searchEqualsImpl != null ? searchEqualsImpl.getMin() : null);
                        namedCallableStatement3.setBigDecimal(FIELD_ATTRIB_NUMERIC_MAX, searchEqualsImpl != null ? searchEqualsImpl.getMax() : null);
                        namedCallableStatement3.setTimestamp(FIELD_ATTRIB_TIME_BEGIN, searchDateTimeImpl != null && searchDateTimeImpl.getBegin() != null ? new Timestamp(searchDateTimeImpl.getBegin().getTime()) : null);
                        namedCallableStatement3.setTimestamp(FIELD_ATTRIB_TIME_END, searchDateTimeImpl != null && searchDateTimeImpl.getEnd() != null ? new Timestamp(searchDateTimeImpl.getEnd().getTime()) : null);
                        if (searchEqualsImpl == null) {
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, null);
                        } else if (ComplexAreaAttrib.class.isInstance(searchAttribImpl.getAttribute())) {
                            object = searchEqualsImpl.getAreaUnit();
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, object != null ? StringUtils.abbreviate((String)object.name(), (int)20) : null);
                        } else if (ComplexCurrencyAttrib.class.isInstance(searchAttribImpl.getAttribute())) {
                            object = searchEqualsImpl.getCurrencyUnit();
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, object != null ? StringUtils.abbreviate((String)((Currency)object).getCurrencyCode(), (int)20) : null);
                        } else if (ComplexLengthAttrib.class.isInstance(searchAttribImpl.getAttribute())) {
                            object = searchEqualsImpl.getLengthUnit();
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, object != null ? StringUtils.abbreviate((String)object.name(), (int)20) : null);
                        } else if (ComplexVolumeAttrib.class.isInstance(searchAttribImpl.getAttribute())) {
                            object = searchEqualsImpl.getVolumeUnit();
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, object != null ? StringUtils.abbreviate((String)object.name(), (int)20) : null);
                        } else {
                            namedCallableStatement3.setString(FIELD_ATTRIB_NUMERIC_UNIT, null);
                        }
                        namedCallableStatement3.execute();
                        arrayList.add(namedCallableStatement3.getStatement());
                    }
                }
                connection.commit();
                if (dbSearch.id >= 1L) break block25;
                dbSearch.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl3);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl3);
    }

    protected void saveSearchAdditionally(Connection connection, DbSearch dbSearch, long l, List<Statement> list) throws SQLException {
    }

    public void setSearchesEnabled(Connection connection, long[] lArray, boolean bl) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SET_SEARCHES_ENABLED) + "(:" + FIELD_SEARCH_ID + ", :" + FIELD_SEARCH_ENABLED + ");");
            for (long l : lArray) {
                namedCallableStatement.clearParameters();
                namedCallableStatement.setLong(FIELD_SEARCH_ID, l);
                namedCallableStatement.setBoolean(FIELD_SEARCH_ENABLED, bl);
                namedCallableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }
}

