/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.immoxml;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.AccessBeginDate;
import com.openindex.openestate.impl.attribs.administration.ApartmentNr;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.ChargeBeginDate;
import com.openindex.openestate.impl.attribs.administration.ChargeEndDate;
import com.openindex.openestate.impl.attribs.administration.ChargeTimeUnit;
import com.openindex.openestate.impl.attribs.administration.CommercialIndustries;
import com.openindex.openestate.impl.attribs.administration.CommercialUse;
import com.openindex.openestate.impl.attribs.administration.CommunalCode;
import com.openindex.openestate.impl.attribs.administration.CommunalDistrict;
import com.openindex.openestate.impl.attribs.administration.EffectiveDate;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LocationInBuilding;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Parcel;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.RegionalNotes;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.RoomsModifiable;
import com.openindex.openestate.impl.attribs.administration.Skyscraper;
import com.openindex.openestate.impl.attribs.administration.SubPlot;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ContaminatedSites;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.descriptions.AdditionalInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.descriptions.PriceDescription;
import com.openindex.openestate.impl.attribs.descriptions.ShortDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.ExpirationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.Applicability;
import com.openindex.openestate.impl.attribs.features.AttachedGastronomy;
import com.openindex.openestate.impl.attribs.features.BalconyTerraceDirection;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.BreweryObligation;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.ChimneyPort;
import com.openindex.openestate.impl.attribs.features.CommercialRooms;
import com.openindex.openestate.impl.attribs.features.CommercialServices;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.Sauna;
import com.openindex.openestate.impl.attribs.features.SecurityTechnology;
import com.openindex.openestate.impl.attribs.features.SportsFacilities;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TelephoneAvailable;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.UndergroundLevel;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.features.WellnessArea;
import com.openindex.openestate.impl.attribs.measures.AdministrationArea;
import com.openindex.openestate.impl.attribs.measures.AtticArea;
import com.openindex.openestate.impl.attribs.measures.BalconyArea;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.BasementArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBalconies;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountCommercialUnits;
import com.openindex.openestate.impl.attribs.measures.CountConferenceRooms;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountLivingAndBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountResidentialUnits;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.CountSeparateToilets;
import com.openindex.openestate.impl.attribs.measures.CubicIndex;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowArea;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.GardenArea;
import com.openindex.openestate.impl.attribs.measures.GrossFloorArea;
import com.openindex.openestate.impl.attribs.measures.GuestTerrace;
import com.openindex.openestate.impl.attribs.measures.HeatableArea;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.OfficeAreaPart;
import com.openindex.openestate.impl.attribs.measures.OpenSpace;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.PlotForesideLength;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.RetailArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.prices.AdditionalRentalCharges;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.AgentFeeIncludingVat;
import com.openindex.openestate.impl.attribs.prices.BasicRent;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.DevelopmentCosts;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.NetReturn;
import com.openindex.openestate.impl.attribs.prices.PlusVat;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.SharedCapital;
import com.openindex.openestate.impl.attribs.prices.TakeoverCosts;
import com.openindex.openestate.impl.attribs.prices.VatRate;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBeach;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToCityCentre;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToComprehensiveSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToDayNursery;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToElementarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToJuniorHighSchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToLake;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextGastronomy;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextShopping;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToRecreationalArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSecondarySchool;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSkiingArea;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToSportsFacilities;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToWanderingArea;
import com.openindex.openestate.impl.attribs.surroundings.SupplyPossible;
import com.openindex.openestate.impl.attribs.surroundings.View;
import com.openindex.openestate.impl.attribs.surroundings.Zone;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.AbstractXmlReader;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.immoxml.ImmoXmlDocument;
import org.openestate.io.immoxml.ImmoXmlUtils;
import org.openestate.io.immoxml.xml.Aktion;
import org.openestate.io.immoxml.xml.Alter;
import org.openestate.io.immoxml.xml.Anbieter;
import org.openestate.io.immoxml.xml.Anhaenge;
import org.openestate.io.immoxml.xml.Anhang;
import org.openestate.io.immoxml.xml.Ausblick;
import org.openestate.io.immoxml.xml.Ausstattung;
import org.openestate.io.immoxml.xml.BebaubarNach;
import org.openestate.io.immoxml.xml.BueroPraxen;
import org.openestate.io.immoxml.xml.Distanzen;
import org.openestate.io.immoxml.xml.DistanzenSport;
import org.openestate.io.immoxml.xml.Einzelhandel;
import org.openestate.io.immoxml.xml.EmailSonstige;
import org.openestate.io.immoxml.xml.Erschliessung;
import org.openestate.io.immoxml.xml.Flaechen;
import org.openestate.io.immoxml.xml.Freitexte;
import org.openestate.io.immoxml.xml.FreizeitimmobilieGewerblich;
import org.openestate.io.immoxml.xml.Gastgewerbe;
import org.openestate.io.immoxml.xml.Geo;
import org.openestate.io.immoxml.xml.Geschlecht;
import org.openestate.io.immoxml.xml.Grundstueck;
import org.openestate.io.immoxml.xml.HallenLagerProd;
import org.openestate.io.immoxml.xml.Haus;
import org.openestate.io.immoxml.xml.Immobilie;
import org.openestate.io.immoxml.xml.Immoxml;
import org.openestate.io.immoxml.xml.Infrastruktur;
import org.openestate.io.immoxml.xml.Kontaktperson;
import org.openestate.io.immoxml.xml.LageGebiet;
import org.openestate.io.immoxml.xml.LandUndForstwirtschaft;
import org.openestate.io.immoxml.xml.MaxMietdauer;
import org.openestate.io.immoxml.xml.Nutzungsart;
import org.openestate.io.immoxml.xml.Objektkategorie;
import org.openestate.io.immoxml.xml.PreisZeiteinheit;
import org.openestate.io.immoxml.xml.Preise;
import org.openestate.io.immoxml.xml.Serviceleistungen;
import org.openestate.io.immoxml.xml.Sonstige;
import org.openestate.io.immoxml.xml.Stellplatzart;
import org.openestate.io.immoxml.xml.StpSonstige;
import org.openestate.io.immoxml.xml.TelSonstige;
import org.openestate.io.immoxml.xml.Uebertragung;
import org.openestate.io.immoxml.xml.Unterkellert;
import org.openestate.io.immoxml.xml.UserDefinedSimplefield;
import org.openestate.io.immoxml.xml.VerwaltungObjekt;
import org.openestate.io.immoxml.xml.VerwaltungTechn;
import org.openestate.io.immoxml.xml.WeitereAdresse;
import org.openestate.io.immoxml.xml.Wohnung;
import org.openestate.io.immoxml.xml.Zimmer;
import org.openestate.io.immoxml.xml.ZinshausRenditeobjekt;
import org.openestate.io.immoxml.xml.Zustand;
import org.openestate.io.immoxml.xml.ZustandAngaben;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ImmoXmlReader
extends AbstractXmlReader<ImmoXmlDocument, Immoxml> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmoXmlReader.class);

    public ImmoXmlReader() {
    }

    public ImmoXmlReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Anbieter anbieter) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.setId(anbieter.getAnbieternr());
        agentImpl.getCompany().setCompanyName(anbieter.getFirma());
        agentImpl.setTerms(anbieter.getImpressum(), this.getOpenEstateLanguage());
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(Immobilie immobilie, Map<String, AgentContactImpl> map) {
        try {
            EstateImpl estateImpl = this.createEmptyEstate();
            String string = this.getEstateId(immobilie);
            if (string == null) {
                LOGGER.warn("Can't detect an object ID from <verwaltung_techn>!");
            }
            this.readImmobilieObjektkategorie(immobilie, estateImpl, string);
            ArrayList<OpenEstateType> arrayList = new ArrayList<OpenEstateType>();
            OpenEstateType openEstateType = estateImpl.getType();
            if (openEstateType != null) {
                arrayList.addAll(Arrays.asList(openEstateType.getParentPath()));
            }
            this.readImmobilieGeo(immobilie.getGeo(), estateImpl, arrayList, string);
            this.readImmobilieKontaktperson(immobilie.getKontaktperson(), estateImpl, arrayList, map, string);
            this.readImmobilieWeitereAdressen(immobilie.getWeitereAdresse(), estateImpl, arrayList, string);
            this.readImmobiliePreise(immobilie.getPreise(), immobilie.getAusstattung(), estateImpl, arrayList, string);
            this.readImmobilieFlaechen(immobilie.getFlaechen(), estateImpl, arrayList, string);
            this.readImmobilieAusstattung(immobilie.getAusstattung(), estateImpl, arrayList, string);
            this.readImmobilieZustandAngaben(immobilie.getZustandAngaben(), estateImpl, arrayList, string);
            this.readImmobilieInfrastruktur(immobilie.getInfrastruktur(), estateImpl, arrayList, string);
            this.readImmobilieFreitexte(immobilie.getFreitexte(), estateImpl, arrayList, string);
            this.readImmobilieAnhaenge(immobilie.getAnhaenge(), estateImpl, arrayList, string);
            this.readImmobilieVerwaltungObjekt(immobilie.getVerwaltungObjekt(), estateImpl, arrayList, string);
            this.readImmobilieVerwaltungTechn(immobilie.getVerwaltungTechn(), estateImpl, arrayList, string);
            return estateImpl;
        }
        catch (Exception exception) {
            LOGGER.error("Can't convert estate!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    protected AgencyImpl convertToAgency(Immoxml immoxml) {
        if (immoxml.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        AgencyImpl agencyImpl = this.createEmptyAgency();
        Anbieter anbieter = (Anbieter)immoxml.getAnbieter().get(0);
        AgentImpl agentImpl = this.convertAnbieter(anbieter);
        agentImpl.setId("Agent.1");
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (Immobilie object : anbieter.getImmobilie()) {
            EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
            if (estateImpl == null) continue;
            String string = estateImpl.getId();
            if (string == null) {
                string = "Estate." + (agencyImpl.getEstates().size() + 1);
            }
            agencyImpl.getEstates().put(string, estateImpl);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        return agencyImpl;
    }

    protected TransferImpl convertToTransfer(Immoxml immoxml) {
        if (immoxml.getAnbieter().isEmpty()) {
            throw new IllegalArgumentException("anbieter is missing!");
        }
        Uebertragung uebertragung = immoxml.getUebertragung();
        TransferImpl transferImpl = this.createEmptyTransfer();
        transferImpl.setSenderSoftwareMail(uebertragung != null ? StringUtils.trimToNull((String)uebertragung.getTechnEmail()) : null);
        transferImpl.setSenderSoftwareName(uebertragung != null ? StringUtils.trimToNull((String)uebertragung.getSendersoftware()) : null);
        for (Anbieter anbieter : immoxml.getAnbieter()) {
            TransferAgencyImpl transferAgencyImpl = this.createEmptyTransferAgency();
            transferAgencyImpl.setRemoveUnmodifiedEstates(uebertragung != null && Uebertragung.Umfang.VOLL.equals((Object)uebertragung.getUmfang()));
            AgentImpl agentImpl = this.convertAnbieter(anbieter);
            agentImpl.setId("Agent." + (transferImpl.getAgencies().size() + 1));
            transferAgencyImpl.setAgent(agentImpl);
            HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
            for (Immobilie immobilie : anbieter.getImmobilie()) {
                EstateImpl estateImpl;
                if (immobilie.getVerwaltungTechn() != null) {
                    boolean bl;
                    boolean bl2 = bl = immobilie.getVerwaltungTechn().getAktion() != null && Aktion.AktionArt.DELETE.equals((Object)immobilie.getVerwaltungTechn().getAktion().getAktionart());
                    if (bl) {
                        String string = this.getEstateId(immobilie);
                        if (string == null) {
                            LOGGER.warn("Can't detect an object ID from <verwaltung_techn> for deletion!");
                            continue;
                        }
                        if (transferAgencyImpl.getEstateIdsToRemove().contains(string)) {
                            LOGGER.warn("Object ID '" + string + "' is defined more then once for deletion!");
                            this.putError(string, "Object ID '" + string + "' is defined more then once for deletion!");
                            continue;
                        }
                        transferAgencyImpl.getEstateIdsToRemove().add(string);
                        continue;
                    }
                }
                if ((estateImpl = this.convertImmobilie(immobilie, hashMap)) == null) continue;
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                transferAgencyImpl.getContacts().put(entry.getKey(), entry.getValue());
            }
            transferImpl.getAgencies().add(transferAgencyImpl);
        }
        return transferImpl;
    }

    protected ImmoXmlDocument createXmlDocument(Document document) {
        return ImmoXmlUtils.createDocument((Document)document);
    }

    protected final String getEstateId(Immobilie immobilie) {
        return immobilie != null ? this.getEstateId(immobilie.getVerwaltungTechn()) : null;
    }

    protected String getEstateId(VerwaltungTechn verwaltungTechn) {
        if (verwaltungTechn == null) {
            return null;
        }
        String string = StringUtils.trimToNull((String)verwaltungTechn.getObjektnrIntern());
        if (string == null) {
            string = StringUtils.trimToNull((String)verwaltungTechn.getImmoxmlObid());
        }
        if (string == null) {
            string = StringUtils.trimToNull((String)verwaltungTechn.getObjektnrExtern());
        }
        return string;
    }

    protected OpenEstateType getEstateType(BueroPraxen.BueroTyp bueroTyp) {
        if (BueroPraxen.BueroTyp.AUSSTELLUNGSFLAECHE.equals((Object)bueroTyp)) {
            return OpenEstateType.EXHIBITION_AREA;
        }
        if (BueroPraxen.BueroTyp.BUEROFLAECHE.equals((Object)bueroTyp)) {
            return OpenEstateType.OFFICE_AREA;
        }
        if (BueroPraxen.BueroTyp.BUEROHAUS.equals((Object)bueroTyp)) {
            return OpenEstateType.OFFICE_BUILDING;
        }
        if (BueroPraxen.BueroTyp.PRAXIS.equals((Object)bueroTyp)) {
            return OpenEstateType.SURGERY;
        }
        return OpenEstateType.OFFICE_SURGERY;
    }

    protected OpenEstateType getEstateType(Einzelhandel.HandelTyp handelTyp) {
        if (Einzelhandel.HandelTyp.EINKAUFSZENTRUM.equals((Object)handelTyp)) {
            return OpenEstateType.SHOPPING_CENTER;
        }
        if (Einzelhandel.HandelTyp.EINZELHANDELSLADEN.equals((Object)handelTyp)) {
            return OpenEstateType.SHOP;
        }
        if (Einzelhandel.HandelTyp.LADENLOKAL.equals((Object)handelTyp)) {
            return OpenEstateType.STORE;
        }
        if (Einzelhandel.HandelTyp.VERBRAUCHERMARKT.equals((Object)handelTyp)) {
            return OpenEstateType.CONSUMER_STORE;
        }
        return OpenEstateType.RETAIL;
    }

    protected OpenEstateType getEstateType(FreizeitimmobilieGewerblich.FreizeitTyp freizeitTyp) {
        if (FreizeitimmobilieGewerblich.FreizeitTyp.SPORTANLAGEN.equals((Object)freizeitTyp)) {
            return OpenEstateType.SPORTS_FACILITY;
        }
        if (FreizeitimmobilieGewerblich.FreizeitTyp.VERGNUEGUNGSPARKS_UND_CENTER.equals((Object)freizeitTyp)) {
            return OpenEstateType.THEME_PARK;
        }
        return OpenEstateType.LEISURE_SPORTS_FACILITY;
    }

    protected OpenEstateType getEstateType(Gastgewerbe.GastgewTyp gastgewTyp) {
        if (Gastgewerbe.GastgewTyp.GASTRONOMIE.equals((Object)gastgewTyp)) {
            return OpenEstateType.GASTRONOMY;
        }
        if (Gastgewerbe.GastgewTyp.GASTRONOMIE_UND_WOHNUNG.equals((Object)gastgewTyp)) {
            return OpenEstateType.GASTRONOMY_WITH_HOUSING;
        }
        if (Gastgewerbe.GastgewTyp.HOTELS.equals((Object)gastgewTyp)) {
            return OpenEstateType.HOTEL;
        }
        if (Gastgewerbe.GastgewTyp.PENSIONEN.equals((Object)gastgewTyp)) {
            return OpenEstateType.GUESTHOUSE;
        }
        return OpenEstateType.HOSPITALITY_INDUSTRY;
    }

    protected OpenEstateType getEstateType(Grundstueck.GrundstTyp grundstTyp) {
        if (Grundstueck.GrundstTyp.FREIZEIT.equals((Object)grundstTyp)) {
            return OpenEstateType.LEISURE_GROUND;
        }
        if (Grundstueck.GrundstTyp.GEMISCHT.equals((Object)grundstTyp)) {
            return OpenEstateType.MIXED_USE_GROUND;
        }
        if (Grundstueck.GrundstTyp.GEWERBE.equals((Object)grundstTyp)) {
            return OpenEstateType.COMMERCIAL_GROUND;
        }
        if (Grundstueck.GrundstTyp.INDUSTRIE.equals((Object)grundstTyp)) {
            return OpenEstateType.INDUSTRIAL_GROUND;
        }
        if (Grundstueck.GrundstTyp.LAND_FORSTWIRSCHAFT.equals((Object)grundstTyp)) {
            return OpenEstateType.AGRICULTURAL_FORESTRY_GROUND;
        }
        if (Grundstueck.GrundstTyp.SONDERNUTZUNG.equals((Object)grundstTyp)) {
            return OpenEstateType.SPECIAL_USE_GROUND;
        }
        if (Grundstueck.GrundstTyp.WOHNEN.equals((Object)grundstTyp)) {
            return OpenEstateType.RESIDENTIAL_GROUND;
        }
        return OpenEstateType.GENERAL_PIECE_OF_LAND;
    }

    protected OpenEstateType getEstateType(HallenLagerProd.HallenTyp hallenTyp) {
        if (HallenLagerProd.HallenTyp.FREIFLAECHEN.equals((Object)hallenTyp)) {
            return OpenEstateType.OPEN_SPACE;
        }
        if (HallenLagerProd.HallenTyp.HALLE.equals((Object)hallenTyp)) {
            return OpenEstateType.HALL_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.HOCHREGALLAGER.equals((Object)hallenTyp)) {
            return OpenEstateType.HIGH_RACK_WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.LAGER.equals((Object)hallenTyp)) {
            return OpenEstateType.WAREHOUSE;
        }
        if (HallenLagerProd.HallenTyp.PRODUKTION.equals((Object)hallenTyp)) {
            return OpenEstateType.PRODUCTION;
        }
        if (HallenLagerProd.HallenTyp.SERVICE.equals((Object)hallenTyp)) {
            return OpenEstateType.SERVICE_AREA;
        }
        if (HallenLagerProd.HallenTyp.WERKSTATT.equals((Object)hallenTyp)) {
            return OpenEstateType.WORKSHOP;
        }
        return OpenEstateType.HALL_WAREHOUSE;
    }

    protected OpenEstateType getEstateType(Haus.Haustyp haustyp) {
        if (Haus.Haustyp.BAUERNHAUS.equals((Object)haustyp)) {
            return OpenEstateType.FARMHOUSE;
        }
        if (Haus.Haustyp.BERGHUETTE.equals((Object)haustyp)) {
            return OpenEstateType.ALPINE_HUT;
        }
        if (Haus.Haustyp.CHALET.equals((Object)haustyp)) {
            return OpenEstateType.CHALET;
        }
        if (Haus.Haustyp.DOPPELHAUSHAELFTE.equals((Object)haustyp)) {
            return OpenEstateType.SEMIDETACHED_HOUSE;
        }
        if (Haus.Haustyp.EINFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.SINGLE_FAMILY_HOUSE;
        }
        if (Haus.Haustyp.FERIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.COTTAGE;
        }
        if (Haus.Haustyp.LANDHAUS.equals((Object)haustyp)) {
            return OpenEstateType.COUNTRY_HOUSE;
        }
        if (Haus.Haustyp.LAUBE_DATSCHE_GARTENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.SUMMER_HOUSE;
        }
        if (Haus.Haustyp.MEHRFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.MULTI_FAMILY_HOUSE;
        }
        if (Haus.Haustyp.REIHENECK.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_CORNERSIDE;
        }
        if (Haus.Haustyp.REIHENEND.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_TAIL;
        }
        if (Haus.Haustyp.REIHENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE;
        }
        if (Haus.Haustyp.REIHENMITTEL.equals((Object)haustyp)) {
            return OpenEstateType.TERRACED_HOUSE_MIDDLE;
        }
        if (Haus.Haustyp.RESTHOF.equals((Object)haustyp)) {
            return OpenEstateType.REST_OF_A_FARM;
        }
        if (Haus.Haustyp.SCHLOSS.equals((Object)haustyp)) {
            return OpenEstateType.PALACE;
        }
        if (Haus.Haustyp.STADTHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TOWN_HOUSE;
        }
        if (Haus.Haustyp.STRANDHAUS.equals((Object)haustyp)) {
            return OpenEstateType.BEACH_HOUSE;
        }
        if (Haus.Haustyp.VILLA.equals((Object)haustyp)) {
            return OpenEstateType.VILLA;
        }
        if (Haus.Haustyp.ZWEIFAMILIENHAUS.equals((Object)haustyp)) {
            return OpenEstateType.TWO_FAMILY_HOUSE;
        }
        return OpenEstateType.HOUSE;
    }

    protected OpenEstateType getEstateType(LandUndForstwirtschaft.LandTyp landTyp) {
        if (LandUndForstwirtschaft.LandTyp.ACKERBAU.equals((Object)landTyp)) {
            return OpenEstateType.CULTIVATION;
        }
        if (LandUndForstwirtschaft.LandTyp.AUSSIEDLERHOF.equals((Object)landTyp)) {
            return OpenEstateType.OUTLYING_FARM;
        }
        if (LandUndForstwirtschaft.LandTyp.BAUERNHOF.equals((Object)landTyp)) {
            return OpenEstateType.FARM;
        }
        if (LandUndForstwirtschaft.LandTyp.GARTENBAU.equals((Object)landTyp)) {
            return OpenEstateType.GARDENING;
        }
        if (LandUndForstwirtschaft.LandTyp.JAGD_UND_FORSTWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.FORESTRY_HUNTING;
        }
        if (LandUndForstwirtschaft.LandTyp.LANDWIRTSCHAFTLICHE_BETRIEBE.equals((Object)landTyp)) {
            return OpenEstateType.GENERAL_AGRICULTURE;
        }
        if (LandUndForstwirtschaft.LandTyp.REITERHOEFE.equals((Object)landTyp)) {
            return OpenEstateType.RIDING_ESTATE;
        }
        if (LandUndForstwirtschaft.LandTyp.SCHEUNEN.equals((Object)landTyp)) {
            return OpenEstateType.BARN;
        }
        if (LandUndForstwirtschaft.LandTyp.SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN.equals((Object)landTyp)) {
            return OpenEstateType.GENERAL_AGRICULTURE;
        }
        if (LandUndForstwirtschaft.LandTyp.TEICH_UND_FISCHWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.FISH_FARMING;
        }
        if (LandUndForstwirtschaft.LandTyp.VIEHWIRTSCHAFT.equals((Object)landTyp)) {
            return OpenEstateType.ANIMAL_HUSBANDRY;
        }
        if (LandUndForstwirtschaft.LandTyp.WEINBAU.equals((Object)landTyp)) {
            return OpenEstateType.VINICULTURE;
        }
        return OpenEstateType.GENERAL_AGRICULTURE;
    }

    protected OpenEstateType getEstateType(Sonstige.SonstigeTyp sonstigeTyp) {
        if (Sonstige.SonstigeTyp.PARKHAUS.equals((Object)sonstigeTyp)) {
            return OpenEstateType.CAR_PARK;
        }
        if (Sonstige.SonstigeTyp.SONSTIGE.equals((Object)sonstigeTyp)) {
            return OpenEstateType.SPECIAL_HOUSE;
        }
        if (Sonstige.SonstigeTyp.TANKSTELLE.equals((Object)sonstigeTyp)) {
            return OpenEstateType.PETROL_STATION;
        }
        return null;
    }

    protected OpenEstateType getEstateType(Wohnung.Wohnungtyp wohnungtyp) {
        if (Wohnung.Wohnungtyp.DACHGESCHOSS.equals((Object)wohnungtyp)) {
            return OpenEstateType.ATTIC_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ERDGESCHOSS.equals((Object)wohnungtyp)) {
            return OpenEstateType.GROUND_FLOOR_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.ETAGE.equals((Object)wohnungtyp)) {
            return OpenEstateType.HIGHER_FLOOR_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.LOFT_STUDIO_ATELIER.equals((Object)wohnungtyp)) {
            return OpenEstateType.LOFT;
        }
        if (Wohnung.Wohnungtyp.MAISONETTE.equals((Object)wohnungtyp)) {
            return OpenEstateType.MAISONETTE;
        }
        if (Wohnung.Wohnungtyp.PENTHOUSE.equals((Object)wohnungtyp)) {
            return OpenEstateType.PENTHOUSE_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.SOUTERRAIN.equals((Object)wohnungtyp)) {
            return OpenEstateType.SOUTERRAIN_APARTMENT;
        }
        if (Wohnung.Wohnungtyp.TERRASSEN.equals((Object)wohnungtyp)) {
            return OpenEstateType.TERRACE_APARTMENT;
        }
        return OpenEstateType.RESIDENCE;
    }

    protected OpenEstateType getEstateType(Zimmer.Zimmertyp zimmertyp) {
        return OpenEstateType.ROOM;
    }

    protected OpenEstateType getEstateType(ZinshausRenditeobjekt.ZinsTyp zinsTyp) {
        if (ZinshausRenditeobjekt.ZinsTyp.BUEROGEBAEUDE.equals((Object)zinsTyp)) {
            return OpenEstateType.OFFICE_BUILDING;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.EINKAUFSCENTREN.equals((Object)zinsTyp)) {
            return OpenEstateType.SHOPPING_CENTER;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.GESCHAEFTSHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.COMMERCIAL_BUILDING;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.INDUSTRIEANLAGEN.equals((Object)zinsTyp)) {
            return OpenEstateType.INDUSTRIAL_FACILITY;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.MEHRFAMILIENHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.SB_MAERKTE.equals((Object)zinsTyp)) {
            return OpenEstateType.SELF_SERVICE_MARKET;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.VERBRAUCHERMAERKTE.equals((Object)zinsTyp)) {
            return OpenEstateType.CONSUMER_STORE;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.WOHNANLAGEN.equals((Object)zinsTyp)) {
            return OpenEstateType.HOUSING_COMPLEX;
        }
        if (ZinshausRenditeobjekt.ZinsTyp.WOHN_UND_GESCHAEFTSHAUS.equals((Object)zinsTyp)) {
            return OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING;
        }
        return OpenEstateType.MULTI_FAMILY_HOUSE_WITH_COMMERCIAL;
    }

    protected OpenEstateType getEstateType(Nutzungsart nutzungsart) {
        if (nutzungsart == null) {
            return null;
        }
        if (Boolean.TRUE.equals(nutzungsart.getGEWERBE())) {
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        if (Boolean.TRUE.equals(nutzungsart.getWOHNEN())) {
            return OpenEstateType.GENERAL_RESIDENCE;
        }
        if (Boolean.TRUE.equals(nutzungsart.getANLAGE())) {
            return OpenEstateType.GENERAL_COMMERCIAL;
        }
        return null;
    }

    protected void readImmobilieAnhaenge(Anhaenge anhaenge, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (anhaenge == null) {
            return;
        }
        for (Anhang anhang : anhaenge.getAnhang()) {
            if (anhang.getDaten() == null) continue;
            try {
                EstateLinkProvider[] estateLinkProviderArray;
                URI uRI;
                String string2 = StringUtils.trimToNull((String)anhang.getDaten().getPfad());
                EstateLinkImpl.ProviderLink providerLink = null;
                if (string2 != null) {
                    URI uRI2 = uRI = string2.toLowerCase().startsWith("http://") || string2.toLowerCase().startsWith("https://") || string2.toLowerCase().startsWith("ftp://") || string2.toLowerCase().startsWith("ftps://") ? new URI(string2) : null;
                    if (uRI != null) {
                        for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                            String string3 = estateLinkProvider.getLinkIdFromUrl(uRI.toString());
                            if (string3 == null) continue;
                            providerLink = new EstateLinkImpl.ProviderLink(string3, estateLinkProvider);
                            break;
                        }
                    }
                } else {
                    uRI = null;
                }
                if (providerLink != null) {
                    estateLinkProviderArray = this.createEmptyLink();
                    estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                    estateLinkProviderArray.setProviderLink(providerLink);
                    estateImpl.getLinks().add(estateLinkProviderArray);
                    continue;
                }
                if (Anhang.Gruppe.LINKS.equals((Object)anhang.getGruppe()) && uRI != null) {
                    estateLinkProviderArray = this.createEmptyLink();
                    estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                    estateLinkProviderArray.setWebLink(uRI);
                    estateImpl.getLinks().add(estateLinkProviderArray);
                    continue;
                }
                estateLinkProviderArray = this.createEmptyAttachment();
                estateLinkProviderArray.setTitle(anhang.getAnhangtitel(), this.getOpenEstateLanguage());
                estateLinkProviderArray.setMimeType(StringUtils.trimToNull((String)anhang.getFormat()));
                if (uRI != null) {
                    estateLinkProviderArray.setFile(uRI);
                } else if (!StringUtils.isBlank((CharSequence)string2)) {
                    estateLinkProviderArray.setFile(string2);
                } else {
                    byte[] byArray = anhang.getDaten().getAnhanginhalt();
                    if (byArray != null) {
                        estateLinkProviderArray.setFile(byArray);
                    } else {
                        LOGGER.warn("<daten> element is empty");
                        continue;
                    }
                }
                if (Anhang.Gruppe.AUSSENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_OUTER_VIEW);
                } else if (Anhang.Gruppe.BILD.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE);
                } else if (Anhang.Gruppe.GRUNDRISS.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_GROUNDPLAN);
                } else if (Anhang.Gruppe.INNENANSICHTEN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_INNER_VIEW);
                } else if (Anhang.Gruppe.KARTEN_LAGEPLAN.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_MAP);
                } else if (Anhang.Gruppe.PANORAMA.equals((Object)anhang.getGruppe())) {
                    estateLinkProviderArray.setType(EstateAttachmentType.IMAGE_PANORAMA);
                }
                estateImpl.getAttachments().add(estateLinkProviderArray);
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read attachment!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.putError(string, "Can't read attachment! " + exception.getLocalizedMessage());
            }
        }
    }

    protected void readImmobilieAusstattung(Ausstattung ausstattung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (ausstattung == null) {
            return;
        }
        if (ausstattung.getAngeschlGastronomie() != null) {
            AttachedGastronomy.put((EstateImpl)estateImpl, (Boolean)(Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().getBAR()) || Boolean.TRUE.equals(ausstattung.getAngeschlGastronomie().getHOTELRESTAURANT()) ? 1 : 0));
        }
        BarrierFree.put((EstateImpl)estateImpl, (Boolean)ausstattung.getBarrierefrei());
        BreweryObligation.put((EstateImpl)estateImpl, (Boolean)ausstattung.getBrauereibindung());
        GardenUse.put((EstateImpl)estateImpl, (Boolean)ausstattung.getGartennutzung());
        GuestTerrace.put((EstateImpl)estateImpl, (Boolean)ausstattung.getGastterrasse());
        if (ausstattung.getHallenhoehe() != null) {
            WarehouseHeight.put((EstateImpl)estateImpl, (Number)ausstattung.getHallenhoehe(), (LengthValue.Unit)LengthValue.Unit.M);
        }
        LiftingPlatform.put((EstateImpl)estateImpl, (Boolean)ausstattung.getHebebuehne());
        ChimneyPort.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKamin());
        CanteenCafeteria.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKantineCafeteria());
        AirConditioned.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKlimatisiert());
        Crane.put((EstateImpl)estateImpl, (Boolean)ausstattung.getKran());
        Ramp.put((EstateImpl)estateImpl, (Boolean)ausstattung.getRampe());
        Sauna.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSauna());
        SportsFacilities.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSporteinrichtungen());
        ElectricalConnectionValue.put((EstateImpl)estateImpl, (Number)ausstattung.getStromanschlusswert());
        SwimmingPool.put((EstateImpl)estateImpl, (Boolean)ausstattung.getSwimmingpool());
        TelephoneAvailable.put((EstateImpl)estateImpl, (Boolean)ausstattung.getTelefonFerienimmobilie());
        WellnessArea.put((EstateImpl)estateImpl, (Boolean)ausstattung.getWellnessbereich());
        if (ausstattung.getAusrichtBalkonTerrasse() != null) {
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getNORD())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.N);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getOST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.E);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getSUED())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.S);
            }
            if (Boolean.TRUE.equals(ausstattung.getAusrichtBalkonTerrasse().getWEST())) {
                BalconyTerraceDirection.putOption((EstateImpl)estateImpl, (BalconyTerraceDirection.Option)BalconyTerraceDirection.Option.W);
            }
        }
        if (Boolean.TRUE.equals(ausstattung.getTeekueche())) {
            CommercialRooms.putOption((EstateImpl)estateImpl, (CommercialRooms.Option)CommercialRooms.Option.TEA_KITCHEN);
        }
        if (Boolean.TRUE.equals(ausstattung.getWaschTrockenraum())) {
            ResidentialRooms.putOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.WASHING_DRYING_ROOM);
        }
        if (Boolean.TRUE.equals(ausstattung.getDvVerkabelung())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        }
        if (Boolean.TRUE.equals(ausstattung.getKabelSatTv())) {
            Technics.putOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.CABLE_SAT_TV);
        }
        if (Boolean.TRUE.equals(ausstattung.getRollstuhlgerecht())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.WHEELCHAIR);
        }
        if (Boolean.TRUE.equals(ausstattung.getWgGeeignet())) {
            Applicability.putOption((EstateImpl)estateImpl, (Applicability.Option)Applicability.Option.APARTMENT_SHARE);
        }
        if (ausstattung.getBad() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBad().getDUSCHE())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.SHOWER);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getFENSTER())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.WINDOW);
            }
            if (Boolean.TRUE.equals(ausstattung.getBad().getWANNE())) {
                Bathroom.putOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BATHTUB);
            }
        }
        if (ausstattung.getBefeuerung() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getALTERNATIV())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.ALTERNATIVELY);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getELEKTRO())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.ELECTRICS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getERDWAERME())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GEOTHERMICS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getGAS())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.GAS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getOEL())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.OIL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBefeuerung().getSOLAR())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.SOLAR);
            }
        }
        if (ausstattung.getBoden() != null) {
            if (Boolean.TRUE.equals(ausstattung.getBoden().getDIELEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.FLOOR_BOARDS);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getDOPPELBODEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.ACCESS_FLOOR);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getESTRICH())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.SCREED);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getFLIESEN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.TILES);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getKUNSTSTOFF())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.SYNTHETIC_MATERIAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getPARKETT())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.PARQUET);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getSTEIN())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.STONE);
            }
            if (Boolean.TRUE.equals(ausstattung.getBoden().getTEPPICH())) {
                FlooringMaterial.putOption((EstateImpl)estateImpl, (FlooringMaterial.Option)FlooringMaterial.Option.CARPET);
            }
        }
        if (ausstattung.getFahrstuhl() != null) {
            FreightElevator.put((EstateImpl)estateImpl, (Boolean)ausstattung.getFahrstuhl().getLASTEN());
            Lift.put((EstateImpl)estateImpl, (Boolean)ausstattung.getFahrstuhl().getPERSONEN());
        }
        if (ausstattung.getHeizungsart() != null) {
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getETAGE())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.SELF_CONTAINED_CENTRAL);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getFERN())) {
                TypeOfBeaconing.putOption((EstateImpl)estateImpl, (TypeOfBeaconing.Option)TypeOfBeaconing.Option.DISTRICT_HEATING);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getFUSSBODEN())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.UNDERFLOOR);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getOFEN())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.OVEN);
            }
            if (Boolean.TRUE.equals(ausstattung.getHeizungsart().getZENTRAL())) {
                TypeOfHeating.putOption((EstateImpl)estateImpl, (TypeOfHeating.Option)TypeOfHeating.Option.CENTRAL);
            }
        }
        if (ausstattung.getKueche() != null) {
            if (Boolean.TRUE.equals(ausstattung.getKueche().getEBK())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN);
            }
            if (Boolean.TRUE.equals(ausstattung.getKueche().getOFFEN())) {
                Kitchen.putOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.OPEN_KITCHEN);
            }
        }
        if (ausstattung.getMoebliert() != null) {
            if (Boolean.TRUE.equals(ausstattung.getMoebliert().getVOLL())) {
                Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.YES);
            } else if (Boolean.TRUE.equals(ausstattung.getMoebliert().getTEIL())) {
                Furnished.put((EstateImpl)estateImpl, (Furnished.Option)Furnished.Option.PARTIAL);
            }
        }
        if (Boolean.TRUE.equals(ausstattung.getRaeumeVeraenderbar())) {
            RoomsModifiable.put((EstateImpl)estateImpl, (RoomsModifiable.Option)RoomsModifiable.Option.YES);
        } else if (Boolean.FALSE.equals(ausstattung.getRaeumeVeraenderbar())) {
            RoomsModifiable.put((EstateImpl)estateImpl, (RoomsModifiable.Option)RoomsModifiable.Option.PARTIALLY);
        }
        if (ausstattung.getServiceleistungen() != null) {
            for (Serviceleistungen serviceleistungen : ausstattung.getServiceleistungen()) {
                if (Boolean.TRUE.equals(serviceleistungen.getBETREUTESWOHNEN())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getEINKAUF())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.PURCHASING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getCATERING())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.CATERING);
                    CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.CATERING);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getREINIGUNG())) {
                    ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.CLEANING);
                    CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.CLEANING);
                }
                if (!Boolean.TRUE.equals(serviceleistungen.getWACHDIENST())) continue;
                ResidentialServices.putOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.SECURITY_FIRM);
                CommercialServices.putOption((EstateImpl)estateImpl, (CommercialServices.Option)CommercialServices.Option.SECURITY_FIRM);
            }
        }
        if (ausstattung.getSicherheitstechnik() != null) {
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getALARMANLAGE())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.ALARM_SYSTEM);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getKAMERA())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.CAMERA);
            }
            if (Boolean.TRUE.equals(ausstattung.getSicherheitstechnik().getPOLIZEIRUF())) {
                SecurityTechnology.putOption((EstateImpl)estateImpl, (SecurityTechnology.Option)SecurityTechnology.Option.POLICE_CALL);
            }
        }
        if (ausstattung.getStellplatzart() != null) {
            for (Serviceleistungen serviceleistungen : ausstattung.getStellplatzart()) {
                if (Boolean.TRUE.equals(serviceleistungen.getCARPORT())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.CARPORT);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getDUPLEX())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.DUPLEX_GARAGE);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getFREIPLATZ())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GENERAL);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getGARAGE())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.GARAGE);
                }
                if (Boolean.TRUE.equals(serviceleistungen.getPARKHAUS())) {
                    CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK);
                }
                if (!Boolean.TRUE.equals(serviceleistungen.getTIEFGARAGE())) continue;
                CarParkingType.putOption((EstateImpl)estateImpl, (CarParkingType.Option)CarParkingType.Option.AT_UNDERGROUND_CAR_PARK);
            }
        }
        if (ausstattung.getUnterkellert() != null && ausstattung.getUnterkellert().getKeller() != null) {
            Unterkellert.Keller keller = ausstattung.getUnterkellert().getKeller();
            if (Unterkellert.Keller.JA.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.YES);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            } else if (Unterkellert.Keller.TEIL.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.PARTIALLY);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.TRUE);
            } else if (Unterkellert.Keller.NEIN.equals((Object)keller)) {
                UndergroundLevel.put((EstateImpl)estateImpl, (UndergroundLevel.Option)UndergroundLevel.Option.NO);
                Basement.put((EstateImpl)estateImpl, (Boolean)Boolean.FALSE);
            }
        }
    }

    protected void readImmobilieFlaechen(Flaechen flaechen, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Object object;
        if (flaechen == null) {
            return;
        }
        CountBathrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBadezimmer());
        CountBalconies.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBalkonTerrassen());
        CountBeds.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlBetten());
        CountCommercialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlGewerbeeinheiten());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlSchlafzimmer());
        CountSeparateToilets.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlSepWc());
        CountParkingSpaces.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlStellplaetze());
        CountConferenceRooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlTagungsraeume());
        CountLivingAndBedrooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlWohnSchlafzimmer());
        CountResidentialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlWohneinheiten());
        CountRooms.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlZimmer());
        BalconyArea.put((EstateImpl)estateImpl, (Number)flaechen.getBalkonTerrasseFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        HeatableArea.put((EstateImpl)estateImpl, (Number)flaechen.getBeheizbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GrossFloorArea.put((EstateImpl)estateImpl, (String)flaechen.getBgf(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CubicIndex.put((EstateImpl)estateImpl, (String)flaechen.getBmz());
        OfficeArea.put((EstateImpl)estateImpl, (Number)flaechen.getBueroflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        OfficeAreaPart.put((EstateImpl)estateImpl, (Number)flaechen.getBueroteilflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AtticArea.put((EstateImpl)estateImpl, (Number)flaechen.getDachbodenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GrannyFlat.put((EstateImpl)estateImpl, (Boolean)flaechen.getEinliegerwohnung());
        FrontWindowLength.put((EstateImpl)estateImpl, (Number)flaechen.getFensterfront(), (LengthValue.Unit)LengthValue.Unit.M);
        FrontWindowArea.put((EstateImpl)estateImpl, (Number)flaechen.getFensterfrontQm(), (AreaValue.Unit)AreaValue.Unit.SQM);
        OpenSpace.put((EstateImpl)estateImpl, (Number)flaechen.getFreiflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        GardenArea.put((EstateImpl)estateImpl, (Number)flaechen.getGartenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        SeatingArea.put((EstateImpl)estateImpl, (Number)flaechen.getGastroflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        TotalArea.put((EstateImpl)estateImpl, (Number)flaechen.getGesamtflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        FloorAreaIndex.put((EstateImpl)estateImpl, (String)flaechen.getGfz());
        PlotArea.put((EstateImpl)estateImpl, (Number)flaechen.getGrundstuecksflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        PlotForesideLength.put((EstateImpl)estateImpl, (Number)flaechen.getGrundstuecksfront(), (LengthValue.Unit)LengthValue.Unit.M);
        BaseAreaIndex.put((EstateImpl)estateImpl, (String)flaechen.getGrz());
        BasementArea.put((EstateImpl)estateImpl, (Number)flaechen.getKellerflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RetailArea.put((EstateImpl)estateImpl, (Number)flaechen.getLadenflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        StorageArea.put((EstateImpl)estateImpl, (Number)flaechen.getLagerflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        UsableArea.put((EstateImpl)estateImpl, (Number)flaechen.getNutzflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        CountGuestroomSeats.put((EstateImpl)estateImpl, (Number)flaechen.getPlaetzeGastraum());
        RemainingAreas.put((EstateImpl)estateImpl, (Number)flaechen.getSonstflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        DivisibleFromArea.put((EstateImpl)estateImpl, (Number)flaechen.getTeilbarAb(), (AreaValue.Unit)AreaValue.Unit.SQM);
        SalesArea.put((EstateImpl)estateImpl, (Number)flaechen.getVerkaufsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        RentableArea.put((EstateImpl)estateImpl, (Number)flaechen.getVermietbareFlaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        AdministrationArea.put((EstateImpl)estateImpl, (Number)flaechen.getVerwaltungsflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        ResidentialArea.put((EstateImpl)estateImpl, (Number)flaechen.getWohnflaeche(), (AreaValue.Unit)AreaValue.Unit.SQM);
        if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            object = UsableArea.get((EstateImpl)estateImpl);
            if (object == null) {
                if (list.contains(OpenEstateType.OFFICE_SURGERY) || list.contains(OpenEstateType.OFFICE_COMMERCIAL_PREMISE)) {
                    object = OfficeArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.RETAIL)) {
                    object = RetailArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.HOSPITALITY_INDUSTRY) || list.contains(OpenEstateType.GASTRONOMY)) {
                    object = SeatingArea.get((EstateImpl)estateImpl);
                } else if (list.contains(OpenEstateType.HALL_WAREHOUSE)) {
                    object = StorageArea.get((EstateImpl)estateImpl);
                }
            }
            if (object == null) {
                object = TotalArea.get((EstateImpl)estateImpl);
            }
            if (object != null) {
                CommercialArea.put((EstateImpl)estateImpl, (AreaValue)object);
            }
        }
        if (list.contains(OpenEstateType.GENERAL_PARKING)) {
            object = UsableArea.get((EstateImpl)estateImpl);
            if (object == null) {
                object = TotalArea.get((EstateImpl)estateImpl);
            }
            if (object != null) {
                CarParkingArea.put((EstateImpl)estateImpl, (AreaValue)object);
            }
        }
        if (list.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING) && ((object = CountCommercialUnits.getAsBigDecimal((EstateImpl)estateImpl)) == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1)) {
            CountCommercialUnits.put((EstateImpl)estateImpl, (Number)flaechen.getAnzahlZimmer());
        }
    }

    protected void readImmobilieFreitexte(Freitexte freitexte, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (freitexte == null) {
            return;
        }
        estateImpl.setTitle(freitexte.getObjekttitel(), this.getOpenEstateLanguage());
        FeatureDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getAusstattBeschr());
        ShortDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getDreizeiler());
        LocationDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getLage());
        DetailledDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getObjektbeschreibung());
        AdditionalInformation.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)freitexte.getSonstigeAngaben());
    }

    protected void readImmobilieGeo(Geo geo, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        BigDecimal bigDecimal;
        if (geo == null) {
            return;
        }
        Floor.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), geo.getEtage() != null ? geo.getEtage().toString() : null);
        Parcel.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getFlur());
        SubPlot.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getFlurstueck());
        CommunalDistrict.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getGemarkung());
        CommunalCode.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getGemeindecode());
        RegionalNotes.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getRegionalerZusatz());
        ApartmentNr.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)geo.getWohnungsnr());
        estateImpl.getAddress().setRegion(geo.getBundesland());
        estateImpl.getAddress().setStreetNr(geo.getHausnummer());
        estateImpl.getAddress().setCity(geo.getOrt());
        estateImpl.getAddress().setPostalCode(geo.getPlz());
        estateImpl.getAddress().setStreet(geo.getStrasse());
        if (geo.getLand() != null && geo.getLand().getIsoLand() != null) {
            estateImpl.getAddress().setCountry(OpenEstateUtils.convertToIso2Country((String)geo.getLand().getIsoLand()));
        }
        if (geo.getGeokoordinaten() != null) {
            bigDecimal = geo.getGeokoordinaten().getBreitengrad();
            BigDecimal bigDecimal2 = geo.getGeokoordinaten().getLaengengrad();
            if (bigDecimal != null && bigDecimal2 != null) {
                estateImpl.getAddress().setLatitude(bigDecimal);
                estateImpl.getAddress().setLongitude(bigDecimal2);
            }
        }
        if (geo.getLageGebiet() != null && geo.getLageGebiet().getGebiete() != null) {
            bigDecimal = geo.getLageGebiet().getGebiete();
            if (LageGebiet.Gebiete.A_LAGE.equals((Object)bigDecimal)) {
                CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_A);
            } else if (LageGebiet.Gebiete.B_LAGE.equals((Object)bigDecimal)) {
                CommercialZone.put((EstateImpl)estateImpl, (CommercialZone.Option)CommercialZone.Option.LOCATION_B);
            } else if (LageGebiet.Gebiete.GEWERBE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.COMMERCIAL);
            } else if (LageGebiet.Gebiete.INDUSTRIE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.INDUSTRIAL);
            } else if (LageGebiet.Gebiete.MISCH.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.MIXED);
            } else if (LageGebiet.Gebiete.NEBENZENTRUM.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.SUBSIDIARY_CENTER);
            } else if (LageGebiet.Gebiete.NEUBAU.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.DEVELOPMENT);
            } else if (LageGebiet.Gebiete.ORTSLAGE.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.CITY);
            } else if (LageGebiet.Gebiete.SIEDLUNG.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.VILLAGE);
            } else if (LageGebiet.Gebiete.STADTRAND.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.SUBURBS);
            } else if (LageGebiet.Gebiete.STADTTEIL.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.DISTRICT);
            } else if (LageGebiet.Gebiete.STADTZENTRUM.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.CITY_CENTER);
            } else if (LageGebiet.Gebiete.WOHN.equals((Object)bigDecimal)) {
                Zone.put((EstateImpl)estateImpl, (Zone.Option)Zone.Option.RESIDENTIAL);
            }
        }
        if (geo.getLageImBau() != null) {
            if (Boolean.TRUE.equals(geo.getLageImBau().getHINTEN())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.BACKYARD_BUILDING);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getLINKS())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.SIDE_WING_LEFT);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getRECHTS())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.SIDE_WING_RIGHT);
            }
            if (Boolean.TRUE.equals(geo.getLageImBau().getVORNE())) {
                LocationInBuilding.put((EstateImpl)estateImpl, (LocationInBuilding.Option)LocationInBuilding.Option.FRONT_BUILDING);
            }
        }
    }

    protected void readImmobilieInfrastruktur(Infrastruktur infrastruktur, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Distanzen.DistanzZu distanzZu;
        if (infrastruktur == null) {
            return;
        }
        if (infrastruktur.getAusblick() != null) {
            Ausblick.Blick blick = infrastruktur.getAusblick().getBlick();
            if (Ausblick.Blick.BERGE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.MOUNTAIN_VIEW);
            } else if (Ausblick.Blick.FERNE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.DISTANT_VIEW);
            } else if (Ausblick.Blick.SEE.equals((Object)blick)) {
                View.putOption((EstateImpl)estateImpl, (View.Option)View.Option.LAKE_VIEW);
            }
        }
        if (infrastruktur.getDistanzen() != null) {
            for (Distanzen distanzen : infrastruktur.getDistanzen()) {
                distanzZu = distanzen.getDistanzZu();
                if (Distanzen.DistanzZu.AUTOBAHN.equals((Object)distanzZu)) {
                    DistanceToMotorway.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.BUS.equals((Object)distanzZu)) {
                    DistanceToBusStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.EINKAUFSMOEGLICHKEITEN.equals((Object)distanzZu)) {
                    DistanceToNextShopping.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.FERNBAHNHOF.equals((Object)distanzZu)) {
                    DistanceToMainLineStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.FLUGHAFEN.equals((Object)distanzZu)) {
                    DistanceToAirport.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GASTSTAETTEN.equals((Object)distanzZu)) {
                    DistanceToNextGastronomy.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GESAMTSCHULE.equals((Object)distanzZu)) {
                    DistanceToComprehensiveSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GRUNDSCHULE.equals((Object)distanzZu)) {
                    DistanceToElementarySchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.GYMNASIUM.equals((Object)distanzZu)) {
                    DistanceToHighSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.HAUPTSCHULE.equals((Object)distanzZu)) {
                    DistanceToJuniorHighSchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.KINDERGAERTEN.equals((Object)distanzZu)) {
                    DistanceToDayNursery.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.REALSCHULE.equals((Object)distanzZu)) {
                    DistanceToSecondarySchool.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (Distanzen.DistanzZu.US_BAHN.equals((Object)distanzZu)) {
                    DistanceToNextTrainStation.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (!Distanzen.DistanzZu.ZENTRUM.equals((Object)distanzZu)) continue;
                DistanceToCityCentre.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
            }
        }
        if (infrastruktur.getDistanzenSport() != null) {
            for (Distanzen distanzen : infrastruktur.getDistanzenSport()) {
                distanzZu = distanzen.getDistanzZuSport();
                if (DistanzenSport.DistanzZuSport.MEER.equals((Object)distanzZu)) {
                    DistanceToSea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.NAHERHOLUNG.equals((Object)distanzZu)) {
                    DistanceToRecreationalArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SEE.equals((Object)distanzZu)) {
                    DistanceToLake.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SKIGEBIET.equals((Object)distanzZu)) {
                    DistanceToSkiingArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.SPORTANLAGEN.equals((Object)distanzZu)) {
                    DistanceToSportsFacilities.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (DistanzenSport.DistanzZuSport.STRAND.equals((Object)distanzZu)) {
                    DistanceToBeach.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
                    continue;
                }
                if (!DistanzenSport.DistanzZuSport.WANDERGEBIETE.equals((Object)distanzZu)) continue;
                DistanceToWanderingArea.put((EstateImpl)estateImpl, (Number)distanzen.getValue(), (LengthValue.Unit)LengthValue.Unit.KM);
            }
        }
        SupplyPossible.put((EstateImpl)estateImpl, (Boolean)infrastruktur.getZulieferung());
    }

    protected void readImmobilieKontaktperson(Kontaktperson kontaktperson, EstateImpl estateImpl, List<OpenEstateType> list, Map<String, AgentContactImpl> map, String string) {
        String string2;
        EmailSonstige emailSonstige;
        Object object;
        if (kontaktperson == null) {
            return;
        }
        String string3 = StringUtils.trimToNull((String)kontaktperson.getPersonennummer());
        if (string3 == null) {
            string3 = "NewContact." + (map.size() + 1);
        }
        if (map.containsKey(string3)) {
            AgentContactImpl agentContactImpl = map.get(string3);
            estateImpl.setContactId(agentContactImpl.getId());
            return;
        }
        AgentContactImpl agentContactImpl = this.createEmptyContact();
        agentContactImpl.setId(string3);
        estateImpl.setContactId(string3);
        map.put(string3, agentContactImpl);
        agentContactImpl.setStreetNr(kontaktperson.getHausnummer());
        agentContactImpl.setPersonLastName(kontaktperson.getName());
        agentContactImpl.setCity(kontaktperson.getOrt());
        agentContactImpl.setPostalCode(kontaktperson.getPlz());
        agentContactImpl.setStreet(kontaktperson.getStrasse());
        agentContactImpl.setPersonFirstName(kontaktperson.getVorname());
        String string4 = kontaktperson.getAnrede();
        if (Gender.FEMALE.name().equalsIgnoreCase(string4) || "frau".equalsIgnoreCase(string4)) {
            agentContactImpl.setPersonGender(Gender.FEMALE);
        } else if (Gender.MALE.name().equalsIgnoreCase(string4) || "herr".equalsIgnoreCase(string4)) {
            agentContactImpl.setPersonGender(Gender.MALE);
        }
        if (kontaktperson.getLand() != null && !StringUtils.isBlank((CharSequence)kontaktperson.getLand().getIsoLand())) {
            agentContactImpl.setCountry(OpenEstateUtils.convertToIso2Country((String)kontaktperson.getLand().getIsoLand().trim()));
        }
        agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailDirekt()));
        if (agentContactImpl.getPersonMail() == null) {
            agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailZentrale()));
        }
        if (agentContactImpl.getPersonMail() == null) {
            agentContactImpl.setPersonMail(StringUtils.trimToNull((String)kontaktperson.getEmailPrivat()));
        }
        if (agentContactImpl.getPersonMail() == null) {
            object = kontaktperson.getEmailSonstige().iterator();
            while (object.hasNext()) {
                emailSonstige = (EmailSonstige)object.next();
                string2 = StringUtils.trimToNull((String)emailSonstige.getValue());
                if (string2 == null) continue;
                agentContactImpl.setPersonMail(string2);
                break;
            }
        }
        agentContactImpl.setPersonFax(StringUtils.trimToNull((String)kontaktperson.getTelFax()));
        agentContactImpl.setPersonMobilePhone(StringUtils.trimToNull((String)kontaktperson.getTelHandy()));
        agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelDurchw()));
        if (agentContactImpl.getPersonPhone() == null) {
            agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelZentrale()));
        }
        if (agentContactImpl.getPersonPhone() == null) {
            agentContactImpl.setPersonPhone(StringUtils.trimToNull((String)kontaktperson.getTelPrivat()));
        }
        if (agentContactImpl.getPersonPhone() == null || agentContactImpl.getPersonMobilePhone() == null || agentContactImpl.getPersonFax() == null) {
            object = kontaktperson.getTelSonstige().iterator();
            while (object.hasNext()) {
                emailSonstige = (TelSonstige)object.next();
                string2 = StringUtils.trimToNull((String)emailSonstige.getValue());
                boolean bl = TelSonstige.Telefonart.TEL_FAX.equals((Object)emailSonstige.getTelefonart());
                boolean bl2 = TelSonstige.Telefonart.TEL_HANDY.equals((Object)emailSonstige.getTelefonart());
                if (string2 == null) continue;
                if (bl && agentContactImpl.getPersonFax() == null) {
                    agentContactImpl.setPersonFax(string2);
                } else if (bl2 && agentContactImpl.getPersonMobilePhone() == null) {
                    agentContactImpl.setPersonMobilePhone(string2);
                } else if (!bl && !bl2 && agentContactImpl.getPersonPhone() == null) {
                    agentContactImpl.setPersonPhone(string2);
                }
                if (agentContactImpl.getPersonPhone() == null || agentContactImpl.getPersonMobilePhone() == null || agentContactImpl.getPersonFax() == null) continue;
                break;
            }
        }
        if ((object = StringUtils.trimToNull((String)kontaktperson.getUrl())) != null) {
            try {
                if (!((String)object).toLowerCase().startsWith("http://") && !((String)object).toLowerCase().startsWith("https://")) {
                    object = "http://" + (String)object;
                }
                agentContactImpl.setContactWebsite(new URI((String)object));
            }
            catch (URISyntaxException uRISyntaxException) {
                LOGGER.warn("Can't read contact website URL '" + (String)object + "'!!");
                LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                agentContactImpl.setContactWebsite(null);
                this.putError(string, "Can't read contact website URL '" + (String)object + "'! " + uRISyntaxException.getLocalizedMessage());
            }
        }
    }

    protected void readImmobilieObjektkategorie(Immobilie immobilie, EstateImpl estateImpl, String string) {
        BigDecimal bigDecimal;
        Preise preise;
        Objektkategorie objektkategorie = immobilie != null ? immobilie.getObjektkategorie() : null;
        Preise preise2 = preise = immobilie != null ? immobilie.getPreise() : null;
        if (objektkategorie == null) {
            return;
        }
        OpenEstateType openEstateType = null;
        if (!objektkategorie.getObjektart().getBueroPraxen().isEmpty()) {
            openEstateType = this.getEstateType(((BueroPraxen)objektkategorie.getObjektart().getBueroPraxen().get(0)).getBueroTyp());
        } else if (!objektkategorie.getObjektart().getEinzelhandel().isEmpty()) {
            openEstateType = this.getEstateType(((Einzelhandel)objektkategorie.getObjektart().getEinzelhandel().get(0)).getHandelTyp());
        } else if (!objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().isEmpty()) {
            openEstateType = this.getEstateType(((FreizeitimmobilieGewerblich)objektkategorie.getObjektart().getFreizeitimmobilieGewerblich().get(0)).getFreizeitTyp());
        } else if (!objektkategorie.getObjektart().getGastgewerbe().isEmpty()) {
            openEstateType = this.getEstateType(((Gastgewerbe)objektkategorie.getObjektart().getGastgewerbe().get(0)).getGastgewTyp());
        } else if (!objektkategorie.getObjektart().getGrundstueck().isEmpty()) {
            openEstateType = this.getEstateType(((Grundstueck)objektkategorie.getObjektart().getGrundstueck().get(0)).getGrundstTyp());
        } else if (!objektkategorie.getObjektart().getHallenLagerProd().isEmpty()) {
            openEstateType = this.getEstateType(((HallenLagerProd)objektkategorie.getObjektart().getHallenLagerProd().get(0)).getHallenTyp());
        } else if (!objektkategorie.getObjektart().getHaus().isEmpty()) {
            openEstateType = this.getEstateType(((Haus)objektkategorie.getObjektart().getHaus().get(0)).getHaustyp());
        } else if (!objektkategorie.getObjektart().getLandUndForstwirtschaft().isEmpty()) {
            openEstateType = this.getEstateType(((LandUndForstwirtschaft)objektkategorie.getObjektart().getLandUndForstwirtschaft().get(0)).getLandTyp());
        } else if (!objektkategorie.getObjektart().getSonstige().isEmpty()) {
            openEstateType = this.getEstateType(((Sonstige)objektkategorie.getObjektart().getSonstige().get(0)).getSonstigeTyp());
        } else if (!objektkategorie.getObjektart().getWohnung().isEmpty()) {
            openEstateType = this.getEstateType(((Wohnung)objektkategorie.getObjektart().getWohnung().get(0)).getWohnungtyp());
        } else if (!objektkategorie.getObjektart().getZimmer().isEmpty()) {
            openEstateType = this.getEstateType(((Zimmer)objektkategorie.getObjektart().getZimmer().get(0)).getZimmertyp());
        } else if (!objektkategorie.getObjektart().getZinshausRenditeobjekt().isEmpty()) {
            openEstateType = this.getEstateType(((ZinshausRenditeobjekt)objektkategorie.getObjektart().getZinshausRenditeobjekt().get(0)).getZinsTyp());
        }
        if (openEstateType == null) {
            openEstateType = this.getEstateType(objektkategorie.getNutzungsart());
        }
        if (openEstateType == null) {
            throw new IllegalArgumentException("Can't find an estate type!");
        }
        AbstractTypeImpl abstractTypeImpl = openEstateType.createImpl();
        if (abstractTypeImpl == null) {
            throw new IllegalArgumentException("unsupported estate type (" + openEstateType + ")");
        }
        OpenEstateAction openEstateAction = null;
        if (objektkategorie.getVermarktungsart() != null) {
            if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().getERBPACHT())) {
                openEstateAction = OpenEstateAction.EMPHYTEUSIS;
            } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().getKAUF())) {
                openEstateAction = OpenEstateAction.PURCHASE;
            } else if (Boolean.TRUE.equals(objektkategorie.getVermarktungsart().getMIETEPACHT())) {
                boolean bl;
                bigDecimal = preise != null ? preise.getPacht() : null;
                boolean bl2 = Boolean.TRUE.equals(objektkategorie.getNutzungsart().getWAZ());
                boolean bl3 = bl = bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0;
                openEstateAction = bl2 && abstractTypeImpl.hasAction(OpenEstateAction.SHORT_TERM_RENT) ? OpenEstateAction.SHORT_TERM_RENT : (bl && abstractTypeImpl.hasAction(OpenEstateAction.LEASE) ? OpenEstateAction.LEASE : OpenEstateAction.RENT);
            }
        }
        if (openEstateAction == null && preise != null) {
            bigDecimal = preise.getKaufpreis();
            BigDecimal bigDecimal2 = preise.getPacht();
            BigDecimal bigDecimal3 = preise.getKaltmiete();
            if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) <= 0) {
                bigDecimal3 = preise.getWarmmiete();
            }
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.PURCHASE;
            } else if (bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.RENT;
            } else if (bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0) {
                openEstateAction = OpenEstateAction.LEASE;
            }
        }
        if (openEstateAction == null) {
            throw new IllegalArgumentException("Can't find an estate-action!");
        }
        if (!abstractTypeImpl.hasAction(openEstateAction)) {
            throw new IllegalArgumentException("The estate-type '" + openEstateType + "' does not suppert estate-action '" + openEstateAction + "'!");
        }
        estateImpl.setType(openEstateType, openEstateAction);
        if (objektkategorie.getNutzungsart() != null) {
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().getANLAGE())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.INVESTMENT);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().getGEWERBE())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.COMMERCIAL);
            }
            if (Boolean.TRUE.equals(objektkategorie.getNutzungsart().getWOHNEN())) {
                Usage.putOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.RESIDENTIAL);
            }
        }
    }

    protected void readImmobiliePreise(Preise preise, Ausstattung ausstattung, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Object object;
        Object object2;
        Object object3;
        if (preise == null) {
            return;
        }
        TakeoverCosts.put((EstateImpl)estateImpl, (Number)preise.getAbstand());
        if (preise.getAussenCourtage() != null) {
            AgentFee.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getAussenCourtage().getContent());
            AgentFeeIncludingVat.put((EstateImpl)estateImpl, (Boolean)preise.getAussenCourtage().getMitMwst());
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            Lease.put((EstateImpl)estateImpl, (Number)preise.getErbpacht());
        }
        DevelopmentCosts.put((EstateImpl)estateImpl, (Number)preise.getErschliessungskosten());
        PriceDescription.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)preise.getFreitextPreis());
        SharedCapital.put((EstateImpl)estateImpl, (Number)preise.getGeschaeftsguthaben());
        CommonCharge.put((EstateImpl)estateImpl, (Number)preise.getHausgeld());
        HeatingCosts.put((EstateImpl)estateImpl, (Number)preise.getHeizkosten());
        RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getKaltmiete());
        PurchasePrice.put((EstateImpl)estateImpl, (Number)preise.getKaufpreis());
        PurchasePricePerArea.put((EstateImpl)estateImpl, (Number)preise.getKaufpreisProQm());
        DepositAmount.put((EstateImpl)estateImpl, (Number)preise.getKaution());
        RentalIncomeActualPerAnnum.put((EstateImpl)estateImpl, (Number)preise.getMieteinnahmenIst());
        RentalIncomeDebitPerAnnum.put((EstateImpl)estateImpl, (Number)preise.getMieteinnahmenSoll());
        RentExcludingServiceChargesPerArea.put((EstateImpl)estateImpl, (Number)preise.getMietpreisProQm());
        AdditionalRentalCharges.put((EstateImpl)estateImpl, (Number)preise.getMietzuschlaege());
        VatRate.put((EstateImpl)estateImpl, (Number)preise.getMwstSatz());
        ServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getNebenkosten());
        BasicRent.put((EstateImpl)estateImpl, (Number)preise.getNettokaltmiete());
        NetReturn.put((EstateImpl)estateImpl, (Number)preise.getNettorendite());
        if (!OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction()) || Lease.get((EstateImpl)estateImpl) == null) {
            Lease.put((EstateImpl)estateImpl, (Number)preise.getPacht());
        }
        if (preise.getPreisZeiteinheit() != null && preise.getPreisZeiteinheit().getZeiteinheit() != null) {
            object3 = preise.getPreisZeiteinheit().getZeiteinheit();
            if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
                if (PreisZeiteinheit.Zeiteinheit.JAHR.equals(object3)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.YEAR);
                } else if (PreisZeiteinheit.Zeiteinheit.MONAT.equals(object3)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.MONTH);
                } else if (PreisZeiteinheit.Zeiteinheit.TAG.equals(object3)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.DAY);
                } else if (PreisZeiteinheit.Zeiteinheit.WOCHE.equals(object3)) {
                    RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.WEEK);
                }
            } else {
                ChargeTimeUnit.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)object3.name());
            }
        }
        ChargeEndDate.put((EstateImpl)estateImpl, (Calendar)preise.getPreisZeitraumBis());
        ChargeBeginDate.put((EstateImpl)estateImpl, (Calendar)preise.getPreisZeitraumVon());
        object3 = null;
        if (ausstattung != null && ausstattung.getStellplatzart() != null) {
            object2 = ausstattung.getStellplatzart().iterator();
            while (object2.hasNext()) {
                object = (Stellplatzart)object2.next();
                if (Boolean.TRUE.equals(object.getCARPORT())) {
                    object3 = preise.getStpCarport();
                } else if (Boolean.TRUE.equals(object.getDUPLEX())) {
                    object3 = preise.getStpDuplex();
                } else if (Boolean.TRUE.equals(object.getFREIPLATZ())) {
                    object3 = preise.getStpFreiplatz();
                } else if (Boolean.TRUE.equals(object.getGARAGE())) {
                    object3 = preise.getStpGarage();
                } else if (Boolean.TRUE.equals(object.getPARKHAUS())) {
                    object3 = preise.getStpParkhaus();
                } else if (Boolean.TRUE.equals(object.getTIEFGARAGE())) {
                    object3 = preise.getStpTiefgarage();
                }
                if (object3 != null && object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
                    object3 = null;
                }
                if (object3 == null) continue;
                break;
            }
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpCarport();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpDuplex();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpFreiplatz();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpGarage();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpParkhaus();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object3 = preise.getStpTiefgarage();
        }
        if (object3 == null || object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
            object2 = preise.getStpSonstige().iterator();
            while (object2.hasNext()) {
                object = (StpSonstige)object2.next();
                object3 = object;
                if (object3 != null && object3.getStellplatzkaufpreis() == null && object3.getStellplatzmiete() == null) {
                    object3 = null;
                }
                if (object3 == null) continue;
                break;
            }
        }
        if (object3 != null) {
            if (CountParkingSpaces.get((EstateImpl)estateImpl) == null) {
                CountParkingSpaces.put((EstateImpl)estateImpl, (Number)object3.getAnzahl());
            }
            if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
                CarParkingSpaceRent.put((EstateImpl)estateImpl, (Number)object3.getStellplatzmiete());
            } else {
                CarParkingSpacePrice.put((EstateImpl)estateImpl, (Number)object3.getStellplatzkaufpreis());
            }
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            RentFlatRate.put((EstateImpl)estateImpl, (Number)preise.getWarmmiete());
        } else {
            RentIncludingServiceCharges.put((EstateImpl)estateImpl, (Number)preise.getWarmmiete());
        }
        PurchasePriceOnAnnualRentalIncome.put((EstateImpl)estateImpl, (String)StringUtils.trimToNull((String)preise.getXFache()));
        PlusVat.put((EstateImpl)estateImpl, (Boolean)preise.getZzgMehrwertsteuer());
        if (preise.getWaehrung() != null && (object2 = StringUtils.trimToNull((String)preise.getWaehrung().getIsoWaehrung())) != null) {
            try {
                estateImpl.setCurrency(Currency.getInstance((String)object2));
            }
            catch (Exception exception) {
                LOGGER.warn("Can't read currency code '" + (String)object2 + "'!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                this.putError(string, "Can't read currency code '" + (String)object2 + "'! " + exception.getLocalizedMessage());
            }
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction()) && RentFlatRate.get((EstateImpl)estateImpl) == null) {
            object2 = RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            object = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            BigDecimal bigDecimal = ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
            if (object2 != null) {
                RentFlatRate.put((EstateImpl)estateImpl, (Number)object2);
            } else if (object != null) {
                if (bigDecimal != null) {
                    RentFlatRate.put((EstateImpl)estateImpl, (Number)((BigDecimal)object).add(bigDecimal));
                } else {
                    RentFlatRate.put((EstateImpl)estateImpl, (Number)object);
                }
            }
        }
    }

    protected void readImmobilieVerwaltungObjekt(VerwaltungObjekt verwaltungObjekt, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        MaxMietdauer.MaxDauer maxDauer;
        Object object;
        Integer n;
        Object object2;
        String string2;
        if (verwaltungObjekt == null) {
            return;
        }
        estateImpl.setGroupId(StringUtils.trimToNull((String)verwaltungObjekt.getGruppennummer()));
        HolidayProperty.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getAlsFerien());
        AvailabilityEndDate.put((EstateImpl)estateImpl, (Calendar)verwaltungObjekt.getBisdatum());
        CommercialIndustries.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)verwaltungObjekt.getBranchen());
        MonumentalProtection.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getDenkmalgeschuetzt());
        Skyscraper.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getHochhaus());
        EmphyteusisDuration.put((EstateImpl)estateImpl, (Number)verwaltungObjekt.getLaufzeit());
        PeopleMaximumCount.put((EstateImpl)estateImpl, (Number)verwaltungObjekt.getMaxPersonen());
        estateImpl.getAddress().setPublished(Boolean.TRUE.equals(verwaltungObjekt.getObjektadresseFreigeben()));
        Rented.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getVermietet());
        AuctionDate.put((EstateImpl)estateImpl, (Calendar)verwaltungObjekt.getVersteigerungstermin());
        WbsRequired.put((EstateImpl)estateImpl, (Boolean)verwaltungObjekt.getWbsSozialwohnung());
        AccessBeginDate.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)verwaltungObjekt.getZugang());
        Calendar calendar = verwaltungObjekt.getAbdatum();
        if (calendar != null) {
            AvailabilityBeginDate.put((EstateImpl)estateImpl, (Calendar)calendar);
        }
        if ((string2 = StringUtils.trimToNull((String)verwaltungObjekt.getVerfuegbarAb())) != null) {
            AvailabilityBegin.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)string2);
        }
        if (calendar == null && string2 != null) {
            try {
                AvailabilityBeginDate.put((EstateImpl)estateImpl, (Date)OpenEstateUtils.parseDate((String)string2));
            }
            catch (Exception exception) {
                LOGGER.debug("Can't read <verfuegbar_ab>" + string2 + "</verfuegbar_ab> as date value!");
                LOGGER.debug("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        if (verwaltungObjekt.getGeschlecht() != null && verwaltungObjekt.getGeschlecht().getGeschlAttr() != null) {
            object2 = verwaltungObjekt.getGeschlecht().getGeschlAttr();
            if (Geschlecht.GeschlAttr.EGAL.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.INDIFFERENT);
            } else if (Geschlecht.GeschlAttr.NUR_FRAU.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.FEMALE);
            } else if (Geschlecht.GeschlAttr.NUR_MANN.equals(object2)) {
                GenderOfRequestedFlatmates.put((EstateImpl)estateImpl, (GenderOfRequestedFlatmates.Option)GenderOfRequestedFlatmates.Option.MALE);
            }
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getGewerblicheNutzung())) {
            CommercialUse.put((EstateImpl)estateImpl, (CommercialUse.Option)CommercialUse.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getGewerblicheNutzung())) {
            CommercialUse.put((EstateImpl)estateImpl, (CommercialUse.Option)CommercialUse.Option.NO);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getHaustiere())) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getHaustiere())) {
            Pets.put((EstateImpl)estateImpl, (Pets.Option)Pets.Option.NO);
        }
        if (verwaltungObjekt.getMaxMietdauer() != null && !StringUtils.isBlank((CharSequence)verwaltungObjekt.getMaxMietdauer().getContent())) {
            object2 = verwaltungObjekt.getMaxMietdauer().getContent().trim();
            n = null;
            try {
                n = Integer.valueOf((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = n != null ? NumberFormat.getIntegerInstance(this.getOpenEstateLanguage()).format(n) : object2;
            maxDauer = verwaltungObjekt.getMaxMietdauer().getMaxDauer();
            if (maxDauer != null) {
                object = (String)object + " ";
                if ("de".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (maxDauer) {
                        case JAHR: {
                            object = (String)object + (n != null && n == 1 ? "Jahr" : "Jahre");
                            break;
                        }
                        case MONAT: {
                            object = (String)object + (n != null && n == 1 ? "Monat" : "Monate");
                            break;
                        }
                        case TAG: {
                            object = (String)object + (n != null && n == 1 ? "Tag" : "Tage");
                            break;
                        }
                        case WOCHE: {
                            object = (String)object + (n != null && n == 1 ? "Woche" : "Wochen");
                        }
                    }
                } else if ("en".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (maxDauer) {
                        case JAHR: {
                            object = (String)object + (n != null && n == 1 ? "year" : "years");
                            break;
                        }
                        case MONAT: {
                            object = (String)object + (n != null && n == 1 ? "month" : "months");
                            break;
                        }
                        case TAG: {
                            object = (String)object + (n != null && n == 1 ? "day" : "days");
                            break;
                        }
                        case WOCHE: {
                            object = (String)object + (n != null && n == 1 ? "week" : "weeks");
                        }
                    }
                } else {
                    object = (String)object + maxDauer.value();
                }
            }
            OccupationPeriodMaximum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)object);
        }
        if (verwaltungObjekt.getMinMietdauer() != null && !StringUtils.isBlank((CharSequence)verwaltungObjekt.getMinMietdauer().getContent())) {
            object2 = verwaltungObjekt.getMinMietdauer().getContent().trim();
            n = null;
            try {
                n = Integer.valueOf((String)object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = n != null ? NumberFormat.getIntegerInstance(this.getOpenEstateLanguage()).format(n) : object2;
            maxDauer = verwaltungObjekt.getMinMietdauer().getMinDauer();
            if (maxDauer != null) {
                object = (String)object + " ";
                if ("de".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (1.$SwitchMap$org$openestate$io$immoxml$xml$MinMietdauer$MinDauer[maxDauer.ordinal()]) {
                        case 1: {
                            object = (String)object + (n != null && n == 1 ? "Jahr" : "Jahre");
                            break;
                        }
                        case 2: {
                            object = (String)object + (n != null && n == 1 ? "Monat" : "Monate");
                            break;
                        }
                        case 3: {
                            object = (String)object + (n != null && n == 1 ? "Tag" : "Tage");
                            break;
                        }
                        case 4: {
                            object = (String)object + (n != null && n == 1 ? "Woche" : "Wochen");
                        }
                    }
                } else if ("en".equalsIgnoreCase(this.getOpenEstateLanguage().getLanguage())) {
                    switch (1.$SwitchMap$org$openestate$io$immoxml$xml$MinMietdauer$MinDauer[maxDauer.ordinal()]) {
                        case 1: {
                            object = (String)object + (n != null && n == 1 ? "year" : "years");
                            break;
                        }
                        case 2: {
                            object = (String)object + (n != null && n == 1 ? "month" : "months");
                            break;
                        }
                        case 3: {
                            object = (String)object + (n != null && n == 1 ? "day" : "days");
                            break;
                        }
                        case 4: {
                            object = (String)object + (n != null && n == 1 ? "week" : "weeks");
                        }
                    }
                } else {
                    object = (String)object + maxDauer.value();
                }
            }
            OccupationPeriodMinimum.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)object);
        }
        if (Boolean.TRUE.equals(verwaltungObjekt.getNichtraucher())) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.YES);
        } else if (Boolean.FALSE.equals(verwaltungObjekt.getNichtraucher())) {
            NonSmoker.put((EstateImpl)estateImpl, (NonSmoker.Option)NonSmoker.Option.NO);
        }
    }

    protected void readImmobilieVerwaltungTechn(VerwaltungTechn verwaltungTechn, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        if (verwaltungTechn == null) {
            return;
        }
        estateImpl.setPublishEnd(verwaltungTechn.getAktivBis() != null ? verwaltungTechn.getAktivBis().getTime() : null);
        estateImpl.setPublishBegin(verwaltungTechn.getAktivVon() != null ? verwaltungTechn.getAktivVon().getTime() : null);
        estateImpl.setId(string);
        estateImpl.setPublicId(verwaltungTechn.getObjektnrExtern());
        EffectiveDate.put((EstateImpl)estateImpl, (Calendar)verwaltungTechn.getStandVom());
        if (verwaltungTechn.getAktion() != null && verwaltungTechn.getAktion().getAktionart() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.aktion", (Object)verwaltungTechn.getAktion().getAktionart().value(), 5);
        } else {
            estateImpl.getCustomValues().putCustomValue("immoxml.aktion", (Object)Aktion.AktionArt.CHANGE.value(), 5);
        }
        if (verwaltungTechn.getKennungUrsprung() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.kennung_ursprung", (Object)verwaltungTechn.getKennungUrsprung(), 5);
        }
        if (verwaltungTechn.getImmoxmlObid() != null) {
            estateImpl.getCustomValues().putCustomValue("immoxml.immoxml_obid", (Object)verwaltungTechn.getImmoxmlObid(), 5);
        }
    }

    protected void readImmobilieWeitereAdressen(List<WeitereAdresse> list, EstateImpl estateImpl, List<OpenEstateType> list2, String string) {
    }

    protected void readImmobilieZustandAngaben(ZustandAngaben zustandAngaben, EstateImpl estateImpl, List<OpenEstateType> list, String string) {
        Object object;
        Alter.AlterAttr alterAttr;
        if (zustandAngaben == null) {
            return;
        }
        ContaminatedSites.putValue((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)zustandAngaben.getAltlasten());
        if (zustandAngaben.getAlter() != null && zustandAngaben.getAlter().getAlterAttr() != null) {
            alterAttr = zustandAngaben.getAlter().getAlterAttr();
            if (Alter.AlterAttr.ALTBAU.equals((Object)alterAttr)) {
                Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.OLD_BUILDING);
            } else if (Alter.AlterAttr.NEUBAU.equals((Object)alterAttr)) {
                Age.put((EstateImpl)estateImpl, (Age.Option)Age.Option.NEW_BUILDING);
            }
        }
        BuildYear.put((EstateImpl)estateImpl, (String)zustandAngaben.getBaujahr());
        if (zustandAngaben.getBebaubarNach() != null && zustandAngaben.getBebaubarNach().getBebaubarAttr() != null) {
            alterAttr = zustandAngaben.getBebaubarNach().getBebaubarAttr();
            if (BebaubarNach.BebaubarAttr.NACHBARSCHAFT.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.AUSSENGEBIET.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.BAUERWARTUNGSLAND.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.GREENFIELD_DEVELOPMENT);
            } else if (BebaubarNach.BebaubarAttr.B_PLAN.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.BINDING_SITE_PLAN);
            } else if (BebaubarNach.BebaubarAttr.KEIN_BAULAND.equals((Object)alterAttr)) {
                BuildableAccordingTo.put((EstateImpl)estateImpl, (BuildableAccordingTo.Option)BuildableAccordingTo.Option.NO_DEVELOPMENT_AREA);
            }
        }
        if (zustandAngaben.getErschliessung() != null && zustandAngaben.getErschliessung().getErschlAttr() != null) {
            alterAttr = zustandAngaben.getErschliessung().getErschlAttr();
            if (Erschliessung.ErschlAttr.TEILERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.PARTIALLY);
            } else if (Erschliessung.ErschlAttr.UNERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.UNDEVELOPED);
            } else if (Erschliessung.ErschlAttr.VOLLERSCHLOSSEN.equals((Object)alterAttr)) {
                Development.put((EstateImpl)estateImpl, (Development.Option)Development.Option.COMPLETELY);
            }
        }
        if (zustandAngaben.getZustand() != null && zustandAngaben.getZustand().getZustandArt() != null) {
            alterAttr = zustandAngaben.getZustand().getZustandArt();
            if (Zustand.ZustandArt.ABRISSOBJEKT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.CONDEMNED);
            } else if (Zustand.ZustandArt.BAUFAELLIG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.DILAPIDATED);
            } else if (Zustand.ZustandArt.ENTKERNT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.GUTTED);
            } else if (Zustand.ZustandArt.ERSTBEZUG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FIRST_OCCUPANCY);
            } else if (Zustand.ZustandArt.GEPFLEGT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.WELL_TENDED);
            } else if (Zustand.ZustandArt.MODERNISIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.MODERNIZED);
            } else if (Zustand.ZustandArt.NACH_VEREINBARUNG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_APPOINTED);
            } else if (Zustand.ZustandArt.NEUWERTIG.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.AS_GOOD_AS_NEW);
            } else if (Zustand.ZustandArt.PROJEKTIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PROJECTED);
            } else if (Zustand.ZustandArt.ROHBAU.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.SHELL_CONSTRUCTION);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_RENOVATED);
            } else if (Zustand.ZustandArt.TEIL_VOLLRENOVIERUNGSBED.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.PARTIAL_RENOVATION_REQUIRED);
            } else if (Zustand.ZustandArt.TEIL_VOLLSANIERT.equals((Object)alterAttr)) {
                ConditionType.put((EstateImpl)estateImpl, (ConditionType.Option)ConditionType.Option.FULLY_REFURBISHED);
            }
        }
        alterAttr = null;
        for (UserDefinedSimplefield userDefinedSimplefield : zustandAngaben.getUserDefinedSimplefield()) {
            if (!"epass_epart".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) continue;
            object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
            if ("bedarf".equalsIgnoreCase((String)object)) {
                alterAttr = Type.Option.DEMAND;
                break;
            }
            if (!"verbrauch".equalsIgnoreCase((String)object)) break;
            alterAttr = Type.Option.CONSUMPTION;
            break;
        }
        if (alterAttr != null) {
            Type.put((EstateImpl)estateImpl, (Type.Option)alterAttr);
            for (UserDefinedSimplefield userDefinedSimplefield : zustandAngaben.getUserDefinedSimplefield()) {
                Object object2;
                if ("epass_endenergiebedarf".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!Type.Option.DEMAND.equals((Object)alterAttr)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object2 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_endenergiebedarf' (" + (String)object + ") into a number!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object2 == null || (Double)object2 <= 0.0) continue;
                    DemandTotal.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    continue;
                }
                if ("epass_energieverbrauchkennwert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!Type.Option.CONSUMPTION.equals((Object)alterAttr)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object2 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_energieverbrauchkennwert' (" + (String)object + ") into a number!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object2 == null || (Double)object2 <= 0.0) continue;
                    ConsumptionTotal.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    continue;
                }
                if ("epass_stromwert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object2 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_stromwert' (" + (String)object + ") into a number!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object2 == null || (Double)object2 <= 0.0) continue;
                    if (Type.Option.DEMAND.equals((Object)alterAttr)) {
                        DemandElectricity.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                        continue;
                    }
                    if (!Type.Option.CONSUMPTION.equals((Object)alterAttr)) continue;
                    ConsumptionElectricity.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    continue;
                }
                if ("epass_waermewert".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    try {
                        if (object != null) {
                            object = ((String)object).replace(',', '.');
                        }
                        object2 = object != null ? Double.valueOf((String)object) : null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_waermewert' (" + (String)object + ") into a number!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object2 == null || (Double)object2 <= 0.0) continue;
                    if (Type.Option.DEMAND.equals((Object)alterAttr)) {
                        DemandHeating.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                        continue;
                    }
                    if (!Type.Option.CONSUMPTION.equals((Object)alterAttr)) continue;
                    ConsumptionHeating.put((EstateImpl)estateImpl, (Number)object2, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    continue;
                }
                if ("epass_wertklasse".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    if ("a+".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.A_PLUS;
                    } else if ("a".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.A;
                    } else if ("b".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.B;
                    } else if ("c".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.C;
                    } else if ("d".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.D;
                    } else if ("e".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.E;
                    } else if ("f".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.F;
                    } else if ("g".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.G;
                    } else if ("h".equalsIgnoreCase((String)object)) {
                        object2 = EfficiencyCategory.Option.H;
                    }
                    if (object2 == null) continue;
                    EfficiencyCategory.put((EstateImpl)estateImpl, (EfficiencyCategory.Option)object2);
                    continue;
                }
                if ("epass_baujahr".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    object = BuildYear.getAsInteger((EstateImpl)estateImpl);
                    if (object != null && (Integer)object > 0) continue;
                    object2 = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    try {
                        if (object2 != null) {
                            object = Integer.valueOf((String)object2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_baujahr' (" + (String)object2 + ") into an integer!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object == null || (Integer)object <= 0) continue;
                    BuildYear.put((EstateImpl)estateImpl, (Number)object);
                    continue;
                }
                if ("epass_mitwarmwasser".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) {
                    if (!Type.Option.CONSUMPTION.equals((Object)alterAttr)) continue;
                    object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                    object2 = null;
                    try {
                        object2 = "0".equalsIgnoreCase((String)object) ? Boolean.valueOf(false) : ("1".equalsIgnoreCase((String)object) ? Boolean.valueOf(true) : (object != null ? Boolean.valueOf((String)object) : null));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't convert 'epass_mitwarmwasser' (" + (String)object + ") into a boolean!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                    if (object2 == null) continue;
                    ConsumptionIncludingHotWater.put((EstateImpl)estateImpl, (Boolean)object2);
                    continue;
                }
                if (!"epass_gueltig_bis".equalsIgnoreCase(userDefinedSimplefield.getFeldname())) continue;
                object = StringUtils.trimToNull((String)userDefinedSimplefield.getContent());
                object2 = null;
                try {
                    object2 = OpenEstateUtils.parseDate((String)userDefinedSimplefield.getContent());
                }
                catch (ParseException parseException) {
                    LOGGER.warn("Can't convert 'epass_gueltig_bis' (" + (String)object + ") into a date!");
                    LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
                }
                if (object2 == null) continue;
                ExpirationDate.put((EstateImpl)estateImpl, (Date)object2);
            }
        }
    }
}

