/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.trovit.xml.types;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AreaUnitValue {
    FEET(new String[]{"feet"}),
    ACRES(new String[]{"acres"}),
    METERS(new String[]{"meters"}),
    HECTARES(new String[]{"hectares"});

    private static final Logger LOGGER;
    private final String[] aliases;

    private AreaUnitValue(String[] stringArray) {
        this.aliases = stringArray;
    }

    public static AreaUnitValue fromXmlValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (AreaUnitValue areaUnitValue : AreaUnitValue.values()) {
            if (areaUnitValue.name().equalsIgnoreCase(string)) {
                return areaUnitValue;
            }
            for (String string2 : areaUnitValue.aliases) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return areaUnitValue;
            }
        }
        return null;
    }

    public String write() {
        return this.aliases[0];
    }

    static {
        LOGGER = LoggerFactory.getLogger(AreaUnitValue.class);
    }
}

