/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.immobiliare_it;

import org.apache.commons.lang3.ArrayUtils;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.immobiliare_it.ImmobiliareItUtils;
import org.openestate.io.immobiliare_it.converters.ImmobiliareIt_2_5;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ImmobiliareItVersion implements XmlVersion
{
    V2_5(ImmobiliareIt_2_5.class, "2.5", "2.5.0");

    private static final Logger LOGGER;
    private final Class converterClass;
    private final String readableVersion;
    private final String[] alias;

    private ImmobiliareItVersion(Class clazz, String string2, String ... stringArray) {
        this.converterClass = clazz;
        this.readableVersion = string2;
        this.alias = stringArray;
    }

    public static ImmobiliareItVersion detectFromString(String string) {
        if (string != null) {
            for (ImmobiliareItVersion immobiliareItVersion : ImmobiliareItVersion.values()) {
                if (immobiliareItVersion.toReadableVersion().equalsIgnoreCase(string)) {
                    return immobiliareItVersion;
                }
                if (immobiliareItVersion.alias == null) continue;
                for (String string2 : immobiliareItVersion.alias) {
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return immobiliareItVersion;
                }
            }
        }
        return null;
    }

    public XmlConverter getConverter() {
        try {
            return (XmlConverter)this.converterClass.newInstance();
        }
        catch (Exception exception) {
            LOGGER.error("Can't create converter!");
            LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            return null;
        }
    }

    public ImmobiliareItVersion getNextVersion() {
        ImmobiliareItVersion[] immobiliareItVersionArray = ImmobiliareItVersion.values();
        int n = ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)((Object)this));
        return immobiliareItVersionArray.length > ++n ? immobiliareItVersionArray[n] : null;
    }

    public ImmobiliareItVersion getPreviousVersion() {
        ImmobiliareItVersion[] immobiliareItVersionArray = ImmobiliareItVersion.values();
        int n = ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)((Object)this));
        return --n >= 0 ? immobiliareItVersionArray[n] : null;
    }

    public boolean isLatestVersion() {
        return ImmobiliareItUtils.VERSION.equals((Object)this);
    }

    public boolean isNewerThen(XmlVersion xmlVersion) {
        ImmobiliareItVersion[] immobiliareItVersionArray = ImmobiliareItVersion.values();
        return ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)((Object)this)) > ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)xmlVersion);
    }

    public boolean isOlderThen(XmlVersion xmlVersion) {
        ImmobiliareItVersion[] immobiliareItVersionArray = ImmobiliareItVersion.values();
        return ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)((Object)this)) < ArrayUtils.indexOf((Object[])immobiliareItVersionArray, (Object)xmlVersion);
    }

    public String toReadableVersion() {
        return this.readableVersion;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ImmobiliareItVersion.class);
    }
}

