/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.kyero;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateException;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.administration.EffectiveDate;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.kyero.KyeroType;
import com.openindex.openestate.impl.utils.AbstractXmlReader;
import com.openindex.openestate.impl.values.AreaValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroLanguage;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.xml.ImagesType;
import org.openestate.io.kyero.xml.LangType;
import org.openestate.io.kyero.xml.PriceFreqType;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class KyeroReader
extends AbstractXmlReader<KyeroDocument, Root> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroReader.class);
    private Locale[] locales = OpenEstateUtils.getAvailableLocales();

    public KyeroReader() {
    }

    public KyeroReader(Locale locale) {
        this();
        this.setOpenEstateLanguage(locale);
    }

    protected AgentImpl convertAnbieter(Root.Agent agent) {
        AgentImpl agentImpl = this.createEmptyAgent();
        agentImpl.getCompany().setStreet(agent.getAddr1());
        agentImpl.getCompany().setStreet2(agent.getAddr2());
        agentImpl.getCompany().setCountry(KyeroReader.parseCountry(agent.getCountry()));
        agentImpl.getCompany().setCompanyMail(agent.getEmail());
        agentImpl.getCompany().setCompanyFax(agent.getFax());
        agentImpl.getCompany().setCompanyMobilePhone(agent.getMob());
        agentImpl.getCompany().setCompanyName(agent.getName());
        agentImpl.getCompany().setPostalCode(agent.getPostcode());
        agentImpl.getCompany().setRegion(agent.getRegion());
        agentImpl.getCompany().setCompanyPhone(agent.getTel());
        agentImpl.getCompany().setCity(agent.getTown());
        return agentImpl;
    }

    protected EstateImpl convertImmobilie(PropertyType propertyType, Map<String, AgentContactImpl> map) throws OpenEstateException {
        Object object;
        EstateImpl estateImpl = this.createEmptyEstate();
        OpenEstateType openEstateType = null;
        String string = StringUtils.trimToNull((String)propertyType.getType());
        Object object2 = KyeroType.values();
        int n = ((KyeroType[])object2).length;
        for (int i = 0; !(i >= n || ((KyeroType)((Object)(object = object2[i]))).getXmlValue().equalsIgnoreCase(string) && (openEstateType = ((KyeroType)((Object)object)).getType()) != null); ++i) {
        }
        if (openEstateType == null) {
            object2 = string.replaceAll("\\W", "").trim();
            for (OpenEstateType object3 : OpenEstateType.values()) {
                String string2 = object3.name().replaceAll("\\W", "").trim();
                if (string2.equalsIgnoreCase((String)object2)) {
                    openEstateType = object3;
                    break;
                }
                for (Locale locale2 : this.locales) {
                    String string3 = object3.getTranslation(locale2);
                    if (StringUtils.isBlank((CharSequence)string3) || !(string2 = string3.replaceAll("\\W", "").trim()).equalsIgnoreCase((String)object2)) continue;
                    openEstateType = object3;
                    break;
                }
                if (openEstateType != null) break;
            }
        }
        if (openEstateType == null) {
            throw new OpenEstateException("Unsupported kyero-type: " + string);
        }
        object2 = openEstateType.createImpl();
        if (object2 == null) {
            throw new OpenEstateException("Unsupported estate type: " + openEstateType);
        }
        OpenEstateAction openEstateAction = null;
        if (PriceFreqType.SALE.equals((Object)propertyType.getPriceFreq())) {
            openEstateAction = Boolean.TRUE.equals(propertyType.getLeasehold()) && object2.hasAction(OpenEstateAction.LEASE) ? OpenEstateAction.LEASE : OpenEstateAction.PURCHASE;
            estateImpl.setType(openEstateType, openEstateAction);
        } else if (PriceFreqType.WEEK.equals((Object)propertyType.getPriceFreq())) {
            openEstateAction = OpenEstateAction.RENT;
            estateImpl.setType(openEstateType, openEstateAction);
            RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.WEEK);
        } else if (PriceFreqType.MONTH.equals((Object)propertyType.getPriceFreq())) {
            openEstateAction = OpenEstateAction.RENT;
            estateImpl.setType(openEstateType, openEstateAction);
            RentFlatRatePer.put((EstateImpl)estateImpl, (RentFlatRatePer.Option)RentFlatRatePer.Option.MONTH);
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction) && !object2.hasAction(OpenEstateAction.RENT) && object2.hasAction(OpenEstateAction.SHORT_TERM_RENT)) {
            openEstateAction = OpenEstateAction.SHORT_TERM_RENT;
            estateImpl.setType(openEstateType, openEstateAction);
        }
        if (openEstateAction == null) {
            throw new OpenEstateException("Unknown estate-action!");
        }
        List<OpenEstateType> list = Arrays.asList(openEstateType.getParentPath());
        estateImpl.setId(propertyType.getId());
        estateImpl.setPublicId(propertyType.getRef());
        estateImpl.setCurrency(Currency.getInstance(propertyType.getCurrency() != null ? propertyType.getCurrency().value() : "EUR"));
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            PurchasePrice.put((EstateImpl)estateImpl, (Number)propertyType.getPrice());
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            RentExcludingServiceCharges.put((EstateImpl)estateImpl, (Number)propertyType.getPrice());
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            RentFlatRate.put((EstateImpl)estateImpl, (Number)propertyType.getPrice());
        } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction) || OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            Lease.put((EstateImpl)estateImpl, (Number)propertyType.getPrice());
        }
        if (propertyType.getSurfaceArea() != null) {
            PlotArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getPlot(), (AreaValue.Unit)AreaValue.Unit.SQM);
            if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                ResidentialArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            } else if (list.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
                CommercialArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            } else if (list.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
                UsableArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            } else if (list.contains(OpenEstateType.GENERAL_PARKING)) {
                CarParkingArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            } else if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                UsableArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            } else {
                TotalArea.put((EstateImpl)estateImpl, (Number)propertyType.getSurfaceArea().getBuilt(), (AreaValue.Unit)AreaValue.Unit.SQM);
            }
        }
        estateImpl.getAddress().setCity(propertyType.getTown());
        estateImpl.getAddress().setDistrict(propertyType.getLocationDetail());
        estateImpl.getAddress().setRegion(propertyType.getProvince());
        estateImpl.getAddress().setCountry(KyeroReader.parseCountry(propertyType.getCountry()));
        CountBathrooms.put((EstateImpl)estateImpl, (Number)propertyType.getBaths());
        CountBedrooms.put((EstateImpl)estateImpl, (Number)propertyType.getBeds());
        if (list.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            object = BigInteger.ZERO;
            if (propertyType.getBeds() != null && propertyType.getBeds().compareTo(BigInteger.ZERO) > 0) {
                object = ((BigInteger)object).add(propertyType.getBeds());
            }
            CountRooms.put((EstateImpl)estateImpl, (Number)object);
        }
        if (Boolean.TRUE.equals(propertyType.getPool())) {
            SwimmingPool.put((EstateImpl)estateImpl, (Boolean)true);
        }
        EffectiveDate.put((EstateImpl)estateImpl, (Calendar)propertyType.getDate());
        if (propertyType.getDesc() != null) {
            for (Object object3 : object = KyeroLanguage.getLanguages((LangType)propertyType.getDesc())) {
                String string4 = object3.toLanguageCode();
                this.putLanguage(estateImpl, string4);
                DetailledDescription.putValue((EstateImpl)estateImpl, (String)string4, (String)object3.getText(propertyType.getDesc()));
            }
        }
        if (propertyType.getImages() != null) {
            for (ImagesType.Image image : propertyType.getImages().getImage()) {
                EstateAttachmentImpl estateAttachmentImpl = this.createEmptyAttachment();
                estateAttachmentImpl.setFile(image.getUrl());
                estateImpl.getAttachments().add(estateAttachmentImpl);
            }
        }
        for (String string5 : estateImpl.getLanguages()) {
            Locale locale = null;
            for (Locale locale2 : OpenEstateUtils.getAvailableLocales()) {
                if (!locale2.getLanguage().equals(string5)) continue;
                locale = locale2;
                break;
            }
            if (locale == null) continue;
            estateImpl.setTitle(estateImpl.getFallbackTitle(locale), string5);
        }
        return estateImpl;
    }

    protected AgencyImpl convertToAgency(Root root) {
        AgentImpl agentImpl = root.getAgent() != null ? this.convertAnbieter(root.getAgent()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        AgencyImpl agencyImpl = this.createEmptyAgency();
        agencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (PropertyType object : root.getProperty()) {
            try {
                EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
                if (estateImpl == null) continue;
                agencyImpl.getEstates().put(estateImpl.getId(), estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn("could not read agency-estate!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            agencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        return agencyImpl;
    }

    protected TransferImpl convertToTransfer(Root root) {
        AgentImpl agentImpl = root.getAgent() != null ? this.convertAnbieter(root.getAgent()) : this.createEmptyAgent();
        agentImpl.setId("Agent.1");
        TransferImpl transferImpl = this.createEmptyTransfer();
        TransferAgencyImpl transferAgencyImpl = this.createEmptyTransferAgency();
        transferAgencyImpl.setRemoveUnmodifiedEstates(false);
        transferAgencyImpl.setAgent(agentImpl);
        HashMap<String, AgentContactImpl> hashMap = new HashMap<String, AgentContactImpl>();
        for (PropertyType object : root.getProperty()) {
            try {
                EstateImpl estateImpl = this.convertImmobilie(object, hashMap);
                if (estateImpl == null) continue;
                transferAgencyImpl.getEstatesToSave().add(estateImpl);
            }
            catch (Exception exception) {
                LOGGER.warn("could not read agency-estate!");
                LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            transferAgencyImpl.getContacts().put(entry.getKey(), entry.getValue());
        }
        transferImpl.getAgencies().add(transferAgencyImpl);
        return transferImpl;
    }

    protected KyeroDocument createXmlDocument(Document document) {
        return KyeroUtils.createDocument((Document)document);
    }

    protected static String parseCountry(String string) {
        String object;
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        if (string.length() == 2) {
            return string;
        }
        if (string.length() == 3 && (object = OpenEstateUtils.convertToIso2Country((String)string)) != null) {
            return object;
        }
        for (String string2 : Locale.getISOCountries()) {
            for (Locale locale : Locale.getAvailableLocales()) {
                String string3 = new Locale(string2.toLowerCase(), string2.toUpperCase()).getDisplayCountry(locale);
                if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)string3)) continue;
                return string2;
            }
        }
        return null;
    }

    private void putLanguage(EstateImpl estateImpl, String string) {
        if (!estateImpl.getLanguages().contains(string)) {
            estateImpl.getLanguages().add(string);
        }
    }
}

