/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.kyero;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.features.SwimmingPool;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.kyero.KyeroType;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.XmlVersion;
import org.openestate.io.kyero.KyeroDocument;
import org.openestate.io.kyero.KyeroLanguage;
import org.openestate.io.kyero.KyeroUtils;
import org.openestate.io.kyero.KyeroVersion;
import org.openestate.io.kyero.xml.CurrencyType;
import org.openestate.io.kyero.xml.ImagesType;
import org.openestate.io.kyero.xml.ObjectFactory;
import org.openestate.io.kyero.xml.PriceFreqType;
import org.openestate.io.kyero.xml.PropertyType;
import org.openestate.io.kyero.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KyeroWriter
extends AbstractXmlWriter<KyeroDocument, Root> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KyeroWriter.class);
    private static final ObjectFactory FACTORY = KyeroUtils.getFactory();
    public static final int MAX_IMAGES_PER_OBJECT = 50;
    public static final int MAX_FEATURES_PER_OBJECT = 50;
    private Date now;
    private String baseUrl = null;
    private boolean energyCertificateAppendedToDescription = false;
    private KyeroVersion version = KyeroUtils.VERSION;

    public KyeroWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public KyeroWriter(Locale locale) {
        this.now = new Date();
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected Root.Agent convertAgent(AgentImpl agentImpl) {
        Root.Agent agent = FACTORY.createRootAgent();
        agent.setAddr1(StringUtils.trimToNull((String)agentImpl.getCompany().getStreet()));
        agent.setAddr2(StringUtils.trimToNull((String)agentImpl.getCompany().getStreet2()));
        agent.setCountry(StringUtils.trimToNull((String)agentImpl.getCompany().writeCountry(Locale.ENGLISH)));
        agent.setEmail(StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMail()));
        agent.setFax(StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyFax()));
        agent.setMob(StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyMobilePhone()));
        agent.setName(StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyName()));
        agent.setPostcode(StringUtils.trimToNull((String)agentImpl.getCompany().getPostalCode()));
        agent.setRegion(StringUtils.trimToNull((String)agentImpl.getCompany().getRegion()));
        agent.setTel(StringUtils.trimToNull((String)agentImpl.getCompany().getCompanyPhone()));
        agent.setTown(StringUtils.trimToNull((String)agentImpl.getCompany().getCity()));
        return agent;
    }

    /*
     * WARNING - void declaration
     */
    protected PropertyType convertEstate(EstateImpl estateImpl, List<String> list) {
        void var11_27;
        String string;
        String string2;
        String string3;
        Object object;
        PropertyType propertyType = FACTORY.createPropertyType();
        KyeroType kyeroType = null;
        List<OpenEstateType> list2 = Arrays.asList(estateImpl.getType().getParentPath());
        for (int i = list2.size() - 1; i > -1; --i) {
            object = list2.get(i);
            for (KyeroType kyeroType2 : KyeroType.values()) {
                if (!kyeroType2.isWritable() || !kyeroType2.getType().equals(object)) continue;
                kyeroType = kyeroType2;
                break;
            }
            if (kyeroType != null) break;
        }
        if (kyeroType == null) {
            if (list2.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
                kyeroType = KyeroType.COMMERCIAL_PROPERTY;
            } else if (list2.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
                kyeroType = KyeroType.COUNTRY_HOUSE;
            } else if (list2.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                kyeroType = KyeroType.LAND;
            } else if (list2.contains(OpenEstateType.GENERAL_PARKING)) {
                kyeroType = KyeroType.GARAGE_PARKING_SPACE;
            } else if (list2.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                kyeroType = KyeroType.APARTMENT;
            }
        }
        if (kyeroType == null) {
            list.add("Immobilienart ist nicht exportierbar: " + estateImpl.getType());
            return null;
        }
        propertyType.setType(kyeroType.getXmlValue());
        if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
            propertyType.setPriceFreq(PriceFreqType.SALE);
            propertyType.setPrice(PurchasePrice.getAsLong((EstateImpl)estateImpl));
        } else if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
            propertyType.setLeasehold(Boolean.valueOf(true));
            propertyType.setPriceFreq(PriceFreqType.SALE);
            propertyType.setPrice(Lease.getAsLong((EstateImpl)estateImpl));
        } else if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) {
            propertyType.setPriceFreq(PriceFreqType.MONTH);
            propertyType.setPrice(RentExcludingServiceCharges.getAsLong((EstateImpl)estateImpl));
            if (propertyType.getPrice() == null) {
                propertyType.setPrice(RentIncludingServiceCharges.getAsLong((EstateImpl)estateImpl));
            }
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) {
            RentFlatRatePer.Option option = RentFlatRatePer.get((EstateImpl)estateImpl);
            if (RentFlatRatePer.Option.MONTH.equals((Object)option)) {
                propertyType.setPriceFreq(PriceFreqType.MONTH);
            } else if (RentFlatRatePer.Option.WEEK.equals((Object)option)) {
                propertyType.setPriceFreq(PriceFreqType.WEEK);
            }
            propertyType.setPrice(RentFlatRate.getAsLong((EstateImpl)estateImpl));
        }
        if (propertyType.getPriceFreq() == null) {
            list.add("Vermarktungsart ist nicht exportierbar: " + estateImpl.getAction());
            return null;
        }
        if (propertyType.getPrice() == null) {
            list.add("Kein Preis ermittelbar!");
            return null;
        }
        try {
            propertyType.setCurrency(CurrencyType.valueOf((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't export currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            list.add("W\u00e4hrung ist nicht exportierbar: " + estateImpl.getCurrency());
            return null;
        }
        propertyType.setId(StringUtils.trimToNull((String)estateImpl.getId()));
        propertyType.setRef((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)estateImpl.getPublicId()), (CharSequence)StringUtils.trimToNull((String)estateImpl.getId())));
        propertyType.setDate(Calendar.getInstance());
        propertyType.getDate().setTime(this.now);
        propertyType.setCountry(estateImpl.getAddress().writeCountry(Locale.ENGLISH));
        propertyType.setTown(StringUtils.trimToNull((String)estateImpl.getAddress().getCity()));
        propertyType.setLocationDetail(StringUtils.trimToNull((String)estateImpl.getAddress().getDistrict()));
        propertyType.setProvince((String)StringUtils.defaultIfBlank((CharSequence)StringUtils.trimToNull((String)estateImpl.getAddress().getRegion()), (CharSequence)StringUtils.trimToNull((String)estateImpl.getAddress().getCity())));
        if (!KyeroUtils.isValidRequiredType((String)propertyType.getTown())) {
            list.add("Ort ist nicht angegeben!");
            return null;
        }
        if (!KyeroUtils.isValidRequiredType((String)propertyType.getProvince())) {
            list.add("Region / Provinz ist nicht angegeben!");
            return null;
        }
        propertyType.setBaths(CountBathrooms.getAsBigInteger((EstateImpl)estateImpl));
        propertyType.setBeds(CountBedrooms.getAsBigInteger((EstateImpl)estateImpl));
        Boolean bl = SwimmingPool.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            propertyType.setPool(Boolean.valueOf(true));
        }
        propertyType.setSurfaceArea(FACTORY.createSurfaceType());
        propertyType.getSurfaceArea().setPlot(PlotArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        object = null;
        if (list2.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            object = UsableArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        } else if (list2.contains(OpenEstateType.GENERAL_COMMERCIAL)) {
            object = CommercialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        } else if (list2.contains(OpenEstateType.GENERAL_PARKING)) {
            object = CarParkingArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        } else if (list2.contains(OpenEstateType.GENERAL_RESIDENCE)) {
            object = ResidentialArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object == null || object.compareTo(BigInteger.ZERO) < 1) {
            object = TotalArea.getAsBigInteger((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        propertyType.getSurfaceArea().setBuilt((BigInteger)object);
        propertyType.setDesc(FACTORY.createLangType());
        for (KyeroLanguage kyeroLanguage : KyeroLanguage.values()) {
            String string4 = kyeroLanguage.toLanguageCode();
            string3 = StringUtils.trimToNull((String)DetailledDescription.get((EstateImpl)estateImpl, (String)string4));
            if (string3 == null) continue;
            if (this.isEnergyCertificateAppendedToDescription() && !StringUtils.isBlank((CharSequence)(string2 = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)kyeroLanguage.toLocale(), (String)this.getXmlLineSeparator())))) {
                string = this.getXmlLineSeparator() + this.getXmlLineSeparator() + StringUtils.repeat((String)"-", (int)15) + this.getXmlLineSeparator() + this.getXmlLineSeparator();
                string3 = StringUtils.trim((String)(string2 + string + string3));
            }
            kyeroLanguage.setText(propertyType.getDesc(), string3);
        }
        propertyType.setImages(FACTORY.createImagesType());
        String string5 = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string5 != null) {
            for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
                URI uRI;
                if (estateAttachmentImpl == null || !estateAttachmentImpl.isImageType() || (uRI = estateAttachmentImpl.getAbsoluteUrl(string5)) == null) continue;
                ImagesType.Image image = FACTORY.createImagesTypeImage();
                image.setUrl(uRI);
                image.setId(Integer.valueOf(propertyType.getImages().getImage().size() + 1));
                propertyType.getImages().getImage().add(image);
                if (propertyType.getImages().getImage().size() < 50) continue;
                break;
            }
        }
        propertyType.setFeatures(FACTORY.createFeaturesType());
        OpenEstateAttrib[] openEstateAttribArray = OpenEstateAttribGroup.FEATURES.getAttributes();
        int n = openEstateAttribArray.length;
        boolean bl2 = false;
        while (var11_27 < n) {
            OpenEstateAttrib openEstateAttrib = openEstateAttribArray[var11_27];
            if (!OpenEstateAttrib.FEATURES_SWIMMING_POOL.equals((Object)openEstateAttrib) && estateImpl.hasAttribute(openEstateAttrib)) {
                string3 = estateImpl.getAttribute(openEstateAttrib);
                string2 = StringUtils.trimToNull((String)openEstateAttrib.getTranslation(Locale.ENGLISH));
                if (string2 != null) {
                    if (string3 instanceof SimpleBooleanAttrib) {
                        string = (SimpleBooleanAttrib)string3;
                        if (Boolean.TRUE.equals(string.getValue())) {
                            propertyType.getFeatures().getFeature().add(string2);
                        }
                    } else if (string3 instanceof SimpleEnumAttrib) {
                        string = StringUtils.trimToNull((String)string3.getFormattedValue(Locale.ENGLISH));
                        if (string != null) {
                            propertyType.getFeatures().getFeature().add(string2 + ": " + string);
                        }
                    } else if (string3 instanceof ComplexEnumAttrib && (string = StringUtils.trimToNull((String)string3.getFormattedValue(Locale.ENGLISH))) != null) {
                        propertyType.getFeatures().getFeature().add(string2 + ": " + string);
                    }
                    if (propertyType.getFeatures().getFeature().size() >= 50) break;
                }
            }
            ++var11_27;
        }
        if (propertyType.getFeatures().getFeature().isEmpty()) {
            propertyType.getFeatures().getFeature().add("No features provided");
        }
        return propertyType;
    }

    protected Root convertToXmlObject(AgencyImpl agencyImpl) {
        Root root = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("no agency was provided!");
            return root;
        }
        root.setAgent(this.convertAgent(agencyImpl.getAgent()));
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                ArrayList<String> arrayList = new ArrayList<String>();
                PropertyType propertyType = this.convertEstate(estateImpl, arrayList);
                if (!arrayList.isEmpty() || propertyType == null) {
                    this.putErrors(estateImpl.getId(), arrayList);
                    continue;
                }
                root.getProperty().add(propertyType);
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return root;
    }

    protected Root convertToXmlObject(TransferImpl transferImpl) {
        Root root = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("no transfer was provided!");
        } else if (transferImpl.getAgencies().isEmpty()) {
            LOGGER.warn("no transferable agent found!");
        } else {
            TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().get(0);
            root.setAgent(this.convertAgent(transferAgencyImpl.getAgent()));
            for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    PropertyType propertyType = this.convertEstate(estateImpl, arrayList);
                    if (!arrayList.isEmpty() || propertyType == null) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    root.getProperty().add(propertyType);
                }
                catch (Exception exception) {
                    LOGGER.error("Fehler beim Parsen der Immobilie!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return root;
    }

    protected KyeroDocument createXmlDocument(Root root) throws ParserConfigurationException, JAXBException {
        KyeroDocument kyeroDocument = KyeroDocument.newDocument((Root)root);
        if (this.version != null && !this.version.isLatestVersion()) {
            kyeroDocument.downgrade((XmlVersion)this.version);
        }
        return kyeroDocument;
    }

    protected Root createRoot() {
        Root root = FACTORY.createRoot();
        root.setKyero(FACTORY.createKyeroType());
        root.getKyero().setFeedVersion(KyeroUtils.VERSION.toXmlVersion());
        root.getKyero().setFeedGenerated(Calendar.getInstance());
        root.getKyero().getFeedGenerated().setTime(this.now);
        return root;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public KyeroVersion getVersion() {
        return this.version;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }

    public void setVersion(KyeroVersion kyeroVersion) {
        this.version = kyeroVersion;
    }
}

