/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.idx;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.core.CsvPrinter;
import org.openestate.io.idx.IdxFormat;
import org.openestate.io.idx.IdxRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdxPrinter
extends CsvPrinter<IdxRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdxPrinter.class);

    protected IdxPrinter(CSVPrinter cSVPrinter) {
        super(cSVPrinter);
    }

    public static IdxPrinter create(StringBuffer stringBuffer) throws IOException {
        return (IdxPrinter)new IdxFormat().print(stringBuffer);
    }

    public static IdxPrinter create(StringBuilder stringBuilder) throws IOException {
        return (IdxPrinter)new IdxFormat().print(stringBuilder);
    }

    public static IdxPrinter create(File file) throws IOException {
        return (IdxPrinter)new IdxFormat().print(file);
    }

    public static IdxPrinter create(OutputStream outputStream) throws IOException {
        return (IdxPrinter)new IdxFormat().print(outputStream);
    }

    public static IdxPrinter create(Writer writer) throws IOException {
        return (IdxPrinter)new IdxFormat().print(writer);
    }

    protected void print(String string) throws IOException {
        string = StringUtils.trimToNull((String)string);
        string = StringUtils.replace((String)string, (String)"#", (String)"");
        string = CsvPrinter.replaceLineBreaks((String)string, (String)"<br>");
        super.print(string);
    }
}

