/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.ComplexCurrencyAttrib;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexLengthAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.ComplexVolumeAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.SimpleNumericAttrib;
import com.openindex.openestate.impl.attribs.SimpleTimeAttrib;
import com.openindex.openestate.impl.types.AbstractTypeImpl;
import com.openindex.openestate.impl.utils.JAreaValueField;
import com.openindex.openestate.impl.utils.JLengthValueField;
import com.openindex.openestate.impl.utils.JVolumeValueField;
import com.openindex.openestate.impl.values.CurrencyValue;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.gui.DefaultDatePicker;
import com.openindex.openestate.tool.gui.DefaultSelectButton;
import com.openindex.openestate.tool.gui.DefaultTreeTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateValueTable
extends DefaultTreeTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateValueTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateValueTable.class);
    private OpenEstateAction loadedEstateAction = null;
    private OpenEstateType loadedEstateType = null;
    private String loadedEstateCountry = null;
    private boolean isModified = false;
    private Model model;

    public AgencyEstateValueTable() {
        this.build();
    }

    private void build() {
        this.model = new Model();
        this.setTreeTableModel((TreeTableModel)this.model);
        this.setRootVisible(false);
        this.setDefaultRenderer(AbstractAttribImpl.class, new NodeValueRenderer());
        this.setDefaultRenderer(ValueInfo.class, new ValueInfoRenderer());
        this.setDefaultEditor(AbstractAttribImpl.class, new NodeValueEditor());
        this.getSelectionModel().setSelectionMode(0);
        this.setToggleClickCount(2);
        this.setTerminateEditOnFocusLost(true);
        this.setShowGrid(true);
        this.setRowMargin(1);
        this.setColumnMargin(1);
        this.setFocusCycleRoot(false);
        this.getActionMap().put("moveToNextRow", this.moveToNextRow());
        this.getActionMap().put("moveToLastRow", this.moveToLastRow());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "moveToNextRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 1), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 1), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "moveToLastRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "moveToLastRow");
    }

    public void loadEstate(EstateImpl estateImpl, String string) {
        this.setEnabled(false);
        if (estateImpl == null) {
            throw new NullPointerException("invalid estate!");
        }
        if (estateImpl.getType() == null) {
            return;
        }
        if (estateImpl.getAction() == null) {
            return;
        }
        if (!estateImpl.getType().equals((Object)this.loadedEstateType) || !estateImpl.getAction().equals((Object)this.loadedEstateAction)) {
            this.loadEstateType(estateImpl.getType(), estateImpl.getAction(), string, false);
        }
        Node node = this.model.getRootNode();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            for (int j = 0; j < node2.getChildCount(); ++j) {
                Node node3 = (Node)node2.getChildAt(j);
                AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)node3.getValueAt(1);
                if (estateImpl.hasAttribute(abstractAttribImpl.getAttrib())) {
                    abstractAttribImpl.setValue(estateImpl.getAttribute(abstractAttribImpl.getAttrib()).getValue());
                    continue;
                }
                abstractAttribImpl.setValue(null);
            }
        }
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 1);
        }
        this.setEnabled(true);
        this.isModified = false;
    }

    /*
     * WARNING - void declaration
     */
    public void loadEstateType(OpenEstateType openEstateType, OpenEstateAction openEstateAction, String string, boolean bl) {
        Object object;
        Object object2;
        AbstractTypeImpl abstractTypeImpl = openEstateType != null ? openEstateType.createImpl() : null;
        EnumMap<OpenEstateAttrib, Object> enumMap = new EnumMap<OpenEstateAttrib, Object>(OpenEstateAttrib.class);
        if (this.model != null) {
            object2 = this.model.getRootNode();
            if (bl) {
                for (int i = 0; i < object2.getChildCount(); ++i) {
                    object = (Node)object2.getChildAt(i);
                    for (int j = 0; j < object.getChildCount(); ++j) {
                        Node node = (Node)object.getChildAt(j);
                        AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)node.getValueAt(1);
                        if (abstractAttribImpl.hasEmptyValue()) continue;
                        enumMap.put(abstractAttribImpl.getAttrib(), abstractAttribImpl.getValue());
                    }
                }
            }
        }
        this.loadedEstateAction = null;
        this.loadedEstateType = null;
        this.loadedEstateCountry = null;
        this.model = new Model();
        object2 = new TreeMap();
        Node node = new Node(1);
        this.model.getRootNode().add((MutableTreeTableNode)node);
        object = new TreeMap();
        for (OpenEstateAttribGroup object3 : OpenEstateAttribGroup.values()) {
            String string2 = (String)StringUtils.defaultIfBlank((CharSequence)object3.getTranslation(), (CharSequence)object3.name());
            object.put(string2.toLowerCase(), object3);
        }
        for (OpenEstateAttribGroup openEstateAttribGroup : object.values()) {
            void var13_25;
            if (OpenEstateAttribGroup.DESCRIPTIONS.equals((Object)openEstateAttribGroup) || OpenEstateAttribGroup.ENERGY_CERTIFICATE.equals((Object)openEstateAttribGroup)) continue;
            TreeMap<String, OpenEstateAttrib> treeMap = new TreeMap<String, OpenEstateAttrib>();
            for (OpenEstateAttrib openEstateAttrib2 : abstractTypeImpl.getAttribs(openEstateAction, new OpenEstateAttribGroup[]{openEstateAttribGroup})) {
                AbstractAttribImpl abstractAttribImpl = openEstateAttrib2.createImpl();
                if (abstractAttribImpl instanceof ComplexStringAttrib || !StringUtils.isBlank((CharSequence)string) && !abstractAttribImpl.isCountrySupported(string)) continue;
                String string3 = (String)StringUtils.defaultIfBlank((CharSequence)openEstateAttrib2.getTranslation(), (CharSequence)openEstateAttrib2.name());
                if (abstractTypeImpl.isAttribRequired(openEstateAttrib2)) {
                    object2.put(string3.toLowerCase(), openEstateAttrib2);
                    continue;
                }
                treeMap.put(string3.toLowerCase(), openEstateAttrib2);
            }
            Object var13_24 = null;
            for (OpenEstateAttrib openEstateAttrib : treeMap.values()) {
                OpenEstateAttrib openEstateAttrib2;
                if (var13_25 == null) {
                    Node node2 = new Node(openEstateAttribGroup);
                }
                openEstateAttrib2 = openEstateAttrib.createImpl();
                if (enumMap.containsKey(openEstateAttrib)) {
                    openEstateAttrib2.setValue(enumMap.get(openEstateAttrib));
                } else if (abstractTypeImpl.isAttribRequired(openEstateAttrib)) {
                    openEstateAttrib2.setValue(openEstateAttrib2.getDefaultValue());
                }
                var13_25.add((MutableTreeTableNode)new Node((AbstractAttribImpl)openEstateAttrib2, false));
            }
            if (var13_25 == null) continue;
            this.model.getRootNode().add((MutableTreeTableNode)var13_25);
        }
        for (OpenEstateAttrib openEstateAttrib : object2.values()) {
            AbstractAttribImpl abstractAttribImpl = openEstateAttrib.createImpl();
            if (enumMap.containsKey(openEstateAttrib)) {
                abstractAttribImpl.setValue(enumMap.get(openEstateAttrib));
            } else if (abstractTypeImpl.isAttribRequired(openEstateAttrib)) {
                abstractAttribImpl.setValue(abstractAttribImpl.getDefaultValue());
            }
            node.add((MutableTreeTableNode)new Node(abstractAttribImpl, true));
        }
        this.setTreeTableModel((TreeTableModel)this.model);
        this.loadedEstateAction = openEstateAction;
        this.loadedEstateType = openEstateType;
        this.loadedEstateCountry = string;
        this.packColumn(0, 5);
        this.packColumn(2, 5);
    }

    public boolean hasModifications() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        return this.isModified;
    }

    public boolean hasRequiredInputs() {
        Node node = this.model.getRootNode();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            if (1 != node2.nodeType) continue;
            for (int j = 0; j < node2.getChildCount(); ++j) {
                Node node3 = (Node)node2.getChildAt(j);
                AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)node3.getValueAt(1);
                if (!abstractAttribImpl.hasEmptyValue()) continue;
                return false;
            }
        }
        return true;
    }

    private AbstractAction moveToLastRow() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateValueTable.this.getSelectedRow() - 1;
                if (n < 0) {
                    return;
                }
                AgencyEstateValueTable.this.editingStopped(new ChangeEvent(this));
                AgencyEstateValueTable.this.setRowSelectionInterval(n, n);
                AgencyEstateValueTable.this.editCellAt(n, 1);
                AgencyEstateValueTable.this.scrollRowToVisible(n);
                AgencyEstateValueTable.this.repaint();
            }
        };
    }

    private AbstractAction moveToNextRow() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AgencyEstateValueTable.this.getSelectedRow() + 1;
                if (n >= AgencyEstateValueTable.this.getRowCount()) {
                    return;
                }
                AgencyEstateValueTable.this.editingStopped(new ChangeEvent(this));
                AgencyEstateValueTable.this.setRowSelectionInterval(n, n);
                AgencyEstateValueTable.this.editCellAt(n, 1);
                AgencyEstateValueTable.this.scrollRowToVisible(n);
                AgencyEstateValueTable.this.repaint();
            }
        };
    }

    public void saveEstate(EstateImpl estateImpl) {
        if (estateImpl == null) {
            throw new NullPointerException("invalid estate!");
        }
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        Node node = this.model.getRootNode();
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node node2 = (Node)node.getChildAt(i);
            for (int j = 0; j < node2.getChildCount(); ++j) {
                Node node3 = (Node)node2.getChildAt(j);
                AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)node3.getValueAt(1);
                if (!abstractAttribImpl.hasEmptyValue()) {
                    estateImpl.putAttribute(abstractAttribImpl);
                    continue;
                }
                estateImpl.removeAttribute(abstractAttribImpl.getAttrib());
            }
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.repaint();
    }

    static /* synthetic */ boolean access$1002(AgencyEstateValueTable agencyEstateValueTable, boolean bl) {
        agencyEstateValueTable.isModified = bl;
        return agencyEstateValueTable.isModified;
    }

    private class ValueInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        private String lastCountryCode = null;
        private ImageIcon lastCountryIcon = null;

        private ValueInfoRenderer() {
            this.setHorizontalTextPosition(10);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof ValueInfo) {
                ValueInfo valueInfo = (ValueInfo)object;
                this.setText(valueInfo.infoText);
                this.setIcon(null);
                if (valueInfo.infoCountrySpecific) {
                    if (AgencyEstateValueTable.this.loadedEstateCountry == null) {
                        LOGGER.warn("can't load flag-icon, no country was selected!");
                    } else if (this.lastCountryCode != null && this.lastCountryCode.equalsIgnoreCase(AgencyEstateValueTable.this.loadedEstateCountry)) {
                        this.setIcon(this.lastCountryIcon);
                    } else {
                        this.lastCountryCode = AgencyEstateValueTable.this.loadedEstateCountry;
                        this.lastCountryIcon = OpenEstateUtils.getFlagIcon((String)AgencyEstateValueTable.this.loadedEstateCountry);
                        if (this.lastCountryIcon == null) {
                            LOGGER.warn("can't load flag-icon, icon is null: " + AgencyEstateValueTable.this.loadedEstateCountry);
                        } else {
                            this.setIcon(this.lastCountryIcon);
                        }
                    }
                }
            } else {
                this.setText("");
                this.setIcon(null);
            }
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            return this;
        }
    }

    private static final class ValueInfo {
        private final String infoText;
        private final boolean infoCountrySpecific;

        private ValueInfo(String string, boolean bl) {
            this.infoText = string;
            this.infoCountrySpecific = bl;
        }
    }

    private class NodeValueRenderer
    extends JLabel
    implements TableCellRenderer {
        private NodeValueRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText("");
            this.setIcon(null);
            this.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            this.setForeground(bl ? jTable.getSelectionForeground() : jTable.getForeground());
            AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)object;
            if (abstractAttribImpl == null || abstractAttribImpl.hasEmptyValue()) {
                return this;
            }
            if (AgencyEstateValueTable.this.loadedEstateCountry != null && abstractAttribImpl.isCountrySpecific() && abstractAttribImpl.isCountrySupported(AgencyEstateValueTable.this.loadedEstateCountry)) {
                Locale locale = new Locale(AgencyEstateValueTable.this.loadedEstateCountry.toLowerCase(), AgencyEstateValueTable.this.loadedEstateCountry.toUpperCase());
                this.setIcon(ImmoToolUtils.getCountryFlagIcon((Locale)locale));
            }
            this.setText(abstractAttribImpl.getFormattedValue(Locale.getDefault(), ", "));
            return this;
        }
    }

    private class NodeValueEditor
    implements TableCellEditor {
        private final List<CellEditorListener> listeners = new ArrayList<CellEditorListener>();
        private JComponent component = null;
        private AbstractAttribImpl value = null;

        private NodeValueEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component = null;
            this.value = (AbstractAttribImpl)object;
            if (this.value == null || this.value.getAttrib() == null) {
                this.component = new JLabel("");
            } else if (this.value instanceof ComplexEnumAttrib) {
                ComplexEnumAttrib complexEnumAttrib = (ComplexEnumAttrib)this.value;
                DefaultSelectButton defaultSelectButton = new DefaultSelectButton(1);
                TreeMap<String, Enum> treeMap = new TreeMap<String, Enum>();
                for (Enum enum_ : complexEnumAttrib.getOptions()) {
                    String string = (String)StringUtils.defaultIfBlank((CharSequence)complexEnumAttrib.getOptionTranslation(enum_), (CharSequence)enum_.name());
                    treeMap.put(string, enum_);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    Enum enum_;
                    String string = (String)entry.getKey();
                    enum_ = (Enum)entry.getValue();
                    defaultSelectButton.addOption(enum_.name(), string);
                    if (!complexEnumAttrib.hasOption(enum_)) continue;
                    defaultSelectButton.setSelected(enum_.name(), true);
                }
                defaultSelectButton.updateText();
                this.component = defaultSelectButton;
            } else if (this.value instanceof ComplexAreaAttrib) {
                ComplexAreaAttrib complexAreaAttrib = (ComplexAreaAttrib)this.value;
                JAreaValueField jAreaValueField = new JAreaValueField();
                jAreaValueField.setValue(complexAreaAttrib.getValue());
                jAreaValueField.getUnitSpinner().setBorder(Paddings.EMPTY);
                jAreaValueField.getValueField().setBorder(Paddings.EMPTY);
                jAreaValueField.getValueField().selectAll();
                this.component = jAreaValueField;
            } else if (this.value instanceof ComplexCurrencyAttrib) {
                ComplexCurrencyAttrib complexCurrencyAttrib = (ComplexCurrencyAttrib)this.value;
                NumberFormat numberFormat = complexCurrencyAttrib.getFormat();
                JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
                jFormattedTextField.setFocusLostBehavior(0);
                if (complexCurrencyAttrib.getValue() != null) {
                    jFormattedTextField.setValue(complexCurrencyAttrib.getValue());
                    jFormattedTextField.selectAll();
                }
                this.component = jFormattedTextField;
            } else if (this.value instanceof ComplexLengthAttrib) {
                ComplexLengthAttrib complexLengthAttrib = (ComplexLengthAttrib)this.value;
                JLengthValueField jLengthValueField = new JLengthValueField();
                jLengthValueField.setValue(complexLengthAttrib.getValue());
                jLengthValueField.getUnitSpinner().setBorder(Paddings.EMPTY);
                jLengthValueField.getValueField().setBorder(Paddings.EMPTY);
                jLengthValueField.getValueField().selectAll();
                this.component = jLengthValueField;
            } else if (this.value instanceof ComplexStringAttrib) {
                ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)this.value;
                JTextField jTextField = new JTextField();
                if (complexStringAttrib.hasValueForLanguage(Locale.getDefault().getLanguage())) {
                    jTextField.setText(complexStringAttrib.getValue(Locale.getDefault().getLanguage()));
                    jTextField.selectAll();
                }
                this.component = jTextField;
            } else if (this.value instanceof ComplexVolumeAttrib) {
                ComplexVolumeAttrib complexVolumeAttrib = (ComplexVolumeAttrib)this.value;
                JVolumeValueField jVolumeValueField = new JVolumeValueField();
                jVolumeValueField.setValue(complexVolumeAttrib.getValue());
                jVolumeValueField.getUnitSpinner().setBorder(Paddings.EMPTY);
                jVolumeValueField.getValueField().setBorder(Paddings.EMPTY);
                jVolumeValueField.getValueField().selectAll();
                this.component = jVolumeValueField;
            } else if (this.value instanceof SimpleBooleanAttrib) {
                SimpleBooleanAttrib simpleBooleanAttrib = (SimpleBooleanAttrib)this.value;
                DefaultSelectButton defaultSelectButton = new DefaultSelectButton(0);
                defaultSelectButton.addOption("", " - ");
                defaultSelectButton.addOption(Boolean.FALSE.toString(), " " + I18N.tr("no") + " ");
                defaultSelectButton.addOption(Boolean.TRUE.toString(), " " + I18N.tr("yes") + " ");
                if (simpleBooleanAttrib.getValue() != null) {
                    Boolean bl2 = simpleBooleanAttrib.getValue();
                    defaultSelectButton.setSelected(bl2.toString(), true);
                } else {
                    defaultSelectButton.setSelected("", true);
                }
                defaultSelectButton.updateText();
                this.component = defaultSelectButton;
            } else if (this.value instanceof SimpleEnumAttrib) {
                SimpleEnumAttrib simpleEnumAttrib = (SimpleEnumAttrib)this.value;
                DefaultSelectButton defaultSelectButton = new DefaultSelectButton(0);
                defaultSelectButton.addOption("", " - ");
                TreeMap<String, Enum> treeMap = new TreeMap<String, Enum>();
                for (Enum enum_ : simpleEnumAttrib.getOptions()) {
                    String string = (String)StringUtils.defaultIfBlank((CharSequence)simpleEnumAttrib.getOptionTranslation(enum_), (CharSequence)enum_.name());
                    treeMap.put(string, enum_);
                }
                for (Map.Entry entry : treeMap.entrySet()) {
                    Enum enum_;
                    String string = (String)entry.getKey();
                    enum_ = (Enum)entry.getValue();
                    defaultSelectButton.addOption(enum_.name(), string);
                    if (!enum_.equals(simpleEnumAttrib.getValue())) continue;
                    defaultSelectButton.setSelected(enum_.name(), true);
                }
                defaultSelectButton.updateText();
                this.component = defaultSelectButton;
            } else if (this.value instanceof SimpleNumericAttrib) {
                SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)this.value;
                NumberFormat numberFormat = simpleNumericAttrib.getFormat();
                JFormattedTextField jFormattedTextField = new JFormattedTextField(numberFormat);
                jFormattedTextField.setFocusLostBehavior(0);
                if (simpleNumericAttrib.getValue() != null) {
                    jFormattedTextField.setValue(simpleNumericAttrib.getValue());
                    jFormattedTextField.selectAll();
                }
                this.component = jFormattedTextField;
            } else if (this.value instanceof SimpleTimeAttrib) {
                SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)this.value;
                DefaultDatePicker defaultDatePicker = new DefaultDatePicker();
                if (simpleTimeAttrib.getValue() != null) {
                    defaultDatePicker.setDate(simpleTimeAttrib.getValue());
                }
                defaultDatePicker.getEditor().setFocusLostBehavior(0);
                this.component = defaultDatePicker;
            }
            if (this.component != null) {
                this.component.setBackground(Color.WHITE);
                this.component.setOpaque(true);
                if (this.component instanceof DefaultSelectButton) {
                    this.component.setBorder(BorderFactory.createRaisedBevelBorder());
                } else {
                    this.component.setBorder(Paddings.EMPTY);
                }
            }
            return this.component;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Object getCellEditorValue() {
            if (this.component == null || this.value == null) {
                return null;
            }
            if (this.value instanceof ComplexEnumAttrib) {
                var1_1 = (ComplexEnumAttrib)this.value;
                var2_11 = (DefaultSelectButton)this.component;
                var3_21 = var2_11.getSelectedKeys();
                var1_1.setValue(null);
                if (!ArrayUtils.isEmpty((Object[])var3_21)) {
                    for (Object var7_29 : var3_21) {
                        var8_30 = var1_1.getOption((String)var7_29);
                        if (var8_30 == null) continue;
                        var1_1.putOption(var8_30);
                    }
                }
            } else if (this.value instanceof ComplexAreaAttrib) {
                var1_2 = (ComplexAreaAttrib)this.value;
                var2_12 = (JAreaValueField)this.component;
                var1_2.setValue(var2_12.getValue());
            } else if (this.value instanceof ComplexCurrencyAttrib) {
                var1_3 = (ComplexCurrencyAttrib)this.value;
                var2_13 = (JFormattedTextField)this.component;
                try {
                    var2_13.commitEdit();
                    if (var2_13.isEditValid()) {
                        var1_3.setValue(CurrencyValue.parse((Object)var2_13.getValue(), null));
                    }
                }
                catch (Exception var3_22) {
                    var1_3.setValue(null);
                }
            } else if (this.value instanceof ComplexLengthAttrib) {
                var1_4 = (ComplexLengthAttrib)this.value;
                var2_14 = (JLengthValueField)this.component;
                var1_4.setValue(var2_14.getValue());
            } else if (this.value instanceof ComplexStringAttrib) {
                var1_5 = (ComplexStringAttrib)this.value;
                var2_15 = (JTextField)this.component;
                var1_5.putValue(Locale.getDefault().getLanguage(), StringUtils.trimToNull((String)var2_15.getText()));
            } else if (this.value instanceof ComplexVolumeAttrib) {
                var1_6 = (ComplexVolumeAttrib)this.value;
                var2_16 = (JVolumeValueField)this.component;
                var1_6.setValue(var2_16.getValue());
            } else if (this.value instanceof SimpleBooleanAttrib) {
                var1_7 = (SimpleBooleanAttrib)this.value;
                var2_17 = (DefaultSelectButton)this.component;
                if (Boolean.TRUE.toString().equals(var2_17.getSelectedKey())) {
                    var1_7.setValue(Boolean.valueOf(true));
                } else if (Boolean.FALSE.toString().equals(var2_17.getSelectedKey())) {
                    var1_7.setValue(Boolean.valueOf(false));
                } else {
                    var1_7.setValue(null);
                }
            } else if (this.value instanceof SimpleEnumAttrib) {
                var1_8 = (SimpleEnumAttrib)this.value;
                var2_18 = (DefaultSelectButton)this.component;
                var3_23 = var2_18.getSelectedKey();
                var1_8.setValue(StringUtils.isBlank((CharSequence)var3_23) == false ? var1_8.getOption(var3_23) : null);
            } else if (this.value instanceof SimpleNumericAttrib) {
                var1_9 = (SimpleNumericAttrib)this.value;
                var2_19 = (JFormattedTextField)this.component;
                try {
                    var2_19.commitEdit();
                    if (var2_19.isEditValid()) {
                        var1_9.setValue((Number)var2_19.getValue());
                    }
                }
                catch (Exception var3_24) {
                    var1_9.setValue(null);
                }
            } else if (this.value instanceof SimpleTimeAttrib) {
                var1_10 = (SimpleTimeAttrib)this.value;
                var2_20 = (DefaultDatePicker)this.component;
                try {
                    var2_20.commitEdit();
                    if (!var2_20.isEditValid()) ** GOTO lbl87
                    var1_10.setValue(var2_20.getDate());
                }
                catch (Exception var3_25) {
                    var1_10.setValue(null);
                }
            }
            AgencyEstateValueTable.access$1002(AgencyEstateValueTable.this, true);
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
            return true;
        }

        @Override
        public void cancelCellEditing() {
            for (CellEditorListener cellEditorListener : this.listeners.toArray(new CellEditorListener[0])) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.add(cellEditorListener);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }
    }

    private static class Node
    extends AbstractMutableTreeTableNode {
        public static final int ROOT = 0;
        public static final int GROUP_REQUIRED = 1;
        public static final int GROUP_GENERAL = 2;
        public static final int VALUE = 3;
        private final int nodeType;
        private Object nodeValue = null;
        private boolean nodeValueRequired = false;

        private Node() {
            this.nodeType = 0;
            this.nodeValue = null;
        }

        private Node(int n) {
            this.nodeType = n;
        }

        private Node(OpenEstateAttribGroup openEstateAttribGroup) {
            this.nodeType = 2;
            this.nodeValue = openEstateAttribGroup;
        }

        private Node(AbstractAttribImpl abstractAttribImpl, boolean bl) {
            this.nodeType = 3;
            this.nodeValue = abstractAttribImpl;
            this.nodeValueRequired = bl;
        }

        public Object getValueAt(int n) {
            if (this.nodeType == 0) {
                switch (n) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 1) {
                switch (n) {
                    case 0: {
                        return "<html><b>" + StringUtils.capitalize((String)I18N.tr("required fields")) + "</b></html>";
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 2) {
                switch (n) {
                    case 0: {
                        return "<html><b>" + StringUtils.capitalize((String)((OpenEstateAttribGroup)this.nodeValue).getTranslation()) + "</b></html>";
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
            if (this.nodeType == 3) {
                AbstractAttribImpl abstractAttribImpl = (AbstractAttribImpl)this.nodeValue;
                switch (n) {
                    case 0: {
                        if (this.nodeValueRequired) {
                            return "<html><u>" + abstractAttribImpl.getAttrib().getTranslation() + "</u></html>";
                        }
                        return "<html>" + abstractAttribImpl.getAttrib().getTranslation() + "</html>";
                    }
                    case 1: {
                        return abstractAttribImpl;
                    }
                    case 2: {
                        String string = null;
                        if (abstractAttribImpl instanceof ComplexAreaAttrib) {
                            string = I18N.tr("area");
                        } else if (abstractAttribImpl instanceof ComplexCurrencyAttrib) {
                            string = I18N.tr("price");
                        } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                            string = I18N.tr("selection (multiple)");
                        } else if (abstractAttribImpl instanceof ComplexLengthAttrib) {
                            string = I18N.tr("length");
                        } else if (abstractAttribImpl instanceof ComplexStringAttrib) {
                            string = I18N.tr("text");
                        } else if (abstractAttribImpl instanceof ComplexVolumeAttrib) {
                            string = I18N.tr("volume");
                        } else if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                            string = I18N.tr("selection (yes/no)");
                        } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                            string = I18N.tr("selection (single)");
                        } else if (abstractAttribImpl instanceof SimpleNumericAttrib) {
                            SimpleNumericAttrib simpleNumericAttrib = (SimpleNumericAttrib)abstractAttribImpl;
                            string = simpleNumericAttrib.getPrecision() > 0 ? I18N.tr("any number") : I18N.tr("integer");
                        } else if (abstractAttribImpl instanceof SimpleTimeAttrib) {
                            SimpleTimeAttrib simpleTimeAttrib = (SimpleTimeAttrib)abstractAttribImpl;
                            string = simpleTimeAttrib.isDate() ? I18N.tr("date") : (simpleTimeAttrib.isTime() ? I18N.tr("time") : I18N.tr("date") + "+" + I18N.tr("time"));
                        }
                        if (StringUtils.isBlank((CharSequence)string)) {
                            string = "[ " + I18N.tr("unknown") + " ]";
                        }
                        return new ValueInfo("<html><i>" + string + "</i></html>", abstractAttribImpl.isCountrySpecific());
                    }
                }
                return null;
            }
            return null;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean isEditable(int n) {
            return this.nodeType == 3 && n == 1;
        }
    }

    private static class Model
    extends DefaultTreeTable.Model {
        public static final int COL_NAME = 0;
        public static final int COL_VALUE = 1;
        public static final int COL_TYPE = 2;
        private final Node rootNode = (Node)this.getRoot();

        public Model() {
            super((TreeTableNode)new Node());
        }

        public Object getChild(Object object, int n) {
            Node node = (Node)((Object)object);
            return node.getChildAt(n);
        }

        public int getChildCount(Object object) {
            Node node = (Node)((Object)object);
            return node.getChildCount();
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 2: {
                    return ValueInfo.class;
                }
                case 1: {
                    return AbstractAttribImpl.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return StringUtils.capitalize((String)I18N.tr("attribute"));
                }
                case 2: {
                    return StringUtils.capitalize((String)I18N.tr("type"));
                }
                case 1: {
                    return StringUtils.capitalize((String)I18N.tr("value"));
                }
            }
            return null;
        }

        public int getIndexOfChild(Object object, Object object2) {
            Node node = (Node)((Object)object);
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (node.getChildAt(i) != object2) continue;
                return i;
            }
            return -1;
        }

        public Node getRootNode() {
            return this.rootNode;
        }

        public Object getValueAt(Object object, int n) {
            Node node = (Node)((Object)object);
            return node.getValueAt(n);
        }

        public boolean isCellEditable(Object object, int n) {
            Node node = (Node)((Object)object);
            return node.isEditable(n);
        }
    }
}

