/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.DbContact;
import com.openindex.openestate.impl.utils.Translatable;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyContactAddressPanel;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyContact;
import com.openindex.openestate.tool.agency.db.DbAgencyContactsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.agency.gui.AgencyContactRenderer;
import com.openindex.openestate.tool.db.DbUser;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import com.openindex.openestate.tool.utils.DisposableComponent;
import com.openindex.openestate.tool.utils.forms.ModificationHandler;
import com.openindex.openestate.tool.utils.forms.ValidationHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import net.java.balloontip.BalloonTip;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewContactPanel
extends AgencyEstateViewPanel.AbstractTab
implements DisposableComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewContactPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewContactPanel.class);
    private WeakReference<DbAgencyObject> currentObject = null;
    private ValidationHandler validationHandler;
    private ModificationHandler modifications;
    private JXTitledSeparator formTitle;
    private JLabel contactLabel;
    private JComboBox<DbAgencyContact> contactField;
    private JComboBox<ContactType> contactTypeField;
    private AgencyContactAddressPanel addressPanel;
    private DbAgencyContact unreadableContact = null;
    private BalloonTip unreadableContactBalloonTip;
    private JLabel unreadableContactBalloonLabel;

    public AgencyEstateViewContactPanel() {
        this.build();
    }

    private void build() {
        this.validationHandler = ImmoToolUtils.createValidationHandler();
        this.modifications = ImmoToolUtils.createModificationHandler();
        this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.contactLabel = new JLabel();
        this.contactField = new JComboBox();
        this.contactField.setRenderer((ListCellRenderer<DbAgencyContact>)new DefaultListCellRenderer((Renderer)new AgencyContactRenderer(){

            public String getEmptyText() {
                return "[ " + I18N.tr("select contact person") + " ]";
            }
        }));
        this.contactField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewContactPanel.this.contactField.isEnabled()) {
                    return;
                }
                AgencyEstateViewContactPanel.this.updateContact();
            }
        });
        this.contactTypeField = new JComboBox();
        this.contactTypeField.setRenderer((ListCellRenderer<ContactType>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer()));
        for (ContactType contactType : ContactType.values()) {
            this.contactTypeField.addItem(contactType);
        }
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT)) {
            this.contactTypeField.removeItem((Object)ContactType.NEW_CONTACT);
        }
        this.contactTypeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyEstateViewContactPanel.this.contactTypeField.isEnabled()) {
                    return;
                }
                AgencyEstateViewContactPanel.this.updateContact();
            }
        });
        this.addressPanel = new AgencyContactAddressPanel(60);
        this.unreadableContactBalloonLabel = new JLabel();
        this.unreadableContactBalloonLabel.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
        this.unreadableContactBalloonTip = new BalloonTip(this.contactField, (JComponent)this.unreadableContactBalloonLabel, ImmoToolUtils.createBalloonTipStyle(), BalloonTip.Orientation.LEFT_BELOW, BalloonTip.AttachLocation.ALIGNED, 10, 10, false);
        this.unreadableContactBalloonTip.setVisible(false);
        this.validationHandler.putRule(this.contactField, ValidationHandler.NOT_BLANK);
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:[60dlu,pref], 3dlu, [50dlu,pref], 3dlu, 50dlu:grow");
        defaultFormBuilder.border((Border)Paddings.DIALOG);
        defaultFormBuilder.add((Component)this.formTitle).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)this.contactLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add(this.contactTypeField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add(this.contactField).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)new JLabel("")).xyw(1, defaultFormBuilder.nextRow(), 5);
        defaultFormBuilder.add((Component)((Object)this.addressPanel)).xyw(1, defaultFormBuilder.nextRow(), 5);
        JScrollPane jScrollPane = new JScrollPane(defaultFormBuilder.getPanel());
        jScrollPane.setBorder(Paddings.EMPTY);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.setLayout(new BorderLayout());
        this.setBorder(Paddings.EMPTY);
        this.add(jScrollPane, "Center");
        this.addressPanel.setEnabled(false);
        this.updateLocalization();
        this.updateContact();
    }

    public void dispose() {
        if (this.unreadableContactBalloonTip != null) {
            this.unreadableContactBalloonTip.closeBalloon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        int n;
        DbAgencyContactsHandler dbAgencyContactsHandler;
        this.contactTypeField.setEnabled(false);
        this.contactField.setEnabled(false);
        this.contactField.removeAllItems();
        DefaultComboBoxModel<DbAgencyContact> defaultComboBoxModel = new DefaultComboBoxModel<DbAgencyContact>();
        defaultComboBoxModel.addElement(null);
        try {
            dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
            DbContact[] dbContactArray = dbAgencyContactsHandler.getContacts(connection);
            n = dbContactArray.length;
            for (int i = 0; i < n; ++i) {
                DbContact dbContact = dbContactArray[i];
                defaultComboBoxModel.addElement((DbAgencyContact)dbContact);
            }
            this.contactTypeField.setEnabled(true);
            this.contactField.setModel(defaultComboBoxModel);
            this.contactField.setSelectedItem(null);
            Object object = dbAgencyContactsHandler = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
        }
        catch (Throwable throwable) {
            DbAgencyObject dbAgencyObject;
            this.contactTypeField.setEnabled(true);
            this.contactField.setModel(defaultComboBoxModel);
            this.contactField.setSelectedItem(null);
            DbAgencyObject dbAgencyObject2 = dbAgencyObject = this.currentObject != null ? (DbAgencyObject)((Object)this.currentObject.get()) : null;
            if (dbAgencyObject == null || dbAgencyObject.contactId < 1L) {
                this.contactTypeField.setSelectedItem((Object)ContactType.NO_CONTACT);
            } else {
                boolean bl = true;
                this.contactTypeField.setSelectedItem((Object)ContactType.USE_CONTACT);
                for (int i = 0; i < this.contactField.getItemCount(); ++i) {
                    DbAgencyContact dbAgencyContact = this.contactField.getItemAt(i);
                    if (dbAgencyContact == null || dbAgencyContact.id != dbAgencyObject.contactId) continue;
                    bl = false;
                    this.contactField.setSelectedIndex(i);
                    break;
                }
                if (bl) {
                    this.unreadableContact = new DbAgencyContact();
                    this.unreadableContact.id = dbAgencyObject.contactId;
                    this.unreadableContact.item.setPersonLastName(I18N.tr("unknown"));
                    this.contactField.addItem(this.unreadableContact);
                    this.contactField.setSelectedIndex(this.contactField.getItemCount() - 1);
                }
            }
            this.updateContact();
            this.validationHandler.validate();
            this.modifications.clear();
            this.modifications.putValue(this.contactTypeField);
            if (ContactType.USE_CONTACT.equals((Object)this.getContactType())) {
                this.modifications.putValue(this.contactField);
            }
            throw throwable;
        }
        if (dbAgencyContactsHandler == null || ((DbAgencyObject)((Object)dbAgencyContactsHandler)).contactId < 1L) {
            this.contactTypeField.setSelectedItem((Object)ContactType.NO_CONTACT);
        } else {
            boolean bl = true;
            this.contactTypeField.setSelectedItem((Object)ContactType.USE_CONTACT);
            for (n = 0; n < this.contactField.getItemCount(); ++n) {
                DbAgencyContact dbAgencyContact = this.contactField.getItemAt(n);
                if (dbAgencyContact == null || dbAgencyContact.id != ((DbAgencyObject)((Object)dbAgencyContactsHandler)).contactId) continue;
                bl = false;
                this.contactField.setSelectedIndex(n);
                break;
            }
            if (bl) {
                this.unreadableContact = new DbAgencyContact();
                this.unreadableContact.id = ((DbAgencyObject)((Object)dbAgencyContactsHandler)).contactId;
                this.unreadableContact.item.setPersonLastName(I18N.tr("unknown"));
                this.contactField.addItem(this.unreadableContact);
                this.contactField.setSelectedIndex(this.contactField.getItemCount() - 1);
            }
        }
        this.updateContact();
        this.validationHandler.validate();
        this.modifications.clear();
        this.modifications.putValue(this.contactTypeField);
        if (ContactType.USE_CONTACT.equals((Object)this.getContactType())) {
            this.modifications.putValue(this.contactField);
        }
    }

    private ContactType getContactType() {
        return (ContactType)((Object)this.contactTypeField.getSelectedItem());
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("contact person"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public boolean isTabModified() {
        if (this.modifications.isModified()) {
            return true;
        }
        return ContactType.USE_CONTACT.equals((Object)this.getContactType()) && this.addressPanel.isModifiedInput();
    }

    public boolean isTabValid() {
        this.validationHandler.validate();
        this.addressPanel.validateInputs();
        return this.validationHandler.isValid() && this.addressPanel.isValidInput() && this.getContactType() != null;
    }

    @Override
    public void load(DbAgencyObject dbAgencyObject) {
        this.currentObject = new WeakReference<DbAgencyObject>(dbAgencyObject);
        this.unreadableContact = null;
        if (this.unreadableContactBalloonTip.isVisible()) {
            this.unreadableContactBalloonTip.setVisible(false);
        }
    }

    @Override
    public void save(DbAgencyObject dbAgencyObject) {
        ContactType contactType = this.getContactType();
        if (ContactType.NO_CONTACT.equals((Object)contactType)) {
            dbAgencyObject.contactId = 0L;
            dbAgencyObject.item.setContactId(null);
        } else if (ContactType.USE_CONTACT.equals((Object)contactType) && this.contactField.getSelectedIndex() > 0) {
            DbAgencyContact dbAgencyContact = (DbAgencyContact)((Object)this.contactField.getSelectedItem());
            if (dbAgencyContact != null && (this.unreadableContact == null || this.unreadableContact.id != dbAgencyContact.id)) {
                dbAgencyObject.contactId = dbAgencyContact.id;
                dbAgencyObject.item.setContactId(String.valueOf(dbAgencyContact.id));
            }
        } else if (ContactType.NEW_CONTACT.equals((Object)contactType)) {
            dbAgencyObject.contactId = 0L;
            dbAgencyObject.item.setContactId(null);
        }
    }

    @Override
    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException {
        DbAgencyContact dbAgencyContact;
        if (!AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT)) {
            return;
        }
        ContactType contactType = this.getContactType();
        DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
        DbAgencyContactsHandler dbAgencyContactsHandler = AgencyPlugin.getDbAgencyExtension().getContactsHandler();
        if (ContactType.NEW_CONTACT.equals((Object)contactType)) {
            DbAgencyContact dbAgencyContact2 = new DbAgencyContact();
            dbAgencyContact2.ownerGroupId = dbAgencyObject.ownerGroupId;
            dbAgencyContact2.ownerUserId = dbAgencyObject.ownerUserId;
            dbAgencyContact2.permission = dbAgencyObject.permission;
            this.addressPanel.save(dbAgencyContact2);
            dbAgencyContactsHandler.saveContact(connection, dbAgencyContact2);
            dbAgencyObject.contactId = dbAgencyContact2.id;
            dbAgencyObject.item.setContactId(String.valueOf(dbAgencyContact2.id));
            dbAgencyObjectsHandler.saveObject(connection, dbAgencyObject);
        } else if (ContactType.USE_CONTACT.equals((Object)contactType) && this.addressPanel.isModifiedInput() && (dbAgencyContact = (DbAgencyContact)((Object)this.contactField.getSelectedItem())) != null && (this.unreadableContact == null || this.unreadableContact.id != dbAgencyContact.id)) {
            this.addressPanel.save(dbAgencyContact);
            dbAgencyContactsHandler.saveContact(connection, dbAgencyContact);
        }
    }

    private void updateContact() {
        ContactType contactType = this.getContactType();
        if (this.unreadableContactBalloonTip.isVisible()) {
            this.unreadableContactBalloonTip.setVisible(false);
        }
        if (ContactType.NO_CONTACT.equals((Object)contactType)) {
            this.contactField.setEnabled(false);
            this.addressPanel.setEnabled(false);
            this.addressPanel.load(null);
        } else if (ContactType.NEW_CONTACT.equals((Object)contactType)) {
            this.contactField.setEnabled(false);
            this.addressPanel.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT));
            this.addressPanel.load(null);
        } else if (ContactType.USE_CONTACT.equals((Object)contactType)) {
            boolean bl;
            DbAgencyContact dbAgencyContact = (DbAgencyContact)((Object)this.contactField.getSelectedItem());
            this.contactField.setEnabled(AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS));
            boolean bl2 = bl = dbAgencyContact != null && AgencyPlugin.isUserAllowedTo(AgencyPermission.CONTACTS_EDIT);
            if (dbAgencyContact != null && this.unreadableContact != null && this.unreadableContact.id == dbAgencyContact.id) {
                bl = false;
                if (!this.unreadableContactBalloonTip.isVisible()) {
                    this.unreadableContactBalloonTip.setVisible(true);
                }
            } else if (dbAgencyContact != null && dbAgencyContact.permission != null) {
                DbUser dbUser = ImmoToolProject.getAppUser();
                bl = bl && dbAgencyContact.permission.canWrite(dbUser, dbAgencyContact.ownerUserId, dbAgencyContact.ownerGroupId);
            }
            this.addressPanel.setEnabled(bl);
            this.addressPanel.load(dbAgencyContact);
        }
        this.addressPanel.initInputs();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.formTitle.setTitle(StringUtils.capitalize((String)I18N.tr("contact person for the property")));
        this.contactLabel.setText(StringUtils.capitalize((String)I18N.tr("contact person")) + ":");
        this.unreadableContactBalloonLabel.setText(I18N.tr("The assigned contact person is not readable by your user account."));
    }

    private static enum ContactType implements Translatable
    {
        NO_CONTACT(I18n.marktr((String)"no contact person")),
        NEW_CONTACT(I18n.marktr((String)"new contact person")),
        USE_CONTACT(I18n.marktr((String)"select contact person"));

        private final String i18nKey;

        private ContactType(String string2) {
            this.i18nKey = string2;
        }

        public String getTranslation() {
            return ImmoToolUtils.getI18nString(AgencyEstateViewContactPanel.class, (String)this.i18nKey);
        }

        public String getTranslation(Locale locale) {
            return ImmoToolUtils.getI18nString(AgencyEstateViewContactPanel.class, (String)this.i18nKey, (Locale)locale);
        }
    }
}

