/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyExportLogPanel;
import com.openindex.openestate.tool.agency.AgencyExportLogTable;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.db.DbAgencyExportLog;
import com.openindex.openestate.tool.agency.db.DbAgencyExportsHandler;
import com.openindex.openestate.tool.gui.AbstractPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.JSplitPane;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportLogsPanel
extends AbstractPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportLogsPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportLogsPanel.class);
    private final String tableId;
    private ViewTask viewTask = null;
    private long currentLogId = 0L;
    private JSplitPane splitPane;
    private LogsPanel logsPanel;
    private AgencyExportLogPanel logPanel;
    private boolean showExportTitleCol;

    public AgencyExportLogsPanel(String string) {
        this(string, true);
    }

    public AgencyExportLogsPanel(String string, boolean bl) {
        this.tableId = string;
        this.showExportTitleCol = bl;
        this.build();
    }

    public void addExportLog(DbAgencyExportLog dbAgencyExportLog, String string) {
        if (dbAgencyExportLog != null) {
            this.logsPanel.table.addRow(new AgencyExportLogTable.Row(dbAgencyExportLog, string));
        }
    }

    private void build() {
        this.logsPanel = new LogsPanel();
        this.logPanel = new AgencyExportLogPanel();
        this.logPanel.setVisible(false);
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(Paddings.EMPTY);
        this.splitPane.setTopComponent((Component)((Object)this.logsPanel));
        this.splitPane.setBottomComponent((Component)((Object)this.logPanel));
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.splitPane, "Center");
    }

    public void clearExportLogs() {
        this.currentLogId = 0L;
        this.logPanel.setVisible(false);
        this.logsPanel.table.clearRows();
    }

    private void doViewSelectedLog() {
        if (this.viewTask != null) {
            return;
        }
        int n = this.logsPanel.table.getSelectedRow();
        if (n < 0) {
            this.logPanel.setVisible(false);
            return;
        }
        n = this.logsPanel.table.convertRowIndexToModel(n);
        String string = this.logsPanel.table.getExportNameAt(n);
        long l = this.logsPanel.table.getLogIdAt(n);
        if (this.currentLogId == l) {
            this.logPanel.setVisible(true);
            return;
        }
        this.viewTask = new ViewTask(l, string);
        ImmoToolEnvironment.executeTask((ImmoToolTask)this.viewTask);
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.logsPanel.updateTitle();
    }

    private class ViewTask
    extends ImmoToolTask<DbAgencyExportLog, Void> {
        private final long logId;
        private final String exportName;

        private ViewTask(long l, String string) {
            this.logId = l;
            this.exportName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DbAgencyExportLog doInBackground() throws Exception {
            DbAgencyExportsHandler dbAgencyExportsHandler = AgencyPlugin.getDbAgencyExtension().getExportsHandler();
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppDbConnection();
                DbAgencyExportLog dbAgencyExportLog = dbAgencyExportsHandler.getExportLog(connection, this.logId);
                dbAgencyExportsHandler.loadExportLogEntries(connection, dbAgencyExportLog);
                dbAgencyExportsHandler.loadExportLogMessages(connection, dbAgencyExportLog);
                DbAgencyExportLog dbAgencyExportLog2 = dbAgencyExportLog;
                return dbAgencyExportLog2;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            AgencyExportLogsPanel.this.logPanel.setVisible(false);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load export log!", (Throwable)throwable);
        }

        protected void finished() {
            super.finished();
            AgencyExportLogsPanel.this.viewTask = null;
        }

        protected void succeeded(DbAgencyExportLog dbAgencyExportLog) {
            super.succeeded((Object)dbAgencyExportLog);
            AgencyExportLogsPanel.this.logPanel.setLog(dbAgencyExportLog, this.exportName);
            AgencyExportLogsPanel.this.logPanel.setVisible(true);
            AgencyExportLogsPanel.this.splitPane.setDividerLocation(0.4);
        }
    }

    private class Table
    extends AgencyExportLogTable<AgencyExportLogTable.Row> {
        public Table(String string) {
            super(string);
        }

        protected void doSelect() {
            AgencyExportLogsPanel.this.doViewSelectedLog();
        }

        @Override
        protected void init() {
            TableColumnExt tableColumnExt;
            super.init();
            this.setSortOrder(AgencyExportLogTable.Column.TIME.getColumnId(), SortOrder.DESCENDING);
            if (!AgencyExportLogsPanel.this.showExportTitleCol && (tableColumnExt = this.getColumnById(AgencyExportLogTable.Column.TITLE.getColumnId())) != null) {
                tableColumnExt.setVisible(false);
            }
        }
    }

    private class LogsPanel
    extends AbstractPanel {
        private JXTitledSeparator title;
        private Table table;

        private LogsPanel() {
            this.build();
        }

        private void build() {
            this.title = ImmoToolUtils.createHead2Separator((String)"");
            this.table = new Table(AgencyExportLogsPanel.this.tableId);
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)this.title, "North");
            this.add(this.table.createScrollPane(), "Center");
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.updateTitle();
        }

        private void updateTitle() {
            int n;
            String string = StringUtils.capitalize((String)I18N.tr("history of property exports"));
            int n2 = n = this.table != null ? this.table.getRowCount() : 0;
            if (n > 0) {
                string = string + " / ";
                string = string + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.title.setTitle(string);
        }
    }
}

