/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.agency.AgencyExportHandler;
import com.openindex.openestate.tool.agency.db.DbAgencyExport;
import com.openindex.openestate.tool.agency.export.AbstractFormat;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.StringRenderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyExportTable<R extends Row>
extends AbstractTable<R, AbstractTable.Model<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyExportTable.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyExportTable.class);

    public AgencyExportTable(String string) {
        super(string);
    }

    public AgencyExportTable(String string, AbstractTable.Model<R> model) {
        super(string, model);
    }

    public Long getExportIdAt(int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        return dbAgencyExport != null ? Long.valueOf(dbAgencyExport.id) : null;
    }

    public DbAgencyExport getExportAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getExport() : null;
    }

    public AgencyExportHandler.JobState getJobStateAt(int n) {
        Row row = (Row)this.getModel().getRow(n);
        return row != null ? row.getState() : null;
    }

    public Date getLastExportDateAt(int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        return dbAgencyExport != null ? dbAgencyExport.lastExecution : null;
    }

    public int getRowForExportId(long l) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Long l2 = this.getExportIdAt(i);
            if (l != l2) continue;
            return i;
        }
        return -1;
    }

    protected void init() {
        this.setSortable(true);
        this.setColumnControlVisible(true);
        super.init();
        this.getColumnById(Column.JOB.getColumnId()).setCellRenderer((TableCellRenderer)((Object)new JobRenderer()));
    }

    public boolean isExportEnabledAt(int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        return dbAgencyExport != null && dbAgencyExport.enabled;
    }

    protected List<AbstractTable.Column> listColumns() {
        return new ArrayList<AbstractTable.Column>(Arrays.asList(Column.values()));
    }

    public void setExportEnabledAt(boolean bl, int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        if (dbAgencyExport != null) {
            dbAgencyExport.enabled = bl;
        }
    }

    public void setJobStateAt(AgencyExportHandler.JobState jobState, int n) {
        Row row = (Row)this.getModel().getRow(n);
        if (row != null) {
            row.setState(jobState);
        }
    }

    public void setLastExportDateAt(Date date, int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        if (dbAgencyExport != null) {
            dbAgencyExport.lastExecution = date;
        }
    }

    public void setModeAt(AbstractFormat.TransferMode transferMode, int n) {
        DbAgencyExport dbAgencyExport = this.getExportAt(n);
        if (dbAgencyExport != null) {
            dbAgencyExport.transferMode = transferMode;
        }
    }

    private class JobRenderer
    extends DefaultTableCellRenderer<AgencyExportHandler.JobState> {
        private final Color orange = Color.ORANGE.darker().darker();
        private final Color green = Color.GREEN.darker().darker();
        private final JProgressBar unboundedProgressBar;
        private final JProgressBar boundedProgressBar;

        private JobRenderer() {
            this.setFont(this.getFont().deriveFont(1));
            this.unboundedProgressBar = new JProgressBar(){

                @Override
                public boolean isDisplayable() {
                    return true;
                }

                @Override
                public void repaint() {
                    AgencyExportTable.this.repaint();
                }
            };
            this.unboundedProgressBar.setStringPainted(true);
            this.unboundedProgressBar.setBorderPainted(false);
            this.unboundedProgressBar.setIndeterminate(true);
            this.boundedProgressBar = new JProgressBar();
            this.boundedProgressBar.setStringPainted(true);
            this.boundedProgressBar.setBorderPainted(false);
            this.boundedProgressBar.setIndeterminate(false);
            this.boundedProgressBar.setMinimum(0);
            this.boundedProgressBar.setMaximum(100);
        }

        public Component getRenderedComponent(JTable jTable, AgencyExportHandler.JobState jobState, boolean bl, boolean bl2, int n, int n2) {
            AgencyExportTable agencyExportTable = (AgencyExportTable)((Object)jTable);
            int n3 = agencyExportTable.convertRowIndexToModel(n);
            long l = agencyExportTable.getExportIdAt(n3);
            AgencyExportHandler.Job job = AgencyExportHandler.getExportJob(l);
            if (AgencyExportHandler.JobState.PREPARATION_RUNNING.equals((Object)jobState)) {
                this.unboundedProgressBar.setString(AgencyExportHandler.JobState.PREPARATION_RUNNING.getTranslation());
                return this.unboundedProgressBar;
            }
            if (AgencyExportHandler.JobState.FINISHING.equals((Object)jobState)) {
                this.unboundedProgressBar.setString(AgencyExportHandler.JobState.FINISHING.getTranslation());
                return this.unboundedProgressBar;
            }
            if (AgencyExportHandler.JobState.TRANSPORT_RUNNING.equals((Object)jobState)) {
                this.boundedProgressBar.setString(StringUtils.trimToEmpty((String)job.getMessage()));
                this.boundedProgressBar.setValue(job.getProgress());
                return this.boundedProgressBar;
            }
            JLabel jLabel = (JLabel)super.getRenderedComponent(jTable, (Object)jobState, bl, bl2, n, n2);
            if (AgencyExportHandler.JobState.FINISHED.equals((Object)jobState)) {
                int n4;
                NumberFormat numberFormat = NumberFormat.getIntegerInstance();
                ArrayList<String> arrayList = new ArrayList<String>();
                if (job.getCountErrors() > 0) {
                    n4 = job.getCountErrors();
                    arrayList.add(I18N.trn("{0} error", "{0} errors", (long)n4, (Object)numberFormat.format(n4)));
                }
                if (job.getCountWarnings() > 0) {
                    n4 = job.getCountWarnings();
                    arrayList.add(I18N.trn("{0} warning", "{0} warnings", (long)n4, (Object)numberFormat.format(n4)));
                }
                if (job.getCountNotices() > 0) {
                    n4 = job.getCountNotices();
                    arrayList.add(I18N.trn("{0} notice", "{0} notices", (long)n4, (Object)numberFormat.format(n4)));
                }
                if (!arrayList.isEmpty()) {
                    jLabel.setText(this.getText() + " (" + StringUtils.join(arrayList, (String)", ") + ")");
                    jLabel.setForeground(this.orange);
                }
            }
            return jLabel;
        }

        protected void initValue(AgencyExportHandler.JobState jobState) {
            this.setText(jobState != null ? jobState.getTranslation() : "");
            if (AgencyExportHandler.JobState.FINISHED.equals((Object)jobState)) {
                this.setIcon(ImmoToolEnvironment.getResourceIcon((String)"button_ok.png", (int)16));
                this.setForeground(this.green);
            } else if (AgencyExportHandler.JobState.PREPARATION_CANCELLED.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_CANCELLED.equals((Object)jobState)) {
                this.setIcon(ImmoToolEnvironment.getResourceIcon((String)"button_cancel.png", (int)16));
                this.setForeground(Color.DARK_GRAY);
            } else if (AgencyExportHandler.JobState.FINISHING_ERROR.equals((Object)jobState) || AgencyExportHandler.JobState.PREPARATION_ERROR.equals((Object)jobState) || AgencyExportHandler.JobState.TRANSPORT_ERROR.equals((Object)jobState)) {
                this.setIcon(ImmoToolEnvironment.getResourceIcon((String)"warning.png", (int)16));
                this.setForeground(Color.RED);
            } else if (AgencyExportHandler.JobState.LOCKED.equals((Object)jobState)) {
                this.setIcon(ImmoToolEnvironment.getResourceIcon((String)"lock.png", (int)16));
                this.setForeground(Color.RED);
            } else if (jobState != null) {
                this.setIcon(ImmoToolEnvironment.getResourceIcon((String)"info.png", (int)16));
                this.setForeground(Color.BLACK);
            } else {
                this.setIcon(null);
            }
        }
    }

    public static class Row
    extends AbstractTable.Row {
        private final DbAgencyExport export;
        private AgencyExportHandler.JobState state;

        public Row(DbAgencyExport dbAgencyExport) {
            this.export = dbAgencyExport;
            this.state = !dbAgencyExport.isLockedByAnotherProcess() ? AgencyExportHandler.getExportJobState(dbAgencyExport.id) : AgencyExportHandler.JobState.LOCKED;
        }

        public DbAgencyExport getExport() {
            return this.export;
        }

        public AgencyExportHandler.JobState getState() {
            return this.state;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof Column) {
                return this.getValueForExport((Column)column);
            }
            return null;
        }

        public Object getValueForExport(Column column) {
            if (this.export == null) {
                return null;
            }
            switch (column) {
                case ID: {
                    return this.export.id;
                }
                case LAST_EXPORT_DATE: {
                    return this.export.lastExecution;
                }
                case TITLE: {
                    return StringUtils.defaultIfBlank((CharSequence)this.export.name, (CharSequence)("#" + this.export.id));
                }
                case ENABLED: {
                    return this.export.enabled;
                }
                case MODE: {
                    return this.export.transferMode;
                }
                case JOB: {
                    return this.state;
                }
            }
            return null;
        }

        public void setState(AgencyExportHandler.JobState jobState) {
            this.state = jobState;
        }
    }

    public static enum Column implements AbstractTable.Column
    {
        ID,
        TITLE,
        MODE,
        LAST_EXPORT_DATE,
        JOB,
        ENABLED;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case TITLE: {
                    return new DefaultTableCellRenderer<String>((Renderer)new StringRenderer()){

                        public Component getRenderedComponent(JTable jTable, String string, boolean bl, boolean bl2, int n, int n2) {
                            AgencyExportTable agencyExportTable = (AgencyExportTable)((Object)jTable);
                            Component component = super.getRenderedComponent(jTable, (Object)string, bl, bl2, n, n2);
                            component.setEnabled(agencyExportTable.isExportEnabledAt(agencyExportTable.convertRowIndexToModel(n)));
                            return component;
                        }
                    };
                }
                case MODE: {
                    return new DefaultTableCellRenderer<AbstractFormat.TransferMode>((Renderer)new TranslatableRenderer()){

                        public Component getRenderedComponent(JTable jTable, AbstractFormat.TransferMode transferMode, boolean bl, boolean bl2, int n, int n2) {
                            AgencyExportTable agencyExportTable = (AgencyExportTable)((Object)jTable);
                            Component component = super.getRenderedComponent(jTable, (Object)transferMode, bl, bl2, n, n2);
                            component.setEnabled(agencyExportTable.isExportEnabledAt(agencyExportTable.convertRowIndexToModel(n)));
                            return component;
                        }
                    };
                }
                case LAST_EXPORT_DATE: {
                    return new DefaultTableCellRenderer<Date>((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(2, 3))){

                        public Component getRenderedComponent(JTable jTable, Date date, boolean bl, boolean bl2, int n, int n2) {
                            AgencyExportTable agencyExportTable = (AgencyExportTable)((Object)jTable);
                            Component component = super.getRenderedComponent(jTable, (Object)date, bl, bl2, n, n2);
                            component.setEnabled(agencyExportTable.isExportEnabledAt(agencyExportTable.convertRowIndexToModel(n)));
                            return component;
                        }
                    };
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case ID: {
                    return Long.class;
                }
                case ENABLED: {
                    return Boolean.class;
                }
                case JOB: {
                    return AgencyExportHandler.JobState.class;
                }
                case MODE: {
                    return AbstractFormat.TransferMode.class;
                }
                case TITLE: {
                    return String.class;
                }
                case LAST_EXPORT_DATE: {
                    return Date.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case ID: {
                    return I18N.tr("ID");
                }
                case ENABLED: {
                    return I18N.tr("active");
                }
                case MODE: {
                    return StringUtils.capitalize((String)I18N.tr("mode"));
                }
                case TITLE: {
                    return StringUtils.capitalize((String)I18N.tr("interface"));
                }
                case JOB: {
                    return StringUtils.capitalize((String)I18N.tr("current transfer"));
                }
                case LAST_EXPORT_DATE: {
                    return StringUtils.capitalize((String)I18N.tr("last export"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                case ID: 
                case ENABLED: {
                    return false;
                }
            }
            return true;
        }
    }
}

